# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2019-01-18 17:18
from __future__ import unicode_literals

import django.db.models.deletion
import jsonfield.fields
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):

    initial = True

    dependencies = [("kolibriauth", "0001_initial")]

    operations = [
        migrations.CreateModel(
            name="PingbackNotification",
            fields=[
                (
                    "id",
                    models.CharField(max_length=50, primary_key=True, serialize=False),
                ),
                ("version_range", models.CharField(max_length=50)),
                ("timestamp", models.DateField()),
                ("link_url", models.CharField(blank=True, max_length=150)),
                ("i18n", jsonfield.fields.JSONField(default={})),
                ("active", models.BooleanField(default=True)),
                (
                    "source",
                    models.CharField(
                        choices=[
                            ("pingback", "Pingback"),
                            ("statistics", "Statistics"),
                        ],
                        max_length=20,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PingbackNotificationDismissed",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "notification",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="analytics.PingbackNotification",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="kolibriauth.FacilityUser",
                    ),
                ),
            ],
        ),
        migrations.AlterUniqueTogether(
            name="pingbacknotificationdismissed",
            unique_together=set([("user", "notification")]),
        ),
    ]
