import os
import getpass
import logging
import subprocess


from concreate.errors import ConcreateError

logger = logging.getLogger('concreate')


class TestRunner(object):
    def __init__(self, target):
        """Check if behave and docker is installed properly"""
        self.target = os.path.abspath(target)
        try:
            subprocess.check_output(['behave', '--version'], stderr=subprocess.STDOUT)
        except subprocess.CalledProcessError as ex:
            raise ConcreateError("Test Runner needs 'behave' installed, '%s'" %
                                 ex.output)
        except Exception as ex:
            raise ConcreateError(
                "Test Runner needs behave installed!", ex)

    def run(self, image_tag, run_tags):
        """Run test suite"""
        cmd = ['behave',
               '--junit',
               '--junit-directory', 'results',
               '-t', '~ignore',
               '--no-skipped',
               '-D', 'IMAGE=%s' % image_tag]

        for tag in run_tags:
            if ':' in image_tag:
                image_tag = image_tag.split(':')[0]

            cmd.append('-t')
            if '/' in tag:
                cmd.append("@%s,@%s" % (image_tag.split('/')[0], image_tag))
            else:
                cmd.append(tag)

        # Check if we're running runtests on CI or locally
        # If we run tests locally - skip all features that
        # are marked with the @ci annotation
        if getpass.getuser() != "jenkins":
            cmd.append("-t")
            cmd.append("~ci ")

        logger.debug("Running '%s'" % ' '.join(cmd))
        try:
            subprocess.check_call(cmd, stderr=subprocess.STDOUT, cwd=os.path.join(self.target, 'test'))
        except:
            logger.error("Test execution failed, please consult output above")
