"""
lexer.tokens.py
===============

Description
-----------
Vtl Token centralized.
"""

# General
PASSIGN = "<-"
ASSIGN = ":="
MEMBERSHIP = "#"
LPAREN = "("
RLPAREN = ")"
COMMA = ","
COLON = ":"
SCOLON = ";"
# Numeric operators.
PLUS = "+"
MINUS = "-"
MULT = "*"
DIV = "/"
MOD = "mod"
ROUND = "round"
TRUNC = "trunc"
CEIL = "ceil"
FLOOR = "floor"
ABS = "abs"
EXP = "exp"
LN = "ln"
POWER = "power"
LOG = "log"
SQRT = "sqrt"
RANDOM = "random"
# Boolean operators.
AND = "and"
OR = "or"
XOR = "xor"
NOT = "not"
# Comparison operators.
EQ = "="
NEQ = "<>"
GT = ">"
GTE = ">="
LT = "<"
LTE = "<="
BETWEEN = "between"
IN = "in"
NOT_IN = "not_in"
CHARSET_MATCH = "match_characters"
ISNULL = "isnull"
EXISTS_IN = "exists_in"
# String operators.
CONCAT = "||"
TRIM = "trim"
RTRIM = "rtrim"
LTRIM = "ltrim"
UCASE = "upper"
LCASE = "lower"
SUBSTR = "substr"
REPLACE = "replace"
INSTR = "instr"
LEN = "length"
# Set operators.
UNION = "union"
INTERSECT = "intersect"
SETDIFF = "setdiff"
SYMDIFF = "symdiff"
# Conditional Operators.
IF = "if"
THEN = "then"
ELSE = "else"
CASE = "case"
NVL = "nvl"
# Clause Operators.
FILTER = "filter"
CALC = "calc"
AGGREGATE = "aggr"
KEEP = "keep"
DROP = "drop"
RENAME = "rename"
PIVOT = "pivot"
UNPIVOT = "unpivot"
SUBSPACE = "sub"
# Time Operators.
PERIOD_INDICATOR = "period_indicator"
FILL_TIME_SERIES = "fill_time_series"
FLOW_TO_STOCK = "flow_to_stock"
STOCK_TO_FLOW = "stock_to_flow"
TIMESHIFT = "timeshift"
TIME_AGG = "time_agg"
CURRENT_DATE = "current_date"
DATEDIFF = "datediff"
DATE_ADD = "dateadd"
YEAR = "year"
MONTH = "month"
DAYOFMONTH = "dayofmonth"
DAYOFYEAR = "dayofyear"
DAYTOYEAR = "daytoyear"
DAYTOMONTH = "daytomonth"
YEARTODAY = "yeartoday"
MONTHTODAY = "monthtoday"
# Join Operators.
INNER_JOIN = "inner_join"
LEFT_JOIN = "left_join"
CROSS_JOIN = "cross_join"
FULL_JOIN = "full_join"
# Hierarchical aggregation.
HIERARCHY = "hierarchy"
# Aggregate and analytic Operators.
COUNT = "count"
MIN = "min"
MAX = "max"
MEDIAN = "median"
SUM = "sum"
AVG = "avg"
STDDEV_POP = "stddev_pop"
STDDEV_SAMP = "stddev_samp"
VAR_POP = "var_pop"
VAR_SAMP = "var_samp"
FIRST_VALUE = "first_value"
LAST_VALUE = "last_value"
LAG = "lag"
LEAD = "lead"
RANK = "rank"
RATIO_TO_REPORT = "ratio_to_report"
# Data validation Operators.
CHECK_DATAPOINT = "check_datapoint"
CHECK_HIERARCHY = "check_hierarchy"
CHECK = "check"
# Role Operators.
IDENTIFIER = "identifier"
MEASURE = "measure"
ATTRIBUTE = "attribute"
VIRAL_ATTRIBUTE = "viral"
# Other Operators.
TO = "to"
AS = "as"
USING = "using"
OPTIONAL = "_"
HAVING = "having"
WHEN = "when"
# Helping Tokens
GROUP_BY = "group by"
GROUP_EXCEPT = "group except"
GROUP_ALL = "group all"
CAST = "cast"
INVALID = "invalid"
ALL = "all"
ALL_MEASURES = "all_measures"
COMPUTED = "computed"
DATASET = "dataset"
DATASET_PRIORITY = "dataset_priority"
RULE = "rule"
RULE_PRIORITY = "rule_priority"
NON_NULL = "non_null"
NON_ZERO = "non_zero"
PARTIAL_NULL = "partial_null"
PARTIAL_ZERO = "partial_zero"
ALWAYS_NULL = "always_null"
ALWAYS_ZERO = "always_zero"
APPLY = "apply"
# Defined operators.
OPERATOR = "operator"
EVAL = "eval"
# External.
SQLITE = '"sqlite"'
EXTERNAL = [SQLITE]
