"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirehoseStreamAction = exports.FirehoseStreamRecordSeparator = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * (experimental) Record Separator to be used to separate records.
 *
 * @experimental
 */
var FirehoseStreamRecordSeparator;
(function (FirehoseStreamRecordSeparator) {
    FirehoseStreamRecordSeparator["NEWLINE"] = "\n";
    FirehoseStreamRecordSeparator["TAB"] = "\t";
    FirehoseStreamRecordSeparator["WINDOWS_NEWLINE"] = "\r\n";
    FirehoseStreamRecordSeparator["COMMA"] = ",";
})(FirehoseStreamRecordSeparator = exports.FirehoseStreamRecordSeparator || (exports.FirehoseStreamRecordSeparator = {}));
/**
 * (experimental) The action to put the record from an MQTT message to the Kinesis Data Firehose stream.
 *
 * @experimental
 */
class FirehoseStreamAction {
    /**
     * @param stream The Kinesis Data Firehose stream to which to put records.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_FirehoseStreamActionProps(props);
        this.batchMode = props.batchMode;
        this.recordSeparator = props.recordSeparator;
        this.role = props.role;
    }
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        this.stream.grantPutRecords(role);
        return {
            configuration: {
                firehose: {
                    batchMode: this.batchMode,
                    deliveryStreamName: this.stream.deliveryStreamName,
                    roleArn: role.roleArn,
                    separator: this.recordSeparator,
                },
            },
        };
    }
}
exports.FirehoseStreamAction = FirehoseStreamAction;
_a = JSII_RTTI_SYMBOL_1;
FirehoseStreamAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.FirehoseStreamAction", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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