/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class GetFederationTokenRequestMarshaller
implements Marshaller<Request<GetFederationTokenRequest>, GetFederationTokenRequest> {
    public Request<GetFederationTokenRequest> marshall(GetFederationTokenRequest getFederationTokenRequest) {
        if (getFederationTokenRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getFederationTokenRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "GetFederationToken");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getFederationTokenRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)getFederationTokenRequest.getName()));
        }
        if (getFederationTokenRequest.getPolicy() != null) {
            request.addParameter("Policy", StringUtils.fromString((String)getFederationTokenRequest.getPolicy()));
        }
        if (getFederationTokenRequest.getPolicyArns() != null) {
            List<PolicyDescriptorType> policyArnsList = getFederationTokenRequest.getPolicyArns();
            if (policyArnsList.isEmpty()) {
                request.addParameter("PolicyArns", "");
            } else {
                int policyArnsListIndex = 1;
                for (PolicyDescriptorType policyArnsListValue : policyArnsList) {
                    if (policyArnsListValue.getArn() != null) {
                        request.addParameter("PolicyArns.member." + policyArnsListIndex + ".arn", StringUtils.fromString((String)policyArnsListValue.getArn()));
                    }
                    ++policyArnsListIndex;
                }
            }
        }
        if (getFederationTokenRequest.getDurationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)getFederationTokenRequest.getDurationSeconds()));
        }
        return request;
    }
}

