/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], "2.4.0-dev.5");
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
405: function _(n,c,f,i,o){i(),n(406)},
406: function _(t,_,r,e,o){e();const g=t(1);
/*
    Copyright notice: many of the awesome techniques and  GLSL code contained in
    this module are based on work by Nicolas Rougier as part of the Glumpy and
    Vispy projects. The algorithms are published in
    http://jcgt.org/published/0003/04/01/ and http://jcgt.org/published/0002/02/08/
    
    Other locations where we work with GL, or prepare for GL-rendering:
    - canvas.ts
    - plot.ts
    - glyph.ts
    - glyph_renderer.ts
    */o("get_regl",t(407).get_regl),(0,g.__exportStar)(t(417),r),(0,g.__exportStar)(t(421),r),(0,g.__exportStar)(t(422),r)},
407: function _(t,i,e,_,a){_();const r=t(1),o=(0,r.__importDefault)(t(408)),n=t(409),s=(0,r.__importDefault)(t(411)),l=(0,r.__importDefault)(t(412)),p=(0,r.__importDefault)(t(413)),c=(0,r.__importDefault)(t(414)),h=(0,r.__importDefault)(t(415)),u=(0,r.__importDefault)(t(416));let f;e.get_regl=function(t){return null==f&&(f=new g(t)),f};class g{constructor(t){try{this._regl=(0,o.default)({gl:t,extensions:["ANGLE_instanced_arrays","EXT_blend_minmax"]}),this._regl_available=!0,this._line_geometry=this._regl.buffer({usage:"static",type:"float",data:[[-2,0],[-1,-1],[1,-1],[2,0],[1,1],[-1,1]]}),this._line_triangles=this._regl.elements({usage:"static",primitive:"triangles",data:[[0,1,5],[1,2,5],[5,2,4],[2,3,4]]})}catch(t){this._regl_available=!1}}buffer(t){return this._regl.buffer(t)}clear(t,i){this._viewport={x:0,y:0,width:t,height:i},this._regl.clear({color:[0,0,0,0]})}get has_webgl(){return this._regl_available}get scissor(){return this._scissor}set_scissor(t,i,e,_){this._scissor={x:t,y:i,width:e,height:_}}get viewport(){return this._viewport}dashed_line(){return null==this._dashed_line&&(this._dashed_line=function(t,i,e){const _={vert:`#define DASHED\n\n${s.default}`,frag:`#define DASHED\n\n${l.default}`,attributes:{a_position:{buffer:i,divisor:0},a_point_prev:(t,i)=>i.points.to_attribute_config(),a_point_start:(t,i)=>i.points.to_attribute_config(2*Float32Array.BYTES_PER_ELEMENT),a_point_end:(t,i)=>i.points.to_attribute_config(4*Float32Array.BYTES_PER_ELEMENT),a_point_next:(t,i)=>i.points.to_attribute_config(6*Float32Array.BYTES_PER_ELEMENT),a_length_so_far:(t,i)=>i.length_so_far.to_attribute_config()},uniforms:{u_canvas_size:t.prop("canvas_size"),u_pixel_ratio:t.prop("pixel_ratio"),u_antialias:t.prop("antialias"),u_line_color:t.prop("line_color"),u_linewidth:t.prop("linewidth"),u_miter_limit:t.prop("miter_limit"),u_line_join:t.prop("line_join"),u_line_cap:t.prop("line_cap"),u_dash_tex:t.prop("dash_tex"),u_dash_tex_info:t.prop("dash_tex_info"),u_dash_scale:t.prop("dash_scale"),u_dash_offset:t.prop("dash_offset")},elements:e,instances:t.prop("nsegments"),blend:{enable:!0,equation:"max",func:{srcRGB:1,srcAlpha:1,dstRGB:1,dstAlpha:1}},depth:{enable:!1},scissor:{enable:!0,box:t.prop("scissor")},viewport:t.prop("viewport")};return t(_)}(this._regl,this._line_geometry,this._line_triangles)),this._dashed_line}get_dash(t){return null==this._dash_cache&&(this._dash_cache=new n.DashCache(this._regl)),this._dash_cache.get(t)}marker(t){null==this._marker_map&&(this._marker_map=new Map);let i=this._marker_map.get(t);return null==i&&(i=function(t,i){const e={vert:p.default,frag:`#define USE_${i.toUpperCase()}\n\n${c.default}`,attributes:{a_position:{buffer:t.buffer([[-.5,-.5],[-.5,.5],[.5,.5],[.5,-.5]]),divisor:0},a_center:(t,i)=>i.center.to_attribute_config(),a_size:(t,i)=>i.size.to_attribute_config(),a_angle:(t,i)=>i.angle.to_attribute_config(),a_linewidth:(t,i)=>i.linewidth.to_attribute_config(),a_line_color:(t,i)=>i.line_color.to_attribute_config(),a_fill_color:(t,i)=>i.fill_color.to_attribute_config(),a_show:(t,i)=>i.show.to_attribute_config()},uniforms:{u_canvas_size:t.prop("canvas_size"),u_pixel_ratio:t.prop("pixel_ratio"),u_antialias:t.prop("antialias")},count:4,primitive:"triangle fan",instances:t.prop("nmarkers"),blend:{enable:!0,func:{srcRGB:"one",srcAlpha:"one",dstRGB:"one minus src alpha",dstAlpha:"one minus src alpha"}},depth:{enable:!1},scissor:{enable:!0,box:t.prop("scissor")},viewport:t.prop("viewport")};return t(e)}(this._regl,t),this._marker_map.set(t,i)),i}rect_no_hatch(){return null==this._rect_no_hatch&&(this._rect_no_hatch=function(t){const i={vert:h.default,frag:u.default,attributes:{a_position:{buffer:t.buffer([[-.5,-.5],[-.5,.5],[.5,.5],[.5,-.5]]),divisor:0},a_center:(t,i)=>i.center.to_attribute_config(),a_width:(t,i)=>i.width.to_attribute_config(),a_height:(t,i)=>i.height.to_attribute_config(),a_angle:(t,i)=>i.angle.to_attribute_config(),a_linewidth:(t,i)=>i.linewidth.to_attribute_config(),a_line_color:(t,i)=>i.line_color.to_attribute_config(),a_fill_color:(t,i)=>i.fill_color.to_attribute_config(),a_line_join:(t,i)=>i.line_join.to_attribute_config(),a_show:(t,i)=>i.show.to_attribute_config()},uniforms:{u_canvas_size:t.prop("canvas_size"),u_pixel_ratio:t.prop("pixel_ratio"),u_antialias:t.prop("antialias")},count:4,primitive:"triangle fan",instances:t.prop("nmarkers"),blend:{enable:!0,func:{srcRGB:"one",srcAlpha:"one",dstRGB:"one minus src alpha",dstAlpha:"one minus src alpha"}},depth:{enable:!1},scissor:{enable:!0,box:t.prop("scissor")},viewport:t.prop("viewport")};return t(i)}(this._regl)),this._rect_no_hatch}rect_hatch(){return null==this._rect_hatch&&(this._rect_hatch=function(t){const i={vert:`#define HATCH\n\n${h.default}`,frag:`#define HATCH\n\n${u.default}`,attributes:{a_position:{buffer:t.buffer([[-.5,-.5],[-.5,.5],[.5,.5],[.5,-.5]]),divisor:0},a_center:(t,i)=>i.center.to_attribute_config(),a_width:(t,i)=>i.width.to_attribute_config(),a_height:(t,i)=>i.height.to_attribute_config(),a_angle:(t,i)=>i.angle.to_attribute_config(),a_linewidth:(t,i)=>i.linewidth.to_attribute_config(),a_line_color:(t,i)=>i.line_color.to_attribute_config(),a_fill_color:(t,i)=>i.fill_color.to_attribute_config(),a_line_join:(t,i)=>i.line_join.to_attribute_config(),a_show:(t,i)=>i.show.to_attribute_config(),a_hatch_pattern:(t,i)=>i.hatch_pattern.to_attribute_config(),a_hatch_scale:(t,i)=>i.hatch_scale.to_attribute_config(),a_hatch_weight:(t,i)=>i.hatch_weight.to_attribute_config(),a_hatch_color:(t,i)=>i.hatch_color.to_attribute_config()},uniforms:{u_canvas_size:t.prop("canvas_size"),u_pixel_ratio:t.prop("pixel_ratio"),u_antialias:t.prop("antialias")},count:4,primitive:"triangle fan",instances:t.prop("nmarkers"),blend:{enable:!0,func:{srcRGB:"one",srcAlpha:"one",dstRGB:"one minus src alpha",dstAlpha:"one minus src alpha"}},depth:{enable:!1},scissor:{enable:!0,box:t.prop("scissor")},viewport:t.prop("viewport")};return t(i)}(this._regl)),this._rect_hatch}solid_line(){return null==this._solid_line&&(this._solid_line=function(t,i,e){const _={vert:s.default,frag:l.default,attributes:{a_position:{buffer:i,divisor:0},a_point_prev:(t,i)=>i.points.to_attribute_config(),a_point_start:(t,i)=>i.points.to_attribute_config(2*Float32Array.BYTES_PER_ELEMENT),a_point_end:(t,i)=>i.points.to_attribute_config(4*Float32Array.BYTES_PER_ELEMENT),a_point_next:(t,i)=>i.points.to_attribute_config(6*Float32Array.BYTES_PER_ELEMENT)},uniforms:{u_canvas_size:t.prop("canvas_size"),u_pixel_ratio:t.prop("pixel_ratio"),u_antialias:t.prop("antialias"),u_line_color:t.prop("line_color"),u_linewidth:t.prop("linewidth"),u_miter_limit:t.prop("miter_limit"),u_line_join:t.prop("line_join"),u_line_cap:t.prop("line_cap")},elements:e,instances:t.prop("nsegments"),blend:{enable:!0,equation:"max",func:{srcRGB:1,srcAlpha:1,dstRGB:1,dstAlpha:1}},depth:{enable:!1},scissor:{enable:!0,box:t.prop("scissor")},viewport:t.prop("viewport")};return t(_)}(this._regl,this._line_geometry,this._line_triangles)),this._solid_line}}e.ReglWrapper=g,g.__name__="ReglWrapper"},
408: function _(e,t,r,n,a){var i,o;i=this,o=function(){"use strict";var e=function(e){return e instanceof Uint8Array||e instanceof Uint16Array||e instanceof Uint32Array||e instanceof Int8Array||e instanceof Int16Array||e instanceof Int32Array||e instanceof Float32Array||e instanceof Float64Array||e instanceof Uint8ClampedArray},t=function(e,t){for(var r=Object.keys(t),n=0;n<r.length;++n)e[r[n]]=t[r[n]];return e},r="\n";function n(e){var t=new Error("(regl) "+e);throw console.error(t),t}function a(e,t){e||n(t)}function i(e){return e?": "+e:""}function o(e,t){switch(t){case"number":return"number"==typeof e;case"object":return"object"==typeof e;case"string":return"string"==typeof e;case"boolean":return"boolean"==typeof e;case"function":return"function"==typeof e;case"undefined":return void 0===e;case"symbol":return"symbol"==typeof e}}function f(e,t,r){t.indexOf(e)<0&&n("invalid value"+i(r)+". must be one of: "+t)}var u=["gl","canvas","container","attributes","pixelRatio","extensions","optionalExtensions","profile","onDone"];function s(e,t){for(e+="";e.length<t;)e=" "+e;return e}function c(){this.name="unknown",this.lines=[],this.index={},this.hasErrors=!1}function l(e,t){this.number=e,this.line=t,this.errors=[]}function d(e,t,r){this.file=e,this.line=t,this.message=r}function m(){var e=new Error,t=(e.stack||e).toString(),r=/compileProcedure.*\n\s*at.*\((.*)\)/.exec(t);if(r)return r[1];var n=/compileProcedure.*\n\s*at\s+(.*)(\n|$)/.exec(t);return n?n[1]:"unknown"}function p(){var e=new Error,t=(e.stack||e).toString(),r=/at REGLCommand.*\n\s+at.*\((.*)\)/.exec(t);if(r)return r[1];var n=/at REGLCommand.*\n\s+at\s+(.*)\n/.exec(t);return n?n[1]:"unknown"}function h(e,t){var r,n=e.split("\n"),a=1,i=0,o={unknown:new c,0:new c};o.unknown.name=o[0].name=t||m(),o.unknown.lines.push(new l(0,""));for(var f=0;f<n.length;++f){var u=n[f],s=/^\s*#\s*(\w+)\s+(.+)\s*$/.exec(u);if(s)switch(s[1]){case"line":var d=/(\d+)(\s+\d+)?/.exec(s[2]);d&&(a=0|d[1],d[2]&&((i=0|d[2])in o||(o[i]=new c)));break;case"define":var p=/SHADER_NAME(_B64)?\s+(.*)$/.exec(s[2]);p&&(o[i].name=p[1]?(r=p[2],"undefined"!=typeof atob?atob(r):"base64:"+r):p[2])}o[i].lines.push(new l(a++,u))}return Object.keys(o).forEach((function(e){var t=o[e];t.lines.forEach((function(e){t.index[e.number]=e}))})),o}function b(e){e._commandRef=m()}function v(e,t){var r=p();n(e+" in command "+(t||m())+("unknown"===r?"":" called from "+r))}function g(e,t,r,n){o(e,t)||v("invalid parameter type"+i(r)+". expected "+t+", got "+typeof e,n||m())}var y=33071,x={};function w(e,t){return 32820===e||32819===e||33635===e?2:34042===e?4:x[e]*t}function A(e){return!(e&e-1||!e)}x[5120]=x[5121]=1,x[5122]=x[5123]=x[36193]=x[33635]=x[32819]=x[32820]=2,x[5124]=x[5125]=x[5126]=x[34042]=4;var _=t(a,{optional:function(e){e()},raise:n,commandRaise:v,command:function(e,t,r){e||v(t,r||m())},parameter:function(e,t,r){e in t||n("unknown parameter ("+e+")"+i(r)+". possible values: "+Object.keys(t).join())},commandParameter:function(e,t,r,n){e in t||v("unknown parameter ("+e+")"+i(r)+". possible values: "+Object.keys(t).join(),n||m())},constructor:function(e){Object.keys(e).forEach((function(e){u.indexOf(e)<0&&n('invalid regl constructor argument "'+e+'". must be one of '+u)}))},type:function(e,t,r){o(e,t)||n("invalid parameter type"+i(r)+". expected "+t+", got "+typeof e)},commandType:g,isTypedArray:function(t,r){e(t)||n("invalid parameter type"+i(r)+". must be a typed array")},nni:function(e,t){e>=0&&(0|e)===e||n("invalid parameter type, ("+e+")"+i(t)+". must be a nonnegative integer")},oneOf:f,shaderError:function(e,t,n,i,o){if(!e.getShaderParameter(t,e.COMPILE_STATUS)){var f=e.getShaderInfoLog(t),u=i===e.FRAGMENT_SHADER?"fragment":"vertex";g(n,"string",u+" shader source must be a string",o);var c=h(n,o),l=function(e){var t=[];return e.split("\n").forEach((function(e){if(!(e.length<5)){var r=/^ERROR:\s+(\d+):(\d+):\s*(.*)$/.exec(e);r?t.push(new d(0|r[1],0|r[2],r[3].trim())):e.length>0&&t.push(new d("unknown",0,e))}})),t}(f);!function(e,t){t.forEach((function(t){var r=e[t.file];if(r){var n=r.index[t.line];if(n)return n.errors.push(t),void(r.hasErrors=!0)}e.unknown.hasErrors=!0,e.unknown.lines[0].errors.push(t)}))}(c,l),Object.keys(c).forEach((function(e){var t=c[e];if(t.hasErrors){var n=[""],a=[""];i("file number "+e+": "+t.name+"\n","color:red;text-decoration:underline;font-weight:bold"),t.lines.forEach((function(e){if(e.errors.length>0){i(s(e.number,4)+"|  ","background-color:yellow; font-weight:bold"),i(e.line+r,"color:red; background-color:yellow; font-weight:bold");var t=0;e.errors.forEach((function(n){var a=n.message,o=/^\s*'(.*)'\s*:\s*(.*)$/.exec(a);if(o){var f=o[1];switch(a=o[2],f){case"assign":f="="}t=Math.max(e.line.indexOf(f,t),0)}else t=0;i(s("| ",6)),i(s("^^^",t+3)+r,"font-weight:bold"),i(s("| ",6)),i(a+r,"font-weight:bold")})),i(s("| ",6)+r)}else i(s(e.number,4)+"|  "),i(e.line+r,"color:red")})),"undefined"==typeof document||window.chrome?console.log(n.join("")):(a[0]=n.join("%c"),console.log.apply(console,a))}function i(e,t){n.push(e),a.push(t||"")}})),a.raise("Error compiling "+u+" shader, "+c[0].name)}},linkError:function(e,t,n,i,o){if(!e.getProgramParameter(t,e.LINK_STATUS)){var f=e.getProgramInfoLog(t),u=h(n,o),s='Error linking program with vertex shader, "'+h(i,o)[0].name+'", and fragment shader "'+u[0].name+'"';"undefined"!=typeof document?console.log("%c"+s+"\n%c"+f,"color:red;text-decoration:underline;font-weight:bold","color:red"):console.log(s+r+f),a.raise(s)}},callSite:p,saveCommandRef:b,saveDrawInfo:function(e,t,r,n){function a(e){return e?n.id(e):0}function i(e,t){Object.keys(t).forEach((function(t){e[n.id(t)]=!0}))}b(e),e._fragId=a(e.static.frag),e._vertId=a(e.static.vert);var o=e._uniformSet={};i(o,t.static),i(o,t.dynamic);var f=e._attributeSet={};i(f,r.static),i(f,r.dynamic),e._hasCount="count"in e.static||"count"in e.dynamic||"elements"in e.static||"elements"in e.dynamic},framebufferFormat:function(e,t,r){e.texture?f(e.texture._texture.internalformat,t,"unsupported texture format for attachment"):f(e.renderbuffer._renderbuffer.format,r,"unsupported renderbuffer format for attachment")},guessCommand:m,texture2D:function(e,t,r){var n,i=t.width,o=t.height,f=t.channels;a(i>0&&i<=r.maxTextureSize&&o>0&&o<=r.maxTextureSize,"invalid texture shape"),e.wrapS===y&&e.wrapT===y||a(A(i)&&A(o),"incompatible wrap mode for texture, both width and height must be power of 2"),1===t.mipmask?1!==i&&1!==o&&a(9984!==e.minFilter&&9986!==e.minFilter&&9985!==e.minFilter&&9987!==e.minFilter,"min filter requires mipmap"):(a(A(i)&&A(o),"texture must be a square power of 2 to support mipmapping"),a(t.mipmask===(i<<1)-1,"missing or incomplete mipmap data")),5126===t.type&&(r.extensions.indexOf("oes_texture_float_linear")<0&&a(9728===e.minFilter&&9728===e.magFilter,"filter not supported, must enable oes_texture_float_linear"),a(!e.genMipmaps,"mipmap generation not supported with float textures"));var u=t.images;for(n=0;n<16;++n)if(u[n]){var s=i>>n,c=o>>n;a(t.mipmask&1<<n,"missing mipmap data");var l=u[n];if(a(l.width===s&&l.height===c,"invalid shape for mip images"),a(l.format===t.format&&l.internalformat===t.internalformat&&l.type===t.type,"incompatible type for mip image"),l.compressed);else if(l.data){var d=Math.ceil(w(l.type,f)*s/l.unpackAlignment)*l.unpackAlignment;a(l.data.byteLength===d*c,"invalid data for image, buffer size is inconsistent with image format")}else l.element||l.copy}else e.genMipmaps||a(0==(t.mipmask&1<<n),"extra mipmap data");t.compressed&&a(!e.genMipmaps,"mipmap generation for compressed images not supported")},textureCube:function(e,t,r,n){var i=e.width,o=e.height,f=e.channels;a(i>0&&i<=n.maxTextureSize&&o>0&&o<=n.maxTextureSize,"invalid texture shape"),a(i===o,"cube map must be square"),a(t.wrapS===y&&t.wrapT===y,"wrap mode not supported by cube map");for(var u=0;u<r.length;++u){var s=r[u];a(s.width===i&&s.height===o,"inconsistent cube map face shape"),t.genMipmaps&&(a(!s.compressed,"can not generate mipmap for compressed textures"),a(1===s.mipmask,"can not specify mipmaps and generate mipmaps"));for(var c=s.images,l=0;l<16;++l){var d=c[l];if(d){var m=i>>l,p=o>>l;a(s.mipmask&1<<l,"missing mipmap data"),a(d.width===m&&d.height===p,"invalid shape for mip images"),a(d.format===e.format&&d.internalformat===e.internalformat&&d.type===e.type,"incompatible type for mip image"),d.compressed||(d.data?a(d.data.byteLength===m*p*Math.max(w(d.type,f),d.unpackAlignment),"invalid data for image, buffer size is inconsistent with image format"):d.element||d.copy)}}}}}),k=0;function S(e,t){this.id=k++,this.type=e,this.data=t}function O(e){return e.replace(/\\/g,"\\\\").replace(/"/g,'\\"')}function E(e){if(0===e.length)return[];var t=e.charAt(0),r=e.charAt(e.length-1);if(e.length>1&&t===r&&('"'===t||"'"===t))return['"'+O(e.substr(1,e.length-2))+'"'];var n=/\[(false|true|null|\d+|'[^']*'|"[^"]*")\]/.exec(e);if(n)return E(e.substr(0,n.index)).concat(E(n[1])).concat(E(e.substr(n.index+n[0].length)));var a=e.split(".");if(1===a.length)return['"'+O(e)+'"'];for(var i=[],o=0;o<a.length;++o)i=i.concat(E(a[o]));return i}function T(e){return"["+E(e).join("][")+"]"}var D={DynamicVariable:S,define:function(e,t){return new S(e,T(t+""))},isDynamic:function(e){return"function"==typeof e&&!e._reglType||e instanceof S},unbox:function e(t,r){return"function"==typeof t?new S(0,t):"number"==typeof t||"boolean"==typeof t?new S(5,t):Array.isArray(t)?new S(6,t.map((function(t,n){return e(t,r+"["+n+"]")}))):t instanceof S?t:void _(!1,"invalid option type in uniform "+r)},accessor:T},j={next:"function"==typeof requestAnimationFrame?function(e){return requestAnimationFrame(e)}:function(e){return setTimeout(e,16)},cancel:"function"==typeof cancelAnimationFrame?function(e){return cancelAnimationFrame(e)}:clearTimeout},C="undefined"!=typeof performance&&performance.now?function(){return performance.now()}:function(){return+new Date};function z(e){return"string"==typeof e?e.split():(_(Array.isArray(e),"invalid extension array"),e)}function F(e){return"string"==typeof e?(_("undefined"!=typeof document,"not supported outside of DOM"),document.querySelector(e)):e}function B(e){var r,n,a,i,o,f=e||{},u={},s=[],c=[],l="undefined"==typeof window?1:window.devicePixelRatio,d=!1,m=function(e){e&&_.raise(e)},p=function(){};if("string"==typeof f?(_("undefined"!=typeof document,"selector queries only supported in DOM enviroments"),r=document.querySelector(f),_(r,"invalid query string for element")):"object"==typeof f?"string"==typeof(o=f).nodeName&&"function"==typeof o.appendChild&&"function"==typeof o.getBoundingClientRect?r=f:function(e){return"function"==typeof e.drawArrays||"function"==typeof e.drawElements}(f)?a=(i=f).canvas:(_.constructor(f),"gl"in f?i=f.gl:"canvas"in f?a=F(f.canvas):"container"in f&&(n=F(f.container)),"attributes"in f&&(u=f.attributes,_.type(u,"object","invalid context attributes")),"extensions"in f&&(s=z(f.extensions)),"optionalExtensions"in f&&(c=z(f.optionalExtensions)),"onDone"in f&&(_.type(f.onDone,"function","invalid or missing onDone callback"),m=f.onDone),"profile"in f&&(d=!!f.profile),"pixelRatio"in f&&(l=+f.pixelRatio,_(l>0,"invalid pixel ratio"))):_.raise("invalid arguments to regl"),r&&("canvas"===r.nodeName.toLowerCase()?a=r:n=r),!i){if(!a){_("undefined"!=typeof document,"must manually specify webgl context outside of DOM environments");var h=function(e,r,n){var a,i=document.createElement("canvas");function o(){var t=window.innerWidth,r=window.innerHeight;if(e!==document.body){var a=i.getBoundingClientRect();t=a.right-a.left,r=a.bottom-a.top}i.width=n*t,i.height=n*r}return t(i.style,{border:0,margin:0,padding:0,top:0,left:0,width:"100%",height:"100%"}),e.appendChild(i),e===document.body&&(i.style.position="absolute",t(e.style,{margin:0,padding:0})),e!==document.body&&"function"==typeof ResizeObserver?(a=new ResizeObserver((function(){setTimeout(o)}))).observe(e):window.addEventListener("resize",o,!1),o(),{canvas:i,onDestroy:function(){a?a.disconnect():window.removeEventListener("resize",o),e.removeChild(i)}}}(n||document.body,0,l);if(!h)return null;a=h.canvas,p=h.onDestroy}void 0===u.premultipliedAlpha&&(u.premultipliedAlpha=!0),i=function(e,t){function r(r){try{return e.getContext(r,t)}catch(e){return null}}return r("webgl")||r("experimental-webgl")||r("webgl-experimental")}(a,u)}return i?{gl:i,canvas:a,container:n,extensions:s,optionalExtensions:c,pixelRatio:l,profile:d,onDone:m,onDestroy:p}:(p(),m("webgl not supported, try upgrading your browser or graphics drivers http://get.webgl.org"),null)}function V(e,t){for(var r=Array(e),n=0;n<e;++n)r[n]=t(n);return r}function I(e){var t,r;return t=(e>65535)<<4,t|=r=((e>>>=t)>255)<<3,t|=r=((e>>>=r)>15)<<2,(t|=r=((e>>>=r)>3)<<1)|(e>>>=r)>>1}function P(){var e=V(8,(function(){return[]}));function t(t){var r=function(e){for(var t=16;t<=1<<28;t*=16)if(e<=t)return t;return 0}(t),n=e[I(r)>>2];return n.length>0?n.pop():new ArrayBuffer(r)}function r(t){e[I(t.byteLength)>>2].push(t)}return{alloc:t,free:r,allocType:function(e,r){var n=null;switch(e){case 5120:n=new Int8Array(t(r),0,r);break;case 5121:n=new Uint8Array(t(r),0,r);break;case 5122:n=new Int16Array(t(2*r),0,r);break;case 5123:n=new Uint16Array(t(2*r),0,r);break;case 5124:n=new Int32Array(t(4*r),0,r);break;case 5125:n=new Uint32Array(t(4*r),0,r);break;case 5126:n=new Float32Array(t(4*r),0,r);break;default:return null}return n.length!==r?n.subarray(0,r):n},freeType:function(e){r(e.buffer)}}}var L=P();L.zero=P();var R=3553,M=6408,W=5126,U=36160;function G(t){return!!t&&"object"==typeof t&&Array.isArray(t.shape)&&Array.isArray(t.stride)&&"number"==typeof t.offset&&t.shape.length===t.stride.length&&(Array.isArray(t.data)||e(t.data))}var H=function(e){return Object.keys(e).map((function(t){return e[t]}))},N={shape:function(e){for(var t=[],r=e;r.length;r=r[0])t.push(r.length);return t},flatten:function(e,t,r,n){var a=1;if(t.length)for(var i=0;i<t.length;++i)a*=t[i];else a=0;var o=n||L.allocType(r,a);switch(t.length){case 0:break;case 1:!function(e,t,r){for(var n=0;n<t;++n)r[n]=e[n]}(e,t[0],o);break;case 2:!function(e,t,r,n){for(var a=0,i=0;i<t;++i)for(var o=e[i],f=0;f<r;++f)n[a++]=o[f]}(e,t[0],t[1],o);break;case 3:q(e,t[0],t[1],t[2],o,0);break;default:Q(e,t,0,o,0)}return o}};function q(e,t,r,n,a,i){for(var o=i,f=0;f<t;++f)for(var u=e[f],s=0;s<r;++s)for(var c=u[s],l=0;l<n;++l)a[o++]=c[l]}function Q(e,t,r,n,a){for(var i=1,o=r+1;o<t.length;++o)i*=t[o];var f=t[r];if(t.length-r==4){var u=t[r+1],s=t[r+2],c=t[r+3];for(o=0;o<f;++o)q(e[o],u,s,c,n,a),a+=i}else for(o=0;o<f;++o)Q(e[o],t,r+1,n,a),a+=i}var Y={"[object Int8Array]":5120,"[object Int16Array]":5122,"[object Int32Array]":5124,"[object Uint8Array]":5121,"[object Uint8ClampedArray]":5121,"[object Uint16Array]":5123,"[object Uint32Array]":5125,"[object Float32Array]":5126,"[object Float64Array]":5121,"[object ArrayBuffer]":5121},X={int8:5120,int16:5122,int32:5124,uint8:5121,uint16:5123,uint32:5125,float:5126,float32:5126},$={dynamic:35048,stream:35040,static:35044},K=N.flatten,J=N.shape,Z=5121,ee=5126,te=[];function re(e){return 0|Y[Object.prototype.toString.call(e)]}function ne(e,t){for(var r=0;r<t.length;++r)e[r]=t[r]}function ae(e,t,r,n,a,i,o){for(var f=0,u=0;u<r;++u)for(var s=0;s<n;++s)e[f++]=t[a*u+i*s+o]}te[5120]=1,te[5122]=2,te[5124]=4,te[5121]=1,te[5123]=2,te[5125]=4,te[5126]=4;var ie={points:0,point:0,lines:1,line:1,triangles:4,triangle:4,"line loop":2,"line strip":3,"triangle strip":5,"triangle fan":6},oe=5121,fe=5123,ue=5125,se=34963,ce=new Float32Array(1),le=new Uint32Array(ce.buffer);function de(e){for(var t=L.allocType(5123,e.length),r=0;r<e.length;++r)if(isNaN(e[r]))t[r]=65535;else if(e[r]===1/0)t[r]=31744;else if(e[r]===-1/0)t[r]=64512;else{ce[0]=e[r];var n=le[0],a=n>>>31<<15,i=(n<<1>>>24)-127,o=n>>13&1023;if(i<-24)t[r]=a;else if(i<-14){var f=-14-i;t[r]=a+(o+1024>>f)}else t[r]=i>15?a+31744:a+(i+15<<10)+o}return t}function me(t){return Array.isArray(t)||e(t)}var pe=function(e){return!(e&e-1||!e)},he=3553,be=34067,ve=34069,ge=6408,ye=6406,xe=6407,we=6409,Ae=6410,_e=32855,ke=6402,Se=34041,Oe=35904,Ee=35906,Te=36193,De=33776,je=33777,Ce=33778,ze=33779,Fe=5121,Be=5123,Ve=5125,Ie=5126,Pe=33071,Le=9728,Re=9984,Me=9987,We=4352,Ue=33984,Ge=[Re,9986,9985,Me],He=[0,we,Ae,xe,ge],Ne={};function qe(e){return"[object "+e+"]"}Ne[6409]=Ne[6406]=Ne[6402]=1,Ne[34041]=Ne[6410]=2,Ne[6407]=Ne[35904]=3,Ne[6408]=Ne[35906]=4;var Qe=qe("HTMLCanvasElement"),Ye=qe("OffscreenCanvas"),Xe=qe("CanvasRenderingContext2D"),$e=qe("ImageBitmap"),Ke=qe("HTMLImageElement"),Je=qe("HTMLVideoElement"),Ze=Object.keys(Y).concat([Qe,Ye,Xe,$e,Ke,Je]),et=[];et[5121]=1,et[5126]=4,et[36193]=2,et[5123]=2,et[5125]=4;var tt=[];function rt(e){return Array.isArray(e)&&(0===e.length||"number"==typeof e[0])}function nt(e){return!!Array.isArray(e)&&!(0===e.length||!me(e[0]))}function at(e){return Object.prototype.toString.call(e)}function it(e){return at(e)===Qe}function ot(e){return at(e)===Ye}function ft(e){if(!e)return!1;var t=at(e);return Ze.indexOf(t)>=0||rt(e)||nt(e)||G(e)}function ut(e){return 0|Y[Object.prototype.toString.call(e)]}function st(e,t){return L.allocType(e.type===Te?Ie:e.type,t)}function ct(e,t){e.type===Te?(e.data=de(t),L.freeType(t)):e.data=t}function lt(e,t,r,n,a,i){var o;if(o=void 0!==tt[e]?tt[e]:Ne[e]*et[t],i&&(o*=6),a){for(var f=0,u=r;u>=1;)f+=o*u*u,u/=2;return f}return o*r*n}function dt(r,n,a,i,o,f,u){var s={"don't care":We,"dont care":We,nice:4354,fast:4353},c={repeat:10497,clamp:Pe,mirror:33648},l={nearest:Le,linear:9729},d=t({mipmap:Me,"nearest mipmap nearest":Re,"linear mipmap nearest":9985,"nearest mipmap linear":9986,"linear mipmap linear":Me},l),m={none:0,browser:37444},p={uint8:Fe,rgba4:32819,rgb565:33635,"rgb5 a1":32820},h={alpha:ye,luminance:we,"luminance alpha":Ae,rgb:xe,rgba:ge,rgba4:32854,"rgb5 a1":_e,rgb565:36194},b={};n.ext_srgb&&(h.srgb=Oe,h.srgba=Ee),n.oes_texture_float&&(p.float32=p.float=Ie),n.oes_texture_half_float&&(p.float16=p["half float"]=Te),n.webgl_depth_texture&&(t(h,{depth:ke,"depth stencil":Se}),t(p,{uint16:Be,uint32:Ve,"depth stencil":34042})),n.webgl_compressed_texture_s3tc&&t(b,{"rgb s3tc dxt1":De,"rgba s3tc dxt1":je,"rgba s3tc dxt3":Ce,"rgba s3tc dxt5":ze}),n.webgl_compressed_texture_atc&&t(b,{"rgb atc":35986,"rgba atc explicit alpha":35987,"rgba atc interpolated alpha":34798}),n.webgl_compressed_texture_pvrtc&&t(b,{"rgb pvrtc 4bppv1":35840,"rgb pvrtc 2bppv1":35841,"rgba pvrtc 4bppv1":35842,"rgba pvrtc 2bppv1":35843}),n.webgl_compressed_texture_etc1&&(b["rgb etc1"]=36196);var v=Array.prototype.slice.call(r.getParameter(34467));Object.keys(b).forEach((function(e){var t=b[e];v.indexOf(t)>=0&&(h[e]=t)}));var g=Object.keys(h);a.textureFormats=g;var y=[];Object.keys(h).forEach((function(e){var t=h[e];y[t]=e}));var x=[];Object.keys(p).forEach((function(e){var t=p[e];x[t]=e}));var w=[];Object.keys(l).forEach((function(e){w[l[e]]=e}));var A=[];Object.keys(d).forEach((function(e){var t=d[e];A[t]=e}));var k=[];Object.keys(c).forEach((function(e){k[c[e]]=e}));var S=g.reduce((function(e,t){var r=h[t];return r===we||r===ye||r===we||r===Ae||r===ke||r===Se||n.ext_srgb&&(r===Oe||r===Ee)?e[r]=r:r===_e||t.indexOf("rgba")>=0?e[r]=ge:e[r]=xe,e}),{});function O(){this.internalformat=ge,this.format=ge,this.type=Fe,this.compressed=!1,this.premultiplyAlpha=!1,this.flipY=!1,this.unpackAlignment=1,this.colorSpace=37444,this.width=0,this.height=0,this.channels=0}function E(e,t){e.internalformat=t.internalformat,e.format=t.format,e.type=t.type,e.compressed=t.compressed,e.premultiplyAlpha=t.premultiplyAlpha,e.flipY=t.flipY,e.unpackAlignment=t.unpackAlignment,e.colorSpace=t.colorSpace,e.width=t.width,e.height=t.height,e.channels=t.channels}function T(e,t){if("object"==typeof t&&t){if("premultiplyAlpha"in t&&(_.type(t.premultiplyAlpha,"boolean","invalid premultiplyAlpha"),e.premultiplyAlpha=t.premultiplyAlpha),"flipY"in t&&(_.type(t.flipY,"boolean","invalid texture flip"),e.flipY=t.flipY),"alignment"in t&&(_.oneOf(t.alignment,[1,2,4,8],"invalid texture unpack alignment"),e.unpackAlignment=t.alignment),"colorSpace"in t&&(_.parameter(t.colorSpace,m,"invalid colorSpace"),e.colorSpace=m[t.colorSpace]),"type"in t){var r=t.type;_(n.oes_texture_float||!("float"===r||"float32"===r),"you must enable the OES_texture_float extension in order to use floating point textures."),_(n.oes_texture_half_float||!("half float"===r||"float16"===r),"you must enable the OES_texture_half_float extension in order to use 16-bit floating point textures."),_(n.webgl_depth_texture||!("uint16"===r||"uint32"===r||"depth stencil"===r),"you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures."),_.parameter(r,p,"invalid texture type"),e.type=p[r]}var i=e.width,o=e.height,f=e.channels,u=!1;"shape"in t?(_(Array.isArray(t.shape)&&t.shape.length>=2,"shape must be an array"),i=t.shape[0],o=t.shape[1],3===t.shape.length&&(f=t.shape[2],_(f>0&&f<=4,"invalid number of channels"),u=!0),_(i>=0&&i<=a.maxTextureSize,"invalid width"),_(o>=0&&o<=a.maxTextureSize,"invalid height")):("radius"in t&&(i=o=t.radius,_(i>=0&&i<=a.maxTextureSize,"invalid radius")),"width"in t&&(i=t.width,_(i>=0&&i<=a.maxTextureSize,"invalid width")),"height"in t&&(o=t.height,_(o>=0&&o<=a.maxTextureSize,"invalid height")),"channels"in t&&(f=t.channels,_(f>0&&f<=4,"invalid number of channels"),u=!0)),e.width=0|i,e.height=0|o,e.channels=0|f;var s=!1;if("format"in t){var c=t.format;_(n.webgl_depth_texture||!("depth"===c||"depth stencil"===c),"you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures."),_.parameter(c,h,"invalid texture format");var l=e.internalformat=h[c];e.format=S[l],c in p&&("type"in t||(e.type=p[c])),c in b&&(e.compressed=!0),s=!0}!u&&s?e.channels=Ne[e.format]:u&&!s?e.channels!==He[e.format]&&(e.format=e.internalformat=He[e.channels]):s&&u&&_(e.channels===Ne[e.format],"number of channels inconsistent with specified format")}}function D(e){r.pixelStorei(37440,e.flipY),r.pixelStorei(37441,e.premultiplyAlpha),r.pixelStorei(37443,e.colorSpace),r.pixelStorei(3317,e.unpackAlignment)}function j(){O.call(this),this.xOffset=0,this.yOffset=0,this.data=null,this.needsFree=!1,this.element=null,this.needsCopy=!1}function C(t,r){var n=null;if(ft(r)?n=r:r&&(_.type(r,"object","invalid pixel data type"),T(t,r),"x"in r&&(t.xOffset=0|r.x),"y"in r&&(t.yOffset=0|r.y),ft(r.data)&&(n=r.data)),_(!t.compressed||n instanceof Uint8Array,"compressed texture data must be stored in a uint8array"),r.copy){_(!n,"can not specify copy and data field for the same texture");var i=o.viewportWidth,f=o.viewportHeight;t.width=t.width||i-t.xOffset,t.height=t.height||f-t.yOffset,t.needsCopy=!0,_(t.xOffset>=0&&t.xOffset<i&&t.yOffset>=0&&t.yOffset<f&&t.width>0&&t.width<=i&&t.height>0&&t.height<=f,"copy texture read out of bounds")}else if(n){if(e(n))t.channels=t.channels||4,t.data=n,"type"in r||t.type!==Fe||(t.type=ut(n));else if(rt(n))t.channels=t.channels||4,function(e,t){var r=t.length;switch(e.type){case Fe:case Be:case Ve:case Ie:var n=L.allocType(e.type,r);n.set(t),e.data=n;break;case Te:e.data=de(t);break;default:_.raise("unsupported texture type, must specify a typed array")}}(t,n),t.alignment=1,t.needsFree=!0;else if(G(n)){var u=n.data;Array.isArray(u)||t.type!==Fe||(t.type=ut(u));var s,c,l,d,m,p,h=n.shape,b=n.stride;3===h.length?(l=h[2],p=b[2]):(_(2===h.length,"invalid ndarray pixel data, must be 2 or 3D"),l=1,p=1),s=h[0],c=h[1],d=b[0],m=b[1],t.alignment=1,t.width=s,t.height=c,t.channels=l,t.format=t.internalformat=He[l],t.needsFree=!0,function(e,t,r,n,a,i){for(var o=e.width,f=e.height,u=e.channels,s=st(e,o*f*u),c=0,l=0;l<f;++l)for(var d=0;d<o;++d)for(var m=0;m<u;++m)s[c++]=t[r*d+n*l+a*m+i];ct(e,s)}(t,u,d,m,p,n.offset)}else if(it(n)||ot(n)||at(n)===Xe)it(n)||ot(n)?t.element=n:t.element=n.canvas,t.width=t.element.width,t.height=t.element.height,t.channels=4;else if(function(e){return at(e)===$e}(n))t.element=n,t.width=n.width,t.height=n.height,t.channels=4;else if(function(e){return at(e)===Ke}(n))t.element=n,t.width=n.naturalWidth,t.height=n.naturalHeight,t.channels=4;else if(function(e){return at(e)===Je}(n))t.element=n,t.width=n.videoWidth,t.height=n.videoHeight,t.channels=4;else if(nt(n)){var v=t.width||n[0].length,g=t.height||n.length,y=t.channels;y=me(n[0][0])?y||n[0][0].length:y||1;for(var x=N.shape(n),w=1,A=0;A<x.length;++A)w*=x[A];var k=st(t,w);N.flatten(n,x,"",k),ct(t,k),t.alignment=1,t.width=v,t.height=g,t.channels=y,t.format=t.internalformat=He[y],t.needsFree=!0}}else t.width=t.width||1,t.height=t.height||1,t.channels=t.channels||4;t.type===Ie?_(a.extensions.indexOf("oes_texture_float")>=0,"oes_texture_float extension not enabled"):t.type===Te&&_(a.extensions.indexOf("oes_texture_half_float")>=0,"oes_texture_half_float extension not enabled")}function z(e,t,n){var a=e.element,o=e.data,f=e.internalformat,u=e.format,s=e.type,c=e.width,l=e.height;D(e),a?r.texImage2D(t,n,u,u,s,a):e.compressed?r.compressedTexImage2D(t,n,f,c,l,0,o):e.needsCopy?(i(),r.copyTexImage2D(t,n,u,e.xOffset,e.yOffset,c,l,0)):r.texImage2D(t,n,u,c,l,0,u,s,o||null)}function F(e,t,n,a,o){var f=e.element,u=e.data,s=e.internalformat,c=e.format,l=e.type,d=e.width,m=e.height;D(e),f?r.texSubImage2D(t,o,n,a,c,l,f):e.compressed?r.compressedTexSubImage2D(t,o,n,a,s,d,m,u):e.needsCopy?(i(),r.copyTexSubImage2D(t,o,n,a,e.xOffset,e.yOffset,d,m)):r.texSubImage2D(t,o,n,a,d,m,c,l,u)}var B=[];function V(){return B.pop()||new j}function I(e){e.needsFree&&L.freeType(e.data),j.call(e),B.push(e)}function P(){O.call(this),this.genMipmaps=!1,this.mipmapHint=We,this.mipmask=0,this.images=Array(16)}function R(e,t,r){var n=e.images[0]=V();e.mipmask=1,n.width=e.width=t,n.height=e.height=r,n.channels=e.channels=4}function M(e,t){var r=null;if(ft(t))E(r=e.images[0]=V(),e),C(r,t),e.mipmask=1;else if(T(e,t),Array.isArray(t.mipmap))for(var n=t.mipmap,a=0;a<n.length;++a)E(r=e.images[a]=V(),e),r.width>>=a,r.height>>=a,C(r,n[a]),e.mipmask|=1<<a;else E(r=e.images[0]=V(),e),C(r,t),e.mipmask=1;E(e,e.images[0]),!e.compressed||e.internalformat!==De&&e.internalformat!==je&&e.internalformat!==Ce&&e.internalformat!==ze||_(e.width%4==0&&e.height%4==0,"for compressed texture formats, mipmap level 0 must have width and height that are a multiple of 4")}function W(e,t){for(var r=e.images,n=0;n<r.length;++n){if(!r[n])return;z(r[n],t,n)}}var U=[];function q(){var e=U.pop()||new P;O.call(e),e.mipmask=0;for(var t=0;t<16;++t)e.images[t]=null;return e}function Q(e){for(var t=e.images,r=0;r<t.length;++r)t[r]&&I(t[r]),t[r]=null;U.push(e)}function Y(){this.minFilter=Le,this.magFilter=Le,this.wrapS=Pe,this.wrapT=Pe,this.anisotropic=1,this.genMipmaps=!1,this.mipmapHint=We}function X(e,t){if("min"in t){var r=t.min;_.parameter(r,d),e.minFilter=d[r],Ge.indexOf(e.minFilter)>=0&&!("faces"in t)&&(e.genMipmaps=!0)}if("mag"in t){var n=t.mag;_.parameter(n,l),e.magFilter=l[n]}var i=e.wrapS,o=e.wrapT;if("wrap"in t){var f=t.wrap;"string"==typeof f?(_.parameter(f,c),i=o=c[f]):Array.isArray(f)&&(_.parameter(f[0],c),_.parameter(f[1],c),i=c[f[0]],o=c[f[1]])}else{if("wrapS"in t){var u=t.wrapS;_.parameter(u,c),i=c[u]}if("wrapT"in t){var m=t.wrapT;_.parameter(m,c),o=c[m]}}if(e.wrapS=i,e.wrapT=o,"anisotropic"in t){var p=t.anisotropic;_("number"==typeof p&&p>=1&&p<=a.maxAnisotropic,"aniso samples must be between 1 and "),e.anisotropic=t.anisotropic}if("mipmap"in t){var h=!1;switch(typeof t.mipmap){case"string":_.parameter(t.mipmap,s,"invalid mipmap hint"),e.mipmapHint=s[t.mipmap],e.genMipmaps=!0,h=!0;break;case"boolean":h=e.genMipmaps=t.mipmap;break;case"object":_(Array.isArray(t.mipmap),"invalid mipmap type"),e.genMipmaps=!1,h=!0;break;default:_.raise("invalid mipmap type")}h&&!("min"in t)&&(e.minFilter=Re)}}function $(e,t){r.texParameteri(t,10241,e.minFilter),r.texParameteri(t,10240,e.magFilter),r.texParameteri(t,10242,e.wrapS),r.texParameteri(t,10243,e.wrapT),n.ext_texture_filter_anisotropic&&r.texParameteri(t,34046,e.anisotropic),e.genMipmaps&&(r.hint(33170,e.mipmapHint),r.generateMipmap(t))}var K=0,J={},Z=a.maxTextureUnits,ee=Array(Z).map((function(){return null}));function te(e){O.call(this),this.mipmask=0,this.internalformat=ge,this.id=K++,this.refCount=1,this.target=e,this.texture=r.createTexture(),this.unit=-1,this.bindCount=0,this.texInfo=new Y,u.profile&&(this.stats={size:0})}function re(e){r.activeTexture(Ue),r.bindTexture(e.target,e.texture)}function ne(){var e=ee[0];e?r.bindTexture(e.target,e.texture):r.bindTexture(he,null)}function ae(e){var t=e.texture;_(t,"must not double destroy texture");var n=e.unit,a=e.target;n>=0&&(r.activeTexture(Ue+n),r.bindTexture(a,null),ee[n]=null),r.deleteTexture(t),e.texture=null,e.params=null,e.pixels=null,e.refCount=0,delete J[e.id],f.textureCount--}return t(te.prototype,{bind:function(){var e=this;e.bindCount+=1;var t=e.unit;if(t<0){for(var n=0;n<Z;++n){var a=ee[n];if(a){if(a.bindCount>0)continue;a.unit=-1}ee[n]=e,t=n;break}t>=Z&&_.raise("insufficient number of texture units"),u.profile&&f.maxTextureUnits<t+1&&(f.maxTextureUnits=t+1),e.unit=t,r.activeTexture(Ue+t),r.bindTexture(e.target,e.texture)}return t},unbind:function(){this.bindCount-=1},decRef:function(){--this.refCount<=0&&ae(this)}}),u.profile&&(f.getTotalTextureSize=function(){var e=0;return Object.keys(J).forEach((function(t){e+=J[t].stats.size})),e}),{create2D:function(e,t){var n=new te(he);function i(e,t){var r=n.texInfo;Y.call(r);var o=q();return"number"==typeof e?R(o,0|e,"number"==typeof t?0|t:0|e):e?(_.type(e,"object","invalid arguments to regl.texture"),X(r,e),M(o,e)):R(o,1,1),r.genMipmaps&&(o.mipmask=(o.width<<1)-1),n.mipmask=o.mipmask,E(n,o),_.texture2D(r,o,a),n.internalformat=o.internalformat,i.width=o.width,i.height=o.height,re(n),W(o,he),$(r,he),ne(),Q(o),u.profile&&(n.stats.size=lt(n.internalformat,n.type,o.width,o.height,r.genMipmaps,!1)),i.format=y[n.internalformat],i.type=x[n.type],i.mag=w[r.magFilter],i.min=A[r.minFilter],i.wrapS=k[r.wrapS],i.wrapT=k[r.wrapT],i}return J[n.id]=n,f.textureCount++,i(e,t),i.subimage=function(e,t,r,a){_(!!e,"must specify image data");var o=0|t,f=0|r,u=0|a,s=V();return E(s,n),s.width=0,s.height=0,C(s,e),s.width=s.width||(n.width>>u)-o,s.height=s.height||(n.height>>u)-f,_(n.type===s.type&&n.format===s.format&&n.internalformat===s.internalformat,"incompatible format for texture.subimage"),_(o>=0&&f>=0&&o+s.width<=n.width&&f+s.height<=n.height,"texture.subimage write out of bounds"),_(n.mipmask&1<<u,"missing mipmap data"),_(s.data||s.element||s.needsCopy,"missing image data"),re(n),F(s,he,o,f,u),ne(),I(s),i},i.resize=function(e,t){var a=0|e,o=0|t||a;if(a===n.width&&o===n.height)return i;i.width=n.width=a,i.height=n.height=o,re(n);for(var f=0;n.mipmask>>f;++f){var s=a>>f,c=o>>f;if(!s||!c)break;r.texImage2D(he,f,n.format,s,c,0,n.format,n.type,null)}return ne(),u.profile&&(n.stats.size=lt(n.internalformat,n.type,a,o,!1,!1)),i},i._reglType="texture2d",i._texture=n,u.profile&&(i.stats=n.stats),i.destroy=function(){n.decRef()},i},createCube:function(e,t,n,i,o,s){var c=new te(be);J[c.id]=c,f.cubeCount++;var l=new Array(6);function d(e,t,r,n,i,o){var f,s=c.texInfo;for(Y.call(s),f=0;f<6;++f)l[f]=q();if("number"!=typeof e&&e)if("object"==typeof e)if(t)M(l[0],e),M(l[1],t),M(l[2],r),M(l[3],n),M(l[4],i),M(l[5],o);else if(X(s,e),T(c,e),"faces"in e){var m=e.faces;for(_(Array.isArray(m)&&6===m.length,"cube faces must be a length 6 array"),f=0;f<6;++f)_("object"==typeof m[f]&&!!m[f],"invalid input for cube map face"),E(l[f],c),M(l[f],m[f])}else for(f=0;f<6;++f)M(l[f],e);else _.raise("invalid arguments to cube map");else{var p=0|e||1;for(f=0;f<6;++f)R(l[f],p,p)}for(E(c,l[0]),_.optional((function(){a.npotTextureCube||_(pe(c.width)&&pe(c.height),"your browser does not support non power or two texture dimensions")})),s.genMipmaps?c.mipmask=(l[0].width<<1)-1:c.mipmask=l[0].mipmask,_.textureCube(c,s,l,a),c.internalformat=l[0].internalformat,d.width=l[0].width,d.height=l[0].height,re(c),f=0;f<6;++f)W(l[f],ve+f);for($(s,be),ne(),u.profile&&(c.stats.size=lt(c.internalformat,c.type,d.width,d.height,s.genMipmaps,!0)),d.format=y[c.internalformat],d.type=x[c.type],d.mag=w[s.magFilter],d.min=A[s.minFilter],d.wrapS=k[s.wrapS],d.wrapT=k[s.wrapT],f=0;f<6;++f)Q(l[f]);return d}return d(e,t,n,i,o,s),d.subimage=function(e,t,r,n,a){_(!!t,"must specify image data"),_("number"==typeof e&&e===(0|e)&&e>=0&&e<6,"invalid face");var i=0|r,o=0|n,f=0|a,u=V();return E(u,c),u.width=0,u.height=0,C(u,t),u.width=u.width||(c.width>>f)-i,u.height=u.height||(c.height>>f)-o,_(c.type===u.type&&c.format===u.format&&c.internalformat===u.internalformat,"incompatible format for texture.subimage"),_(i>=0&&o>=0&&i+u.width<=c.width&&o+u.height<=c.height,"texture.subimage write out of bounds"),_(c.mipmask&1<<f,"missing mipmap data"),_(u.data||u.element||u.needsCopy,"missing image data"),re(c),F(u,ve+e,i,o,f),ne(),I(u),d},d.resize=function(e){var t=0|e;if(t!==c.width){d.width=c.width=t,d.height=c.height=t,re(c);for(var n=0;n<6;++n)for(var a=0;c.mipmask>>a;++a)r.texImage2D(ve+n,a,c.format,t>>a,t>>a,0,c.format,c.type,null);return ne(),u.profile&&(c.stats.size=lt(c.internalformat,c.type,d.width,d.height,!1,!0)),d}},d._reglType="textureCube",d._texture=c,u.profile&&(d.stats=c.stats),d.destroy=function(){c.decRef()},d},clear:function(){for(var e=0;e<Z;++e)r.activeTexture(Ue+e),r.bindTexture(he,null),ee[e]=null;H(J).forEach(ae),f.cubeCount=0,f.textureCount=0},getTexture:function(e){return null},restore:function(){for(var e=0;e<Z;++e){var t=ee[e];t&&(t.bindCount=0,t.unit=-1,ee[e]=null)}H(J).forEach((function(e){e.texture=r.createTexture(),r.bindTexture(e.target,e.texture);for(var t=0;t<32;++t)if(0!=(e.mipmask&1<<t))if(e.target===he)r.texImage2D(he,t,e.internalformat,e.width>>t,e.height>>t,0,e.internalformat,e.type,null);else for(var n=0;n<6;++n)r.texImage2D(ve+n,t,e.internalformat,e.width>>t,e.height>>t,0,e.internalformat,e.type,null);$(e.texInfo,e.target)}))},refresh:function(){for(var e=0;e<Z;++e){var t=ee[e];t&&(t.bindCount=0,t.unit=-1,ee[e]=null),r.activeTexture(Ue+e),r.bindTexture(he,null),r.bindTexture(be,null)}}}}tt[32854]=2,tt[32855]=2,tt[36194]=2,tt[34041]=4,tt[33776]=.5,tt[33777]=.5,tt[33778]=1,tt[33779]=1,tt[35986]=.5,tt[35987]=1,tt[34798]=1,tt[35840]=.5,tt[35841]=.25,tt[35842]=.5,tt[35843]=.25,tt[36196]=.5;var mt=36161,pt=32854,ht=[];function bt(e,t,r){return ht[e]*t*r}ht[32854]=2,ht[32855]=2,ht[36194]=2,ht[33189]=2,ht[36168]=1,ht[34041]=4,ht[35907]=4,ht[34836]=16,ht[34842]=8,ht[34843]=6;var vt=36160,gt=36161,yt=3553,xt=34069,wt=[6407,6408],At=[];At[6408]=4,At[6407]=3;var _t=[];_t[5121]=1,_t[5126]=4,_t[36193]=2;var kt=[32854,32855,36194,35907,34842,34843,34836],St={36053:"complete",36054:"incomplete attachment",36057:"incomplete dimensions",36055:"incomplete, missing attachment",36061:"unsupported"},Ot=34963,Et=["attributes","elements","offset","count","primitive","instances"];function Tt(){this.state=0,this.x=0,this.y=0,this.z=0,this.w=0,this.buffer=null,this.size=0,this.normalized=!1,this.type=5126,this.offset=0,this.stride=0,this.divisor=0}var Dt=5121,jt=5126;function Ct(t,r,n,a,i,o,f){function u(u){var s;null===r.next?(_(i.preserveDrawingBuffer,'you must create a webgl context with "preserveDrawingBuffer":true in order to read pixels from the drawing buffer'),s=Dt):(_(null!==r.next.colorAttachments[0].texture,"You cannot read from a renderbuffer"),s=r.next.colorAttachments[0].texture._texture.type,_.optional((function(){o.oes_texture_float?(_(s===Dt||s===jt,"Reading from a framebuffer is only allowed for the types 'uint8' and 'float'"),s===jt&&_(f.readFloat,"Reading 'float' values is not permitted in your browser. For a fallback, please see: https://www.npmjs.com/package/glsl-read-float")):_(s===Dt,"Reading from a framebuffer is only allowed for the type 'uint8'")})));var c=0,l=0,d=a.framebufferWidth,m=a.framebufferHeight,p=null;e(u)?p=u:u&&(_.type(u,"object","invalid arguments to regl.read()"),c=0|u.x,l=0|u.y,_(c>=0&&c<a.framebufferWidth,"invalid x offset for regl.read"),_(l>=0&&l<a.framebufferHeight,"invalid y offset for regl.read"),d=0|(u.width||a.framebufferWidth-c),m=0|(u.height||a.framebufferHeight-l),p=u.data||null),p&&(s===Dt?_(p instanceof Uint8Array,"buffer must be 'Uint8Array' when reading from a framebuffer of type 'uint8'"):s===jt&&_(p instanceof Float32Array,"buffer must be 'Float32Array' when reading from a framebuffer of type 'float'")),_(d>0&&d+c<=a.framebufferWidth,"invalid width for read pixels"),_(m>0&&m+l<=a.framebufferHeight,"invalid height for read pixels"),n();var h=d*m*4;return p||(s===Dt?p=new Uint8Array(h):s===jt&&(p=p||new Float32Array(h))),_.isTypedArray(p,"data buffer for regl.read() must be a typedarray"),_(p.byteLength>=h,"data buffer for regl.read() too small"),t.pixelStorei(3333,4),t.readPixels(c,l,d,m,6408,s,p),p}return function(e){return e&&"framebuffer"in e?function(e){var t;return r.setFBO({framebuffer:e.framebuffer},(function(){t=u(e)})),t}(e):u(e)}}function zt(e){return Array.prototype.slice.call(e)}function Ft(e){return zt(e).join("")}var Bt="xyzw".split(""),Vt="dither",It="blend.enable",Pt="blend.color",Lt="blend.equation",Rt="blend.func",Mt="depth.enable",Wt="depth.func",Ut="depth.range",Gt="depth.mask",Ht="colorMask",Nt="cull.enable",qt="cull.face",Qt="frontFace",Yt="lineWidth",Xt="polygonOffset.enable",$t="polygonOffset.offset",Kt="sample.alpha",Jt="sample.enable",Zt="sample.coverage",er="stencil.enable",tr="stencil.mask",rr="stencil.func",nr="stencil.opFront",ar="stencil.opBack",ir="scissor.enable",or="scissor.box",fr="viewport",ur="profile",sr="framebuffer",cr="vert",lr="frag",dr="elements",mr="primitive",pr="count",hr="offset",br="instances",vr="vao",gr="Width",yr="Height",xr=sr+gr,wr=sr+yr,Ar="drawingBufferWidth",_r="drawingBufferHeight",kr=[Rt,Lt,rr,nr,ar,Zt,fr,or,$t],Sr=34962,Or=34963,Er=5126,Tr=35664,Dr=35665,jr=35666,Cr=5124,zr=35667,Fr=35668,Br=35669,Vr=35670,Ir=35671,Pr=35672,Lr=35673,Rr=35674,Mr=35675,Wr=35676,Ur=35678,Gr=35680,Hr=1028,Nr=1029,qr=2305,Qr=7680,Yr={0:0,1:1,zero:0,one:1,"src color":768,"one minus src color":769,"src alpha":770,"one minus src alpha":771,"dst color":774,"one minus dst color":775,"dst alpha":772,"one minus dst alpha":773,"constant color":32769,"one minus constant color":32770,"constant alpha":32771,"one minus constant alpha":32772,"src alpha saturate":776},Xr=["constant color, constant alpha","one minus constant color, constant alpha","constant color, one minus constant alpha","one minus constant color, one minus constant alpha","constant alpha, constant color","constant alpha, one minus constant color","one minus constant alpha, constant color","one minus constant alpha, one minus constant color"],$r={never:512,less:513,"<":513,equal:514,"=":514,"==":514,"===":514,lequal:515,"<=":515,greater:516,">":516,notequal:517,"!=":517,"!==":517,gequal:518,">=":518,always:519},Kr={0:0,zero:0,keep:7680,replace:7681,increment:7682,decrement:7683,"increment wrap":34055,"decrement wrap":34056,invert:5386},Jr={frag:35632,vert:35633},Zr={cw:2304,ccw:qr};function en(t){return Array.isArray(t)||e(t)||G(t)}function tn(e){return e.sort((function(e,t){return e===fr?-1:t===fr?1:e<t?-1:1}))}function rn(e,t,r,n){this.thisDep=e,this.contextDep=t,this.propDep=r,this.append=n}function nn(e){return e&&!(e.thisDep||e.contextDep||e.propDep)}function an(e){return new rn(!1,!1,!1,e)}function on(e,t){var r=e.type;if(0===r){var n=e.data.length;return new rn(!0,n>=1,n>=2,t)}if(4===r){var a=e.data;return new rn(a.thisDep,a.contextDep,a.propDep,t)}if(5===r)return new rn(!1,!1,!1,t);if(6===r){for(var i=!1,o=!1,f=!1,u=0;u<e.data.length;++u){var s=e.data[u];if(1===s.type)f=!0;else if(2===s.type)o=!0;else if(3===s.type)i=!0;else if(0===s.type){i=!0;var c=s.data;c>=1&&(o=!0),c>=2&&(f=!0)}else 4===s.type&&(i=i||s.data.thisDep,o=o||s.data.contextDep,f=f||s.data.propDep)}return new rn(i,o,f,t)}return new rn(3===r,2===r,1===r,t)}var fn=new rn(!1,!1,!1,(function(){}));function un(e,r,n,a,i,o,f,u,s,c,l,d,m,p,h){var b=c.Record,v={add:32774,subtract:32778,"reverse subtract":32779};n.ext_blend_minmax&&(v.min=32775,v.max=32776);var g=n.angle_instanced_arrays,y=n.webgl_draw_buffers,x=n.oes_vertex_array_object,w={dirty:!0,profile:h.profile},A={},k=[],S={},O={};function E(e){return e.replace(".","_")}function T(e,t,r){var n=E(e);k.push(e),A[n]=w[n]=!!r,S[n]=t}function j(e,t,r){var n=E(e);k.push(e),Array.isArray(r)?(w[n]=r.slice(),A[n]=r.slice()):w[n]=A[n]=r,O[n]=t}T(Vt,3024),T(It,3042),j(Pt,"blendColor",[0,0,0,0]),j(Lt,"blendEquationSeparate",[32774,32774]),j(Rt,"blendFuncSeparate",[1,0,1,0]),T(Mt,2929,!0),j(Wt,"depthFunc",513),j(Ut,"depthRange",[0,1]),j(Gt,"depthMask",!0),j(Ht,Ht,[!0,!0,!0,!0]),T(Nt,2884),j(qt,"cullFace",Nr),j(Qt,Qt,qr),j(Yt,Yt,1),T(Xt,32823),j($t,"polygonOffset",[0,0]),T(Kt,32926),T(Jt,32928),j(Zt,"sampleCoverage",[1,!1]),T(er,2960),j(tr,"stencilMask",-1),j(rr,"stencilFunc",[519,0,-1]),j(nr,"stencilOpSeparate",[Hr,Qr,Qr,Qr]),j(ar,"stencilOpSeparate",[Nr,Qr,Qr,Qr]),T(ir,3089),j(or,"scissor",[0,0,e.drawingBufferWidth,e.drawingBufferHeight]),j(fr,fr,[0,0,e.drawingBufferWidth,e.drawingBufferHeight]);var C={gl:e,context:m,strings:r,next:A,current:w,draw:d,elements:o,buffer:i,shader:l,attributes:c.state,vao:c,uniforms:s,framebuffer:u,extensions:n,timer:p,isBufferArgs:en},z={primTypes:ie,compareFuncs:$r,blendFuncs:Yr,blendEquations:v,stencilOps:Kr,glTypes:X,orientationType:Zr};_.optional((function(){C.isArrayLike=me})),y&&(z.backBuffer=[Nr],z.drawBuffer=V(a.maxDrawbuffers,(function(e){return 0===e?[0]:V(e,(function(e){return 36064+e}))})));var F=0;function B(){var e=function(){var e=0,r=[],n=[];function a(){var r=[],n=[];return t((function(){r.push.apply(r,zt(arguments))}),{def:function(){var t="v"+e++;return n.push(t),arguments.length>0&&(r.push(t,"="),r.push.apply(r,zt(arguments)),r.push(";")),t},toString:function(){return Ft([n.length>0?"var "+n.join(",")+";":"",Ft(r)])}})}function i(){var e=a(),r=a(),n=e.toString,i=r.toString;function o(t,n){r(t,n,"=",e.def(t,n),";")}return t((function(){e.apply(e,zt(arguments))}),{def:e.def,entry:e,exit:r,save:o,set:function(t,r,n){o(t,r),e(t,r,"=",n,";")},toString:function(){return n()+i()}})}var o=a(),f={};return{global:o,link:function(t){for(var a=0;a<n.length;++a)if(n[a]===t)return r[a];var i="g"+e++;return r.push(i),n.push(t),i},block:a,proc:function(e,r){var n=[];function a(){var e="a"+n.length;return n.push(e),e}r=r||0;for(var o=0;o<r;++o)a();var u=i(),s=u.toString;return f[e]=t(u,{arg:a,toString:function(){return Ft(["function(",n.join(),"){",s(),"}"])}})},scope:i,cond:function(){var e=Ft(arguments),r=i(),n=i(),a=r.toString,o=n.toString;return t(r,{then:function(){return r.apply(r,zt(arguments)),this},else:function(){return n.apply(n,zt(arguments)),this},toString:function(){var t=o();return t&&(t="else{"+t+"}"),Ft(["if(",e,"){",a(),"}",t])}})},compile:function(){var e=['"use strict";',o,"return {"];Object.keys(f).forEach((function(t){e.push('"',t,'":',f[t].toString(),",")})),e.push("}");var t=Ft(e).replace(/;/g,";\n").replace(/}/g,"}\n").replace(/{/g,"{\n");return Function.apply(null,r.concat(t)).apply(null,n)}}}(),n=e.link,a=e.global;e.id=F++,e.batchId="0";var i=n(C),o=e.shared={props:"a0"};Object.keys(C).forEach((function(e){o[e]=a.def(i,".",e)})),_.optional((function(){e.CHECK=n(_),e.commandStr=_.guessCommand(),e.command=n(e.commandStr),e.assert=function(e,t,r){e("if(!(",t,"))",this.CHECK,".commandRaise(",n(r),",",this.command,");")},z.invalidBlendCombinations=Xr}));var f=e.next={},u=e.current={};Object.keys(O).forEach((function(e){Array.isArray(w[e])&&(f[e]=a.def(o.next,".",e),u[e]=a.def(o.current,".",e))}));var s=e.constants={};Object.keys(z).forEach((function(e){s[e]=a.def(JSON.stringify(z[e]))})),e.invoke=function(t,r){switch(r.type){case 0:var a=["this",o.context,o.props,e.batchId];return t.def(n(r.data),".call(",a.slice(0,Math.max(r.data.length+1,4)),")");case 1:return t.def(o.props,r.data);case 2:return t.def(o.context,r.data);case 3:return t.def("this",r.data);case 4:return r.data.append(e,t),r.data.ref;case 5:return r.data.toString();case 6:return r.data.map((function(r){return e.invoke(t,r)}))}},e.attribCache={};var l={};return e.scopeAttrib=function(e){var t=r.id(e);if(t in l)return l[t];var a=c.scope[t];return a||(a=c.scope[t]=new b),l[t]=n(a)},e}function I(e,t,f,s,d){var m=e.static,p=e.dynamic;_.optional((function(){var e=[sr,cr,lr,dr,mr,hr,pr,br,ur,vr].concat(k);function t(t){Object.keys(t).forEach((function(t){_.command(e.indexOf(t)>=0,'unknown parameter "'+t+'"',d.commandStr)}))}t(m),t(p)}));var h=function(e,t){var r=e.static;if("string"==typeof r[lr]&&"string"==typeof r[cr]){if(Object.keys(t.dynamic).length>0)return null;var n=t.static,a=Object.keys(n);if(a.length>0&&"number"==typeof n[a[0]]){for(var i=[],o=0;o<a.length;++o)_("number"==typeof n[a[o]],"must specify all vertex attribute locations when using vaos"),i.push([0|n[a[o]],a[o]]);return i}}return null}(e,t),y=function(e,t){var r=e.static,n=e.dynamic;if(sr in r){var a=r[sr];return a?(a=u.getFramebuffer(a),_.command(a,"invalid framebuffer object"),an((function(e,t){var r=e.link(a),n=e.shared;t.set(n.framebuffer,".next",r);var i=n.context;return t.set(i,"."+xr,r+".width"),t.set(i,"."+wr,r+".height"),r}))):an((function(e,t){var r=e.shared;t.set(r.framebuffer,".next","null");var n=r.context;return t.set(n,"."+xr,n+"."+Ar),t.set(n,"."+wr,n+"."+_r),"null"}))}if(sr in n){var i=n[sr];return on(i,(function(e,t){var r=e.invoke(t,i),n=e.shared,a=n.framebuffer,o=t.def(a,".getFramebuffer(",r,")");_.optional((function(){e.assert(t,"!"+r+"||"+o,"invalid framebuffer object")})),t.set(a,".next",o);var f=n.context;return t.set(f,"."+xr,o+"?"+o+".width:"+f+"."+Ar),t.set(f,"."+wr,o+"?"+o+".height:"+f+"."+_r),o}))}return null}(e),x=function(e,t,r){var n=e.static,a=e.dynamic;function i(e){if(e in n){var i=n[e];_.commandType(i,"object","invalid "+e,r.commandStr);var o,f,u=!0,s=0|i.x,c=0|i.y;return"width"in i?(o=0|i.width,_.command(o>=0,"invalid "+e,r.commandStr)):u=!1,"height"in i?(f=0|i.height,_.command(f>=0,"invalid "+e,r.commandStr)):u=!1,new rn(!u&&t&&t.thisDep,!u&&t&&t.contextDep,!u&&t&&t.propDep,(function(e,t){var r=e.shared.context,n=o;"width"in i||(n=t.def(r,".",xr,"-",s));var a=f;return"height"in i||(a=t.def(r,".",wr,"-",c)),[s,c,n,a]}))}if(e in a){var l=a[e],d=on(l,(function(t,r){var n=t.invoke(r,l);_.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid "+e)}));var a=t.shared.context,i=r.def(n,".x|0"),o=r.def(n,".y|0"),f=r.def('"width" in ',n,"?",n,".width|0:","(",a,".",xr,"-",i,")"),u=r.def('"height" in ',n,"?",n,".height|0:","(",a,".",wr,"-",o,")");return _.optional((function(){t.assert(r,f+">=0&&"+u+">=0","invalid "+e)})),[i,o,f,u]}));return t&&(d.thisDep=d.thisDep||t.thisDep,d.contextDep=d.contextDep||t.contextDep,d.propDep=d.propDep||t.propDep),d}return t?new rn(t.thisDep,t.contextDep,t.propDep,(function(e,t){var r=e.shared.context;return[0,0,t.def(r,".",xr),t.def(r,".",wr)]})):null}var o=i(fr);if(o){var f=o;o=new rn(o.thisDep,o.contextDep,o.propDep,(function(e,t){var r=f.append(e,t),n=e.shared.context;return t.set(n,".viewportWidth",r[2]),t.set(n,".viewportHeight",r[3]),r}))}return{viewport:o,scissor_box:i(or)}}(e,y,d),w=function(e,t){var r=e.static,n=e.dynamic,a={},i=!1,f=function(){if(vr in r){var e=r[vr];return null!==e&&null===c.getVAO(e)&&(e=c.createVAO(e)),i=!0,a.vao=e,an((function(t){var r=c.getVAO(e);return r?t.link(r):"null"}))}if(vr in n){i=!0;var t=n[vr];return on(t,(function(e,r){var n=e.invoke(r,t);return r.def(e.shared.vao+".getVAO("+n+")")}))}return null}(),u=!1,s=function(){if(dr in r){var e=r[dr];if(a.elements=e,en(e)){var s=a.elements=o.create(e,!0);e=o.getElements(s),u=!0}else e&&(e=o.getElements(e),u=!0,_.command(e,"invalid elements",t.commandStr));var c=an((function(t,r){if(e){var n=t.link(e);return t.ELEMENTS=n,n}return t.ELEMENTS=null,null}));return c.value=e,c}if(dr in n){u=!0;var l=n[dr];return on(l,(function(e,t){var r=e.shared,n=r.isBufferArgs,a=r.elements,i=e.invoke(t,l),o=t.def("null"),f=t.def(n,"(",i,")"),u=e.cond(f).then(o,"=",a,".createStream(",i,");").else(o,"=",a,".getElements(",i,");");return _.optional((function(){e.assert(u.else,"!"+i+"||"+o,"invalid elements")})),t.entry(u),t.exit(e.cond(f).then(a,".destroyStream(",o,");")),e.ELEMENTS=o,o}))}return i?new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.elements+".getElements("+e.shared.vao+".currentVAO.elements):null")})):null}();function l(e,o){if(e in r){var s=0|r[e];return o?a.offset=s:a.instances=s,_.command(!o||s>=0,"invalid "+e,t.commandStr),an((function(e,t){return o&&(e.OFFSET=s),s}))}if(e in n){var c=n[e];return on(c,(function(t,r){var n=t.invoke(r,c);return o&&(t.OFFSET=n,_.optional((function(){t.assert(r,n+">=0","invalid "+e)}))),n}))}if(o){if(u)return an((function(e,t){return e.OFFSET=0,0}));if(i)return new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.offset:0")}))}else if(i)return new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.instances:-1")}));return null}var d=l(hr,!0),m=function(){if(mr in r){var e=r[mr];return a.primitive=e,_.commandParameter(e,ie,"invalid primitve",t.commandStr),an((function(t,r){return ie[e]}))}if(mr in n){var o=n[mr];return on(o,(function(e,t){var r=e.constants.primTypes,n=e.invoke(t,o);return _.optional((function(){e.assert(t,n+" in "+r,"invalid primitive, must be one of "+Object.keys(ie))})),t.def(r,"[",n,"]")}))}return u?nn(s)?s.value?an((function(e,t){return t.def(e.ELEMENTS,".primType")})):an((function(){return 4})):new rn(s.thisDep,s.contextDep,s.propDep,(function(e,t){var r=e.ELEMENTS;return t.def(r,"?",r,".primType:",4)})):i?new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.primitive:4")})):null}(),p=function(){if(pr in r){var e=0|r[pr];return a.count=e,_.command("number"==typeof e&&e>=0,"invalid vertex count",t.commandStr),an((function(){return e}))}if(pr in n){var o=n[pr];return on(o,(function(e,t){var r=e.invoke(t,o);return _.optional((function(){e.assert(t,"typeof "+r+'==="number"&&'+r+">=0&&"+r+"===("+r+"|0)","invalid vertex count")})),r}))}if(u){if(nn(s)){if(s)return d?new rn(d.thisDep,d.contextDep,d.propDep,(function(e,t){var r=t.def(e.ELEMENTS,".vertCount-",e.OFFSET);return _.optional((function(){e.assert(t,r+">=0","invalid vertex offset/element buffer too small")})),r})):an((function(e,t){return t.def(e.ELEMENTS,".vertCount")}));var c=an((function(){return-1}));return _.optional((function(){c.MISSING=!0})),c}var l=new rn(s.thisDep||d.thisDep,s.contextDep||d.contextDep,s.propDep||d.propDep,(function(e,t){var r=e.ELEMENTS;return e.OFFSET?t.def(r,"?",r,".vertCount-",e.OFFSET,":-1"):t.def(r,"?",r,".vertCount:-1")}));return _.optional((function(){l.DYNAMIC=!0})),l}return i?new rn(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao,".currentVAO?",e.shared.vao,".currentVAO.count:-1")})):null}(),h=l(br,!1);return{elements:s,primitive:m,count:p,instances:h,offset:d,vao:f,vaoActive:i,elementsActive:u,static:a}}(e,d),A=function(e,t){var r=e.static,n=e.dynamic,i={};return k.forEach((function(e){var o=E(e);function f(t,a){if(e in r){var f=t(r[e]);i[o]=an((function(){return f}))}else if(e in n){var u=n[e];i[o]=on(u,(function(e,t){return a(e,t,e.invoke(t,u))}))}}switch(e){case Nt:case It:case Vt:case er:case Mt:case ir:case Xt:case Kt:case Jt:case Gt:return f((function(r){return _.commandType(r,"boolean",e,t.commandStr),r}),(function(t,r,n){return _.optional((function(){t.assert(r,"typeof "+n+'==="boolean"',"invalid flag "+e,t.commandStr)})),n}));case Wt:return f((function(r){return _.commandParameter(r,$r,"invalid "+e,t.commandStr),$r[r]}),(function(t,r,n){var a=t.constants.compareFuncs;return _.optional((function(){t.assert(r,n+" in "+a,"invalid "+e+", must be one of "+Object.keys($r))})),r.def(a,"[",n,"]")}));case Ut:return f((function(e){return _.command(me(e)&&2===e.length&&"number"==typeof e[0]&&"number"==typeof e[1]&&e[0]<=e[1],"depth range is 2d array",t.commandStr),e}),(function(e,t,r){return _.optional((function(){e.assert(t,e.shared.isArrayLike+"("+r+")&&"+r+".length===2&&typeof "+r+'[0]==="number"&&typeof '+r+'[1]==="number"&&'+r+"[0]<="+r+"[1]","depth range must be a 2d array")})),[t.def("+",r,"[0]"),t.def("+",r,"[1]")]}));case Rt:return f((function(e){_.commandType(e,"object","blend.func",t.commandStr);var r="srcRGB"in e?e.srcRGB:e.src,n="srcAlpha"in e?e.srcAlpha:e.src,a="dstRGB"in e?e.dstRGB:e.dst,i="dstAlpha"in e?e.dstAlpha:e.dst;return _.commandParameter(r,Yr,o+".srcRGB",t.commandStr),_.commandParameter(n,Yr,o+".srcAlpha",t.commandStr),_.commandParameter(a,Yr,o+".dstRGB",t.commandStr),_.commandParameter(i,Yr,o+".dstAlpha",t.commandStr),_.command(-1===Xr.indexOf(r+", "+a),"unallowed blending combination (srcRGB, dstRGB) = ("+r+", "+a+")",t.commandStr),[Yr[r],Yr[a],Yr[n],Yr[i]]}),(function(t,r,n){var a=t.constants.blendFuncs;function i(i,o){var f=r.def('"',i,o,'" in ',n,"?",n,".",i,o,":",n,".",i);return _.optional((function(){t.assert(r,f+" in "+a,"invalid "+e+"."+i+o+", must be one of "+Object.keys(Yr))})),f}_.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid blend func, must be an object")}));var o=i("src","RGB"),f=i("dst","RGB");_.optional((function(){var e=t.constants.invalidBlendCombinations;t.assert(r,e+".indexOf("+o+'+", "+'+f+") === -1 ","unallowed blending combination for (srcRGB, dstRGB)")}));var u=r.def(a,"[",o,"]"),s=r.def(a,"[",i("src","Alpha"),"]");return[u,r.def(a,"[",f,"]"),s,r.def(a,"[",i("dst","Alpha"),"]")]}));case Lt:return f((function(r){return"string"==typeof r?(_.commandParameter(r,v,"invalid "+e,t.commandStr),[v[r],v[r]]):"object"==typeof r?(_.commandParameter(r.rgb,v,e+".rgb",t.commandStr),_.commandParameter(r.alpha,v,e+".alpha",t.commandStr),[v[r.rgb],v[r.alpha]]):void _.commandRaise("invalid blend.equation",t.commandStr)}),(function(t,r,n){var a=t.constants.blendEquations,i=r.def(),o=r.def(),f=t.cond("typeof ",n,'==="string"');return _.optional((function(){function r(e,r,n){t.assert(e,n+" in "+a,"invalid "+r+", must be one of "+Object.keys(v))}r(f.then,e,n),t.assert(f.else,n+"&&typeof "+n+'==="object"',"invalid "+e),r(f.else,e+".rgb",n+".rgb"),r(f.else,e+".alpha",n+".alpha")})),f.then(i,"=",o,"=",a,"[",n,"];"),f.else(i,"=",a,"[",n,".rgb];",o,"=",a,"[",n,".alpha];"),r(f),[i,o]}));case Pt:return f((function(e){return _.command(me(e)&&4===e.length,"blend.color must be a 4d array",t.commandStr),V(4,(function(t){return+e[t]}))}),(function(e,t,r){return _.optional((function(){e.assert(t,e.shared.isArrayLike+"("+r+")&&"+r+".length===4","blend.color must be a 4d array")})),V(4,(function(e){return t.def("+",r,"[",e,"]")}))}));case tr:return f((function(e){return _.commandType(e,"number",o,t.commandStr),0|e}),(function(e,t,r){return _.optional((function(){e.assert(t,"typeof "+r+'==="number"',"invalid stencil.mask")})),t.def(r,"|0")}));case rr:return f((function(r){_.commandType(r,"object",o,t.commandStr);var n=r.cmp||"keep",a=r.ref||0,i="mask"in r?r.mask:-1;return _.commandParameter(n,$r,e+".cmp",t.commandStr),_.commandType(a,"number",e+".ref",t.commandStr),_.commandType(i,"number",e+".mask",t.commandStr),[$r[n],a,i]}),(function(e,t,r){var n=e.constants.compareFuncs;return _.optional((function(){function a(){e.assert(t,Array.prototype.join.call(arguments,""),"invalid stencil.func")}a(r+"&&typeof ",r,'==="object"'),a('!("cmp" in ',r,")||(",r,".cmp in ",n,")")})),[t.def('"cmp" in ',r,"?",n,"[",r,".cmp]",":",Qr),t.def(r,".ref|0"),t.def('"mask" in ',r,"?",r,".mask|0:-1")]}));case nr:case ar:return f((function(r){_.commandType(r,"object",o,t.commandStr);var n=r.fail||"keep",a=r.zfail||"keep",i=r.zpass||"keep";return _.commandParameter(n,Kr,e+".fail",t.commandStr),_.commandParameter(a,Kr,e+".zfail",t.commandStr),_.commandParameter(i,Kr,e+".zpass",t.commandStr),[e===ar?Nr:Hr,Kr[n],Kr[a],Kr[i]]}),(function(t,r,n){var a=t.constants.stencilOps;function i(i){return _.optional((function(){t.assert(r,'!("'+i+'" in '+n+")||("+n+"."+i+" in "+a+")","invalid "+e+"."+i+", must be one of "+Object.keys(Kr))})),r.def('"',i,'" in ',n,"?",a,"[",n,".",i,"]:",Qr)}return _.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid "+e)})),[e===ar?Nr:Hr,i("fail"),i("zfail"),i("zpass")]}));case $t:return f((function(e){_.commandType(e,"object",o,t.commandStr);var r=0|e.factor,n=0|e.units;return _.commandType(r,"number",o+".factor",t.commandStr),_.commandType(n,"number",o+".units",t.commandStr),[r,n]}),(function(t,r,n){return _.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid "+e)})),[r.def(n,".factor|0"),r.def(n,".units|0")]}));case qt:return f((function(e){var r=0;return"front"===e?r=Hr:"back"===e&&(r=Nr),_.command(!!r,o,t.commandStr),r}),(function(e,t,r){return _.optional((function(){e.assert(t,r+'==="front"||'+r+'==="back"',"invalid cull.face")})),t.def(r,'==="front"?',Hr,":",Nr)}));case Yt:return f((function(e){return _.command("number"==typeof e&&e>=a.lineWidthDims[0]&&e<=a.lineWidthDims[1],"invalid line width, must be a positive number between "+a.lineWidthDims[0]+" and "+a.lineWidthDims[1],t.commandStr),e}),(function(e,t,r){return _.optional((function(){e.assert(t,"typeof "+r+'==="number"&&'+r+">="+a.lineWidthDims[0]+"&&"+r+"<="+a.lineWidthDims[1],"invalid line width")})),r}));case Qt:return f((function(e){return _.commandParameter(e,Zr,o,t.commandStr),Zr[e]}),(function(e,t,r){return _.optional((function(){e.assert(t,r+'==="cw"||'+r+'==="ccw"',"invalid frontFace, must be one of cw,ccw")})),t.def(r+'==="cw"?2304:'+qr)}));case Ht:return f((function(e){return _.command(me(e)&&4===e.length,"color.mask must be length 4 array",t.commandStr),e.map((function(e){return!!e}))}),(function(e,t,r){return _.optional((function(){e.assert(t,e.shared.isArrayLike+"("+r+")&&"+r+".length===4","invalid color.mask")})),V(4,(function(e){return"!!"+r+"["+e+"]"}))}));case Zt:return f((function(e){_.command("object"==typeof e&&e,o,t.commandStr);var r="value"in e?e.value:1,n=!!e.invert;return _.command("number"==typeof r&&r>=0&&r<=1,"sample.coverage.value must be a number between 0 and 1",t.commandStr),[r,n]}),(function(e,t,r){return _.optional((function(){e.assert(t,r+"&&typeof "+r+'==="object"',"invalid sample.coverage")})),[t.def('"value" in ',r,"?+",r,".value:1"),t.def("!!",r,".invert")]}))}})),i}(e,d),S=function(e,t,n){var a=e.static,i=e.dynamic;function o(e){if(e in a){var t=r.id(a[e]);_.optional((function(){l.shader(Jr[e],t,_.guessCommand())}));var n=an((function(){return t}));return n.id=t,n}if(e in i){var o=i[e];return on(o,(function(t,r){var n=t.invoke(r,o),a=r.def(t.shared.strings,".id(",n,")");return _.optional((function(){r(t.shared.shader,".shader(",Jr[e],",",a,",",t.command,");")})),a}))}return null}var f,u=o(lr),s=o(cr),c=null;return nn(u)&&nn(s)?(c=l.program(s.id,u.id,null,n),f=an((function(e,t){return e.link(c)}))):f=new rn(u&&u.thisDep||s&&s.thisDep,u&&u.contextDep||s&&s.contextDep,u&&u.propDep||s&&s.propDep,(function(e,t){var r,n=e.shared.shader;r=u?u.append(e,t):t.def(n,".",lr);var a=n+".program("+(s?s.append(e,t):t.def(n,".",cr))+","+r;return _.optional((function(){a+=","+e.command})),t.def(a+")")})),{frag:u,vert:s,progVar:f,program:c}}(e,0,h);function O(e){var t=x[e];t&&(A[e]=t)}O(fr),O(E(or));var T=Object.keys(A).length>0,D={framebuffer:y,draw:w,shader:S,state:A,dirty:T,scopeVAO:null,drawVAO:null,useVAO:!1,attributes:{}};if(D.profile=function(e){var t,r=e.static,n=e.dynamic;if(ur in r){var a=!!r[ur];(t=an((function(e,t){return a}))).enable=a}else if(ur in n){var i=n[ur];t=on(i,(function(e,t){return e.invoke(t,i)}))}return t}(e),D.uniforms=function(e,t){var r=e.static,n=e.dynamic,a={};return Object.keys(r).forEach((function(e){var n,i=r[e];if("number"==typeof i||"boolean"==typeof i)n=an((function(){return i}));else if("function"==typeof i){var o=i._reglType;"texture2d"===o||"textureCube"===o?n=an((function(e){return e.link(i)})):"framebuffer"===o||"framebufferCube"===o?(_.command(i.color.length>0,'missing color attachment for framebuffer sent to uniform "'+e+'"',t.commandStr),n=an((function(e){return e.link(i.color[0])}))):_.commandRaise('invalid data for uniform "'+e+'"',t.commandStr)}else me(i)?n=an((function(t){return t.global.def("[",V(i.length,(function(r){return _.command("number"==typeof i[r]||"boolean"==typeof i[r],"invalid uniform "+e,t.commandStr),i[r]})),"]")})):_.commandRaise('invalid or missing data for uniform "'+e+'"',t.commandStr);n.value=i,a[e]=n})),Object.keys(n).forEach((function(e){var t=n[e];a[e]=on(t,(function(e,r){return e.invoke(r,t)}))})),a}(f,d),D.drawVAO=D.scopeVAO=w.vao,!D.drawVAO&&S.program&&!h&&n.angle_instanced_arrays&&w.static.elements){var j=!0,C=S.program.attributes.map((function(e){var r=t.static[e];return j=j&&!!r,r}));if(j&&C.length>0){var z=c.getVAO(c.createVAO({attributes:C,elements:w.static.elements}));D.drawVAO=new rn(null,null,null,(function(e,t){return e.link(z)})),D.useVAO=!0}}return h?D.useVAO=!0:D.attributes=function(e,t){var n=e.static,a=e.dynamic,o={};return Object.keys(n).forEach((function(e){var a=n[e],f=r.id(e),u=new b;if(en(a))u.state=1,u.buffer=i.getBuffer(i.create(a,Sr,!1,!0)),u.type=0;else{var s=i.getBuffer(a);if(s)u.state=1,u.buffer=s,u.type=0;else if(_.command("object"==typeof a&&a,"invalid data for attribute "+e,t.commandStr),"constant"in a){var c=a.constant;u.buffer="null",u.state=2,"number"==typeof c?u.x=c:(_.command(me(c)&&c.length>0&&c.length<=4,"invalid constant for attribute "+e,t.commandStr),Bt.forEach((function(e,t){t<c.length&&(u[e]=c[t])})))}else{s=en(a.buffer)?i.getBuffer(i.create(a.buffer,Sr,!1,!0)):i.getBuffer(a.buffer),_.command(!!s,'missing buffer for attribute "'+e+'"',t.commandStr);var l=0|a.offset;_.command(l>=0,'invalid offset for attribute "'+e+'"',t.commandStr);var d=0|a.stride;_.command(d>=0&&d<256,'invalid stride for attribute "'+e+'", must be integer betweeen [0, 255]',t.commandStr);var m=0|a.size;_.command(!("size"in a)||m>0&&m<=4,'invalid size for attribute "'+e+'", must be 1,2,3,4',t.commandStr);var p=!!a.normalized,h=0;"type"in a&&(_.commandParameter(a.type,X,"invalid type for attribute "+e,t.commandStr),h=X[a.type]);var v=0|a.divisor;_.optional((function(){"divisor"in a&&(_.command(0===v||g,'cannot specify divisor for attribute "'+e+'", instancing not supported',t.commandStr),_.command(v>=0,'invalid divisor for attribute "'+e+'"',t.commandStr));var r=t.commandStr,n=["buffer","offset","divisor","normalized","type","size","stride"];Object.keys(a).forEach((function(t){_.command(n.indexOf(t)>=0,'unknown parameter "'+t+'" for attribute pointer "'+e+'" (valid parameters are '+n+")",r)}))})),u.buffer=s,u.state=1,u.size=m,u.normalized=p,u.type=h||s.dtype,u.offset=l,u.stride=d,u.divisor=v}}o[e]=an((function(e,t){var r=e.attribCache;if(f in r)return r[f];var n={isStream:!1};return Object.keys(u).forEach((function(e){n[e]=u[e]})),u.buffer&&(n.buffer=e.link(u.buffer),n.type=n.type||n.buffer+".dtype"),r[f]=n,n}))})),Object.keys(a).forEach((function(e){var t=a[e];o[e]=on(t,(function(r,n){var a=r.invoke(n,t),i=r.shared,o=r.constants,f=i.isBufferArgs,u=i.buffer;_.optional((function(){r.assert(n,a+"&&(typeof "+a+'==="object"||typeof '+a+'==="function")&&('+f+"("+a+")||"+u+".getBuffer("+a+")||"+u+".getBuffer("+a+".buffer)||"+f+"("+a+'.buffer)||("constant" in '+a+"&&(typeof "+a+'.constant==="number"||'+i.isArrayLike+"("+a+".constant))))",'invalid dynamic attribute "'+e+'"')}));var s={isStream:n.def(!1)},c=new b;c.state=1,Object.keys(c).forEach((function(e){s[e]=n.def(""+c[e])}));var l=s.buffer,d=s.type;function m(e){n(s[e],"=",a,".",e,"|0;")}return n("if(",f,"(",a,")){",s.isStream,"=true;",l,"=",u,".createStream(",Sr,",",a,");",d,"=",l,".dtype;","}else{",l,"=",u,".getBuffer(",a,");","if(",l,"){",d,"=",l,".dtype;",'}else if("constant" in ',a,"){",s.state,"=",2,";","if(typeof "+a+'.constant === "number"){',s[Bt[0]],"=",a,".constant;",Bt.slice(1).map((function(e){return s[e]})).join("="),"=0;","}else{",Bt.map((function(e,t){return s[e]+"="+a+".constant.length>"+t+"?"+a+".constant["+t+"]:0;"})).join(""),"}}else{","if(",f,"(",a,".buffer)){",l,"=",u,".createStream(",Sr,",",a,".buffer);","}else{",l,"=",u,".getBuffer(",a,".buffer);","}",d,'="type" in ',a,"?",o.glTypes,"[",a,".type]:",l,".dtype;",s.normalized,"=!!",a,".normalized;"),m("size"),m("offset"),m("stride"),m("divisor"),n("}}"),n.exit("if(",s.isStream,"){",u,".destroyStream(",l,");","}"),s}))})),o}(t,d),D.context=function(e){var t=e.static,r=e.dynamic,n={};return Object.keys(t).forEach((function(e){var r=t[e];n[e]=an((function(e,t){return"number"==typeof r||"boolean"==typeof r?""+r:e.link(r)}))})),Object.keys(r).forEach((function(e){var t=r[e];n[e]=on(t,(function(e,r){return e.invoke(r,t)}))})),n}(s),D}function P(e,t,r){var n=e.shared.context,a=e.scope();Object.keys(r).forEach((function(i){t.save(n,"."+i);var o=r[i].append(e,t);Array.isArray(o)?a(n,".",i,"=[",o.join(),"];"):a(n,".",i,"=",o,";")})),t(a)}function L(e,t,r,n){var a,i=e.shared,o=i.gl,f=i.framebuffer;y&&(a=t.def(i.extensions,".webgl_draw_buffers"));var u,s=e.constants,c=s.drawBuffer,l=s.backBuffer;u=r?r.append(e,t):t.def(f,".next"),n||t("if(",u,"!==",f,".cur){"),t("if(",u,"){",o,".bindFramebuffer(",36160,",",u,".framebuffer);"),y&&t(a,".drawBuffersWEBGL(",c,"[",u,".colorAttachments.length]);"),t("}else{",o,".bindFramebuffer(",36160,",null);"),y&&t(a,".drawBuffersWEBGL(",l,");"),t("}",f,".cur=",u,";"),n||t("}")}function R(e,t,r){var n=e.shared,a=n.gl,i=e.current,o=e.next,f=n.current,u=n.next,s=e.cond(f,".dirty");k.forEach((function(t){var n,c,l=E(t);if(!(l in r.state))if(l in o){n=o[l],c=i[l];var d=V(w[l].length,(function(e){return s.def(n,"[",e,"]")}));s(e.cond(d.map((function(e,t){return e+"!=="+c+"["+t+"]"})).join("||")).then(a,".",O[l],"(",d,");",d.map((function(e,t){return c+"["+t+"]="+e})).join(";"),";"))}else{n=s.def(u,".",l);var m=e.cond(n,"!==",f,".",l);s(m),l in S?m(e.cond(n).then(a,".enable(",S[l],");").else(a,".disable(",S[l],");"),f,".",l,"=",n,";"):m(a,".",O[l],"(",n,");",f,".",l,"=",n,";")}})),0===Object.keys(r.state).length&&s(f,".dirty=false;"),t(s)}function M(e,t,r,n){var a=e.shared,i=e.current,o=a.current,f=a.gl;tn(Object.keys(r)).forEach((function(a){var u=r[a];if(!n||n(u)){var s=u.append(e,t);if(S[a]){var c=S[a];nn(u)?t(f,s?".enable(":".disable(",c,");"):t(e.cond(s).then(f,".enable(",c,");").else(f,".disable(",c,");")),t(o,".",a,"=",s,";")}else if(me(s)){var l=i[a];t(f,".",O[a],"(",s,");",s.map((function(e,t){return l+"["+t+"]="+e})).join(";"),";")}else t(f,".",O[a],"(",s,");",o,".",a,"=",s,";")}}))}function W(e,t){g&&(e.instancing=t.def(e.shared.extensions,".angle_instanced_arrays"))}function U(e,t,r,n,a){var i,o,f,u=e.shared,s=e.stats,c=u.current,l=u.timer,d=r.profile;function m(){return"undefined"==typeof performance?"Date.now()":"performance.now()"}function h(e){e(i=t.def(),"=",m(),";"),"string"==typeof a?e(s,".count+=",a,";"):e(s,".count++;"),p&&(n?e(o=t.def(),"=",l,".getNumPendingQueries();"):e(l,".beginQuery(",s,");"))}function b(e){e(s,".cpuTime+=",m(),"-",i,";"),p&&(n?e(l,".pushScopeStats(",o,",",l,".getNumPendingQueries(),",s,");"):e(l,".endQuery();"))}function v(e){var r=t.def(c,".profile");t(c,".profile=",e,";"),t.exit(c,".profile=",r,";")}if(d){if(nn(d))return void(d.enable?(h(t),b(t.exit),v("true")):v("false"));v(f=d.append(e,t))}else f=t.def(c,".profile");var g=e.block();h(g),t("if(",f,"){",g,"}");var y=e.block();b(y),t.exit("if(",f,"){",y,"}")}function G(e,t,r,n,a){var i=e.shared;n.forEach((function(n){var o,f=n.name,u=r.attributes[f];if(u){if(!a(u))return;o=u.append(e,t)}else{if(!a(fn))return;var s=e.scopeAttrib(f);_.optional((function(){e.assert(t,s+".state","missing attribute "+f)})),o={},Object.keys(new b).forEach((function(e){o[e]=t.def(s,".",e)}))}!function(r,n,a){var o=i.gl,f=t.def(r,".location"),u=t.def(i.attributes,"[",f,"]"),s=a.state,c=a.buffer,l=[a.x,a.y,a.z,a.w],d=["buffer","normalized","offset","stride"];function m(){t("if(!",u,".buffer){",o,".enableVertexAttribArray(",f,");}");var r,i=a.type;if(r=a.size?t.def(a.size,"||",n):n,t("if(",u,".type!==",i,"||",u,".size!==",r,"||",d.map((function(e){return u+"."+e+"!=="+a[e]})).join("||"),"){",o,".bindBuffer(",Sr,",",c,".buffer);",o,".vertexAttribPointer(",[f,r,i,a.normalized,a.stride,a.offset],");",u,".type=",i,";",u,".size=",r,";",d.map((function(e){return u+"."+e+"="+a[e]+";"})).join(""),"}"),g){var s=a.divisor;t("if(",u,".divisor!==",s,"){",e.instancing,".vertexAttribDivisorANGLE(",[f,s],");",u,".divisor=",s,";}")}}function p(){t("if(",u,".buffer){",o,".disableVertexAttribArray(",f,");",u,".buffer=null;","}if(",Bt.map((function(e,t){return u+"."+e+"!=="+l[t]})).join("||"),"){",o,".vertexAttrib4f(",f,",",l,");",Bt.map((function(e,t){return u+"."+e+"="+l[t]+";"})).join(""),"}")}1===s?m():2===s?p():(t("if(",s,"===",1,"){"),m(),t("}else{"),p(),t("}"))}(e.link(n),function(e){switch(e){case Tr:case zr:case Ir:return 2;case Dr:case Fr:case Pr:return 3;case jr:case Br:case Lr:return 4;default:return 1}}(n.info.type),o)}))}function H(e,t,n,a,i,o){for(var f,u=e.shared,s=u.gl,c={},l=0;l<a.length;++l){var d=a[l],m=d.name,p=d.info.type,h=d.info.size,b=n.uniforms[m];if(h>1){if(!b)continue;var v=m.replace("[0]","");if(c[v])continue;c[v]=1}var g,y=e.link(d)+".location";if(b){if(!i(b))continue;if(nn(b)){var x=b.value;if(_.command(null!=x,'missing uniform "'+m+'"',e.commandStr),p===Ur||p===Gr){_.command("function"==typeof x&&(p===Ur&&("texture2d"===x._reglType||"framebuffer"===x._reglType)||p===Gr&&("textureCube"===x._reglType||"framebufferCube"===x._reglType)),"invalid texture for uniform "+m,e.commandStr);var w=e.link(x._texture||x.color[0]._texture);t(s,".uniform1i(",y,",",w+".bind());"),t.exit(w,".unbind();")}else if(p===Rr||p===Mr||p===Wr){_.optional((function(){_.command(me(x),"invalid matrix for uniform "+m,e.commandStr),_.command(p===Rr&&4===x.length||p===Mr&&9===x.length||p===Wr&&16===x.length,"invalid length for matrix uniform "+m,e.commandStr)}));var A=e.global.def("new Float32Array(["+Array.prototype.slice.call(x)+"])"),k=2;p===Mr?k=3:p===Wr&&(k=4),t(s,".uniformMatrix",k,"fv(",y,",false,",A,");")}else{switch(p){case Er:1===h?_.commandType(x,"number","uniform "+m,e.commandStr):_.command(me(x)&&x.length===h,"uniform "+m,e.commandStr),f="1f";break;case Tr:_.command(me(x)&&x.length&&x.length%2==0&&x.length<=2*h,"uniform "+m,e.commandStr),f="2f";break;case Dr:_.command(me(x)&&x.length&&x.length%3==0&&x.length<=3*h,"uniform "+m,e.commandStr),f="3f";break;case jr:_.command(me(x)&&x.length&&x.length%4==0&&x.length<=4*h,"uniform "+m,e.commandStr),f="4f";break;case Vr:1===h?_.commandType(x,"boolean","uniform "+m,e.commandStr):_.command(me(x)&&x.length===h,"uniform "+m,e.commandStr),f="1i";break;case Cr:1===h?_.commandType(x,"number","uniform "+m,e.commandStr):_.command(me(x)&&x.length===h,"uniform "+m,e.commandStr),f="1i";break;case Ir:case zr:_.command(me(x)&&x.length&&x.length%2==0&&x.length<=2*h,"uniform "+m,e.commandStr),f="2i";break;case Pr:case Fr:_.command(me(x)&&x.length&&x.length%3==0&&x.length<=3*h,"uniform "+m,e.commandStr),f="3i";break;case Lr:case Br:_.command(me(x)&&x.length&&x.length%4==0&&x.length<=4*h,"uniform "+m,e.commandStr),f="4i"}h>1?(f+="v",x=e.global.def("["+Array.prototype.slice.call(x)+"]")):x=me(x)?Array.prototype.slice.call(x):x,t(s,".uniform",f,"(",y,",",x,");")}continue}g=b.append(e,t)}else{if(!i(fn))continue;g=t.def(u.uniforms,"[",r.id(m),"]")}p===Ur?(_(!Array.isArray(g),"must specify a scalar prop for textures"),t("if(",g,"&&",g,'._reglType==="framebuffer"){',g,"=",g,".color[0];","}")):p===Gr&&(_(!Array.isArray(g),"must specify a scalar prop for cube maps"),t("if(",g,"&&",g,'._reglType==="framebufferCube"){',g,"=",g,".color[0];","}")),_.optional((function(){function r(r,n){e.assert(t,r,'bad data or missing for uniform "'+m+'".  '+n)}function n(e,t){1===t&&_(!Array.isArray(g),"must not specify an array type for uniform"),r("Array.isArray("+g+") && typeof "+g+'[0]===" '+e+'" || typeof '+g+'==="'+e+'"',"invalid type, expected "+e)}function a(t,n,a){Array.isArray(g)?_(g.length&&g.length%t==0&&g.length<=t*a,"must have length of "+(1===a?"":"n * ")+t):r(u.isArrayLike+"("+g+")&&"+g+".length && "+g+".length % "+t+" === 0 && "+g+".length<="+t*a,"invalid vector, should have length of "+(1===a?"":"n * ")+t,e.commandStr)}function i(t){_(!Array.isArray(g),"must not specify a value type"),r("typeof "+g+'==="function"&&'+g+'._reglType==="texture'+(3553===t?"2d":"Cube")+'"',"invalid texture type",e.commandStr)}switch(p){case Cr:n("number",h);break;case zr:a(2,0,h);break;case Fr:a(3,0,h);break;case Br:a(4,0,h);break;case Er:n("number",h);break;case Tr:a(2,0,h);break;case Dr:a(3,0,h);break;case jr:a(4,0,h);break;case Vr:n("boolean",h);break;case Ir:a(2,0,h);break;case Pr:a(3,0,h);break;case Lr:case Rr:a(4,0,h);break;case Mr:a(9,0,h);break;case Wr:a(16,0,h);break;case Ur:i(3553);break;case Gr:i(34067)}}));var S=1;switch(p){case Ur:case Gr:var O=t.def(g,"._texture");t(s,".uniform1i(",y,",",O,".bind());"),t.exit(O,".unbind();");continue;case Cr:case Vr:f="1i";break;case zr:case Ir:f="2i",S=2;break;case Fr:case Pr:f="3i",S=3;break;case Br:case Lr:f="4i",S=4;break;case Er:f="1f";break;case Tr:f="2f",S=2;break;case Dr:f="3f",S=3;break;case jr:f="4f",S=4;break;case Rr:f="Matrix2fv";break;case Mr:f="Matrix3fv";break;case Wr:f="Matrix4fv"}if(-1===f.indexOf("Matrix")&&h>1&&(f+="v",S=1),"M"===f.charAt(0)){t(s,".uniform",f,"(",y,",");var E=Math.pow(p-Rr+2,2),T=e.global.def("new Float32Array(",E,")");Array.isArray(g)?t("false,(",V(E,(function(e){return T+"["+e+"]="+g[e]})),",",T,")"):t("false,(Array.isArray(",g,")||",g," instanceof Float32Array)?",g,":(",V(E,(function(e){return T+"["+e+"]="+g+"["+e+"]"})),",",T,")"),t(");")}else if(S>1){for(var D=[],j=[],C=0;C<S;++C)Array.isArray(g)?j.push(g[C]):j.push(t.def(g+"["+C+"]")),o&&D.push(t.def());o&&t("if(!",e.batchId,"||",D.map((function(e,t){return e+"!=="+j[t]})).join("||"),"){",D.map((function(e,t){return e+"="+j[t]+";"})).join("")),t(s,".uniform",f,"(",y,",",j.join(","),");"),o&&t("}")}else{if(_(!Array.isArray(g),"uniform value must not be an array"),o){var z=t.def();t("if(!",e.batchId,"||",z,"!==",g,"){",z,"=",g,";")}t(s,".uniform",f,"(",y,",",g,");"),o&&t("}")}}}function N(e,t,r,n){var a=e.shared,i=a.gl,o=a.draw,f=n.draw,u=function(){var u,s=f.elements,c=t;return s?((s.contextDep&&n.contextDynamic||s.propDep)&&(c=r),u=s.append(e,c),f.elementsActive&&c("if("+u+")"+i+".bindBuffer(34963,"+u+".buffer.buffer);")):(u=c.def(),c(u,"=",o,".",dr,";","if(",u,"){",i,".bindBuffer(",Or,",",u,".buffer.buffer);}","else if(",a.vao,".currentVAO){",u,"=",e.shared.elements+".getElements("+a.vao,".currentVAO.elements);",x?"":"if("+u+")"+i+".bindBuffer(34963,"+u+".buffer.buffer);","}")),u}();function s(a){var i=f[a];return i?i.contextDep&&n.contextDynamic||i.propDep?i.append(e,r):i.append(e,t):t.def(o,".",a)}var c,l,d=s(mr),m=s(hr),p=function(){var a,i=f.count,u=t;return i?((i.contextDep&&n.contextDynamic||i.propDep)&&(u=r),a=i.append(e,u),_.optional((function(){i.MISSING&&e.assert(t,"false","missing vertex count"),i.DYNAMIC&&e.assert(u,a+">=0","missing vertex count")}))):(a=u.def(o,".",pr),_.optional((function(){e.assert(u,a+">=0","missing vertex count")}))),a}();if("number"==typeof p){if(0===p)return}else r("if(",p,"){"),r.exit("}");g&&(c=s(br),l=e.instancing);var h=u+".type",b=f.elements&&nn(f.elements)&&!f.vaoActive;function v(){function e(){r(l,".drawElementsInstancedANGLE(",[d,p,h,m+"<<(("+h+"-5121)>>1)",c],");")}function t(){r(l,".drawArraysInstancedANGLE(",[d,m,p,c],");")}u&&"null"!==u?b?e():(r("if(",u,"){"),e(),r("}else{"),t(),r("}")):t()}function y(){function e(){r(i+".drawElements("+[d,p,h,m+"<<(("+h+"-5121)>>1)"]+");")}function t(){r(i+".drawArrays("+[d,m,p]+");")}u&&"null"!==u?b?e():(r("if(",u,"){"),e(),r("}else{"),t(),r("}")):t()}g&&("number"!=typeof c||c>=0)?"string"==typeof c?(r("if(",c,">0){"),v(),r("}else if(",c,"<0){"),y(),r("}")):v():y()}function q(e,t,r,n,a){var i=B(),o=i.proc("body",a);return _.optional((function(){i.commandStr=t.commandStr,i.command=i.link(t.commandStr)})),g&&(i.instancing=o.def(i.shared.extensions,".angle_instanced_arrays")),e(i,o,r,n),i.compile().body}function Q(e,t,r,n){W(e,t),r.useVAO?r.drawVAO?t(e.shared.vao,".setVAO(",r.drawVAO.append(e,t),");"):t(e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"):(t(e.shared.vao,".setVAO(null);"),G(e,t,r,n.attributes,(function(){return!0}))),H(e,t,r,n.uniforms,(function(){return!0}),!1),N(e,t,t,r)}function Y(e,t,r,n){function a(){return!0}e.batchId="a1",W(e,t),G(e,t,r,n.attributes,a),H(e,t,r,n.uniforms,a,!1),N(e,t,t,r)}function $(e,t,r,n){W(e,t);var a=r.contextDep,i=t.def(),o=t.def();e.shared.props=o,e.batchId=i;var f=e.scope(),u=e.scope();function s(e){return e.contextDep&&a||e.propDep}function c(e){return!s(e)}if(t(f.entry,"for(",i,"=0;",i,"<","a1",";++",i,"){",o,"=","a0","[",i,"];",u,"}",f.exit),r.needsContext&&P(e,u,r.context),r.needsFramebuffer&&L(e,u,r.framebuffer),M(e,u,r.state,s),r.profile&&s(r.profile)&&U(e,u,r,!1,!0),n)r.useVAO?r.drawVAO?s(r.drawVAO)?u(e.shared.vao,".setVAO(",r.drawVAO.append(e,u),");"):f(e.shared.vao,".setVAO(",r.drawVAO.append(e,f),");"):f(e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"):(f(e.shared.vao,".setVAO(null);"),G(e,f,r,n.attributes,c),G(e,u,r,n.attributes,s)),H(e,f,r,n.uniforms,c,!1),H(e,u,r,n.uniforms,s,!0),N(e,f,u,r);else{var l=e.global.def("{}"),d=r.shader.progVar.append(e,u),m=u.def(d,".id"),p=u.def(l,"[",m,"]");u(e.shared.gl,".useProgram(",d,".program);","if(!",p,"){",p,"=",l,"[",m,"]=",e.link((function(t){return q(Y,e,r,t,2)})),"(",d,");}",p,".call(this,a0[",i,"],",i,");")}}function K(e,t,r){var n=t.static[r];if(n&&function(e){if("object"==typeof e&&!me(e)){for(var t=Object.keys(e),r=0;r<t.length;++r)if(D.isDynamic(e[t[r]]))return!0;return!1}}(n)){var a=e.global,i=Object.keys(n),o=!1,f=!1,u=!1,s=e.global.def("{}");i.forEach((function(t){var r=n[t];if(D.isDynamic(r)){"function"==typeof r&&(r=n[t]=D.unbox(r));var i=on(r,null);o=o||i.thisDep,u=u||i.propDep,f=f||i.contextDep}else{switch(a(s,".",t,"="),typeof r){case"number":a(r);break;case"string":a('"',r,'"');break;case"object":Array.isArray(r)&&a("[",r.join(),"]");break;default:a(e.link(r))}a(";")}})),t.dynamic[r]=new D.DynamicVariable(4,{thisDep:o,contextDep:f,propDep:u,ref:s,append:function(e,t){i.forEach((function(r){var a=n[r];if(D.isDynamic(a)){var i=e.invoke(t,a);t(s,".",r,"=",i,";")}}))}}),delete t.static[r]}}return{next:A,current:w,procs:function(){var e=B(),t=e.proc("poll"),r=e.proc("refresh"),i=e.block();t(i),r(i);var o,f=e.shared,u=f.gl,s=f.next,c=f.current;i(c,".dirty=false;"),L(e,t),L(e,r,null,!0),g&&(o=e.link(g)),n.oes_vertex_array_object&&r(e.link(n.oes_vertex_array_object),".bindVertexArrayOES(null);");for(var l=0;l<a.maxAttributes;++l){var d=r.def(f.attributes,"[",l,"]"),m=e.cond(d,".buffer");m.then(u,".enableVertexAttribArray(",l,");",u,".bindBuffer(",Sr,",",d,".buffer.buffer);",u,".vertexAttribPointer(",l,",",d,".size,",d,".type,",d,".normalized,",d,".stride,",d,".offset);").else(u,".disableVertexAttribArray(",l,");",u,".vertexAttrib4f(",l,",",d,".x,",d,".y,",d,".z,",d,".w);",d,".buffer=null;"),r(m),g&&r(o,".vertexAttribDivisorANGLE(",l,",",d,".divisor);")}return r(e.shared.vao,".currentVAO=null;",e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"),Object.keys(S).forEach((function(n){var a=S[n],o=i.def(s,".",n),f=e.block();f("if(",o,"){",u,".enable(",a,")}else{",u,".disable(",a,")}",c,".",n,"=",o,";"),r(f),t("if(",o,"!==",c,".",n,"){",f,"}")})),Object.keys(O).forEach((function(n){var a,o,f=O[n],l=w[n],d=e.block();if(d(u,".",f,"("),me(l)){var m=l.length;a=e.global.def(s,".",n),o=e.global.def(c,".",n),d(V(m,(function(e){return a+"["+e+"]"})),");",V(m,(function(e){return o+"["+e+"]="+a+"["+e+"];"})).join("")),t("if(",V(m,(function(e){return a+"["+e+"]!=="+o+"["+e+"]"})).join("||"),"){",d,"}")}else a=i.def(s,".",n),o=i.def(c,".",n),d(a,");",c,".",n,"=",a,";"),t("if(",a,"!==",o,"){",d,"}");r(d)})),e.compile()}(),compile:function(e,n,a,i,o){var f=B();f.stats=f.link(o),Object.keys(n.static).forEach((function(e){K(f,n,e)})),kr.forEach((function(t){K(f,e,t)}));var u=I(e,n,a,i,f);return function(e,t){var r=e.proc("draw",1);W(e,r),P(e,r,t.context),L(e,r,t.framebuffer),R(e,r,t),M(e,r,t.state),U(e,r,t,!1,!0);var n=t.shader.progVar.append(e,r);if(r(e.shared.gl,".useProgram(",n,".program);"),t.shader.program)Q(e,r,t,t.shader.program);else{r(e.shared.vao,".setVAO(null);");var a=e.global.def("{}"),i=r.def(n,".id"),o=r.def(a,"[",i,"]");r(e.cond(o).then(o,".call(this,a0);").else(o,"=",a,"[",i,"]=",e.link((function(r){return q(Q,e,t,r,1)})),"(",n,");",o,".call(this,a0);"))}Object.keys(t.state).length>0&&r(e.shared.current,".dirty=true;"),e.shared.vao&&r(e.shared.vao,".setVAO(null);")}(f,u),function(e,t){var n=e.proc("scope",3);e.batchId="a2";var a=e.shared,i=a.current;function o(r){var i=t.shader[r];i&&n.set(a.shader,"."+r,i.append(e,n))}P(e,n,t.context),t.framebuffer&&t.framebuffer.append(e,n),tn(Object.keys(t.state)).forEach((function(r){var i=t.state[r].append(e,n);me(i)?i.forEach((function(t,a){n.set(e.next[r],"["+a+"]",t)})):n.set(a.next,"."+r,i)})),U(e,n,t,!0,!0),[dr,hr,pr,br,mr].forEach((function(r){var i=t.draw[r];i&&n.set(a.draw,"."+r,""+i.append(e,n))})),Object.keys(t.uniforms).forEach((function(i){var o=t.uniforms[i].append(e,n);Array.isArray(o)&&(o="["+o.join()+"]"),n.set(a.uniforms,"["+r.id(i)+"]",o)})),Object.keys(t.attributes).forEach((function(r){var a=t.attributes[r].append(e,n),i=e.scopeAttrib(r);Object.keys(new b).forEach((function(e){n.set(i,"."+e,a[e])}))})),t.scopeVAO&&n.set(a.vao,".targetVAO",t.scopeVAO.append(e,n)),o(cr),o(lr),Object.keys(t.state).length>0&&(n(i,".dirty=true;"),n.exit(i,".dirty=true;")),n("a1(",e.shared.context,",a0,",e.batchId,");")}(f,u),function(e,t){var r=e.proc("batch",2);e.batchId="0",W(e,r);var n=!1,a=!0;Object.keys(t.context).forEach((function(e){n=n||t.context[e].propDep})),n||(P(e,r,t.context),a=!1);var i=t.framebuffer,o=!1;function f(e){return e.contextDep&&n||e.propDep}i?(i.propDep?n=o=!0:i.contextDep&&n&&(o=!0),o||L(e,r,i)):L(e,r,null),t.state.viewport&&t.state.viewport.propDep&&(n=!0),R(e,r,t),M(e,r,t.state,(function(e){return!f(e)})),t.profile&&f(t.profile)||U(e,r,t,!1,"a1"),t.contextDep=n,t.needsContext=a,t.needsFramebuffer=o;var u=t.shader.progVar;if(u.contextDep&&n||u.propDep)$(e,r,t,null);else{var s=u.append(e,r);if(r(e.shared.gl,".useProgram(",s,".program);"),t.shader.program)$(e,r,t,t.shader.program);else{r(e.shared.vao,".setVAO(null);");var c=e.global.def("{}"),l=r.def(s,".id"),d=r.def(c,"[",l,"]");r(e.cond(d).then(d,".call(this,a0,a1);").else(d,"=",c,"[",l,"]=",e.link((function(r){return q($,e,t,r,2)})),"(",s,");",d,".call(this,a0,a1);"))}}Object.keys(t.state).length>0&&r(e.shared.current,".dirty=true;"),e.shared.vao&&r(e.shared.vao,".setVAO(null);")}(f,u),t(f.compile(),{destroy:function(){u.shader.program.destroy()}})}}}var sn=function(e,t){if(!t.ext_disjoint_timer_query)return null;var r=[];function n(e){r.push(e)}var a=[];function i(){this.startQueryIndex=-1,this.endQueryIndex=-1,this.sum=0,this.stats=null}var o=[];function f(e){o.push(e)}var u=[];function s(e,t,r){var n=o.pop()||new i;n.startQueryIndex=e,n.endQueryIndex=t,n.sum=0,n.stats=r,u.push(n)}var c=[],l=[];return{beginQuery:function(e){var n=r.pop()||t.ext_disjoint_timer_query.createQueryEXT();t.ext_disjoint_timer_query.beginQueryEXT(35007,n),a.push(n),s(a.length-1,a.length,e)},endQuery:function(){t.ext_disjoint_timer_query.endQueryEXT(35007)},pushScopeStats:s,update:function(){var e,r,i=a.length;if(0!==i){l.length=Math.max(l.length,i+1),c.length=Math.max(c.length,i+1),c[0]=0,l[0]=0;var o=0;for(e=0,r=0;r<a.length;++r){var s=a[r];t.ext_disjoint_timer_query.getQueryObjectEXT(s,34919)?(o+=t.ext_disjoint_timer_query.getQueryObjectEXT(s,34918),n(s)):a[e++]=s,c[r+1]=o,l[r+1]=e}for(a.length=e,e=0,r=0;r<u.length;++r){var d=u[r],m=d.startQueryIndex,p=d.endQueryIndex;d.sum+=c[p]-c[m];var h=l[m],b=l[p];b===h?(d.stats.gpuTime+=d.sum/1e6,f(d)):(d.startQueryIndex=h,d.endQueryIndex=b,u[e++]=d)}u.length=e}},getNumPendingQueries:function(){return a.length},clear:function(){r.push.apply(r,a);for(var e=0;e<r.length;e++)t.ext_disjoint_timer_query.deleteQueryEXT(r[e]);a.length=0,r.length=0},restore:function(){a.length=0,r.length=0}}},cn="webglcontextlost",ln="webglcontextrestored";function dn(e,t){for(var r=0;r<e.length;++r)if(e[r]===t)return r;return-1}return function(r){var n=B(r);if(!n)return null;var a=n.gl,i=a.getContextAttributes(),o=a.isContextLost(),f=function(e,t){var r={};function n(t){_.type(t,"string","extension name must be string");var n,a=t.toLowerCase();try{n=r[a]=e.getExtension(a)}catch(e){}return!!n}for(var a=0;a<t.extensions.length;++a){var i=t.extensions[a];if(!n(i))return t.onDestroy(),t.onDone('"'+i+'" extension is not supported by the current WebGL context, try upgrading your system or a different browser'),null}return t.optionalExtensions.forEach(n),{extensions:r,restore:function(){Object.keys(r).forEach((function(e){if(r[e]&&!n(e))throw new Error("(regl): error restoring extension "+e)}))}}}(a,n);if(!f)return null;var u,s,c=(u={"":0},s=[""],{id:function(e){var t=u[e];return t||(t=u[e]=s.length,s.push(e),t)},str:function(e){return s[e]}}),l={vaoCount:0,bufferCount:0,elementsCount:0,framebufferCount:0,shaderCount:0,textureCount:0,cubeCount:0,renderbufferCount:0,maxTextureUnits:0},d=f.extensions,m=sn(0,d),p=C(),h=a.drawingBufferWidth,b=a.drawingBufferHeight,v={tick:0,time:0,viewportWidth:h,viewportHeight:b,framebufferWidth:h,framebufferHeight:b,drawingBufferWidth:h,drawingBufferHeight:b,pixelRatio:n.pixelRatio},g={elements:null,primitive:4,count:-1,offset:0,instances:-1},y=function(e,t){var r=1;t.ext_texture_filter_anisotropic&&(r=e.getParameter(34047));var n=1,a=1;t.webgl_draw_buffers&&(n=e.getParameter(34852),a=e.getParameter(36063));var i=!!t.oes_texture_float;if(i){var o=e.createTexture();e.bindTexture(R,o),e.texImage2D(R,0,M,1,1,0,M,W,null);var f=e.createFramebuffer();if(e.bindFramebuffer(U,f),e.framebufferTexture2D(U,36064,R,o,0),e.bindTexture(R,null),36053!==e.checkFramebufferStatus(U))i=!1;else{e.viewport(0,0,1,1),e.clearColor(1,0,0,1),e.clear(16384);var u=L.allocType(W,4);e.readPixels(0,0,1,1,M,W,u),e.getError()?i=!1:(e.deleteFramebuffer(f),e.deleteTexture(o),i=1===u[0]),L.freeType(u)}}var s=!0;if("undefined"==typeof navigator||!(/MSIE/.test(navigator.userAgent)||/Trident\//.test(navigator.appVersion)||/Edge/.test(navigator.userAgent))){var c=e.createTexture(),l=L.allocType(5121,36);e.activeTexture(33984),e.bindTexture(34067,c),e.texImage2D(34069,0,M,3,3,0,M,5121,l),L.freeType(l),e.bindTexture(34067,null),e.deleteTexture(c),s=!e.getError()}return{colorBits:[e.getParameter(3410),e.getParameter(3411),e.getParameter(3412),e.getParameter(3413)],depthBits:e.getParameter(3414),stencilBits:e.getParameter(3415),subpixelBits:e.getParameter(3408),extensions:Object.keys(t).filter((function(e){return!!t[e]})),maxAnisotropic:r,maxDrawbuffers:n,maxColorAttachments:a,pointSizeDims:e.getParameter(33901),lineWidthDims:e.getParameter(33902),maxViewportDims:e.getParameter(3386),maxCombinedTextureUnits:e.getParameter(35661),maxCubeMapSize:e.getParameter(34076),maxRenderbufferSize:e.getParameter(34024),maxTextureUnits:e.getParameter(34930),maxTextureSize:e.getParameter(3379),maxAttributes:e.getParameter(34921),maxVertexUniforms:e.getParameter(36347),maxVertexTextureUnits:e.getParameter(35660),maxVaryingVectors:e.getParameter(36348),maxFragmentUniforms:e.getParameter(36349),glsl:e.getParameter(35724),renderer:e.getParameter(7937),vendor:e.getParameter(7936),version:e.getParameter(7938),readFloat:i,npotTextureCube:s}}(a,d),x=function(t,r,n,a){var i=0,o={};function f(e){this.id=i++,this.buffer=t.createBuffer(),this.type=e,this.usage=35044,this.byteLength=0,this.dimension=1,this.dtype=Z,this.persistentData=null,n.profile&&(this.stats={size:0})}f.prototype.bind=function(){t.bindBuffer(this.type,this.buffer)},f.prototype.destroy=function(){l(this)};var u=[];function s(e,r,n){e.byteLength=r.byteLength,t.bufferData(e.type,r,n)}function c(t,r,n,a,i,o){var f,u;if(t.usage=n,Array.isArray(r)){if(t.dtype=a||ee,r.length>0)if(Array.isArray(r[0])){f=J(r);for(var c=1,l=1;l<f.length;++l)c*=f[l];t.dimension=c,s(t,u=K(r,f,t.dtype),n),o?t.persistentData=u:L.freeType(u)}else if("number"==typeof r[0]){t.dimension=i;var d=L.allocType(t.dtype,r.length);ne(d,r),s(t,d,n),o?t.persistentData=d:L.freeType(d)}else e(r[0])?(t.dimension=r[0].length,t.dtype=a||re(r[0])||ee,s(t,u=K(r,[r.length,r[0].length],t.dtype),n),o?t.persistentData=u:L.freeType(u)):_.raise("invalid buffer data")}else if(e(r))t.dtype=a||re(r),t.dimension=i,s(t,r,n),o&&(t.persistentData=new Uint8Array(new Uint8Array(r.buffer)));else if(G(r)){f=r.shape;var m=r.stride,p=r.offset,h=0,b=0,v=0,g=0;1===f.length?(h=f[0],b=1,v=m[0],g=0):2===f.length?(h=f[0],b=f[1],v=m[0],g=m[1]):_.raise("invalid shape"),t.dtype=a||re(r.data)||ee,t.dimension=b;var y=L.allocType(t.dtype,h*b);ae(y,r.data,h,b,v,g,p),s(t,y,n),o?t.persistentData=y:L.freeType(y)}else r instanceof ArrayBuffer?(t.dtype=Z,t.dimension=i,s(t,r,n),o&&(t.persistentData=new Uint8Array(new Uint8Array(r)))):_.raise("invalid buffer data")}function l(e){r.bufferCount--,a(e);var n=e.buffer;_(n,"buffer must not be deleted already"),t.deleteBuffer(n),e.buffer=null,delete o[e.id]}return n.profile&&(r.getTotalBufferSize=function(){var e=0;return Object.keys(o).forEach((function(t){e+=o[t].stats.size})),e}),{create:function(a,i,u,s){r.bufferCount++;var d=new f(i);function m(r){var a=35044,i=null,o=0,f=0,u=1;return Array.isArray(r)||e(r)||G(r)||r instanceof ArrayBuffer?i=r:"number"==typeof r?o=0|r:r&&(_.type(r,"object","buffer arguments must be an object, a number or an array"),"data"in r&&(_(null===i||Array.isArray(i)||e(i)||G(i),"invalid data for buffer"),i=r.data),"usage"in r&&(_.parameter(r.usage,$,"invalid buffer usage"),a=$[r.usage]),"type"in r&&(_.parameter(r.type,X,"invalid buffer type"),f=X[r.type]),"dimension"in r&&(_.type(r.dimension,"number","invalid dimension"),u=0|r.dimension),"length"in r&&(_.nni(o,"buffer length must be a nonnegative integer"),o=0|r.length)),d.bind(),i?c(d,i,a,f,u,s):(o&&t.bufferData(d.type,o,a),d.dtype=f||Z,d.usage=a,d.dimension=u,d.byteLength=o),n.profile&&(d.stats.size=d.byteLength*te[d.dtype]),m}function p(e,r){_(r+e.byteLength<=d.byteLength,"invalid buffer subdata call, buffer is too small.  Can't write data of size "+e.byteLength+" starting from offset "+r+" to a buffer of size "+d.byteLength),t.bufferSubData(d.type,r,e)}return o[d.id]=d,u||m(a),m._reglType="buffer",m._buffer=d,m.subdata=function(t,r){var n,a=0|(r||0);if(d.bind(),e(t)||t instanceof ArrayBuffer)p(t,a);else if(Array.isArray(t)){if(t.length>0)if("number"==typeof t[0]){var i=L.allocType(d.dtype,t.length);ne(i,t),p(i,a),L.freeType(i)}else if(Array.isArray(t[0])||e(t[0])){n=J(t);var o=K(t,n,d.dtype);p(o,a),L.freeType(o)}else _.raise("invalid buffer data")}else if(G(t)){n=t.shape;var f=t.stride,u=0,s=0,c=0,l=0;1===n.length?(u=n[0],s=1,c=f[0],l=0):2===n.length?(u=n[0],s=n[1],c=f[0],l=f[1]):_.raise("invalid shape");var h=Array.isArray(t.data)?d.dtype:re(t.data),b=L.allocType(h,u*s);ae(b,t.data,u,s,c,l,t.offset),p(b,a),L.freeType(b)}else _.raise("invalid data for buffer subdata");return m},n.profile&&(m.stats=d.stats),m.destroy=function(){l(d)},m},createStream:function(e,t){var r=u.pop();return r||(r=new f(e)),r.bind(),c(r,t,35040,0,1,!1),r},destroyStream:function(e){u.push(e)},clear:function(){H(o).forEach(l),u.forEach(l)},getBuffer:function(e){return e&&e._buffer instanceof f?e._buffer:null},restore:function(){H(o).forEach((function(e){e.buffer=t.createBuffer(),t.bindBuffer(e.type,e.buffer),t.bufferData(e.type,e.persistentData||e.byteLength,e.usage)}))},_initBuffer:c}}(a,l,n,(function(e){return A.destroyBuffer(e)})),w=function(t,r,n,a){var i={},o=0,f={uint8:oe,uint16:fe};function u(e){this.id=o++,i[this.id]=this,this.buffer=e,this.primType=4,this.vertCount=0,this.type=0}r.oes_element_index_uint&&(f.uint32=ue),u.prototype.bind=function(){this.buffer.bind()};var s=[];function c(a,i,o,f,u,s,c){var l;if(a.buffer.bind(),i){var d=c;c||e(i)&&(!G(i)||e(i.data))||(d=r.oes_element_index_uint?ue:fe),n._initBuffer(a.buffer,i,o,d,3)}else t.bufferData(se,s,o),a.buffer.dtype=l||oe,a.buffer.usage=o,a.buffer.dimension=3,a.buffer.byteLength=s;if(l=c,!c){switch(a.buffer.dtype){case oe:case 5120:l=oe;break;case fe:case 5122:l=fe;break;case ue:case 5124:l=ue;break;default:_.raise("unsupported type for element array")}a.buffer.dtype=l}a.type=l,_(l!==ue||!!r.oes_element_index_uint,"32 bit element buffers not supported, enable oes_element_index_uint first");var m=u;m<0&&(m=a.buffer.byteLength,l===fe?m>>=1:l===ue&&(m>>=2)),a.vertCount=m;var p=f;if(f<0){p=4;var h=a.buffer.dimension;1===h&&(p=0),2===h&&(p=1),3===h&&(p=4)}a.primType=p}function l(e){a.elementsCount--,_(null!==e.buffer,"must not double destroy elements"),delete i[e.id],e.buffer.destroy(),e.buffer=null}return{create:function(t,r){var i=n.create(null,se,!0),o=new u(i._buffer);function s(t){if(t)if("number"==typeof t)i(t),o.primType=4,o.vertCount=0|t,o.type=oe;else{var r=null,n=35044,a=-1,u=-1,l=0,d=0;Array.isArray(t)||e(t)||G(t)?r=t:(_.type(t,"object","invalid arguments for elements"),"data"in t&&(r=t.data,_(Array.isArray(r)||e(r)||G(r),"invalid data for element buffer")),"usage"in t&&(_.parameter(t.usage,$,"invalid element buffer usage"),n=$[t.usage]),"primitive"in t&&(_.parameter(t.primitive,ie,"invalid element buffer primitive"),a=ie[t.primitive]),"count"in t&&(_("number"==typeof t.count&&t.count>=0,"invalid vertex count for elements"),u=0|t.count),"type"in t&&(_.parameter(t.type,f,"invalid buffer type"),d=f[t.type]),"length"in t?l=0|t.length:(l=u,d===fe||5122===d?l*=2:d!==ue&&5124!==d||(l*=4))),c(o,r,n,a,u,l,d)}else i(),o.primType=4,o.vertCount=0,o.type=oe;return s}return a.elementsCount++,s(t),s._reglType="elements",s._elements=o,s.subdata=function(e,t){return i.subdata(e,t),s},s.destroy=function(){l(o)},s},createStream:function(e){var t=s.pop();return t||(t=new u(n.create(null,se,!0,!1)._buffer)),c(t,e,35040,-1,-1,0,0),t},destroyStream:function(e){s.push(e)},getElements:function(e){return"function"==typeof e&&e._elements instanceof u?e._elements:null},clear:function(){H(i).forEach(l)}}}(a,d,x,l),A=function(t,r,n,a,i,o,f){for(var u=n.maxAttributes,s=new Array(u),c=0;c<u;++c)s[c]=new Tt;var l=0,d={},m={Record:Tt,scope:{},state:s,currentVAO:null,targetVAO:null,restore:p()?function(){p()&&H(d).forEach((function(e){e.refresh()}))}:function(){},createVAO:function(t){var n=new b;function f(t){var a;if(Array.isArray(t))a=t,n.elements&&n.ownsElements&&n.elements.destroy(),n.elements=null,n.ownsElements=!1,n.offset=0,n.count=0,n.instances=-1,n.primitive=4;else{if(_("object"==typeof t,"invalid arguments for create vao"),_("attributes"in t,"must specify attributes for vao"),t.elements){var s=t.elements;n.ownsElements?"function"==typeof s&&"elements"===s._reglType?(n.elements.destroy(),n.ownsElements=!1):(n.elements(s),n.ownsElements=!1):o.getElements(t.elements)?(n.elements=t.elements,n.ownsElements=!1):(n.elements=o.create(t.elements),n.ownsElements=!0)}else n.elements=null,n.ownsElements=!1;a=t.attributes,n.offset=0,n.count=-1,n.instances=-1,n.primitive=4,n.elements&&(n.count=n.elements._elements.vertCount,n.primitive=n.elements._elements.primType),"offset"in t&&(n.offset=0|t.offset),"count"in t&&(n.count=0|t.count),"instances"in t&&(n.instances=0|t.instances),"primitive"in t&&(_(t.primitive in ie,"bad primitive type: "+t.primitive),n.primitive=ie[t.primitive]),_.optional((()=>{for(var e=Object.keys(t),r=0;r<e.length;++r)_(Et.indexOf(e[r])>=0,'invalid option for vao: "'+e[r]+'" valid options are '+Et)})),_(Array.isArray(a),"attributes must be an array")}_(a.length<u,"too many attributes"),_(a.length>0,"must specify at least one attribute");var c={},l=n.attributes;l.length=a.length;for(var d=0;d<a.length;++d){var m,p=a[d],h=l[d]=new Tt,b=p.data||p;Array.isArray(b)||e(b)||G(b)?(n.buffers[d]&&(m=n.buffers[d],e(b)&&m._buffer.byteLength>=b.byteLength?m.subdata(b):(m.destroy(),n.buffers[d]=null)),n.buffers[d]||(m=n.buffers[d]=i.create(p,34962,!1,!0)),h.buffer=i.getBuffer(m),h.size=0|h.buffer.dimension,h.normalized=!1,h.type=h.buffer.dtype,h.offset=0,h.stride=0,h.divisor=0,h.state=1,c[d]=1):i.getBuffer(p)?(h.buffer=i.getBuffer(p),h.size=0|h.buffer.dimension,h.normalized=!1,h.type=h.buffer.dtype,h.offset=0,h.stride=0,h.divisor=0,h.state=1):i.getBuffer(p.buffer)?(h.buffer=i.getBuffer(p.buffer),h.size=0|(+p.size||h.buffer.dimension),h.normalized=!!p.normalized||!1,"type"in p?(_.parameter(p.type,X,"invalid buffer type"),h.type=X[p.type]):h.type=h.buffer.dtype,h.offset=0|(p.offset||0),h.stride=0|(p.stride||0),h.divisor=0|(p.divisor||0),h.state=1,_(h.size>=1&&h.size<=4,"size must be between 1 and 4"),_(h.offset>=0,"invalid offset"),_(h.stride>=0&&h.stride<=255,"stride must be between 0 and 255"),_(h.divisor>=0,"divisor must be positive"),_(!h.divisor||!!r.angle_instanced_arrays,"ANGLE_instanced_arrays must be enabled to use divisor")):"x"in p?(_(d>0,"first attribute must not be a constant"),h.x=+p.x||0,h.y=+p.y||0,h.z=+p.z||0,h.w=+p.w||0,h.state=2):_(!1,"invalid attribute spec for location "+d)}for(var v=0;v<n.buffers.length;++v)!c[v]&&n.buffers[v]&&(n.buffers[v].destroy(),n.buffers[v]=null);return n.refresh(),f}return a.vaoCount+=1,f.destroy=function(){for(var e=0;e<n.buffers.length;++e)n.buffers[e]&&n.buffers[e].destroy();n.buffers.length=0,n.ownsElements&&(n.elements.destroy(),n.elements=null,n.ownsElements=!1),n.destroy()},f._vao=n,f._reglType="vao",f(t)},getVAO:function(e){return"function"==typeof e&&e._vao?e._vao:null},destroyBuffer:function(e){for(var r=0;r<s.length;++r){var n=s[r];n.buffer===e&&(t.disableVertexAttribArray(r),n.buffer=null)}},setVAO:p()?function(e){if(e!==m.currentVAO){var t=p();e?t.bindVertexArrayOES(e.vao):t.bindVertexArrayOES(null),m.currentVAO=e}}:function(e){if(e!==m.currentVAO){if(e)e.bindAttrs();else{for(var r=h(),n=0;n<s.length;++n){var a=s[n];a.buffer?(t.enableVertexAttribArray(n),a.buffer.bind(),t.vertexAttribPointer(n,a.size,a.type,a.normalized,a.stride,a.offfset),r&&a.divisor&&r.vertexAttribDivisorANGLE(n,a.divisor)):(t.disableVertexAttribArray(n),t.vertexAttrib4f(n,a.x,a.y,a.z,a.w))}f.elements?t.bindBuffer(Ot,f.elements.buffer.buffer):t.bindBuffer(Ot,null)}m.currentVAO=e}},clear:p()?function(){H(d).forEach((function(e){e.destroy()}))}:function(){}};function p(){return r.oes_vertex_array_object}function h(){return r.angle_instanced_arrays}function b(){this.id=++l,this.attributes=[],this.elements=null,this.ownsElements=!1,this.count=0,this.offset=0,this.instances=-1,this.primitive=4;var e=p();this.vao=e?e.createVertexArrayOES():null,d[this.id]=this,this.buffers=[]}return b.prototype.bindAttrs=function(){for(var e=h(),r=this.attributes,n=0;n<r.length;++n){var a=r[n];a.buffer?(t.enableVertexAttribArray(n),t.bindBuffer(34962,a.buffer.buffer),t.vertexAttribPointer(n,a.size,a.type,a.normalized,a.stride,a.offset),e&&a.divisor&&e.vertexAttribDivisorANGLE(n,a.divisor)):(t.disableVertexAttribArray(n),t.vertexAttrib4f(n,a.x,a.y,a.z,a.w))}for(var i=r.length;i<u;++i)t.disableVertexAttribArray(i);var f=o.getElements(this.elements);f?t.bindBuffer(Ot,f.buffer.buffer):t.bindBuffer(Ot,null)},b.prototype.refresh=function(){var e=p();e&&(e.bindVertexArrayOES(this.vao),this.bindAttrs(),m.currentVAO=null,e.bindVertexArrayOES(null))},b.prototype.destroy=function(){if(this.vao){var e=p();this===m.currentVAO&&(m.currentVAO=null,e.bindVertexArrayOES(null)),e.deleteVertexArrayOES(this.vao),this.vao=null}this.ownsElements&&(this.elements.destroy(),this.elements=null,this.ownsElements=!1),d[this.id]&&(delete d[this.id],a.vaoCount-=1)},m}(a,d,y,l,x,w,g),k=function(e,r,n,a){var i={},o={};function f(e,t,r,n){this.name=e,this.id=t,this.location=r,this.info=n}function u(e,t){for(var r=0;r<e.length;++r)if(e[r].id===t.id)return void(e[r].location=t.location);e.push(t)}function s(t,n,a){var f=35632===t?i:o,u=f[n];if(!u){var s=r.str(n);u=e.createShader(t),e.shaderSource(u,s),e.compileShader(u),_.shaderError(e,u,s,t,a),f[n]=u}return u}var c={},l=[],d=0;function m(e,t){this.id=d++,this.fragId=e,this.vertId=t,this.program=null,this.uniforms=[],this.attributes=[],this.refCount=1,a.profile&&(this.stats={uniformsCount:0,attributesCount:0})}function p(t,n,i){var o,c,l=s(35632,t.fragId),d=s(35633,t.vertId),m=t.program=e.createProgram();if(e.attachShader(m,l),e.attachShader(m,d),i)for(o=0;o<i.length;++o){var p=i[o];e.bindAttribLocation(m,p[0],p[1])}e.linkProgram(m),_.linkError(e,m,r.str(t.fragId),r.str(t.vertId),n);var h=e.getProgramParameter(m,35718);a.profile&&(t.stats.uniformsCount=h);var b=t.uniforms;for(o=0;o<h;++o)if(c=e.getActiveUniform(m,o)){if(c.size>1)for(var v=0;v<c.size;++v){var g=c.name.replace("[0]","["+v+"]");u(b,new f(g,r.id(g),e.getUniformLocation(m,g),c))}var y=c.name;c.size>1&&(y=y.replace("[0]","")),u(b,new f(y,r.id(y),e.getUniformLocation(m,y),c))}var x=e.getProgramParameter(m,35721);a.profile&&(t.stats.attributesCount=x);var w=t.attributes;for(o=0;o<x;++o)(c=e.getActiveAttrib(m,o))&&u(w,new f(c.name,r.id(c.name),e.getAttribLocation(m,c.name),c))}return a.profile&&(n.getMaxUniformsCount=function(){var e=0;return l.forEach((function(t){t.stats.uniformsCount>e&&(e=t.stats.uniformsCount)})),e},n.getMaxAttributesCount=function(){var e=0;return l.forEach((function(t){t.stats.attributesCount>e&&(e=t.stats.attributesCount)})),e}),{clear:function(){var t=e.deleteShader.bind(e);H(i).forEach(t),i={},H(o).forEach(t),o={},l.forEach((function(t){e.deleteProgram(t.program)})),l.length=0,c={},n.shaderCount=0},program:function(r,a,f,u){_.command(r>=0,"missing vertex shader",f),_.command(a>=0,"missing fragment shader",f);var s=c[a];s||(s=c[a]={});var d=s[r];if(d&&(d.refCount++,!u))return d;var h=new m(a,r);return n.shaderCount++,p(h,f,u),d||(s[r]=h),l.push(h),t(h,{destroy:function(){if(h.refCount--,h.refCount<=0){e.deleteProgram(h.program);var t=l.indexOf(h);l.splice(t,1),n.shaderCount--}s[h.vertId].refCount<=0&&(e.deleteShader(o[h.vertId]),delete o[h.vertId],delete c[h.fragId][h.vertId]),Object.keys(c[h.fragId]).length||(e.deleteShader(i[h.fragId]),delete i[h.fragId],delete c[h.fragId])}})},restore:function(){i={},o={};for(var e=0;e<l.length;++e)p(l[e],null,l[e].attributes.map((function(e){return[e.location,e.name]})))},shader:s,frag:-1,vert:-1}}(a,c,l,n),S=dt(a,d,y,(function(){T.procs.poll()}),v,l,n),O=function(e,t,r,n,a){var i={rgba4:pt,rgb565:36194,"rgb5 a1":32855,depth:33189,stencil:36168,"depth stencil":34041};t.ext_srgb&&(i.srgba=35907),t.ext_color_buffer_half_float&&(i.rgba16f=34842,i.rgb16f=34843),t.webgl_color_buffer_float&&(i.rgba32f=34836);var o=[];Object.keys(i).forEach((function(e){var t=i[e];o[t]=e}));var f=0,u={};function s(e){this.id=f++,this.refCount=1,this.renderbuffer=e,this.format=pt,this.width=0,this.height=0,a.profile&&(this.stats={size:0})}function c(t){var r=t.renderbuffer;_(r,"must not double destroy renderbuffer"),e.bindRenderbuffer(mt,null),e.deleteRenderbuffer(r),t.renderbuffer=null,t.refCount=0,delete u[t.id],n.renderbufferCount--}return s.prototype.decRef=function(){--this.refCount<=0&&c(this)},a.profile&&(n.getTotalRenderbufferSize=function(){var e=0;return Object.keys(u).forEach((function(t){e+=u[t].stats.size})),e}),{create:function(t,f){var c=new s(e.createRenderbuffer());function l(t,n){var f=0,u=0,s=pt;if("object"==typeof t&&t){var d=t;if("shape"in d){var m=d.shape;_(Array.isArray(m)&&m.length>=2,"invalid renderbuffer shape"),f=0|m[0],u=0|m[1]}else"radius"in d&&(f=u=0|d.radius),"width"in d&&(f=0|d.width),"height"in d&&(u=0|d.height);"format"in d&&(_.parameter(d.format,i,"invalid renderbuffer format"),s=i[d.format])}else"number"==typeof t?(f=0|t,u="number"==typeof n?0|n:f):t?_.raise("invalid arguments to renderbuffer constructor"):f=u=1;if(_(f>0&&u>0&&f<=r.maxRenderbufferSize&&u<=r.maxRenderbufferSize,"invalid renderbuffer size"),f!==c.width||u!==c.height||s!==c.format)return l.width=c.width=f,l.height=c.height=u,c.format=s,e.bindRenderbuffer(mt,c.renderbuffer),e.renderbufferStorage(mt,s,f,u),_(0===e.getError(),"invalid render buffer format"),a.profile&&(c.stats.size=bt(c.format,c.width,c.height)),l.format=o[c.format],l}return u[c.id]=c,n.renderbufferCount++,l(t,f),l.resize=function(t,n){var i=0|t,o=0|n||i;return i===c.width&&o===c.height||(_(i>0&&o>0&&i<=r.maxRenderbufferSize&&o<=r.maxRenderbufferSize,"invalid renderbuffer size"),l.width=c.width=i,l.height=c.height=o,e.bindRenderbuffer(mt,c.renderbuffer),e.renderbufferStorage(mt,c.format,i,o),_(0===e.getError(),"invalid render buffer format"),a.profile&&(c.stats.size=bt(c.format,c.width,c.height))),l},l._reglType="renderbuffer",l._renderbuffer=c,a.profile&&(l.stats=c.stats),l.destroy=function(){c.decRef()},l},clear:function(){H(u).forEach(c)},restore:function(){H(u).forEach((function(t){t.renderbuffer=e.createRenderbuffer(),e.bindRenderbuffer(mt,t.renderbuffer),e.renderbufferStorage(mt,t.format,t.width,t.height)})),e.bindRenderbuffer(mt,null)}}}(a,d,y,l,n),E=function(e,r,n,a,i,o){var f={cur:null,next:null,dirty:!1,setFBO:null},u=["rgba"],s=["rgba4","rgb565","rgb5 a1"];r.ext_srgb&&s.push("srgba"),r.ext_color_buffer_half_float&&s.push("rgba16f","rgb16f"),r.webgl_color_buffer_float&&s.push("rgba32f");var c=["uint8"];function l(e,t,r){this.target=e,this.texture=t,this.renderbuffer=r;var n=0,a=0;t?(n=t.width,a=t.height):r&&(n=r.width,a=r.height),this.width=n,this.height=a}function d(e){e&&(e.texture&&e.texture._texture.decRef(),e.renderbuffer&&e.renderbuffer._renderbuffer.decRef())}function m(e,t,r){if(e)if(e.texture){var n=e.texture._texture,a=Math.max(1,n.width),i=Math.max(1,n.height);_(a===t&&i===r,"inconsistent width/height for supplied texture"),n.refCount+=1}else{var o=e.renderbuffer._renderbuffer;_(o.width===t&&o.height===r,"inconsistent width/height for renderbuffer"),o.refCount+=1}}function p(t,r){r&&(r.texture?e.framebufferTexture2D(vt,t,r.target,r.texture._texture.texture,0):e.framebufferRenderbuffer(vt,t,gt,r.renderbuffer._renderbuffer.renderbuffer))}function h(e){var t=yt,r=null,n=null,a=e;"object"==typeof e&&(a=e.data,"target"in e&&(t=0|e.target)),_.type(a,"function","invalid attachment data");var i=a._reglType;return"texture2d"===i?(r=a,_(t===yt)):"textureCube"===i?(r=a,_(t>=xt&&t<34075,"invalid cube map target")):"renderbuffer"===i?(n=a,t=gt):_.raise("invalid regl object for attachment"),new l(t,r,n)}function b(e,t,r,n,o){if(r){var f=a.create2D({width:e,height:t,format:n,type:o});return f._texture.refCount=0,new l(yt,f,null)}var u=i.create({width:e,height:t,format:n});return u._renderbuffer.refCount=0,new l(gt,null,u)}function v(e){return e&&(e.texture||e.renderbuffer)}function g(e,t,r){e&&(e.texture?e.texture.resize(t,r):e.renderbuffer&&e.renderbuffer.resize(t,r),e.width=t,e.height=r)}r.oes_texture_half_float&&c.push("half float","float16"),r.oes_texture_float&&c.push("float","float32");var y=0,x={};function w(){this.id=y++,x[this.id]=this,this.framebuffer=e.createFramebuffer(),this.width=0,this.height=0,this.colorAttachments=[],this.depthAttachment=null,this.stencilAttachment=null,this.depthStencilAttachment=null}function A(e){e.colorAttachments.forEach(d),d(e.depthAttachment),d(e.stencilAttachment),d(e.depthStencilAttachment)}function k(t){var r=t.framebuffer;_(r,"must not double destroy framebuffer"),e.deleteFramebuffer(r),t.framebuffer=null,o.framebufferCount--,delete x[t.id]}function S(t){var r;e.bindFramebuffer(vt,t.framebuffer);var a=t.colorAttachments;for(r=0;r<a.length;++r)p(36064+r,a[r]);for(r=a.length;r<n.maxColorAttachments;++r)e.framebufferTexture2D(vt,36064+r,yt,null,0);e.framebufferTexture2D(vt,33306,yt,null,0),e.framebufferTexture2D(vt,36096,yt,null,0),e.framebufferTexture2D(vt,36128,yt,null,0),p(36096,t.depthAttachment),p(36128,t.stencilAttachment),p(33306,t.depthStencilAttachment);var i=e.checkFramebufferStatus(vt);e.isContextLost()||36053===i||_.raise("framebuffer configuration not supported, status = "+St[i]),e.bindFramebuffer(vt,f.next?f.next.framebuffer:null),f.cur=f.next,e.getError()}function O(e,a){var i=new w;function l(e,t){var a;_(f.next!==i,"can not update framebuffer which is currently in use");var o=0,d=0,p=!0,g=!0,y=null,x=!0,w="rgba",k="uint8",O=1,E=null,T=null,D=null,j=!1;if("number"==typeof e)o=0|e,d=0|t||o;else if(e){_.type(e,"object","invalid arguments for framebuffer");var C=e;if("shape"in C){var z=C.shape;_(Array.isArray(z)&&z.length>=2,"invalid shape for framebuffer"),o=z[0],d=z[1]}else"radius"in C&&(o=d=C.radius),"width"in C&&(o=C.width),"height"in C&&(d=C.height);("color"in C||"colors"in C)&&(y=C.color||C.colors,Array.isArray(y)&&_(1===y.length||r.webgl_draw_buffers,"multiple render targets not supported")),y||("colorCount"in C&&(O=0|C.colorCount,_(O>0,"invalid color buffer count")),"colorTexture"in C&&(x=!!C.colorTexture,w="rgba4"),"colorType"in C&&(k=C.colorType,x?(_(r.oes_texture_float||!("float"===k||"float32"===k),"you must enable OES_texture_float in order to use floating point framebuffer objects"),_(r.oes_texture_half_float||!("half float"===k||"float16"===k),"you must enable OES_texture_half_float in order to use 16-bit floating point framebuffer objects")):"half float"===k||"float16"===k?(_(r.ext_color_buffer_half_float,"you must enable EXT_color_buffer_half_float to use 16-bit render buffers"),w="rgba16f"):"float"!==k&&"float32"!==k||(_(r.webgl_color_buffer_float,"you must enable WEBGL_color_buffer_float in order to use 32-bit floating point renderbuffers"),w="rgba32f"),_.oneOf(k,c,"invalid color type")),"colorFormat"in C&&(w=C.colorFormat,u.indexOf(w)>=0?x=!0:s.indexOf(w)>=0?x=!1:_.optional((function(){x?_.oneOf(C.colorFormat,u,"invalid color format for texture"):_.oneOf(C.colorFormat,s,"invalid color format for renderbuffer")})))),("depthTexture"in C||"depthStencilTexture"in C)&&(j=!(!C.depthTexture&&!C.depthStencilTexture),_(!j||r.webgl_depth_texture,"webgl_depth_texture extension not supported")),"depth"in C&&("boolean"==typeof C.depth?p=C.depth:(E=C.depth,g=!1)),"stencil"in C&&("boolean"==typeof C.stencil?g=C.stencil:(T=C.stencil,p=!1)),"depthStencil"in C&&("boolean"==typeof C.depthStencil?p=g=C.depthStencil:(D=C.depthStencil,p=!1,g=!1))}else o=d=1;var F=null,B=null,V=null,I=null;if(Array.isArray(y))F=y.map(h);else if(y)F=[h(y)];else for(F=new Array(O),a=0;a<O;++a)F[a]=b(o,d,x,w,k);_(r.webgl_draw_buffers||F.length<=1,"you must enable the WEBGL_draw_buffers extension in order to use multiple color buffers."),_(F.length<=n.maxColorAttachments,"too many color attachments, not supported"),o=o||F[0].width,d=d||F[0].height,E?B=h(E):p&&!g&&(B=b(o,d,j,"depth","uint32")),T?V=h(T):g&&!p&&(V=b(o,d,!1,"stencil","uint8")),D?I=h(D):!E&&!T&&g&&p&&(I=b(o,d,j,"depth stencil","depth stencil")),_(!!E+!!T+!!D<=1,"invalid framebuffer configuration, can specify exactly one depth/stencil attachment");var P=null;for(a=0;a<F.length;++a)if(m(F[a],o,d),_(!F[a]||F[a].texture&&wt.indexOf(F[a].texture._texture.format)>=0||F[a].renderbuffer&&kt.indexOf(F[a].renderbuffer._renderbuffer.format)>=0,"framebuffer color attachment "+a+" is invalid"),F[a]&&F[a].texture){var L=At[F[a].texture._texture.format]*_t[F[a].texture._texture.type];null===P?P=L:_(P===L,"all color attachments much have the same number of bits per pixel.")}return m(B,o,d),_(!B||B.texture&&6402===B.texture._texture.format||B.renderbuffer&&33189===B.renderbuffer._renderbuffer.format,"invalid depth attachment for framebuffer object"),m(V,o,d),_(!V||V.renderbuffer&&36168===V.renderbuffer._renderbuffer.format,"invalid stencil attachment for framebuffer object"),m(I,o,d),_(!I||I.texture&&34041===I.texture._texture.format||I.renderbuffer&&34041===I.renderbuffer._renderbuffer.format,"invalid depth-stencil attachment for framebuffer object"),A(i),i.width=o,i.height=d,i.colorAttachments=F,i.depthAttachment=B,i.stencilAttachment=V,i.depthStencilAttachment=I,l.color=F.map(v),l.depth=v(B),l.stencil=v(V),l.depthStencil=v(I),l.width=i.width,l.height=i.height,S(i),l}return o.framebufferCount++,l(e,a),t(l,{resize:function(e,t){_(f.next!==i,"can not resize a framebuffer which is currently in use");var r=Math.max(0|e,1),n=Math.max(0|t||r,1);if(r===i.width&&n===i.height)return l;for(var a=i.colorAttachments,o=0;o<a.length;++o)g(a[o],r,n);return g(i.depthAttachment,r,n),g(i.stencilAttachment,r,n),g(i.depthStencilAttachment,r,n),i.width=l.width=r,i.height=l.height=n,S(i),l},_reglType:"framebuffer",_framebuffer:i,destroy:function(){k(i),A(i)},use:function(e){f.setFBO({framebuffer:l},e)}})}return t(f,{getFramebuffer:function(e){if("function"==typeof e&&"framebuffer"===e._reglType){var t=e._framebuffer;if(t instanceof w)return t}return null},create:O,createCube:function(e){var i=Array(6);function o(e){var n;_(i.indexOf(f.next)<0,"can not update framebuffer which is currently in use");var s,l={color:null},d=0,m=null,p="rgba",h="uint8",b=1;if("number"==typeof e)d=0|e;else if(e){_.type(e,"object","invalid arguments for framebuffer");var v=e;if("shape"in v){var g=v.shape;_(Array.isArray(g)&&g.length>=2,"invalid shape for framebuffer"),_(g[0]===g[1],"cube framebuffer must be square"),d=g[0]}else"radius"in v&&(d=0|v.radius),"width"in v?(d=0|v.width,"height"in v&&_(v.height===d,"must be square")):"height"in v&&(d=0|v.height);("color"in v||"colors"in v)&&(m=v.color||v.colors,Array.isArray(m)&&_(1===m.length||r.webgl_draw_buffers,"multiple render targets not supported")),m||("colorCount"in v&&(b=0|v.colorCount,_(b>0,"invalid color buffer count")),"colorType"in v&&(_.oneOf(v.colorType,c,"invalid color type"),h=v.colorType),"colorFormat"in v&&(p=v.colorFormat,_.oneOf(v.colorFormat,u,"invalid color format for texture"))),"depth"in v&&(l.depth=v.depth),"stencil"in v&&(l.stencil=v.stencil),"depthStencil"in v&&(l.depthStencil=v.depthStencil)}else d=1;if(m)if(Array.isArray(m))for(s=[],n=0;n<m.length;++n)s[n]=m[n];else s=[m];else{s=Array(b);var y={radius:d,format:p,type:h};for(n=0;n<b;++n)s[n]=a.createCube(y)}for(l.color=Array(s.length),n=0;n<s.length;++n){var x=s[n];_("function"==typeof x&&"textureCube"===x._reglType,"invalid cube map"),d=d||x.width,_(x.width===d&&x.height===d,"invalid cube map shape"),l.color[n]={target:xt,data:s[n]}}for(n=0;n<6;++n){for(var w=0;w<s.length;++w)l.color[w].target=xt+n;n>0&&(l.depth=i[0].depth,l.stencil=i[0].stencil,l.depthStencil=i[0].depthStencil),i[n]?i[n](l):i[n]=O(l)}return t(o,{width:d,height:d,color:s})}return o(e),t(o,{faces:i,resize:function(e){var t,r=0|e;if(_(r>0&&r<=n.maxCubeMapSize,"invalid radius for cube fbo"),r===o.width)return o;var a=o.color;for(t=0;t<a.length;++t)a[t].resize(r);for(t=0;t<6;++t)i[t].resize(r);return o.width=o.height=r,o},_reglType:"framebufferCube",destroy:function(){i.forEach((function(e){e.destroy()}))}})},clear:function(){H(x).forEach(k)},restore:function(){f.cur=null,f.next=null,f.dirty=!0,H(x).forEach((function(t){t.framebuffer=e.createFramebuffer(),S(t)}))}})}(a,d,y,S,O,l),T=un(a,c,d,y,x,w,0,E,{},A,k,g,v,m,n),z=Ct(a,E,T.procs.poll,v,i,d,y),F=T.next,V=a.canvas,I=[],P=[],N=[],q=[n.onDestroy],Q=null;function Y(){if(0===I.length)return m&&m.update(),void(Q=null);Q=j.next(Y),ye();for(var e=I.length-1;e>=0;--e){var t=I[e];t&&t(v,null,0)}a.flush(),m&&m.update()}function ce(){!Q&&I.length>0&&(Q=j.next(Y))}function le(){Q&&(j.cancel(Y),Q=null)}function de(e){e.preventDefault(),o=!0,le(),P.forEach((function(e){e()}))}function me(e){a.getError(),o=!1,f.restore(),k.restore(),x.restore(),S.restore(),O.restore(),E.restore(),A.restore(),m&&m.restore(),T.procs.refresh(),ce(),N.forEach((function(e){e()}))}function pe(e){function r(e,t){var r={},n={};return Object.keys(e).forEach((function(a){var i=e[a];if(D.isDynamic(i))n[a]=D.unbox(i,a);else{if(t&&Array.isArray(i))for(var o=0;o<i.length;++o)if(D.isDynamic(i[o]))return void(n[a]=D.unbox(i,a));r[a]=i}})),{dynamic:n,static:r}}_(!!e,"invalid args to regl({...})"),_.type(e,"object","invalid args to regl({...})");var n=r(e.context||{},!0),a=r(e.uniforms||{},!0),i=r(e.attributes||{},!1),f=r(function(e){var r=t({},e);function n(e){if(e in r){var t=r[e];delete r[e],Object.keys(t).forEach((function(n){r[e+"."+n]=t[n]}))}}return delete r.uniforms,delete r.attributes,delete r.context,delete r.vao,"stencil"in r&&r.stencil.op&&(r.stencil.opBack=r.stencil.opFront=r.stencil.op,delete r.stencil.op),n("blend"),n("depth"),n("cull"),n("stencil"),n("polygonOffset"),n("scissor"),n("sample"),"vao"in e&&(r.vao=e.vao),r}(e),!1),u={gpuTime:0,cpuTime:0,count:0},s=T.compile(f,i,a,n,u),c=s.draw,l=s.batch,d=s.scope,m=[];return t((function(e,t){var r;if(o&&_.raise("context lost"),"function"==typeof e)return d.call(this,null,e,0);if("function"==typeof t)if("number"==typeof e)for(r=0;r<e;++r)d.call(this,null,t,r);else{if(!Array.isArray(e))return d.call(this,e,t,0);for(r=0;r<e.length;++r)d.call(this,e[r],t,r)}else if("number"==typeof e){if(e>0)return l.call(this,function(e){for(;m.length<e;)m.push(null);return m}(0|e),0|e)}else{if(!Array.isArray(e))return c.call(this,e);if(e.length)return l.call(this,e,e.length)}}),{stats:u,destroy:function(){s.destroy()}})}V&&(V.addEventListener(cn,de,!1),V.addEventListener(ln,me,!1));var he=E.setFBO=pe({framebuffer:D.define.call(null,1,"framebuffer")});function be(e,t){var r=0;T.procs.poll();var n=t.color;n&&(a.clearColor(+n[0]||0,+n[1]||0,+n[2]||0,+n[3]||0),r|=16384),"depth"in t&&(a.clearDepth(+t.depth),r|=256),"stencil"in t&&(a.clearStencil(0|t.stencil),r|=1024),_(!!r,"called regl.clear with no buffer specified"),a.clear(r)}function ve(e){return _.type(e,"function","regl.frame() callback must be a function"),I.push(e),ce(),{cancel:function(){var t=dn(I,e);_(t>=0,"cannot cancel a frame twice"),I[t]=function e(){var t=dn(I,e);I[t]=I[I.length-1],I.length-=1,I.length<=0&&le()}}}}function ge(){var e=F.viewport,t=F.scissor_box;e[0]=e[1]=t[0]=t[1]=0,v.viewportWidth=v.framebufferWidth=v.drawingBufferWidth=e[2]=t[2]=a.drawingBufferWidth,v.viewportHeight=v.framebufferHeight=v.drawingBufferHeight=e[3]=t[3]=a.drawingBufferHeight}function ye(){v.tick+=1,v.time=we(),ge(),T.procs.poll()}function xe(){S.refresh(),ge(),T.procs.refresh(),m&&m.update()}function we(){return(C()-p)/1e3}xe();var Ae=t(pe,{clear:function(e){if(_("object"==typeof e&&e,"regl.clear() takes an object as input"),"framebuffer"in e)if(e.framebuffer&&"framebufferCube"===e.framebuffer_reglType)for(var r=0;r<6;++r)he(t({framebuffer:e.framebuffer.faces[r]},e),be);else he(e,be);else be(0,e)},prop:D.define.bind(null,1),context:D.define.bind(null,2),this:D.define.bind(null,3),draw:pe({}),buffer:function(e){return x.create(e,34962,!1,!1)},elements:function(e){return w.create(e,!1)},texture:S.create2D,cube:S.createCube,renderbuffer:O.create,framebuffer:E.create,framebufferCube:E.createCube,vao:A.createVAO,attributes:i,frame:ve,on:function(e,t){var r;switch(_.type(t,"function","listener callback must be a function"),e){case"frame":return ve(t);case"lost":r=P;break;case"restore":r=N;break;case"destroy":r=q;break;default:_.raise("invalid event, must be one of frame,lost,restore,destroy")}return r.push(t),{cancel:function(){for(var e=0;e<r.length;++e)if(r[e]===t)return r[e]=r[r.length-1],void r.pop()}}},limits:y,hasExtension:function(e){return y.extensions.indexOf(e.toLowerCase())>=0},read:z,destroy:function(){I.length=0,le(),V&&(V.removeEventListener(cn,de),V.removeEventListener(ln,me)),k.clear(),E.clear(),O.clear(),A.clear(),S.clear(),w.clear(),x.clear(),m&&m.clear(),q.forEach((function(e){e()}))},_gl:a,_refresh:xe,poll:function(){ye(),m&&m.update()},now:we,stats:l});return n.onDone(null,Ae),Ae}},"object"==typeof r&&void 0!==t?t.exports=o():"function"==typeof define&&define.amd?define(o):i.createREGL=o()},
409: function _(t,e,s,a,r){a();const n=t(410),_=t(12);class o{constructor(t){this._regl=t,this._map=new Map}_create_texture(t){const e=t.length;let s=0;const a=[];let r=0,_=0;for(let n=0;n<e;n++)s+=t[n],a.push(t[n]+t[(n+1)%e]),n%2==0?_=Math.max(_,t[n]):r=Math.min(r,-t[n]);r*=.5,_*=.5;const o=(0,n.gcd)(a),c=[0];for(let s=0;s<e;s++)c.push(c[s]+t[s]);const h=2*s/o,i=(0,n.is_pow_2)(h),l=i?h:128,g=.5*o*h/l;let p;if(i){if(p=.5*t[0],g<p){p-=Math.floor(p/g)*g}}else p=0;const u=p-.5*g,m=new Uint8Array(l);let f=0;for(let e=0;e<l;e++){const s=p+e*g;s>c[f+1]&&f++;const a=t[f],n=c[f]+.5*a;let o=.5*a-Math.abs(s-n);f%2==1&&(o=-o),m[e]=Math.round(255*(o-r)/(_-r))}return[[s,u,r,_],this._regl.texture({shape:[l,1,1],data:m,wrapS:"repeat",format:"alpha",type:"uint8",mag:"linear",min:"linear"})]}_get_key(t){return t.join(",")}_get_or_create(t){const e=this._get_key(t);let s=this._map.get(e);if(null==s){const a=(0,n.gcd)(t);if(a>1){t=(0,_.map)(t,(t=>t/a)),s=this._get_or_create(t);const[r,n,o]=s;s=[r,n,a],this._map.set(e,s)}else{const[r,n]=this._create_texture(t);s=[r,n,a],this._map.set(e,s)}}return s}get(t){return t.length%2==1&&(t=t.slice(0,-1)),this._get_or_create(t)}}s.DashCache=o,o.__name__="DashCache"},
410: function _(n,t,e,r,o){function u(n,t){let e,r;n>t?(e=n,r=t):(e=t,r=n);let o=e%r;for(;0!=o;)e=r,r=o,o=e%r;return r}r(),e.gcd=function(n){let t=n[0];for(let e=1;e<n.length;e++)t=u(t,n[e]);return t},e.is_pow_2=function(n){return!(n&n-1||!n)}},
411: function _(n,t,i,e,_){e();i.default="\nprecision mediump float;\n\nconst int butt_cap   = 0;\nconst int round_cap  = 1;\nconst int square_cap = 2;\n\nconst int miter_join = 0;\nconst int round_join = 1;\nconst int bevel_join = 2;\n\nconst float missing_point_threshold = -9000.0;\n\nattribute vec2 a_position;\nattribute vec2 a_point_prev;\nattribute vec2 a_point_start;\nattribute vec2 a_point_end;\nattribute vec2 a_point_next;\n#ifdef DASHED\nattribute float a_length_so_far;\n#endif\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform float u_linewidth;\nuniform float u_antialias;\nuniform float u_line_join;\nuniform float u_line_cap;\nuniform float u_miter_limit;\n\nvarying float v_segment_length;\nvarying vec2 v_coords;\nvarying float v_flags;  // Booleans for start/end caps and miters too long.\nvarying float v_cos_theta_turn_right_start;  // Sign gives turn_right, abs gives\nvarying float v_cos_theta_turn_right_end;    //   cos(theta).\n#ifdef DASHED\nvarying float v_length_so_far;\n#endif\n\nfloat cross_z(in vec2 v0, in vec2 v1)\n{\n    return v0.x*v1.y - v0.y*v1.x;\n}\n\nvec2 right_vector(in vec2 v)\n{\n    return vec2(v.y, -v.x);\n}\n\nvec2 line_intersection(in vec2 point0, in vec2 dir0,\n                       in vec2 point1, in vec2 dir1)\n{\n    // Line-line intersection: point0 + lambda0 dir0 = point1 + lambda1 dir1.\n    // Not checking if lines are parallel!\n    float lambda0 = cross_z(point1 - point0, dir1) / cross_z(dir0, dir1);\n    return point0 + lambda0*dir0;\n}\n\nvoid main()\n{\n    if (a_point_start.x < missing_point_threshold ||\n        a_point_end.x < missing_point_threshold) {\n        // Line segment has non-finite value at one or both ends, do not render.\n        gl_Position = vec4(-2.0, -2.0, 0.0, 1.0);\n        return;\n    }\n\n    const float min_miter_factor_round_join_mesh = sqrt(2.0);\n\n    int join_type = int(u_line_join + 0.5);\n    int cap_type = int(u_line_cap + 0.5);\n    float halfwidth = 0.5*(u_linewidth + u_antialias);\n    vec2 segment_along = normalize(a_point_end - a_point_start); // unit vector.\n    v_segment_length = length(a_point_end - a_point_start);\n    vec2 segment_right = right_vector(segment_along);  // unit vector.\n    vec2 xy;\n\n    bool miter_too_large_start = false;\n    bool miter_too_large_end = false;\n\n    v_coords.y = a_position.y*halfwidth;  // Overwritten later for end points.\n\n    bool has_start_cap = a_point_prev.x < missing_point_threshold;\n    bool has_end_cap = a_point_next.x < missing_point_threshold;\n\n    vec2 point_normal_start;\n    float cos_theta_start;\n    float turn_right_start;\n    if (has_start_cap)\n        point_normal_start = segment_right;\n    else {\n        vec2 prev_right = right_vector(normalize(a_point_start - a_point_prev));\n        point_normal_start = normalize(segment_right + prev_right);\n        cos_theta_start = dot(segment_right, point_normal_start);  // Always +ve\n        turn_right_start = sign(dot(segment_right, a_point_prev - a_point_start));\n    }\n\n    vec2 point_normal_end;\n    float cos_theta_end;\n    float turn_right_end;\n    if (has_end_cap)\n        point_normal_end = segment_right;\n    else {\n        vec2 next_right = right_vector(normalize(a_point_next - a_point_end));\n        point_normal_end = normalize(segment_right + next_right);\n        cos_theta_end = dot(segment_right, point_normal_end);  // Always +ve\n        turn_right_end = sign(dot(segment_right, a_point_next - a_point_end));\n    }\n\n    float miter_factor_start = 1.0 / dot(segment_right, point_normal_start);\n    float miter_factor_end = 1.0 / dot(segment_right, point_normal_end);\n    if (join_type == miter_join) {\n        // If miter too large, use bevel join instead.\n        miter_too_large_start = (miter_factor_start > u_miter_limit);\n        miter_too_large_end = (miter_factor_end > u_miter_limit);\n    }\n\n    float sign_at_start = -sign(a_position.x);  // +ve at segment start, -ve end.\n    vec2 point = sign_at_start > 0.0 ? a_point_start : a_point_end;\n    vec2 adjacent_point =\n        sign_at_start > 0.0 ? (has_start_cap ? a_point_start : a_point_prev)\n                            : (has_end_cap ? a_point_end : a_point_next);\n\n    if ( (has_start_cap && sign_at_start > 0.0) ||\n         (has_end_cap && sign_at_start < 0.0) ) {\n        // Cap.\n        xy = point - segment_right*(halfwidth*a_position.y);\n        if (cap_type == butt_cap)\n            xy -= sign_at_start*0.5*u_antialias*segment_along;\n        else\n            xy -= sign_at_start*halfwidth*segment_along;\n    }\n    else { // Join.\n        // +ve if turning to right, -ve if to left.\n        float turn_sign = sign_at_start > 0.0 ? turn_right_start : turn_right_end;\n\n        vec2 adjacent_right = sign_at_start*normalize(right_vector(point - adjacent_point));\n        vec2 point_right = normalize(segment_right + adjacent_right);\n        float miter_factor = sign_at_start > 0.0 ? miter_factor_start : miter_factor_end;\n        bool miter_too_large = sign_at_start > 0.0 ? miter_too_large_start : miter_too_large_end;\n\n        if (abs(a_position.x) > 1.5) {\n            // Outer point, meets prev/next segment.\n            float factor;  // multiplied by halfwidth...\n\n            if (join_type == bevel_join || (join_type == miter_join && miter_too_large))\n                factor = 1.0 / miter_factor;  // cos_theta.\n            else if (join_type == round_join &&\n                     miter_factor > min_miter_factor_round_join_mesh)\n                factor = 1.0;\n            else  // miter, or round (small angle only).\n                factor = miter_factor;\n\n            xy = point - point_right*(halfwidth*turn_sign*factor);\n            v_coords.y = turn_sign*halfwidth*factor / miter_factor;\n        }\n        else if (turn_sign*a_position.y < 0.0) {\n            // Inner point, meets prev/next segment.\n            float len = halfwidth*miter_factor;\n            float segment_len = v_segment_length;\n            float adjacent_len = distance(point, adjacent_point);\n\n            if (len <= min(segment_len, adjacent_len))\n                // Normal behaviour.\n                xy = point - point_right*(len*a_position.y);\n            else\n                // For short wide line segments the inner point using the above\n                // calculation can be outside of the line.  Here clipping it.\n                xy = point + segment_right*(halfwidth*turn_sign);\n        }\n        else {\n            // Point along outside edge.\n            xy = point - segment_right*(halfwidth*a_position.y);\n            if (join_type == round_join &&\n                miter_factor > min_miter_factor_round_join_mesh) {\n                xy = line_intersection(xy, segment_along,\n                                       point - turn_sign*point_right*halfwidth,\n                                       right_vector(point_right));\n            }\n        }\n    }\n\n    vec2 pos = xy + 0.5;  // Bokeh's offset.\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(2.0*pos.x - 1.0, 1.0 - 2.0*pos.y, 0.0, 1.0);\n\n    v_coords.x = dot(xy - a_point_start, segment_along);\n    v_flags = float(int(has_start_cap) +\n                    2*int(has_end_cap) +\n                    4*int(miter_too_large_start) +\n                    8*int(miter_too_large_end));\n    v_cos_theta_turn_right_start = cos_theta_start*turn_right_start;\n    v_cos_theta_turn_right_end = cos_theta_end*turn_right_end;\n\n#ifdef DASHED\n    v_length_so_far = a_length_so_far;\n#endif\n}\n"},
412: function _(n,t,a,i,e){i();a.default="\nprecision mediump float;\n\nconst int butt_cap   = 0;\nconst int round_cap  = 1;\nconst int square_cap = 2;\n\nconst int miter_join = 0;\nconst int round_join = 1;\nconst int bevel_join = 2;\n\nuniform float u_linewidth;\nuniform float u_antialias;\nuniform float u_line_join;\nuniform float u_line_cap;\nuniform vec4 u_line_color;\n#ifdef DASHED\nuniform sampler2D u_dash_tex;\nuniform vec4 u_dash_tex_info;\nuniform float u_dash_scale;\nuniform float u_dash_offset;\n#endif\n\nvarying float v_segment_length;\nvarying vec2 v_coords;\nvarying float v_flags;\nvarying float v_cos_theta_turn_right_start;\nvarying float v_cos_theta_turn_right_end;\n#ifdef DASHED\nvarying float v_length_so_far;\n#endif\n\nfloat cross_z(in vec2 v0, in vec2 v1)\n{\n    return v0.x*v1.y - v0.y*v1.x;\n}\n\nfloat point_line_side(in vec2 point, in vec2 start, in vec2 end)\n{\n    // +ve if point to right of line.\n    // Alternatively could do dot product with right_vector.\n    return cross_z(point - start, end - start);\n}\n\nfloat point_line_distance(in vec2 point, in vec2 start, in vec2 end)\n{\n    return point_line_side(point, start, end) / distance(start, end);\n}\n\nvec2 right_vector(in vec2 v)\n{\n    return vec2(v.y, -v.x);\n}\n\nfloat bevel_join_distance(in float sign_start, in float halfwidth)\n{\n    float cos_theta_turn_right = sign_start > 0.0 ? v_cos_theta_turn_right_start\n                                                  : v_cos_theta_turn_right_end;\n    float cos_theta = abs(cos_theta_turn_right);\n    float turn_right = sign(cos_theta_turn_right);\n    float distance_along = sign_start > 0.0 ? 0.0 : v_segment_length;\n\n    // In v_coords reference frame (x is along segment, y across).\n    vec2 line_start = vec2(distance_along, halfwidth*turn_right);\n    float sin_alpha = cos_theta;\n    float cos_alpha = sqrt(1.0 - sin_alpha*sin_alpha);\n    vec2 line_along = vec2(-sign_start*turn_right*sin_alpha, -cos_alpha);\n\n    return halfwidth + sign_start*point_line_distance(\n        v_coords, line_start, line_start+line_along);\n}\n\nfloat cap(in int cap_type, in float x, in float y)\n{\n    // x is distance along segment in direction away from end of segment,\n    // y is distance across segment.\n    if (cap_type == butt_cap)\n        return max(0.5*u_linewidth - x, abs(y));\n    else if (cap_type == square_cap)\n        return max(-x, abs(y));\n    else  // cap_type == round_cap\n        return distance(vec2(min(x, 0.0), y), vec2(0.0, 0.0));\n}\n\nfloat distance_to_alpha(in float dist)\n{\n    return 1.0 - smoothstep(0.5*(u_linewidth - u_antialias),\n                            0.5*(u_linewidth + u_antialias), dist);\n}\n\n#ifdef DASHED\nfloat dash_distance(in float x)\n{\n    // x is in direction of v_coords.x, i.e. along segment.\n    float tex_length = u_dash_tex_info.x;\n    float tex_offset = u_dash_tex_info.y;\n    float tex_dist_min = u_dash_tex_info.z;\n    float tex_dist_max = u_dash_tex_info.w;\n\n    // Apply offset.\n    x += v_length_so_far - u_dash_scale*tex_offset + u_dash_offset;\n\n    // Interpolate within texture to obtain distance to dash.\n    float dist = texture2D(u_dash_tex,\n                           vec2(x / (tex_length*u_dash_scale), 0.0)).a;\n\n    // Scale distance within min and max limits.\n    dist = tex_dist_min + dist*(tex_dist_max - tex_dist_min);\n\n    return u_dash_scale*dist;\n}\n\nmat2 rotation_matrix(in float sign_start)\n{\n    // Rotation matrix for v_coords from this segment to prev or next segment.\n    float cos_theta_turn_right = sign_start > 0.0 ? v_cos_theta_turn_right_start\n                                                  : v_cos_theta_turn_right_end;\n    float cos_theta = abs(cos_theta_turn_right);\n    float turn_right = sign(cos_theta_turn_right);\n\n    float sin_theta = sqrt(1.0 - cos_theta*cos_theta)*sign_start*turn_right;\n    float cos_2theta = 2.0*cos_theta*cos_theta - 1.0;\n    float sin_2theta = 2.0*sin_theta*cos_theta;\n    return mat2(cos_2theta, -sin_2theta, sin_2theta, cos_2theta);\n}\n#endif\n\nvoid main()\n{\n    int join_type = int(u_line_join + 0.5);\n    int cap_type = int(u_line_cap + 0.5);\n    float halfwidth = 0.5*(u_linewidth + u_antialias);\n\n    // Extract flags.\n    int flags = int(v_flags + 0.5);\n    bool miter_too_large_end = (flags / 8 > 0);\n    flags -= 8*int(miter_too_large_end);\n    bool miter_too_large_start = (flags / 4 > 0);\n    flags -= 4*int(miter_too_large_start);\n    bool has_end_cap = (flags / 2 > 0);\n    flags -= 2*int(has_end_cap);\n    bool has_start_cap = flags > 0;\n\n    float dist = v_coords.y;  // For straight segment, and miter join.\n\n    if (v_coords.x <= 0.5*u_antialias) {\n        // At start of segment, either cap or join.\n        if (has_start_cap)\n            dist = cap(cap_type, v_coords.x, v_coords.y);\n        else if (join_type == round_join)\n            dist = distance(v_coords, vec2(0.0, 0.0));\n        else if (join_type == bevel_join ||\n                 (join_type == miter_join && miter_too_large_start))\n            dist = max(abs(dist), bevel_join_distance(1.0, halfwidth));\n        // else a miter join which uses the default dist calculation.\n    }\n    else if (v_coords.x >= v_segment_length - 0.5*u_antialias) {\n        // At end of segment, either cap or join.\n        if (has_end_cap)\n            dist = cap(cap_type, v_segment_length - v_coords.x, v_coords.y);\n        else if (join_type == round_join)\n            dist = distance(v_coords, vec2(v_segment_length, 0));\n        else if ((join_type == bevel_join ||\n                 (join_type == miter_join && miter_too_large_end)))\n            dist = max(abs(dist), bevel_join_distance(-1.0, halfwidth));\n        // else a miter join which uses the default dist calculation.\n    }\n\n    float alpha = distance_to_alpha(abs(dist));\n\n#ifdef DASHED\n    if (u_dash_tex_info.x >= 0.0) {\n        // Dashes in straight segments (outside of joins) are easily calculated.\n        dist = dash_distance(v_coords.x);\n\n        if (!has_start_cap && cap_type == butt_cap) {\n            if (v_coords.x < 0.5*u_antialias) {\n                // Outer of start join rendered solid color or not at all\n                // depending on whether corner point is in dash or gap, with\n                // antialiased ends.\n                dist = (dash_distance(0.0) > 0.0 ? 0.5*u_antialias - v_coords.x\n                                                 : -0.5*u_linewidth);\n\n                // Also consider antialiased end of dash just outside corner.\n                float end_dist = dash_distance(0.5*u_antialias) + v_coords.x -\n                    0.5*u_antialias;\n                dist = max(dist, end_dist);\n            }\n\n            vec2 prev_coords = rotation_matrix(1.0)*v_coords;\n\n            if (abs(prev_coords.y) < halfwidth &&\n                prev_coords.x < 0.5*u_antialias) {\n                // Extend dashes across from previous segment, with antialiased\n                // end.\n                float new_dist = dash_distance(min(prev_coords.x,\n                                                   -0.5*u_antialias));\n\n                if (prev_coords.x > -0.5*u_antialias)\n                    new_dist -= prev_coords.x + 0.5*u_antialias;\n\n                new_dist = min(new_dist, 0.5*u_linewidth - abs(prev_coords.y));\n                dist = max(dist, new_dist);\n            }\n        }\n\n        if (!has_end_cap && cap_type == butt_cap) {\n            if (v_coords.x > v_segment_length - 0.5*u_antialias) {\n                // Similar for end join.\n                dist = (dash_distance(v_segment_length) > 0.0\n                            ? v_coords.x - v_segment_length + 0.5*u_antialias\n                            : -0.5*u_linewidth);\n\n                float end_dist =\n                    dash_distance(v_segment_length - 0.5*u_antialias) -\n                    v_coords.x + v_segment_length - 0.5*u_antialias;\n                dist = max(dist, end_dist);\n            }\n\n            vec2 next_coords =\n                rotation_matrix(-1.0)*(v_coords - vec2(v_segment_length, 0.0));\n\n            if (abs(next_coords.y) < halfwidth &&\n                next_coords.x > -0.5*u_antialias) {\n                // Extend dashes across from next segment, with antialiased end.\n                float new_dist = dash_distance(v_segment_length +\n                    max(next_coords.x, 0.5*u_antialias));\n\n                if (next_coords.x < 0.5*u_antialias)\n                    new_dist += next_coords.x - 0.5*u_antialias;\n\n                new_dist = min(new_dist, 0.5*u_linewidth - abs(next_coords.y));\n                dist = max(dist, new_dist);\n            }\n        }\n\n        dist = cap(cap_type, dist, v_coords.y);\n\n        float dash_alpha = distance_to_alpha(dist);\n        alpha = min(alpha, dash_alpha);\n    }\n#endif\n\n    alpha = u_line_color.a*alpha;\n    gl_FragColor = vec4(u_line_color.rgb*alpha, alpha);  // Premultiplied alpha.\n}\n"},
413: function _(n,i,o,a,t){a();o.default="\nprecision mediump float;\n\nattribute vec2 a_position;\nattribute vec2 a_center;\nattribute float a_size;\nattribute float a_angle;  // in radians\nattribute float a_linewidth;\nattribute vec4 a_line_color;\nattribute vec4 a_fill_color;\nattribute float a_show;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform float u_antialias;\n\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying vec2 v_coords;\n\nvoid main()\n{\n    v_size = a_size;\n    v_linewidth = a_linewidth;\n    v_line_color = a_line_color;\n    v_fill_color = a_fill_color;\n\n    if (a_show < 0.5) {\n      // Do not show this marker.\n      gl_Position = vec4(-2.0, -2.0, 0.0, 1.0);\n      return;\n    }\n\n    float enclosing_size = v_size + 2.0*v_linewidth + 3.0*u_antialias;\n\n    // Coordinates in rotated frame with respect to center of marker, used in\n    // distance functions in fragment shader.\n    v_coords = a_position*enclosing_size;\n\n    float c = cos(-a_angle);\n    float s = sin(-a_angle);\n    mat2 rotation = mat2(c, -s, s, c);\n\n    vec2 pos = a_center + rotation*v_coords;\n    pos += 0.5;  // make up for Bokeh's offset\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(2.0*pos.x - 1.0, 1.0 - 2.0*pos.y, 0.0, 1.0);\n}\n"},
414: function _(n,a,e,t,s){t();e.default="\nprecision mediump float;\n\nconst float SQRT_2 = 1.4142135623730951;\nconst float SQRT_3 = sqrt(3.0);\nconst float PI = 3.14159265358979323846264;\n\nconst float IN_ANGLE = 0.6283185307179586; // PI/5. = 36 degrees (star of 5 pikes)\n//const float OUT_ANGLE = PI/2. - IN_ANGLE; // External angle for regular stars\nconst float COS_A = 0.8090169943749475; // cos(IN_ANGLE)\nconst float SIN_A = 0.5877852522924731; // sin(IN_ANGLE)\nconst float COS_B = 0.5877852522924731; // cos(OUT_ANGLE)\nconst float SIN_B = 0.8090169943749475; // sin(OUT_ANGLE)\n\nuniform float u_antialias;\n\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec2 v_coords;\n\n#ifdef USE_ASTERISK\n// asterisk\nfloat marker(vec2 P, float size)\n{\n    // Masks\n    float diamond = max(abs(SQRT_2 / 2.0 * (P.x - P.y)), abs(SQRT_2 / 2.0 * (P.x + P.y))) - size / 2.0;\n    float square = max(abs(P.x), abs(P.y)) - size / 2.0;\n    // Shapes\n    float X = min(abs(P.x - P.y), abs(P.x + P.y));\n    float cross = min(abs(P.x), abs(P.y));\n    // Result is union of masked shapes\n    float result = min(max(X, diamond), max(cross, square));\n    return max(result - v_linewidth/2.0 + u_antialias/2.0, 0.0);\n}\n#endif\n\n#ifdef USE_CIRCLE\n// circle\nfloat marker(vec2 P, float size)\n{\n    return length(P) - size/2.0;\n}\n#endif\n\n#ifdef USE_DOT\nfloat marker(vec2 P, float size)\n{\n    return max(length(P) - size/8.0 - v_linewidth/15.0 + u_antialias, 0.0);\n}\n#endif\n\n#ifdef USE_CIRCLE_DOT\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size/2.0;\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    return max(circle, dot_);\n}\n#endif\n\n#ifdef USE_SQUARE\n// square\nfloat marker(vec2 P, float size)\n{\n    return max(abs(P.x), abs(P.y)) - size/2.0;\n}\n#endif\n\n#ifdef USE_SQUARE_DOT\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    return max(square, dot_);\n}\n#endif\n\n#ifdef USE_DIAMOND\n// diamond\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    return r1 / SQRT_2;\n}\n#endif\n\n#ifdef USE_DIAMOND_DOT\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    float diamond = r1 / SQRT_2;\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    return max(diamond, dot_);\n}\n#endif\n\n#ifdef USE_HEX\n// hex\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    return max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n}\n#endif\n\n#ifdef USE_HEX_DOT\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    float hex = max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    return max(hex, dot_);\n}\n#endif\n\n#ifdef USE_STAR\n// star\n// https://iquilezles.org/www/articles/distfunctions2d/distfunctions2d.htm\nfloat marker(vec2 P, float size)\n{\n    float bn = mod(atan(P.x, -P.y), 2.0*IN_ANGLE) - IN_ANGLE;\n    P = length(P)*vec2(cos(bn), abs(sin(bn)));\n    P -= size*vec2(COS_A, SIN_A)/2.;\n    P += vec2(COS_B, SIN_B)*clamp(-(P.x*COS_B + P.y*SIN_B), 0.0, size*SIN_A/SIN_B/2.);\n    return length(P)*sign(P.x);\n}\n#endif\n\n#ifdef USE_STAR_DOT\nfloat marker(vec2 P, float size)\n{\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    float bn = mod(atan(P.x, -P.y), 2.0*IN_ANGLE) - IN_ANGLE;\n    P = length(P)*vec2(cos(bn), abs(sin(bn)));\n    P -= size*vec2(COS_A, SIN_A)/2.;\n    P += vec2(COS_B, SIN_B)*clamp(-(P.x*COS_B + P.y*SIN_B), 0.0, size*SIN_A/SIN_B/2.);\n    float star = length(P)*sign(P.x);\n    return max(star, dot_);\n}\n#endif\n\n#ifdef USE_TRIANGLE\n// triangle\nfloat marker(vec2 P, float size)\n{\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n#endif\n\n#ifdef USE_TRIANGLE_DOT\nfloat marker(vec2 P, float size)\n{\n    float dot_ = min(size/8.0 + v_linewidth/15.0 - u_antialias - length(P), 0.0);\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    float triangle = max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n    return max(triangle, dot_);\n}\n#endif\n\n#ifdef USE_INVERTED_TRIANGLE\n// inverted_triangle\nfloat marker(vec2 P, float size)\n{\n    P.y += size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = - P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n#endif\n\n#ifdef USE_CROSS\n// cross\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.0;\n    float cross = min(abs(P.x), abs(P.y));\n    cross = max(cross - v_linewidth/2.0 + u_antialias/2.0, 0.0);\n    return max(square, cross);\n}\n#endif\n\n#ifdef USE_DASH\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.0;\n    float cross = abs(P.y);\n    cross = max(cross - v_linewidth/2.0 + u_antialias/2.0, 0.0);\n    return max(square, cross);\n}\n#endif\n\n#ifdef USE_CIRCLE_CROSS\n// circle_cross\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_SQUARE_CROSS\n// square_cross\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_DIAMOND_CROSS\n// diamond_cross\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float diamond = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    diamond /= SQRT_2;\n    float c1 = max(diamond, s1);\n    float c2 = max(diamond, s2);\n    float c3 = max(diamond, s3);\n    float c4 = max(diamond, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_X\n// x\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 2.0;\n    float X = min(abs(P.x - P.y), abs(P.x + P.y));\n    X = max(X - v_linewidth/2.0, 0.0);\n    return max(circle, X);\n}\n#endif\n\n#ifdef USE_Y\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 2.0;\n\n    float dx = 1.0 / SQRT_3;\n    float dy = SQRT_2 / SQRT_3;\n\n    // Sideways distance from the three spokes.\n    float d0 = abs(P.x);\n    float d1 = abs(dot(P, vec2(dx, dy)));\n    float d2 = abs(dot(P, vec2(dx, -dy)));\n\n    // Clip each spoke to semicircle.\n    d0 = max(d0, -P.y);\n    d1 = max(d1, dot(P, vec2(-dy, dx)));\n    d2 = max(d2, dot(P, vec2(dy, dx)));\n\n    float Y = min(min(d0, d1), d2);\n    Y = max(Y - v_linewidth/2.0 + u_antialias/2.0, 0.0);\n    return max(circle, Y);\n}\n#endif\n\n#ifdef USE_CIRCLE_X\n// circle_x\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_CIRCLE_Y\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size/2.0;\n\n    float dx = 1.0 / SQRT_3;\n    float dy = SQRT_2 / SQRT_3;\n\n    // Sideways distance from the three spokes.\n    float d0 = abs(P.x);\n    float d1 = abs(dot(P, vec2(dx, dy)));\n    float d2 = abs(dot(P, vec2(dx, -dy)));\n\n    // Clip each spoke to semicircle.\n    d0 = max(d0, -P.y);\n    d1 = max(d1, dot(P, vec2(-dy, dx)));\n    d2 = max(d2, dot(P, vec2(dy, dx)));\n\n    float Y = min(min(d0, d1), d2);\n    Y = min(v_linewidth/2.0 - u_antialias/2.0 - Y, 0.0);\n\n    return max(circle, Y);\n}\n#endif\n\n#ifdef USE_SQUARE_X\n// square_x\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n#endif\n\n#ifdef USE_PLUS\nfloat marker(vec2 P, float size)\n{\n    vec2 size2 = vec2(size*0.5, size*0.2);\n    P = abs(P);\n    P = (P.y > P.x) ? P.yx : P.xy;\n    vec2 q = P - size2;\n    float k = max(q.y, q.x);\n    vec2 w = (k > 0.0) ? q : vec2(size2.y - P.x, -k);\n    return sign(k)*length(max(w, 0.0));\n}\n#endif\n\n#ifdef USE_SQUARE_PIN\nfloat marker(vec2 P, float size)\n{\n    float actual_size = size*1.2;\n    float radius = 0.75*actual_size; // Radius of curvature of edges.\n    float offset = actual_size/2.0 + sqrt(radius*radius - actual_size*actual_size/4.0);\n    vec2 centerx = vec2(offset, 0.0);\n    vec2 centery = vec2(0.0, offset);\n\n    float right = length(P - centerx);\n    float left = length(P + centerx);\n    float up = length(P - centery);\n    float down = length(P + centery);\n    float pin = radius - min(min(right, left), min(up, down));\n\n    float circle = length(P) - actual_size*0.6;\n    return max(circle, pin);\n}\n#endif\n\n#ifdef USE_TRIANGLE_PIN\nfloat marker(vec2 P, float size)\n{\n    float actual_size = size*1.2;\n    float radius = 1.2*actual_size; // Radius of curvature of edges.\n\n    float angle = 2.0*PI / 3.0;\n    float c = cos(angle);\n    float s = sin(angle);\n    mat2 rotation = mat2(c, -s, s, c);\n\n    // Half the length of straight triangle edge.\n    float half_edge = actual_size*SQRT_3/4.0;\n    // Distance from center of triangle to middle of straight edge.\n    float centre_middle_edge = 0.25*actual_size;\n    float offset = centre_middle_edge + sqrt(radius*radius - half_edge*half_edge);\n    // Centre of curvature.\n    vec2 center = vec2(0.0, offset);\n\n    float dist0 = length(P - center);\n    P = rotation*P;\n    float dist1 = length(P - center);\n    P = rotation*P;\n    float dist2 = length(P - center);\n    float pin = radius - min(min(dist0, dist1), dist2);\n\n    float circle = length(P) - actual_size / 2.0;\n    return max(circle, pin);\n}\n#endif\n\nvec4 outline(float distance, float linewidth, float antialias, vec4 line_color,\n             vec4 fill_color)\n{\n    vec4 frag_color;\n    float t = min(linewidth/2.0 - antialias, 0.0);  // Line half-width.\n    float signed_distance = distance;\n    float border_distance = abs(signed_distance) - t;\n    float alpha = border_distance/antialias;\n    alpha = exp(-alpha*alpha);\n\n    // If line alpha is zero, it probably means no outline. To avoid a dark\n    // outline shining through due to antialiasing, we set the line color to the\n    // fill color.\n    float select = float(bool(line_color.a));\n    line_color.rgb = select*line_color.rgb + (1.0 - select)*fill_color.rgb;\n    // Similarly, if we want a transparent fill.\n    select = float(bool(fill_color.a));\n    fill_color.rgb = select*fill_color.rgb + (1.0 - select)*line_color.rgb;\n\n    if (border_distance < 0.0)\n        frag_color = line_color;\n    else if (signed_distance < 0.0)\n        frag_color = mix(fill_color, line_color, sqrt(alpha));\n    else {\n        if (abs(signed_distance) < linewidth/2.0 + antialias)\n            frag_color = vec4(line_color.rgb, line_color.a*alpha);\n        else\n            discard;\n    }\n    return frag_color;\n}\n\nvoid main()\n{\n    float distance = marker(v_coords, v_size);\n    gl_FragColor = outline(\n        distance, v_linewidth, u_antialias, v_line_color, v_fill_color);\n    gl_FragColor.rgb *= gl_FragColor.a;  // Premultiplied alpha.\n}\n"},
415: function _(n,t,a,i,e){i();a.default="\nprecision mediump float;\n\nattribute vec2 a_position;\nattribute vec2 a_center;\nattribute float a_width;\nattribute float a_height;\nattribute float a_angle; // In radians\nattribute float a_linewidth;\nattribute vec4 a_line_color;\nattribute vec4 a_fill_color;\nattribute float a_line_join;\nattribute float a_show;\n#ifdef HATCH\nattribute float a_hatch_pattern;\nattribute float a_hatch_scale;\nattribute float a_hatch_weight;\nattribute vec4 a_hatch_color;\n#endif\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform float u_antialias;\n\nvarying float v_linewidth;\nvarying vec2 v_size; // 2D size for rects compared to 1D for markers.\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying float v_line_join;\nvarying vec2 v_coords;\n#ifdef HATCH\nvarying float v_hatch_pattern;\nvarying float v_hatch_scale;\nvarying float v_hatch_weight;\nvarying vec4 v_hatch_color;\nvarying vec2 v_hatch_coords;\n#endif\n\nvoid main()\n{\n  if (a_show < 0.5) {\n    // Do not show this rect.\n    gl_Position = vec4(-2.0, -2.0, 0.0, 1.0);\n    return;\n  }\n\n  v_size = vec2(a_width, a_height);\n  v_linewidth = a_linewidth;\n  v_line_color = a_line_color;\n  v_fill_color = a_fill_color;\n  v_line_join = a_line_join;\n\n  if (v_linewidth < 1.0) {\n    // Linewidth less than 1 is implemented as 1 but with reduced alpha.\n    v_line_color.a *= v_linewidth;\n    v_linewidth = 1.0;\n  }\n\n#ifdef HATCH\n  v_hatch_pattern = a_hatch_pattern;\n  v_hatch_scale = a_hatch_scale;\n  v_hatch_weight = a_hatch_weight;\n  v_hatch_color = a_hatch_color;\n#endif\n\n  vec2 enclosing_size = v_size + v_linewidth + u_antialias;\n\n  // Coordinates in rotated frame with respect to center of marker, used for\n  // distance functions in fragment shader.\n  v_coords = a_position*enclosing_size;\n\n  float c = cos(-a_angle);\n  float s = sin(-a_angle);\n  mat2 rotation = mat2(c, -s, s, c);\n\n  vec2 pos = a_center + rotation*v_coords;\n#ifdef HATCH\n  // Coordinates for hatching in unrotated frame of reference.\n  v_hatch_coords = pos - 0.5;\n#endif\n  pos += 0.5; // Make up for Bokeh's offset.\n  pos /= u_canvas_size / u_pixel_ratio; // 0 to 1.\n  gl_Position = vec4(2.0*pos.x - 1.0, 1.0 - 2.0*pos.y, 0.0, 1.0);\n}\n"},
416: function _(n,a,t,o,r){o();t.default="\nprecision mediump float;\n\nconst float SQRT2 = sqrt(2.0);\nconst float INVSQRT2 = 1.0/SQRT2;\nconst float PI = 3.14159265358979323846;\n\nconst int miter_join = 0;\nconst int round_join = 1;\nconst int bevel_join = 2;\n#ifdef HATCH\nconst int hatch_dot = 1;\nconst int hatch_ring = 2;\nconst int hatch_horizontal_line = 3;\nconst int hatch_vertical_line = 4;\nconst int hatch_cross = 5;\nconst int hatch_horizontal_dash = 6;\nconst int hatch_vertical_dash = 7;\nconst int hatch_spiral = 8;\nconst int hatch_right_diagonal_line = 9;\nconst int hatch_left_diagonal_line = 10;\nconst int hatch_diagonal_cross = 11;\nconst int hatch_right_diagonal_dash = 12;\nconst int hatch_left_diagonal_dash = 13;\nconst int hatch_horizontal_wave = 14;\nconst int hatch_vertical_wave = 15;\nconst int hatch_criss_cross = 16;\n#endif\n\nuniform float u_antialias;\n\nvarying float v_linewidth;\nvarying vec2 v_size;\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying float v_line_join;\nvarying vec2 v_coords;\n#ifdef HATCH\nvarying float v_hatch_pattern;\nvarying float v_hatch_scale;\nvarying float v_hatch_weight;\nvarying vec4 v_hatch_color;\nvarying vec2 v_hatch_coords;\n#endif\n\n// Distance is zero on edge of marker, +ve outside and -ve inside.\nfloat marker_distance(vec2 p, int line_join)\n{\n  vec2 dist2 = abs(p) - v_size/2.0;\n  float dist = max(dist2.x, dist2.y);\n\n  if (dist2.x > 0.0 && dist2.y > 0.0) {\n    // Outside of corner needs correct join, default is miter.\n    if (line_join == round_join)\n      dist = length(dist2);\n    else if (line_join == bevel_join) {\n      vec2 normal = vec2(INVSQRT2, INVSQRT2);\n      dist = dot(dist2, normal) + 0.5*v_linewidth*(1.0 - INVSQRT2);\n    }\n  }\n\n  return dist;\n}\n\n// Convert distance from edge of marker to fraction in range 0 to 1, depending\n// on antialiasing width.\nfloat distance_to_fraction(float dist)\n{\n  return 1.0 - smoothstep(-0.5*u_antialias, 0.5*u_antialias, dist);\n}\n\n// Return fraction from 0 (no fill color) to 1 (full fill color).\nfloat fill_fraction(float dist)\n{\n  return distance_to_fraction(dist);\n}\n\n// Return fraction in range 0 (no line color) to 1 (full line color).\nfloat line_fraction(float dist)\n{\n  return distance_to_fraction(abs(dist) - 0.5*v_linewidth);\n}\n\n// Return fraction (in range 0 to 1) of a color, with premultiplied alpha.\nvec4 fractional_color(vec4 color, float fraction)\n{\n  color.a *= fraction;\n  color.rgb *= color.a;\n  return color;\n}\n\n// Blend colors that have premultiplied alpha.\nvec4 blend_colors(vec4 src, vec4 dest)\n{\n  return (1.0 - src.a)*dest + src;\n}\n\n#ifdef HATCH\n// Wrap coordinate(s) by removing integer part to give distance from center of\n// repeat, in the range -0.5 to +0.5.\nfloat wrap(float x)\n{\n  return fract(x) - 0.5;\n}\n\nvec2 wrap(vec2 xy)\n{\n  return fract(xy) - 0.5;\n}\n\n// Return fraction from 0 (no hatch color) to 1 (full hatch color).\nfloat hatch_fraction(vec2 coords, int hatch_pattern)\n{\n  float scale = v_hatch_scale; // Hatch repeat distance.\n\n  // Coordinates and linewidth/halfwidth are scaled to hatch repeat distance.\n  coords = coords / scale;\n  float halfwidth = 0.5*v_hatch_weight / scale; // Half the hatch linewidth.\n\n  // Default is to return fraction of zero, i.e. no pattern.\n  float dist = u_antialias;\n\n  if (hatch_pattern == hatch_dot) {\n    const float dot_radius = 0.25;\n    dist = length(wrap(coords)) - dot_radius;\n  }\n  else if (hatch_pattern == hatch_ring) {\n    const float ring_radius = 0.25;\n    dist = abs(length(wrap(coords)) - ring_radius) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_horizontal_line) {\n    dist = abs(wrap(coords.y)) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_vertical_line) {\n    dist = abs(wrap(coords.x)) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_cross) {\n    dist = min(abs(wrap(coords.x)), abs(wrap(coords.y))) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_horizontal_dash) {\n    // Dashes have square caps.\n    const float halflength = 0.25;\n    dist = max(abs(wrap(coords.y)),\n               abs(wrap(coords.x) + 0.25) - halflength) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_vertical_dash) {\n    const float halflength = 0.25;\n    dist = max(abs(wrap(coords.x)),\n               abs(wrap(coords.y) + 0.25) - halflength) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_spiral) {\n    vec2 wrap2 = wrap(coords);\n    float angle = wrap(atan(wrap2.y, wrap2.x) / (2.0*PI));\n    // Canvas spiral radius increases by scale*pi/15 each rotation.\n    const float dr = PI/15.0;\n    float radius = length(wrap2);\n    // At any angle, spiral lines are equally spaced dr apart.\n    // Find distance to nearest of these lines.\n    float frac = fract((radius - dr*angle) / dr); // 0 to 1.\n    dist = dr*(abs(frac - 0.5));\n    dist = min(dist, radius) - halfwidth; // Consider center point also.\n  }\n  else if (hatch_pattern == hatch_right_diagonal_line) {\n    dist = abs(wrap(2.0*coords.x + coords.y))/sqrt(5.0) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_left_diagonal_line) {\n    dist = abs(wrap(2.0*coords.x - coords.y))/sqrt(5.0) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_diagonal_cross) {\n    coords = vec2(coords.x + coords.y + 0.5, coords.x - coords.y + 0.5);\n    dist = min(abs(wrap(coords.x)), abs(wrap(coords.y))) / SQRT2 - halfwidth;\n  }\n  else if (hatch_pattern == hatch_right_diagonal_dash) {\n    float across = coords.x + coords.y + 0.5;\n    dist = abs(wrap(across)) / SQRT2; // Distance to nearest solid line.\n\n    across = floor(across); // Offset for dash.\n    float along = wrap(0.5*(coords.x - coords.y + across));\n    const float halflength = 0.25;\n    along = abs(along) - halflength; // Distance along line.\n\n    dist = max(dist, along) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_left_diagonal_dash) {\n    float across = coords.x - coords.y + 0.5;\n    dist = abs(wrap(across)) / SQRT2; // Distance to nearest solid line.\n\n    across = floor(across); // Offset for dash.\n    float along = wrap(0.5*(coords.x + coords.y + across));\n    const float halflength = 0.25;\n    along = abs(along) - halflength; // Distance along line.\n\n    dist = max(dist, along) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_horizontal_wave) {\n    float wrapx = wrap(coords.x);\n    float wrapy = wrap(coords.y - 0.25 + abs(wrapx));\n    dist = abs(wrapy) / SQRT2 - halfwidth;\n  }\n  else if (hatch_pattern == hatch_vertical_wave) {\n    float wrapy = wrap(coords.y);\n    float wrapx = wrap(coords.x - 0.25 + abs(wrapy));\n    dist = abs(wrapx) / SQRT2 - halfwidth;\n  }\n  else if (hatch_pattern == hatch_criss_cross) {\n    float plus = min(abs(wrap(coords.x)), abs(wrap(coords.y)));\n\n    coords = vec2(coords.x + coords.y + 0.5, coords.x - coords.y + 0.5);\n    float X = min(abs(wrap(coords.x)), abs(wrap(coords.y))) / SQRT2;\n\n    dist = min(plus, X) - halfwidth;\n  }\n\n  return distance_to_fraction(dist*scale);\n}\n#endif\n\nvoid main()\n{\n  int line_join = int(v_line_join + 0.5);\n#ifdef HATCH\n  int hatch_pattern = int(v_hatch_pattern + 0.5);\n#endif\n\n  float dist = marker_distance(v_coords, line_join);\n\n  float fill_frac = fill_fraction(dist);\n  vec4 color = fractional_color(v_fill_color, fill_frac);\n\n#ifdef HATCH\n  if (hatch_pattern > 0 && fill_frac > 0.0) {\n    float hatch_frac = hatch_fraction(v_hatch_coords, hatch_pattern);\n    vec4 hatch_color = fractional_color(v_hatch_color, hatch_frac*fill_frac);\n    color = blend_colors(hatch_color, color);\n  }\n#endif\n\n  float line_frac = line_fraction(dist);\n  if (line_frac > 0.0) {\n    vec4 line_color = fractional_color(v_line_color, line_frac);\n    color = blend_colors(line_color, color);\n  }\n\n  gl_FragColor = color;\n}\n"},
417: function _(s,i,t,e,_){e();const h=s(418),l=s(22),a=s(46),n=s(419),o=s(420),r=-1e4;class p extends h.BaseGLGlyph{constructor(s,i){super(s,i),this.glyph=i,this._antialias=1.5,this._miter_limit=5}draw(s,i,t){const e=i.glglyph;this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1),e.data_changed&&(e._set_data(),e.data_changed=!1);const _=this.glyph.visuals.line,h=n.cap_lookup[_.line_cap.value],l=n.join_lookup[_.line_join.value];if(this._is_dashed()){const s={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[t.width,t.height],pixel_ratio:t.pixel_ratio,line_color:this._color,linewidth:this._linewidth,antialias:this._antialias,miter_limit:this._miter_limit,points:e._points,nsegments:e._nsegments,line_join:l,line_cap:h,length_so_far:e._length_so_far,dash_tex:this._dash_tex,dash_tex_info:this._dash_tex_info,dash_scale:this._dash_scale,dash_offset:this._dash_offset};this.regl_wrapper.dashed_line()(s)}else{const s={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[t.width,t.height],pixel_ratio:t.pixel_ratio,line_color:this._color,linewidth:this._linewidth,antialias:this._antialias,miter_limit:this._miter_limit,points:e._points,nsegments:e._nsegments,line_join:l,line_cap:h};this.regl_wrapper.solid_line()(s)}}_is_dashed(){return this._line_dash.length>0}_set_data(){const s=this.glyph.sx.length;this._nsegments=s-1,null==this._is_closed&&(this._is_closed=this.glyph.sx[0]==this.glyph.sx[s-1]&&this.glyph.sy[0]==this.glyph.sy[s-1]&&isFinite(this.glyph.sx[0])&&isFinite(this.glyph.sy[0])),null==this._points&&(this._points=new o.Float32Buffer(this.regl_wrapper));const i=this._points.get_sized_array(2*(s+2));for(let t=1;t<s+1;t++)isFinite(this.glyph.sx[t-1])&&isFinite(this.glyph.sy[t-1])?(i[2*t]=this.glyph.sx[t-1],i[2*t+1]=this.glyph.sy[t-1]):(i[2*t]=r,i[2*t+1]=r);if(this._is_closed?(i[0]=i[2*s-2],i[1]=i[2*s-1],i[2*s+2]=i[4],i[2*s+3]=i[5]):(i[0]=r,i[1]=r,i[2*s+2]=r,i[2*s+3]=r),this._points.update(),this._is_dashed()){null==this._length_so_far&&(this._length_so_far=new o.Float32Buffer(this.regl_wrapper));const s=this._length_so_far.get_sized_array(this._nsegments);let t=0;for(let e=0;e<this._nsegments;e++)s[e]=t,i[2*e+2]>-9e3&&i[2*e+4]>-9e3&&(t+=Math.sqrt((i[2*e+4]-i[2*e+2])**2+(i[2*e+5]-i[2*e+3])**2));this._length_so_far.update()}}_set_visuals(){const s=this.glyph.visuals.line,i=(0,l.color2rgba)(s.line_color.value,s.line_alpha.value);this._color=i.map((s=>s/255)),this._linewidth=s.line_width.value,this._linewidth<1&&(this._color[3]*=this._linewidth,this._linewidth=1),this._line_dash=(0,a.resolve_line_dash)(s.line_dash.value),1==this._line_dash.length&&this._line_dash.push(this._line_dash[0]),this._is_dashed()&&([this._dash_tex_info,this._dash_tex,this._dash_scale]=this.regl_wrapper.get_dash(this._line_dash),this._dash_offset=s.line_dash_offset.value)}}t.LineGL=p,p.__name__="LineGL"},
418: function _(e,t,s,i,h){i();class a{constructor(e,t){this.glyph=t,this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1,this.regl_wrapper=e}set_data_changed(){const{data_size:e}=this.glyph;e!=this.nvertices&&(this.nvertices=e,this.size_changed=!0),this.data_changed=!0}set_visuals_changed(){this.visuals_changed=!0}render(e,t,s){if(0==t.length)return!0;const{width:i,height:h}=this.glyph.renderer.plot_view.canvas_view.webgl.canvas,a={pixel_ratio:this.glyph.renderer.plot_view.canvas_view.pixel_ratio,width:i,height:h};return this.draw(t,s,a),!0}}s.BaseGLGlyph=a,a.__name__="BaseGLGlyph"},
419: function _(a,o,i,n,l){n();const t=a(52);i.cap_lookup={butt:0,round:1,square:2},i.join_lookup={miter:0,round:1,bevel:2};const _={blank:0,dot:1,ring:2,horizontal_line:3,vertical_line:4,cross:5,horizontal_dash:6,vertical_dash:7,spiral:8,right_diagonal_line:9,left_diagonal_line:10,diagonal_cross:11,right_diagonal_dash:12,left_diagonal_dash:13,horizontal_wave:14,vertical_wave:15,criss_cross:16};i.hatch_pattern_to_index=function(a){var o,i;return null!==(i=_[null!==(o=t.hatch_aliases[a])&&void 0!==o?o:a])&&void 0!==i?i:0}},
420: function _(r,t,a,e,s){e();const i=r(419),_=r(22);class n{constructor(r){this.regl_wrapper=r,this.is_scalar=!0}get_sized_array(r){return null!=this.array&&this.array.length==r||(this.array=this.new_array(r)),this.array}is_normalized(){return!1}get length(){return this.array.length}set_from_array(r){const t=r.length,a=this.get_sized_array(t);for(let e=0;e<t;e++)a[e]=r[e];this.update()}set_from_prop(r,t=4){const a=r.is_Scalar()?t:r.length,e=this.get_sized_array(a);for(let t=0;t<a;t++)e[t]=r.get(t);this.update(r.is_Scalar())}to_attribute_config(r=0){return{buffer:this.buffer,divisor:this.is_scalar?0:1,normalized:this.is_normalized(),offset:r}}update(r=!1){null==this.buffer?this.buffer=this.regl_wrapper.buffer({usage:"dynamic",data:this.array}):this.buffer({data:this.array}),this.is_scalar=r}}n.__name__="WrappedBuffer";class l extends n{new_array(r){return new Float32Array(r)}}a.Float32Buffer=l,l.__name__="Float32Buffer";class o extends n{new_array(r){return new Uint8Array(r)}set_from_color(r,t,a=4){const e=r.is_Scalar()&&t.is_Scalar(),s=e?a:r.length,i=this.get_sized_array(4*s);for(let a=0;a<s;a++){const[e,s,n,l]=(0,_.color2rgba)(r.get(a),t.get(a));i[4*a]=e,i[4*a+1]=s,i[4*a+2]=n,i[4*a+3]=l}this.update(e)}set_from_hatch_pattern(r,t=4){const a=r.is_Scalar()?t:r.length,e=this.get_sized_array(a);for(let t=0;t<a;t++)e[t]=(0,i.hatch_pattern_to_index)(r.get(t));this.update(r.is_Scalar())}set_from_line_join(r,t=4){const a=r.is_Scalar()?t:r.length,e=this.get_sized_array(a);for(let t=0;t<a;t++)e[t]=i.join_lookup[r.get(t)];this.update(r.is_Scalar())}}a.Uint8Buffer=o,o.__name__="Uint8Buffer";class f extends o{is_normalized(){return!0}}a.NormalizedUint8Buffer=f,f.__name__="NormalizedUint8Buffer"},
421: function _(t,h,s,i,e){i();const _=t(418),a=t(420),r=-1e4;class l extends _.BaseGLGlyph{constructor(t,h){super(t,h),this.glyph=h,this._antialias=1.5}draw(t,h,s){const i=h.glglyph;i.data_changed&&(i._set_data(),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1);const e=i._centers.length/2;null==this._show&&(this._show=new a.Uint8Buffer(this.regl_wrapper));const _=this._show.get_sized_array(e);if(t.length<e){this._show_all=!1;for(let t=0;t<e;t++)_[t]=0;for(let h=0;h<t.length;h++)_[t[h]]=255}else if(!this._show_all){this._show_all=!0;for(let t=0;t<e;t++)_[t]=255}if(this._show.update(),this._have_hatch){const t={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[s.width,s.height],pixel_ratio:s.pixel_ratio,center:i._centers,width:i._widths,height:i._heights,angle:i._angles,nmarkers:e,antialias:this._antialias,linewidth:this._linewidths,line_color:this._line_rgba,fill_color:this._fill_rgba,line_join:this._line_joins,show:this._show,hatch_pattern:this._hatch_patterns,hatch_scale:this._hatch_scales,hatch_weight:this._hatch_weights,hatch_color:this._hatch_rgba};this.regl_wrapper.rect_hatch()(t)}else{const t={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[s.width,s.height],pixel_ratio:s.pixel_ratio,center:i._centers,width:i._widths,height:i._heights,angle:i._angles,nmarkers:e,antialias:this._antialias,linewidth:this._linewidths,line_color:this._line_rgba,fill_color:this._fill_rgba,line_join:this._line_joins,show:this._show};this.regl_wrapper.rect_no_hatch()(t)}}_set_data(){const t=this.glyph.sx.length;null==this._centers&&(this._centers=new a.Float32Buffer(this.regl_wrapper),this._widths=new a.Float32Buffer(this.regl_wrapper),this._heights=new a.Float32Buffer(this.regl_wrapper),this._angles=new a.Float32Buffer(this.regl_wrapper));const h=this._centers.get_sized_array(2*t);for(let s=0;s<t;s++)isFinite(this.glyph.sx[s])&&isFinite(this.glyph.sy[s])?(h[2*s]=this.glyph.sx[s],h[2*s+1]=this.glyph.sy[s]):(h[2*s]=r,h[2*s+1]=r);this._centers.update(),this._widths.set_from_array(this.glyph.sw),this._heights.set_from_array(this.glyph.sh),this._angles.set_from_prop(this.glyph.angle)}_set_visuals(){const t=this.glyph.visuals.fill,h=this.glyph.visuals.line;if(null==this._linewidths&&(this._linewidths=new a.Float32Buffer(this.regl_wrapper),this._line_joins=new a.Uint8Buffer(this.regl_wrapper),this._line_rgba=new a.NormalizedUint8Buffer(this.regl_wrapper),this._fill_rgba=new a.NormalizedUint8Buffer(this.regl_wrapper)),this._linewidths.set_from_prop(h.line_width),this._line_joins.set_from_line_join(h.line_join),this._line_rgba.set_from_color(h.line_color,h.line_alpha),this._fill_rgba.set_from_color(t.fill_color,t.fill_alpha),this._have_hatch=this.glyph.visuals.hatch.doit,this._have_hatch){const t=this.glyph.visuals.hatch;null==this._hatch_patterns&&(this._hatch_patterns=new a.Uint8Buffer(this.regl_wrapper),this._hatch_scales=new a.Float32Buffer(this.regl_wrapper),this._hatch_weights=new a.Float32Buffer(this.regl_wrapper),this._hatch_rgba=new a.NormalizedUint8Buffer(this.regl_wrapper)),this._hatch_patterns.set_from_hatch_pattern(t.hatch_pattern),this._hatch_scales.set_from_prop(t.hatch_scale),this._hatch_weights.set_from_prop(t.hatch_weight),this._hatch_rgba.set_from_color(t.hatch_color,t.hatch_alpha)}}}s.RectGL=l,l.__name__="RectGL"},
422: function _(s,e,t,i,a){i();const r=s(418),l=s(420),_=-1e4;function h(s){return"Circle"==s.model.type}class n extends r.BaseGLGlyph{constructor(s,e,t){super(s,e),this.glyph=e,this.marker_type=t,this._marker_type=t,this._antialias=.8,this._show_all=!1}static is_supported(s){switch(s){case"asterisk":case"circle":case"circle_cross":case"circle_dot":case"circle_x":case"circle_y":case"cross":case"dash":case"diamond":case"diamond_cross":case"diamond_dot":case"dot":case"hex":case"hex_dot":case"inverted_triangle":case"plus":case"square":case"square_cross":case"square_dot":case"square_pin":case"square_x":case"star":case"star_dot":case"triangle":case"triangle_dot":case"triangle_pin":case"x":case"y":return!0;default:return!1}}draw(s,e,t){const i=e.glglyph;(i.data_changed||h(this.glyph))&&(i._set_data(),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1);const a=i._centers.length/2;null==this._show&&(this._show=new l.Uint8Buffer(this.regl_wrapper));const r=this._show.get_sized_array(a);if(s.length<a){this._show_all=!1;for(let s=0;s<a;s++)r[s]=0;for(let e=0;e<s.length;e++)r[s[e]]=255}else if(!this._show_all){this._show_all=!0;for(let s=0;s<a;s++)r[s]=255}this._show.update();const _={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[t.width,t.height],pixel_ratio:t.pixel_ratio,center:i._centers,size:i._sizes,angle:i._angles,nmarkers:a,antialias:this._antialias,linewidth:this._linewidths,line_color:this._line_rgba,fill_color:this._fill_rgba,show:this._show};this.regl_wrapper.marker(this._marker_type)(_)}_set_data(){const s=this.glyph.sx.length;null==this._centers&&(this._centers=new l.Float32Buffer(this.regl_wrapper),this._sizes=new l.Float32Buffer(this.regl_wrapper),this._angles=new l.Float32Buffer(this.regl_wrapper));const e=this._centers.get_sized_array(2*s);for(let t=0;t<s;t++)isFinite(this.glyph.sx[t])&&isFinite(this.glyph.sy[t])?(e[2*t]=this.glyph.sx[t],e[2*t+1]=this.glyph.sy[t]):(e[2*t]=_,e[2*t+1]=_);if(this._centers.update(),h(this.glyph)&&null!=this.glyph.radius){const e=this._sizes.get_sized_array(s);for(let t=0;t<s;t++)e[t]=2*this.glyph.sradius[t];this._sizes.update()}else this._sizes.set_from_prop(this.glyph.size);this._angles.set_from_prop(this.glyph.angle)}_set_visuals(){const s=this.glyph.visuals.fill,e=this.glyph.visuals.line;null==this._linewidths&&(this._linewidths=new l.Float32Buffer(this.regl_wrapper),this._line_rgba=new l.NormalizedUint8Buffer(this.regl_wrapper),this._fill_rgba=new l.NormalizedUint8Buffer(this.regl_wrapper)),this._linewidths.set_from_prop(e.line_width),this._line_rgba.set_from_color(e.line_color,e.line_alpha),this._fill_rgba.set_from_color(s.fill_color,s.fill_alpha)}}t.MarkerGL=n,n.__name__="MarkerGL"},
}, 405, {"models/glyphs/webgl/main":405,"models/glyphs/webgl/index":406,"models/glyphs/webgl/regl_wrap":407,"models/glyphs/webgl/dash_cache":409,"models/glyphs/webgl/utils/math":410,"models/glyphs/webgl/regl_line.vert":411,"models/glyphs/webgl/regl_line.frag":412,"models/glyphs/webgl/markers.vert":413,"models/glyphs/webgl/markers.frag":414,"models/glyphs/webgl/rect.vert":415,"models/glyphs/webgl/rect.frag":416,"models/glyphs/webgl/line_gl":417,"models/glyphs/webgl/base":418,"models/glyphs/webgl/webgl_utils":419,"models/glyphs/webgl/buffer":420,"models/glyphs/webgl/rect":421,"models/glyphs/webgl/markers":422}, {});});
