# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/verifiable-credentials/v1/verifiable-credentials.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...common import v1 as __common_v1__


if TYPE_CHECKING:
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class IssueRequest(betterproto.Message):
    document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class IssueResponse(betterproto.Message):
    signed_document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class IssueFromTemplateRequest(betterproto.Message):
    template_id: str = betterproto.string_field(1)
    values_json: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class IssueFromTemplateResponse(betterproto.Message):
    document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class CreateProofRequest(betterproto.Message):
    """Create Proof"""

    reveal_document_json: str = betterproto.string_field(1)
    """
    Optional document that describes which fields should be revealed in the
    generated proof. If specified, this document must be a valid JSON-LD frame.
    If this field is not specified, a default reveal document will be used and
    all fields in the signed document will be revealed
    """

    item_id: str = betterproto.string_field(2, group="proof")
    """
    The item identifier that contains a record with a verifiable credential to
    be used for generating the proof.
    """

    document_json: str = betterproto.string_field(3, group="proof")
    """
    A document that contains a valid verifiable credential with an unbound
    signature. The proof will be derived from this document directly. The
    document will not be stored in the wallet.
    """


@dataclass(eq=False, repr=False)
class CreateProofResponse(betterproto.Message):
    proof_document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class VerifyProofRequest(betterproto.Message):
    """Verify Proof"""

    proof_document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class VerifyProofResponse(betterproto.Message):
    is_valid: bool = betterproto.bool_field(1)
    """Indicates if the proof is valid"""

    validation_messages: List[str] = betterproto.string_field(2)
    """
    Validation messages that describe invalid verifications based on different
    factors, such as schema validation, proof verification, revocation registry
    membership, etc. If the proof is not valid, this field will contain
    detailed results where this verification failed.
    """


@dataclass(eq=False, repr=False)
class SendRequest(betterproto.Message):
    email: str = betterproto.string_field(1, group="delivery_method")
    did_uri: str = betterproto.string_field(2, group="delivery_method")
    didcomm_invitation_json: str = betterproto.string_field(3, group="delivery_method")
    document_json: str = betterproto.string_field(100)


@dataclass(eq=False, repr=False)
class SendResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class UpdateStatusRequest(betterproto.Message):
    """request object to update the status of the revocation entry"""

    credential_status_id: str = betterproto.string_field(1)
    """the credential status id"""

    revoked: bool = betterproto.bool_field(2)
    """indicates if the status is revoked"""


@dataclass(eq=False, repr=False)
class UpdateStatusResponse(betterproto.Message):
    """response object for update of status of revocation entry"""

    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class CheckStatusRequest(betterproto.Message):
    """request object to update the status of the revocation entry"""

    credential_status_id: str = betterproto.string_field(1)
    """the credential status id"""


@dataclass(eq=False, repr=False)
class CheckStatusResponse(betterproto.Message):
    """response object for update of status of revocation entry"""

    revoked: bool = betterproto.bool_field(1)
    """indicates if the status is revoked"""


class VerifiableCredentialStub(betterproto.ServiceStub):
    async def issue(
        self,
        issue_request: "IssueRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "IssueResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/Issue",
            issue_request,
            IssueResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def issue_from_template(
        self,
        issue_from_template_request: "IssueFromTemplateRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "IssueFromTemplateResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/IssueFromTemplate",
            issue_from_template_request,
            IssueFromTemplateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def check_status(
        self,
        check_status_request: "CheckStatusRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "CheckStatusResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/CheckStatus",
            check_status_request,
            CheckStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_status(
        self,
        update_status_request: "UpdateStatusRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "UpdateStatusResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/UpdateStatus",
            update_status_request,
            UpdateStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_proof(
        self,
        create_proof_request: "CreateProofRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "CreateProofResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/CreateProof",
            create_proof_request,
            CreateProofResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def verify_proof(
        self,
        verify_proof_request: "VerifyProofRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "VerifyProofResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/VerifyProof",
            verify_proof_request,
            VerifyProofResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def send(
        self,
        send_request: "SendRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "SendResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/Send",
            send_request,
            SendResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class VerifiableCredentialBase(ServiceBase):
    async def issue(self, issue_request: "IssueRequest") -> "IssueResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def issue_from_template(
        self, issue_from_template_request: "IssueFromTemplateRequest"
    ) -> "IssueFromTemplateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def check_status(
        self, check_status_request: "CheckStatusRequest"
    ) -> "CheckStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_status(
        self, update_status_request: "UpdateStatusRequest"
    ) -> "UpdateStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_proof(
        self, create_proof_request: "CreateProofRequest"
    ) -> "CreateProofResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def verify_proof(
        self, verify_proof_request: "VerifyProofRequest"
    ) -> "VerifyProofResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def send(self, send_request: "SendRequest") -> "SendResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_issue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.issue(request)
        await stream.send_message(response)

    async def __rpc_issue_from_template(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.issue_from_template(request)
        await stream.send_message(response)

    async def __rpc_check_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.check_status(request)
        await stream.send_message(response)

    async def __rpc_update_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.update_status(request)
        await stream.send_message(response)

    async def __rpc_create_proof(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.create_proof(request)
        await stream.send_message(response)

    async def __rpc_verify_proof(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.verify_proof(request)
        await stream.send_message(response)

    async def __rpc_send(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.send(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.verifiablecredentials.v1.VerifiableCredential/Issue": grpclib.const.Handler(
                self.__rpc_issue,
                grpclib.const.Cardinality.UNARY_UNARY,
                IssueRequest,
                IssueResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/IssueFromTemplate": grpclib.const.Handler(
                self.__rpc_issue_from_template,
                grpclib.const.Cardinality.UNARY_UNARY,
                IssueFromTemplateRequest,
                IssueFromTemplateResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/CheckStatus": grpclib.const.Handler(
                self.__rpc_check_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                CheckStatusRequest,
                CheckStatusResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/UpdateStatus": grpclib.const.Handler(
                self.__rpc_update_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateStatusRequest,
                UpdateStatusResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/CreateProof": grpclib.const.Handler(
                self.__rpc_create_proof,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateProofRequest,
                CreateProofResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/VerifyProof": grpclib.const.Handler(
                self.__rpc_verify_proof,
                grpclib.const.Cardinality.UNARY_UNARY,
                VerifyProofRequest,
                VerifyProofResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/Send": grpclib.const.Handler(
                self.__rpc_send,
                grpclib.const.Cardinality.UNARY_UNARY,
                SendRequest,
                SendResponse,
            ),
        }
