# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/trust-registry/v1/trust-registry.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterator,
    Dict,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...common import v1 as __common_v1__


if TYPE_CHECKING:
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class RegistrationStatus(betterproto.Enum):
    CURRENT = 0
    EXPIRED = 1
    TERMINATED = 2
    REVOKED = 3
    NOT_FOUND = 10


@dataclass(eq=False, repr=False)
class AddFrameworkRequest(betterproto.Message):
    governance_framework: "GovernanceFramework" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AddFrameworkResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class RemoveFrameworkRequest(betterproto.Message):
    governance_framework: "GovernanceFramework" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RemoveFrameworkResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class SearchRegistryRequest(betterproto.Message):
    query: str = betterproto.string_field(1)
    continuation_token: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SearchRegistryResponse(betterproto.Message):
    items_json: str = betterproto.string_field(1)
    has_more: bool = betterproto.bool_field(2)
    count: int = betterproto.int32_field(3)
    continuation_token: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class GovernanceFramework(betterproto.Message):
    governance_framework_uri: str = betterproto.string_field(1)
    trust_registry_uri: str = betterproto.string_field(2)
    description: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class RegisterIssuerRequest(betterproto.Message):
    did_uri: str = betterproto.string_field(1, group="authority")
    x509_cert: str = betterproto.string_field(2, group="authority")
    credential_type_uri: str = betterproto.string_field(10)
    valid_from_utc: int = betterproto.uint64_field(11)
    valid_until_utc: int = betterproto.uint64_field(12)
    governance_framework_uri: str = betterproto.string_field(20)


@dataclass(eq=False, repr=False)
class RegisterIssuerResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class RegisterVerifierRequest(betterproto.Message):
    did_uri: str = betterproto.string_field(1, group="authority")
    x509_cert: str = betterproto.string_field(2, group="authority")
    presentation_type_uri: str = betterproto.string_field(10)
    valid_from_utc: int = betterproto.uint64_field(11)
    valid_until_utc: int = betterproto.uint64_field(12)
    governance_framework_uri: str = betterproto.string_field(20)


@dataclass(eq=False, repr=False)
class RegisterVerifierResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class UnregisterIssuerRequest(betterproto.Message):
    did_uri: str = betterproto.string_field(1, group="authority")
    x509_cert: str = betterproto.string_field(2, group="authority")
    credential_type_uri: str = betterproto.string_field(10)
    governance_framework_uri: str = betterproto.string_field(20)


@dataclass(eq=False, repr=False)
class UnregisterIssuerResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class UnregisterVerifierRequest(betterproto.Message):
    did_uri: str = betterproto.string_field(1, group="authority")
    x509_cert: str = betterproto.string_field(2, group="authority")
    presentation_type_uri: str = betterproto.string_field(10)
    governance_framework_uri: str = betterproto.string_field(20)


@dataclass(eq=False, repr=False)
class UnregisterVerifierResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class CheckIssuerStatusRequest(betterproto.Message):
    governance_framework_uri: str = betterproto.string_field(1)
    did_uri: str = betterproto.string_field(2, group="member")
    x509_cert: str = betterproto.string_field(3, group="member")
    credential_type_uri: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class CheckIssuerStatusResponse(betterproto.Message):
    status: "RegistrationStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class CheckVerifierStatusRequest(betterproto.Message):
    governance_framework_uri: str = betterproto.string_field(1)
    did_uri: str = betterproto.string_field(2, group="member")
    x509_cert: str = betterproto.string_field(3, group="member")
    presentation_type_uri: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class CheckVerifierStatusResponse(betterproto.Message):
    status: "RegistrationStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class FetchDataRequest(betterproto.Message):
    governance_framework_uri: str = betterproto.string_field(1)
    query: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class FetchDataResponse(betterproto.Message):
    response_json: str = betterproto.string_field(1)
    has_more_results: bool = betterproto.bool_field(2)
    continuation_token: str = betterproto.string_field(3)


class TrustRegistryStub(betterproto.ServiceStub):
    async def add_framework(
        self,
        add_framework_request: "AddFrameworkRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "AddFrameworkResponse":
        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/AddFramework",
            add_framework_request,
            AddFrameworkResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def remove_framework(
        self,
        remove_framework_request: "RemoveFrameworkRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "RemoveFrameworkResponse":
        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/RemoveFramework",
            remove_framework_request,
            RemoveFrameworkResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def search_registry(
        self,
        search_registry_request: "SearchRegistryRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "SearchRegistryResponse":
        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/SearchRegistry",
            search_registry_request,
            SearchRegistryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def register_issuer(
        self,
        register_issuer_request: "RegisterIssuerRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "RegisterIssuerResponse":
        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/RegisterIssuer",
            register_issuer_request,
            RegisterIssuerResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def register_verifier(
        self,
        register_verifier_request: "RegisterVerifierRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "RegisterVerifierResponse":
        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/RegisterVerifier",
            register_verifier_request,
            RegisterVerifierResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def unregister_issuer(
        self,
        unregister_issuer_request: "UnregisterIssuerRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "UnregisterIssuerResponse":
        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/UnregisterIssuer",
            unregister_issuer_request,
            UnregisterIssuerResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def unregister_verifier(
        self,
        unregister_verifier_request: "UnregisterVerifierRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "UnregisterVerifierResponse":
        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/UnregisterVerifier",
            unregister_verifier_request,
            UnregisterVerifierResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def check_issuer_status(
        self,
        check_issuer_status_request: "CheckIssuerStatusRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "CheckIssuerStatusResponse":
        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/CheckIssuerStatus",
            check_issuer_status_request,
            CheckIssuerStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def check_verifier_status(
        self,
        check_verifier_status_request: "CheckVerifierStatusRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "CheckVerifierStatusResponse":
        return await self._unary_unary(
            "/services.trustregistry.v1.TrustRegistry/CheckVerifierStatus",
            check_verifier_status_request,
            CheckVerifierStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def fetch_data(
        self,
        fetch_data_request: "FetchDataRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> AsyncIterator["FetchDataResponse"]:
        async for response in self._unary_stream(
            "/services.trustregistry.v1.TrustRegistry/FetchData",
            fetch_data_request,
            FetchDataResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class TrustRegistryBase(ServiceBase):
    async def add_framework(
        self, add_framework_request: "AddFrameworkRequest"
    ) -> "AddFrameworkResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_framework(
        self, remove_framework_request: "RemoveFrameworkRequest"
    ) -> "RemoveFrameworkResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def search_registry(
        self, search_registry_request: "SearchRegistryRequest"
    ) -> "SearchRegistryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def register_issuer(
        self, register_issuer_request: "RegisterIssuerRequest"
    ) -> "RegisterIssuerResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def register_verifier(
        self, register_verifier_request: "RegisterVerifierRequest"
    ) -> "RegisterVerifierResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unregister_issuer(
        self, unregister_issuer_request: "UnregisterIssuerRequest"
    ) -> "UnregisterIssuerResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unregister_verifier(
        self, unregister_verifier_request: "UnregisterVerifierRequest"
    ) -> "UnregisterVerifierResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def check_issuer_status(
        self, check_issuer_status_request: "CheckIssuerStatusRequest"
    ) -> "CheckIssuerStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def check_verifier_status(
        self, check_verifier_status_request: "CheckVerifierStatusRequest"
    ) -> "CheckVerifierStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_data(
        self, fetch_data_request: "FetchDataRequest"
    ) -> AsyncIterator["FetchDataResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_add_framework(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.add_framework(request)
        await stream.send_message(response)

    async def __rpc_remove_framework(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.remove_framework(request)
        await stream.send_message(response)

    async def __rpc_search_registry(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.search_registry(request)
        await stream.send_message(response)

    async def __rpc_register_issuer(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.register_issuer(request)
        await stream.send_message(response)

    async def __rpc_register_verifier(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.register_verifier(request)
        await stream.send_message(response)

    async def __rpc_unregister_issuer(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.unregister_issuer(request)
        await stream.send_message(response)

    async def __rpc_unregister_verifier(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.unregister_verifier(request)
        await stream.send_message(response)

    async def __rpc_check_issuer_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.check_issuer_status(request)
        await stream.send_message(response)

    async def __rpc_check_verifier_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.check_verifier_status(request)
        await stream.send_message(response)

    async def __rpc_fetch_data(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.fetch_data,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.trustregistry.v1.TrustRegistry/AddFramework": grpclib.const.Handler(
                self.__rpc_add_framework,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddFrameworkRequest,
                AddFrameworkResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/RemoveFramework": grpclib.const.Handler(
                self.__rpc_remove_framework,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemoveFrameworkRequest,
                RemoveFrameworkResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/SearchRegistry": grpclib.const.Handler(
                self.__rpc_search_registry,
                grpclib.const.Cardinality.UNARY_UNARY,
                SearchRegistryRequest,
                SearchRegistryResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/RegisterIssuer": grpclib.const.Handler(
                self.__rpc_register_issuer,
                grpclib.const.Cardinality.UNARY_UNARY,
                RegisterIssuerRequest,
                RegisterIssuerResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/RegisterVerifier": grpclib.const.Handler(
                self.__rpc_register_verifier,
                grpclib.const.Cardinality.UNARY_UNARY,
                RegisterVerifierRequest,
                RegisterVerifierResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/UnregisterIssuer": grpclib.const.Handler(
                self.__rpc_unregister_issuer,
                grpclib.const.Cardinality.UNARY_UNARY,
                UnregisterIssuerRequest,
                UnregisterIssuerResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/UnregisterVerifier": grpclib.const.Handler(
                self.__rpc_unregister_verifier,
                grpclib.const.Cardinality.UNARY_UNARY,
                UnregisterVerifierRequest,
                UnregisterVerifierResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/CheckIssuerStatus": grpclib.const.Handler(
                self.__rpc_check_issuer_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                CheckIssuerStatusRequest,
                CheckIssuerStatusResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/CheckVerifierStatus": grpclib.const.Handler(
                self.__rpc_check_verifier_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                CheckVerifierStatusRequest,
                CheckVerifierStatusResponse,
            ),
            "/services.trustregistry.v1.TrustRegistry/FetchData": grpclib.const.Handler(
                self.__rpc_fetch_data,
                grpclib.const.Cardinality.UNARY_STREAM,
                FetchDataRequest,
                FetchDataResponse,
            ),
        }
