# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/provider/v1/provider.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...account import v1 as __account_v1__
from ...common import v1 as __common_v1__


if TYPE_CHECKING:
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ParticipantType(betterproto.Enum):
    participant_type_individual = 0
    participant_type_organization = 1


class InvitationStatusResponseStatus(betterproto.Enum):
    Error = 0
    """Onboarding resulted in error"""

    InvitationSent = 1
    """The participant has been invited"""

    Completed = 2
    """The participant has been onboarded"""

    Expired = 3
    """The invite has expired"""


@dataclass(eq=False, repr=False)
class Invite(betterproto.Message):
    id: str = betterproto.string_field(1)
    code: str = betterproto.string_field(2)
    created: str = betterproto.string_field(3)
    accepted: str = betterproto.string_field(4)
    expires: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class InviteRequest(betterproto.Message):
    participant: "ParticipantType" = betterproto.enum_field(1)
    description: str = betterproto.string_field(2)
    details: "__account_v1__.AccountDetails" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class InviteRequestDidCommInvitation(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class InviteResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)
    invitation_id: str = betterproto.string_field(10)
    invitation_code: str = betterproto.string_field(11)
    """
    Invitation Code that must be passed with the account 'SignIn' request to
    correlate this user with the invitation sent.
    """


@dataclass(eq=False, repr=False)
class InvitationStatusRequest(betterproto.Message):
    """
    Request details for the status of onboarding an individual or organization.
    The reference_id passed is the response from the `Onboard` method call
    """

    invitation_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class InvitationStatusResponse(betterproto.Message):
    status: "InvitationStatusResponseStatus" = betterproto.enum_field(1)
    status_details: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Ecosystem(betterproto.Message):
    id: str = betterproto.string_field(1)
    name: str = betterproto.string_field(2)
    description: str = betterproto.string_field(3)
    uri: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class CreateEcosystemRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    Globally unique name for the Ecosystem. This name will be part of the
    ecosystem specific URLs and namespaces. Allowed characters are lowercase
    letters, numbers, underscore and hyphen.
    """

    description: str = betterproto.string_field(2)
    """Ecosystem description. This field is optional."""

    uri: str = betterproto.string_field(3)
    """
    External URL associated with your organization or ecosystem entity. This
    field is optional
    """

    details: "__account_v1__.AccountDetails" = betterproto.message_field(4)
    """The account details of the owner of the ecosystem"""


@dataclass(eq=False, repr=False)
class CreateEcosystemResponse(betterproto.Message):
    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Details of the created ecosystem"""

    profile: "__account_v1__.AccountProfile" = betterproto.message_field(2)
    """Account profile for auth of the owner of the ecosystem"""

    confirmation_method: "__account_v1__.ConfirmationMethod" = betterproto.enum_field(3)
    """
    Indicates if confirmation of account is required. This settings is
    configured globally by the server administrator.
    """


@dataclass(eq=False, repr=False)
class GenerateTokenRequest(betterproto.Message):
    description: str = betterproto.string_field(1)
    """Optional description to identify this token"""


@dataclass(eq=False, repr=False)
class GenerateTokenResponse(betterproto.Message):
    profile: "__account_v1__.AccountProfile" = betterproto.message_field(1)
    """Account authentication profile that contains unprotected token"""


class ProviderStub(betterproto.ServiceStub):
    async def create_ecosystem(
        self,
        create_ecosystem_request: "CreateEcosystemRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "CreateEcosystemResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/CreateEcosystem",
            create_ecosystem_request,
            CreateEcosystemResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def generate_token(
        self,
        generate_token_request: "GenerateTokenRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GenerateTokenResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/GenerateToken",
            generate_token_request,
            GenerateTokenResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def invite(
        self,
        invite_request: "InviteRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "InviteResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/Invite",
            invite_request,
            InviteResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def invitation_status(
        self,
        invitation_status_request: "InvitationStatusRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "InvitationStatusResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/InvitationStatus",
            invitation_status_request,
            InvitationStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ProviderBase(ServiceBase):
    async def create_ecosystem(
        self, create_ecosystem_request: "CreateEcosystemRequest"
    ) -> "CreateEcosystemResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def generate_token(
        self, generate_token_request: "GenerateTokenRequest"
    ) -> "GenerateTokenResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def invite(self, invite_request: "InviteRequest") -> "InviteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def invitation_status(
        self, invitation_status_request: "InvitationStatusRequest"
    ) -> "InvitationStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_ecosystem(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.create_ecosystem(request)
        await stream.send_message(response)

    async def __rpc_generate_token(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.generate_token(request)
        await stream.send_message(response)

    async def __rpc_invite(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.invite(request)
        await stream.send_message(response)

    async def __rpc_invitation_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.invitation_status(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.provider.v1.Provider/CreateEcosystem": grpclib.const.Handler(
                self.__rpc_create_ecosystem,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateEcosystemRequest,
                CreateEcosystemResponse,
            ),
            "/services.provider.v1.Provider/GenerateToken": grpclib.const.Handler(
                self.__rpc_generate_token,
                grpclib.const.Cardinality.UNARY_UNARY,
                GenerateTokenRequest,
                GenerateTokenResponse,
            ),
            "/services.provider.v1.Provider/Invite": grpclib.const.Handler(
                self.__rpc_invite,
                grpclib.const.Cardinality.UNARY_UNARY,
                InviteRequest,
                InviteResponse,
            ),
            "/services.provider.v1.Provider/InvitationStatus": grpclib.const.Handler(
                self.__rpc_invitation_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                InvitationStatusRequest,
                InvitationStatusResponse,
            ),
        }
