# Repository ORM

[![Actions Status](https://github.com/lyz-code/repository-orm/workflows/Tests/badge.svg)](https://github.com/lyz-code/repository-orm/actions)
[![Actions Status](https://github.com/lyz-code/repository-orm/workflows/Build/badge.svg)](https://github.com/lyz-code/repository-orm/actions)
[![Coverage Status](https://coveralls.io/repos/github/lyz-code/repository-orm/badge.svg?branch=main)](https://coveralls.io/github/lyz-code/repository-orm?branch=main)

Library to ease the implementation of the
[repository pattern](https://lyz-code.github.io/blue-book/architecture/repository_pattern/).

One of the disadvantages of using the repository pattern is that developers need
to add and maintain a new abstraction to manage how to persist their models in
the storage. *repository-orm* aims to mitigate this inconvenient by:

- Supplying classes that already have the common operations for different
  storage solutions.
- Supplying test classes and fixtures so extending the provided repositories is
  easy.

## Help

See [documentation](https://lyz-code.github.io/repository-orm) for more details.

## Installing

```bash
pip install repository-orm
```

## Contributing

For guidance on setting up a development environment, and how to make a
contribution to *repository-orm*, see
[Contributing to repository-orm](https://lyz-code.github.io/repository-orm/contributing).

## Donations

<noscript><a href="https://liberapay.com/Lyz/donate"><img alt="Donate using
Liberapay" src="https://liberapay.com/assets/widgets/donate.svg"></a></noscript>
or
[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/T6T3GP0V8)

If you are using some of my open-source tools, have enjoyed them, and want to
say "thanks", this is a very strong way to do it.

If your product/company depends on these tools, you can sponsor me to ensure I
keep happily maintaining them.

If these tools are helping you save money, time, effort, or frustrations; or
they are helping you make money, be more productive, efficient, secure, enjoy a
bit more your work, or get your product ready faster, this is a great way to
show your appreciation. Thanks for that!

And by sponsoring me, you are helping make these tools, that already help you,
sustainable and healthy.

## License

GPLv3
