# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_assemblyai.ipynb.

# %% auto 0
__all__ = ['submit_transcript', 'upload_local_file_endpoint', 'read_file', 'AssemblyAI']

# %% ../nbs/00_assemblyai.ipynb 2
from fastcore.utils import *
import requests
import time
from os.path import exists

# %% ../nbs/00_assemblyai.ipynb 4
def read_file(filename, chunk_size=5242880):
    with open(filename, 'rb') as _file:
        while True:
            data = _file.read(chunk_size)
            if not data:
                break
            yield data

# %% ../nbs/00_assemblyai.ipynb 5
submit_transcript = "https://api.assemblyai.com/v2/transcript" # AssemblyAI endpoint
upload_local_file_endpoint = 'https://api.assemblyai.com/v2/upload' # Upload Local file

class AssemblyAI:
    ''' AssemblAI class for transcribing '''
    __version__ = '0.0.8'
    def __init__(self, #AssemblyAI
                 api_key:str # AssemblyAI API Key, Get it for free from https://app.assemblyai.com/
                ):
        self.api_key = api_key
    
    
    def get_headers(self):
        return {"authorization": self.api_key, "content-type": "application/json"}
    
    
    def get_status_of_transcription(self,
                                    transcripiton_id: str) -> str:
        endpoint = f"{submit_transcript}/{transcripiton_id}"
        response = requests.get(endpoint, headers=self.get_headers())
        
        return response.json()

# %% ../nbs/00_assemblyai.ipynb 6
@patch 
def upload_local_file(self: AssemblyAI, 
                      local_file_path: str, # Local Audio File path
                     ):
    ''' Upload the local file and get audio_url in response, which can be used to sumbit for transcription'''
    try:
        if exists(local_file_path):
            response = requests.post('https://api.assemblyai.com/v2/upload',
                            headers=self.get_headers(),
                            data=read_file(local_file_path))
            return response.json().get('upload_url')
    except BaseException as e:
        print(f'Error in processing local audio file: {e}')

    return {'error': 'Provided File has issues'}
        

# %% ../nbs/00_assemblyai.ipynb 7
@patch
def submit_audio_for_transcription(self:AssemblyAI,
                                   audio_url: str='', #Audio URL
                                   local_audio_file_path: str ='', # Local Audio File Path. Provide `audio_url` or `local_audio_file_path` . If both are provided, audio_url is used by default.   
                                   sentiment_analysis: bool = False, # Include Sentiment Analysis
                                   auto_chapters: bool = False, # Include Auto Chapaters
                                   entity_detection: bool = False, # Include Entity Detection
                                   auto_highlights: bool = False, # Include Auto Highlights 
                                   summarization: bool = False, # Include Summary 
                                   summary_type: str = "bullets", # If summary is included select `summary_type` from list [`bullets', 'bullets_verbose', 'gist', 'paragraph', 'headline']. Check out this for more details: https://www.assemblyai.com/docs/audio-intelligence#summarization 
                                   ):
        ''' Submit Audio URL or the Local file Path for Transcription '''
        
        if local_audio_file_path and not audio_url:
            audio_url = self.upload_local_file(local_audio_file_path)
        
        json = {
            "audio_url": audio_url,
            "sentiment_analysis": sentiment_analysis,
            "auto_chapters": auto_chapters,
            "entity_detection": entity_detection,
            "auto_highlights": auto_highlights,
        }
        
        json = {**json, 'summarization': True, 'summary_type': summary_type} if summarization else json
            
        
        response = requests.post(submit_transcript, json=json, headers=self.get_headers())
        return response.json()

# %% ../nbs/00_assemblyai.ipynb 8
@patch
def submit_url_for_transcription(self:AssemblyAI,
                                   audio_url: str='', #Audio URL
                                   sentiment_analysis: bool = False, # Include Sentiment Analysis
                                   auto_chapters: bool = False, # Include Auto Chapaters
                                   entity_detection: bool = False, # Include Entity Detection
                                   auto_highlights: bool = False, # Include Auto Highlights 
                                   summarization: bool = False, # Include Summary 
                                   summary_type: str = "bullets", # If summary is included select `summary_type` from list [`bullets', 'bullets_verbose', 'gist', 'paragraph', 'headline']. Check out this for more details: https://www.assemblyai.com/docs/audio-intelligence#summarization 
                                   ):
    ''' Submit Audio URL or the Local file Path for Transcription '''
    return self.submit_audio_for_transcription(audio_url,
                                               sentiment_analysis,
                                               auto_chapters,
                                               entity_detection, 
                                               auto_chapters,
                                               summarization,
                                               summary_type)

# %% ../nbs/00_assemblyai.ipynb 9
@patch
def get_transcription_results(self:AssemblyAI,
                              transcripiton_id: str, # Transcrption ID that we got from `submit_url_for_transcription`
                              all_details: bool = False # Include All the details, by default it `text` and `id` are returned
                             ):
    """Get the transcription results for the given id"""
    full_details = self.get_status_of_transcription(transcripiton_id)
    status = full_details.get("status")
    while status not in ["completed", "error"]:
        time.sleep(5)  # sleep for secs
        full_details = self.get_status_of_transcription(transcripiton_id)
        status = full_details.get("status")

    if all_details:
        return full_details


    return {
        "id": full_details.get("id"),
        "confidence": full_details.get("confidence"),
        "text": full_details.get("text"),
    }
