"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const project_1 = require("../project");
const junit_1 = require("./junit");
const maven_compile_1 = require("./maven-compile");
const maven_packaging_1 = require("./maven-packaging");
const maven_sample_1 = require("./maven-sample");
const pom_1 = require("./pom");
const projenrc_1 = require("./projenrc");
/**
 * (experimental) Java project.
 *
 * @experimental
 * @pjid java
 */
class JavaProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(options);
        this.distdir = (_b = options.distdir) !== null && _b !== void 0 ? _b : 'dist/java';
        this.pom = new pom_1.Pom(this, options);
        if ((_c = options.projenrcJava) !== null && _c !== void 0 ? _c : true) {
            this.projenrc = new projenrc_1.Projenrc(this, this.pom, {
                ...options.projenrcJavaOptions,
                initializationOptions: options,
            });
        }
        const sampleJavaPackage = (_d = options.sampleJavaPackage) !== null && _d !== void 0 ? _d : 'org.acme';
        if ((_e = options.junit) !== null && _e !== void 0 ? _e : true) {
            this.junit = new junit_1.Junit(this, {
                pom: this.pom,
                sampleJavaPackage,
                ...options.junitOptions,
            });
        }
        if ((_f = options.sample) !== null && _f !== void 0 ? _f : true) {
            new maven_sample_1.MavenSample(this, { package: sampleJavaPackage });
        }
        // platform independent build
        this.pom.addProperty('project.build.sourceEncoding', 'UTF-8');
        this.gitignore.exclude('.classpath');
        this.gitignore.exclude('.project');
        this.gitignore.exclude('.settings');
        this.compile = new maven_compile_1.MavenCompile(this, this.pom, options.compileOptions);
        this.packaging = new maven_packaging_1.MavenPackaging(this, this.pom, options.packagingOptions);
        this.addPlugin('org.apache.maven.plugins/maven-enforcer-plugin@3.0.0-M3', {
            executions: [{ id: 'enforce-maven', goals: ['enforce'] }],
            configuration: {
                rules: [
                    { requireMavenVersion: [{ version: '3.6' }] },
                ],
            },
        });
        const buildTask = this.addTask('build', { description: 'Full CI build' });
        buildTask.spawn(this.packaging.task);
        for (const dep of (_g = options.deps) !== null && _g !== void 0 ? _g : []) {
            this.addDependency(dep);
        }
        for (const dep of (_h = options.testDeps) !== null && _h !== void 0 ? _h : []) {
            this.addTestDependency(dep);
        }
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        return this.pom.addDependency(spec);
    }
    /**
     * (experimental) Adds a test dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addTestDependency(spec) {
        return this.pom.addTestDependency(spec);
    }
    /**
     * (experimental) Adds a build plugin to the pom.
     *
     * The plug in is also added as a BUILD dep to the project.
     *
     * @param spec dependency spec (`group/artifact@version`).
     * @param options plugin options.
     * @experimental
     */
    addPlugin(spec, options = {}) {
        return this.pom.addPlugin(spec, options);
    }
}
exports.JavaProject = JavaProject;
_a = JSII_RTTI_SYMBOL_1;
JavaProject[_a] = { fqn: "projen.java.JavaProject", version: "0.17.37" };
//# sourceMappingURL=data:application/json;base64,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