"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const _resolve_1 = require("./_resolve");
const common_1 = require("./common");
const component_1 = require("./component");
const util_1 = require("./util");
/**
 * @experimental
 */
class FileBase extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        var _b, _c, _d, _e;
        super(project);
        this.readonly = (_b = options.readonly) !== null && _b !== void 0 ? _b : true;
        this.executable = (_c = options.executable) !== null && _c !== void 0 ? _c : false;
        this.path = filePath;
        this.absolutePath = path.resolve(project.outdir, filePath);
        // verify file path is unique within project tree
        const existing = project.root.tryFindFile(this.absolutePath);
        if (existing && existing !== this) {
            throw new Error(`there is already a file under ${path.relative(project.root.outdir, this.absolutePath)}`);
        }
        const gitignore = (_d = options.editGitignore) !== null && _d !== void 0 ? _d : true;
        if (gitignore) {
            const committed = (_e = options.committed) !== null && _e !== void 0 ? _e : true;
            const pattern = `/${this.path}`;
            if (committed) {
                project.gitignore.include(pattern);
            }
            else {
                project.gitignore.exclude(pattern);
            }
        }
        else {
            if (options.committed != null) {
                throw new Error('"gitignore" is disabled, so it does not make sense to specify "committed"');
            }
        }
    }
    /**
     * (experimental) Writes the file to the project's output directory.
     *
     * @experimental
     */
    synthesize() {
        const outdir = this.project.outdir;
        const filePath = path.join(outdir, this.path);
        const resolver = { resolve: (obj, options) => _resolve_1.resolve(obj, options) };
        const content = this.synthesizeContent(resolver);
        if (content === undefined) {
            return; // skip
        }
        util_1.writeFile(filePath, content, {
            readonly: this.readonly,
            executable: this.executable,
        });
    }
}
exports.FileBase = FileBase;
_a = JSII_RTTI_SYMBOL_1;
FileBase[_a] = { fqn: "projen.FileBase", version: "0.17.37" };
/**
 * (experimental) The marker to embed in files in order to identify them as projen files.
 *
 * This marker is used to prune these files before synthesis.
 *
 * @experimental
 */
FileBase.PROJEN_MARKER = `${common_1.PROJEN_MARKER}. To modify, edit ${common_1.PROJEN_RC} and run "npx projen".`;
//# sourceMappingURL=data:application/json;base64,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