# Generated by Django 3.2.4 on 2021-07-19 08:03

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('crams_contact', '0003_contactlog'),
        ('crams', '0010_projectmemberstatus_lookups'),
    ]

    operations = [
        migrations.CreateModel(
            name='SoftwareProductCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.CharField(max_length=99)),
                ('active', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='SoftwareUserEvent',
            fields=[
                ('userevents_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crams.userevents')),
                ('action', models.CharField(choices=[('CSL', 'Create New Software License'), ('USL', 'Update Software License')], max_length=3)),
                ('pre_event_json', models.TextField(blank=True)),
                ('post_event_json', models.TextField(blank=True)),
            ],
            bases=('crams.userevents',),
        ),
        migrations.CreateModel(
            name='SoftwareProduct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=99)),
                ('version', models.CharField(blank=True, max_length=22, null=True)),
                ('description', models.TextField(default='')),
                ('active', models.BooleanField(default=True)),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='crams_software.softwareproductcategory')),
                ('e_research_body', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='crams.eresearchbody')),
                ('provision_details', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='softwareproduct', to='crams.provisiondetails')),
            ],
            options={
                'unique_together': {('name', 'e_research_body')},
                'index_together': {('name', 'e_research_body')},
            },
        ),
        migrations.CreateModel(
            name='SoftwareLicenseType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(max_length=99)),
                ('end_date_ts', models.DateTimeField(blank=True, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'unique_together': {('type', 'end_date_ts')},
            },
        ),
        migrations.CreateModel(
            name='SoftwareLicense',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(blank=True, max_length=22, null=True)),
                ('end_date_ts', models.DateTimeField(blank=True, null=True)),
                ('is_academic', models.BooleanField(default=False)),
                ('is_restricted', models.BooleanField(default=True)),
                ('homepage', models.URLField(blank=True, null=True)),
                ('start_date', models.DateField()),
                ('license_text', models.TextField(blank=True, null=True)),
                ('cluster', models.ManyToManyField(to='crams.EResearchBodySystem')),
                ('software', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='licenses', to='crams_software.softwareproduct')),
                ('type', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='crams_software.softwarelicensetype')),
            ],
            options={
                'unique_together': {('software', 'type', 'end_date_ts')},
            },
        ),
        migrations.CreateModel(
            name='SoftwareProductMetaData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.CharField(max_length=99)),
                ('name', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='crams.eresearchbodyidkey')),
                ('software', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='metadata', to='crams_software.softwareproduct')),
            ],
            options={
                'unique_together': {('name', 'software', 'value')},
            },
        ),
        migrations.CreateModel(
            name='ContactSoftwareLicense',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('accepted_ts', models.DateTimeField(auto_created=True)),
                ('status', models.CharField(choices=[('R', 'Requested'), ('A', 'Approved'), ('D', 'Declined')], max_length=1)),
                ('notes', models.TextField(blank=True, null=True)),
                ('end_date_ts', models.DateTimeField(blank=True, null=True)),
                ('contact', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='software_licenses', to='crams_contact.contact')),
                ('license', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='user_licenses', to='crams_software.softwarelicense')),
                ('provision_details', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='contactsoftwarelicense', to='crams.provisiondetails')),
            ],
            options={
                'unique_together': {('contact', 'license', 'end_date_ts')},
            },
        ),
    ]
