"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.app = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const ecr = require("@aws-cdk/aws-ecr");
const ecs = require("@aws-cdk/aws-ecs");
const cdk = require("@aws-cdk/core");
const batch = require("../lib/");
exports.app = new cdk.App();
const stack = new cdk.Stack(exports.app, 'batch-stack');
const vpc = new ec2.Vpc(stack, 'vpc');
const launchTemplate = new ec2.CfnLaunchTemplate(stack, 'ec2-launch-template', {
    launchTemplateName: 'EC2LaunchTemplate',
    launchTemplateData: {
        blockDeviceMappings: [
            {
                deviceName: '/dev/xvdcz',
                ebs: {
                    encrypted: true,
                    volumeSize: 100,
                    volumeType: 'gp2',
                },
            },
        ],
    },
});
new batch.JobQueue(stack, 'batch-job-queue', {
    computeEnvironments: [
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'batch-unmanaged-compute-env', {
                managed: false,
            }),
            order: 1,
        },
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'batch-demand-compute-env-launch-template', {
                managed: true,
                computeResources: {
                    type: batch.ComputeResourceType.ON_DEMAND,
                    vpc,
                    launchTemplate: {
                        launchTemplateName: launchTemplate.launchTemplateName,
                    },
                    computeResourcesTags: {
                        'compute-env-tag': '123XYZ',
                    },
                },
            }),
            order: 2,
        },
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'batch-spot-compute-env', {
                managed: true,
                computeResources: {
                    type: batch.ComputeResourceType.SPOT,
                    vpc,
                    bidPercentage: 80,
                },
            }),
            order: 3,
        },
    ],
});
const repo = new ecr.Repository(stack, 'batch-job-repo');
new batch.JobDefinition(stack, 'batch-job-def-from-ecr', {
    container: {
        image: new ecs.EcrImage(repo, 'latest'),
    },
});
new batch.JobDefinition(stack, 'batch-job-def-from-', {
    container: {
        image: ecs.ContainerImage.fromRegistry('docker/whalesay'),
    },
});
//# sourceMappingURL=data:application/json;base64,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