#! /usr/bin/python3

# Raw code was generated by PAGE version 7.4
#  in conjunction with Tcl version 8.6
#    Jul 26, 2022 04:34:12 PM CST  platform: Darwin

from importlib import resources
from logging import handlers
from time import time
from tkinter import filedialog, messagebox, scrolledtext
import logging
import queue
import sys
import tkinter as tk
import tkinter.ttk as ttk
import webbrowser

from pyGUS import core, global_vars
from pyGUS.utils import open_folder


log = global_vars.log


def thread_wrap(function, arg_str):
    """
    Wrap for callback.
    Args:
        function(callable): function to call
        arg_str(str): string for function's argparse
    """
    try:
        result = function(arg_str)
    except Exception as e:
        log.exception(str(e))
        log.exception('Abort.')
        messagebox.showerror('Abort.')
        return
    if result[0]:
        messagebox.showinfo(f'Done. See {result[1]} for details.')
    else:
        messagebox.showinfo(f'Fail. See {result[1]} for details.')
    return


def move_to_center(window: tk.Tk, width: int, height: int,
                   is_root=False) -> None:
    screen_width = root.winfo_screenwidth()
    screen_height = root.winfo_screenheight()
    x = (screen_width - width) // 2
    y = (screen_height - height) // 2
    if not is_root:
        window.geometry(f'{width}x{height}+{x}+{y}')
    else:
        window.geometry(f'{width}x{height}+{x-width*2}+{y}')
    return


class Root:
    def __init__(self, top=None):
        _bgcolor = '#edf0f3'  # Closest X11 color: 'gray94'
        _fgcolor = '#000000'  # X11 color: 'black'
        _compcolor = 'gray40'  # X11 color: #666666
        _ana1color = '#c3c3c3'  # Closest X11 color: 'gray76'
        _ana2color = 'beige'  # X11 color: #f5f5dc
        _tabfg1 = 'black'
        _tabfg2 = 'black'
        _tabbg1 = 'grey75'
        _tabbg2 = 'grey89'
        _bgmode = 'light'

        top.geometry("280x400+843+223")
        move_to_center(top, 280, 400, is_root=True)
        top.minsize(72, 15)
        top.maxsize(3648, 1089)
        top.resizable(1, 1)
        top.title("pyGUS")
        top.configure(background="#edf0f3")
        top.configure(highlightbackground="#d9d9d9")
        top.configure(highlightcolor="black")

        self.top = top

        self.Button1 = tk.Button(self.top)
        self.Button1.place(relx=0.232, rely=0.1, height=40, width=150)
        self.Button1.configure(activebackground="beige")
        self.Button1.configure(activeforeground="#000000")
        self.Button1.configure(background="#edf0f3")
        self.Button1.configure(command=run_mode1)
        self.Button1.configure(compound='left')
        self.Button1.configure(foreground="#000000")
        self.Button1.configure(highlightbackground="#edf0f3")
        self.Button1.configure(highlightcolor="black")
        self.Button1.configure(text='''Normal''')
        self.tooltip_font = "TkDefaultFont"
        self.Button1_tooltip = ToolTip(self.Button1, self.tooltip_font,
                                       'Single target in each image')

        self.Button2 = tk.Button(self.top)
        self.Button2.place(relx=0.232, rely=0.25, height=40, width=150)
        self.Button2.configure(activebackground="beige")
        self.Button2.configure(activeforeground="#000000")
        self.Button2.configure(background="#edf0f3")
        self.Button2.configure(command=run_mode2)
        self.Button2.configure(compound='left')
        self.Button2.configure(foreground="#000000")
        self.Button2.configure(highlightbackground="#edf0f3")
        self.Button2.configure(highlightcolor="black")
        self.Button2.configure(text='''With reference''')
        self.tooltip_font = "TkDefaultFont"
        self.Button2_tooltip = ToolTip(
            self.Button2, self.tooltip_font,
            'Target and positive reference in each image')

        self.Button3 = tk.Button(self.top)
        self.Button3.place(relx=0.232, rely=0.4, height=40, width=150)
        self.Button3.configure(activebackground="beige")
        self.Button3.configure(activeforeground="#000000")
        self.Button3.configure(background="#edf0f3")
        self.Button3.configure(command=run_mode3)
        self.Button3.configure(compound='left')
        self.Button3.configure(foreground="#000000")
        self.Button3.configure(highlightbackground="#edf0f3")
        self.Button3.configure(highlightcolor="black")
        self.Button3.configure(text='''With color checker''')
        self.tooltip_font = "TkDefaultFont"
        self.Button3_tooltip = ToolTip(
            self.Button3, self.tooltip_font,
            'Target and color checker in each image')

        self.Button4 = tk.Button(self.top)
        self.Button4.place(relx=0.232, rely=0.55, height=40, width=150)
        self.Button4.configure(activebackground="beige")
        self.Button4.configure(activeforeground="#000000")
        self.Button4.configure(background="#edf0f3")
        self.Button4.configure(command=run_mode4)
        self.Button4.configure(compound='left')
        self.Button4.configure(foreground="#000000")
        self.Button4.configure(highlightbackground="#edf0f3")
        self.Button4.configure(highlightcolor="black")
        self.Button4.configure(text='''Manually''')
        self.tooltip_font = "TkDefaultFont"
        self.Button4_tooltip = ToolTip(
            self.Button4, self.tooltip_font, 'Manually select')

        self.che0 = tk.IntVar()
        self.Checker = tk.Checkbutton(self.top)
        self.Checker.place(relx=0.3, rely=0.66, height=30, width=120)
        self.Checker.configure(activebackground="beige")
        self.Checker.configure(activeforeground="#000000")
        self.Checker.configure(background="#edf0f3")
        self.Checker.configure(compound='left')
        self.Checker.configure(foreground="#000000")
        self.Checker.configure(highlightbackground="#edf0f3")
        self.Checker.configure(highlightcolor="black")
        self.Checker.configure(justify='left')
        self.Checker.configure(selectcolor="#edf0f3")
        self.Checker.configure(text='''Quick analyze''')
        self.Checker.configure(variable=self.che0)

        self.Button5 = tk.Button(self.top)
        self.Button5.place(relx=0.107, rely=0.75, height=30, width=100)
        self.Button5.configure(activebackground="beige")
        self.Button5.configure(activeforeground="#000000")
        self.Button5.configure(background="#edf0f3")
        self.Button5.configure(command=example)
        self.Button5.configure(compound='left')
        self.Button5.configure(foreground="#000000")
        self.Button5.configure(highlightbackground="#edf0f3")
        self.Button5.configure(highlightcolor="black")
        self.Button5.configure(text='''Example''')
        self.tooltip_font = "TkDefaultFont"
        self.Button2_tooltip = ToolTip(
            self.Button5, self.tooltip_font,
            'Macbeth color checker for print')

        self.ButtonHelp = tk.Button(self.top)
        self.ButtonHelp.place(relx=0.536, rely=0.75, height=30, width=100)
        self.ButtonHelp.configure(activebackground="beige")
        self.ButtonHelp.configure(activeforeground="#000000")
        self.ButtonHelp.configure(background="#edf0f3")
        self.ButtonHelp.configure(command=help)
        self.ButtonHelp.configure(compound='left')
        self.ButtonHelp.configure(foreground="#000000")
        self.ButtonHelp.configure(highlightbackground="#edf0f3")
        self.ButtonHelp.configure(highlightcolor="black")
        self.ButtonHelp.configure(text='''Help''')


class Mode1:
    def __init__(self, top=None):
        _bgcolor = '#edf0f3'  # Closest X11 color: 'gray94'
        _fgcolor = '#000000'  # X11 color: 'black'
        _compcolor = 'gray40'  # X11 color: #666666
        _ana1color = '#c3c3c3'  # Closest X11 color: 'gray76'
        _ana2color = 'beige'  # X11 color: #f5f5dc
        _tabfg1 = 'black'
        _tabfg2 = 'black'
        _tabbg1 = 'grey75'
        _tabbg2 = 'grey89'
        _bgmode = 'light'

        top.geometry("500x280+597+46")
        move_to_center(top, 500, 280)
        top.minsize(72, 15)
        top.maxsize(3648, 1089)
        top.resizable(1, 1)
        top.title("Normal mode")
        top.configure(background="#edf0f3")
        top.configure(highlightbackground="#d9d9d9")
        top.configure(highlightcolor="black")

        self.top = top
        self.ref1 = tk.StringVar()
        self.ref2 = tk.StringVar()
        self.images = tk.StringVar()
        self.Frame1 = tk.Frame(self.top)
        self.Frame1.place(relx=0.04, rely=0.071, relheight=0.143,
                          relwidth=0.912)

        self.Frame1.configure(relief='groove')
        self.Frame1.configure(borderwidth="2")
        self.Frame1.configure(relief="groove")
        self.Frame1.configure(background="#edf0f3")
        self.Frame1.configure(highlightbackground="#d9d9d9")
        self.Frame1.configure(highlightcolor="black")

        self.Label1 = tk.Label(self.Frame1)
        self.Label1.place(relx=0.022, rely=0.25, height=22, width=160)
        self.Label1.configure(activebackground="#f9f9f9")
        self.Label1.configure(anchor='w')
        self.Label1.configure(background="#edf0f3")
        self.Label1.configure(compound='left')
        self.Label1.configure(foreground="#000000")
        self.Label1.configure(highlightbackground="#d9d9d9")
        self.Label1.configure(highlightcolor="black")
        self.Label1.configure(text='''Negative reference image''')

        self.Entry1 = tk.Entry(self.Frame1)
        self.Entry1.place(relx=0.395, rely=0.125, height=30, relwidth=0.439)
        self.Entry1.configure(background="white")
        self.Entry1.configure(font="TkFixedFont")
        self.Entry1.configure(foreground="#000000")
        self.Entry1.configure(highlightbackground="#d9d9d9")
        self.Entry1.configure(highlightcolor="black")
        self.Entry1.configure(insertbackground="black")
        self.Entry1.configure(selectbackground="#c4c4c4")
        self.Entry1.configure(selectforeground="black")
        self.Entry1.configure(textvariable=self.ref1)

        self.Button1 = tk.Button(self.Frame1)
        self.Button1.place(relx=0.833, rely=0.125, height=30, width=70)
        self.Button1.configure(activebackground="beige")
        self.Button1.configure(activeforeground="#000000")
        self.Button1.configure(background="#edf0f3")
        self.Button1.configure(command=open_file('Negative reference image',
                                                 self.Entry1))
        self.Button1.configure(compound='left')
        self.Button1.configure(foreground="#000000")
        self.Button1.configure(highlightbackground="#edf0f3")
        self.Button1.configure(highlightcolor="black")
        self.Button1.configure(text='''Open''')

        self.Frame2 = tk.Frame(self.top)
        self.Frame2.place(relx=0.04, rely=0.286, relheight=0.143,
                          relwidth=0.912)
        self.Frame2.configure(relief='groove')
        self.Frame2.configure(borderwidth="2")
        self.Frame2.configure(relief="groove")
        self.Frame2.configure(background="#edf0f3")
        self.Frame2.configure(highlightbackground="#d9d9d9")
        self.Frame2.configure(highlightcolor="black")

        self.Label2 = tk.Label(self.Frame2)
        self.Label2.place(relx=0.022, rely=0.25, height=22, width=160)
        self.Label2.configure(activebackground="#f9f9f9")
        self.Label2.configure(anchor='w')
        self.Label2.configure(background="#edf0f3")
        self.Label2.configure(compound='left')
        self.Label2.configure(foreground="#000000")
        self.Label2.configure(highlightbackground="#d9d9d9")
        self.Label2.configure(highlightcolor="black")
        self.Label2.configure(text='''Positive reference image''')

        self.Entry2 = tk.Entry(self.Frame2)
        self.Entry2.place(relx=0.395, rely=0.125, height=30, relwidth=0.439)
        self.Entry2.configure(background="white")
        self.Entry2.configure(font="TkFixedFont")
        self.Entry2.configure(foreground="#000000")
        self.Entry2.configure(highlightbackground="#d9d9d9")
        self.Entry2.configure(highlightcolor="black")
        self.Entry2.configure(insertbackground="black")
        self.Entry2.configure(selectbackground="#c4c4c4")
        self.Entry2.configure(selectforeground="black")
        self.Entry2.configure(textvariable=self.ref2)

        self.Button2 = tk.Button(self.Frame2)
        self.Button2.place(relx=0.833, rely=0.125, height=30, width=70)
        self.Button2.configure(activebackground="beige")
        self.Button2.configure(activeforeground="#000000")
        self.Button2.configure(background="#edf0f3")
        self.Button2.configure(command=open_file('Positive reference image',
                                                 self.Entry2))
        self.Button2.configure(compound='left')
        self.Button2.configure(foreground="#000000")
        self.Button2.configure(highlightbackground="#edf0f3")
        self.Button2.configure(highlightcolor="black")
        self.Button2.configure(text='''Open''')

        self.Frame3 = tk.Frame(self.top)
        self.Frame3.place(relx=0.04, rely=0.5, relheight=0.143, relwidth=0.912)
        self.Frame3.configure(relief='groove')
        self.Frame3.configure(borderwidth="2")
        self.Frame3.configure(relief="groove")
        self.Frame3.configure(background="#edf0f3")
        self.Frame3.configure(highlightbackground="#d9d9d9")
        self.Frame3.configure(highlightcolor="black")

        self.Label3 = tk.Label(self.Frame3)
        self.Label3.place(relx=0.158, rely=0.25, height=22, width=90)
        self.Label3.configure(activebackground="#f9f9f9")
        self.Label3.configure(anchor='w')
        self.Label3.configure(background="#edf0f3")
        self.Label3.configure(compound='left')
        self.Label3.configure(foreground="#000000")
        self.Label3.configure(highlightbackground="#d9d9d9")
        self.Label3.configure(highlightcolor="black")
        self.Label3.configure(text='''Target images''')

        self.Entry3 = tk.Entry(self.Frame3)
        self.Entry3.place(relx=0.395, rely=0.125, height=30, relwidth=0.439)
        self.Entry3.configure(background="white")
        self.Entry3.configure(font="TkFixedFont")
        self.Entry3.configure(foreground="#000000")
        self.Entry3.configure(highlightbackground="#d9d9d9")
        self.Entry3.configure(highlightcolor="black")
        self.Entry3.configure(insertbackground="black")
        self.Entry3.configure(selectbackground="#c4c4c4")
        self.Entry3.configure(selectforeground="black")
        self.Entry3.configure(textvariable=self.images)

        self.Button3 = tk.Button(self.Frame3)
        self.Button3.place(relx=0.833, rely=0.125, height=30, width=70)
        self.Button3.configure(activebackground="beige")
        self.Button3.configure(activeforeground="#000000")
        self.Button3.configure(background="#edf0f3")
        self.Button3.configure(command=open_file(
            'Target images', self.Entry3, single=False))
        self.Button3.configure(compound='left')
        self.Button3.configure(foreground="#000000")
        self.Button3.configure(highlightbackground="#edf0f3")
        self.Button3.configure(highlightcolor="black")
        self.Button3.configure(text='''Open''')

        self.che48 = tk.IntVar()
        self.Checkbutton1 = tk.Checkbutton(self.top)
        # hide, not implemented
        # self.Checkbutton1.place(relx=0.04, rely=0.75, relheight=0.079,
        #                         relwidth=0.44)
        self.Checkbutton1.configure(activebackground="beige")
        self.Checkbutton1.configure(activeforeground="#000000")
        self.Checkbutton1.configure(anchor='w')
        self.Checkbutton1.configure(background="#edf0f3")
        self.Checkbutton1.configure(compound='left')
        self.Checkbutton1.configure(foreground="#000000")
        self.Checkbutton1.configure(highlightbackground="#edf0f3")
        self.Checkbutton1.configure(highlightcolor="black")
        self.Checkbutton1.configure(justify='left')
        self.Checkbutton1.configure(selectcolor="#edf0f3")
        self.Checkbutton1.configure(text='''Automatic adjust white balance''')
        self.Checkbutton1.configure(variable=self.che48)

        self.Button4 = tk.Button(self.top)
        # self.Button2.place(relx=0.58, rely=0.732, height=38, width=107)
        self.Button4.place(relx=0.38, rely=0.732, height=40, width=100)
        self.Button4.configure(activebackground="beige")
        self.Button4.configure(activeforeground="#000000")
        self.Button4.configure(background="#edf0f3")
        self.Button4.configure(command=run(mode=1, ref1=self.ref1,
                                           ref2=self.ref2, images=self.images))
        self.Button4.configure(compound='left')
        self.Button4.configure(foreground="#000000")
        self.Button4.configure(highlightbackground="#edf0f3")
        self.Button4.configure(highlightcolor="black")
        self.Button4.configure(text='''Run''')


class Mode2:
    def __init__(self, top=None):
        """This class configures and populates the toplevel window.
           top is the toplevel containing window."""
        _bgcolor = '#edf0f3'  # Closest X11 color: 'gray94'
        _fgcolor = '#000000'  # X11 color: 'black'
        _compcolor = 'gray40'  # X11 color: #666666
        _ana1color = '#c3c3c3'  # Closest X11 color: 'gray76'
        _ana2color = 'beige'  # X11 color: #f5f5dc
        _tabfg1 = 'black'
        _tabfg2 = 'black'
        _tabbg1 = 'grey75'
        _tabbg2 = 'grey89'
        _bgmode = 'light'

        top.geometry("500x200+630+378")
        move_to_center(top, 500, 200)
        top.minsize(72, 15)
        top.maxsize(3648, 1089)
        top.resizable(1, 1)
        top.title("With reference mode")
        top.configure(background="#edf0f3")
        top.configure(highlightbackground="#d9d9d9")
        top.configure(highlightcolor="black")

        self.top = top
        self.ref1 = tk.StringVar()
        self.images = tk.StringVar()

        self.Frame1 = tk.Frame(self.top)
        self.Frame1.place(relx=0.04, rely=0.1, relheight=0.2, relwidth=0.92)
        self.Frame1.configure(relief='groove')
        self.Frame1.configure(borderwidth="2")
        self.Frame1.configure(relief="groove")
        self.Frame1.configure(background="#edf0f3")
        self.Frame1.configure(highlightbackground="#d9d9d9")
        self.Frame1.configure(highlightcolor="black")

        self.Label1 = tk.Label(self.Frame1)
        self.Label1.place(relx=0.133, rely=0.25, height=22, width=111)
        self.Label1.configure(activebackground="#f9f9f9")
        self.Label1.configure(anchor='w')
        self.Label1.configure(background="#edf0f3")
        self.Label1.configure(compound='left')
        self.Label1.configure(foreground="#000000")
        self.Label1.configure(highlightbackground="#d9d9d9")
        self.Label1.configure(highlightcolor="black")
        self.Label1.configure(text='''Reference image''')
        self.tooltip_font = "TkDefaultFont"
        self.Label1_tooltip = ToolTip(self.Label1, self.tooltip_font,
                                      'Left negative, right positive')

        self.Entry1 = tk.Entry(self.Frame1)
        self.Entry1.place(relx=0.396, rely=0.125, height=30, relwidth=0.435)
        self.Entry1.configure(background="white")
        self.Entry1.configure(font="TkFixedFont")
        self.Entry1.configure(foreground="#000000")
        self.Entry1.configure(highlightbackground="#d9d9d9")
        self.Entry1.configure(highlightcolor="black")
        self.Entry1.configure(insertbackground="black")
        self.Entry1.configure(selectbackground="#c4c4c4")
        self.Entry1.configure(selectforeground="black")
        self.Entry1.configure(textvariable=self.ref1)

        self.Button1 = tk.Button(self.Frame1)
        self.Button1.place(relx=0.833, rely=0.125, height=30, width=70)
        self.Button1.configure(activebackground="beige")
        self.Button1.configure(activeforeground="#000000")
        self.Button1.configure(background="#edf0f3")
        self.Button1.configure(command=open_file(
            'Left negative reference, right positive reference', self.Entry1))
        self.Button1.configure(compound='left')
        self.Button1.configure(foreground="#000000")
        self.Button1.configure(highlightbackground="#edf0f3")
        self.Button1.configure(highlightcolor="black")
        self.Button1.configure(text='''Open''')

        self.Frame2 = tk.Frame(self.top)
        self.Frame2.place(relx=0.04, rely=0.4, relheight=0.2, relwidth=0.92)
        self.Frame2.configure(relief='groove')
        self.Frame2.configure(borderwidth="2")
        self.Frame2.configure(relief="groove")
        self.Frame2.configure(background="#edf0f3")
        self.Frame2.configure(highlightbackground="#d9d9d9")
        self.Frame2.configure(highlightcolor="black")

        self.Label2 = tk.Label(self.Frame2)
        self.Label2.place(relx=0.154, rely=0.25, height=22, width=90)
        self.Label2.configure(activebackground="#f9f9f9")
        self.Label2.configure(anchor='w')
        self.Label2.configure(background="#edf0f3")
        self.Label2.configure(compound='left')
        self.Label2.configure(foreground="#000000")
        self.Label2.configure(highlightbackground="#d9d9d9")
        self.Label2.configure(highlightcolor="black")
        self.Label2.configure(text='''Target images''')
        self.tooltip_font = "TkDefaultFont"
        self.Label1_1_1_tooltip = ToolTip(
            self.Label2, self.tooltip_font,
            'Left target, right positive reference')

        self.Entry2 = tk.Entry(self.Frame2)
        self.Entry2.place(relx=0.396, rely=0.125, height=30, relwidth=0.435)
        self.Entry2.configure(background="white")
        self.Entry2.configure(font="TkFixedFont")
        self.Entry2.configure(foreground="#000000")
        self.Entry2.configure(highlightbackground="#d9d9d9")
        self.Entry2.configure(highlightcolor="black")
        self.Entry2.configure(insertbackground="black")
        self.Entry2.configure(selectbackground="#c4c4c4")
        self.Entry2.configure(selectforeground="black")
        self.Entry2.configure(textvariable=self.images)

        self.Button2 = tk.Button(self.Frame2)
        self.Button2.place(relx=0.833, rely=0.125, height=30, width=70)
        self.Button2.configure(activebackground="beige")
        self.Button2.configure(activeforeground="#000000")
        self.Button2.configure(background="#edf0f3")
        self.Button2.configure(command=open_file(
            'Target images', self.Entry2, single=False))
        self.Button2.configure(compound='left')
        self.Button2.configure(foreground="#000000")
        self.Button2.configure(highlightbackground="#edf0f3")
        self.Button2.configure(highlightcolor="black")
        self.Button2.configure(text='''Open''')

        self.Button3 = tk.Button(self.top)
        self.Button3.place(relx=0.38, rely=0.7, height=40, width=100)
        self.Button3.configure(activebackground="beige")
        self.Button3.configure(activeforeground="#000000")
        self.Button3.configure(background="#edf0f3")
        self.Button3.configure(command=run(mode=2, ref1=self.ref1,
                                           images=self.images))
        self.Button3.configure(compound='left')
        self.Button3.configure(foreground="#000000")
        self.Button3.configure(highlightbackground="#edf0f3")
        self.Button3.configure(highlightcolor="black")
        self.Button3.configure(text='''Run''')


class Mode3:
    def __init__(self, top=None):
        _bgcolor = '#edf0f3'  # Closest X11 color: 'gray94'
        _fgcolor = '#000000'  # X11 color: 'black'
        _compcolor = 'gray40'  # X11 color: #666666
        _ana1color = '#c3c3c3'  # Closest X11 color: 'gray76'
        _ana2color = 'beige'  # X11 color: #f5f5dc
        _tabfg1 = 'black'
        _tabfg2 = 'black'
        _tabbg1 = 'grey75'
        _tabbg2 = 'grey89'
        _bgmode = 'light'

        top.geometry("500x280+639+615")
        move_to_center(top, 500, 280)
        top.minsize(72, 15)
        top.maxsize(3648, 1089)
        top.resizable(1, 1)
        top.title("With colorchecker mode")
        top.configure(background="#edf0f3")
        top.configure(highlightbackground="#d9d9d9")
        top.configure(highlightcolor="black")

        self.top = top
        self.ref1 = tk.StringVar()
        self.ref2 = tk.StringVar()
        self.images = tk.StringVar()

        self.Frame1 = tk.Frame(self.top)
        self.Frame1.place(relx=0.04, rely=0.071, relheight=0.143,
                          relwidth=0.912)
        self.Frame1.configure(relief='groove')
        self.Frame1.configure(borderwidth="2")
        self.Frame1.configure(relief="groove")
        self.Frame1.configure(background="#edf0f3")
        self.Frame1.configure(highlightbackground="#d9d9d9")
        self.Frame1.configure(highlightcolor="black")

        self.Label1 = tk.Label(self.Frame1)
        self.Label1.place(relx=0.022, rely=0.25, height=22, width=160)
        self.Label1.configure(activebackground="#f9f9f9")
        self.Label1.configure(anchor='w')
        self.Label1.configure(background="#edf0f3")
        self.Label1.configure(compound='left')
        self.Label1.configure(foreground="#000000")
        self.Label1.configure(highlightbackground="#d9d9d9")
        self.Label1.configure(highlightcolor="black")
        self.Label1.configure(text='''Negative reference image''')
        self.tooltip_font = "TkDefaultFont"
        self.Label1_tooltip = ToolTip(
            self.Label1, self.tooltip_font,
            'Left negative reference, right color checker')

        self.Entry1 = tk.Entry(self.Frame1)
        self.Entry1.place(relx=0.395, rely=0.125, height=30, relwidth=0.439)
        self.Entry1.configure(background="white")
        self.Entry1.configure(font="TkFixedFont")
        self.Entry1.configure(foreground="#000000")
        self.Entry1.configure(highlightbackground="#d9d9d9")
        self.Entry1.configure(highlightcolor="black")
        self.Entry1.configure(insertbackground="black")
        self.Entry1.configure(selectbackground="#c4c4c4")
        self.Entry1.configure(selectforeground="black")
        self.Entry1.configure(textvariable=self.ref1)

        self.Button1 = tk.Button(self.Frame1)
        self.Button1.place(relx=0.833, rely=0.125, height=30, width=70)
        self.Button1.configure(activebackground="beige")
        self.Button1.configure(activeforeground="#000000")
        self.Button1.configure(background="#edf0f3")
        self.Button1.configure(command=open_file(
            'Negative reference with color checker', self.Entry1))
        self.Button1.configure(compound='left')
        self.Button1.configure(foreground="#000000")
        self.Button1.configure(highlightbackground="#edf0f3")
        self.Button1.configure(highlightcolor="black")
        self.Button1.configure(text='''Open''')

        self.Frame2 = tk.Frame(self.top)
        self.Frame2.place(relx=0.04, rely=0.321, relheight=0.143,
                          relwidth=0.912)
        self.Frame2.configure(relief='groove')
        self.Frame2.configure(borderwidth="2")
        self.Frame2.configure(relief="groove")
        self.Frame2.configure(background="#edf0f3")
        self.Frame2.configure(highlightbackground="#d9d9d9")
        self.Frame2.configure(highlightcolor="black")

        self.Label2 = tk.Label(self.Frame2)
        self.Label2.place(relx=0.022, rely=0.25, height=22, width=160)
        self.Label2.configure(activebackground="#f9f9f9")
        self.Label2.configure(anchor='w')
        self.Label2.configure(background="#edf0f3")
        self.Label2.configure(compound='left')
        self.Label2.configure(foreground="#000000")
        self.Label2.configure(highlightbackground="#d9d9d9")
        self.Label2.configure(highlightcolor="black")
        self.Label2.configure(text='''Positive reference image''')
        self.tooltip_font = "TkDefaultFont"
        self.Label2_tooltip = ToolTip(
            self.Label2, self.tooltip_font,
            'Left positive reference, right color checker')

        self.Entry2 = tk.Entry(self.Frame2)
        self.Entry2.place(relx=0.395, rely=0.125, height=30, relwidth=0.439)
        self.Entry2.configure(background="white")
        self.Entry2.configure(font="TkFixedFont")
        self.Entry2.configure(foreground="#000000")
        self.Entry2.configure(highlightbackground="#d9d9d9")
        self.Entry2.configure(highlightcolor="black")
        self.Entry2.configure(insertbackground="black")
        self.Entry2.configure(selectbackground="#c4c4c4")
        self.Entry2.configure(selectforeground="black")
        self.Entry2.configure(textvariable=self.ref2)

        self.Button2 = tk.Button(self.Frame2)
        self.Button2.place(relx=0.833, rely=0.125, height=30, width=70)
        self.Button2.configure(activebackground="beige")
        self.Button2.configure(activeforeground="#000000")
        self.Button2.configure(background="#edf0f3")
        self.Button2.configure(command=open_file(
            'Positive reference with color checker', self.Entry2))
        self.Button2.configure(compound='left')
        self.Button2.configure(foreground="#000000")
        self.Button2.configure(highlightbackground="#edf0f3")
        self.Button2.configure(highlightcolor="black")
        self.Button2.configure(text='''Open''')

        self.Frame3 = tk.Frame(self.top)
        self.Frame3.place(relx=0.04, rely=0.571, relheight=0.143,
                          relwidth=0.912)
        self.Frame3.configure(relief='groove')
        self.Frame3.configure(borderwidth="2")
        self.Frame3.configure(relief="groove")
        self.Frame3.configure(background="#edf0f3")
        self.Frame3.configure(highlightbackground="#d9d9d9")
        self.Frame3.configure(highlightcolor="black")

        self.Label3 = tk.Label(self.Frame3)
        self.Label3.place(relx=0.158, rely=0.25, height=22, width=90)
        self.Label3.configure(activebackground="#f9f9f9")
        self.Label3.configure(anchor='w')
        self.Label3.configure(background="#edf0f3")
        self.Label3.configure(compound='left')
        self.Label3.configure(foreground="#000000")
        self.Label3.configure(highlightbackground="#d9d9d9")
        self.Label3.configure(highlightcolor="black")
        self.Label3.configure(text='''Target images''')
        self.tooltip_font = "TkDefaultFont"
        self.Label3_tooltip = ToolTip(
            self.Label3, self.tooltip_font,
            'Left target, right color checker')

        self.Entry3 = tk.Entry(self.Frame3)
        self.Entry3.place(relx=0.395, rely=0.125, height=30, relwidth=0.439)
        self.Entry3.configure(background="white")
        self.Entry3.configure(font="TkFixedFont")
        self.Entry3.configure(foreground="#000000")
        self.Entry3.configure(highlightbackground="#d9d9d9")
        self.Entry3.configure(highlightcolor="black")
        self.Entry3.configure(insertbackground="black")
        self.Entry3.configure(selectbackground="#c4c4c4")
        self.Entry3.configure(selectforeground="black")
        self.Entry3.configure(textvariable=self.images)

        self.Button3 = tk.Button(self.Frame3)
        self.Button3.place(relx=0.833, rely=0.125, height=30, width=70)
        self.Button3.configure(activebackground="beige")
        self.Button3.configure(activeforeground="#000000")
        self.Button3.configure(background="#edf0f3")
        self.Button3.configure(command=open_file(
            'Left target, right color checker', self.Entry3, single=False))
        self.Button3.configure(compound='left')
        self.Button3.configure(foreground="#000000")
        self.Button3.configure(highlightbackground="#edf0f3")
        self.Button3.configure(highlightcolor="black")
        self.Button3.configure(text='''Open''')

        self.Button4 = tk.Button(self.top)
        self.Button4.place(relx=0.38, rely=0.786, height=40, width=100)
        self.Button4.configure(activebackground="beige")
        self.Button4.configure(activeforeground="#000000")
        self.Button4.configure(background="#edf0f3")
        self.Button4.configure(command=run(mode=3, ref1=self.ref1,
                                           ref2=self.ref2, images=self.images))
        self.Button4.configure(compound='left')
        self.Button4.configure(foreground="#000000")
        self.Button4.configure(highlightbackground="#edf0f3")
        self.Button4.configure(highlightcolor="black")
        self.Button4.configure(text='''Run''')


class Mode4:
    def __init__(self, top=None):
        _bgcolor = '#edf0f3'  # Closest X11 color: 'gray94'
        _fgcolor = '#000000'  # X11 color: 'black'
        _compcolor = 'gray40'  # X11 color: #666666
        _ana1color = '#c3c3c3'  # Closest X11 color: 'gray76'
        _ana2color = 'beige'  # X11 color: #f5f5dc
        _tabfg1 = 'black'
        _tabfg2 = 'black'
        _tabbg1 = 'grey75'
        _tabbg2 = 'grey89'
        _bgmode = 'light'

        top.geometry("500x120+138+702")
        move_to_center(top, 500, 120)
        top.minsize(72, 15)
        top.maxsize(3648, 1089)
        top.resizable(1, 1)
        top.title("Manual mode")
        top.configure(background="#edf0f3")
        top.configure(highlightbackground="#d9d9d9")
        top.configure(highlightcolor="black")

        self.top = top
        self.images = tk.StringVar()

        self.Frame = tk.Frame(self.top)
        self.Frame.place(relx=0.04, rely=0.167, relheight=0.333,
                         relwidth=0.912)
        self.Frame.configure(relief='groove')
        self.Frame.configure(borderwidth="2")
        self.Frame.configure(relief="groove")
        self.Frame.configure(background="#edf0f3")
        self.Frame.configure(highlightbackground="#d9d9d9")
        self.Frame.configure(highlightcolor="black")

        self.Label = tk.Label(self.Frame)
        self.Label.place(relx=0.154, rely=0.25, height=22, width=90)
        self.Label.configure(activebackground="#f9f9f9")
        self.Label.configure(anchor='w')
        self.Label.configure(background="#edf0f3")
        self.Label.configure(compound='left')
        self.Label.configure(foreground="#000000")
        self.Label.configure(highlightbackground="#d9d9d9")
        self.Label.configure(highlightcolor="black")
        self.Label.configure(text='''Target images''')
        self.tooltip_font = "TkDefaultFont"
        self.Label_tooltip = ToolTip(
            self.Label, self.tooltip_font, 'target images')

        self.Entry = tk.Entry(self.Frame)
        self.Entry.place(relx=0.395, rely=0.125, height=30, relwidth=0.439)
        self.Entry.configure(background="white")
        self.Entry.configure(font="TkFixedFont")
        self.Entry.configure(foreground="#000000")
        self.Entry.configure(highlightbackground="#d9d9d9")
        self.Entry.configure(highlightcolor="black")
        self.Entry.configure(insertbackground="black")
        self.Entry.configure(selectbackground="#c4c4c4")
        self.Entry.configure(selectforeground="black")
        self.Entry.configure(textvariable=self.images)

        self.Button1 = tk.Button(self.Frame)
        self.Button1.place(relx=0.833, rely=0.125, height=30, width=70)
        self.Button1.configure(activebackground="beige")
        self.Button1.configure(activeforeground="#000000")
        self.Button1.configure(background="#edf0f3")
        self.Button1.configure(command=open_file(
            'Target images', self.Entry, single=False))
        self.Button1.configure(compound='left')
        self.Button1.configure(foreground="#000000")
        self.Button1.configure(highlightbackground="#edf0f3")
        self.Button1.configure(highlightcolor="black")
        self.Button1.configure(text='''Open''')

        self.Button2 = tk.Button(self.top)
        self.Button2.place(relx=0.4, rely=0.583, height=40, width=100)
        self.Button2.configure(activebackground="beige")
        self.Button2.configure(activeforeground="#000000")
        self.Button2.configure(background="#edf0f3")
        self.Button2.configure(command=run(mode=4, images=self.images))
        self.Button2.configure(compound='left')
        self.Button2.configure(foreground="#000000")
        self.Button2.configure(highlightbackground="#edf0f3")
        self.Button2.configure(highlightcolor="black")
        self.Button2.configure(text='''Run''')


class Scroll:
    def __init__(self, top=None):
        _bgcolor = '#edf0f3'  # Closest X11 color: 'gray94'
        _fgcolor = '#000000'  # X11 color: 'black'
        _compcolor = 'gray40'  # X11 color: #666666
        _ana1color = '#c3c3c3'  # Closest X11 color: 'gray76'
        _ana2color = 'beige'  # X11 color: #f5f5dc
        _tabfg1 = 'black'
        _tabfg2 = 'black'
        _tabbg1 = 'grey75'
        _tabbg2 = 'grey89'
        _bgmode = 'light'
        self.style = ttk.Style()
        if sys.platform == "win32":
            self.style.theme_use('winnative')
        self.style.configure('.', background=_bgcolor)
        self.style.configure('.', foreground=_fgcolor)
        self.style.map('.', background=[('selected', _compcolor),
                                        ('active', _ana2color)])

        top.geometry("500x200+225+402")
        move_to_center(top, 500, 200)
        top.minsize(72, 15)
        top.maxsize(3648, 1089)
        top.resizable(1, 1)
        top.title("Log")
        top.configure(background="#edf0f3")
        top.configure(highlightbackground="#d9d9d9")
        top.configure(highlightcolor="black")

        def poll():
            while True:
                try:
                    msg = log_queue.get(block=False)
                    level = msg.levelname
                    msg = formatter.format(msg) + '\n'
                    self.Scrolledtext1.insert('end', msg, level)
                    self.Scrolledtext1.yview('end')
                except queue.Empty:
                    break
            # to avoid orphan poll()
            if log.hasHandlers():
                self.Scrolledtext1.after(1, poll)
            else:
                return

        self.top = top
        # clean old handlers
        for i in log.handlers:
            log.removeHandler(i)
        log_queue = queue.Queue()
        formatter = logging.Formatter(fmt=global_vars.FMT,
                                      datefmt=global_vars.DATEFMT)
        # do not add formatter to queuehandler, or msg will be formatted twice
        queue_handler = handlers.QueueHandler(log_queue)
        # give poll() time to quit
        root.after(100, log.addHandler(queue_handler))
        self.Scrolledtext1 = scrolledtext.ScrolledText(self.top)
        self.Scrolledtext1.place(relx=0.0, rely=0.0, relheight=1.0,
                                 relwidth=1.0)
        self.Scrolledtext1.configure(background="white")
        self.Scrolledtext1.configure(font="TkTextFont")
        self.Scrolledtext1.configure(foreground="black")
        self.Scrolledtext1.configure(highlightbackground="#edf0f3")
        self.Scrolledtext1.configure(highlightcolor="black")
        self.Scrolledtext1.configure(insertbackground="black")
        self.Scrolledtext1.configure(insertborderwidth="3")
        self.Scrolledtext1.configure(selectbackground="#c4c4c4")
        self.Scrolledtext1.configure(selectforeground="black")
        self.Scrolledtext1.configure(wrap="none")
        self.Scrolledtext1.tag_config('INFO', foreground='black')
        self.Scrolledtext1.tag_config('WARNING', foreground='orange')
        self.Scrolledtext1.tag_config('ERROR', foreground='red')
        self.Scrolledtext1.tag_config('CRITICAL', foreground='red')
        self.Scrolledtext1.tag_config('EXCEPTION', foreground='red')
        self.Scrolledtext1.pack(fill='both')
        self.Scrolledtext1.after(0, poll)


class ToolTip(tk.Toplevel):
    """
    Provides a ToolTip widget for Tkinter.
    Support code for Balloon Help (also called tooltips).
    derived from http://code.activestate.com/recipes/576688-tooltip-for-tkinter/
    """

    def __init__(self, wdgt, tooltip_font, msg=None, msgFunc=None,
                 delay=0.5, follow=True):
        self.wdgt = wdgt
        self.parent = self.wdgt.master
        tk.Toplevel.__init__(self, self.parent, bg='black', padx=1, pady=1)
        self.withdraw()
        self.overrideredirect(True)
        self.msgVar = tk.StringVar()
        if msg is None:
            self.msgVar.set('No message provided')
        else:
            self.msgVar.set(msg)
        self.msgFunc = msgFunc
        self.delay = delay
        self.follow = follow
        self.visible = 0
        self.lastMotion = 0
        tk.Message(self, textvariable=self.msgVar, bg='#FFFFDD',
                   font=tooltip_font,
                   aspect=1000).grid()
        self.wdgt.bind('<Enter>', self.spawn, '+')
        self.wdgt.bind('<Leave>', self.hide, '+')
        self.wdgt.bind('<Motion>', self.move, '+')

    def spawn(self, event=None):
        self.visible = 1
        self.after(int(self.delay * 1000), self.show)

    def show(self):
        if self.visible == 1 and time() - self.lastMotion > self.delay:
            self.visible = 2
        if self.visible == 2:
            self.deiconify()

    def move(self, event):
        self.lastMotion = time()
        if self.follow is False:
            self.withdraw()
            self.visible = 1
        self.geometry('+%i+%i' % (event.x_root + 20, event.y_root - 10))
        try:
            self.msgVar.set(self.msgFunc())
        except:
            pass
        self.after(int(self.delay * 1000), self.show)

    def hide(self, event=None):
        self.visible = 0
        self.withdraw()

    def update(self, msg):
        self.msgVar.set(msg)


def open_file(title, entry, single=True):
    def func():
        if single:
            a = filedialog.askopenfilename(title=title)
            if ' ' in a:
                messagebox.showwarning(
                    message="File names should not have space character")

        else:
            a = filedialog.askopenfilenames(title=title)
            for i in a:
                if ' ' in i:
                    messagebox.showwarning(
                        message="File names should not have space character")
        entry.delete(0, 'end')
        entry.insert(0, a)
    return func


def example():
    with resources.path('pyGUS', 'data') as data_folder:
        open_folder(data_folder)
    return


def help():
    with resources.path('pyGUS', 'data') as data_folder:
        manual = data_folder / 'Manual.pdf'
        open_folder(manual)
    return


def run_mode1():
    global _top2, _w2
    _top2 = tk.Toplevel(root)
    _w2 = Mode1(_top2)


def run_mode2():
    global _top3, _w3
    _top3 = tk.Toplevel(root)
    _w3 = Mode2(_top3)


def run_mode3():
    # Creates a toplevel widget.
    global _top4, _w4
    _top4 = tk.Toplevel(root)
    _w4 = Mode3(_top4)


def run_mode4():
    global _top5, _w5
    _top5 = tk.Toplevel(root)
    _w5 = Mode4(_top5)


def run(mode, ref1=None, ref2=None, images=None):
    # call core

    def call():
        s_list = ['', '', '']
        for index, entry in enumerate([ref1, ref2, images]):
            if entry is not None:
                if entry.get() == '':
                    messagebox.showerror(message='Empty input!')
                    return
                else:
                    s_list[index] = entry.get()


        # global _w1
        is_quick = bool(_w1.che0.get())
        log.debug(f'is quick mode: {is_quick}')
        cmd = (f'-mode {mode} -ref1 {s_list[0]} -ref2 {s_list[1]} '
               f'-images {s_list[2]}')
        if is_quick:
            cmd += ' -quick'
        log.info(cmd)
        # opencv imshow could only run in main thread
        from pyGUS.utils import Quit
        if mode != 4:
            pass
            # messagebox.showinfo(message='Running...')
        root.iconify()
        try:
            svg_file, csv_file = core.cli_main(cmd)
        except Quit:
            return
        finally:
            root.deiconify()
        if svg_file is not None and csv_file is not None:
            messagebox.showinfo(message=f'Output file {svg_file} {csv_file}')
        else:
            messagebox.showinfo(message='Abort.')
        # scroll = Scroll(root)
    return call


def ui_main():
    global_vars.is_gui = True
    global root
    root = tk.Tk()
    root.protocol('WM_DELETE_WINDOW', root.destroy)
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = Root(_top1)
    root.mainloop()


if __name__ == '__main__':
    ui_main()
