# -*- coding: utf-8 -*-
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from .compute import (
    AbandonInstancesInstanceGroupManagerRequest,
    AbandonInstancesRegionInstanceGroupManagerRequest,
    AcceleratorConfig,
    Accelerators,
    AcceleratorType,
    AcceleratorTypeAggregatedList,
    AcceleratorTypeList,
    AcceleratorTypesScopedList,
    AccessConfig,
    AddAccessConfigInstanceRequest,
    AddHealthCheckTargetPoolRequest,
    AddInstancesInstanceGroupRequest,
    AddInstanceTargetPoolRequest,
    AddNodesNodeGroupRequest,
    AddPeeringNetworkRequest,
    AddResourcePoliciesDiskRequest,
    AddResourcePoliciesInstanceRequest,
    AddResourcePoliciesRegionDiskRequest,
    Address,
    AddressAggregatedList,
    AddressesScopedList,
    AddressList,
    AddRuleSecurityPolicyRequest,
    AddSignedUrlKeyBackendBucketRequest,
    AddSignedUrlKeyBackendServiceRequest,
    AggregatedListAcceleratorTypesRequest,
    AggregatedListAddressesRequest,
    AggregatedListAutoscalersRequest,
    AggregatedListBackendServicesRequest,
    AggregatedListDisksRequest,
    AggregatedListDiskTypesRequest,
    AggregatedListForwardingRulesRequest,
    AggregatedListGlobalOperationsRequest,
    AggregatedListHealthChecksRequest,
    AggregatedListInstanceGroupManagersRequest,
    AggregatedListInstanceGroupsRequest,
    AggregatedListInstancesRequest,
    AggregatedListInterconnectAttachmentsRequest,
    AggregatedListMachineTypesRequest,
    AggregatedListNetworkEndpointGroupsRequest,
    AggregatedListNodeGroupsRequest,
    AggregatedListNodeTemplatesRequest,
    AggregatedListNodeTypesRequest,
    AggregatedListPacketMirroringsRequest,
    AggregatedListRegionCommitmentsRequest,
    AggregatedListReservationsRequest,
    AggregatedListResourcePoliciesRequest,
    AggregatedListRoutersRequest,
    AggregatedListSslCertificatesRequest,
    AggregatedListSubnetworksRequest,
    AggregatedListTargetHttpProxiesRequest,
    AggregatedListTargetHttpsProxiesRequest,
    AggregatedListTargetInstancesRequest,
    AggregatedListTargetPoolsRequest,
    AggregatedListTargetVpnGatewaysRequest,
    AggregatedListUrlMapsRequest,
    AggregatedListVpnGatewaysRequest,
    AggregatedListVpnTunnelsRequest,
    AliasIpRange,
    AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk,
    AllocationSpecificSKUAllocationReservedInstanceProperties,
    AllocationSpecificSKUReservation,
    Allowed,
    ApplyUpdatesToInstancesInstanceGroupManagerRequest,
    ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest,
    AttachDiskInstanceRequest,
    AttachedDisk,
    AttachedDiskInitializeParams,
    AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    AttachNetworkEndpointsNetworkEndpointGroupRequest,
    AuditConfig,
    AuditLogConfig,
    AuthorizationLoggingOptions,
    Autoscaler,
    AutoscalerAggregatedList,
    AutoscalerList,
    AutoscalersScopedList,
    AutoscalerStatusDetails,
    AutoscalingPolicy,
    AutoscalingPolicyCpuUtilization,
    AutoscalingPolicyCustomMetricUtilization,
    AutoscalingPolicyLoadBalancingUtilization,
    AutoscalingPolicyScaleInControl,
    Backend,
    BackendBucket,
    BackendBucketCdnPolicy,
    BackendBucketList,
    BackendService,
    BackendServiceAggregatedList,
    BackendServiceCdnPolicy,
    BackendServiceFailoverPolicy,
    BackendServiceGroupHealth,
    BackendServiceIAP,
    BackendServiceList,
    BackendServiceLogConfig,
    BackendServiceReference,
    BackendServicesScopedList,
    Binding,
    CacheInvalidationRule,
    CacheKeyPolicy,
    CircuitBreakers,
    Commitment,
    CommitmentAggregatedList,
    CommitmentList,
    CommitmentsScopedList,
    Condition,
    ConfidentialInstanceConfig,
    ConnectionDraining,
    ConsistentHashLoadBalancerSettings,
    ConsistentHashLoadBalancerSettingsHttpCookie,
    CorsPolicy,
    CreateInstancesInstanceGroupManagerRequest,
    CreateInstancesRegionInstanceGroupManagerRequest,
    CreateSnapshotDiskRequest,
    CreateSnapshotRegionDiskRequest,
    CustomerEncryptionKey,
    CustomerEncryptionKeyProtectedDisk,
    Data,
    DeleteAccessConfigInstanceRequest,
    DeleteAddressRequest,
    DeleteAutoscalerRequest,
    DeleteBackendBucketRequest,
    DeleteBackendServiceRequest,
    DeleteDiskRequest,
    DeleteExternalVpnGatewayRequest,
    DeleteFirewallRequest,
    DeleteForwardingRuleRequest,
    DeleteGlobalAddressRequest,
    DeleteGlobalForwardingRuleRequest,
    DeleteGlobalNetworkEndpointGroupRequest,
    DeleteGlobalOperationRequest,
    DeleteGlobalOperationResponse,
    DeleteGlobalOrganizationOperationRequest,
    DeleteGlobalOrganizationOperationResponse,
    DeleteHealthCheckRequest,
    DeleteImageRequest,
    DeleteInstanceGroupManagerRequest,
    DeleteInstanceGroupRequest,
    DeleteInstanceRequest,
    DeleteInstancesInstanceGroupManagerRequest,
    DeleteInstancesRegionInstanceGroupManagerRequest,
    DeleteInstanceTemplateRequest,
    DeleteInterconnectAttachmentRequest,
    DeleteInterconnectRequest,
    DeleteLicenseRequest,
    DeleteNetworkEndpointGroupRequest,
    DeleteNetworkRequest,
    DeleteNodeGroupRequest,
    DeleteNodesNodeGroupRequest,
    DeleteNodeTemplateRequest,
    DeletePacketMirroringRequest,
    DeletePerInstanceConfigsInstanceGroupManagerRequest,
    DeletePerInstanceConfigsRegionInstanceGroupManagerRequest,
    DeleteRegionAutoscalerRequest,
    DeleteRegionBackendServiceRequest,
    DeleteRegionDiskRequest,
    DeleteRegionHealthCheckRequest,
    DeleteRegionHealthCheckServiceRequest,
    DeleteRegionInstanceGroupManagerRequest,
    DeleteRegionNetworkEndpointGroupRequest,
    DeleteRegionNotificationEndpointRequest,
    DeleteRegionOperationRequest,
    DeleteRegionOperationResponse,
    DeleteRegionSslCertificateRequest,
    DeleteRegionTargetHttpProxyRequest,
    DeleteRegionTargetHttpsProxyRequest,
    DeleteRegionUrlMapRequest,
    DeleteReservationRequest,
    DeleteResourcePolicyRequest,
    DeleteRouteRequest,
    DeleteRouterRequest,
    DeleteSecurityPolicyRequest,
    DeleteSignedUrlKeyBackendBucketRequest,
    DeleteSignedUrlKeyBackendServiceRequest,
    DeleteSnapshotRequest,
    DeleteSslCertificateRequest,
    DeleteSslPolicyRequest,
    DeleteSubnetworkRequest,
    DeleteTargetGrpcProxyRequest,
    DeleteTargetHttpProxyRequest,
    DeleteTargetHttpsProxyRequest,
    DeleteTargetInstanceRequest,
    DeleteTargetPoolRequest,
    DeleteTargetSslProxyRequest,
    DeleteTargetTcpProxyRequest,
    DeleteTargetVpnGatewayRequest,
    DeleteUrlMapRequest,
    DeleteVpnGatewayRequest,
    DeleteVpnTunnelRequest,
    DeleteZoneOperationRequest,
    DeleteZoneOperationResponse,
    Denied,
    DeprecateImageRequest,
    DeprecationStatus,
    DetachDiskInstanceRequest,
    DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    DetachNetworkEndpointsNetworkEndpointGroupRequest,
    DisableXpnHostProjectRequest,
    DisableXpnResourceProjectRequest,
    Disk,
    DiskAggregatedList,
    DiskInstantiationConfig,
    DiskList,
    DiskMoveRequest,
    DisksAddResourcePoliciesRequest,
    DisksRemoveResourcePoliciesRequest,
    DisksResizeRequest,
    DisksScopedList,
    DiskType,
    DiskTypeAggregatedList,
    DiskTypeList,
    DiskTypesScopedList,
    DisplayDevice,
    DistributionPolicy,
    DistributionPolicyZoneConfiguration,
    Duration,
    EnableXpnHostProjectRequest,
    EnableXpnResourceProjectRequest,
    Error,
    Errors,
    ExchangedPeeringRoute,
    ExchangedPeeringRoutesList,
    ExpandIpCidrRangeSubnetworkRequest,
    Expr,
    ExternalVpnGateway,
    ExternalVpnGatewayInterface,
    ExternalVpnGatewayList,
    FileContentBuffer,
    Firewall,
    FirewallList,
    FirewallLogConfig,
    FixedOrPercent,
    ForwardingRule,
    ForwardingRuleAggregatedList,
    ForwardingRuleList,
    ForwardingRuleReference,
    ForwardingRulesScopedList,
    GetAcceleratorTypeRequest,
    GetAddressRequest,
    GetAutoscalerRequest,
    GetBackendBucketRequest,
    GetBackendServiceRequest,
    GetDiagnosticsInterconnectRequest,
    GetDiskRequest,
    GetDiskTypeRequest,
    GetExternalVpnGatewayRequest,
    GetFirewallRequest,
    GetForwardingRuleRequest,
    GetFromFamilyImageRequest,
    GetGlobalAddressRequest,
    GetGlobalForwardingRuleRequest,
    GetGlobalNetworkEndpointGroupRequest,
    GetGlobalOperationRequest,
    GetGlobalOrganizationOperationRequest,
    GetGuestAttributesInstanceRequest,
    GetHealthBackendServiceRequest,
    GetHealthCheckRequest,
    GetHealthRegionBackendServiceRequest,
    GetHealthTargetPoolRequest,
    GetIamPolicyDiskRequest,
    GetIamPolicyImageRequest,
    GetIamPolicyInstanceRequest,
    GetIamPolicyInstanceTemplateRequest,
    GetIamPolicyLicenseRequest,
    GetIamPolicyNodeGroupRequest,
    GetIamPolicyNodeTemplateRequest,
    GetIamPolicyRegionDiskRequest,
    GetIamPolicyReservationRequest,
    GetIamPolicyResourcePolicyRequest,
    GetIamPolicySnapshotRequest,
    GetIamPolicySubnetworkRequest,
    GetImageRequest,
    GetInstanceGroupManagerRequest,
    GetInstanceGroupRequest,
    GetInstanceRequest,
    GetInstanceTemplateRequest,
    GetInterconnectAttachmentRequest,
    GetInterconnectLocationRequest,
    GetInterconnectRequest,
    GetLicenseCodeRequest,
    GetLicenseRequest,
    GetMachineTypeRequest,
    GetNatMappingInfoRoutersRequest,
    GetNetworkEndpointGroupRequest,
    GetNetworkRequest,
    GetNodeGroupRequest,
    GetNodeTemplateRequest,
    GetNodeTypeRequest,
    GetPacketMirroringRequest,
    GetProjectRequest,
    GetRegionAutoscalerRequest,
    GetRegionBackendServiceRequest,
    GetRegionCommitmentRequest,
    GetRegionDiskRequest,
    GetRegionDiskTypeRequest,
    GetRegionHealthCheckRequest,
    GetRegionHealthCheckServiceRequest,
    GetRegionInstanceGroupManagerRequest,
    GetRegionInstanceGroupRequest,
    GetRegionNetworkEndpointGroupRequest,
    GetRegionNotificationEndpointRequest,
    GetRegionOperationRequest,
    GetRegionRequest,
    GetRegionSslCertificateRequest,
    GetRegionTargetHttpProxyRequest,
    GetRegionTargetHttpsProxyRequest,
    GetRegionUrlMapRequest,
    GetReservationRequest,
    GetResourcePolicyRequest,
    GetRouteRequest,
    GetRouterRequest,
    GetRouterStatusRouterRequest,
    GetRuleSecurityPolicyRequest,
    GetScreenshotInstanceRequest,
    GetSecurityPolicyRequest,
    GetSerialPortOutputInstanceRequest,
    GetShieldedInstanceIdentityInstanceRequest,
    GetSnapshotRequest,
    GetSslCertificateRequest,
    GetSslPolicyRequest,
    GetStatusVpnGatewayRequest,
    GetSubnetworkRequest,
    GetTargetGrpcProxyRequest,
    GetTargetHttpProxyRequest,
    GetTargetHttpsProxyRequest,
    GetTargetInstanceRequest,
    GetTargetPoolRequest,
    GetTargetSslProxyRequest,
    GetTargetTcpProxyRequest,
    GetTargetVpnGatewayRequest,
    GetUrlMapRequest,
    GetVpnGatewayRequest,
    GetVpnTunnelRequest,
    GetXpnHostProjectRequest,
    GetXpnResourcesProjectsRequest,
    GetZoneOperationRequest,
    GetZoneRequest,
    GlobalNetworkEndpointGroupsAttachEndpointsRequest,
    GlobalNetworkEndpointGroupsDetachEndpointsRequest,
    GlobalSetLabelsRequest,
    GlobalSetPolicyRequest,
    GRPCHealthCheck,
    GuestAttributes,
    GuestAttributesEntry,
    GuestAttributesValue,
    GuestOsFeature,
    HealthCheck,
    HealthCheckList,
    HealthCheckLogConfig,
    HealthCheckReference,
    HealthChecksAggregatedList,
    HealthCheckService,
    HealthCheckServiceReference,
    HealthCheckServicesList,
    HealthChecksScopedList,
    HealthStatus,
    HealthStatusForNetworkEndpoint,
    HostRule,
    HTTP2HealthCheck,
    HttpFaultAbort,
    HttpFaultDelay,
    HttpFaultInjection,
    HttpHeaderAction,
    HttpHeaderMatch,
    HttpHeaderOption,
    HTTPHealthCheck,
    HttpQueryParameterMatch,
    HttpRedirectAction,
    HttpRetryPolicy,
    HttpRouteAction,
    HttpRouteRule,
    HttpRouteRuleMatch,
    HTTPSHealthCheck,
    Image,
    ImageList,
    InitialStateConfig,
    InsertAddressRequest,
    InsertAutoscalerRequest,
    InsertBackendBucketRequest,
    InsertBackendServiceRequest,
    InsertDiskRequest,
    InsertExternalVpnGatewayRequest,
    InsertFirewallRequest,
    InsertForwardingRuleRequest,
    InsertGlobalAddressRequest,
    InsertGlobalForwardingRuleRequest,
    InsertGlobalNetworkEndpointGroupRequest,
    InsertHealthCheckRequest,
    InsertImageRequest,
    InsertInstanceGroupManagerRequest,
    InsertInstanceGroupRequest,
    InsertInstanceRequest,
    InsertInstanceTemplateRequest,
    InsertInterconnectAttachmentRequest,
    InsertInterconnectRequest,
    InsertLicenseRequest,
    InsertNetworkEndpointGroupRequest,
    InsertNetworkRequest,
    InsertNodeGroupRequest,
    InsertNodeTemplateRequest,
    InsertPacketMirroringRequest,
    InsertRegionAutoscalerRequest,
    InsertRegionBackendServiceRequest,
    InsertRegionCommitmentRequest,
    InsertRegionDiskRequest,
    InsertRegionHealthCheckRequest,
    InsertRegionHealthCheckServiceRequest,
    InsertRegionInstanceGroupManagerRequest,
    InsertRegionNetworkEndpointGroupRequest,
    InsertRegionNotificationEndpointRequest,
    InsertRegionSslCertificateRequest,
    InsertRegionTargetHttpProxyRequest,
    InsertRegionTargetHttpsProxyRequest,
    InsertRegionUrlMapRequest,
    InsertReservationRequest,
    InsertResourcePolicyRequest,
    InsertRouteRequest,
    InsertRouterRequest,
    InsertSecurityPolicyRequest,
    InsertSslCertificateRequest,
    InsertSslPolicyRequest,
    InsertSubnetworkRequest,
    InsertTargetGrpcProxyRequest,
    InsertTargetHttpProxyRequest,
    InsertTargetHttpsProxyRequest,
    InsertTargetInstanceRequest,
    InsertTargetPoolRequest,
    InsertTargetSslProxyRequest,
    InsertTargetTcpProxyRequest,
    InsertTargetVpnGatewayRequest,
    InsertUrlMapRequest,
    InsertVpnGatewayRequest,
    InsertVpnTunnelRequest,
    Instance,
    InstanceAggregatedList,
    InstanceGroup,
    InstanceGroupAggregatedList,
    InstanceGroupList,
    InstanceGroupManager,
    InstanceGroupManagerActionsSummary,
    InstanceGroupManagerAggregatedList,
    InstanceGroupManagerAutoHealingPolicy,
    InstanceGroupManagerList,
    InstanceGroupManagersAbandonInstancesRequest,
    InstanceGroupManagersApplyUpdatesRequest,
    InstanceGroupManagersCreateInstancesRequest,
    InstanceGroupManagersDeleteInstancesRequest,
    InstanceGroupManagersDeletePerInstanceConfigsReq,
    InstanceGroupManagersListErrorsResponse,
    InstanceGroupManagersListManagedInstancesResponse,
    InstanceGroupManagersListPerInstanceConfigsResp,
    InstanceGroupManagersPatchPerInstanceConfigsReq,
    InstanceGroupManagersRecreateInstancesRequest,
    InstanceGroupManagersScopedList,
    InstanceGroupManagersSetInstanceTemplateRequest,
    InstanceGroupManagersSetTargetPoolsRequest,
    InstanceGroupManagerStatus,
    InstanceGroupManagerStatusStateful,
    InstanceGroupManagerStatusStatefulPerInstanceConfigs,
    InstanceGroupManagerStatusVersionTarget,
    InstanceGroupManagersUpdatePerInstanceConfigsReq,
    InstanceGroupManagerUpdatePolicy,
    InstanceGroupManagerVersion,
    InstanceGroupsAddInstancesRequest,
    InstanceGroupsListInstances,
    InstanceGroupsListInstancesRequest,
    InstanceGroupsRemoveInstancesRequest,
    InstanceGroupsScopedList,
    InstanceGroupsSetNamedPortsRequest,
    InstanceList,
    InstanceListReferrers,
    InstanceManagedByIgmError,
    InstanceManagedByIgmErrorInstanceActionDetails,
    InstanceManagedByIgmErrorManagedInstanceError,
    InstanceMoveRequest,
    InstanceProperties,
    InstanceReference,
    InstancesAddResourcePoliciesRequest,
    InstancesRemoveResourcePoliciesRequest,
    InstancesScopedList,
    InstancesSetLabelsRequest,
    InstancesSetMachineResourcesRequest,
    InstancesSetMachineTypeRequest,
    InstancesSetMinCpuPlatformRequest,
    InstancesSetServiceAccountRequest,
    InstancesStartWithEncryptionKeyRequest,
    InstanceTemplate,
    InstanceTemplateList,
    InstanceWithNamedPorts,
    Int64RangeMatch,
    Interconnect,
    InterconnectAttachment,
    InterconnectAttachmentAggregatedList,
    InterconnectAttachmentList,
    InterconnectAttachmentPartnerMetadata,
    InterconnectAttachmentPrivateInfo,
    InterconnectAttachmentsScopedList,
    InterconnectCircuitInfo,
    InterconnectDiagnostics,
    InterconnectDiagnosticsARPEntry,
    InterconnectDiagnosticsLinkLACPStatus,
    InterconnectDiagnosticsLinkOpticalPower,
    InterconnectDiagnosticsLinkStatus,
    InterconnectList,
    InterconnectLocation,
    InterconnectLocationList,
    InterconnectLocationRegionInfo,
    InterconnectOutageNotification,
    InterconnectsGetDiagnosticsResponse,
    InvalidateCacheUrlMapRequest,
    Items,
    License,
    LicenseCode,
    LicenseCodeLicenseAlias,
    LicenseResourceCommitment,
    LicenseResourceRequirements,
    LicensesListResponse,
    ListAcceleratorTypesRequest,
    ListAddressesRequest,
    ListAutoscalersRequest,
    ListAvailableFeaturesSslPoliciesRequest,
    ListBackendBucketsRequest,
    ListBackendServicesRequest,
    ListDisksRequest,
    ListDiskTypesRequest,
    ListErrorsInstanceGroupManagersRequest,
    ListErrorsRegionInstanceGroupManagersRequest,
    ListExternalVpnGatewaysRequest,
    ListFirewallsRequest,
    ListForwardingRulesRequest,
    ListGlobalAddressesRequest,
    ListGlobalForwardingRulesRequest,
    ListGlobalNetworkEndpointGroupsRequest,
    ListGlobalOperationsRequest,
    ListGlobalOrganizationOperationsRequest,
    ListHealthChecksRequest,
    ListImagesRequest,
    ListInstanceGroupManagersRequest,
    ListInstanceGroupsRequest,
    ListInstancesInstanceGroupsRequest,
    ListInstancesRegionInstanceGroupsRequest,
    ListInstancesRequest,
    ListInstanceTemplatesRequest,
    ListInterconnectAttachmentsRequest,
    ListInterconnectLocationsRequest,
    ListInterconnectsRequest,
    ListLicensesRequest,
    ListMachineTypesRequest,
    ListManagedInstancesInstanceGroupManagersRequest,
    ListManagedInstancesRegionInstanceGroupManagersRequest,
    ListNetworkEndpointGroupsRequest,
    ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest,
    ListNetworkEndpointsNetworkEndpointGroupsRequest,
    ListNetworksRequest,
    ListNodeGroupsRequest,
    ListNodesNodeGroupsRequest,
    ListNodeTemplatesRequest,
    ListNodeTypesRequest,
    ListPacketMirroringsRequest,
    ListPeeringRoutesNetworksRequest,
    ListPerInstanceConfigsInstanceGroupManagersRequest,
    ListPerInstanceConfigsRegionInstanceGroupManagersRequest,
    ListPreconfiguredExpressionSetsSecurityPoliciesRequest,
    ListReferrersInstancesRequest,
    ListRegionAutoscalersRequest,
    ListRegionBackendServicesRequest,
    ListRegionCommitmentsRequest,
    ListRegionDisksRequest,
    ListRegionDiskTypesRequest,
    ListRegionHealthCheckServicesRequest,
    ListRegionHealthChecksRequest,
    ListRegionInstanceGroupManagersRequest,
    ListRegionInstanceGroupsRequest,
    ListRegionNetworkEndpointGroupsRequest,
    ListRegionNotificationEndpointsRequest,
    ListRegionOperationsRequest,
    ListRegionsRequest,
    ListRegionSslCertificatesRequest,
    ListRegionTargetHttpProxiesRequest,
    ListRegionTargetHttpsProxiesRequest,
    ListRegionUrlMapsRequest,
    ListReservationsRequest,
    ListResourcePoliciesRequest,
    ListRoutersRequest,
    ListRoutesRequest,
    ListSecurityPoliciesRequest,
    ListSnapshotsRequest,
    ListSslCertificatesRequest,
    ListSslPoliciesRequest,
    ListSubnetworksRequest,
    ListTargetGrpcProxiesRequest,
    ListTargetHttpProxiesRequest,
    ListTargetHttpsProxiesRequest,
    ListTargetInstancesRequest,
    ListTargetPoolsRequest,
    ListTargetSslProxiesRequest,
    ListTargetTcpProxiesRequest,
    ListTargetVpnGatewaysRequest,
    ListUrlMapsRequest,
    ListUsableSubnetworksRequest,
    ListVpnGatewaysRequest,
    ListVpnTunnelsRequest,
    ListXpnHostsProjectsRequest,
    ListZoneOperationsRequest,
    ListZonesRequest,
    LocalDisk,
    LogConfig,
    LogConfigCloudAuditOptions,
    LogConfigCounterOptions,
    LogConfigCounterOptionsCustomField,
    LogConfigDataAccessOptions,
    MachineType,
    MachineTypeAggregatedList,
    MachineTypeList,
    MachineTypesScopedList,
    ManagedInstance,
    ManagedInstanceInstanceHealth,
    ManagedInstanceLastAttempt,
    ManagedInstanceVersion,
    Metadata,
    MetadataFilter,
    MetadataFilterLabelMatch,
    MoveDiskProjectRequest,
    MoveInstanceProjectRequest,
    NamedPort,
    Network,
    NetworkEndpoint,
    NetworkEndpointGroup,
    NetworkEndpointGroupAggregatedList,
    NetworkEndpointGroupAppEngine,
    NetworkEndpointGroupCloudFunction,
    NetworkEndpointGroupCloudRun,
    NetworkEndpointGroupList,
    NetworkEndpointGroupsAttachEndpointsRequest,
    NetworkEndpointGroupsDetachEndpointsRequest,
    NetworkEndpointGroupsListEndpointsRequest,
    NetworkEndpointGroupsListNetworkEndpoints,
    NetworkEndpointGroupsScopedList,
    NetworkEndpointWithHealthStatus,
    NetworkInterface,
    NetworkList,
    NetworkPeering,
    NetworkRoutingConfig,
    NetworksAddPeeringRequest,
    NetworksRemovePeeringRequest,
    NetworksUpdatePeeringRequest,
    NodeGroup,
    NodeGroupAggregatedList,
    NodeGroupAutoscalingPolicy,
    NodeGroupList,
    NodeGroupMaintenanceWindow,
    NodeGroupNode,
    NodeGroupsAddNodesRequest,
    NodeGroupsDeleteNodesRequest,
    NodeGroupsListNodes,
    NodeGroupsScopedList,
    NodeGroupsSetNodeTemplateRequest,
    NodeTemplate,
    NodeTemplateAggregatedList,
    NodeTemplateList,
    NodeTemplateNodeTypeFlexibility,
    NodeTemplatesScopedList,
    NodeType,
    NodeTypeAggregatedList,
    NodeTypeList,
    NodeTypesScopedList,
    NotificationEndpoint,
    NotificationEndpointGrpcSettings,
    NotificationEndpointList,
    Operation,
    OperationAggregatedList,
    OperationList,
    OperationsScopedList,
    OutlierDetection,
    PacketMirroring,
    PacketMirroringAggregatedList,
    PacketMirroringFilter,
    PacketMirroringForwardingRuleInfo,
    PacketMirroringList,
    PacketMirroringMirroredResourceInfo,
    PacketMirroringMirroredResourceInfoInstanceInfo,
    PacketMirroringMirroredResourceInfoSubnetInfo,
    PacketMirroringNetworkInfo,
    PacketMirroringsScopedList,
    PatchAutoscalerRequest,
    PatchBackendBucketRequest,
    PatchBackendServiceRequest,
    PatchFirewallRequest,
    PatchForwardingRuleRequest,
    PatchGlobalForwardingRuleRequest,
    PatchHealthCheckRequest,
    PatchImageRequest,
    PatchInstanceGroupManagerRequest,
    PatchInterconnectAttachmentRequest,
    PatchInterconnectRequest,
    PatchNetworkRequest,
    PatchNodeGroupRequest,
    PatchPacketMirroringRequest,
    PatchPerInstanceConfigsInstanceGroupManagerRequest,
    PatchPerInstanceConfigsRegionInstanceGroupManagerRequest,
    PatchRegionAutoscalerRequest,
    PatchRegionBackendServiceRequest,
    PatchRegionHealthCheckRequest,
    PatchRegionHealthCheckServiceRequest,
    PatchRegionInstanceGroupManagerRequest,
    PatchRegionUrlMapRequest,
    PatchRouterRequest,
    PatchRuleSecurityPolicyRequest,
    PatchSecurityPolicyRequest,
    PatchSslPolicyRequest,
    PatchSubnetworkRequest,
    PatchTargetGrpcProxyRequest,
    PatchTargetHttpProxyRequest,
    PatchUrlMapRequest,
    PathMatcher,
    PathRule,
    PerInstanceConfig,
    Policy,
    PreconfiguredWafSet,
    PreservedState,
    PreservedStatePreservedDisk,
    PreviewRouterRequest,
    Project,
    ProjectsDisableXpnResourceRequest,
    ProjectsEnableXpnResourceRequest,
    ProjectsGetXpnResources,
    ProjectsListXpnHostsRequest,
    ProjectsSetDefaultNetworkTierRequest,
    Quota,
    RawDisk,
    RecreateInstancesInstanceGroupManagerRequest,
    RecreateInstancesRegionInstanceGroupManagerRequest,
    Reference,
    Region,
    RegionAutoscalerList,
    RegionDisksAddResourcePoliciesRequest,
    RegionDisksRemoveResourcePoliciesRequest,
    RegionDisksResizeRequest,
    RegionDiskTypeList,
    RegionInstanceGroupList,
    RegionInstanceGroupManagerDeleteInstanceConfigReq,
    RegionInstanceGroupManagerList,
    RegionInstanceGroupManagerPatchInstanceConfigReq,
    RegionInstanceGroupManagersAbandonInstancesRequest,
    RegionInstanceGroupManagersApplyUpdatesRequest,
    RegionInstanceGroupManagersCreateInstancesRequest,
    RegionInstanceGroupManagersDeleteInstancesRequest,
    RegionInstanceGroupManagersListErrorsResponse,
    RegionInstanceGroupManagersListInstanceConfigsResp,
    RegionInstanceGroupManagersListInstancesResponse,
    RegionInstanceGroupManagersRecreateRequest,
    RegionInstanceGroupManagersSetTargetPoolsRequest,
    RegionInstanceGroupManagersSetTemplateRequest,
    RegionInstanceGroupManagerUpdateInstanceConfigReq,
    RegionInstanceGroupsListInstances,
    RegionInstanceGroupsListInstancesRequest,
    RegionInstanceGroupsSetNamedPortsRequest,
    RegionList,
    RegionSetLabelsRequest,
    RegionSetPolicyRequest,
    RegionTargetHttpsProxiesSetSslCertificatesRequest,
    RegionUrlMapsValidateRequest,
    RemoveHealthCheckTargetPoolRequest,
    RemoveInstancesInstanceGroupRequest,
    RemoveInstanceTargetPoolRequest,
    RemovePeeringNetworkRequest,
    RemoveResourcePoliciesDiskRequest,
    RemoveResourcePoliciesInstanceRequest,
    RemoveResourcePoliciesRegionDiskRequest,
    RemoveRuleSecurityPolicyRequest,
    RequestMirrorPolicy,
    Reservation,
    ReservationAffinity,
    ReservationAggregatedList,
    ReservationList,
    ReservationsResizeRequest,
    ReservationsScopedList,
    ResetInstanceRequest,
    ResizeDiskRequest,
    ResizeInstanceGroupManagerRequest,
    ResizeRegionDiskRequest,
    ResizeRegionInstanceGroupManagerRequest,
    ResizeReservationRequest,
    ResourceCommitment,
    ResourceGroupReference,
    ResourcePoliciesScopedList,
    ResourcePolicy,
    ResourcePolicyAggregatedList,
    ResourcePolicyDailyCycle,
    ResourcePolicyGroupPlacementPolicy,
    ResourcePolicyHourlyCycle,
    ResourcePolicyList,
    ResourcePolicySnapshotSchedulePolicy,
    ResourcePolicySnapshotSchedulePolicyRetentionPolicy,
    ResourcePolicySnapshotSchedulePolicySchedule,
    ResourcePolicySnapshotSchedulePolicySnapshotProperties,
    ResourcePolicyWeeklyCycle,
    ResourcePolicyWeeklyCycleDayOfWeek,
    Route,
    RouteList,
    Router,
    RouterAdvertisedIpRange,
    RouterAggregatedList,
    RouterBgp,
    RouterBgpPeer,
    RouterInterface,
    RouterList,
    RouterNat,
    RouterNatLogConfig,
    RouterNatSubnetworkToNat,
    RoutersPreviewResponse,
    RoutersScopedList,
    RouterStatus,
    RouterStatusBgpPeerStatus,
    RouterStatusNatStatus,
    RouterStatusResponse,
    Rule,
    Scheduling,
    SchedulingNodeAffinity,
    ScratchDisks,
    Screenshot,
    SecurityPoliciesListPreconfiguredExpressionSetsResponse,
    SecurityPoliciesWafConfig,
    SecurityPolicy,
    SecurityPolicyList,
    SecurityPolicyReference,
    SecurityPolicyRule,
    SecurityPolicyRuleMatcher,
    SecurityPolicyRuleMatcherConfig,
    SecuritySettings,
    SerialPortOutput,
    ServerBinding,
    ServiceAccount,
    SetBackendServiceTargetSslProxyRequest,
    SetBackendServiceTargetTcpProxyRequest,
    SetBackupTargetPoolRequest,
    SetCommonInstanceMetadataProjectRequest,
    SetDefaultNetworkTierProjectRequest,
    SetDeletionProtectionInstanceRequest,
    SetDiskAutoDeleteInstanceRequest,
    SetIamPolicyDiskRequest,
    SetIamPolicyImageRequest,
    SetIamPolicyInstanceRequest,
    SetIamPolicyInstanceTemplateRequest,
    SetIamPolicyLicenseRequest,
    SetIamPolicyNodeGroupRequest,
    SetIamPolicyNodeTemplateRequest,
    SetIamPolicyRegionDiskRequest,
    SetIamPolicyReservationRequest,
    SetIamPolicyResourcePolicyRequest,
    SetIamPolicySnapshotRequest,
    SetIamPolicySubnetworkRequest,
    SetInstanceTemplateInstanceGroupManagerRequest,
    SetInstanceTemplateRegionInstanceGroupManagerRequest,
    SetLabelsDiskRequest,
    SetLabelsExternalVpnGatewayRequest,
    SetLabelsImageRequest,
    SetLabelsInstanceRequest,
    SetLabelsRegionDiskRequest,
    SetLabelsSnapshotRequest,
    SetLabelsVpnGatewayRequest,
    SetMachineResourcesInstanceRequest,
    SetMachineTypeInstanceRequest,
    SetMetadataInstanceRequest,
    SetMinCpuPlatformInstanceRequest,
    SetNamedPortsInstanceGroupRequest,
    SetNamedPortsRegionInstanceGroupRequest,
    SetNodeTemplateNodeGroupRequest,
    SetPrivateIpGoogleAccessSubnetworkRequest,
    SetProxyHeaderTargetSslProxyRequest,
    SetProxyHeaderTargetTcpProxyRequest,
    SetQuicOverrideTargetHttpsProxyRequest,
    SetSchedulingInstanceRequest,
    SetSecurityPolicyBackendServiceRequest,
    SetServiceAccountInstanceRequest,
    SetShieldedInstanceIntegrityPolicyInstanceRequest,
    SetSslCertificatesRegionTargetHttpsProxyRequest,
    SetSslCertificatesTargetHttpsProxyRequest,
    SetSslCertificatesTargetSslProxyRequest,
    SetSslPolicyTargetHttpsProxyRequest,
    SetSslPolicyTargetSslProxyRequest,
    SetTagsInstanceRequest,
    SetTargetForwardingRuleRequest,
    SetTargetGlobalForwardingRuleRequest,
    SetTargetPoolsInstanceGroupManagerRequest,
    SetTargetPoolsRegionInstanceGroupManagerRequest,
    SetUrlMapRegionTargetHttpProxyRequest,
    SetUrlMapRegionTargetHttpsProxyRequest,
    SetUrlMapTargetHttpProxyRequest,
    SetUrlMapTargetHttpsProxyRequest,
    SetUsageExportBucketProjectRequest,
    ShieldedInstanceConfig,
    ShieldedInstanceIdentity,
    ShieldedInstanceIdentityEntry,
    ShieldedInstanceIntegrityPolicy,
    SignedUrlKey,
    SimulateMaintenanceEventInstanceRequest,
    Snapshot,
    SnapshotList,
    SourceInstanceParams,
    SslCertificate,
    SslCertificateAggregatedList,
    SslCertificateList,
    SslCertificateManagedSslCertificate,
    SslCertificateSelfManagedSslCertificate,
    SslCertificatesScopedList,
    SSLHealthCheck,
    SslPoliciesList,
    SslPoliciesListAvailableFeaturesResponse,
    SslPolicy,
    SslPolicyReference,
    StartInstanceRequest,
    StartWithEncryptionKeyInstanceRequest,
    StatefulPolicy,
    StatefulPolicyPreservedState,
    StatefulPolicyPreservedStateDiskDevice,
    StopInstanceRequest,
    Subnetwork,
    SubnetworkAggregatedList,
    SubnetworkList,
    SubnetworkLogConfig,
    SubnetworkSecondaryRange,
    SubnetworksExpandIpCidrRangeRequest,
    SubnetworksScopedList,
    SubnetworksSetPrivateIpGoogleAccessRequest,
    SwitchToCustomModeNetworkRequest,
    Tags,
    TargetGrpcProxy,
    TargetGrpcProxyList,
    TargetHttpProxiesScopedList,
    TargetHttpProxy,
    TargetHttpProxyAggregatedList,
    TargetHttpProxyList,
    TargetHttpsProxiesScopedList,
    TargetHttpsProxiesSetQuicOverrideRequest,
    TargetHttpsProxiesSetSslCertificatesRequest,
    TargetHttpsProxy,
    TargetHttpsProxyAggregatedList,
    TargetHttpsProxyList,
    TargetInstance,
    TargetInstanceAggregatedList,
    TargetInstanceList,
    TargetInstancesScopedList,
    TargetPool,
    TargetPoolAggregatedList,
    TargetPoolInstanceHealth,
    TargetPoolList,
    TargetPoolsAddHealthCheckRequest,
    TargetPoolsAddInstanceRequest,
    TargetPoolsRemoveHealthCheckRequest,
    TargetPoolsRemoveInstanceRequest,
    TargetPoolsScopedList,
    TargetReference,
    TargetSslProxiesSetBackendServiceRequest,
    TargetSslProxiesSetProxyHeaderRequest,
    TargetSslProxiesSetSslCertificatesRequest,
    TargetSslProxy,
    TargetSslProxyList,
    TargetTcpProxiesSetBackendServiceRequest,
    TargetTcpProxiesSetProxyHeaderRequest,
    TargetTcpProxy,
    TargetTcpProxyList,
    TargetVpnGateway,
    TargetVpnGatewayAggregatedList,
    TargetVpnGatewayList,
    TargetVpnGatewaysScopedList,
    TCPHealthCheck,
    TestFailure,
    TestIamPermissionsDiskRequest,
    TestIamPermissionsExternalVpnGatewayRequest,
    TestIamPermissionsImageRequest,
    TestIamPermissionsInstanceRequest,
    TestIamPermissionsInstanceTemplateRequest,
    TestIamPermissionsLicenseCodeRequest,
    TestIamPermissionsLicenseRequest,
    TestIamPermissionsNetworkEndpointGroupRequest,
    TestIamPermissionsNodeGroupRequest,
    TestIamPermissionsNodeTemplateRequest,
    TestIamPermissionsPacketMirroringRequest,
    TestIamPermissionsRegionDiskRequest,
    TestIamPermissionsReservationRequest,
    TestIamPermissionsResourcePolicyRequest,
    TestIamPermissionsSnapshotRequest,
    TestIamPermissionsSubnetworkRequest,
    TestIamPermissionsVpnGatewayRequest,
    TestPermissionsRequest,
    TestPermissionsResponse,
    UpdateAccessConfigInstanceRequest,
    UpdateAutoscalerRequest,
    UpdateBackendBucketRequest,
    UpdateBackendServiceRequest,
    UpdateDisplayDeviceInstanceRequest,
    UpdateFirewallRequest,
    UpdateHealthCheckRequest,
    UpdateInstanceRequest,
    UpdateNetworkInterfaceInstanceRequest,
    UpdatePeeringNetworkRequest,
    UpdatePerInstanceConfigsInstanceGroupManagerRequest,
    UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest,
    UpdateRegionAutoscalerRequest,
    UpdateRegionBackendServiceRequest,
    UpdateRegionHealthCheckRequest,
    UpdateRegionUrlMapRequest,
    UpdateRouterRequest,
    UpdateShieldedInstanceConfigInstanceRequest,
    UpdateUrlMapRequest,
    UrlMap,
    UrlMapList,
    UrlMapReference,
    UrlMapsAggregatedList,
    UrlMapsScopedList,
    UrlMapsValidateRequest,
    UrlMapsValidateResponse,
    UrlMapTest,
    UrlMapValidationResult,
    UrlRewrite,
    UsableSubnetwork,
    UsableSubnetworksAggregatedList,
    UsableSubnetworkSecondaryRange,
    UsageExportLocation,
    ValidateRegionUrlMapRequest,
    ValidateUrlMapRequest,
    VmEndpointNatMappings,
    VmEndpointNatMappingsInterfaceNatMappings,
    VmEndpointNatMappingsList,
    VpnGateway,
    VpnGatewayAggregatedList,
    VpnGatewayList,
    VpnGatewaysGetStatusResponse,
    VpnGatewaysScopedList,
    VpnGatewayStatus,
    VpnGatewayStatusHighAvailabilityRequirementState,
    VpnGatewayStatusTunnel,
    VpnGatewayStatusVpnConnection,
    VpnGatewayVpnGatewayInterface,
    VpnTunnel,
    VpnTunnelAggregatedList,
    VpnTunnelList,
    VpnTunnelsScopedList,
    WafExpressionSet,
    WafExpressionSetExpression,
    WaitGlobalOperationRequest,
    WaitRegionOperationRequest,
    WaitZoneOperationRequest,
    Warning,
    Warnings,
    WeightedBackendService,
    XpnHostList,
    XpnResourceId,
    Zone,
    ZoneList,
    ZoneSetLabelsRequest,
    ZoneSetPolicyRequest,
)

__all__ = (
    "AbandonInstancesInstanceGroupManagerRequest",
    "AbandonInstancesRegionInstanceGroupManagerRequest",
    "AcceleratorConfig",
    "Accelerators",
    "AcceleratorType",
    "AcceleratorTypeAggregatedList",
    "AcceleratorTypeList",
    "AcceleratorTypesScopedList",
    "AccessConfig",
    "AddAccessConfigInstanceRequest",
    "AddHealthCheckTargetPoolRequest",
    "AddInstancesInstanceGroupRequest",
    "AddInstanceTargetPoolRequest",
    "AddNodesNodeGroupRequest",
    "AddPeeringNetworkRequest",
    "AddResourcePoliciesDiskRequest",
    "AddResourcePoliciesInstanceRequest",
    "AddResourcePoliciesRegionDiskRequest",
    "Address",
    "AddressAggregatedList",
    "AddressesScopedList",
    "AddressList",
    "AddRuleSecurityPolicyRequest",
    "AddSignedUrlKeyBackendBucketRequest",
    "AddSignedUrlKeyBackendServiceRequest",
    "AggregatedListAcceleratorTypesRequest",
    "AggregatedListAddressesRequest",
    "AggregatedListAutoscalersRequest",
    "AggregatedListBackendServicesRequest",
    "AggregatedListDisksRequest",
    "AggregatedListDiskTypesRequest",
    "AggregatedListForwardingRulesRequest",
    "AggregatedListGlobalOperationsRequest",
    "AggregatedListHealthChecksRequest",
    "AggregatedListInstanceGroupManagersRequest",
    "AggregatedListInstanceGroupsRequest",
    "AggregatedListInstancesRequest",
    "AggregatedListInterconnectAttachmentsRequest",
    "AggregatedListMachineTypesRequest",
    "AggregatedListNetworkEndpointGroupsRequest",
    "AggregatedListNodeGroupsRequest",
    "AggregatedListNodeTemplatesRequest",
    "AggregatedListNodeTypesRequest",
    "AggregatedListPacketMirroringsRequest",
    "AggregatedListRegionCommitmentsRequest",
    "AggregatedListReservationsRequest",
    "AggregatedListResourcePoliciesRequest",
    "AggregatedListRoutersRequest",
    "AggregatedListSslCertificatesRequest",
    "AggregatedListSubnetworksRequest",
    "AggregatedListTargetHttpProxiesRequest",
    "AggregatedListTargetHttpsProxiesRequest",
    "AggregatedListTargetInstancesRequest",
    "AggregatedListTargetPoolsRequest",
    "AggregatedListTargetVpnGatewaysRequest",
    "AggregatedListUrlMapsRequest",
    "AggregatedListVpnGatewaysRequest",
    "AggregatedListVpnTunnelsRequest",
    "AliasIpRange",
    "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    "AllocationSpecificSKUAllocationReservedInstanceProperties",
    "AllocationSpecificSKUReservation",
    "Allowed",
    "ApplyUpdatesToInstancesInstanceGroupManagerRequest",
    "ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest",
    "AttachDiskInstanceRequest",
    "AttachedDisk",
    "AttachedDiskInitializeParams",
    "AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "AttachNetworkEndpointsNetworkEndpointGroupRequest",
    "AuditConfig",
    "AuditLogConfig",
    "AuthorizationLoggingOptions",
    "Autoscaler",
    "AutoscalerAggregatedList",
    "AutoscalerList",
    "AutoscalersScopedList",
    "AutoscalerStatusDetails",
    "AutoscalingPolicy",
    "AutoscalingPolicyCpuUtilization",
    "AutoscalingPolicyCustomMetricUtilization",
    "AutoscalingPolicyLoadBalancingUtilization",
    "AutoscalingPolicyScaleInControl",
    "Backend",
    "BackendBucket",
    "BackendBucketCdnPolicy",
    "BackendBucketList",
    "BackendService",
    "BackendServiceAggregatedList",
    "BackendServiceCdnPolicy",
    "BackendServiceFailoverPolicy",
    "BackendServiceGroupHealth",
    "BackendServiceIAP",
    "BackendServiceList",
    "BackendServiceLogConfig",
    "BackendServiceReference",
    "BackendServicesScopedList",
    "Binding",
    "CacheInvalidationRule",
    "CacheKeyPolicy",
    "CircuitBreakers",
    "Commitment",
    "CommitmentAggregatedList",
    "CommitmentList",
    "CommitmentsScopedList",
    "Condition",
    "ConfidentialInstanceConfig",
    "ConnectionDraining",
    "ConsistentHashLoadBalancerSettings",
    "ConsistentHashLoadBalancerSettingsHttpCookie",
    "CorsPolicy",
    "CreateInstancesInstanceGroupManagerRequest",
    "CreateInstancesRegionInstanceGroupManagerRequest",
    "CreateSnapshotDiskRequest",
    "CreateSnapshotRegionDiskRequest",
    "CustomerEncryptionKey",
    "CustomerEncryptionKeyProtectedDisk",
    "Data",
    "DeleteAccessConfigInstanceRequest",
    "DeleteAddressRequest",
    "DeleteAutoscalerRequest",
    "DeleteBackendBucketRequest",
    "DeleteBackendServiceRequest",
    "DeleteDiskRequest",
    "DeleteExternalVpnGatewayRequest",
    "DeleteFirewallRequest",
    "DeleteForwardingRuleRequest",
    "DeleteGlobalAddressRequest",
    "DeleteGlobalForwardingRuleRequest",
    "DeleteGlobalNetworkEndpointGroupRequest",
    "DeleteGlobalOperationRequest",
    "DeleteGlobalOperationResponse",
    "DeleteGlobalOrganizationOperationRequest",
    "DeleteGlobalOrganizationOperationResponse",
    "DeleteHealthCheckRequest",
    "DeleteImageRequest",
    "DeleteInstanceGroupManagerRequest",
    "DeleteInstanceGroupRequest",
    "DeleteInstanceRequest",
    "DeleteInstancesInstanceGroupManagerRequest",
    "DeleteInstancesRegionInstanceGroupManagerRequest",
    "DeleteInstanceTemplateRequest",
    "DeleteInterconnectAttachmentRequest",
    "DeleteInterconnectRequest",
    "DeleteLicenseRequest",
    "DeleteNetworkEndpointGroupRequest",
    "DeleteNetworkRequest",
    "DeleteNodeGroupRequest",
    "DeleteNodesNodeGroupRequest",
    "DeleteNodeTemplateRequest",
    "DeletePacketMirroringRequest",
    "DeletePerInstanceConfigsInstanceGroupManagerRequest",
    "DeletePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "DeleteRegionAutoscalerRequest",
    "DeleteRegionBackendServiceRequest",
    "DeleteRegionDiskRequest",
    "DeleteRegionHealthCheckRequest",
    "DeleteRegionHealthCheckServiceRequest",
    "DeleteRegionInstanceGroupManagerRequest",
    "DeleteRegionNetworkEndpointGroupRequest",
    "DeleteRegionNotificationEndpointRequest",
    "DeleteRegionOperationRequest",
    "DeleteRegionOperationResponse",
    "DeleteRegionSslCertificateRequest",
    "DeleteRegionTargetHttpProxyRequest",
    "DeleteRegionTargetHttpsProxyRequest",
    "DeleteRegionUrlMapRequest",
    "DeleteReservationRequest",
    "DeleteResourcePolicyRequest",
    "DeleteRouteRequest",
    "DeleteRouterRequest",
    "DeleteSecurityPolicyRequest",
    "DeleteSignedUrlKeyBackendBucketRequest",
    "DeleteSignedUrlKeyBackendServiceRequest",
    "DeleteSnapshotRequest",
    "DeleteSslCertificateRequest",
    "DeleteSslPolicyRequest",
    "DeleteSubnetworkRequest",
    "DeleteTargetGrpcProxyRequest",
    "DeleteTargetHttpProxyRequest",
    "DeleteTargetHttpsProxyRequest",
    "DeleteTargetInstanceRequest",
    "DeleteTargetPoolRequest",
    "DeleteTargetSslProxyRequest",
    "DeleteTargetTcpProxyRequest",
    "DeleteTargetVpnGatewayRequest",
    "DeleteUrlMapRequest",
    "DeleteVpnGatewayRequest",
    "DeleteVpnTunnelRequest",
    "DeleteZoneOperationRequest",
    "DeleteZoneOperationResponse",
    "Denied",
    "DeprecateImageRequest",
    "DeprecationStatus",
    "DetachDiskInstanceRequest",
    "DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "DetachNetworkEndpointsNetworkEndpointGroupRequest",
    "DisableXpnHostProjectRequest",
    "DisableXpnResourceProjectRequest",
    "Disk",
    "DiskAggregatedList",
    "DiskInstantiationConfig",
    "DiskList",
    "DiskMoveRequest",
    "DisksAddResourcePoliciesRequest",
    "DisksRemoveResourcePoliciesRequest",
    "DisksResizeRequest",
    "DisksScopedList",
    "DiskType",
    "DiskTypeAggregatedList",
    "DiskTypeList",
    "DiskTypesScopedList",
    "DisplayDevice",
    "DistributionPolicy",
    "DistributionPolicyZoneConfiguration",
    "Duration",
    "EnableXpnHostProjectRequest",
    "EnableXpnResourceProjectRequest",
    "Error",
    "Errors",
    "ExchangedPeeringRoute",
    "ExchangedPeeringRoutesList",
    "ExpandIpCidrRangeSubnetworkRequest",
    "Expr",
    "ExternalVpnGateway",
    "ExternalVpnGatewayInterface",
    "ExternalVpnGatewayList",
    "FileContentBuffer",
    "Firewall",
    "FirewallList",
    "FirewallLogConfig",
    "FixedOrPercent",
    "ForwardingRule",
    "ForwardingRuleAggregatedList",
    "ForwardingRuleList",
    "ForwardingRuleReference",
    "ForwardingRulesScopedList",
    "GetAcceleratorTypeRequest",
    "GetAddressRequest",
    "GetAutoscalerRequest",
    "GetBackendBucketRequest",
    "GetBackendServiceRequest",
    "GetDiagnosticsInterconnectRequest",
    "GetDiskRequest",
    "GetDiskTypeRequest",
    "GetExternalVpnGatewayRequest",
    "GetFirewallRequest",
    "GetForwardingRuleRequest",
    "GetFromFamilyImageRequest",
    "GetGlobalAddressRequest",
    "GetGlobalForwardingRuleRequest",
    "GetGlobalNetworkEndpointGroupRequest",
    "GetGlobalOperationRequest",
    "GetGlobalOrganizationOperationRequest",
    "GetGuestAttributesInstanceRequest",
    "GetHealthBackendServiceRequest",
    "GetHealthCheckRequest",
    "GetHealthRegionBackendServiceRequest",
    "GetHealthTargetPoolRequest",
    "GetIamPolicyDiskRequest",
    "GetIamPolicyImageRequest",
    "GetIamPolicyInstanceRequest",
    "GetIamPolicyInstanceTemplateRequest",
    "GetIamPolicyLicenseRequest",
    "GetIamPolicyNodeGroupRequest",
    "GetIamPolicyNodeTemplateRequest",
    "GetIamPolicyRegionDiskRequest",
    "GetIamPolicyReservationRequest",
    "GetIamPolicyResourcePolicyRequest",
    "GetIamPolicySnapshotRequest",
    "GetIamPolicySubnetworkRequest",
    "GetImageRequest",
    "GetInstanceGroupManagerRequest",
    "GetInstanceGroupRequest",
    "GetInstanceRequest",
    "GetInstanceTemplateRequest",
    "GetInterconnectAttachmentRequest",
    "GetInterconnectLocationRequest",
    "GetInterconnectRequest",
    "GetLicenseCodeRequest",
    "GetLicenseRequest",
    "GetMachineTypeRequest",
    "GetNatMappingInfoRoutersRequest",
    "GetNetworkEndpointGroupRequest",
    "GetNetworkRequest",
    "GetNodeGroupRequest",
    "GetNodeTemplateRequest",
    "GetNodeTypeRequest",
    "GetPacketMirroringRequest",
    "GetProjectRequest",
    "GetRegionAutoscalerRequest",
    "GetRegionBackendServiceRequest",
    "GetRegionCommitmentRequest",
    "GetRegionDiskRequest",
    "GetRegionDiskTypeRequest",
    "GetRegionHealthCheckRequest",
    "GetRegionHealthCheckServiceRequest",
    "GetRegionInstanceGroupManagerRequest",
    "GetRegionInstanceGroupRequest",
    "GetRegionNetworkEndpointGroupRequest",
    "GetRegionNotificationEndpointRequest",
    "GetRegionOperationRequest",
    "GetRegionRequest",
    "GetRegionSslCertificateRequest",
    "GetRegionTargetHttpProxyRequest",
    "GetRegionTargetHttpsProxyRequest",
    "GetRegionUrlMapRequest",
    "GetReservationRequest",
    "GetResourcePolicyRequest",
    "GetRouteRequest",
    "GetRouterRequest",
    "GetRouterStatusRouterRequest",
    "GetRuleSecurityPolicyRequest",
    "GetScreenshotInstanceRequest",
    "GetSecurityPolicyRequest",
    "GetSerialPortOutputInstanceRequest",
    "GetShieldedInstanceIdentityInstanceRequest",
    "GetSnapshotRequest",
    "GetSslCertificateRequest",
    "GetSslPolicyRequest",
    "GetStatusVpnGatewayRequest",
    "GetSubnetworkRequest",
    "GetTargetGrpcProxyRequest",
    "GetTargetHttpProxyRequest",
    "GetTargetHttpsProxyRequest",
    "GetTargetInstanceRequest",
    "GetTargetPoolRequest",
    "GetTargetSslProxyRequest",
    "GetTargetTcpProxyRequest",
    "GetTargetVpnGatewayRequest",
    "GetUrlMapRequest",
    "GetVpnGatewayRequest",
    "GetVpnTunnelRequest",
    "GetXpnHostProjectRequest",
    "GetXpnResourcesProjectsRequest",
    "GetZoneOperationRequest",
    "GetZoneRequest",
    "GlobalNetworkEndpointGroupsAttachEndpointsRequest",
    "GlobalNetworkEndpointGroupsDetachEndpointsRequest",
    "GlobalSetLabelsRequest",
    "GlobalSetPolicyRequest",
    "GRPCHealthCheck",
    "GuestAttributes",
    "GuestAttributesEntry",
    "GuestAttributesValue",
    "GuestOsFeature",
    "HealthCheck",
    "HealthCheckList",
    "HealthCheckLogConfig",
    "HealthCheckReference",
    "HealthChecksAggregatedList",
    "HealthCheckService",
    "HealthCheckServiceReference",
    "HealthCheckServicesList",
    "HealthChecksScopedList",
    "HealthStatus",
    "HealthStatusForNetworkEndpoint",
    "HostRule",
    "HTTP2HealthCheck",
    "HttpFaultAbort",
    "HttpFaultDelay",
    "HttpFaultInjection",
    "HttpHeaderAction",
    "HttpHeaderMatch",
    "HttpHeaderOption",
    "HTTPHealthCheck",
    "HttpQueryParameterMatch",
    "HttpRedirectAction",
    "HttpRetryPolicy",
    "HttpRouteAction",
    "HttpRouteRule",
    "HttpRouteRuleMatch",
    "HTTPSHealthCheck",
    "Image",
    "ImageList",
    "InitialStateConfig",
    "InsertAddressRequest",
    "InsertAutoscalerRequest",
    "InsertBackendBucketRequest",
    "InsertBackendServiceRequest",
    "InsertDiskRequest",
    "InsertExternalVpnGatewayRequest",
    "InsertFirewallRequest",
    "InsertForwardingRuleRequest",
    "InsertGlobalAddressRequest",
    "InsertGlobalForwardingRuleRequest",
    "InsertGlobalNetworkEndpointGroupRequest",
    "InsertHealthCheckRequest",
    "InsertImageRequest",
    "InsertInstanceGroupManagerRequest",
    "InsertInstanceGroupRequest",
    "InsertInstanceRequest",
    "InsertInstanceTemplateRequest",
    "InsertInterconnectAttachmentRequest",
    "InsertInterconnectRequest",
    "InsertLicenseRequest",
    "InsertNetworkEndpointGroupRequest",
    "InsertNetworkRequest",
    "InsertNodeGroupRequest",
    "InsertNodeTemplateRequest",
    "InsertPacketMirroringRequest",
    "InsertRegionAutoscalerRequest",
    "InsertRegionBackendServiceRequest",
    "InsertRegionCommitmentRequest",
    "InsertRegionDiskRequest",
    "InsertRegionHealthCheckRequest",
    "InsertRegionHealthCheckServiceRequest",
    "InsertRegionInstanceGroupManagerRequest",
    "InsertRegionNetworkEndpointGroupRequest",
    "InsertRegionNotificationEndpointRequest",
    "InsertRegionSslCertificateRequest",
    "InsertRegionTargetHttpProxyRequest",
    "InsertRegionTargetHttpsProxyRequest",
    "InsertRegionUrlMapRequest",
    "InsertReservationRequest",
    "InsertResourcePolicyRequest",
    "InsertRouteRequest",
    "InsertRouterRequest",
    "InsertSecurityPolicyRequest",
    "InsertSslCertificateRequest",
    "InsertSslPolicyRequest",
    "InsertSubnetworkRequest",
    "InsertTargetGrpcProxyRequest",
    "InsertTargetHttpProxyRequest",
    "InsertTargetHttpsProxyRequest",
    "InsertTargetInstanceRequest",
    "InsertTargetPoolRequest",
    "InsertTargetSslProxyRequest",
    "InsertTargetTcpProxyRequest",
    "InsertTargetVpnGatewayRequest",
    "InsertUrlMapRequest",
    "InsertVpnGatewayRequest",
    "InsertVpnTunnelRequest",
    "Instance",
    "InstanceAggregatedList",
    "InstanceGroup",
    "InstanceGroupAggregatedList",
    "InstanceGroupList",
    "InstanceGroupManager",
    "InstanceGroupManagerActionsSummary",
    "InstanceGroupManagerAggregatedList",
    "InstanceGroupManagerAutoHealingPolicy",
    "InstanceGroupManagerList",
    "InstanceGroupManagersAbandonInstancesRequest",
    "InstanceGroupManagersApplyUpdatesRequest",
    "InstanceGroupManagersCreateInstancesRequest",
    "InstanceGroupManagersDeleteInstancesRequest",
    "InstanceGroupManagersDeletePerInstanceConfigsReq",
    "InstanceGroupManagersListErrorsResponse",
    "InstanceGroupManagersListManagedInstancesResponse",
    "InstanceGroupManagersListPerInstanceConfigsResp",
    "InstanceGroupManagersPatchPerInstanceConfigsReq",
    "InstanceGroupManagersRecreateInstancesRequest",
    "InstanceGroupManagersScopedList",
    "InstanceGroupManagersSetInstanceTemplateRequest",
    "InstanceGroupManagersSetTargetPoolsRequest",
    "InstanceGroupManagerStatus",
    "InstanceGroupManagerStatusStateful",
    "InstanceGroupManagerStatusStatefulPerInstanceConfigs",
    "InstanceGroupManagerStatusVersionTarget",
    "InstanceGroupManagersUpdatePerInstanceConfigsReq",
    "InstanceGroupManagerUpdatePolicy",
    "InstanceGroupManagerVersion",
    "InstanceGroupsAddInstancesRequest",
    "InstanceGroupsListInstances",
    "InstanceGroupsListInstancesRequest",
    "InstanceGroupsRemoveInstancesRequest",
    "InstanceGroupsScopedList",
    "InstanceGroupsSetNamedPortsRequest",
    "InstanceList",
    "InstanceListReferrers",
    "InstanceManagedByIgmError",
    "InstanceManagedByIgmErrorInstanceActionDetails",
    "InstanceManagedByIgmErrorManagedInstanceError",
    "InstanceMoveRequest",
    "InstanceProperties",
    "InstanceReference",
    "InstancesAddResourcePoliciesRequest",
    "InstancesRemoveResourcePoliciesRequest",
    "InstancesScopedList",
    "InstancesSetLabelsRequest",
    "InstancesSetMachineResourcesRequest",
    "InstancesSetMachineTypeRequest",
    "InstancesSetMinCpuPlatformRequest",
    "InstancesSetServiceAccountRequest",
    "InstancesStartWithEncryptionKeyRequest",
    "InstanceTemplate",
    "InstanceTemplateList",
    "InstanceWithNamedPorts",
    "Int64RangeMatch",
    "Interconnect",
    "InterconnectAttachment",
    "InterconnectAttachmentAggregatedList",
    "InterconnectAttachmentList",
    "InterconnectAttachmentPartnerMetadata",
    "InterconnectAttachmentPrivateInfo",
    "InterconnectAttachmentsScopedList",
    "InterconnectCircuitInfo",
    "InterconnectDiagnostics",
    "InterconnectDiagnosticsARPEntry",
    "InterconnectDiagnosticsLinkLACPStatus",
    "InterconnectDiagnosticsLinkOpticalPower",
    "InterconnectDiagnosticsLinkStatus",
    "InterconnectList",
    "InterconnectLocation",
    "InterconnectLocationList",
    "InterconnectLocationRegionInfo",
    "InterconnectOutageNotification",
    "InterconnectsGetDiagnosticsResponse",
    "InvalidateCacheUrlMapRequest",
    "Items",
    "License",
    "LicenseCode",
    "LicenseCodeLicenseAlias",
    "LicenseResourceCommitment",
    "LicenseResourceRequirements",
    "LicensesListResponse",
    "ListAcceleratorTypesRequest",
    "ListAddressesRequest",
    "ListAutoscalersRequest",
    "ListAvailableFeaturesSslPoliciesRequest",
    "ListBackendBucketsRequest",
    "ListBackendServicesRequest",
    "ListDisksRequest",
    "ListDiskTypesRequest",
    "ListErrorsInstanceGroupManagersRequest",
    "ListErrorsRegionInstanceGroupManagersRequest",
    "ListExternalVpnGatewaysRequest",
    "ListFirewallsRequest",
    "ListForwardingRulesRequest",
    "ListGlobalAddressesRequest",
    "ListGlobalForwardingRulesRequest",
    "ListGlobalNetworkEndpointGroupsRequest",
    "ListGlobalOperationsRequest",
    "ListGlobalOrganizationOperationsRequest",
    "ListHealthChecksRequest",
    "ListImagesRequest",
    "ListInstanceGroupManagersRequest",
    "ListInstanceGroupsRequest",
    "ListInstancesInstanceGroupsRequest",
    "ListInstancesRegionInstanceGroupsRequest",
    "ListInstancesRequest",
    "ListInstanceTemplatesRequest",
    "ListInterconnectAttachmentsRequest",
    "ListInterconnectLocationsRequest",
    "ListInterconnectsRequest",
    "ListLicensesRequest",
    "ListMachineTypesRequest",
    "ListManagedInstancesInstanceGroupManagersRequest",
    "ListManagedInstancesRegionInstanceGroupManagersRequest",
    "ListNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsNetworkEndpointGroupsRequest",
    "ListNetworksRequest",
    "ListNodeGroupsRequest",
    "ListNodesNodeGroupsRequest",
    "ListNodeTemplatesRequest",
    "ListNodeTypesRequest",
    "ListPacketMirroringsRequest",
    "ListPeeringRoutesNetworksRequest",
    "ListPerInstanceConfigsInstanceGroupManagersRequest",
    "ListPerInstanceConfigsRegionInstanceGroupManagersRequest",
    "ListPreconfiguredExpressionSetsSecurityPoliciesRequest",
    "ListReferrersInstancesRequest",
    "ListRegionAutoscalersRequest",
    "ListRegionBackendServicesRequest",
    "ListRegionCommitmentsRequest",
    "ListRegionDisksRequest",
    "ListRegionDiskTypesRequest",
    "ListRegionHealthCheckServicesRequest",
    "ListRegionHealthChecksRequest",
    "ListRegionInstanceGroupManagersRequest",
    "ListRegionInstanceGroupsRequest",
    "ListRegionNetworkEndpointGroupsRequest",
    "ListRegionNotificationEndpointsRequest",
    "ListRegionOperationsRequest",
    "ListRegionsRequest",
    "ListRegionSslCertificatesRequest",
    "ListRegionTargetHttpProxiesRequest",
    "ListRegionTargetHttpsProxiesRequest",
    "ListRegionUrlMapsRequest",
    "ListReservationsRequest",
    "ListResourcePoliciesRequest",
    "ListRoutersRequest",
    "ListRoutesRequest",
    "ListSecurityPoliciesRequest",
    "ListSnapshotsRequest",
    "ListSslCertificatesRequest",
    "ListSslPoliciesRequest",
    "ListSubnetworksRequest",
    "ListTargetGrpcProxiesRequest",
    "ListTargetHttpProxiesRequest",
    "ListTargetHttpsProxiesRequest",
    "ListTargetInstancesRequest",
    "ListTargetPoolsRequest",
    "ListTargetSslProxiesRequest",
    "ListTargetTcpProxiesRequest",
    "ListTargetVpnGatewaysRequest",
    "ListUrlMapsRequest",
    "ListUsableSubnetworksRequest",
    "ListVpnGatewaysRequest",
    "ListVpnTunnelsRequest",
    "ListXpnHostsProjectsRequest",
    "ListZoneOperationsRequest",
    "ListZonesRequest",
    "LocalDisk",
    "LogConfig",
    "LogConfigCloudAuditOptions",
    "LogConfigCounterOptions",
    "LogConfigCounterOptionsCustomField",
    "LogConfigDataAccessOptions",
    "MachineType",
    "MachineTypeAggregatedList",
    "MachineTypeList",
    "MachineTypesScopedList",
    "ManagedInstance",
    "ManagedInstanceInstanceHealth",
    "ManagedInstanceLastAttempt",
    "ManagedInstanceVersion",
    "Metadata",
    "MetadataFilter",
    "MetadataFilterLabelMatch",
    "MoveDiskProjectRequest",
    "MoveInstanceProjectRequest",
    "NamedPort",
    "Network",
    "NetworkEndpoint",
    "NetworkEndpointGroup",
    "NetworkEndpointGroupAggregatedList",
    "NetworkEndpointGroupAppEngine",
    "NetworkEndpointGroupCloudFunction",
    "NetworkEndpointGroupCloudRun",
    "NetworkEndpointGroupList",
    "NetworkEndpointGroupsAttachEndpointsRequest",
    "NetworkEndpointGroupsDetachEndpointsRequest",
    "NetworkEndpointGroupsListEndpointsRequest",
    "NetworkEndpointGroupsListNetworkEndpoints",
    "NetworkEndpointGroupsScopedList",
    "NetworkEndpointWithHealthStatus",
    "NetworkInterface",
    "NetworkList",
    "NetworkPeering",
    "NetworkRoutingConfig",
    "NetworksAddPeeringRequest",
    "NetworksRemovePeeringRequest",
    "NetworksUpdatePeeringRequest",
    "NodeGroup",
    "NodeGroupAggregatedList",
    "NodeGroupAutoscalingPolicy",
    "NodeGroupList",
    "NodeGroupMaintenanceWindow",
    "NodeGroupNode",
    "NodeGroupsAddNodesRequest",
    "NodeGroupsDeleteNodesRequest",
    "NodeGroupsListNodes",
    "NodeGroupsScopedList",
    "NodeGroupsSetNodeTemplateRequest",
    "NodeTemplate",
    "NodeTemplateAggregatedList",
    "NodeTemplateList",
    "NodeTemplateNodeTypeFlexibility",
    "NodeTemplatesScopedList",
    "NodeType",
    "NodeTypeAggregatedList",
    "NodeTypeList",
    "NodeTypesScopedList",
    "NotificationEndpoint",
    "NotificationEndpointGrpcSettings",
    "NotificationEndpointList",
    "Operation",
    "OperationAggregatedList",
    "OperationList",
    "OperationsScopedList",
    "OutlierDetection",
    "PacketMirroring",
    "PacketMirroringAggregatedList",
    "PacketMirroringFilter",
    "PacketMirroringForwardingRuleInfo",
    "PacketMirroringList",
    "PacketMirroringMirroredResourceInfo",
    "PacketMirroringMirroredResourceInfoInstanceInfo",
    "PacketMirroringMirroredResourceInfoSubnetInfo",
    "PacketMirroringNetworkInfo",
    "PacketMirroringsScopedList",
    "PatchAutoscalerRequest",
    "PatchBackendBucketRequest",
    "PatchBackendServiceRequest",
    "PatchFirewallRequest",
    "PatchForwardingRuleRequest",
    "PatchGlobalForwardingRuleRequest",
    "PatchHealthCheckRequest",
    "PatchImageRequest",
    "PatchInstanceGroupManagerRequest",
    "PatchInterconnectAttachmentRequest",
    "PatchInterconnectRequest",
    "PatchNetworkRequest",
    "PatchNodeGroupRequest",
    "PatchPacketMirroringRequest",
    "PatchPerInstanceConfigsInstanceGroupManagerRequest",
    "PatchPerInstanceConfigsRegionInstanceGroupManagerRequest",
    "PatchRegionAutoscalerRequest",
    "PatchRegionBackendServiceRequest",
    "PatchRegionHealthCheckRequest",
    "PatchRegionHealthCheckServiceRequest",
    "PatchRegionInstanceGroupManagerRequest",
    "PatchRegionUrlMapRequest",
    "PatchRouterRequest",
    "PatchRuleSecurityPolicyRequest",
    "PatchSecurityPolicyRequest",
    "PatchSslPolicyRequest",
    "PatchSubnetworkRequest",
    "PatchTargetGrpcProxyRequest",
    "PatchTargetHttpProxyRequest",
    "PatchUrlMapRequest",
    "PathMatcher",
    "PathRule",
    "PerInstanceConfig",
    "Policy",
    "PreconfiguredWafSet",
    "PreservedState",
    "PreservedStatePreservedDisk",
    "PreviewRouterRequest",
    "Project",
    "ProjectsDisableXpnResourceRequest",
    "ProjectsEnableXpnResourceRequest",
    "ProjectsGetXpnResources",
    "ProjectsListXpnHostsRequest",
    "ProjectsSetDefaultNetworkTierRequest",
    "Quota",
    "RawDisk",
    "RecreateInstancesInstanceGroupManagerRequest",
    "RecreateInstancesRegionInstanceGroupManagerRequest",
    "Reference",
    "Region",
    "RegionAutoscalerList",
    "RegionDisksAddResourcePoliciesRequest",
    "RegionDisksRemoveResourcePoliciesRequest",
    "RegionDisksResizeRequest",
    "RegionDiskTypeList",
    "RegionInstanceGroupList",
    "RegionInstanceGroupManagerDeleteInstanceConfigReq",
    "RegionInstanceGroupManagerList",
    "RegionInstanceGroupManagerPatchInstanceConfigReq",
    "RegionInstanceGroupManagersAbandonInstancesRequest",
    "RegionInstanceGroupManagersApplyUpdatesRequest",
    "RegionInstanceGroupManagersCreateInstancesRequest",
    "RegionInstanceGroupManagersDeleteInstancesRequest",
    "RegionInstanceGroupManagersListErrorsResponse",
    "RegionInstanceGroupManagersListInstanceConfigsResp",
    "RegionInstanceGroupManagersListInstancesResponse",
    "RegionInstanceGroupManagersRecreateRequest",
    "RegionInstanceGroupManagersSetTargetPoolsRequest",
    "RegionInstanceGroupManagersSetTemplateRequest",
    "RegionInstanceGroupManagerUpdateInstanceConfigReq",
    "RegionInstanceGroupsListInstances",
    "RegionInstanceGroupsListInstancesRequest",
    "RegionInstanceGroupsSetNamedPortsRequest",
    "RegionList",
    "RegionSetLabelsRequest",
    "RegionSetPolicyRequest",
    "RegionTargetHttpsProxiesSetSslCertificatesRequest",
    "RegionUrlMapsValidateRequest",
    "RemoveHealthCheckTargetPoolRequest",
    "RemoveInstancesInstanceGroupRequest",
    "RemoveInstanceTargetPoolRequest",
    "RemovePeeringNetworkRequest",
    "RemoveResourcePoliciesDiskRequest",
    "RemoveResourcePoliciesInstanceRequest",
    "RemoveResourcePoliciesRegionDiskRequest",
    "RemoveRuleSecurityPolicyRequest",
    "RequestMirrorPolicy",
    "Reservation",
    "ReservationAffinity",
    "ReservationAggregatedList",
    "ReservationList",
    "ReservationsResizeRequest",
    "ReservationsScopedList",
    "ResetInstanceRequest",
    "ResizeDiskRequest",
    "ResizeInstanceGroupManagerRequest",
    "ResizeRegionDiskRequest",
    "ResizeRegionInstanceGroupManagerRequest",
    "ResizeReservationRequest",
    "ResourceCommitment",
    "ResourceGroupReference",
    "ResourcePoliciesScopedList",
    "ResourcePolicy",
    "ResourcePolicyAggregatedList",
    "ResourcePolicyDailyCycle",
    "ResourcePolicyGroupPlacementPolicy",
    "ResourcePolicyHourlyCycle",
    "ResourcePolicyList",
    "ResourcePolicySnapshotSchedulePolicy",
    "ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
    "ResourcePolicySnapshotSchedulePolicySchedule",
    "ResourcePolicySnapshotSchedulePolicySnapshotProperties",
    "ResourcePolicyWeeklyCycle",
    "ResourcePolicyWeeklyCycleDayOfWeek",
    "Route",
    "RouteList",
    "Router",
    "RouterAdvertisedIpRange",
    "RouterAggregatedList",
    "RouterBgp",
    "RouterBgpPeer",
    "RouterInterface",
    "RouterList",
    "RouterNat",
    "RouterNatLogConfig",
    "RouterNatSubnetworkToNat",
    "RoutersPreviewResponse",
    "RoutersScopedList",
    "RouterStatus",
    "RouterStatusBgpPeerStatus",
    "RouterStatusNatStatus",
    "RouterStatusResponse",
    "Rule",
    "Scheduling",
    "SchedulingNodeAffinity",
    "ScratchDisks",
    "Screenshot",
    "SecurityPoliciesListPreconfiguredExpressionSetsResponse",
    "SecurityPoliciesWafConfig",
    "SecurityPolicy",
    "SecurityPolicyList",
    "SecurityPolicyReference",
    "SecurityPolicyRule",
    "SecurityPolicyRuleMatcher",
    "SecurityPolicyRuleMatcherConfig",
    "SecuritySettings",
    "SerialPortOutput",
    "ServerBinding",
    "ServiceAccount",
    "SetBackendServiceTargetSslProxyRequest",
    "SetBackendServiceTargetTcpProxyRequest",
    "SetBackupTargetPoolRequest",
    "SetCommonInstanceMetadataProjectRequest",
    "SetDefaultNetworkTierProjectRequest",
    "SetDeletionProtectionInstanceRequest",
    "SetDiskAutoDeleteInstanceRequest",
    "SetIamPolicyDiskRequest",
    "SetIamPolicyImageRequest",
    "SetIamPolicyInstanceRequest",
    "SetIamPolicyInstanceTemplateRequest",
    "SetIamPolicyLicenseRequest",
    "SetIamPolicyNodeGroupRequest",
    "SetIamPolicyNodeTemplateRequest",
    "SetIamPolicyRegionDiskRequest",
    "SetIamPolicyReservationRequest",
    "SetIamPolicyResourcePolicyRequest",
    "SetIamPolicySnapshotRequest",
    "SetIamPolicySubnetworkRequest",
    "SetInstanceTemplateInstanceGroupManagerRequest",
    "SetInstanceTemplateRegionInstanceGroupManagerRequest",
    "SetLabelsDiskRequest",
    "SetLabelsExternalVpnGatewayRequest",
    "SetLabelsImageRequest",
    "SetLabelsInstanceRequest",
    "SetLabelsRegionDiskRequest",
    "SetLabelsSnapshotRequest",
    "SetLabelsVpnGatewayRequest",
    "SetMachineResourcesInstanceRequest",
    "SetMachineTypeInstanceRequest",
    "SetMetadataInstanceRequest",
    "SetMinCpuPlatformInstanceRequest",
    "SetNamedPortsInstanceGroupRequest",
    "SetNamedPortsRegionInstanceGroupRequest",
    "SetNodeTemplateNodeGroupRequest",
    "SetPrivateIpGoogleAccessSubnetworkRequest",
    "SetProxyHeaderTargetSslProxyRequest",
    "SetProxyHeaderTargetTcpProxyRequest",
    "SetQuicOverrideTargetHttpsProxyRequest",
    "SetSchedulingInstanceRequest",
    "SetSecurityPolicyBackendServiceRequest",
    "SetServiceAccountInstanceRequest",
    "SetShieldedInstanceIntegrityPolicyInstanceRequest",
    "SetSslCertificatesRegionTargetHttpsProxyRequest",
    "SetSslCertificatesTargetHttpsProxyRequest",
    "SetSslCertificatesTargetSslProxyRequest",
    "SetSslPolicyTargetHttpsProxyRequest",
    "SetSslPolicyTargetSslProxyRequest",
    "SetTagsInstanceRequest",
    "SetTargetForwardingRuleRequest",
    "SetTargetGlobalForwardingRuleRequest",
    "SetTargetPoolsInstanceGroupManagerRequest",
    "SetTargetPoolsRegionInstanceGroupManagerRequest",
    "SetUrlMapRegionTargetHttpProxyRequest",
    "SetUrlMapRegionTargetHttpsProxyRequest",
    "SetUrlMapTargetHttpProxyRequest",
    "SetUrlMapTargetHttpsProxyRequest",
    "SetUsageExportBucketProjectRequest",
    "ShieldedInstanceConfig",
    "ShieldedInstanceIdentity",
    "ShieldedInstanceIdentityEntry",
    "ShieldedInstanceIntegrityPolicy",
    "SignedUrlKey",
    "SimulateMaintenanceEventInstanceRequest",
    "Snapshot",
    "SnapshotList",
    "SourceInstanceParams",
    "SslCertificate",
    "SslCertificateAggregatedList",
    "SslCertificateList",
    "SslCertificateManagedSslCertificate",
    "SslCertificateSelfManagedSslCertificate",
    "SslCertificatesScopedList",
    "SSLHealthCheck",
    "SslPoliciesList",
    "SslPoliciesListAvailableFeaturesResponse",
    "SslPolicy",
    "SslPolicyReference",
    "StartInstanceRequest",
    "StartWithEncryptionKeyInstanceRequest",
    "StatefulPolicy",
    "StatefulPolicyPreservedState",
    "StatefulPolicyPreservedStateDiskDevice",
    "StopInstanceRequest",
    "Subnetwork",
    "SubnetworkAggregatedList",
    "SubnetworkList",
    "SubnetworkLogConfig",
    "SubnetworkSecondaryRange",
    "SubnetworksExpandIpCidrRangeRequest",
    "SubnetworksScopedList",
    "SubnetworksSetPrivateIpGoogleAccessRequest",
    "SwitchToCustomModeNetworkRequest",
    "Tags",
    "TargetGrpcProxy",
    "TargetGrpcProxyList",
    "TargetHttpProxiesScopedList",
    "TargetHttpProxy",
    "TargetHttpProxyAggregatedList",
    "TargetHttpProxyList",
    "TargetHttpsProxiesScopedList",
    "TargetHttpsProxiesSetQuicOverrideRequest",
    "TargetHttpsProxiesSetSslCertificatesRequest",
    "TargetHttpsProxy",
    "TargetHttpsProxyAggregatedList",
    "TargetHttpsProxyList",
    "TargetInstance",
    "TargetInstanceAggregatedList",
    "TargetInstanceList",
    "TargetInstancesScopedList",
    "TargetPool",
    "TargetPoolAggregatedList",
    "TargetPoolInstanceHealth",
    "TargetPoolList",
    "TargetPoolsAddHealthCheckRequest",
    "TargetPoolsAddInstanceRequest",
    "TargetPoolsRemoveHealthCheckRequest",
    "TargetPoolsRemoveInstanceRequest",
    "TargetPoolsScopedList",
    "TargetReference",
    "TargetSslProxiesSetBackendServiceRequest",
    "TargetSslProxiesSetProxyHeaderRequest",
    "TargetSslProxiesSetSslCertificatesRequest",
    "TargetSslProxy",
    "TargetSslProxyList",
    "TargetTcpProxiesSetBackendServiceRequest",
    "TargetTcpProxiesSetProxyHeaderRequest",
    "TargetTcpProxy",
    "TargetTcpProxyList",
    "TargetVpnGateway",
    "TargetVpnGatewayAggregatedList",
    "TargetVpnGatewayList",
    "TargetVpnGatewaysScopedList",
    "TCPHealthCheck",
    "TestFailure",
    "TestIamPermissionsDiskRequest",
    "TestIamPermissionsExternalVpnGatewayRequest",
    "TestIamPermissionsImageRequest",
    "TestIamPermissionsInstanceRequest",
    "TestIamPermissionsInstanceTemplateRequest",
    "TestIamPermissionsLicenseCodeRequest",
    "TestIamPermissionsLicenseRequest",
    "TestIamPermissionsNetworkEndpointGroupRequest",
    "TestIamPermissionsNodeGroupRequest",
    "TestIamPermissionsNodeTemplateRequest",
    "TestIamPermissionsPacketMirroringRequest",
    "TestIamPermissionsRegionDiskRequest",
    "TestIamPermissionsReservationRequest",
    "TestIamPermissionsResourcePolicyRequest",
    "TestIamPermissionsSnapshotRequest",
    "TestIamPermissionsSubnetworkRequest",
    "TestIamPermissionsVpnGatewayRequest",
    "TestPermissionsRequest",
    "TestPermissionsResponse",
    "UpdateAccessConfigInstanceRequest",
    "UpdateAutoscalerRequest",
    "UpdateBackendBucketRequest",
    "UpdateBackendServiceRequest",
    "UpdateDisplayDeviceInstanceRequest",
    "UpdateFirewallRequest",
    "UpdateHealthCheckRequest",
    "UpdateInstanceRequest",
    "UpdateNetworkInterfaceInstanceRequest",
    "UpdatePeeringNetworkRequest",
    "UpdatePerInstanceConfigsInstanceGroupManagerRequest",
    "UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "UpdateRegionAutoscalerRequest",
    "UpdateRegionBackendServiceRequest",
    "UpdateRegionHealthCheckRequest",
    "UpdateRegionUrlMapRequest",
    "UpdateRouterRequest",
    "UpdateShieldedInstanceConfigInstanceRequest",
    "UpdateUrlMapRequest",
    "UrlMap",
    "UrlMapList",
    "UrlMapReference",
    "UrlMapsAggregatedList",
    "UrlMapsScopedList",
    "UrlMapsValidateRequest",
    "UrlMapsValidateResponse",
    "UrlMapTest",
    "UrlMapValidationResult",
    "UrlRewrite",
    "UsableSubnetwork",
    "UsableSubnetworksAggregatedList",
    "UsableSubnetworkSecondaryRange",
    "UsageExportLocation",
    "ValidateRegionUrlMapRequest",
    "ValidateUrlMapRequest",
    "VmEndpointNatMappings",
    "VmEndpointNatMappingsInterfaceNatMappings",
    "VmEndpointNatMappingsList",
    "VpnGateway",
    "VpnGatewayAggregatedList",
    "VpnGatewayList",
    "VpnGatewaysGetStatusResponse",
    "VpnGatewaysScopedList",
    "VpnGatewayStatus",
    "VpnGatewayStatusHighAvailabilityRequirementState",
    "VpnGatewayStatusTunnel",
    "VpnGatewayStatusVpnConnection",
    "VpnGatewayVpnGatewayInterface",
    "VpnTunnel",
    "VpnTunnelAggregatedList",
    "VpnTunnelList",
    "VpnTunnelsScopedList",
    "WafExpressionSet",
    "WafExpressionSetExpression",
    "WaitGlobalOperationRequest",
    "WaitRegionOperationRequest",
    "WaitZoneOperationRequest",
    "Warning",
    "Warnings",
    "WeightedBackendService",
    "XpnHostList",
    "XpnResourceId",
    "Zone",
    "ZoneList",
    "ZoneSetLabelsRequest",
    "ZoneSetPolicyRequest",
)
