# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['net_promoter_score', 'net_promoter_score.migrations']

package_data = \
{'': ['*']}

install_requires = \
['django>=2.2,<5.0']

setup_kwargs = {
    'name': 'django-nps',
    'version': '0.7.2',
    'description': 'Django app supporting Net Promoter Score (NPS) surveys.',
    'long_description': '.. image:: https://badge.fury.io/py/django-nps.svg\n    :target: https://badge.fury.io/py/django-nps\n\n.. image:: https://travis-ci.org/yunojuno/django-nps.svg?branch=master\n    :target: https://travis-ci.org/yunojuno/django-nps\n\n**This package now support Python 3.7+ and Django 2.2+ and above only.**\n\nFor legacay versions please refer to the relevant tag / branch.\n\nDjango NPS\n==========\n\n**Django app supporting Net Promoter Score (NPS) surveys**\n\nBackground - Net Promoter Score\n-------------------------------\n\nThe NPS is a measure of customer loyalty that is captured by asking your\ncustomers a singe question:\n\n::\n\n    How likely is it that you would recommend our [company|product|service] to a friend or colleague?"\n\nThe answer to this question is a number from 0-10 (inclusive). These scores\nare then broken out into three distinct groups: \'detractors\' (0-6), \'neutral\'\n(7-8) and \'promoters\' (9-10). The NPS is then the difference between the\nnumber of promoters and detractors (as a percentage of the whole population).\n\nFor example, if you ask 100 people, and you get the following results:\n\n.. code::\n\n    detractors: 20%\n    neutrals:   10%\n    promoters:  70%\n\nThen your NPS is 70 - 20 = 50. *(NPS is expressed as a number, not a %)*\n\nNPS was orginally developed at the strategy consultants Bain & Company by Fred Reichheld in 2003.\nThey retain the registered trademark for NPS, and you can read all about the history of it on\ntheir site "`Net Promoter System <http://netpromotersystem.com/about/index.aspx>`_".\n\nUsage\n-----\n\nThis app is used to store the individual scores, and calculate the NPS based\non these. It does not contain any templates for displaying the question itself,\nneither does it put any restriction around how often you ask the question, or\nto whom. It is up to the app developer to determine how this should work -\neach score is timestamped and linked to a Django User object, so you can\neasily work out the time elapsed since the last time they were asked.\n\nFor example, if you want to ensure that you only survey users every X days,\nyou can add a context property to the template using the ``display_to_user``\nmethod:\n\n.. code:: python\n\n    >>> # only show the survey every 90 days\n    >>> UserScore.objects.days_since_user_score(request.user) > 90\n    True\n\nIf you then show the survey - the output of which is a single value (the score)\ntogether with an optional reason ("what is the main reason for your score"), is\nthen posted to the ``post_score`` endpoint, which registers the user score.\n\nThe NPS value itself can be calculated on any queryset of ``UserScore`` objects -\nwhich allows you to track the score based on any attribute of the score itself\nor the underlying user. For instance, if you have custom user profiles, you\nmay wish to segement your NPS by characteristics of those profiles.\n\n.. code:: python\n\n    >>> # December\'s NPS\n    >>> UserScore.objects.filter(timestamp__month=12).net_promoter_score()\n    50\n\nThe ``post_score`` endpoint returns a ``JsonResponse`` which contains a ``\'success\': True|False``\nvalue together with the `UserScore` details:\n\n.. code:: python\n\n    {\n      "success": True,\n      "score": {"id": 1, "user": 1, "score": 0, "group": "detractor"}\n    }\n\nIf the score was rejected, the errors are returned in place of the score (errors\nare a list of lists, as returned from the Django `Form.errors` property:\n\n.. code:: python\n\n    {\n      "success": False,\n      "errors": [["score", "Score must be between 0-10"]]\n    }\n\nThe app contains a piece of middleware, ``NPSMiddleware``, which will add an\nattribute to the ``HttpRequest`` object called ``show_nps``. If you add the\nmiddleware to your settings:\n\n.. code:: python\n\n    # settings.py\n    MIDDLEWARE_CLASSES = (\n        # standard django middleware\n        \'django.middleware.common.CommonMiddleware\',\n        \'django.contrib.sessions.middleware.SessionMiddleware\',\n        \'django.contrib.auth.middleware.AuthenticationMiddleware\',\n        ...\n        \'net_promoter_score.NPSMiddleware\',\n    )\n\nYou can then use this value in your templates:\n\n.. code:: html\n\n    <!-- show_nps template = {{request.show_nps}} -->\n    {% if request.show_nps %}\n        <div>HTML goes here</div>\n    {% endif %}\n\nSettings\n--------\n\n**NPS_DISPLAY_INTERVAL**\n\nThe number of days between surveys, integer, defaults to 30. This value is\nused by the default ``show_nps`` function to determine whether someone should\nbe shown the survey.\n\n**NPS_DISPLAY_FUNCTION**\n\nA function that takes an ``HttpRequest`` object as its only argument, and\nwhich returns True if you want to show the survey. This function is used\nby the ``net_promoter_score.show_nps`` function. It defaults to return True\nif the request user has either never seen the survey, or hasn\'t seen it\nfor more days than the ``NPS_DISPLAY_INTERVAL``.\n\nThis function should be overridden if you want fine-grained control over\nthe process - it\'s the main hook into the app.\n\nTests\n-----\n\nThere is a full suite of tests for the app, which are best run through `tox`. If\nyou wish to run the tests outside of tox, you should install the requirements first:\n\n.. code:: shell\n\n    $ pip install -r requirements.txt\n    $ python manage.py test\n\nLicence\n-------\n\nMIT\n\nContributing\n------------\n\nUsual rules apply:\n\n1. Fork to your own account\n2. Create a branch, fix the issue / add the feature\n3. Submit PR\n\nPlease take care to follow the coding style - and PEP8.\n\nAcknowledgements\n----------------\n\nCredit is due to **epantry** for the `original project <https://github.com/epantry/django-netpromoterscore>`_ from which this was forked.\n\nThanks also to the kind people at **Eldarion** (`website  <http://eldarion.com/>`_) for releasing the PyPI package name.\n',
    'author': 'YunoJuno',
    'author_email': 'code@yunojuno.com',
    'maintainer': 'YunoJuno',
    'maintainer_email': 'code@yunojuno.com',
    'url': 'https://github.com/yunojuno/django-nps',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
