/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public class PreciseDurationField
extends BaseDurationField {
    private static final long serialVersionUID = -8346152187724495365L;
    private final long iUnitMillis;

    public PreciseDurationField(DurationFieldType durationFieldType, long l2) {
        super(durationFieldType);
        this.iUnitMillis = l2;
    }

    public final boolean isPrecise() {
        return true;
    }

    public final long getUnitMillis() {
        return this.iUnitMillis;
    }

    public long getValueAsLong(long l2, long l3) {
        return l2 / this.iUnitMillis;
    }

    public long getMillis(int n2, long l2) {
        return (long)n2 * this.iUnitMillis;
    }

    public long getMillis(long l2, long l3) {
        return FieldUtils.safeMultiply(l2, this.iUnitMillis);
    }

    public long add(long l2, int n2) {
        long l3 = (long)n2 * this.iUnitMillis;
        return FieldUtils.safeAdd(l2, l3);
    }

    public long add(long l2, long l3) {
        long l4 = FieldUtils.safeMultiply(l3, this.iUnitMillis);
        return FieldUtils.safeAdd(l2, l4);
    }

    public long getDifferenceAsLong(long l2, long l3) {
        long l4 = FieldUtils.safeSubtract(l2, l3);
        return l4 / this.iUnitMillis;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PreciseDurationField) {
            PreciseDurationField preciseDurationField = (PreciseDurationField)object;
            return this.getType() == preciseDurationField.getType() && this.iUnitMillis == preciseDurationField.iUnitMillis;
        }
        return false;
    }

    public int hashCode() {
        long l2 = this.iUnitMillis;
        int n2 = (int)(l2 ^ l2 >>> 32);
        return n2 += this.getType().hashCode();
    }
}

