import * as codepipeline from '@aws-cdk/aws-codepipeline';
import { Action } from '../action';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) Construction properties of the {@link ServiceCatalogDeployAction ServiceCatalog deploy CodePipeline Action}.
 *
 * **Note**: this API is still experimental, and may have breaking changes in the future!
 *
 * @experimental
 */
export interface ServiceCatalogDeployActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) The path to the cloudformation artifact.
     *
     * @experimental
     */
    readonly templatePath: codepipeline.ArtifactPath;
    /**
     * (experimental) The name of the version of the Service Catalog product to be deployed.
     *
     * @experimental
     */
    readonly productVersionName: string;
    /**
     * (experimental) The optional description of this version of the Service Catalog product.
     *
     * @default ''
     * @experimental
     */
    readonly productVersionDescription?: string;
    /**
     * (experimental) The identifier of the product in the Service Catalog.
     *
     * This product must already exist.
     *
     * @experimental
     */
    readonly productId: string;
}
/**
 * (experimental) CodePipeline action to connect to an existing ServiceCatalog product.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 *
 * @experimental
 */
export declare class ServiceCatalogDeployAction extends Action {
    private readonly templatePath;
    private readonly productVersionName;
    private readonly productVersionDescription?;
    private readonly productId;
    private readonly productType;
    /**
     * @experimental
     */
    constructor(props: ServiceCatalogDeployActionProps);
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
