# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_cli.ipynb.

# %% auto 0
__all__ = ['clean_dataset']

# %% ../nbs/01_cli.ipynb 2
import json

from datasets import load_dataset
from fastcore.script import *
from .core import BenchmarkCleaner

# %% ../nbs/01_cli.ipynb 5
@call_parse
def clean_dataset(
    dataset_name: str, # Name of the dataset to clean
    column_name: str, # Name of the column to clean
    benchmark_configs_path: str, # Path to the benchmark configuration file
    output_path: str, # Path to where the cleaned dataset will be saved
    dataset_config_name: str = None, # Name of the dataset configuration to use
    data_dir: str = None, # Path to the data files to use
    dataset_split: str = "train", # Name of the dataset split to clean
    save_json: bool = False, # Whether to save the cleaned dataset as a JSON file
    ): 
    """
    Clean a dataset using a benchmark configuration file.
    """
    ds = load_dataset(
        dataset_name,
        name=dataset_config_name,
        data_dir=data_dir,
        split=dataset_split,
    )
    benchmarks = json.load(open(benchmark_configs_path))
    bench_cleaner = BenchmarkCleaner(benchmarks, threshold=0.1, num_perm=128)
    ds = bench_cleaner.clean(ds, column_name)
    if save_json:
        ds.to_json(output_path, orient="records", lines=True)
    else:
        ds.save_to_disk(output_path)
