# Copyright (c) Facebook, Inc. and its affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

# pyre-unsafe

from typing import Any, Type

from django.contrib.auth.models import AbstractBaseUser as AbstractBaseUser
from django.http import HttpRequest

# Import functions that are accessed through django.contrib.auth, but are
# actually defined and overridden in util.asyncio.third_party_patches:
# https://fburl.com/diffusion/s4pwj22n
from util.asyncio.third_party_patches import (
    async_authenticate as async_authenticate,
    async_logout as async_logout,
)

REDIRECT_FIELD_NAME: str = ...
SESSION_KEY: str = ...
BACKEND_SESSION_KEY: str = ...
HASH_SESSION_KEY: str = ...

def _get_backends(return_tuples: bool) -> Any: ...
def _clean_credentials(credentials: dict) -> Any: ...
def get_user_model() -> Type[AbstractBaseUser]: ...
def logout(request: HttpRequest) -> None: ...
def load_backend(path: str): ...
def authenticate(**credentials) -> Any: ...
