# arlas-persistence-api-python
persistence REST services

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 12.0.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://www.gisaia.com/](http://www.gisaia.com/)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import arlas_persistence_api_python 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import arlas_persistence_api_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import arlas_persistence_api_python
from arlas_persistence_api_python.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = arlas_persistence_api_python.PersistenceApi()
type = 'hibernate' # str | Type of the document. (default to hibernate)
value = 'value_example' # str | Value to be persisted.
pretty = false # bool | Pretty print (optional) (default to false)

try:
    # Store a new piece of data for the provided key (auto generate id)
    api_response = api_instance.create(type, value, pretty=pretty)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling PersistenceApi->create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/arlas_persistence_server*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PersistenceApi* | [**create**](docs/PersistenceApi.md#create) | **POST** /persistence | Store a new piece of data for the provided key (auto generate id)
*PersistenceApi* | [**delete**](docs/PersistenceApi.md#delete) | **DELETE** /persistence/{id} | Delete an entry given its key and id.
*PersistenceApi* | [**get**](docs/PersistenceApi.md#get) | **GET** /persistence/{id} | Fetch an entry given its key and id.
*PersistenceApi* | [**list**](docs/PersistenceApi.md#list) | **GET** /persistence | Fetch a list of data related to a key.
*PersistenceApi* | [**update**](docs/PersistenceApi.md#update) | **PUT** /persistence/{id} | Update an existing value.


## Documentation For Models

 - [Data](docs/Data.md)
 - [DataResource](docs/DataResource.md)
 - [DataWithLinks](docs/DataWithLinks.md)
 - [Error](docs/Error.md)
 - [Link](docs/Link.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

contact@gisaia.com

