from quicktions import Fraction

from . import (
    _update,
    deprecated,
    enumerate,
    format,
    get,
    illustrators,
    io,
    iterate,
    iterpitches,
    lyconst,
    lyenv,
    makers,
    mutate,
    persist,
    string,
    wf,
)
from ._version import __version__, __version_info__
from .bind import Wrapper, annotate, attach, detach
from .bundle import LilyPondFormatBundle, SlotContributions
from .configuration import (
    Configuration,
    list_all_classes,
    list_all_functions,
    yield_all_modules,
)
from .contextmanagers import (
    ContextManager,
    FilesystemState,
    ForbidUpdate,
    NullContextManager,
    ProgressIndicator,
    RedirectedStreams,
    TemporaryDirectory,
    TemporaryDirectoryChange,
    Timer,
)
from .cyclictuple import CyclicTuple
from .duration import Duration, Multiplier, NonreducedFraction, Offset
from .dynamic import Dynamic
from .enums import (
    Center,
    Comparison,
    Down,
    Exact,
    HorizontalAlignment,
    Left,
    Less,
    Middle,
    More,
    Right,
    Up,
    VerticalAlignment,
)
from .exceptions import (
    AssignabilityError,
    ImpreciseMetronomeMarkError,
    LilyPondParserError,
    MissingMetronomeMarkError,
    ParentageError,
    PersistentIndicatorError,
    SchemeParserFinishedError,
    UnboundedTimeIntervalError,
    WellformednessError,
)
from .format import lilypond
from .get import Lineage
from .illustrators import illustrate
from .indicators import (
    Arpeggio,
    Articulation,
    BarLine,
    BeamCount,
    BendAfter,
    BreathMark,
    Clef,
    ColorFingering,
    Fermata,
    Glissando,
    KeyCluster,
    KeySignature,
    LaissezVibrer,
    MarginMarkup,
    MetronomeMark,
    Mode,
    Ottava,
    RehearsalMark,
    Repeat,
    RepeatTie,
    StaffChange,
    StaffPosition,
    StartBeam,
    StartGroup,
    StartHairpin,
    StartMarkup,
    StartPhrasingSlur,
    StartPianoPedal,
    StartSlur,
    StartTextSpan,
    StartTrillSpan,
    StemTremolo,
    StopBeam,
    StopGroup,
    StopHairpin,
    StopPhrasingSlur,
    StopPianoPedal,
    StopSlur,
    StopTextSpan,
    StopTrillSpan,
    Tie,
    TimeSignature,
)
from .instruments import (
    Accordion,
    AltoFlute,
    AltoSaxophone,
    AltoTrombone,
    AltoVoice,
    BaritoneSaxophone,
    BaritoneVoice,
    BassClarinet,
    BassFlute,
    BassSaxophone,
    BassTrombone,
    BassVoice,
    Bassoon,
    Cello,
    ClarinetInA,
    ClarinetInBFlat,
    ClarinetInEFlat,
    Contrabass,
    ContrabassClarinet,
    ContrabassFlute,
    ContrabassSaxophone,
    Contrabassoon,
    EnglishHorn,
    Flute,
    FrenchHorn,
    Glockenspiel,
    Guitar,
    Harp,
    Harpsichord,
    Instrument,
    Marimba,
    MezzoSopranoVoice,
    Oboe,
    Percussion,
    Piano,
    Piccolo,
    SopraninoSaxophone,
    SopranoSaxophone,
    SopranoVoice,
    StringNumber,
    TenorSaxophone,
    TenorTrombone,
    TenorVoice,
    Trumpet,
    Tuba,
    Tuning,
    Vibraphone,
    Viola,
    Violin,
    Xylophone,
)
from .io import graph, show
from .label import ColorMap
from .lilypondfile import Block, LilyPondFile
from .lyproxy import (
    LilyPondContext,
    LilyPondEngraver,
    LilyPondGrob,
    LilyPondGrobInterface,
)
from .makers import LeafMaker, NoteMaker
from .markups import Markup
from .math import Infinity, NegativeInfinity
from .meter import Meter, MeterList, MetricAccentKernel
from .metricmodulation import MetricModulation
from .obgc import OnBeatGraceContainer, on_beat_grace_container
from .overrides import (
    IndexedTweakManager,
    IndexedTweakManagers,
    Interface,
    LilyPondLiteral,
    LilyPondOverride,
    LilyPondSetting,
    OverrideInterface,
    SettingInterface,
    TweakInterface,
    override,
    setting,
    tweak,
)
from .parentage import Parentage
from .parsers import parser
from .parsers.base import Parser
from .parsers.parse import parse
from .pattern import Pattern, PatternTuple
from .pcollections import (
    IntervalClassSegment,
    IntervalClassSet,
    IntervalSegment,
    IntervalSet,
    PitchClassSegment,
    PitchClassSet,
    PitchRange,
    PitchSegment,
    PitchSet,
    Segment,
    Set,
    TwelveToneRow,
)
from .pitch import (
    Accidental,
    Interval,
    IntervalClass,
    NamedInterval,
    NamedIntervalClass,
    NamedInversionEquivalentIntervalClass,
    NamedPitch,
    NamedPitchClass,
    NumberedInterval,
    NumberedIntervalClass,
    NumberedInversionEquivalentIntervalClass,
    NumberedPitch,
    NumberedPitchClass,
    Octave,
    Pitch,
    PitchClass,
    PitchTyping,
)
from .ratio import NonreducedRatio, Ratio
from .score import (
    AfterGraceContainer,
    BeforeGraceContainer,
    Chord,
    Cluster,
    Component,
    Container,
    Context,
    DrumNoteHead,
    Leaf,
    MultimeasureRest,
    Note,
    NoteHead,
    NoteHeadList,
    Rest,
    Score,
    Skip,
    Staff,
    StaffGroup,
    TremoloContainer,
    Tuplet,
    Voice,
)
from .select import LogicalTie, Selection
from .setclass import SetClass
from .spanners import (
    beam,
    glissando,
    hairpin,
    horizontal_bracket,
    ottava,
    phrasing_slur,
    piano_pedal,
    slur,
    text_spanner,
    tie,
    trill_spanner,
)
from .tag import Line, Tag, activate, deactivate
from .timespan import OffsetCounter, Timespan, TimespanList
from .typedcollections import TypedCollection, TypedFrozenset, TypedList, TypedTuple
from .typings import (
    DurationSequenceTyping,
    DurationTyping,
    IntegerPair,
    IntegerSequence,
    Number,
    NumberPair,
    PatternTyping,
    Prototype,
    RatioSequenceTyping,
    RatioTyping,
    Strings,
)
from .verticalmoment import (
    VerticalMoment,
    iterate_leaf_pairs,
    iterate_pitch_pairs,
    iterate_vertical_moments,
)

index = Pattern.index
index_all = Pattern.index_all
index_first = Pattern.index_first
index_last = Pattern.index_last


__all__ = [
    "Accidental",
    "Accordion",
    "AfterGraceContainer",
    "AltoFlute",
    "AltoSaxophone",
    "AltoTrombone",
    "AltoVoice",
    "Arpeggio",
    "Articulation",
    "AssignabilityError",
    "BarLine",
    "BaritoneSaxophone",
    "BaritoneVoice",
    "BassClarinet",
    "BassFlute",
    "BassSaxophone",
    "BassTrombone",
    "BassVoice",
    "Bassoon",
    "BeamCount",
    "BeforeGraceContainer",
    "BendAfter",
    "Block",
    "BreathMark",
    "Cello",
    "Center",
    "Chord",
    "ClarinetInA",
    "ClarinetInBFlat",
    "ClarinetInEFlat",
    "Clef",
    "Cluster",
    "ColorFingering",
    "ColorMap",
    "Comparison",
    "Component",
    "Configuration",
    "Container",
    "Context",
    "ContextManager",
    "Contrabass",
    "ContrabassClarinet",
    "ContrabassFlute",
    "ContrabassSaxophone",
    "Contrabassoon",
    "CyclicTuple",
    "Down",
    "DrumNoteHead",
    "Duration",
    "DurationSequenceTyping",
    "DurationTyping",
    "Dynamic",
    "EnglishHorn",
    "Exact",
    "Expression",
    "Fermata",
    "FilesystemState",
    "Flute",
    "ForbidUpdate",
    "Fraction",
    "FrenchHorn",
    "Glissando",
    "Glockenspiel",
    "Guitar",
    "Harp",
    "Harpsichord",
    "HorizontalAlignment",
    "ImpreciseMetronomeMarkError",
    "IndexedTweakManager",
    "IndexedTweakManagers",
    "Infinity",
    "Instrument",
    "IntegerPair",
    "IntegerSequence",
    "Interface",
    "Interval",
    "IntervalClass",
    "IntervalClassSegment",
    "IntervalClassSet",
    "IntervalSegment",
    "IntervalSet",
    "KeyCluster",
    "KeySignature",
    "LaissezVibrer",
    "Leaf",
    "LeafMaker",
    "Left",
    "Less",
    "LilyPondContext",
    "LilyPondEngraver",
    "LilyPondFile",
    "LilyPondFormatBundle",
    "LilyPondGrob",
    "LilyPondGrobInterface",
    "LilyPondLiteral",
    "LilyPondOverride",
    "LilyPondParserError",
    "LilyPondSetting",
    "Line",
    "Lineage",
    "LogicalTie",
    "MarginMarkup",
    "Marimba",
    "Markup",
    "Meter",
    "MeterList",
    "MetricAccentKernel",
    "MetricModulation",
    "MetronomeMark",
    "MezzoSopranoVoice",
    "Middle",
    "MissingMetronomeMarkError",
    "Mode",
    "More",
    "MultimeasureRest",
    "Multiplier",
    "NamedInterval",
    "NamedIntervalClass",
    "NamedInversionEquivalentIntervalClass",
    "NamedPitch",
    "NamedPitchClass",
    "NegativeInfinity",
    "NonreducedFraction",
    "NonreducedRatio",
    "Note",
    "NoteHead",
    "NoteHeadList",
    "NoteMaker",
    "NullContextManager",
    "Number",
    "NumberPair",
    "NumberedInterval",
    "NumberedIntervalClass",
    "NumberedInversionEquivalentIntervalClass",
    "NumberedPitch",
    "NumberedPitchClass",
    "Oboe",
    "Octave",
    "Offset",
    "OffsetCounter",
    "OnBeatGraceContainer",
    "Ottava",
    "OverrideInterface",
    "Parentage",
    "ParentageError",
    "Parser",
    "Pattern",
    "PatternTuple",
    "PatternTyping",
    "Percussion",
    "PersistentIndicatorError",
    "Piano",
    "Piccolo",
    "Pitch",
    "PitchClass",
    "PitchClassSegment",
    "PitchClassSet",
    "PitchRange",
    "PitchSegment",
    "PitchSet",
    "PitchTyping",
    "ProgressIndicator",
    "Prototype",
    "Ratio",
    "RatioSequenceTyping",
    "RatioTyping",
    "RedirectedStreams",
    "RehearsalMark",
    "Repeat",
    "RepeatTie",
    "Rest",
    "Right",
    "SchemeParserFinishedError",
    "Score",
    "Segment",
    "Selection",
    "Set",
    "SetClass",
    "SettingInterface",
    "Skip",
    "SlotContributions",
    "SopraninoSaxophone",
    "SopranoSaxophone",
    "SopranoVoice",
    "Staff",
    "StaffChange",
    "StaffGroup",
    "StaffPosition",
    "StartBeam",
    "StartGroup",
    "StartHairpin",
    "StartMarkup",
    "StartPhrasingSlur",
    "StartPianoPedal",
    "StartSlur",
    "StartTextSpan",
    "StartTrillSpan",
    "StemTremolo",
    "StopBeam",
    "StopGroup",
    "StopHairpin",
    "StopPhrasingSlur",
    "StopPianoPedal",
    "StopSlur",
    "StopTextSpan",
    "StopTrillSpan",
    "StringNumber",
    "Strings",
    "Tag",
    "TemporaryDirectory",
    "TemporaryDirectoryChange",
    "TenorSaxophone",
    "TenorTrombone",
    "TenorVoice",
    "Tie",
    "TimeSignature",
    "Timer",
    "Timespan",
    "TimespanList",
    "TremoloContainer",
    "Trumpet",
    "Tuba",
    "Tuning",
    "Tuplet",
    "TweakInterface",
    "TwelveToneRow",
    "TypedCollection",
    "TypedFrozenset",
    "TypedList",
    "TypedTuple",
    "UnboundedTimeIntervalError",
    "Up",
    "VerticalAlignment",
    "VerticalMoment",
    "Vibraphone",
    "Viola",
    "Violin",
    "Voice",
    "WellformednessError",
    "Wrapper",
    "Xylophone",
    "__version__",
    "__version_info__",
    "_update",
    "activate",
    "annotate",
    "attach",
    "beam",
    "deactivate",
    "deprecated",
    "detach",
    "enumerate",
    "format",
    "glissando",
    "graph",
    "hairpin",
    "horizontal_bracket",
    "illustrate",
    "illustrators",
    "index",
    "index_all",
    "index_first",
    "index_last",
    "get",
    "io",
    "iterate",
    "iterate_leaf_pairs",
    "iterate_pitch_pairs",
    "iterate_vertical_moments",
    "iterpitches",
    "label",
    "list_all_classes",
    "list_all_functions",
    "lilypond",
    "lyconst",
    "lyenv",
    "makers",
    "mutate",
    "on_beat_grace_container",
    "ottava",
    "override",
    "parse",
    "parser",
    "persist",
    "phrasing_slur",
    "piano_pedal",
    "select",
    "setting",
    "show",
    "slur",
    "string",
    "text_spanner",
    "tie",
    "trill_spanner",
    "tweak",
    "wf",
    "yield_all_modules",
]
