# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['AuthenticationUsers']


class AuthenticationUsers(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_app: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 force_change_pass: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 realname: Optional[pulumi.Input[str]] = None,
                 restart_background_jobs: Optional[pulumi.Input[bool]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tz: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: AuthenticationUsers

        Create and update user information or delete the user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        user01 = splunk.AuthenticationUsers("user01",
            email="user01@example.com",
            force_change_pass=False,
            password="password01",
            roles=["terraform-user01-role"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_app: User default app. Overrides the default app inherited from the user roles.
        :param pulumi.Input[str] email: User email address.
        :param pulumi.Input[bool] force_change_pass: Force user to change password indication
        :param pulumi.Input[str] name: Unique user login name.
        :param pulumi.Input[str] password: User login password.
        :param pulumi.Input[str] realname: Full user name.
        :param pulumi.Input[bool] restart_background_jobs: Restart background search job that has not completed when Splunk restarts indication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Role to assign to this user. At least one existing role is required.
        :param pulumi.Input[str] tz: User timezone.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['default_app'] = default_app
            __props__['email'] = email
            __props__['force_change_pass'] = force_change_pass
            __props__['name'] = name
            __props__['password'] = password
            __props__['realname'] = realname
            __props__['restart_background_jobs'] = restart_background_jobs
            __props__['roles'] = roles
            __props__['tz'] = tz
        super(AuthenticationUsers, __self__).__init__(
            'splunk:index/authenticationUsers:AuthenticationUsers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_app: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            force_change_pass: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            realname: Optional[pulumi.Input[str]] = None,
            restart_background_jobs: Optional[pulumi.Input[bool]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tz: Optional[pulumi.Input[str]] = None) -> 'AuthenticationUsers':
        """
        Get an existing AuthenticationUsers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_app: User default app. Overrides the default app inherited from the user roles.
        :param pulumi.Input[str] email: User email address.
        :param pulumi.Input[bool] force_change_pass: Force user to change password indication
        :param pulumi.Input[str] name: Unique user login name.
        :param pulumi.Input[str] password: User login password.
        :param pulumi.Input[str] realname: Full user name.
        :param pulumi.Input[bool] restart_background_jobs: Restart background search job that has not completed when Splunk restarts indication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Role to assign to this user. At least one existing role is required.
        :param pulumi.Input[str] tz: User timezone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["default_app"] = default_app
        __props__["email"] = email
        __props__["force_change_pass"] = force_change_pass
        __props__["name"] = name
        __props__["password"] = password
        __props__["realname"] = realname
        __props__["restart_background_jobs"] = restart_background_jobs
        __props__["roles"] = roles
        __props__["tz"] = tz
        return AuthenticationUsers(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultApp")
    def default_app(self) -> pulumi.Output[str]:
        """
        User default app. Overrides the default app inherited from the user roles.
        """
        return pulumi.get(self, "default_app")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        User email address.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="forceChangePass")
    def force_change_pass(self) -> pulumi.Output[Optional[bool]]:
        """
        Force user to change password indication
        """
        return pulumi.get(self, "force_change_pass")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique user login name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        User login password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def realname(self) -> pulumi.Output[str]:
        """
        Full user name.
        """
        return pulumi.get(self, "realname")

    @property
    @pulumi.getter(name="restartBackgroundJobs")
    def restart_background_jobs(self) -> pulumi.Output[bool]:
        """
        Restart background search job that has not completed when Splunk restarts indication.
        """
        return pulumi.get(self, "restart_background_jobs")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[str]]:
        """
        Role to assign to this user. At least one existing role is required.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def tz(self) -> pulumi.Output[str]:
        """
        User timezone.
        """
        return pulumi.get(self, "tz")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

