% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Booster.R
\name{predict.lgb.Booster}
\alias{predict.lgb.Booster}
\title{Predict method for LightGBM model}
\usage{
\method{predict}{lgb.Booster}(object, data, num_iteration = NULL,
  rawscore = FALSE, predleaf = FALSE, predcontrib = FALSE,
  header = FALSE, reshape = FALSE, ...)
}
\arguments{
\item{object}{Object of class \code{lgb.Booster}}

\item{data}{a \code{matrix} object, a \code{dgCMatrix} object or a character representing a filename}

\item{num_iteration}{number of iteration want to predict with, NULL or <= 0 means use best iteration}

\item{rawscore}{whether the prediction should be returned in the for of original untransformed
sum of predictions from boosting iterations' results. E.g., setting \code{rawscore=TRUE} for
logistic regression would result in predictions for log-odds instead of probabilities.}

\item{predleaf}{whether predict leaf index instead.}

\item{predcontrib}{return per-feature contributions for each record.}

\item{header}{only used for prediction for text file. True if text file has header}

\item{reshape}{whether to reshape the vector of predictions to a matrix form when there are several
prediction outputs per case.}

\item{...}{Additional named arguments passed to the \code{predict()} method of
the \code{lgb.Booster} object passed to \code{object}.}
}
\value{
For regression or binary classification, it returns a vector of length \code{nrows(data)}.
For multiclass classification, either a \code{num_class * nrows(data)} vector or
a \code{(nrows(data), num_class)} dimension matrix is returned, depending on
the \code{reshape} value.

When \code{predleaf = TRUE}, the output is a matrix object with the
number of columns corresponding to the number of trees.
}
\description{
Predicted values based on class \code{lgb.Booster}
}
\examples{
library(lightgbm)
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "lightgbm")
test <- agaricus.test
dtest <- lgb.Dataset.create.valid(dtrain, test$data, label = test$label)
params <- list(objective = "regression", metric = "l2")
valids <- list(test = dtest)
model <- lgb.train(params,
                   dtrain,
                   100,
                   valids,
                   min_data = 1,
                   learning_rate = 1,
                   early_stopping_rounds = 10)
preds <- predict(model, test$data)

}
