% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Booster.R
\name{lgb.load}
\alias{lgb.load}
\title{Load LightGBM model}
\usage{
lgb.load(filename = NULL, model_str = NULL)
}
\arguments{
\item{filename}{path of model file}

\item{model_str}{a str containing the model}
}
\value{
lgb.Booster
}
\description{
Load LightGBM model from saved model file or string
Load LightGBM takes in either a file path or model string
If both are provided, Load will default to loading from file
}
\examples{
library(lightgbm)
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "lightgbm")
test <- agaricus.test
dtest <- lgb.Dataset.create.valid(dtrain, test$data, label = test$label)
params <- list(objective = "regression", metric = "l2")
valids <- list(test = dtest)
model <- lgb.train(params,
                   dtrain,
                   100,
                   valids,
                   min_data = 1,
                   learning_rate = 1,
                   early_stopping_rounds = 10)
lgb.save(model, "model.txt")
load_booster <- lgb.load(filename = "model.txt")
model_string <- model$save_model_to_string(NULL) # saves best iteration
load_booster_from_str <- lgb.load(model_str = model_string)

}
