% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Dataset.R
\name{getinfo}
\alias{getinfo}
\alias{getinfo.lgb.Dataset}
\title{Get information of an lgb.Dataset object}
\usage{
getinfo(dataset, ...)

\method{getinfo}{lgb.Dataset}(dataset, name, ...)
}
\arguments{
\item{dataset}{Object of class \code{lgb.Dataset}}

\item{...}{other parameters}

\item{name}{the name of the information field to get (see details)}
}
\value{
info data
}
\description{
Get information of an lgb.Dataset object
}
\details{
The \code{name} field can be one of the following:

\itemize{
    \item \code{label}: label lightgbm learn from ;
    \item \code{weight}: to do a weight rescale ;
    \item \code{group}: group size
    \item \code{init_score}: initial score is the base prediction lightgbm will boost from ;
}
}
\examples{
library(lightgbm)
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
lgb.Dataset.construct(dtrain)

labels <- lightgbm::getinfo(dtrain, "label")
lightgbm::setinfo(dtrain, "label", 1 - labels)

labels2 <- lightgbm::getinfo(dtrain, "label")
stopifnot(all(labels2 == 1 - labels))

}
