%include "mpdocstring.i"
%module(docstring=MPDOCSTRING) medpython

%{
#define SWIG_FILE_WITH_INIT
%}

%include "exception.i"
%include "typemaps.i"
%include "std_string.i"
%include "std_vector.i"
%include "medial-numpy.i"


%init %{
import_array();
%}


namespace std {
   %template(BoolVector) std::vector<bool>;
   %template(IntVector) std::vector<int>;
   %template(CharVector) std::vector<char>;
   %template(DoubleVector) std::vector<double>;
   %template(StringVector) std::vector<std::string>;
   %template(StringVector2) std::vector< std::string,std::allocator< std::string > >;
   %template(FloatVector) std::vector<float>;
};

%apply const std::string & { std::string& };
%apply const std::string & { string& };
%apply std::string { string };

typedef std::vector vector;

%exception {
  try {
    $function;
  } catch(StopIterator) {
    PyErr_SetString(PyExc_StopIteration, "End of iterator");
    return NULL;
  } catch (std::runtime_error e) {
    PyErr_SetString(PyExc_Exception, e.what());
    return NULL;
  } catch (std::exception e) {
    PyErr_SetString(PyExc_Exception, e.what());
    return NULL;
  } catch (...) {
    PyErr_SetString(PyExc_Exception, "Error: An unknown Exception was thrown");
    return NULL;
  } 

}

%feature("autodoc", "1");

%{
#include "MedPython.h"
#include "MedPyCommon.h"
#include "MedPyExport.h"
%}

%include "apply_directives.i"
%include "MedPyCommon.h"

/* This was added to avoid SWIG's CheckLong which fails on numpy.int64/32 */

%typemap(in) int %{
  $1 = PyLong_AsLong($input);
  if ($1 == -1 && PyErr_Occurred()) {
    PyErr_Clear();
    PyErr_Format(PyExc_TypeError, "Parameter must be an integer type, but got %s", Py_TYPE($input)->tp_name);
    return NULL;
  }
%}

%typemap(in) unsigned long long %{
  $1 = PyLong_AsUnsignedLongLong($input);
  if ($1 == -1 && PyErr_Occurred()) {
    PyErr_Clear();
    PyErr_Format(PyExc_TypeError, "Parameter must be an integer (unsigned long long) type, but got %s", Py_TYPE($input)->tp_name);
    return NULL;
  }
%}

%include "MedPython.h"

%include "autogenerated_includes.i"

%include "pythoncode.i"


%include "MedPyExport.h"


