% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Dataset.R
\name{slice}
\alias{slice}
\alias{slice.lgb.Dataset}
\title{Slice a dataset}
\usage{
slice(dataset, ...)

\method{slice}{lgb.Dataset}(dataset, idxset, ...)
}
\arguments{
\item{dataset}{Object of class "lgb.Dataset"}

\item{...}{other parameters (currently not used)}

\item{idxset}{a integer vector of indices of rows needed}
}
\value{
constructed sub dataset
}
\description{
Get a new \code{lgb.Dataset} containing the specified rows of
original lgb.Dataset object
}
\examples{
library(lightgbm)
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)

dsub <- lightgbm::slice(dtrain, 1:42)
lgb.Dataset.construct(dsub)
labels <- lightgbm::getinfo(dsub, "label")

}
