# studio_wrapper.py

from enum import Enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = '83e1bfb3a13bb970193903fd8c156725'
g_compiler_version = '1.0'

class RootCoreCore_monitoring(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_monitoring'


class RootCoreDirect_motor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.direct_motor_control'


class RootCoreOrtPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.amplitude_reduction.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.amplitude_reduction.unit', str(new_val))


class RootCoreOrtPropertyBaseline_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_value.unit', str(new_val))


class RootCoreOrtPropertyAverage_periods(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.average_periods'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.average_periods.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.average_periods.value', int(new_val))


class RootCoreOrtPropertyBaseline_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_amplitude.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_amplitude.unit', str(new_val))


class RootCoreOrtPropertyBaseline_window_begin(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_begin'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_begin.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_begin.value', float(new_val))


class RootCoreOrtPropertyAdhesion_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.adhesion_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.adhesion_value.unit', str(new_val))


class RootCoreOrtPropertyBaseline_controller_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_controller_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.baseline_controller_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.baseline_controller_enabled.value', bool(new_val))


class RootCoreOrtPropertyAdhesion_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_position.value', float(new_val))


class RootCoreOrtPropertyExcitation_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.excitation_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.excitation_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.excitation_enabled.value', bool(new_val))


class RootCoreOrtPropertySamples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.samples_per_period.value', int(new_val))


class RootCoreOrtPropertyFree_wave_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.free_wave_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.free_wave_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.free_wave_delay.value', float(new_val))


class RootCoreOrtPropertyCantilever_samples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.cantilever_samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.cantilever_samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.cantilever_samples_per_period.value', int(new_val))


class RootCoreOrtPropertyInput_select(wrap.CmdTreeProp):

    class EnumType(Enum):
        Fast_In_Deflection = 'Fast In Deflection'
        Hi_Res_In_Deflection = 'Hi Res In Deflection'
        Fast_In_User = 'Fast In User'
        Hi_Res_In_User1 = 'Hi Res In User1'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.input_select'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreOrtPropertyInput_select.EnumType(self._context.get('root.core.ort.property.input_select.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.ort.property.input_select.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.ort.property.input_select.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.ort.property.input_select.enum', list(new_val))


class RootCoreOrtPropertyFeedback_amplitude_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.feedback_amplitude_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.feedback_amplitude_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.feedback_amplitude_position.value', float(new_val))


class RootCoreOrtPropertyBaseline_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_frequency.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_frequency.unit', str(new_val))


class RootCoreOrtPropertyBaseline_window_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_end.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_end.value', float(new_val))


class RootCoreOrtProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property'
        self.baseline_window_end = RootCoreOrtPropertyBaseline_window_end(self._context)
        self.baseline_frequency = RootCoreOrtPropertyBaseline_frequency(self._context)
        self.feedback_amplitude_position = RootCoreOrtPropertyFeedback_amplitude_position(self._context)
        self.input_select = RootCoreOrtPropertyInput_select(self._context)
        self.cantilever_samples_per_period = RootCoreOrtPropertyCantilever_samples_per_period(self._context)
        self.free_wave_delay = RootCoreOrtPropertyFree_wave_delay(self._context)
        self.samples_per_period = RootCoreOrtPropertySamples_per_period(self._context)
        self.excitation_enabled = RootCoreOrtPropertyExcitation_enabled(self._context)
        self.adhesion_position = RootCoreOrtPropertyAdhesion_position(self._context)
        self.baseline_controller_enabled = RootCoreOrtPropertyBaseline_controller_enabled(self._context)
        self.adhesion_value = RootCoreOrtPropertyAdhesion_value(self._context)
        self.baseline_window_begin = RootCoreOrtPropertyBaseline_window_begin(self._context)
        self.baseline_amplitude = RootCoreOrtPropertyBaseline_amplitude(self._context)
        self.average_periods = RootCoreOrtPropertyAverage_periods(self._context)
        self.baseline_value = RootCoreOrtPropertyBaseline_value(self._context)
        self.amplitude_reduction = RootCoreOrtPropertyAmplitude_reduction(self._context)


class RootCoreOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort'
        self.property = RootCoreOrtProperty(self._context)

    def update_free_wave(self, *args) -> Any:
        return self._context.call('root.core.ort.update_free_wave', *args)

    def apply_sample_values(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_sample_values', *args)

    def excitation_amplitude(self, *args) -> Any:
        return self._context.call('root.core.ort.excitation_amplitude', *args)

    def select_input(self, *args) -> Any:
        return self._context.call('root.core.ort.select_input', *args)

    def is_averaging(self, *args) -> Any:
        return self._context.call('root.core.ort.is_averaging', *args)

    def apply_samples_per_period(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_samples_per_period', *args)


class RootCoreCore_environment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_environment'


class RootCoreHv_amp_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.hv_amp_control'


class RootCoreThermal_tunePropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.temperature.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.temperature.unit', str(new_val))


class RootCoreThermal_tunePropertyMax_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.max_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.max_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.max_frequency.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.max_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.max_frequency.unit', str(new_val))


class RootCoreThermal_tunePropertyMeasurement_environment(wrap.CmdTreeProp):

    class EnumType(Enum):
        Air = 'Air'
        Liquid = 'Liquid'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreThermal_tunePropertyMeasurement_environment.EnumType(self._context.get('root.core.thermal_tune.property.measurement_environment.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.thermal_tune.property.measurement_environment.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.thermal_tune.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.thermal_tune.property.measurement_environment.enum', list(new_val))


class RootCoreThermal_tunePropertyIterations(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.iterations'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.thermal_tune.property.iterations.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.thermal_tune.property.iterations.value', int(new_val))


class RootCoreThermal_tunePropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.unit', str(new_val))


class RootCoreThermal_tunePropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.unit', str(new_val))


class RootCoreThermal_tunePropertyResolution(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.resolution'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.resolution.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.resolution.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.resolution.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.resolution.unit', str(new_val))


class RootCoreThermal_tuneProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property'
        self.resolution = RootCoreThermal_tunePropertyResolution(self._context)
        self.fit_frequency_upper_bound = RootCoreThermal_tunePropertyFit_frequency_upper_bound(self._context)
        self.fit_frequency_lower_bound = RootCoreThermal_tunePropertyFit_frequency_lower_bound(self._context)
        self.iterations = RootCoreThermal_tunePropertyIterations(self._context)
        self.measurement_environment = RootCoreThermal_tunePropertyMeasurement_environment(self._context)
        self.max_frequency = RootCoreThermal_tunePropertyMax_frequency(self._context)
        self.temperature = RootCoreThermal_tunePropertyTemperature(self._context)


class RootCoreThermal_tuneSignalNew_frequency_list(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_frequency_list'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect', *args)


class RootCoreThermal_tuneSignalNew_fit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_fit'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect', *args)


class RootCoreThermal_tuneSignalEnded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.ended'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect', *args)


class RootCoreThermal_tuneSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.procedure_info'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect', *args)


class RootCoreThermal_tuneSignalStarted(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect', *args)


class RootCoreThermal_tuneSignalProgress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.progress'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect', *args)


class RootCoreThermal_tuneSignalNew_average(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_average'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect', *args)


class RootCoreThermal_tuneSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal'
        self.new_average = RootCoreThermal_tuneSignalNew_average(self._context)
        self.progress = RootCoreThermal_tuneSignalProgress(self._context)
        self.started = RootCoreThermal_tuneSignalStarted(self._context)
        self.procedure_info = RootCoreThermal_tuneSignalProcedure_info(self._context)
        self.ended = RootCoreThermal_tuneSignalEnded(self._context)
        self.new_fit = RootCoreThermal_tuneSignalNew_fit(self._context)
        self.new_frequency_list = RootCoreThermal_tuneSignalNew_frequency_list(self._context)


class RootCoreThermal_tune(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune'
        self.signal = RootCoreThermal_tuneSignal(self._context)
        self.property = RootCoreThermal_tuneProperty(self._context)

    def start(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.start', *args)

    def create_fit_from_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.create_fit_from_fft_average_buffer', *args)

    def calculate_cantilever_calibration(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.calculate_cantilever_calibration', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.abort', *args)

    def set_fit_window_range(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.set_fit_window_range', *args)

    def add_raw_data_to_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.add_raw_data_to_fft_average_buffer', *args)

    def auto_calc_properties(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.auto_calc_properties', *args)

    def generate_frequency_list(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.generate_frequency_list', *args)


class RootCoreFrequency_sweepPropertyFrequency_selection_criteria(wrap.CmdTreeProp):

    class EnumType(Enum):
        Below_Peak = 'Below Peak'
        Above_Peak = 'Above Peak'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.frequency_selection_criteria'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreFrequency_sweepPropertyFrequency_selection_criteria.EnumType(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.enum', list(new_val))


class RootCoreFrequency_sweepPropertyNew_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.unit', str(new_val))


class RootCoreFrequency_sweepPropertyNew_excitation_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_excitation_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.unit', str(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit', str(new_val))


class RootCoreFrequency_sweepPropertyMeasurement_environment(wrap.CmdTreeProp):

    class EnumType(Enum):
        Air = 'Air'
        Liquid = 'Liquid'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreFrequency_sweepPropertyMeasurement_environment.EnumType(self._context.get('root.core.frequency_sweep.property.measurement_environment.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.enum', list(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.unit', str(new_val))


class RootCoreFrequency_sweepPropertySweep_data_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_data_points'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.sweep_data_points.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.sweep_data_points.value', int(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit', str(new_val))


class RootCoreFrequency_sweepPropertySweep_excitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit', str(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_unit(wrap.CmdTreeProp):

    class EnumType(Enum):
        Meters_m_ = 'Meters [m]'
        Volts_V_ = 'Volts [V]'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_unit'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreFrequency_sweepPropertyAmplitude_unit.EnumType(self._context.get('root.core.frequency_sweep.property.amplitude_unit.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.amplitude_unit.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.enum', list(new_val))


class RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit', str(new_val))


class RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_free_vibration_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit', str(new_val))


class RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit', str(new_val))


class RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(wrap.CmdTreeProp):

    class EnumType(Enum):
        num_90_Hz = '90 Hz'
        num_180_Hz = '180 Hz'
        num_360_Hz = '360 Hz'
        num_750_Hz = '750 Hz'
        num_1500_Hz = '1500 Hz'
        num_3_kHz = '3 kHz'
        num_6_kHz = '6 kHz'
        num_12_kHz = '12 kHz'
        num_23_kHz = '23 kHz'
        num_45_kHz = '45 kHz'
        num_100_kHz = '100 kHz'
        num_230_kHz = '230 kHz'
        num_500_kHz = '500 kHz'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.analyzer_demodulator_bandwidth'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth.EnumType(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum', list(new_val))


class RootCoreFrequency_sweepPropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.temperature.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.temperature.unit', str(new_val))


class RootCoreFrequency_sweepProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property'
        self.temperature = RootCoreFrequency_sweepPropertyTemperature(self._context)
        self.analyzer_demodulator_bandwidth = RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(self._context)
        self.fit_frequency_lower_bound = RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(self._context)
        self.sweep_free_vibration_amplitude = RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(self._context)
        self.fit_frequency_upper_bound = RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(self._context)
        self.amplitude_unit = RootCoreFrequency_sweepPropertyAmplitude_unit(self._context)
        self.sweep_excitation_amplitude = RootCoreFrequency_sweepPropertySweep_excitation_amplitude(self._context)
        self.sweep_frequency_upper_bound = RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(self._context)
        self.sweep_data_points = RootCoreFrequency_sweepPropertySweep_data_points(self._context)
        self.amplitude_reduction = RootCoreFrequency_sweepPropertyAmplitude_reduction(self._context)
        self.measurement_environment = RootCoreFrequency_sweepPropertyMeasurement_environment(self._context)
        self.sweep_frequency_lower_bound = RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(self._context)
        self.new_excitation_frequency = RootCoreFrequency_sweepPropertyNew_excitation_frequency(self._context)
        self.new_spring_constant = RootCoreFrequency_sweepPropertyNew_spring_constant(self._context)
        self.frequency_selection_criteria = RootCoreFrequency_sweepPropertyFrequency_selection_criteria(self._context)


class RootCoreFrequency_sweepSignalProcess_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.process_sweep_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect', *args)


class RootCoreFrequency_sweepSignalNew_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_sweep_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect', *args)


class RootCoreFrequency_sweepSignalData_invalidated(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.data_invalidated'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect', *args)


class RootCoreFrequency_sweepSignalSweep_ended(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_ended'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect', *args)


class RootCoreFrequency_sweepSignalSweep_progress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_progress'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect', *args)


class RootCoreFrequency_sweepSignalNew_fit_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_fit_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect', *args)


class RootCoreFrequency_sweepSignalSho_fit_failed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sho_fit_failed'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect', *args)


class RootCoreFrequency_sweepSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal'
        self.sho_fit_failed = RootCoreFrequency_sweepSignalSho_fit_failed(self._context)
        self.new_fit_data = RootCoreFrequency_sweepSignalNew_fit_data(self._context)
        self.sweep_progress = RootCoreFrequency_sweepSignalSweep_progress(self._context)
        self.sweep_ended = RootCoreFrequency_sweepSignalSweep_ended(self._context)
        self.data_invalidated = RootCoreFrequency_sweepSignalData_invalidated(self._context)
        self.new_sweep_data = RootCoreFrequency_sweepSignalNew_sweep_data(self._context)
        self.process_sweep_data = RootCoreFrequency_sweepSignalProcess_sweep_data(self._context)


class RootCoreFrequency_sweep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep'
        self.signal = RootCoreFrequency_sweepSignal(self._context)
        self.property = RootCoreFrequency_sweepProperty(self._context)

    def invalidate_sweep_and_fit_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.invalidate_sweep_and_fit_data', *args)

    def calculate_spring_constant(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.calculate_spring_constant', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.abort', *args)

    def convert_and_emit_sweep_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.convert_and_emit_sweep_data', *args)

    def do_sho_fit(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.do_sho_fit', *args)

    def start(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.start', *args)

    def set_sweep_parameters(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.set_sweep_parameters', *args)


class RootCoreSignal_store(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_store'

    def get_signal_calibration_min_max(self, *args) -> Any:
        return self._context.call('root.core.signal_store.get_signal_calibration_min_max', *args)


class RootCoreAcquisition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.acquisition'

    def write_data(self, *args) -> Any:
        return self._context.call('root.core.acquisition.write_data', *args)


class RootCoreApproachPropertyApproach_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.approach_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.approach_steps.value', int(new_val))


class RootCoreApproachPropertyDeflection_offset_voltage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.deflection_offset_voltage'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.deflection_offset_voltage.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.deflection_offset_voltage.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.deflection_offset_voltage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.deflection_offset_voltage.unit', str(new_val))


class RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_coarse_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit', str(new_val))


class RootCoreApproachPropertyStep_by_step_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Position_Controlled = 'Position Controlled'
        Not_Controlled = 'Not Controlled'
        Tip_Position_Ignored = 'Tip Position Ignored'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreApproachPropertyStep_by_step_mode.EnumType(self._context.get('root.core.approach.property.step_by_step_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.approach.property.step_by_step_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.step_by_step_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.step_by_step_mode.enum', list(new_val))


class RootCoreApproachPropertyStep_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_period.value', float(new_val))


class RootCoreApproachPropertyWithdraw_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.withdraw_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.withdraw_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.withdraw_steps.value', int(new_val))


class RootCoreApproachPropertyMotor_source(wrap.CmdTreeProp):

    class EnumType(Enum):
        Internal = 'Internal'
        External = 'External'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.motor_source'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreApproachPropertyMotor_source.EnumType(self._context.get('root.core.approach.property.motor_source.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.approach.property.motor_source.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.motor_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.motor_source.enum', list(new_val))


class RootCoreApproachPropertyStep_by_step_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_time.value', float(new_val))


class RootCoreApproachPropertyApproach_result(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_result'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_result.value'))

    @value.setter
    def value(self, new_val:str):
        self._context.set('root.core.approach.property.approach_result.value', str(new_val))


class RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_fine_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.unit', str(new_val))


class RootCoreApproachPropertyStep_by_step_slope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_slope.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_slope.unit', str(new_val))


class RootCoreApproachPropertyApproach_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Continuous = 'Continuous'
        Step_by_Step = 'Step by Step'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreApproachPropertyApproach_mode.EnumType(self._context.get('root.core.approach.property.approach_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.approach.property.approach_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.approach_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.approach_mode.enum', list(new_val))


class RootCoreApproachPropertyApproach_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_pos.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_pos.unit', str(new_val))


class RootCoreApproachPropertyApproach_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_speed.unit', str(new_val))


class RootCoreApproachProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property'
        self.approach_speed = RootCoreApproachPropertyApproach_speed(self._context)
        self.approach_pos = RootCoreApproachPropertyApproach_pos(self._context)
        self.approach_mode = RootCoreApproachPropertyApproach_mode(self._context)
        self.step_by_step_slope = RootCoreApproachPropertyStep_by_step_slope(self._context)
        self.step_by_step_fine_step_size_percentage = RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(self._context)
        self.approach_result = RootCoreApproachPropertyApproach_result(self._context)
        self.step_by_step_time = RootCoreApproachPropertyStep_by_step_time(self._context)
        self.motor_source = RootCoreApproachPropertyMotor_source(self._context)
        self.withdraw_steps = RootCoreApproachPropertyWithdraw_steps(self._context)
        self.step_period = RootCoreApproachPropertyStep_period(self._context)
        self.step_by_step_mode = RootCoreApproachPropertyStep_by_step_mode(self._context)
        self.step_by_step_coarse_step_size_percentage = RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(self._context)
        self.deflection_offset_voltage = RootCoreApproachPropertyDeflection_offset_voltage(self._context)
        self.approach_steps = RootCoreApproachPropertyApproach_steps(self._context)


class RootCoreApproachSignalApproach_or_withdraw_done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal.approach_or_withdraw_done'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect', *args)


class RootCoreApproachSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal'
        self.approach_or_withdraw_done = RootCoreApproachSignalApproach_or_withdraw_done(self._context)


class RootCoreApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach'
        self.signal = RootCoreApproachSignal(self._context)
        self.property = RootCoreApproachProperty(self._context)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.approach.abort', *args)

    def approach(self, *args) -> Any:
        return self._context.call('root.core.approach.approach', *args)

    def withdraw(self, *args) -> Any:
        return self._context.call('root.core.approach.withdraw', *args)


class RootCoreSignal_analyzer1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_analyzer1'


class RootCoreScan_head_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.scan_head_calibration'


class RootCoreComp_dc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.comp_dc'


class RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Is_Less_Than = 'Is Less Than'
        Is_Greater_Than = 'Is Greater Than'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyBackward_modulation_stop_mode.EnumType(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Z_Off = 'Z Off'
        Z_On = 'Z On'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyBackward_pause_mode.EnumType(self._context.get('root.core.spectroscopy.property.backward_pause_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Is_Less_Than = 'Is Less Than'
        Is_Greater_Than = 'Is Greater Than'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyForward_modulation_stop_mode.EnumType(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Fixed_Length = 'Fixed Length'
        Stop_by_Value = 'Stop by Value'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyBackward_modulation_mode.EnumType(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyFeedback_active(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.feedback_active'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.feedback_active.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.feedback_active.value', bool(new_val))


class RootCoreSpectroscopyPropertyForward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_pause_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Z_Off = 'Z Off'
        Z_On = 'Z On'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyForward_pause_mode.EnumType(self._context.get('root.core.spectroscopy.property.forward_pause_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertySample_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.sample_mask'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.sample_mask.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.sample_mask.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.sample_mask.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.sample_mask.unit', str(new_val))


class RootCoreSpectroscopyPropertyStart_offste_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offste_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.unit', str(new_val))


class RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.auto_recalibrate_probe_interval'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.unit', str(new_val))


class RootCoreSpectroscopyPropertyModulation_output(wrap.CmdTreeProp):

    class EnumType(Enum):
        Position_Z = 'Position Z'
        Tip_Voltage = 'Tip Voltage'
        External_Z = 'External Z'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_output'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyModulation_output.EnumType(self._context.get('root.core.spectroscopy.property.modulation_output.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.modulation_output.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.modulation_output.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.modulation_output.enum', list(new_val))


class RootCoreSpectroscopyPropertySpec_end_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Keep_Last_Z_Position = 'Keep Last Z Position'
        Z_Controller_Active = 'Z-Controller Active'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.spec_end_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertySpec_end_mode.EnumType(self._context.get('root.core.spectroscopy.property.spec_end_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.spec_end_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.unit', str(new_val))


class RootCoreSpectroscopyPropertyStart_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offset.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offset.unit', str(new_val))


class RootCoreSpectroscopyPropertyRepetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.repetition_count'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.repetition_count.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.repetition_count.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.repetition_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.repetition_count.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Fixed_Length = 'Fixed Length'
        Stop_by_Value = 'Stop by Value'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreSpectroscopyPropertyForward_modulation_mode.EnumType(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.unit', str(new_val))


class RootCoreSpectroscopyPropertyModulation_relative_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_relative_value'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.modulation_relative_value.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.modulation_relative_value.value', bool(new_val))


class RootCoreSpectroscopyPropertyXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.xy_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.xy_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.unit', str(new_val))


class RootCoreSpectroscopyProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property'
        self.forward_modulation_stop_value = RootCoreSpectroscopyPropertyForward_modulation_stop_value(self._context)
        self.xy_move_speed = RootCoreSpectroscopyPropertyXy_move_speed(self._context)
        self.modulation_relative_value = RootCoreSpectroscopyPropertyModulation_relative_value(self._context)
        self.backward_pause_time = RootCoreSpectroscopyPropertyBackward_pause_time(self._context)
        self.forward_move_speed = RootCoreSpectroscopyPropertyForward_move_speed(self._context)
        self.forward_modulation_mode = RootCoreSpectroscopyPropertyForward_modulation_mode(self._context)
        self.repetition_count = RootCoreSpectroscopyPropertyRepetition_count(self._context)
        self.start_offset = RootCoreSpectroscopyPropertyStart_offset(self._context)
        self.backward_modulation_stop_value = RootCoreSpectroscopyPropertyBackward_modulation_stop_value(self._context)
        self.forward_modulation_time = RootCoreSpectroscopyPropertyForward_modulation_time(self._context)
        self.forward_pause_sampling_rate = RootCoreSpectroscopyPropertyForward_pause_sampling_rate(self._context)
        self.spec_end_mode = RootCoreSpectroscopyPropertySpec_end_mode(self._context)
        self.modulation_output = RootCoreSpectroscopyPropertyModulation_output(self._context)
        self.backward_pause_datapoints = RootCoreSpectroscopyPropertyBackward_pause_datapoints(self._context)
        self.backward_pause_sampling_rate = RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(self._context)
        self.auto_recalibrate_probe_interval = RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(self._context)
        self.backward_modulation_range = RootCoreSpectroscopyPropertyBackward_modulation_range(self._context)
        self.backward_sampling_rate = RootCoreSpectroscopyPropertyBackward_sampling_rate(self._context)
        self.backward_datapoints = RootCoreSpectroscopyPropertyBackward_datapoints(self._context)
        self.start_offste_move_speed = RootCoreSpectroscopyPropertyStart_offste_move_speed(self._context)
        self.sample_mask = RootCoreSpectroscopyPropertySample_mask(self._context)
        self.forward_pause_mode = RootCoreSpectroscopyPropertyForward_pause_mode(self._context)
        self.forward_datapoints = RootCoreSpectroscopyPropertyForward_datapoints(self._context)
        self.forward_sampling_rate = RootCoreSpectroscopyPropertyForward_sampling_rate(self._context)
        self.forward_pause_time = RootCoreSpectroscopyPropertyForward_pause_time(self._context)
        self.feedback_active = RootCoreSpectroscopyPropertyFeedback_active(self._context)
        self.backward_modulation_mode = RootCoreSpectroscopyPropertyBackward_modulation_mode(self._context)
        self.forward_modulation_stop_mode = RootCoreSpectroscopyPropertyForward_modulation_stop_mode(self._context)
        self.forward_modulation_range = RootCoreSpectroscopyPropertyForward_modulation_range(self._context)
        self.forward_pause_datapoints = RootCoreSpectroscopyPropertyForward_pause_datapoints(self._context)
        self.backward_modulation_time = RootCoreSpectroscopyPropertyBackward_modulation_time(self._context)
        self.backward_move_speed = RootCoreSpectroscopyPropertyBackward_move_speed(self._context)
        self.backward_pause_mode = RootCoreSpectroscopyPropertyBackward_pause_mode(self._context)
        self.backward_modulation_stop_mode = RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(self._context)


class RootCoreSpectroscopySignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.signal'


class RootCoreSpectroscopy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy'
        self.signal = RootCoreSpectroscopySignal(self._context)
        self.property = RootCoreSpectroscopyProperty(self._context)

    def start(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.start', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.abort', *args)


class RootCorePosition_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.position_control'


class RootCoreConverter_channel_correction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.converter_channel_correction'


class RootCoreZ_controllerPropertyMax_z_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.max_z_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.max_z_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.max_z_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.max_z_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.max_z_value.unit', str(new_val))


class RootCoreZ_controllerPropertyFeedback_polarity(wrap.CmdTreeProp):

    class EnumType(Enum):
        positive = 'positive'
        negative = 'negative'
        invalid = 'invalid'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback_polarity'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreZ_controllerPropertyFeedback_polarity.EnumType(self._context.get('root.core.z_controller.property.feedback_polarity.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.z_controller.property.feedback_polarity.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback_polarity.enum', list(new_val))


class RootCoreZ_controllerPropertyI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.i_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.i_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.i_gain.value', int(new_val))


class RootCoreZ_controllerPropertyAbsolute_idle_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.absolute_idle_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.absolute_idle_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.absolute_idle_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.absolute_idle_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.absolute_idle_position.unit', str(new_val))


class RootCoreZ_controllerPropertyActual_feedback_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_feedback_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_feedback_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_feedback_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_feedback_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_feedback_value.unit', str(new_val))


class RootCoreZ_controllerPropertyFeedback(wrap.CmdTreeProp):

    class EnumType(Enum):
        Deflection = 'Deflection'
        WaveMode_Amplitude_Reduction = 'WaveMode Amplitude Reduction'
        Dynamic_Mode_Amplitude_Reduction = 'Dynamic Mode Amplitude Reduction'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreZ_controllerPropertyFeedback.EnumType(self._context.get('root.core.z_controller.property.feedback.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.z_controller.property.feedback.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback.enum', list(new_val))


class RootCoreZ_controllerPropertyActual_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_tip_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_tip_position.unit', str(new_val))


class RootCoreZ_controllerPropertyP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.p_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.p_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.p_gain.value', int(new_val))


class RootCoreZ_controllerPropertyIdle_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Enable_Z_Controller = 'Enable Z Controller'
        Retract_Tip = 'Retract Tip'
        Keep_Last_Z_Position = 'Keep Last Z Position'
        Absolute_Z_Position = 'Absolute Z Position'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.idle_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreZ_controllerPropertyIdle_mode.EnumType(self._context.get('root.core.z_controller.property.idle_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.z_controller.property.idle_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.idle_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.idle_mode.enum', list(new_val))


class RootCoreZ_controllerPropertySetpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.setpoint.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.setpoint.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.setpoint.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.setpoint.unit', str(new_val))


class RootCoreZ_controllerPropertyD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.d_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.d_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.d_gain.value', int(new_val))


class RootCoreZ_controllerPropertyBase_work_mode(wrap.CmdTreeProp):

    class EnumType(Enum):
        Control_Z_by_Z_Sensor = 'Control Z by Z-Sensor'
        Drive_Z = 'Drive Z'
        Control_Z_by_Measurement_Mode = 'Control Z by Measurement Mode'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.base_work_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreZ_controllerPropertyBase_work_mode.EnumType(self._context.get('root.core.z_controller.property.base_work_mode.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.z_controller.property.base_work_mode.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.base_work_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.base_work_mode.enum', list(new_val))


class RootCoreZ_controllerProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property'
        self.base_work_mode = RootCoreZ_controllerPropertyBase_work_mode(self._context)
        self.d_gain = RootCoreZ_controllerPropertyD_gain(self._context)
        self.setpoint = RootCoreZ_controllerPropertySetpoint(self._context)
        self.idle_mode = RootCoreZ_controllerPropertyIdle_mode(self._context)
        self.p_gain = RootCoreZ_controllerPropertyP_gain(self._context)
        self.actual_tip_position = RootCoreZ_controllerPropertyActual_tip_position(self._context)
        self.feedback = RootCoreZ_controllerPropertyFeedback(self._context)
        self.actual_feedback_value = RootCoreZ_controllerPropertyActual_feedback_value(self._context)
        self.absolute_idle_position = RootCoreZ_controllerPropertyAbsolute_idle_position(self._context)
        self.i_gain = RootCoreZ_controllerPropertyI_gain(self._context)
        self.feedback_polarity = RootCoreZ_controllerPropertyFeedback_polarity(self._context)
        self.max_z_value = RootCoreZ_controllerPropertyMax_z_value(self._context)


class RootCoreZ_controllerSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.signal'


class RootCoreZ_controller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller'
        self.signal = RootCoreZ_controllerSignal(self._context)
        self.property = RootCoreZ_controllerProperty(self._context)

    def retract_tip(self, *args) -> Any:
        return self._context.call('root.core.z_controller.retract_tip', *args)

    def setpoint_limits_from_calibration(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_limits_from_calibration', *args)

    def tip_position_lower_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.tip_position_lower_limit', *args)

    def setpoint_upper_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_upper_limit', *args)


class RootCoreOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.oscilloscope'


class RootCoreCore_cantileverPropertySelected_cantilever_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.selected_cantilever_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.selected_cantilever_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_spring_constant.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.selected_cantilever_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_spring_constant.unit', str(new_val))


class RootCoreCore_cantileverPropertySelected_cantilever_deflection_sensitivity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.unit', str(new_val))


class RootCoreCore_cantileverProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property'
        self.selected_cantilever_deflection_sensitivity = RootCoreCore_cantileverPropertySelected_cantilever_deflection_sensitivity(self._context)
        self.selected_cantilever_spring_constant = RootCoreCore_cantileverPropertySelected_cantilever_spring_constant(self._context)


class RootCoreCore_cantilever(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever'
        self.property = RootCoreCore_cantileverProperty(self._context)

    def select_cantilever(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.select_cantilever', *args)

    def selected_cantilever(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.selected_cantilever', *args)

    def apply(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.apply', *args)


class RootCoreCore_options(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_options'


class RootCoreImaging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.imaging'


class RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_approach_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_advance_retract'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_front_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_front_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_front_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_front_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_left_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_left_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_left_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_left_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_right_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_right_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_right_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_right_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyRelative_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.relative_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.unit', str(new_val))


class RootCoreApproach_motors_driveProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property'
        self.relative_tip_position = RootCoreApproach_motors_drivePropertyRelative_tip_position(self._context)
        self.motor_speed = RootCoreApproach_motors_drivePropertyMotor_speed(self._context)
        self.motor_right_position = RootCoreApproach_motors_drivePropertyMotor_right_position(self._context)
        self.motor_left_position = RootCoreApproach_motors_drivePropertyMotor_left_position(self._context)
        self.motor_front_position = RootCoreApproach_motors_drivePropertyMotor_front_position(self._context)
        self.motor_speed_advance_retract = RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(self._context)
        self.motor_speed_approach_motors = RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(self._context)


class RootCoreApproach_motors_driveSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect', *args)


class RootCoreApproach_motors_driveSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect', *args)


class RootCoreApproach_motors_driveSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal'
        self.motor_move_finished = RootCoreApproach_motors_driveSignalMotor_move_finished(self._context)
        self.motor_move_started = RootCoreApproach_motors_driveSignalMotor_move_started(self._context)


class RootCoreApproach_motors_drive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive'
        self.signal = RootCoreApproach_motors_driveSignal(self._context)
        self.property = RootCoreApproach_motors_driveProperty(self._context)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.move_motors_by_step', *args)

    def reference_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.reference_motors', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.start_moving_motors', *args)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.stop_motors', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_search_step_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect', *args)


class RootCoreLaser_align_drive_implSignalCenter_detector_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.center_detector_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect', *args)


class RootCoreLaser_align_drive_implSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect', *args)


class RootCoreLaser_align_drive_implSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.procedure_info'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_pte_aligned'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect', *args)


class RootCoreLaser_align_drive_implSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.empty', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect_extended', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect', *args)


class RootCoreLaser_align_drive_implSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal'
        self.motor_move_started = RootCoreLaser_align_drive_implSignalMotor_move_started(self._context)
        self.auto_align_pte_aligned = RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(self._context)
        self.procedure_info = RootCoreLaser_align_drive_implSignalProcedure_info(self._context)
        self.motor_move_finished = RootCoreLaser_align_drive_implSignalMotor_move_finished(self._context)
        self.center_detector_finished = RootCoreLaser_align_drive_implSignalCenter_detector_finished(self._context)
        self.auto_align_finished = RootCoreLaser_align_drive_implSignalAuto_align_finished(self._context)
        self.auto_align_search_step_finished = RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(self._context)


class RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_beam_shifter_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        No_Error = 'No Error'
        Calibration_Error = 'Calibration Error'
        Sensor_Signal_Failed = 'Sensor Signal Failed'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_offset_calibration_status'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status.EnumType(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertySensor_status(wrap.CmdTreeProp):

    class EnumType(Enum):
        Undefined = 'Undefined'
        Low = 'Low'
        Ok = 'Ok'
        High = 'High'
        Fail = 'Fail'

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.sensor_status'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> EnumType:
        return RootCoreLaser_align_drive_implPropertySensor_status.EnumType(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.value'))

    @value.setter
    def value(self, new_val:EnumType):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.value', new_val.value)

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyScan_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.scan_mode'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.scan_mode.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.scan_mode.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_spot_intensity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_normal(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_normal'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_focus_z_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_lateral(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_lateral'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.unit', str(new_val))


class RootCoreLaser_align_drive_implProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property'
        self.deflection_lateral = RootCoreLaser_align_drive_implPropertyDeflection_lateral(self._context)
        self.motor_laser_focus_z_position = RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(self._context)
        self.motor_laser_readout_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(self._context)
        self.motor_laser_photodetector_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(self._context)
        self.deflection_normal = RootCoreLaser_align_drive_implPropertyDeflection_normal(self._context)
        self.motor_laser_readout_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(self._context)
        self.motor_laser_clean_drive_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(self._context)
        self.laser_readout_enabled = RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(self._context)
        self.motor_speed_max_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(self._context)
        self.laser_spot_intensity = RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(self._context)
        self.scan_mode = RootCoreLaser_align_drive_implPropertyScan_mode(self._context)
        self.sensor_status = RootCoreLaser_align_drive_implPropertySensor_status(self._context)
        self.motor_speed_max_laser_focus = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(self._context)
        self.laser_clean_drive_enabled = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(self._context)
        self.motor_speed_max_beam_shifter = RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(self._context)
        self.motor_speed_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(self._context)
        self.motor_laser_photodetector_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(self._context)
        self.laser_readout_power = RootCoreLaser_align_drive_implPropertyLaser_readout_power(self._context)
        self.deflection_offset_calibration_status = RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(self._context)
        self.laser_clean_drive_amplitude = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(self._context)
        self.motor_laser_clean_drive_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(self._context)
        self.laser_clean_drive_power = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(self._context)
        self.motor_beam_shifter_position = RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(self._context)


class RootCoreLaser_align_drive_impl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl'
        self.property = RootCoreLaser_align_drive_implProperty(self._context)
        self.signal = RootCoreLaser_align_drive_implSignal(self._context)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.move_motors_by_step', *args)

    def abort_center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_center_detector', *args)

    def start_move_to_optical_center(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_move_to_optical_center', *args)

    def start_optimizing(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_optimizing', *args)

    def auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.auto_align', *args)

    def abort_auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_auto_align', *args)

    def stop_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_updating_detector_status', *args)

    def start_search_algorithm(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_search_algorithm', *args)

    def reference_motor(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.reference_motor', *args)

    def start_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_updating_detector_status', *args)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_motors', *args)

    def center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.center_detector', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_moving_motors', *args)

    def zero_position(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.zero_position', *args)


class RootCore(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core'
        self.laser_align_drive_impl = RootCoreLaser_align_drive_impl(self._context)
        self.approach_motors_drive = RootCoreApproach_motors_drive(self._context)
        self.imaging = RootCoreImaging(self._context)
        self.core_options = RootCoreCore_options(self._context)
        self.core_cantilever = RootCoreCore_cantilever(self._context)
        self.oscilloscope = RootCoreOscilloscope(self._context)
        self.z_controller = RootCoreZ_controller(self._context)
        self.converter_channel_correction = RootCoreConverter_channel_correction(self._context)
        self.position_control = RootCorePosition_control(self._context)
        self.spectroscopy = RootCoreSpectroscopy(self._context)
        self.comp_dc = RootCoreComp_dc(self._context)
        self.scan_head_calibration = RootCoreScan_head_calibration(self._context)
        self.signal_analyzer1 = RootCoreSignal_analyzer1(self._context)
        self.approach = RootCoreApproach(self._context)
        self.acquisition = RootCoreAcquisition(self._context)
        self.signal_store = RootCoreSignal_store(self._context)
        self.frequency_sweep = RootCoreFrequency_sweep(self._context)
        self.thermal_tune = RootCoreThermal_tune(self._context)
        self.hv_amp_control = RootCoreHv_amp_control(self._context)
        self.core_environment = RootCoreCore_environment(self._context)
        self.ort = RootCoreOrt(self._context)
        self.direct_motor_control = RootCoreDirect_motor_control(self._context)
        self.core_monitoring = RootCoreCore_monitoring(self._context)


class RootSeqCxRbanaEventmgrSgleStartmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.startmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.startmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.startmask.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleAborteventmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.aborteventmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.aborteventmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.aborteventmask.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleEventsnapshot(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.eventsnapshot'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.eventsnapshot.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.eventsnapshot.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStatusAbortevent(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.status.abortevent'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStatusStopevent(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.status.stopevent'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.status'
        self.stopevent = RootSeqCxRbanaEventmgrSgleStatusStopevent(self._context)
        self.busy = RootSeqCxRbanaEventmgrSgleStatusBusy(self._context)
        self.abortevent = RootSeqCxRbanaEventmgrSgleStatusAbortevent(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleAndmask0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.andmask0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.andmask0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.andmask0.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStopeventmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.stopeventmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.stopeventmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.stopeventmask.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleEventvector(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.eventvector'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.eventvector.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.eventvector.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlSoftevent2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.softevent2'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlSoftevent1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.softevent1'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlSoftevent0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.softevent0'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlSoftevent3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.softevent3'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.start.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control'
        self.start = RootSeqCxRbanaEventmgrSgleControlStart(self._context)
        self.softevent3 = RootSeqCxRbanaEventmgrSgleControlSoftevent3(self._context)
        self.abort = RootSeqCxRbanaEventmgrSgleControlAbort(self._context)
        self.stop = RootSeqCxRbanaEventmgrSgleControlStop(self._context)
        self.softevent0 = RootSeqCxRbanaEventmgrSgleControlSoftevent0(self._context)
        self.softevent1 = RootSeqCxRbanaEventmgrSgleControlSoftevent1(self._context)
        self.softevent2 = RootSeqCxRbanaEventmgrSgleControlSoftevent2(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStopmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.stopmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.stopmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.stopmask.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle'
        self.stopmask = RootSeqCxRbanaEventmgrSgleStopmask(self._context)
        self.control = RootSeqCxRbanaEventmgrSgleControl(self._context)
        self.eventvector = RootSeqCxRbanaEventmgrSgleEventvector(self._context)
        self.stopeventmask = RootSeqCxRbanaEventmgrSgleStopeventmask(self._context)
        self.andmask0 = RootSeqCxRbanaEventmgrSgleAndmask0(self._context)
        self.status = RootSeqCxRbanaEventmgrSgleStatus(self._context)
        self.eventsnapshot = RootSeqCxRbanaEventmgrSgleEventsnapshot(self._context)
        self.aborteventmask = RootSeqCxRbanaEventmgrSgleAborteventmask(self._context)
        self.startmask = RootSeqCxRbanaEventmgrSgleStartmask(self._context)


class RootSeqCxRbanaEventmgr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr'
        self.sgle = RootSeqCxRbanaEventmgrSgle(self._context)


class RootSeqCxRbanaInchannelsdigiSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inchannelsdigi.sgle.control'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inchannelsdigi.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inchannelsdigi.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaInchannelsdigiSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inchannelsdigi.sgle'
        self.control = RootSeqCxRbanaInchannelsdigiSgleControl(self._context)


class RootSeqCxRbanaInchannelsdigi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inchannelsdigi'
        self.sgle = RootSeqCxRbanaInchannelsdigiSgle(self._context)


class RootSeqCxRbanaInfastcommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infastcommon'


class RootSeqCxRbanaInhiresCh10Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh10Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh10Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh10Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh10Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh10Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh10Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh10Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh10Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh10Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh10Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh10Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh10Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh10Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh10Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh10Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh10Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh10Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh10Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh10Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh10Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh10Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh10Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh10Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh10Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh10Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh9Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh9Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh9Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh9Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh9Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh9Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh9Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh9Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh9Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh9Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh9Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh9Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh9Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh9Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh9Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh9Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh9Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh9Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh9Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh9Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh9Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh9Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh9Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh9Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh9Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh9Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh11Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh11Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh11Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh11Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh11Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh11Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh11Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh11Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh11Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh11Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh11Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh11Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh11Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh11Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh11Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh11Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh11Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh11Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh11Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh11Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh11Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh11Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh11Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh11Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh11Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh11Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh12Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh12Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh12Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh12Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh12Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh12Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh12Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh12Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh12Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh12Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh12Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh12Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh12Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh12Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh12Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh12Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh12Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh12Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh12Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh12Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh12Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh12Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh12Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh12Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh12Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh12Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh3Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh3Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh3Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh3Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh3Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh3Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh3Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh3Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh3Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh3Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh3Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh3Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh3Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh3Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh3Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh3Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh3Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh3Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh3Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh3Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh3Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh3Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh3Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh3Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh3Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh3Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh7Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh7Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh7Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh7Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh7Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh7Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh7Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh7Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh7Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh7Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh7Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh7Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh7Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh7Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh7Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh7Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh7Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh7Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh7Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh7Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh7Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh7Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh7Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh7Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh7Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh7Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh1Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh1Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh1Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh1Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh1Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh1Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh1Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh1Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh1Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh1Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh1Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh1Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh1Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh1Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh1Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh1Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh1Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh1Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh1Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh1Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh1Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh1Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh1Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh1Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh1Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh1Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh5Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh5Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh5Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh5Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh5Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh5Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh5Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh5Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh5Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh5Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh5Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh5Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh5Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh5Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh5Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh5Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh5Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh5Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh5Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh5Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh5Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh5Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh5Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh5Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh5Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh5Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh8Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh8Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh8Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh8Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh8Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh8Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh8Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh8Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh8Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh8Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh8Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh8Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh8Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh8Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh8Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh8Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh8Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh8Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh8Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh8Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh8Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh8Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh8Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh8Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh8Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh8Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh6Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh6Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh6Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh6Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh6Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh6Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh6Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh6Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh6Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh6Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh6Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh6Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh6Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh6Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh6Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh6Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh6Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh6Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh6Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh6Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh6Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh6Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh6Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh6Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh6Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh6Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh2Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh2Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh2Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh2Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh2Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh2Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh2Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh2Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh2Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh2Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh2Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh2Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh2Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh2Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh2Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh2Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh2Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh2Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh2Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh2Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh2Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh2Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh2Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh2Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh2Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh2Cccoefy4(self._context)


class RootSeqCxRbanaInhiresCh4Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4'
        self.cccoefx1 = RootSeqCxRbanaInhiresCh4Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh4Cccoefy1(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh4Cccoefx3(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh4Cccoefx4(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh4Cccoefy3(self._context)
        self.cccoefz1 = RootSeqCxRbanaInhiresCh4Cccoefz1(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh4Cccoefs0(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh4Currentinval(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh4Inputoffset(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh4Cccoefs3(self._context)
        self.offset = RootSeqCxRbanaInhiresCh4Offset(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh4Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh4Cccoefy0(self._context)
        self.gain = RootSeqCxRbanaInhiresCh4Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh4Filterval(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh4Cccoefs4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh4Cccoefs1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh4Cccoefx2(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh4Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh4Cccoefz3(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh4Cccoefs2(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh4Cccoefz2(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh4Cccoefx0(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh4Cccoefz0(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh4Cccoefy4(self._context)


class RootSeqCxRbanaInhires(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires'
        self.ch4 = RootSeqCxRbanaInhiresCh4(self._context)
        self.ch2 = RootSeqCxRbanaInhiresCh2(self._context)
        self.ch6 = RootSeqCxRbanaInhiresCh6(self._context)
        self.ch8 = RootSeqCxRbanaInhiresCh8(self._context)
        self.ch5 = RootSeqCxRbanaInhiresCh5(self._context)
        self.ch1 = RootSeqCxRbanaInhiresCh1(self._context)
        self.ch7 = RootSeqCxRbanaInhiresCh7(self._context)
        self.ch3 = RootSeqCxRbanaInhiresCh3(self._context)
        self.ch12 = RootSeqCxRbanaInhiresCh12(self._context)
        self.ch11 = RootSeqCxRbanaInhiresCh11(self._context)
        self.ch9 = RootSeqCxRbanaInhiresCh9(self._context)
        self.ch10 = RootSeqCxRbanaInhiresCh10(self._context)


class RootSeqCxRbanaOrtSgleStatusAveraging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.status.averaging'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.status.averaging.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.status.averaging.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.status.averaging.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.status.averaging.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.status.averaging.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.status.averaging.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.status'
        self.averaging = RootSeqCxRbanaOrtSgleStatusAveraging(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleMinposition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.minposition'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.minposition.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.minposition.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleAmplitudesample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.amplitudesample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.amplitudesample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.amplitudesample.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleFreewavebeginsample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.freewavebeginsample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.freewavebeginsample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.freewavebeginsample.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleBaselineamplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.baselineamplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.baselineamplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.baselineamplitude.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleMinvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.minvalue.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleBaselinewindowendsample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.baselinewindowendsample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.baselinewindowendsample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.baselinewindowendsample.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlAveragestart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.averagestart'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestart.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestart.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestart.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestart.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestart.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestart.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlAveragestop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.averagestop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestop.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlFreewaveoutputenable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlEnablebaselinecontroller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlInputselect(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.inputselect'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.inputselect.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.inputselect.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.inputselect.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.inputselect.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.inputselect.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.inputselect.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlUpdatesamplevalues(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.updatesamplevalues'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control'
        self.updatesamplevalues = RootSeqCxRbanaOrtSgleControlUpdatesamplevalues(self._context)
        self.inputselect = RootSeqCxRbanaOrtSgleControlInputselect(self._context)
        self.enablebaselinecontroller = RootSeqCxRbanaOrtSgleControlEnablebaselinecontroller(self._context)
        self.freewaveoutputenable = RootSeqCxRbanaOrtSgleControlFreewaveoutputenable(self._context)
        self.averagestop = RootSeqCxRbanaOrtSgleControlAveragestop(self._context)
        self.averagestart = RootSeqCxRbanaOrtSgleControlAveragestart(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleSamplesperperiodSamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleSamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.samplesperperiod'
        self.samplesperperiod = RootSeqCxRbanaOrtSgleSamplesperperiodSamplesperperiod(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.samplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.samplesperperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleCantileversamplesperperiodSamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleCantileversamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod'
        self.samplesperperiod = RootSeqCxRbanaOrtSgleCantileversamplesperperiodSamplesperperiod(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleAverageperiodsAverageperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleAverageperiods(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.averageperiods'
        self.averageperiod = RootSeqCxRbanaOrtSgleAverageperiodsAverageperiod(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.averageperiods.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.averageperiods.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleAmplitudereduction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.amplitudereduction'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.amplitudereduction.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.amplitudereduction.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleExcitationamplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.excitationamplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.excitationamplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.excitationamplitude.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleBaselinemultiplier(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.baselinemultiplier'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.baselinemultiplier.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.baselinemultiplier.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleBaselinewindowbeginsample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.baselinewindowbeginsample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.baselinewindowbeginsample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.baselinewindowbeginsample.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle'
        self.baselinewindowbeginsample = RootSeqCxRbanaOrtSgleBaselinewindowbeginsample(self._context)
        self.baselinemultiplier = RootSeqCxRbanaOrtSgleBaselinemultiplier(self._context)
        self.excitationamplitude = RootSeqCxRbanaOrtSgleExcitationamplitude(self._context)
        self.amplitudereduction = RootSeqCxRbanaOrtSgleAmplitudereduction(self._context)
        self.averageperiods = RootSeqCxRbanaOrtSgleAverageperiods(self._context)
        self.cantileversamplesperperiod = RootSeqCxRbanaOrtSgleCantileversamplesperperiod(self._context)
        self.samplesperperiod = RootSeqCxRbanaOrtSgleSamplesperperiod(self._context)
        self.control = RootSeqCxRbanaOrtSgleControl(self._context)
        self.baselinewindowendsample = RootSeqCxRbanaOrtSgleBaselinewindowendsample(self._context)
        self.minvalue = RootSeqCxRbanaOrtSgleMinvalue(self._context)
        self.baselineamplitude = RootSeqCxRbanaOrtSgleBaselineamplitude(self._context)
        self.freewavebeginsample = RootSeqCxRbanaOrtSgleFreewavebeginsample(self._context)
        self.amplitudesample = RootSeqCxRbanaOrtSgleAmplitudesample(self._context)
        self.minposition = RootSeqCxRbanaOrtSgleMinposition(self._context)
        self.status = RootSeqCxRbanaOrtSgleStatus(self._context)


class RootSeqCxRbanaOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort'
        self.sgle = RootSeqCxRbanaOrtSgle(self._context)


class RootSeqCxRbanaOutfastcommonSgleDampinggain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.dampinggain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.dampinggain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.dampinggain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddamping1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddamping3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddamping2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlSelectout1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.selectout1'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlSelectout2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.selectout2'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlSelectout3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.selectout3'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddamping4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlSelectout4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.selectout4'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control'
        self.adddigitalhiresmodulation3 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation3(self._context)
        self.selectout4 = RootSeqCxRbanaOutfastcommonSgleControlSelectout4(self._context)
        self.adddigitalhiresmodulation4 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation4(self._context)
        self.adddamping4 = RootSeqCxRbanaOutfastcommonSgleControlAdddamping4(self._context)
        self.selectout3 = RootSeqCxRbanaOutfastcommonSgleControlSelectout3(self._context)
        self.adddigitalmodulation1 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation1(self._context)
        self.adddigitalmodulation3 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation3(self._context)
        self.adddigitalmodulation4 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation4(self._context)
        self.selectout2 = RootSeqCxRbanaOutfastcommonSgleControlSelectout2(self._context)
        self.selectout1 = RootSeqCxRbanaOutfastcommonSgleControlSelectout1(self._context)
        self.adddigitalmodulation2 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation2(self._context)
        self.adddamping2 = RootSeqCxRbanaOutfastcommonSgleControlAdddamping2(self._context)
        self.adddigitalhiresmodulation2 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation2(self._context)
        self.adddamping3 = RootSeqCxRbanaOutfastcommonSgleControlAdddamping3(self._context)
        self.adddigitalhiresmodulation1 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation1(self._context)
        self.adddamping1 = RootSeqCxRbanaOutfastcommonSgleControlAdddamping1(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle'
        self.control = RootSeqCxRbanaOutfastcommonSgleControl(self._context)
        self.dampinggain = RootSeqCxRbanaOutfastcommonSgleDampinggain(self._context)


class RootSeqCxRbanaOutfastcommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon'
        self.sgle = RootSeqCxRbanaOutfastcommonSgle(self._context)


class RootSeqCxRbanaInhirescommonSgleControlCh3bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh10bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh1bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh12bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh5bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh11bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh7bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh4bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh2bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh6bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh9bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh8bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control'
        self.ch8bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh8bypassfilter(self._context)
        self.ch9bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh9bypassfilter(self._context)
        self.ch6bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh6bypassfilter(self._context)
        self.ch2bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh2bypassfilter(self._context)
        self.ch4bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh4bypassfilter(self._context)
        self.ch7bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh7bypassfilter(self._context)
        self.ch11bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh11bypassfilter(self._context)
        self.ch5bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh5bypassfilter(self._context)
        self.ch12bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh12bypassfilter(self._context)
        self.ch1bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh1bypassfilter(self._context)
        self.ch10bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh10bypassfilter(self._context)
        self.ch3bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh3bypassfilter(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleAafcoefAddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleAafcoefData(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleAafcoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.aafcoef'
        self.data = RootSeqCxRbanaInhirescommonSgleAafcoefData(self._context)
        self.addr = RootSeqCxRbanaInhirescommonSgleAafcoefAddr(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle'
        self.aafcoef = RootSeqCxRbanaInhirescommonSgleAafcoef(self._context)
        self.control = RootSeqCxRbanaInhirescommonSgleControl(self._context)


class RootSeqCxRbanaInhirescommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon'
        self.sgle = RootSeqCxRbanaInhirescommonSgle(self._context)


class RootSeqCxRbanaInfastCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.gain.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.offset.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3'
        self.cccoefx1 = RootSeqCxRbanaInfastCh3Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInfastCh3Cccoefy1(self._context)
        self.cccoefy2 = RootSeqCxRbanaInfastCh3Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInfastCh3Cccoefy0(self._context)
        self.cccoefx0 = RootSeqCxRbanaInfastCh3Cccoefx0(self._context)
        self.cccoefz1 = RootSeqCxRbanaInfastCh3Cccoefz1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInfastCh3Cccoefx2(self._context)
        self.currentinval = RootSeqCxRbanaInfastCh3Currentinval(self._context)
        self.cccoefz2 = RootSeqCxRbanaInfastCh3Cccoefz2(self._context)
        self.offset = RootSeqCxRbanaInfastCh3Offset(self._context)
        self.cccoefz0 = RootSeqCxRbanaInfastCh3Cccoefz0(self._context)
        self.gain = RootSeqCxRbanaInfastCh3Gain(self._context)


class RootSeqCxRbanaInfastCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.gain.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.offset.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2'
        self.cccoefx1 = RootSeqCxRbanaInfastCh2Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInfastCh2Cccoefy1(self._context)
        self.cccoefy2 = RootSeqCxRbanaInfastCh2Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInfastCh2Cccoefy0(self._context)
        self.cccoefx0 = RootSeqCxRbanaInfastCh2Cccoefx0(self._context)
        self.cccoefz1 = RootSeqCxRbanaInfastCh2Cccoefz1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInfastCh2Cccoefx2(self._context)
        self.currentinval = RootSeqCxRbanaInfastCh2Currentinval(self._context)
        self.cccoefz2 = RootSeqCxRbanaInfastCh2Cccoefz2(self._context)
        self.offset = RootSeqCxRbanaInfastCh2Offset(self._context)
        self.cccoefz0 = RootSeqCxRbanaInfastCh2Cccoefz0(self._context)
        self.gain = RootSeqCxRbanaInfastCh2Gain(self._context)


class RootSeqCxRbanaInfastCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.gain.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.offset.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1'
        self.cccoefx1 = RootSeqCxRbanaInfastCh1Cccoefx1(self._context)
        self.cccoefy1 = RootSeqCxRbanaInfastCh1Cccoefy1(self._context)
        self.cccoefy2 = RootSeqCxRbanaInfastCh1Cccoefy2(self._context)
        self.cccoefy0 = RootSeqCxRbanaInfastCh1Cccoefy0(self._context)
        self.cccoefx0 = RootSeqCxRbanaInfastCh1Cccoefx0(self._context)
        self.cccoefz1 = RootSeqCxRbanaInfastCh1Cccoefz1(self._context)
        self.cccoefx2 = RootSeqCxRbanaInfastCh1Cccoefx2(self._context)
        self.currentinval = RootSeqCxRbanaInfastCh1Currentinval(self._context)
        self.cccoefz2 = RootSeqCxRbanaInfastCh1Cccoefz2(self._context)
        self.offset = RootSeqCxRbanaInfastCh1Offset(self._context)
        self.cccoefz0 = RootSeqCxRbanaInfastCh1Cccoefz0(self._context)
        self.gain = RootSeqCxRbanaInfastCh1Gain(self._context)


class RootSeqCxRbanaInfast(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast'
        self.ch1 = RootSeqCxRbanaInfastCh1(self._context)
        self.ch2 = RootSeqCxRbanaInfastCh2(self._context)
        self.ch3 = RootSeqCxRbanaInfastCh3(self._context)


class RootSeqCxRbanaOuthiresCh10Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh10ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh10ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh10ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh10ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10'
        self.gain = RootSeqCxRbanaOuthiresCh10Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh10Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh10Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh10Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh10Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh10Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh10Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh10Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh10Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh9Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh9ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh9ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh9ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh9ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9'
        self.gain = RootSeqCxRbanaOuthiresCh9Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh9Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh9Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh9Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh9Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh9Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh9Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh9Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh9Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh11Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh11ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh11ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh11ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh11ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11'
        self.gain = RootSeqCxRbanaOuthiresCh11Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh11Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh11Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh11Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh11Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh11Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh11Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh11Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh11Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh12Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh12ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh12ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh12ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh12ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12'
        self.gain = RootSeqCxRbanaOuthiresCh12Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh12Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh12Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh12Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh12Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh12Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh12Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh12Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh12Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh3Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh3ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh3ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh3ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh3ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3'
        self.gain = RootSeqCxRbanaOuthiresCh3Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh3Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh3Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh3Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh3Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh3Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh3Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh3Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh3Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh7Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh7ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh7ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh7ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh7ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7'
        self.gain = RootSeqCxRbanaOuthiresCh7Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh7Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh7Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh7Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh7Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh7Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh7Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh7Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh7Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh1Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh1ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh1ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh1ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh1ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1'
        self.gain = RootSeqCxRbanaOuthiresCh1Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh1Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh1Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh1Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh1Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh1Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh1Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh1Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh1Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh5Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh5ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh5ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh5ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh5ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5'
        self.gain = RootSeqCxRbanaOuthiresCh5Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh5Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh5Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh5Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh5Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh5Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh5Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh5Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh5Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh8Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh8ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh8ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh8ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh8ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8'
        self.gain = RootSeqCxRbanaOuthiresCh8Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh8Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh8Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh8Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh8Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh8Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh8Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh8Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh8Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh6Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh6ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh6ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh6ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh6ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6'
        self.gain = RootSeqCxRbanaOuthiresCh6Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh6Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh6Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh6Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh6Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh6Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh6Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh6Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh6Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh2Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh2ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh2ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh2ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh2ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2'
        self.gain = RootSeqCxRbanaOuthiresCh2Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh2Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh2Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh2Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh2Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh2Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh2Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh2Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh2Glitchcorr(self._context)


class RootSeqCxRbanaOuthiresCh4Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control.selectout'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.selectout.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control.bypassfilter'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control.glitchcorr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control'
        self.glitchcorr = RootSeqCxRbanaOuthiresCh4ControlGlitchcorr(self._context)
        self.bypassfilter = RootSeqCxRbanaOuthiresCh4ControlBypassfilter(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh4ControlAdddigitalmodulation(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh4ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4'
        self.gain = RootSeqCxRbanaOuthiresCh4Gain(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh4Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh4Currentoutval(self._context)
        self.control = RootSeqCxRbanaOuthiresCh4Control(self._context)
        self.slewrate = RootSeqCxRbanaOuthiresCh4Slewrate(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh4Offset(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh4Lowordgaincorr(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh4Filterval(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh4Glitchcorr(self._context)


class RootSeqCxRbanaOuthires(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires'
        self.ch4 = RootSeqCxRbanaOuthiresCh4(self._context)
        self.ch2 = RootSeqCxRbanaOuthiresCh2(self._context)
        self.ch6 = RootSeqCxRbanaOuthiresCh6(self._context)
        self.ch8 = RootSeqCxRbanaOuthiresCh8(self._context)
        self.ch5 = RootSeqCxRbanaOuthiresCh5(self._context)
        self.ch1 = RootSeqCxRbanaOuthiresCh1(self._context)
        self.ch7 = RootSeqCxRbanaOuthiresCh7(self._context)
        self.ch3 = RootSeqCxRbanaOuthiresCh3(self._context)
        self.ch12 = RootSeqCxRbanaOuthiresCh12(self._context)
        self.ch11 = RootSeqCxRbanaOuthiresCh11(self._context)
        self.ch9 = RootSeqCxRbanaOuthiresCh9(self._context)
        self.ch10 = RootSeqCxRbanaOuthiresCh10(self._context)


class RootSeqCxRbanaInternaSgleControlRst8chconverters(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna.sgle.control.rst8chconverters'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.regaddr', int(new_val))


class RootSeqCxRbanaInternaSgleControlStatusled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna.sgle.control.statusled'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.statusled.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.statusled.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.statusled.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.statusled.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.statusled.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.statusled.regaddr', int(new_val))


class RootSeqCxRbanaInternaSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna.sgle.control'
        self.statusled = RootSeqCxRbanaInternaSgleControlStatusled(self._context)
        self.rst8chconverters = RootSeqCxRbanaInternaSgleControlRst8chconverters(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaInternaSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna.sgle'
        self.control = RootSeqCxRbanaInternaSgleControl(self._context)


class RootSeqCxRbanaInterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna'
        self.sgle = RootSeqCxRbanaInternaSgle(self._context)


class RootSeqCxRbanaOutfastCh3Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch3.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch3.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh3Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch3.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch3.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch3.offset.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch3.gain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3'
        self.gain = RootSeqCxRbanaOutfastCh3Gain(self._context)
        self.offset = RootSeqCxRbanaOutfastCh3Offset(self._context)
        self.testvalue = RootSeqCxRbanaOutfastCh3Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOutfastCh3Currentoutval(self._context)


class RootSeqCxRbanaOutfastCh2Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch2.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch2.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh2Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch2.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch2.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch2.offset.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch2.gain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2'
        self.gain = RootSeqCxRbanaOutfastCh2Gain(self._context)
        self.offset = RootSeqCxRbanaOutfastCh2Offset(self._context)
        self.testvalue = RootSeqCxRbanaOutfastCh2Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOutfastCh2Currentoutval(self._context)


class RootSeqCxRbanaOutfastCh1Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch1.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch1.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh1Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch1.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch1.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch1.offset.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch1.gain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1'
        self.gain = RootSeqCxRbanaOutfastCh1Gain(self._context)
        self.offset = RootSeqCxRbanaOutfastCh1Offset(self._context)
        self.testvalue = RootSeqCxRbanaOutfastCh1Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOutfastCh1Currentoutval(self._context)


class RootSeqCxRbanaOutfastCh4Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch4.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch4.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh4Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch4.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch4.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh4Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch4.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch4.offset.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh4Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch4.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch4.gain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4'
        self.gain = RootSeqCxRbanaOutfastCh4Gain(self._context)
        self.offset = RootSeqCxRbanaOutfastCh4Offset(self._context)
        self.testvalue = RootSeqCxRbanaOutfastCh4Testvalue(self._context)
        self.currentoutval = RootSeqCxRbanaOutfastCh4Currentoutval(self._context)


class RootSeqCxRbanaOutfast(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast'
        self.ch4 = RootSeqCxRbanaOutfastCh4(self._context)
        self.ch1 = RootSeqCxRbanaOutfastCh1(self._context)
        self.ch2 = RootSeqCxRbanaOutfastCh2(self._context)
        self.ch3 = RootSeqCxRbanaOutfastCh3(self._context)


class RootSeqCxRbanaUserioSgleDigitalin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.digitalin'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.digitalin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.digitalin.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlOut1src(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.out1src'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1src.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1src.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1src.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1src.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1src.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1src.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlOut2level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.out2level'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2level.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2level.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2level.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2level.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2level.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlOut1level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.out1level'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1level.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1level.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1level.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1level.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1level.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlOut2type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.out2type'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2type.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2type.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2type.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2type.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2type.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2type.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlIn2enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.in2enable'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.in2enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.in2enable.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.in2enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.in2enable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.in2enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.in2enable.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlOut2src(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.out2src'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2src.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2src.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2src.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2src.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2src.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2src.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlOut1type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.out1type'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1type.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1type.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1type.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1type.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1type.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1type.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlOut2enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.out2enable'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2enable.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2enable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out2enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out2enable.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlOut1enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.out1enable'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1enable.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1enable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.out1enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.out1enable.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControlIn1enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control.in1enable'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.in1enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.in1enable.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.in1enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.in1enable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.in1enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.in1enable.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle.control'
        self.in1enable = RootSeqCxRbanaUserioSgleControlIn1enable(self._context)
        self.out1enable = RootSeqCxRbanaUserioSgleControlOut1enable(self._context)
        self.out2enable = RootSeqCxRbanaUserioSgleControlOut2enable(self._context)
        self.out1type = RootSeqCxRbanaUserioSgleControlOut1type(self._context)
        self.out2src = RootSeqCxRbanaUserioSgleControlOut2src(self._context)
        self.in2enable = RootSeqCxRbanaUserioSgleControlIn2enable(self._context)
        self.out2type = RootSeqCxRbanaUserioSgleControlOut2type(self._context)
        self.out1level = RootSeqCxRbanaUserioSgleControlOut1level(self._context)
        self.out2level = RootSeqCxRbanaUserioSgleControlOut2level(self._context)
        self.out1src = RootSeqCxRbanaUserioSgleControlOut1src(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.userio.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.userio.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaUserioSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio.sgle'
        self.control = RootSeqCxRbanaUserioSgleControl(self._context)
        self.digitalin = RootSeqCxRbanaUserioSgleDigitalin(self._context)


class RootSeqCxRbanaUserio(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.userio'
        self.sgle = RootSeqCxRbanaUserioSgle(self._context)


class RootSeqCxRbanaRampgenTipvoltageStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.countup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status'
        self.countup = RootSeqCxRbanaRampgenTipvoltageStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenTipvoltageStatusReachedupperlimit(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenTipvoltageStatusReachedlowerlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenTipvoltageStatusReachedregularend(self._context)
        self.busy = RootSeqCxRbanaRampgenTipvoltageStatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.mode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.init'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.init.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control'
        self.start = RootSeqCxRbanaRampgenTipvoltageControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenTipvoltageControlAbort(self._context)
        self.init = RootSeqCxRbanaRampgenTipvoltageControlInit(self._context)
        self.stop = RootSeqCxRbanaRampgenTipvoltageControlStop(self._context)
        self.mode = RootSeqCxRbanaRampgenTipvoltageControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage'
        self.control = RootSeqCxRbanaRampgenTipvoltageControl(self._context)
        self.out = RootSeqCxRbanaRampgenTipvoltageOut(self._context)
        self.limit_pos = RootSeqCxRbanaRampgenTipvoltageLimit_pos(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenTipvoltageLimit_neg(self._context)
        self.value = RootSeqCxRbanaRampgenTipvoltageValue(self._context)
        self.increment = RootSeqCxRbanaRampgenTipvoltageIncrement(self._context)
        self.status = RootSeqCxRbanaRampgenTipvoltageStatus(self._context)


class RootSeqCxRbanaRampgenUser4StatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4StatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.reachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4StatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4StatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4StatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.countup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.countup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status'
        self.countup = RootSeqCxRbanaRampgenUser4StatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenUser4StatusReachedupperlimit(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenUser4StatusReachedlowerlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenUser4StatusReachedregularend(self._context)
        self.busy = RootSeqCxRbanaRampgenUser4StatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Increment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Limit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Limit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Out(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.mode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.mode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.init'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.init.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control'
        self.start = RootSeqCxRbanaRampgenUser4ControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenUser4ControlAbort(self._context)
        self.init = RootSeqCxRbanaRampgenUser4ControlInit(self._context)
        self.stop = RootSeqCxRbanaRampgenUser4ControlStop(self._context)
        self.mode = RootSeqCxRbanaRampgenUser4ControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4'
        self.control = RootSeqCxRbanaRampgenUser4Control(self._context)
        self.out = RootSeqCxRbanaRampgenUser4Out(self._context)
        self.limit_pos = RootSeqCxRbanaRampgenUser4Limit_pos(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenUser4Limit_neg(self._context)
        self.value = RootSeqCxRbanaRampgenUser4Value(self._context)
        self.increment = RootSeqCxRbanaRampgenUser4Increment(self._context)
        self.status = RootSeqCxRbanaRampgenUser4Status(self._context)


class RootSeqCxRbanaRampgenPlanezStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.reachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.countup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.countup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status'
        self.countup = RootSeqCxRbanaRampgenPlanezStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenPlanezStatusReachedupperlimit(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenPlanezStatusReachedlowerlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenPlanezStatusReachedregularend(self._context)
        self.busy = RootSeqCxRbanaRampgenPlanezStatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.mode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.mode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.init'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.init.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control'
        self.start = RootSeqCxRbanaRampgenPlanezControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenPlanezControlAbort(self._context)
        self.init = RootSeqCxRbanaRampgenPlanezControlInit(self._context)
        self.stop = RootSeqCxRbanaRampgenPlanezControlStop(self._context)
        self.mode = RootSeqCxRbanaRampgenPlanezControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanez(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez'
        self.control = RootSeqCxRbanaRampgenPlanezControl(self._context)
        self.out = RootSeqCxRbanaRampgenPlanezOut(self._context)
        self.limit_pos = RootSeqCxRbanaRampgenPlanezLimit_pos(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenPlanezLimit_neg(self._context)
        self.value = RootSeqCxRbanaRampgenPlanezValue(self._context)
        self.increment = RootSeqCxRbanaRampgenPlanezIncrement(self._context)
        self.status = RootSeqCxRbanaRampgenPlanezStatus(self._context)


class RootSeqCxRbanaRampgenPositionxStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.reachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.countup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.countup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status'
        self.countup = RootSeqCxRbanaRampgenPositionxStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenPositionxStatusReachedupperlimit(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenPositionxStatusReachedlowerlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenPositionxStatusReachedregularend(self._context)
        self.busy = RootSeqCxRbanaRampgenPositionxStatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.mode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.mode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.init'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.init.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control'
        self.start = RootSeqCxRbanaRampgenPositionxControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenPositionxControlAbort(self._context)
        self.init = RootSeqCxRbanaRampgenPositionxControlInit(self._context)
        self.stop = RootSeqCxRbanaRampgenPositionxControlStop(self._context)
        self.mode = RootSeqCxRbanaRampgenPositionxControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionx(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx'
        self.control = RootSeqCxRbanaRampgenPositionxControl(self._context)
        self.out = RootSeqCxRbanaRampgenPositionxOut(self._context)
        self.limit_pos = RootSeqCxRbanaRampgenPositionxLimit_pos(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenPositionxLimit_neg(self._context)
        self.value = RootSeqCxRbanaRampgenPositionxValue(self._context)
        self.increment = RootSeqCxRbanaRampgenPositionxIncrement(self._context)
        self.status = RootSeqCxRbanaRampgenPositionxStatus(self._context)


class RootSeqCxRbanaRampgenTestStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.reachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.reachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.countup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.countup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status'
        self.countup = RootSeqCxRbanaRampgenTestStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenTestStatusReachedupperlimit(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenTestStatusReachedlowerlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenTestStatusReachedregularend(self._context)
        self.busy = RootSeqCxRbanaRampgenTestStatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.mode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.mode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.init'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.init.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control'
        self.start = RootSeqCxRbanaRampgenTestControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenTestControlAbort(self._context)
        self.init = RootSeqCxRbanaRampgenTestControlInit(self._context)
        self.stop = RootSeqCxRbanaRampgenTestControlStop(self._context)
        self.mode = RootSeqCxRbanaRampgenTestControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test'
        self.control = RootSeqCxRbanaRampgenTestControl(self._context)
        self.out = RootSeqCxRbanaRampgenTestOut(self._context)
        self.limit_pos = RootSeqCxRbanaRampgenTestLimit_pos(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenTestLimit_neg(self._context)
        self.value = RootSeqCxRbanaRampgenTestValue(self._context)
        self.increment = RootSeqCxRbanaRampgenTestIncrement(self._context)
        self.status = RootSeqCxRbanaRampgenTestStatus(self._context)


class RootSeqCxRbanaRampgenApproachStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.reachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.countup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.countup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status'
        self.countup = RootSeqCxRbanaRampgenApproachStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenApproachStatusReachedupperlimit(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenApproachStatusReachedlowerlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenApproachStatusReachedregularend(self._context)
        self.busy = RootSeqCxRbanaRampgenApproachStatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.mode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.mode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.init'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.init.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control'
        self.start = RootSeqCxRbanaRampgenApproachControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenApproachControlAbort(self._context)
        self.init = RootSeqCxRbanaRampgenApproachControlInit(self._context)
        self.stop = RootSeqCxRbanaRampgenApproachControlStop(self._context)
        self.mode = RootSeqCxRbanaRampgenApproachControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach'
        self.control = RootSeqCxRbanaRampgenApproachControl(self._context)
        self.out = RootSeqCxRbanaRampgenApproachOut(self._context)
        self.limit_pos = RootSeqCxRbanaRampgenApproachLimit_pos(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenApproachLimit_neg(self._context)
        self.value = RootSeqCxRbanaRampgenApproachValue(self._context)
        self.increment = RootSeqCxRbanaRampgenApproachIncrement(self._context)
        self.status = RootSeqCxRbanaRampgenApproachStatus(self._context)


class RootSeqCxRbanaRampgenAlternatezStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.countup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.countup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status'
        self.countup = RootSeqCxRbanaRampgenAlternatezStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenAlternatezStatusReachedupperlimit(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenAlternatezStatusReachedlowerlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenAlternatezStatusReachedregularend(self._context)
        self.busy = RootSeqCxRbanaRampgenAlternatezStatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.mode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.mode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.init'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.init.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control'
        self.start = RootSeqCxRbanaRampgenAlternatezControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenAlternatezControlAbort(self._context)
        self.init = RootSeqCxRbanaRampgenAlternatezControlInit(self._context)
        self.stop = RootSeqCxRbanaRampgenAlternatezControlStop(self._context)
        self.mode = RootSeqCxRbanaRampgenAlternatezControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatez(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez'
        self.control = RootSeqCxRbanaRampgenAlternatezControl(self._context)
        self.out = RootSeqCxRbanaRampgenAlternatezOut(self._context)
        self.limit_pos = RootSeqCxRbanaRampgenAlternatezLimit_pos(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenAlternatezLimit_neg(self._context)
        self.value = RootSeqCxRbanaRampgenAlternatezValue(self._context)
        self.increment = RootSeqCxRbanaRampgenAlternatezIncrement(self._context)
        self.status = RootSeqCxRbanaRampgenAlternatezStatus(self._context)


class RootSeqCxRbanaRampgenPositionyStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.reachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.countup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.countup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status'
        self.countup = RootSeqCxRbanaRampgenPositionyStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenPositionyStatusReachedupperlimit(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenPositionyStatusReachedlowerlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenPositionyStatusReachedregularend(self._context)
        self.busy = RootSeqCxRbanaRampgenPositionyStatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.mode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.mode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.init'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.init.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control'
        self.start = RootSeqCxRbanaRampgenPositionyControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenPositionyControlAbort(self._context)
        self.init = RootSeqCxRbanaRampgenPositionyControlInit(self._context)
        self.stop = RootSeqCxRbanaRampgenPositionyControlStop(self._context)
        self.mode = RootSeqCxRbanaRampgenPositionyControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositiony(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony'
        self.control = RootSeqCxRbanaRampgenPositionyControl(self._context)
        self.out = RootSeqCxRbanaRampgenPositionyOut(self._context)
        self.limit_pos = RootSeqCxRbanaRampgenPositionyLimit_pos(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenPositionyLimit_neg(self._context)
        self.value = RootSeqCxRbanaRampgenPositionyValue(self._context)
        self.increment = RootSeqCxRbanaRampgenPositionyIncrement(self._context)
        self.status = RootSeqCxRbanaRampgenPositionyStatus(self._context)


class RootSeqCxRbanaRampgenMaxzStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.busy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.busy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.reachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.countup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.countup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status'
        self.countup = RootSeqCxRbanaRampgenMaxzStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenMaxzStatusReachedupperlimit(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenMaxzStatusReachedlowerlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenMaxzStatusReachedregularend(self._context)
        self.busy = RootSeqCxRbanaRampgenMaxzStatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.mode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.mode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.init'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.init.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control'
        self.start = RootSeqCxRbanaRampgenMaxzControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenMaxzControlAbort(self._context)
        self.init = RootSeqCxRbanaRampgenMaxzControlInit(self._context)
        self.stop = RootSeqCxRbanaRampgenMaxzControlStop(self._context)
        self.mode = RootSeqCxRbanaRampgenMaxzControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz'
        self.control = RootSeqCxRbanaRampgenMaxzControl(self._context)
        self.out = RootSeqCxRbanaRampgenMaxzOut(self._context)
        self.limit_pos = RootSeqCxRbanaRampgenMaxzLimit_pos(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenMaxzLimit_neg(self._context)
        self.value = RootSeqCxRbanaRampgenMaxzValue(self._context)
        self.increment = RootSeqCxRbanaRampgenMaxzIncrement(self._context)
        self.status = RootSeqCxRbanaRampgenMaxzStatus(self._context)


class RootSeqCxRbanaRampgen(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen'
        self.maxz = RootSeqCxRbanaRampgenMaxz(self._context)
        self.positiony = RootSeqCxRbanaRampgenPositiony(self._context)
        self.alternatez = RootSeqCxRbanaRampgenAlternatez(self._context)
        self.approach = RootSeqCxRbanaRampgenApproach(self._context)
        self.test = RootSeqCxRbanaRampgenTest(self._context)
        self.positionx = RootSeqCxRbanaRampgenPositionx(self._context)
        self.planez = RootSeqCxRbanaRampgenPlanez(self._context)
        self.user4 = RootSeqCxRbanaRampgenUser4(self._context)
        self.tipvoltage = RootSeqCxRbanaRampgenTipvoltage(self._context)


class RootSeqCxRbanaOuthirescommonSgleGpfiltrcoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.gpfiltrcoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.gpfiltrcoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.gpfiltrcoef.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleGpfiltraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.gpfiltraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.gpfiltraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.gpfiltraddr.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleControlGpflt_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleControlOuthires_dac8delay(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleControlSelectmod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.control.selectmod'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.control'
        self.selectmod = RootSeqCxRbanaOuthirescommonSgleControlSelectmod(self._context)
        self.outhires_dac8delay = RootSeqCxRbanaOuthirescommonSgleControlOuthires_dac8delay(self._context)
        self.gpflt_vld = RootSeqCxRbanaOuthirescommonSgleControlGpflt_vld(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle'
        self.control = RootSeqCxRbanaOuthirescommonSgleControl(self._context)
        self.gpfiltraddr = RootSeqCxRbanaOuthirescommonSgleGpfiltraddr(self._context)
        self.gpfiltrcoef = RootSeqCxRbanaOuthirescommonSgleGpfiltrcoef(self._context)


class RootSeqCxRbanaOuthirescommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon'
        self.sgle = RootSeqCxRbanaOuthirescommonSgle(self._context)


class RootSeqCxRbanaAnalyzerTwoDeltafoffs_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.deltafoffs_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.deltafoffs_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.deltafoffs_hi.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoFltrcoeff(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.fltrcoeff'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.fltrcoeff.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.fltrcoeff.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiampkel.factor'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.factor.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiampkel.shift'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shift.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiampkel'
        self.shift = RootSeqCxRbanaAnalyzerTwoKiampkelShift(self._context)
        self.shiftdirection = RootSeqCxRbanaAnalyzerTwoKiampkelShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerTwoKiampkelFactor(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoFlag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.flag'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.flag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.flag.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpctrlmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsPhaseclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsPhasectrl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpctrlpositiveaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbits(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits'
        self.ampctrlpositiveaccu = RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpctrlpositiveaccu(self._context)
        self.ampclearaccu = RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpclearaccu(self._context)
        self.phasectrl = RootSeqCxRbanaAnalyzerTwoCtrlbitsPhasectrl(self._context)
        self.phaseclearaccu = RootSeqCxRbanaAnalyzerTwoCtrlbitsPhaseclearaccu(self._context)
        self.ampctrlmode = RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpctrlmode(self._context)
        self.ampmodulation = RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoLockrangeshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.lockrangeshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.lockrangeshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.lockrangeshift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpphase.factor'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.factor.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpphase.shift'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shift.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpphase'
        self.shift = RootSeqCxRbanaAnalyzerTwoKpphaseShift(self._context)
        self.shiftdirection = RootSeqCxRbanaAnalyzerTwoKpphaseShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerTwoKpphaseFactor(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpampkel.factor'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.factor.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpampkel.shift'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shift.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpampkel'
        self.shift = RootSeqCxRbanaAnalyzerTwoKpampkelShift(self._context)
        self.shiftdirection = RootSeqCxRbanaAnalyzerTwoKpampkelShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerTwoKpampkelFactor(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.modampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.modampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.modampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoAmplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.amplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.amplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.amplitude.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModeOpmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode.opmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.opmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.opmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.opmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.opmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.opmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.opmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModePhasedetref(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode.phasedetref'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.phasedetref.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.phasedetref.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.phasedetref.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.phasedetref.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.phasedetref.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.phasedetref.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModeInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode.input'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.input.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.input.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.input.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.input.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.input.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.input.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModeAnalyzerinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode.analyzerinput'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode'
        self.analyzerinput = RootSeqCxRbanaAnalyzerTwoModeAnalyzerinput(self._context)
        self.input = RootSeqCxRbanaAnalyzerTwoModeInput(self._context)
        self.phasedetref = RootSeqCxRbanaAnalyzerTwoModePhasedetref(self._context)
        self.opmode = RootSeqCxRbanaAnalyzerTwoModeOpmode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoPhaseshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.phaseshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.phaseshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.phaseshift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetipSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip.safetip'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetip.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetip.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetipSafetipmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip.safetipmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetipSyncorsafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetipThresholdmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip.thresholdmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip'
        self.thresholdmode = RootSeqCxRbanaAnalyzerTwoSafetipThresholdmode(self._context)
        self.syncorsafetip = RootSeqCxRbanaAnalyzerTwoSafetipSyncorsafetip(self._context)
        self.safetipmode = RootSeqCxRbanaAnalyzerTwoSafetipSafetipmode(self._context)
        self.safetip = RootSeqCxRbanaAnalyzerTwoSafetipSafetip(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoDelaycomp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.delaycomp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.delaycomp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.delaycomp.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSetvalampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.setvalampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.setvalampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.setvalampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoThreshold(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.threshold'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.threshold.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.threshold.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCenterfreq_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.centerfreq_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.centerfreq_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.centerfreq_hi.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiphase.factor'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.factor.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiphase.shift'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shift.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiphase'
        self.shift = RootSeqCxRbanaAnalyzerTwoKiphaseShift(self._context)
        self.shiftdirection = RootSeqCxRbanaAnalyzerTwoKiphaseShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerTwoKiphaseFactor(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoDeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.deltaf'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.deltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.deltaf.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoX(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.x'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.x.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.x.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoY(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.y'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.y.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.y.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoPhase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.phase'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.phase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.phase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSetptampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.setptampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.setptampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.setptampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoDeltafoffs_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.deltafoffs_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.deltafoffs_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.deltafoffs_lo.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCenterfreq_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.centerfreq_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.centerfreq_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.centerfreq_lo.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Fltr_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.fltr_vld'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Distdeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.distdeltaf'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Filtaddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.filtaddr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.filtaddr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.filtaddr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.filtaddr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.filtaddr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.filtaddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.filtaddr.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Outputsourceid(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.outputsourceid'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Clearflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.clearflag'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.clearflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.clearflag.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.clearflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.clearflag.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.clearflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.clearflag.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Enabledcblock(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.enabledcblock'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1'
        self.enabledcblock = RootSeqCxRbanaAnalyzerTwoControl1Enabledcblock(self._context)
        self.clearflag = RootSeqCxRbanaAnalyzerTwoControl1Clearflag(self._context)
        self.outputsourceid = RootSeqCxRbanaAnalyzerTwoControl1Outputsourceid(self._context)
        self.filtaddr = RootSeqCxRbanaAnalyzerTwoControl1Filtaddr(self._context)
        self.distdeltaf = RootSeqCxRbanaAnalyzerTwoControl1Distdeltaf(self._context)
        self.fltr_vld = RootSeqCxRbanaAnalyzerTwoControl1Fltr_vld(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoDisscp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.disscp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.disscp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.disscp.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two'
        self.disscp = RootSeqCxRbanaAnalyzerTwoDisscp(self._context)
        self.control1 = RootSeqCxRbanaAnalyzerTwoControl1(self._context)
        self.centerfreq_lo = RootSeqCxRbanaAnalyzerTwoCenterfreq_lo(self._context)
        self.deltafoffs_lo = RootSeqCxRbanaAnalyzerTwoDeltafoffs_lo(self._context)
        self.setptampkel = RootSeqCxRbanaAnalyzerTwoSetptampkel(self._context)
        self.phase = RootSeqCxRbanaAnalyzerTwoPhase(self._context)
        self.y = RootSeqCxRbanaAnalyzerTwoY(self._context)
        self.x = RootSeqCxRbanaAnalyzerTwoX(self._context)
        self.deltaf = RootSeqCxRbanaAnalyzerTwoDeltaf(self._context)
        self.kiphase = RootSeqCxRbanaAnalyzerTwoKiphase(self._context)
        self.centerfreq_hi = RootSeqCxRbanaAnalyzerTwoCenterfreq_hi(self._context)
        self.threshold = RootSeqCxRbanaAnalyzerTwoThreshold(self._context)
        self.setvalampkel = RootSeqCxRbanaAnalyzerTwoSetvalampkel(self._context)
        self.delaycomp = RootSeqCxRbanaAnalyzerTwoDelaycomp(self._context)
        self.safetip = RootSeqCxRbanaAnalyzerTwoSafetip(self._context)
        self.phaseshift = RootSeqCxRbanaAnalyzerTwoPhaseshift(self._context)
        self.mode = RootSeqCxRbanaAnalyzerTwoMode(self._context)
        self.amplitude = RootSeqCxRbanaAnalyzerTwoAmplitude(self._context)
        self.modampkel = RootSeqCxRbanaAnalyzerTwoModampkel(self._context)
        self.kpampkel = RootSeqCxRbanaAnalyzerTwoKpampkel(self._context)
        self.kpphase = RootSeqCxRbanaAnalyzerTwoKpphase(self._context)
        self.lockrangeshift = RootSeqCxRbanaAnalyzerTwoLockrangeshift(self._context)
        self.ctrlbits = RootSeqCxRbanaAnalyzerTwoCtrlbits(self._context)
        self.flag = RootSeqCxRbanaAnalyzerTwoFlag(self._context)
        self.kiampkel = RootSeqCxRbanaAnalyzerTwoKiampkel(self._context)
        self.fltrcoeff = RootSeqCxRbanaAnalyzerTwoFltrcoeff(self._context)
        self.deltafoffs_hi = RootSeqCxRbanaAnalyzerTwoDeltafoffs_hi(self._context)


class RootSeqCxRbanaAnalyzerOneDeltafoffs_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.deltafoffs_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.deltafoffs_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.deltafoffs_hi.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneFltrcoeff(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.fltrcoeff'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.fltrcoeff.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.fltrcoeff.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiampkel.factor'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.factor.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiampkel.shift'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shift.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiampkel'
        self.shift = RootSeqCxRbanaAnalyzerOneKiampkelShift(self._context)
        self.shiftdirection = RootSeqCxRbanaAnalyzerOneKiampkelShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerOneKiampkelFactor(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneFlag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.flag'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.flag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.flag.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsAmpmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsAmpctrlmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsPhaseclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsPhasectrl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsAmpclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsAmpctrlpositiveaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbits(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits'
        self.ampctrlpositiveaccu = RootSeqCxRbanaAnalyzerOneCtrlbitsAmpctrlpositiveaccu(self._context)
        self.ampclearaccu = RootSeqCxRbanaAnalyzerOneCtrlbitsAmpclearaccu(self._context)
        self.phasectrl = RootSeqCxRbanaAnalyzerOneCtrlbitsPhasectrl(self._context)
        self.phaseclearaccu = RootSeqCxRbanaAnalyzerOneCtrlbitsPhaseclearaccu(self._context)
        self.ampctrlmode = RootSeqCxRbanaAnalyzerOneCtrlbitsAmpctrlmode(self._context)
        self.ampmodulation = RootSeqCxRbanaAnalyzerOneCtrlbitsAmpmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneLockrangeshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.lockrangeshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.lockrangeshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.lockrangeshift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpphase.factor'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.factor.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpphase.shift'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shift.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpphase'
        self.shift = RootSeqCxRbanaAnalyzerOneKpphaseShift(self._context)
        self.shiftdirection = RootSeqCxRbanaAnalyzerOneKpphaseShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerOneKpphaseFactor(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpampkel.factor'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.factor.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpampkel.shift'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shift.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpampkel'
        self.shift = RootSeqCxRbanaAnalyzerOneKpampkelShift(self._context)
        self.shiftdirection = RootSeqCxRbanaAnalyzerOneKpampkelShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerOneKpampkelFactor(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.modampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.modampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.modampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneAmplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.amplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.amplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.amplitude.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModeOpmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode.opmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.opmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.opmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.opmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.opmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.opmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.opmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModePhasedetref(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode.phasedetref'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.phasedetref.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.phasedetref.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.phasedetref.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.phasedetref.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.phasedetref.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.phasedetref.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModeInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode.input'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.input.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.input.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.input.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.input.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.input.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.input.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModeAnalyzerinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode.analyzerinput'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode'
        self.analyzerinput = RootSeqCxRbanaAnalyzerOneModeAnalyzerinput(self._context)
        self.input = RootSeqCxRbanaAnalyzerOneModeInput(self._context)
        self.phasedetref = RootSeqCxRbanaAnalyzerOneModePhasedetref(self._context)
        self.opmode = RootSeqCxRbanaAnalyzerOneModeOpmode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOnePhaseshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.phaseshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.phaseshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.phaseshift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetipSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip.safetip'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetip.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetip.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetipSafetipmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip.safetipmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetipSyncorsafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetipThresholdmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip.thresholdmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip'
        self.thresholdmode = RootSeqCxRbanaAnalyzerOneSafetipThresholdmode(self._context)
        self.syncorsafetip = RootSeqCxRbanaAnalyzerOneSafetipSyncorsafetip(self._context)
        self.safetipmode = RootSeqCxRbanaAnalyzerOneSafetipSafetipmode(self._context)
        self.safetip = RootSeqCxRbanaAnalyzerOneSafetipSafetip(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneDelaycomp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.delaycomp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.delaycomp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.delaycomp.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSetvalampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.setvalampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.setvalampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.setvalampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneThreshold(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.threshold'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.threshold.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.threshold.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCenterfreq_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.centerfreq_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.centerfreq_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.centerfreq_hi.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiphase.factor'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.factor.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiphase.shift'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shift.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiphase'
        self.shift = RootSeqCxRbanaAnalyzerOneKiphaseShift(self._context)
        self.shiftdirection = RootSeqCxRbanaAnalyzerOneKiphaseShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerOneKiphaseFactor(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneDeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.deltaf'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.deltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.deltaf.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneX(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.x'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.x.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.x.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneY(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.y'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.y.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.y.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOnePhase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.phase'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.phase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.phase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSetptampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.setptampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.setptampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.setptampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneDeltafoffs_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.deltafoffs_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.deltafoffs_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.deltafoffs_lo.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCenterfreq_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.centerfreq_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.centerfreq_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.centerfreq_lo.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Fltr_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.fltr_vld'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Distdeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.distdeltaf'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Filtaddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.filtaddr'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.filtaddr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.filtaddr.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.filtaddr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.filtaddr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.filtaddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.filtaddr.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Outputsourceid(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.outputsourceid'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Clearflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.clearflag'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.clearflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.clearflag.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.clearflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.clearflag.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.clearflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.clearflag.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Enabledcblock(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.enabledcblock'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1'
        self.enabledcblock = RootSeqCxRbanaAnalyzerOneControl1Enabledcblock(self._context)
        self.clearflag = RootSeqCxRbanaAnalyzerOneControl1Clearflag(self._context)
        self.outputsourceid = RootSeqCxRbanaAnalyzerOneControl1Outputsourceid(self._context)
        self.filtaddr = RootSeqCxRbanaAnalyzerOneControl1Filtaddr(self._context)
        self.distdeltaf = RootSeqCxRbanaAnalyzerOneControl1Distdeltaf(self._context)
        self.fltr_vld = RootSeqCxRbanaAnalyzerOneControl1Fltr_vld(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneDisscp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.disscp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.disscp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.disscp.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOne(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one'
        self.disscp = RootSeqCxRbanaAnalyzerOneDisscp(self._context)
        self.control1 = RootSeqCxRbanaAnalyzerOneControl1(self._context)
        self.centerfreq_lo = RootSeqCxRbanaAnalyzerOneCenterfreq_lo(self._context)
        self.deltafoffs_lo = RootSeqCxRbanaAnalyzerOneDeltafoffs_lo(self._context)
        self.setptampkel = RootSeqCxRbanaAnalyzerOneSetptampkel(self._context)
        self.phase = RootSeqCxRbanaAnalyzerOnePhase(self._context)
        self.y = RootSeqCxRbanaAnalyzerOneY(self._context)
        self.x = RootSeqCxRbanaAnalyzerOneX(self._context)
        self.deltaf = RootSeqCxRbanaAnalyzerOneDeltaf(self._context)
        self.kiphase = RootSeqCxRbanaAnalyzerOneKiphase(self._context)
        self.centerfreq_hi = RootSeqCxRbanaAnalyzerOneCenterfreq_hi(self._context)
        self.threshold = RootSeqCxRbanaAnalyzerOneThreshold(self._context)
        self.setvalampkel = RootSeqCxRbanaAnalyzerOneSetvalampkel(self._context)
        self.delaycomp = RootSeqCxRbanaAnalyzerOneDelaycomp(self._context)
        self.safetip = RootSeqCxRbanaAnalyzerOneSafetip(self._context)
        self.phaseshift = RootSeqCxRbanaAnalyzerOnePhaseshift(self._context)
        self.mode = RootSeqCxRbanaAnalyzerOneMode(self._context)
        self.amplitude = RootSeqCxRbanaAnalyzerOneAmplitude(self._context)
        self.modampkel = RootSeqCxRbanaAnalyzerOneModampkel(self._context)
        self.kpampkel = RootSeqCxRbanaAnalyzerOneKpampkel(self._context)
        self.kpphase = RootSeqCxRbanaAnalyzerOneKpphase(self._context)
        self.lockrangeshift = RootSeqCxRbanaAnalyzerOneLockrangeshift(self._context)
        self.ctrlbits = RootSeqCxRbanaAnalyzerOneCtrlbits(self._context)
        self.flag = RootSeqCxRbanaAnalyzerOneFlag(self._context)
        self.kiampkel = RootSeqCxRbanaAnalyzerOneKiampkel(self._context)
        self.fltrcoeff = RootSeqCxRbanaAnalyzerOneFltrcoeff(self._context)
        self.deltafoffs_hi = RootSeqCxRbanaAnalyzerOneDeltafoffs_hi(self._context)


class RootSeqCxRbanaAnalyzer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer'
        self.one = RootSeqCxRbanaAnalyzerOne(self._context)
        self.two = RootSeqCxRbanaAnalyzerTwo(self._context)


class RootSeqCxRbanaAnalyzercommonSgleControlHarmoncinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzercommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzercommon.sgle.control'
        self.harmoncinput = RootSeqCxRbanaAnalyzercommonSgleControlHarmoncinput(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzercommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzercommon.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzercommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzercommon.sgle'
        self.control = RootSeqCxRbanaAnalyzercommonSgleControl(self._context)


class RootSeqCxRbanaAnalyzercommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzercommon'
        self.sgle = RootSeqCxRbanaAnalyzercommonSgle(self._context)


class RootSeqCxRbanaGpiSgleOdata(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.odata'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.odata.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.odata.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaEventmgrstop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaEventmgrabort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaRampgentestdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaUserdigi1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.userdigi1'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaEventmgrdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaRampgenuser4done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaUserdigi2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.userdigi2'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena'
        self.userdigi2 = RootSeqCxRbanaGpiSgleIrqenaUserdigi2(self._context)
        self.rampgenuser4done = RootSeqCxRbanaGpiSgleIrqenaRampgenuser4done(self._context)
        self.eventmgrdone = RootSeqCxRbanaGpiSgleIrqenaEventmgrdone(self._context)
        self.userdigi1 = RootSeqCxRbanaGpiSgleIrqenaUserdigi1(self._context)
        self.rampgentestdone = RootSeqCxRbanaGpiSgleIrqenaRampgentestdone(self._context)
        self.eventmgrabort = RootSeqCxRbanaGpiSgleIrqenaEventmgrabort(self._context)
        self.eventmgrstop = RootSeqCxRbanaGpiSgleIrqenaEventmgrstop(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecEventmgrstop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecEventmgrabort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecRampgentestdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecUserdigi1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecEventmgrdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecRampgenuser4done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecUserdigi2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec'
        self.userdigi2 = RootSeqCxRbanaGpiSgleIrqvecUserdigi2(self._context)
        self.rampgenuser4done = RootSeqCxRbanaGpiSgleIrqvecRampgenuser4done(self._context)
        self.eventmgrdone = RootSeqCxRbanaGpiSgleIrqvecEventmgrdone(self._context)
        self.userdigi1 = RootSeqCxRbanaGpiSgleIrqvecUserdigi1(self._context)
        self.rampgentestdone = RootSeqCxRbanaGpiSgleIrqvecRampgentestdone(self._context)
        self.eventmgrabort = RootSeqCxRbanaGpiSgleIrqvecEventmgrabort(self._context)
        self.eventmgrstop = RootSeqCxRbanaGpiSgleIrqvecEventmgrstop(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataEventmgrstop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataEventmgrabort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataRampgentestdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataUserdigi1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.userdigi1'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataEventmgrdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataRampgenuser4done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataUserdigi2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.userdigi2'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdata(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata'
        self.userdigi2 = RootSeqCxRbanaGpiSgleIdataUserdigi2(self._context)
        self.rampgenuser4done = RootSeqCxRbanaGpiSgleIdataRampgenuser4done(self._context)
        self.eventmgrdone = RootSeqCxRbanaGpiSgleIdataEventmgrdone(self._context)
        self.userdigi1 = RootSeqCxRbanaGpiSgleIdataUserdigi1(self._context)
        self.rampgentestdone = RootSeqCxRbanaGpiSgleIdataRampgentestdone(self._context)
        self.eventmgrabort = RootSeqCxRbanaGpiSgleIdataEventmgrabort(self._context)
        self.eventmgrstop = RootSeqCxRbanaGpiSgleIdataEventmgrstop(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle'
        self.idata = RootSeqCxRbanaGpiSgleIdata(self._context)
        self.irqvec = RootSeqCxRbanaGpiSgleIrqvec(self._context)
        self.irqena = RootSeqCxRbanaGpiSgleIrqena(self._context)
        self.odata = RootSeqCxRbanaGpiSgleOdata(self._context)


class RootSeqCxRbanaGpi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi'
        self.sgle = RootSeqCxRbanaGpiSgle(self._context)


class RootSeqCxRbanaSeqSgleA(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.a'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.a.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.a.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleSeqreg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.seqreg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.seqreg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.seqreg.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleBit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.bit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.bit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.bit.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleB(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.b'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.b.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.b.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleM(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.m'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.m.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.m.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleAddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.addr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.addr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.addr.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleInstrptr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.instrptr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.instrptr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.instrptr.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControlStep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control.step'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.step.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.step.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.step.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.step.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.step.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.step.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control.abort'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.abort.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control.start'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.start.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.start.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control'
        self.start = RootSeqCxRbanaSeqSgleControlStart(self._context)
        self.abort = RootSeqCxRbanaSeqSgleControlAbort(self._context)
        self.stop = RootSeqCxRbanaSeqSgleControlStop(self._context)
        self.step = RootSeqCxRbanaSeqSgleControlStep(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleStatusReaderror(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.status.readerror'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.readerror.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.readerror.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.readerror.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.readerror.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.readerror.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.readerror.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleStatusRunning(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.status.running'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.running.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.running.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.running.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.running.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.running.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.running.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.status'
        self.running = RootSeqCxRbanaSeqSgleStatusRunning(self._context)
        self.readerror = RootSeqCxRbanaSeqSgleStatusReaderror(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleSum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.sum'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.sum.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.sum.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleData(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.data'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.data.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.data.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle'
        self.data = RootSeqCxRbanaSeqSgleData(self._context)
        self.sum = RootSeqCxRbanaSeqSgleSum(self._context)
        self.status = RootSeqCxRbanaSeqSgleStatus(self._context)
        self.control = RootSeqCxRbanaSeqSgleControl(self._context)
        self.instrptr = RootSeqCxRbanaSeqSgleInstrptr(self._context)
        self.addr = RootSeqCxRbanaSeqSgleAddr(self._context)
        self.m = RootSeqCxRbanaSeqSgleM(self._context)
        self.b = RootSeqCxRbanaSeqSgleB(self._context)
        self.bit = RootSeqCxRbanaSeqSgleBit(self._context)
        self.seqreg = RootSeqCxRbanaSeqSgleSeqreg(self._context)
        self.a = RootSeqCxRbanaSeqSgleA(self._context)


class RootSeqCxRbanaSeq(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq'
        self.sgle = RootSeqCxRbanaSeqSgle(self._context)


class RootSeqCxRbanaZctrlexSgleCurrentrampvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.currentrampvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.currentrampvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.currentrampvalue.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleCurrentphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.currentphase'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.currentphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.currentphase.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleInputiirout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.inputiirout'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.inputiirout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.inputiirout.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleP3movevalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.p3movevalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.p3movevalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.p3movevalue.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleP2moveinc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.p2moveinc'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.p2moveinc.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.p2moveinc.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleClp_pid_gain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.clp_pid_gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.clp_pid_gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.clp_pid_gain_p.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleClp_pid_gain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.clp_pid_gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.clp_pid_gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.clp_pid_gain_d.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleFb_pid_gain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.fb_pid_gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.fb_pid_gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.fb_pid_gain_d.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleError(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.error'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.error.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.error.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleP0moveinc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.p0moveinc'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.p0moveinc.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.p0moveinc.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleDdciiraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.ddciiraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.ddciiraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.ddciiraddr.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSglePhase0realendpos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.phase0realendpos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.phase0realendpos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.phase0realendpos.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSglePhase2realendpos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.phase2realendpos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.phase2realendpos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.phase2realendpos.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleOutput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.output'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.output.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.output.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSglePhase3realendpos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.phase3realendpos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.phase3realendpos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.phase3realendpos.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleMinzvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.minzvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.minzvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.minzvalue.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSglePhase1realendpos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.phase1realendpos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.phase1realendpos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.phase1realendpos.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzreachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedlowerlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedlowerlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusZctrlexrampgenmaxzdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenmaxzdone'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenmaxzdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenmaxzdone.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenmaxzdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenmaxzdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenmaxzdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenmaxzdone.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusZctrlexactivaterunmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.zctrlexactivaterunmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexactivaterunmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexactivaterunmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexactivaterunmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexactivaterunmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexactivaterunmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexactivaterunmode.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusZctrlexreachedminz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedminz'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedminz.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedminz.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedminz.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedminz.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedminz.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedminz.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzbusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzbusy'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzbusy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzbusy.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzbusy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzbusy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzbusy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzbusy.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusZctrlexrampgenctrlzdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenctrlzdone'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenctrlzdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenctrlzdone.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenctrlzdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenctrlzdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenctrlzdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexrampgenctrlzdone.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzreachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedupperlimit'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedupperlimit.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzcountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzcountup'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzcountup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzcountup.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzcountup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzcountup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzcountup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzcountup.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusZctrlexinternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.zctrlexinternaloaded'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexinternaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexinternaloaded.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexinternaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexinternaloaded.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexinternaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexinternaloaded.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzreachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedregularend'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedregularend.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.rampgenctrlzreachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusZctrlexreachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachederrlim'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachederrlim.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachederrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachederrlim.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusZctrlexreachedmaxz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedmaxz'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedmaxz.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedmaxz.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedmaxz.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedmaxz.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedmaxz.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.zctrlexreachedmaxz.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusStopwhileprocessing(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.stopwhileprocessing'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.stopwhileprocessing.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.stopwhileprocessing.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.stopwhileprocessing.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.stopwhileprocessing.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.stopwhileprocessing.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.stopwhileprocessing.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatusEndofphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status.endofphase'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.endofphase.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.endofphase.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.endofphase.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.endofphase.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.endofphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.endofphase.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.status'
        self.endofphase = RootSeqCxRbanaZctrlexSgleStatusEndofphase(self._context)
        self.stopwhileprocessing = RootSeqCxRbanaZctrlexSgleStatusStopwhileprocessing(self._context)
        self.zctrlexreachedmaxz = RootSeqCxRbanaZctrlexSgleStatusZctrlexreachedmaxz(self._context)
        self.zctrlexreachederrlim = RootSeqCxRbanaZctrlexSgleStatusZctrlexreachederrlim(self._context)
        self.rampgenctrlzreachedregularend = RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzreachedregularend(self._context)
        self.zctrlexinternaloaded = RootSeqCxRbanaZctrlexSgleStatusZctrlexinternaloaded(self._context)
        self.rampgenctrlzcountup = RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzcountup(self._context)
        self.rampgenctrlzreachedupperlimit = RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzreachedupperlimit(self._context)
        self.zctrlexrampgenctrlzdone = RootSeqCxRbanaZctrlexSgleStatusZctrlexrampgenctrlzdone(self._context)
        self.rampgenctrlzbusy = RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzbusy(self._context)
        self.zctrlexreachedminz = RootSeqCxRbanaZctrlexSgleStatusZctrlexreachedminz(self._context)
        self.zctrlexactivaterunmode = RootSeqCxRbanaZctrlexSgleStatusZctrlexactivaterunmode(self._context)
        self.zctrlexrampgenmaxzdone = RootSeqCxRbanaZctrlexSgleStatusZctrlexrampgenmaxzdone(self._context)
        self.rampgenctrlzreachedlowerlimit = RootSeqCxRbanaZctrlexSgleStatusRampgenctrlzreachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleP2movevalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.p2movevalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.p2movevalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.p2movevalue.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleFb_pid_gain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.fb_pid_gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.fb_pid_gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.fb_pid_gain_p.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleTotphasenbr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.totphasenbr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.totphasenbr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.totphasenbr.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleP0movevalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.p0movevalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.p0movevalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.p0movevalue.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleZoutlimited(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.zoutlimited'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.zoutlimited.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.zoutlimited.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleRampgenctrlzout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.rampgenctrlzout'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.rampgenctrlzout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.rampgenctrlzout.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P3workmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p3workmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p3workmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p3workmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p3workmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p3workmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p3workmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p3workmode.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P2movestopbyvalueactive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P3movestopbyvalueactive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P0movestopbyvalueactive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P0workmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p0workmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p0workmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p0workmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p0workmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p0workmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p0workmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p0workmode.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P2workmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p2workmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p2workmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p2workmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p2workmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p2workmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p2workmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p2workmode.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P1workmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p1workmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p1workmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p1workmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p1workmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p1workmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p1workmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p1workmode.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P3moveendmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p3moveendmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p3moveendmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p3moveendmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p3moveendmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p3moveendmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p3moveendmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p3moveendmode.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P1movestopbyvalueactive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P0moveendmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p0moveendmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p0moveendmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p0moveendmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p0moveendmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p0moveendmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p0moveendmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p0moveendmode.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P1moveendmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p1moveendmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p1moveendmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p1moveendmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p1moveendmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p1moveendmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p1moveendmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p1moveendmode.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1P2moveendmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1.p2moveendmode'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p2moveendmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p2moveendmode.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p2moveendmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p2moveendmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.p2moveendmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.p2moveendmode.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control1'
        self.p2moveendmode = RootSeqCxRbanaZctrlexSgleControl1P2moveendmode(self._context)
        self.p1moveendmode = RootSeqCxRbanaZctrlexSgleControl1P1moveendmode(self._context)
        self.p0moveendmode = RootSeqCxRbanaZctrlexSgleControl1P0moveendmode(self._context)
        self.p1movestopbyvalueactive = RootSeqCxRbanaZctrlexSgleControl1P1movestopbyvalueactive(self._context)
        self.p3moveendmode = RootSeqCxRbanaZctrlexSgleControl1P3moveendmode(self._context)
        self.p1workmode = RootSeqCxRbanaZctrlexSgleControl1P1workmode(self._context)
        self.p2workmode = RootSeqCxRbanaZctrlexSgleControl1P2workmode(self._context)
        self.p0workmode = RootSeqCxRbanaZctrlexSgleControl1P0workmode(self._context)
        self.p0movestopbyvalueactive = RootSeqCxRbanaZctrlexSgleControl1P0movestopbyvalueactive(self._context)
        self.p3movestopbyvalueactive = RootSeqCxRbanaZctrlexSgleControl1P3movestopbyvalueactive(self._context)
        self.p2movestopbyvalueactive = RootSeqCxRbanaZctrlexSgleControl1P2movestopbyvalueactive(self._context)
        self.p3workmode = RootSeqCxRbanaZctrlexSgleControl1P3workmode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control1.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleErrorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.errorlimit.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSglePidcommand(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.pidcommand'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.pidcommand.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.pidcommand.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleRampgenctrlzlimitpos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.rampgenctrlzlimitpos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.rampgenctrlzlimitpos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.rampgenctrlzlimitpos.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleDdciircoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.ddciircoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.ddciircoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.ddciircoef.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleP1moveinc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.p1moveinc'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.p1moveinc.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.p1moveinc.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleSum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.sum'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.sum.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.sum.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleP3moveinc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.p3moveinc'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.p3moveinc.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.p3moveinc.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleInputiiraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.inputiiraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.inputiiraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.inputiiraddr.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleCompdcwithz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.compdcwithz'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.compdcwithz.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.compdcwithz.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleFb_pid_gain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.fb_pid_gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.fb_pid_gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.fb_pid_gain_i.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.input'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.input.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.input.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleP1movevalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.p1movevalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.p1movevalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.p1movevalue.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleInputiircoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.inputiircoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.inputiircoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.inputiircoef.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleRampgenctrlzlimitneg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.rampgenctrlzlimitneg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.rampgenctrlzlimitneg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.rampgenctrlzlimitneg.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleSetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.setpoint'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.setpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.setpoint.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleClp_pid_gain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.clp_pid_gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.clp_pid_gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.clp_pid_gain_i.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl0Stop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control0.stop'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.stop.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.stop.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl0Setpointmodulationena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control0.setpointmodulationena'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.setpointmodulationena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.setpointmodulationena.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.setpointmodulationena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.setpointmodulationena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.setpointmodulationena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.setpointmodulationena.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl0Zctrlexpolpidinzclp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinzclp'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinzclp.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinzclp.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinzclp.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinzclp.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinzclp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinzclp.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl0Zctrlexpolpidinfb(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinfb'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinfb.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinfb.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinfb.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinfb.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinfb.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexpolpidinfb.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl0Outputmodulationena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control0.outputmodulationena'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.outputmodulationena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.outputmodulationena.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.outputmodulationena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.outputmodulationena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.outputmodulationena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.outputmodulationena.regaddr', int(new_val))


class RootSeqCxRbanaZctrlexSgleControl0Zctrlexinputchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexinputchan'

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexinputchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexinputchan.lsb', int(new_val))

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexinputchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.zctrlex.sgle.control0.zctrlexinputchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        re