# studio_wrapper.py

from enum import Enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = '2000509c4708c7ea9cc87f31e754cb12'
g_compiler_version = '1.0'

class RootSeqCxRbanaInchannelsdigiSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inchannelsdigi.sgle.control'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inchannelsdigi.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inchannelsdigi.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaInchannelsdigiSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inchannelsdigi.sgle'
        self.control = RootSeqCxRbanaInchannelsdigiSgleControl(self._context)


class RootSeqCxRbanaInchannelsdigi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inchannelsdigi'
        self.sgle = RootSeqCxRbanaInchannelsdigiSgle(self._context)


class RootSeqCxRbanaInfastCh3Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.gain.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.offset.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch3.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch3.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch3'
        self.cccoefz1 = RootSeqCxRbanaInfastCh3Cccoefz1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInfastCh3Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInfastCh3Cccoefz2(self._context)
        self.offset = RootSeqCxRbanaInfastCh3Offset(self._context)
        self.cccoefy0 = RootSeqCxRbanaInfastCh3Cccoefy0(self._context)
        self.cccoefx0 = RootSeqCxRbanaInfastCh3Cccoefx0(self._context)
        self.currentinval = RootSeqCxRbanaInfastCh3Currentinval(self._context)
        self.cccoefy2 = RootSeqCxRbanaInfastCh3Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInfastCh3Cccoefz0(self._context)
        self.gain = RootSeqCxRbanaInfastCh3Gain(self._context)
        self.cccoefx2 = RootSeqCxRbanaInfastCh3Cccoefx2(self._context)
        self.cccoefy1 = RootSeqCxRbanaInfastCh3Cccoefy1(self._context)


class RootSeqCxRbanaInfastCh2Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.gain.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.offset.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch2.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch2.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch2'
        self.cccoefz1 = RootSeqCxRbanaInfastCh2Cccoefz1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInfastCh2Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInfastCh2Cccoefz2(self._context)
        self.offset = RootSeqCxRbanaInfastCh2Offset(self._context)
        self.cccoefy0 = RootSeqCxRbanaInfastCh2Cccoefy0(self._context)
        self.cccoefx0 = RootSeqCxRbanaInfastCh2Cccoefx0(self._context)
        self.currentinval = RootSeqCxRbanaInfastCh2Currentinval(self._context)
        self.cccoefy2 = RootSeqCxRbanaInfastCh2Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInfastCh2Cccoefz0(self._context)
        self.gain = RootSeqCxRbanaInfastCh2Gain(self._context)
        self.cccoefx2 = RootSeqCxRbanaInfastCh2Cccoefx2(self._context)
        self.cccoefy1 = RootSeqCxRbanaInfastCh2Cccoefy1(self._context)


class RootSeqCxRbanaInfastCh1Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.gain.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.offset.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.infast.ch1.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.infast.ch1.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInfastCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast.ch1'
        self.cccoefz1 = RootSeqCxRbanaInfastCh1Cccoefz1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInfastCh1Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInfastCh1Cccoefz2(self._context)
        self.offset = RootSeqCxRbanaInfastCh1Offset(self._context)
        self.cccoefy0 = RootSeqCxRbanaInfastCh1Cccoefy0(self._context)
        self.cccoefx0 = RootSeqCxRbanaInfastCh1Cccoefx0(self._context)
        self.currentinval = RootSeqCxRbanaInfastCh1Currentinval(self._context)
        self.cccoefy2 = RootSeqCxRbanaInfastCh1Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInfastCh1Cccoefz0(self._context)
        self.gain = RootSeqCxRbanaInfastCh1Gain(self._context)
        self.cccoefx2 = RootSeqCxRbanaInfastCh1Cccoefx2(self._context)
        self.cccoefy1 = RootSeqCxRbanaInfastCh1Cccoefy1(self._context)


class RootSeqCxRbanaInfast(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infast'
        self.ch1 = RootSeqCxRbanaInfastCh1(self._context)
        self.ch2 = RootSeqCxRbanaInfastCh2(self._context)
        self.ch3 = RootSeqCxRbanaInfastCh3(self._context)


class RootSeqCxRbanaRegaddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.regaddr'


class RootSeqCxRbanaInhirescommonSgleAafcoefAddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.addr.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleAafcoefData(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.data.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleAafcoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.aafcoef'
        self.data = RootSeqCxRbanaInhirescommonSgleAafcoefData(self._context)
        self.addr = RootSeqCxRbanaInhirescommonSgleAafcoefAddr(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.aafcoef.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh3bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch3bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh12bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch12bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh5bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch5bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh8bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch8bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh10bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch10bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh2bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch2bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh11bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch11bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh9bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch9bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh4bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch4bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh7bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch7bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh6bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch6bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControlCh1bypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.ch1bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle.control'
        self.ch1bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh1bypassfilter(self._context)
        self.ch6bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh6bypassfilter(self._context)
        self.ch7bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh7bypassfilter(self._context)
        self.ch4bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh4bypassfilter(self._context)
        self.ch9bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh9bypassfilter(self._context)
        self.ch11bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh11bypassfilter(self._context)
        self.ch2bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh2bypassfilter(self._context)
        self.ch10bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh10bypassfilter(self._context)
        self.ch8bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh8bypassfilter(self._context)
        self.ch5bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh5bypassfilter(self._context)
        self.ch12bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh12bypassfilter(self._context)
        self.ch3bypassfilter = RootSeqCxRbanaInhirescommonSgleControlCh3bypassfilter(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhirescommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhirescommon.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaInhirescommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon.sgle'
        self.control = RootSeqCxRbanaInhirescommonSgleControl(self._context)
        self.aafcoef = RootSeqCxRbanaInhirescommonSgleAafcoef(self._context)


class RootSeqCxRbanaInhirescommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhirescommon'
        self.sgle = RootSeqCxRbanaInhirescommonSgle(self._context)


class RootSeqCxRbanaOrtSgleAmplitudesample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.amplitudesample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.amplitudesample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.amplitudesample.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleBaselinewindowbeginsample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.baselinewindowbeginsample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.baselinewindowbeginsample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.baselinewindowbeginsample.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleBaselinewindowendsample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.baselinewindowendsample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.baselinewindowendsample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.baselinewindowendsample.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleCantileversamplesperperiodSamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleCantileversamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod'
        self.samplesperperiod = RootSeqCxRbanaOrtSgleCantileversamplesperperiodSamplesperperiod(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.cantileversamplesperperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlEnablebaselinecontroller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.enablebaselinecontroller.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlInputselect(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.inputselect'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.inputselect.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.inputselect.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.inputselect.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.inputselect.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.inputselect.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.inputselect.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlAveragestart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.averagestart'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestart.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestart.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestart.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestart.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestart.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestart.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlFreewaveoutputenable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.freewaveoutputenable.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlUpdatesamplevalues(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.updatesamplevalues'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.updatesamplevalues.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControlAveragestop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control.averagestop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.averagestop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.averagestop.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.control'
        self.averagestop = RootSeqCxRbanaOrtSgleControlAveragestop(self._context)
        self.updatesamplevalues = RootSeqCxRbanaOrtSgleControlUpdatesamplevalues(self._context)
        self.freewaveoutputenable = RootSeqCxRbanaOrtSgleControlFreewaveoutputenable(self._context)
        self.averagestart = RootSeqCxRbanaOrtSgleControlAveragestart(self._context)
        self.inputselect = RootSeqCxRbanaOrtSgleControlInputselect(self._context)
        self.enablebaselinecontroller = RootSeqCxRbanaOrtSgleControlEnablebaselinecontroller(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleBaselinemultiplier(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.baselinemultiplier'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.baselinemultiplier.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.baselinemultiplier.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleExcitationamplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.excitationamplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.excitationamplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.excitationamplitude.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleFreewavebeginsample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.freewavebeginsample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.freewavebeginsample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.freewavebeginsample.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleStatusAveraging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.status.averaging'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.status.averaging.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.status.averaging.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.status.averaging.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.status.averaging.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.status.averaging.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.status.averaging.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.status'
        self.averaging = RootSeqCxRbanaOrtSgleStatusAveraging(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleAverageperiodsAverageperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.averageperiods.averageperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleAverageperiods(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.averageperiods'
        self.averageperiod = RootSeqCxRbanaOrtSgleAverageperiodsAverageperiod(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.averageperiods.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.averageperiods.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleBaselineamplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.baselineamplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.baselineamplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.baselineamplitude.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleMinvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.minvalue.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleSamplesperperiodSamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.samplesperperiod.samplesperperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleSamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.samplesperperiod'
        self.samplesperperiod = RootSeqCxRbanaOrtSgleSamplesperperiodSamplesperperiod(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.samplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.samplesperperiod.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleMinposition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.minposition'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.minposition.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.minposition.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgleAmplitudereduction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle.amplitudereduction'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.ort.sgle.amplitudereduction.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.ort.sgle.amplitudereduction.regaddr', int(new_val))


class RootSeqCxRbanaOrtSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort.sgle'
        self.amplitudereduction = RootSeqCxRbanaOrtSgleAmplitudereduction(self._context)
        self.minposition = RootSeqCxRbanaOrtSgleMinposition(self._context)
        self.samplesperperiod = RootSeqCxRbanaOrtSgleSamplesperperiod(self._context)
        self.minvalue = RootSeqCxRbanaOrtSgleMinvalue(self._context)
        self.baselineamplitude = RootSeqCxRbanaOrtSgleBaselineamplitude(self._context)
        self.averageperiods = RootSeqCxRbanaOrtSgleAverageperiods(self._context)
        self.status = RootSeqCxRbanaOrtSgleStatus(self._context)
        self.freewavebeginsample = RootSeqCxRbanaOrtSgleFreewavebeginsample(self._context)
        self.excitationamplitude = RootSeqCxRbanaOrtSgleExcitationamplitude(self._context)
        self.baselinemultiplier = RootSeqCxRbanaOrtSgleBaselinemultiplier(self._context)
        self.control = RootSeqCxRbanaOrtSgleControl(self._context)
        self.cantileversamplesperperiod = RootSeqCxRbanaOrtSgleCantileversamplesperperiod(self._context)
        self.baselinewindowendsample = RootSeqCxRbanaOrtSgleBaselinewindowendsample(self._context)
        self.baselinewindowbeginsample = RootSeqCxRbanaOrtSgleBaselinewindowbeginsample(self._context)
        self.amplitudesample = RootSeqCxRbanaOrtSgleAmplitudesample(self._context)


class RootSeqCxRbanaOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.ort'
        self.sgle = RootSeqCxRbanaOrtSgle(self._context)


class RootSeqCxRbanaMemorysignalgenSgleStatusFifolevel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.status.fifolevel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.fifolevel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.fifolevel.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.fifolevel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.fifolevel.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.fifolevel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.fifolevel.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleStatusEndreached(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.status.endreached'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.endreached.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.endreached.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.endreached.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.endreached.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.endreached.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.endreached.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleStatusUnderrun(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.status.underrun'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.underrun.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.underrun.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.underrun.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.underrun.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.underrun.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.underrun.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.status'
        self.busy = RootSeqCxRbanaMemorysignalgenSgleStatusBusy(self._context)
        self.underrun = RootSeqCxRbanaMemorysignalgenSgleStatusUnderrun(self._context)
        self.endreached = RootSeqCxRbanaMemorysignalgenSgleStatusEndreached(self._context)
        self.fifolevel = RootSeqCxRbanaMemorysignalgenSgleStatusFifolevel(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleSamplecnt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.samplecnt'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.samplecnt.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.samplecnt.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.out.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.increment.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleWvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.wvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.wvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.wvalue.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControlJoin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control.join'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.join.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.join.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.join.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.join.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.join.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.join.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControlLinear(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control.linear'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.linear.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.linear.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.linear.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.linear.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.linear.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.linear.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControlOutaddress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control.outaddress'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.outaddress.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.outaddress.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.outaddress.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.outaddress.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.outaddress.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.outaddress.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControlAddress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control.address'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.address.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.address.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.address.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.address.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.address.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.address.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.start.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControlClear(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control.clear'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.clear.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.clear.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.clear.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.clear.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.clear.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.clear.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControlEnable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control.enable'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.enable.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.enable.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.enable.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.control'
        self.enable = RootSeqCxRbanaMemorysignalgenSgleControlEnable(self._context)
        self.clear = RootSeqCxRbanaMemorysignalgenSgleControlClear(self._context)
        self.stop = RootSeqCxRbanaMemorysignalgenSgleControlStop(self._context)
        self.start = RootSeqCxRbanaMemorysignalgenSgleControlStart(self._context)
        self.abort = RootSeqCxRbanaMemorysignalgenSgleControlAbort(self._context)
        self.address = RootSeqCxRbanaMemorysignalgenSgleControlAddress(self._context)
        self.outaddress = RootSeqCxRbanaMemorysignalgenSgleControlOutaddress(self._context)
        self.linear = RootSeqCxRbanaMemorysignalgenSgleControlLinear(self._context)
        self.join = RootSeqCxRbanaMemorysignalgenSgleControlJoin(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleSampleno(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.sampleno'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.sampleno.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.sampleno.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgleRvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle.rvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.memorysignalgen.sgle.rvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.memorysignalgen.sgle.rvalue.regaddr', int(new_val))


class RootSeqCxRbanaMemorysignalgenSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen.sgle'
        self.rvalue = RootSeqCxRbanaMemorysignalgenSgleRvalue(self._context)
        self.sampleno = RootSeqCxRbanaMemorysignalgenSgleSampleno(self._context)
        self.control = RootSeqCxRbanaMemorysignalgenSgleControl(self._context)
        self.wvalue = RootSeqCxRbanaMemorysignalgenSgleWvalue(self._context)
        self.increment = RootSeqCxRbanaMemorysignalgenSgleIncrement(self._context)
        self.out = RootSeqCxRbanaMemorysignalgenSgleOut(self._context)
        self.samplecnt = RootSeqCxRbanaMemorysignalgenSgleSamplecnt(self._context)
        self.status = RootSeqCxRbanaMemorysignalgenSgleStatus(self._context)


class RootSeqCxRbanaMemorysignalgen(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.memorysignalgen'
        self.sgle = RootSeqCxRbanaMemorysignalgenSgle(self._context)


class RootSeqCxRbanaOutfastCh4Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch4.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch4.offset.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh4Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch4.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch4.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh4Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch4.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch4.gain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh4Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch4.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch4.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch4'
        self.testvalue = RootSeqCxRbanaOutfastCh4Testvalue(self._context)
        self.gain = RootSeqCxRbanaOutfastCh4Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOutfastCh4Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOutfastCh4Offset(self._context)


class RootSeqCxRbanaOutfastCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch3.offset.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh3Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch3.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch3.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch3.gain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh3Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch3.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch3.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch3'
        self.testvalue = RootSeqCxRbanaOutfastCh3Testvalue(self._context)
        self.gain = RootSeqCxRbanaOutfastCh3Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOutfastCh3Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOutfastCh3Offset(self._context)


class RootSeqCxRbanaOutfastCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch2.offset.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh2Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch2.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch2.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch2.gain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh2Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch2.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch2.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch2'
        self.testvalue = RootSeqCxRbanaOutfastCh2Testvalue(self._context)
        self.gain = RootSeqCxRbanaOutfastCh2Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOutfastCh2Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOutfastCh2Offset(self._context)


class RootSeqCxRbanaOutfastCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch1.offset.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh1Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch1.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch1.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch1.gain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh1Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfast.ch1.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfast.ch1.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOutfastCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast.ch1'
        self.testvalue = RootSeqCxRbanaOutfastCh1Testvalue(self._context)
        self.gain = RootSeqCxRbanaOutfastCh1Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOutfastCh1Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOutfastCh1Offset(self._context)


class RootSeqCxRbanaOutfast(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfast'
        self.ch1 = RootSeqCxRbanaOutfastCh1(self._context)
        self.ch2 = RootSeqCxRbanaOutfastCh2(self._context)
        self.ch3 = RootSeqCxRbanaOutfastCh3(self._context)
        self.ch4 = RootSeqCxRbanaOutfastCh4(self._context)


class RootSeqCxRbanaEventmgrSgleStatusAbortevent(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.status.abortevent'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.abortevent.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStatusStopevent(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.status.stopevent'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.stopevent.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.status'
        self.busy = RootSeqCxRbanaEventmgrSgleStatusBusy(self._context)
        self.stopevent = RootSeqCxRbanaEventmgrSgleStatusStopevent(self._context)
        self.abortevent = RootSeqCxRbanaEventmgrSgleStatusAbortevent(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStopeventmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.stopeventmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.stopeventmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.stopeventmask.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStopmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.stopmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.stopmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.stopmask.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleEventvector(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.eventvector'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.eventvector.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.eventvector.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.start.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlSoftevent2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.softevent2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent2.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlSoftevent1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.softevent1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent1.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlSoftevent0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.softevent0'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent0.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlSoftevent3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.softevent3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.softevent3.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.control'
        self.stop = RootSeqCxRbanaEventmgrSgleControlStop(self._context)
        self.softevent3 = RootSeqCxRbanaEventmgrSgleControlSoftevent3(self._context)
        self.softevent0 = RootSeqCxRbanaEventmgrSgleControlSoftevent0(self._context)
        self.softevent1 = RootSeqCxRbanaEventmgrSgleControlSoftevent1(self._context)
        self.softevent2 = RootSeqCxRbanaEventmgrSgleControlSoftevent2(self._context)
        self.start = RootSeqCxRbanaEventmgrSgleControlStart(self._context)
        self.abort = RootSeqCxRbanaEventmgrSgleControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleStartmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.startmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.startmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.startmask.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleAndmask0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.andmask0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.andmask0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.andmask0.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleAborteventmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.aborteventmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.aborteventmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.aborteventmask.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgleEventsnapshot(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle.eventsnapshot'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.eventmgr.sgle.eventsnapshot.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.eventmgr.sgle.eventsnapshot.regaddr', int(new_val))


class RootSeqCxRbanaEventmgrSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr.sgle'
        self.eventsnapshot = RootSeqCxRbanaEventmgrSgleEventsnapshot(self._context)
        self.aborteventmask = RootSeqCxRbanaEventmgrSgleAborteventmask(self._context)
        self.andmask0 = RootSeqCxRbanaEventmgrSgleAndmask0(self._context)
        self.startmask = RootSeqCxRbanaEventmgrSgleStartmask(self._context)
        self.control = RootSeqCxRbanaEventmgrSgleControl(self._context)
        self.eventvector = RootSeqCxRbanaEventmgrSgleEventvector(self._context)
        self.stopmask = RootSeqCxRbanaEventmgrSgleStopmask(self._context)
        self.stopeventmask = RootSeqCxRbanaEventmgrSgleStopeventmask(self._context)
        self.status = RootSeqCxRbanaEventmgrSgleStatus(self._context)


class RootSeqCxRbanaEventmgr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.eventmgr'
        self.sgle = RootSeqCxRbanaEventmgrSgle(self._context)


class RootSeqCxRbanaComparatorComparator3Iircoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator3.iircoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.iircoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.iircoef.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator3ControlFilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator3.control.filterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.filterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.filterena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.filterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.filterena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.filterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.filterena.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator3ControlComparatorinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator3.control.comparatorinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.comparatorinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.comparatorinput.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.comparatorinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.comparatorinput.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.comparatorinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.comparatorinput.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator3ControlPolcomparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator3.control.polcomparator'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.polcomparator.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.polcomparator.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.polcomparator.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.polcomparator.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.polcomparator.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.polcomparator.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator3ControlInputiir_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator3.control.inputiir_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.inputiir_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.inputiir_vld.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.inputiir_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.inputiir_vld.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.inputiir_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.inputiir_vld.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator3Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator3.control'
        self.inputiir_vld = RootSeqCxRbanaComparatorComparator3ControlInputiir_vld(self._context)
        self.polcomparator = RootSeqCxRbanaComparatorComparator3ControlPolcomparator(self._context)
        self.comparatorinput = RootSeqCxRbanaComparatorComparator3ControlComparatorinput(self._context)
        self.filterena = RootSeqCxRbanaComparatorComparator3ControlFilterena(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.control.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator3Iiraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator3.iiraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.iiraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.iiraddr.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator3Level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator3.level'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator3.level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator3.level.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator3'
        self.level = RootSeqCxRbanaComparatorComparator3Level(self._context)
        self.iiraddr = RootSeqCxRbanaComparatorComparator3Iiraddr(self._context)
        self.control = RootSeqCxRbanaComparatorComparator3Control(self._context)
        self.iircoef = RootSeqCxRbanaComparatorComparator3Iircoef(self._context)


class RootSeqCxRbanaComparatorComparator1Iircoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator1.iircoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.iircoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.iircoef.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator1ControlFilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator1.control.filterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.filterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.filterena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.filterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.filterena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.filterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.filterena.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator1ControlComparatorinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator1.control.comparatorinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.comparatorinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.comparatorinput.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.comparatorinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.comparatorinput.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.comparatorinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.comparatorinput.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator1ControlPolcomparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator1.control.polcomparator'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.polcomparator.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.polcomparator.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.polcomparator.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.polcomparator.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.polcomparator.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.polcomparator.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator1ControlInputiir_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator1.control.inputiir_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.inputiir_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.inputiir_vld.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.inputiir_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.inputiir_vld.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.inputiir_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.inputiir_vld.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator1Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator1.control'
        self.inputiir_vld = RootSeqCxRbanaComparatorComparator1ControlInputiir_vld(self._context)
        self.polcomparator = RootSeqCxRbanaComparatorComparator1ControlPolcomparator(self._context)
        self.comparatorinput = RootSeqCxRbanaComparatorComparator1ControlComparatorinput(self._context)
        self.filterena = RootSeqCxRbanaComparatorComparator1ControlFilterena(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.control.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator1Iiraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator1.iiraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.iiraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.iiraddr.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator1Level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator1.level'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator1.level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator1.level.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator1'
        self.level = RootSeqCxRbanaComparatorComparator1Level(self._context)
        self.iiraddr = RootSeqCxRbanaComparatorComparator1Iiraddr(self._context)
        self.control = RootSeqCxRbanaComparatorComparator1Control(self._context)
        self.iircoef = RootSeqCxRbanaComparatorComparator1Iircoef(self._context)


class RootSeqCxRbanaComparatorComparator2Iircoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator2.iircoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.iircoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.iircoef.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator2ControlFilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator2.control.filterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.filterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.filterena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.filterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.filterena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.filterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.filterena.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator2ControlComparatorinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator2.control.comparatorinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.comparatorinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.comparatorinput.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.comparatorinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.comparatorinput.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.comparatorinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.comparatorinput.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator2ControlPolcomparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator2.control.polcomparator'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.polcomparator.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.polcomparator.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.polcomparator.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.polcomparator.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.polcomparator.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.polcomparator.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator2ControlInputiir_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator2.control.inputiir_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.inputiir_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.inputiir_vld.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.inputiir_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.inputiir_vld.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.inputiir_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.inputiir_vld.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator2Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator2.control'
        self.inputiir_vld = RootSeqCxRbanaComparatorComparator2ControlInputiir_vld(self._context)
        self.polcomparator = RootSeqCxRbanaComparatorComparator2ControlPolcomparator(self._context)
        self.comparatorinput = RootSeqCxRbanaComparatorComparator2ControlComparatorinput(self._context)
        self.filterena = RootSeqCxRbanaComparatorComparator2ControlFilterena(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.control.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator2Iiraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator2.iiraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.iiraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.iiraddr.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator2Level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator2.level'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.comparator.comparator2.level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.comparator.comparator2.level.regaddr', int(new_val))


class RootSeqCxRbanaComparatorComparator2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator.comparator2'
        self.level = RootSeqCxRbanaComparatorComparator2Level(self._context)
        self.iiraddr = RootSeqCxRbanaComparatorComparator2Iiraddr(self._context)
        self.control = RootSeqCxRbanaComparatorComparator2Control(self._context)
        self.iircoef = RootSeqCxRbanaComparatorComparator2Iircoef(self._context)


class RootSeqCxRbanaComparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.comparator'
        self.comparator2 = RootSeqCxRbanaComparatorComparator2(self._context)
        self.comparator1 = RootSeqCxRbanaComparatorComparator1(self._context)
        self.comparator3 = RootSeqCxRbanaComparatorComparator3(self._context)


class RootSeqCxRbanaInternaSgleControlRst8chconverters(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna.sgle.control.rst8chconverters'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.rst8chconverters.regaddr', int(new_val))


class RootSeqCxRbanaInternaSgleControlStatusled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna.sgle.control.statusled'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.statusled.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.statusled.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.statusled.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.statusled.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.statusled.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.statusled.regaddr', int(new_val))


class RootSeqCxRbanaInternaSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna.sgle.control'
        self.statusled = RootSeqCxRbanaInternaSgleControlStatusled(self._context)
        self.rst8chconverters = RootSeqCxRbanaInternaSgleControlRst8chconverters(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.interna.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.interna.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaInternaSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna.sgle'
        self.control = RootSeqCxRbanaInternaSgleControl(self._context)


class RootSeqCxRbanaInterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.interna'
        self.sgle = RootSeqCxRbanaInternaSgle(self._context)


class RootSeqCxRbanaDatasamplerSgleTimestamplastlsb(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.timestamplastlsb'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.timestamplastlsb.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.timestamplastlsb.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleDatapoint2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.datapoint2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.datapoint2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.datapoint2.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleDatapoint1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.datapoint1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.datapoint1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.datapoint1.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleValue3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.value3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.value3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.value3.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleTimestampfirstlsb(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.timestampfirstlsb'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.timestampfirstlsb.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.timestampfirstlsb.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.start.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleControlFlushfifo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.control.flushfifo'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.flushfifo.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.flushfifo.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.flushfifo.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.flushfifo.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.flushfifo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.flushfifo.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleControlSyncwithzctrlex(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.control.syncwithzctrlex'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.syncwithzctrlex.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.syncwithzctrlex.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.syncwithzctrlex.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.syncwithzctrlex.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.syncwithzctrlex.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.syncwithzctrlex.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.control'
        self.syncwithzctrlex = RootSeqCxRbanaDatasamplerSgleControlSyncwithzctrlex(self._context)
        self.flushfifo = RootSeqCxRbanaDatasamplerSgleControlFlushfifo(self._context)
        self.mode = RootSeqCxRbanaDatasamplerSgleControlMode(self._context)
        self.stop = RootSeqCxRbanaDatasamplerSgleControlStop(self._context)
        self.start = RootSeqCxRbanaDatasamplerSgleControlStart(self._context)
        self.abort = RootSeqCxRbanaDatasamplerSgleControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleTimestampfirstmsb(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.timestampfirstmsb'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.timestampfirstmsb.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.timestampfirstmsb.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleEvents(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.events'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.events.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.events.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleStatusEventcount(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.status.eventcount'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.status.eventcount.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.status.eventcount.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.status.eventcount.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.status.eventcount.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.status.eventcount.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.status.eventcount.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.status'
        self.busy = RootSeqCxRbanaDatasamplerSgleStatusBusy(self._context)
        self.eventcount = RootSeqCxRbanaDatasamplerSgleStatusEventcount(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleTimestamplastmsb(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.timestamplastmsb'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.timestamplastmsb.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.timestamplastmsb.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleDatapoint3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.datapoint3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.datapoint3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.datapoint3.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleValue0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.value0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.value0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.value0.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleDatapoint0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.datapoint0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.datapoint0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.datapoint0.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleValue1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.value1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.value1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.value1.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgleValue2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.value2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.value2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.value2.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSglePhasenbr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle.phasenbr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.datasampler.sgle.phasenbr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.datasampler.sgle.phasenbr.regaddr', int(new_val))


class RootSeqCxRbanaDatasamplerSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler.sgle'
        self.phasenbr = RootSeqCxRbanaDatasamplerSglePhasenbr(self._context)
        self.value2 = RootSeqCxRbanaDatasamplerSgleValue2(self._context)
        self.value1 = RootSeqCxRbanaDatasamplerSgleValue1(self._context)
        self.datapoint0 = RootSeqCxRbanaDatasamplerSgleDatapoint0(self._context)
        self.value0 = RootSeqCxRbanaDatasamplerSgleValue0(self._context)
        self.datapoint3 = RootSeqCxRbanaDatasamplerSgleDatapoint3(self._context)
        self.timestamplastmsb = RootSeqCxRbanaDatasamplerSgleTimestamplastmsb(self._context)
        self.status = RootSeqCxRbanaDatasamplerSgleStatus(self._context)
        self.events = RootSeqCxRbanaDatasamplerSgleEvents(self._context)
        self.timestampfirstmsb = RootSeqCxRbanaDatasamplerSgleTimestampfirstmsb(self._context)
        self.control = RootSeqCxRbanaDatasamplerSgleControl(self._context)
        self.timestampfirstlsb = RootSeqCxRbanaDatasamplerSgleTimestampfirstlsb(self._context)
        self.value3 = RootSeqCxRbanaDatasamplerSgleValue3(self._context)
        self.datapoint1 = RootSeqCxRbanaDatasamplerSgleDatapoint1(self._context)
        self.datapoint2 = RootSeqCxRbanaDatasamplerSgleDatapoint2(self._context)
        self.timestamplastlsb = RootSeqCxRbanaDatasamplerSgleTimestamplastlsb(self._context)


class RootSeqCxRbanaDatasampler(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.datasampler'
        self.sgle = RootSeqCxRbanaDatasamplerSgle(self._context)


class RootSeqCxRbanaOutfastcommonSgleDampinggain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.dampinggain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.dampinggain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.dampinggain.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation1.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation3.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlSelectout3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.selectout3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout3.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlSelectout4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.selectout4'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout4.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddamping4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping4.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddamping2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping2.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation2.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddamping3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping3.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlSelectout2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.selectout2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout2.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalmodulation4.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddamping1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddamping1.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControlSelectout1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control.selectout1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.selectout1.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle.control'
        self.selectout1 = RootSeqCxRbanaOutfastcommonSgleControlSelectout1(self._context)
        self.adddigitalhiresmodulation2 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation2(self._context)
        self.adddamping1 = RootSeqCxRbanaOutfastcommonSgleControlAdddamping1(self._context)
        self.adddigitalmodulation4 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation4(self._context)
        self.adddigitalhiresmodulation1 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation1(self._context)
        self.selectout2 = RootSeqCxRbanaOutfastcommonSgleControlSelectout2(self._context)
        self.adddigitalhiresmodulation4 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation4(self._context)
        self.adddamping3 = RootSeqCxRbanaOutfastcommonSgleControlAdddamping3(self._context)
        self.adddigitalmodulation2 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation2(self._context)
        self.adddigitalhiresmodulation3 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalhiresmodulation3(self._context)
        self.adddamping2 = RootSeqCxRbanaOutfastcommonSgleControlAdddamping2(self._context)
        self.adddamping4 = RootSeqCxRbanaOutfastcommonSgleControlAdddamping4(self._context)
        self.selectout4 = RootSeqCxRbanaOutfastcommonSgleControlSelectout4(self._context)
        self.selectout3 = RootSeqCxRbanaOutfastcommonSgleControlSelectout3(self._context)
        self.adddigitalmodulation3 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation3(self._context)
        self.adddigitalmodulation1 = RootSeqCxRbanaOutfastcommonSgleControlAdddigitalmodulation1(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outfastcommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outfastcommon.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaOutfastcommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon.sgle'
        self.control = RootSeqCxRbanaOutfastcommonSgleControl(self._context)
        self.dampinggain = RootSeqCxRbanaOutfastcommonSgleDampinggain(self._context)


class RootSeqCxRbanaOutfastcommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outfastcommon'
        self.sgle = RootSeqCxRbanaOutfastcommonSgle(self._context)


class RootSeqCxRbanaPidPidyGain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.gain_p.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyMinvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.minvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.offset.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyStatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.reachederrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.reachederrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.reachederrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyStatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.reachedmax.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.reachedmax.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.reachedmax.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyStatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.internaloaded.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.internaloaded.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.internaloaded.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyStatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.reachedmin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.reachedmin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.reachedmin.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.status'
        self.reachedmin = RootSeqCxRbanaPidPidyStatusReachedmin(self._context)
        self.internaloaded = RootSeqCxRbanaPidPidyStatusInternaloaded(self._context)
        self.reachedmax = RootSeqCxRbanaPidPidyStatusReachedmax(self._context)
        self.reachederrlim = RootSeqCxRbanaPidPidyStatusReachederrlim(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.status.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyGain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.gain_i.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.memorygendriveena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.memorygendriveena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.memorygendriveena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.modena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.modena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.modena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.pidinputactual.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.pidinputactual.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.pidinputactual.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.medianfilterena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.medianfilterena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.medianfilterena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.outsel.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.outsel.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.outsel.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.pidinputsetpoint.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.pidinputsetpoint.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.pidinputsetpoint.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.polpidin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.polpidin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.polpidin.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.memorygenpositionena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.memorygenpositionena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.memorygenpositionena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.loadinterna.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.loadinterna.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.loadinterna.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.polcomperrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.polcomperrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.polcomperrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.control'
        self.polcomperrlim = RootSeqCxRbanaPidPidyControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqCxRbanaPidPidyControlLoadinterna(self._context)
        self.memorygenpositionena = RootSeqCxRbanaPidPidyControlMemorygenpositionena(self._context)
        self.polpidin = RootSeqCxRbanaPidPidyControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqCxRbanaPidPidyControlPidinputsetpoint(self._context)
        self.outsel = RootSeqCxRbanaPidPidyControlOutsel(self._context)
        self.medianfilterena = RootSeqCxRbanaPidPidyControlMedianfilterena(self._context)
        self.pidinputactual = RootSeqCxRbanaPidPidyControlPidinputactual(self._context)
        self.modena = RootSeqCxRbanaPidPidyControlModena(self._context)
        self.mode = RootSeqCxRbanaPidPidyControlMode(self._context)
        self.memorygendriveena = RootSeqCxRbanaPidPidyControlMemorygendriveena(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.control.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyGain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.gain_d.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyMaxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.maxvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyPreloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.preloadvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyErrorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.errorlimit.regaddr', int(new_val))


class RootSeqCxRbanaPidPidyConversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.conversion.regaddr', int(new_val))


class RootSeqCxRbanaPidPidySlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidy.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidy.slope.regaddr', int(new_val))


class RootSeqCxRbanaPidPidy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidy'
        self.slope = RootSeqCxRbanaPidPidySlope(self._context)
        self.conversion = RootSeqCxRbanaPidPidyConversion(self._context)
        self.errorlimit = RootSeqCxRbanaPidPidyErrorlimit(self._context)
        self.preloadvalue = RootSeqCxRbanaPidPidyPreloadvalue(self._context)
        self.maxvalue = RootSeqCxRbanaPidPidyMaxvalue(self._context)
        self.gain_d = RootSeqCxRbanaPidPidyGain_d(self._context)
        self.control = RootSeqCxRbanaPidPidyControl(self._context)
        self.gain_i = RootSeqCxRbanaPidPidyGain_i(self._context)
        self.status = RootSeqCxRbanaPidPidyStatus(self._context)
        self.offset = RootSeqCxRbanaPidPidyOffset(self._context)
        self.minvalue = RootSeqCxRbanaPidPidyMinvalue(self._context)
        self.gain_p = RootSeqCxRbanaPidPidyGain_p(self._context)


class RootSeqCxRbanaPidPidwGain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.gain_p.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwMinvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.minvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.offset.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwStatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.reachederrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.reachederrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.reachederrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwStatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.reachedmax.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.reachedmax.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.reachedmax.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwStatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.internaloaded.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.internaloaded.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.internaloaded.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwStatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.reachedmin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.reachedmin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.reachedmin.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.status'
        self.reachedmin = RootSeqCxRbanaPidPidwStatusReachedmin(self._context)
        self.internaloaded = RootSeqCxRbanaPidPidwStatusInternaloaded(self._context)
        self.reachedmax = RootSeqCxRbanaPidPidwStatusReachedmax(self._context)
        self.reachederrlim = RootSeqCxRbanaPidPidwStatusReachederrlim(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.status.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwGain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.gain_i.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.memorygendriveena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.memorygendriveena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.memorygendriveena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.modena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.modena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.modena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.pidinputactual.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.pidinputactual.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.pidinputactual.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.medianfilterena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.medianfilterena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.medianfilterena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.outsel.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.outsel.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.outsel.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.pidinputsetpoint.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.pidinputsetpoint.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.pidinputsetpoint.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.polpidin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.polpidin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.polpidin.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.memorygenpositionena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.memorygenpositionena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.memorygenpositionena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.loadinterna.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.loadinterna.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.loadinterna.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.polcomperrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.polcomperrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.polcomperrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.control'
        self.polcomperrlim = RootSeqCxRbanaPidPidwControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqCxRbanaPidPidwControlLoadinterna(self._context)
        self.memorygenpositionena = RootSeqCxRbanaPidPidwControlMemorygenpositionena(self._context)
        self.polpidin = RootSeqCxRbanaPidPidwControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqCxRbanaPidPidwControlPidinputsetpoint(self._context)
        self.outsel = RootSeqCxRbanaPidPidwControlOutsel(self._context)
        self.medianfilterena = RootSeqCxRbanaPidPidwControlMedianfilterena(self._context)
        self.pidinputactual = RootSeqCxRbanaPidPidwControlPidinputactual(self._context)
        self.modena = RootSeqCxRbanaPidPidwControlModena(self._context)
        self.mode = RootSeqCxRbanaPidPidwControlMode(self._context)
        self.memorygendriveena = RootSeqCxRbanaPidPidwControlMemorygendriveena(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.control.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwGain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.gain_d.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwMaxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.maxvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwPreloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.preloadvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwErrorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.errorlimit.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwConversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.conversion.regaddr', int(new_val))


class RootSeqCxRbanaPidPidwSlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidw.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidw.slope.regaddr', int(new_val))


class RootSeqCxRbanaPidPidw(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidw'
        self.slope = RootSeqCxRbanaPidPidwSlope(self._context)
        self.conversion = RootSeqCxRbanaPidPidwConversion(self._context)
        self.errorlimit = RootSeqCxRbanaPidPidwErrorlimit(self._context)
        self.preloadvalue = RootSeqCxRbanaPidPidwPreloadvalue(self._context)
        self.maxvalue = RootSeqCxRbanaPidPidwMaxvalue(self._context)
        self.gain_d = RootSeqCxRbanaPidPidwGain_d(self._context)
        self.control = RootSeqCxRbanaPidPidwControl(self._context)
        self.gain_i = RootSeqCxRbanaPidPidwGain_i(self._context)
        self.status = RootSeqCxRbanaPidPidwStatus(self._context)
        self.offset = RootSeqCxRbanaPidPidwOffset(self._context)
        self.minvalue = RootSeqCxRbanaPidPidwMinvalue(self._context)
        self.gain_p = RootSeqCxRbanaPidPidwGain_p(self._context)


class RootSeqCxRbanaPidPidxGain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.gain_p.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxMinvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.minvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.offset.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxStatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.reachederrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.reachederrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.reachederrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxStatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.reachedmax.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.reachedmax.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.reachedmax.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxStatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.internaloaded.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.internaloaded.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.internaloaded.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxStatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.reachedmin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.reachedmin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.reachedmin.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.status'
        self.reachedmin = RootSeqCxRbanaPidPidxStatusReachedmin(self._context)
        self.internaloaded = RootSeqCxRbanaPidPidxStatusInternaloaded(self._context)
        self.reachedmax = RootSeqCxRbanaPidPidxStatusReachedmax(self._context)
        self.reachederrlim = RootSeqCxRbanaPidPidxStatusReachederrlim(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.status.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxGain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.gain_i.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.memorygendriveena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.memorygendriveena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.memorygendriveena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.modena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.modena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.modena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.pidinputactual.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.pidinputactual.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.pidinputactual.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.medianfilterena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.medianfilterena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.medianfilterena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.outsel.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.outsel.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.outsel.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.pidinputsetpoint.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.pidinputsetpoint.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.pidinputsetpoint.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.polpidin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.polpidin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.polpidin.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.memorygenpositionena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.memorygenpositionena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.memorygenpositionena.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.loadinterna.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.loadinterna.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.loadinterna.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.polcomperrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.polcomperrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.polcomperrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.control'
        self.polcomperrlim = RootSeqCxRbanaPidPidxControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqCxRbanaPidPidxControlLoadinterna(self._context)
        self.memorygenpositionena = RootSeqCxRbanaPidPidxControlMemorygenpositionena(self._context)
        self.polpidin = RootSeqCxRbanaPidPidxControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqCxRbanaPidPidxControlPidinputsetpoint(self._context)
        self.outsel = RootSeqCxRbanaPidPidxControlOutsel(self._context)
        self.medianfilterena = RootSeqCxRbanaPidPidxControlMedianfilterena(self._context)
        self.pidinputactual = RootSeqCxRbanaPidPidxControlPidinputactual(self._context)
        self.modena = RootSeqCxRbanaPidPidxControlModena(self._context)
        self.mode = RootSeqCxRbanaPidPidxControlMode(self._context)
        self.memorygendriveena = RootSeqCxRbanaPidPidxControlMemorygendriveena(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.control.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxGain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.gain_d.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxMaxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.maxvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxPreloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.preloadvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxErrorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.errorlimit.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxConversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.conversion.regaddr', int(new_val))


class RootSeqCxRbanaPidPidxSlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.pidx.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.pidx.slope.regaddr', int(new_val))


class RootSeqCxRbanaPidPidx(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.pidx'
        self.slope = RootSeqCxRbanaPidPidxSlope(self._context)
        self.conversion = RootSeqCxRbanaPidPidxConversion(self._context)
        self.errorlimit = RootSeqCxRbanaPidPidxErrorlimit(self._context)
        self.preloadvalue = RootSeqCxRbanaPidPidxPreloadvalue(self._context)
        self.maxvalue = RootSeqCxRbanaPidPidxMaxvalue(self._context)
        self.gain_d = RootSeqCxRbanaPidPidxGain_d(self._context)
        self.control = RootSeqCxRbanaPidPidxControl(self._context)
        self.gain_i = RootSeqCxRbanaPidPidxGain_i(self._context)
        self.status = RootSeqCxRbanaPidPidxStatus(self._context)
        self.offset = RootSeqCxRbanaPidPidxOffset(self._context)
        self.minvalue = RootSeqCxRbanaPidPidxMinvalue(self._context)
        self.gain_p = RootSeqCxRbanaPidPidxGain_p(self._context)


class RootSeqCxRbanaPidPiduser1Gain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.gain_p.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Minvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.minvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.offset.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1StatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.reachederrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.reachederrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.reachederrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1StatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.reachedmax.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.reachedmax.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.reachedmax.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1StatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.internaloaded.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.internaloaded.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.internaloaded.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1StatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.reachedmin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.reachedmin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.reachedmin.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.status'
        self.reachedmin = RootSeqCxRbanaPidPiduser1StatusReachedmin(self._context)
        self.internaloaded = RootSeqCxRbanaPidPiduser1StatusInternaloaded(self._context)
        self.reachedmax = RootSeqCxRbanaPidPiduser1StatusReachedmax(self._context)
        self.reachederrlim = RootSeqCxRbanaPidPiduser1StatusReachederrlim(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.status.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Gain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.gain_i.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.memorygendriveena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.memorygendriveena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.memorygendriveena.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.modena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.modena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.modena.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.pidinputactual.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.pidinputactual.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.pidinputactual.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.medianfilterena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.medianfilterena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.medianfilterena.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.outsel.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.outsel.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.outsel.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.pidinputsetpoint.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.pidinputsetpoint.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.pidinputsetpoint.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.polpidin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.polpidin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.polpidin.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.memorygenpositionena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.memorygenpositionena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.memorygenpositionena.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.loadinterna.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.loadinterna.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.loadinterna.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1ControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.polcomperrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.polcomperrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.polcomperrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.control'
        self.polcomperrlim = RootSeqCxRbanaPidPiduser1ControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqCxRbanaPidPiduser1ControlLoadinterna(self._context)
        self.memorygenpositionena = RootSeqCxRbanaPidPiduser1ControlMemorygenpositionena(self._context)
        self.polpidin = RootSeqCxRbanaPidPiduser1ControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqCxRbanaPidPiduser1ControlPidinputsetpoint(self._context)
        self.outsel = RootSeqCxRbanaPidPiduser1ControlOutsel(self._context)
        self.medianfilterena = RootSeqCxRbanaPidPiduser1ControlMedianfilterena(self._context)
        self.pidinputactual = RootSeqCxRbanaPidPiduser1ControlPidinputactual(self._context)
        self.modena = RootSeqCxRbanaPidPiduser1ControlModena(self._context)
        self.mode = RootSeqCxRbanaPidPiduser1ControlMode(self._context)
        self.memorygendriveena = RootSeqCxRbanaPidPiduser1ControlMemorygendriveena(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.control.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Gain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.gain_d.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Maxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.maxvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Preloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.preloadvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Errorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.errorlimit.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Conversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.conversion.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1Slope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser1.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser1.slope.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser1'
        self.slope = RootSeqCxRbanaPidPiduser1Slope(self._context)
        self.conversion = RootSeqCxRbanaPidPiduser1Conversion(self._context)
        self.errorlimit = RootSeqCxRbanaPidPiduser1Errorlimit(self._context)
        self.preloadvalue = RootSeqCxRbanaPidPiduser1Preloadvalue(self._context)
        self.maxvalue = RootSeqCxRbanaPidPiduser1Maxvalue(self._context)
        self.gain_d = RootSeqCxRbanaPidPiduser1Gain_d(self._context)
        self.control = RootSeqCxRbanaPidPiduser1Control(self._context)
        self.gain_i = RootSeqCxRbanaPidPiduser1Gain_i(self._context)
        self.status = RootSeqCxRbanaPidPiduser1Status(self._context)
        self.offset = RootSeqCxRbanaPidPiduser1Offset(self._context)
        self.minvalue = RootSeqCxRbanaPidPiduser1Minvalue(self._context)
        self.gain_p = RootSeqCxRbanaPidPiduser1Gain_p(self._context)


class RootSeqCxRbanaPidPiduser2Gain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.gain_p.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Minvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.minvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.offset.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2StatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.reachederrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.reachederrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.reachederrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2StatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.reachedmax.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.reachedmax.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.reachedmax.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2StatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.internaloaded.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.internaloaded.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.internaloaded.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2StatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.reachedmin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.reachedmin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.reachedmin.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.status'
        self.reachedmin = RootSeqCxRbanaPidPiduser2StatusReachedmin(self._context)
        self.internaloaded = RootSeqCxRbanaPidPiduser2StatusInternaloaded(self._context)
        self.reachedmax = RootSeqCxRbanaPidPiduser2StatusReachedmax(self._context)
        self.reachederrlim = RootSeqCxRbanaPidPiduser2StatusReachederrlim(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.status.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Gain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.gain_i.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.memorygendriveena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.memorygendriveena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.memorygendriveena.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.modena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.modena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.modena.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.pidinputactual.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.pidinputactual.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.pidinputactual.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.medianfilterena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.medianfilterena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.medianfilterena.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.outsel.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.outsel.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.outsel.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.pidinputsetpoint.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.pidinputsetpoint.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.pidinputsetpoint.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.polpidin.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.polpidin.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.polpidin.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.memorygenpositionena.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.memorygenpositionena.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.memorygenpositionena.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.loadinterna.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.loadinterna.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.loadinterna.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2ControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.polcomperrlim.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.polcomperrlim.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.polcomperrlim.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.control'
        self.polcomperrlim = RootSeqCxRbanaPidPiduser2ControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqCxRbanaPidPiduser2ControlLoadinterna(self._context)
        self.memorygenpositionena = RootSeqCxRbanaPidPiduser2ControlMemorygenpositionena(self._context)
        self.polpidin = RootSeqCxRbanaPidPiduser2ControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqCxRbanaPidPiduser2ControlPidinputsetpoint(self._context)
        self.outsel = RootSeqCxRbanaPidPiduser2ControlOutsel(self._context)
        self.medianfilterena = RootSeqCxRbanaPidPiduser2ControlMedianfilterena(self._context)
        self.pidinputactual = RootSeqCxRbanaPidPiduser2ControlPidinputactual(self._context)
        self.modena = RootSeqCxRbanaPidPiduser2ControlModena(self._context)
        self.mode = RootSeqCxRbanaPidPiduser2ControlMode(self._context)
        self.memorygendriveena = RootSeqCxRbanaPidPiduser2ControlMemorygendriveena(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.control.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Gain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.gain_d.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Maxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.maxvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Preloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.preloadvalue.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Errorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.errorlimit.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Conversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.conversion.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2Slope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.pid.piduser2.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.pid.piduser2.slope.regaddr', int(new_val))


class RootSeqCxRbanaPidPiduser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid.piduser2'
        self.slope = RootSeqCxRbanaPidPiduser2Slope(self._context)
        self.conversion = RootSeqCxRbanaPidPiduser2Conversion(self._context)
        self.errorlimit = RootSeqCxRbanaPidPiduser2Errorlimit(self._context)
        self.preloadvalue = RootSeqCxRbanaPidPiduser2Preloadvalue(self._context)
        self.maxvalue = RootSeqCxRbanaPidPiduser2Maxvalue(self._context)
        self.gain_d = RootSeqCxRbanaPidPiduser2Gain_d(self._context)
        self.control = RootSeqCxRbanaPidPiduser2Control(self._context)
        self.gain_i = RootSeqCxRbanaPidPiduser2Gain_i(self._context)
        self.status = RootSeqCxRbanaPidPiduser2Status(self._context)
        self.offset = RootSeqCxRbanaPidPiduser2Offset(self._context)
        self.minvalue = RootSeqCxRbanaPidPiduser2Minvalue(self._context)
        self.gain_p = RootSeqCxRbanaPidPiduser2Gain_p(self._context)


class RootSeqCxRbanaPid(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.pid'
        self.piduser2 = RootSeqCxRbanaPidPiduser2(self._context)
        self.piduser1 = RootSeqCxRbanaPidPiduser1(self._context)
        self.pidx = RootSeqCxRbanaPidPidx(self._context)
        self.pidw = RootSeqCxRbanaPidPidw(self._context)
        self.pidy = RootSeqCxRbanaPidPidy(self._context)


class RootSeqCxRbanaOuthirescommonSgleControlGpflt_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.gpflt_vld.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleControlSelectmod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.control.selectmod'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.selectmod.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleControlOuthires_dac8delay(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.outhires_dac8delay.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.control'
        self.outhires_dac8delay = RootSeqCxRbanaOuthirescommonSgleControlOuthires_dac8delay(self._context)
        self.selectmod = RootSeqCxRbanaOuthirescommonSgleControlSelectmod(self._context)
        self.gpflt_vld = RootSeqCxRbanaOuthirescommonSgleControlGpflt_vld(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleGpfiltraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.gpfiltraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.gpfiltraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.gpfiltraddr.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgleGpfiltrcoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle.gpfiltrcoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhirescommon.sgle.gpfiltrcoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhirescommon.sgle.gpfiltrcoef.regaddr', int(new_val))


class RootSeqCxRbanaOuthirescommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon.sgle'
        self.gpfiltrcoef = RootSeqCxRbanaOuthirescommonSgleGpfiltrcoef(self._context)
        self.gpfiltraddr = RootSeqCxRbanaOuthirescommonSgleGpfiltraddr(self._context)
        self.control = RootSeqCxRbanaOuthirescommonSgleControl(self._context)


class RootSeqCxRbanaOuthirescommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhirescommon'
        self.sgle = RootSeqCxRbanaOuthirescommonSgle(self._context)


class RootSeqCxRbanaGpiSgleOdata(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.odata'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.odata.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.odata.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecRampgenuser4done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgenuser4done.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecRampgentestdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.rampgentestdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecUserdigi1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi1.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecEventmgrabort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrabort.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecEventmgrdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecEventmgrstop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.eventmgrstop.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvecUserdigi2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.userdigi2.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqvec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqvec'
        self.userdigi2 = RootSeqCxRbanaGpiSgleIrqvecUserdigi2(self._context)
        self.eventmgrstop = RootSeqCxRbanaGpiSgleIrqvecEventmgrstop(self._context)
        self.eventmgrdone = RootSeqCxRbanaGpiSgleIrqvecEventmgrdone(self._context)
        self.eventmgrabort = RootSeqCxRbanaGpiSgleIrqvecEventmgrabort(self._context)
        self.userdigi1 = RootSeqCxRbanaGpiSgleIrqvecUserdigi1(self._context)
        self.rampgentestdone = RootSeqCxRbanaGpiSgleIrqvecRampgentestdone(self._context)
        self.rampgenuser4done = RootSeqCxRbanaGpiSgleIrqvecRampgenuser4done(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqvec.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqvec.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataRampgenuser4done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgenuser4done.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataRampgentestdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.rampgentestdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataUserdigi1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.userdigi1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi1.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataEventmgrabort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrabort.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataEventmgrdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataEventmgrstop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.eventmgrstop.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdataUserdigi2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata.userdigi2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.userdigi2.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIdata(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.idata'
        self.userdigi2 = RootSeqCxRbanaGpiSgleIdataUserdigi2(self._context)
        self.eventmgrstop = RootSeqCxRbanaGpiSgleIdataEventmgrstop(self._context)
        self.eventmgrdone = RootSeqCxRbanaGpiSgleIdataEventmgrdone(self._context)
        self.eventmgrabort = RootSeqCxRbanaGpiSgleIdataEventmgrabort(self._context)
        self.userdigi1 = RootSeqCxRbanaGpiSgleIdataUserdigi1(self._context)
        self.rampgentestdone = RootSeqCxRbanaGpiSgleIdataRampgentestdone(self._context)
        self.rampgenuser4done = RootSeqCxRbanaGpiSgleIdataRampgenuser4done(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.idata.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.idata.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaRampgenuser4done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgenuser4done.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaRampgentestdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.rampgentestdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaUserdigi1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.userdigi1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi1.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaEventmgrabort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrabort.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaEventmgrdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrdone.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaEventmgrstop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.eventmgrstop.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqenaUserdigi2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena.userdigi2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.userdigi2.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgleIrqena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle.irqena'
        self.userdigi2 = RootSeqCxRbanaGpiSgleIrqenaUserdigi2(self._context)
        self.eventmgrstop = RootSeqCxRbanaGpiSgleIrqenaEventmgrstop(self._context)
        self.eventmgrdone = RootSeqCxRbanaGpiSgleIrqenaEventmgrdone(self._context)
        self.eventmgrabort = RootSeqCxRbanaGpiSgleIrqenaEventmgrabort(self._context)
        self.userdigi1 = RootSeqCxRbanaGpiSgleIrqenaUserdigi1(self._context)
        self.rampgentestdone = RootSeqCxRbanaGpiSgleIrqenaRampgentestdone(self._context)
        self.rampgenuser4done = RootSeqCxRbanaGpiSgleIrqenaRampgenuser4done(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.gpi.sgle.irqena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.gpi.sgle.irqena.regaddr', int(new_val))


class RootSeqCxRbanaGpiSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi.sgle'
        self.irqena = RootSeqCxRbanaGpiSgleIrqena(self._context)
        self.idata = RootSeqCxRbanaGpiSgleIdata(self._context)
        self.irqvec = RootSeqCxRbanaGpiSgleIrqvec(self._context)
        self.odata = RootSeqCxRbanaGpiSgleOdata(self._context)


class RootSeqCxRbanaGpi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.gpi'
        self.sgle = RootSeqCxRbanaGpiSgle(self._context)


class RootSeqCxRbanaOuthiresCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh3ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh3ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh3ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh3ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch3.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch3.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch3'
        self.slewrate = RootSeqCxRbanaOuthiresCh3Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh3Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh3Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh3Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh3Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh3Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh3Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh3Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh3Offset(self._context)


class RootSeqCxRbanaOuthiresCh10Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh10ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh10ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh10ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh10ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch10.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch10.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh10(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch10'
        self.slewrate = RootSeqCxRbanaOuthiresCh10Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh10Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh10Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh10Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh10Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh10Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh10Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh10Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh10Offset(self._context)


class RootSeqCxRbanaOuthiresCh11Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh11ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh11ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh11ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh11ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch11.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch11.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh11(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch11'
        self.slewrate = RootSeqCxRbanaOuthiresCh11Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh11Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh11Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh11Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh11Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh11Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh11Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh11Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh11Offset(self._context)


class RootSeqCxRbanaOuthiresCh12Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh12ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh12ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh12ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh12ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch12.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch12.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh12(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch12'
        self.slewrate = RootSeqCxRbanaOuthiresCh12Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh12Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh12Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh12Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh12Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh12Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh12Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh12Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh12Offset(self._context)


class RootSeqCxRbanaOuthiresCh4Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh4ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh4ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh4ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh4ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch4.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch4.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch4'
        self.slewrate = RootSeqCxRbanaOuthiresCh4Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh4Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh4Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh4Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh4Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh4Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh4Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh4Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh4Offset(self._context)


class RootSeqCxRbanaOuthiresCh7Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh7ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh7ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh7ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh7ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch7.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch7.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch7'
        self.slewrate = RootSeqCxRbanaOuthiresCh7Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh7Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh7Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh7Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh7Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh7Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh7Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh7Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh7Offset(self._context)


class RootSeqCxRbanaOuthiresCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh2ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh2ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh2ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh2ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch2.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch2.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch2'
        self.slewrate = RootSeqCxRbanaOuthiresCh2Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh2Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh2Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh2Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh2Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh2Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh2Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh2Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh2Offset(self._context)


class RootSeqCxRbanaOuthiresCh9Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh9ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh9ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh9ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh9ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch9.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch9.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh9(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch9'
        self.slewrate = RootSeqCxRbanaOuthiresCh9Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh9Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh9Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh9Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh9Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh9Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh9Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh9Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh9Offset(self._context)


class RootSeqCxRbanaOuthiresCh6Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh6ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh6ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh6ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh6ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch6.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch6.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch6'
        self.slewrate = RootSeqCxRbanaOuthiresCh6Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh6Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh6Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh6Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh6Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh6Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh6Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh6Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh6Offset(self._context)


class RootSeqCxRbanaOuthiresCh5Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh5ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh5ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh5ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh5ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch5.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch5.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh5(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch5'
        self.slewrate = RootSeqCxRbanaOuthiresCh5Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh5Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh5Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh5Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh5Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh5Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh5Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh5Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh5Offset(self._context)


class RootSeqCxRbanaOuthiresCh8Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh8ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh8ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh8ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh8ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch8.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch8.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh8(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch8'
        self.slewrate = RootSeqCxRbanaOuthiresCh8Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh8Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh8Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh8Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh8Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh8Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh8Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh8Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh8Offset(self._context)


class RootSeqCxRbanaOuthiresCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.offset.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.currentoutval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.gain.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.lowordgaincorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.adddigitalmodulation.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.glitchcorr.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.selectout.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.selectout.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.selectout.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.bypassfilter.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.control'
        self.bypassfilter = RootSeqCxRbanaOuthiresCh1ControlBypassfilter(self._context)
        self.selectout = RootSeqCxRbanaOuthiresCh1ControlSelectout(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh1ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqCxRbanaOuthiresCh1ControlAdddigitalmodulation(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.control.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.testvalue.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.filterval.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.outhires.ch1.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.outhires.ch1.slewrate.regaddr', int(new_val))


class RootSeqCxRbanaOuthiresCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires.ch1'
        self.slewrate = RootSeqCxRbanaOuthiresCh1Slewrate(self._context)
        self.filterval = RootSeqCxRbanaOuthiresCh1Filterval(self._context)
        self.testvalue = RootSeqCxRbanaOuthiresCh1Testvalue(self._context)
        self.control = RootSeqCxRbanaOuthiresCh1Control(self._context)
        self.glitchcorr = RootSeqCxRbanaOuthiresCh1Glitchcorr(self._context)
        self.lowordgaincorr = RootSeqCxRbanaOuthiresCh1Lowordgaincorr(self._context)
        self.gain = RootSeqCxRbanaOuthiresCh1Gain(self._context)
        self.currentoutval = RootSeqCxRbanaOuthiresCh1Currentoutval(self._context)
        self.offset = RootSeqCxRbanaOuthiresCh1Offset(self._context)


class RootSeqCxRbanaOuthires(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.outhires'
        self.ch1 = RootSeqCxRbanaOuthiresCh1(self._context)
        self.ch8 = RootSeqCxRbanaOuthiresCh8(self._context)
        self.ch5 = RootSeqCxRbanaOuthiresCh5(self._context)
        self.ch6 = RootSeqCxRbanaOuthiresCh6(self._context)
        self.ch9 = RootSeqCxRbanaOuthiresCh9(self._context)
        self.ch2 = RootSeqCxRbanaOuthiresCh2(self._context)
        self.ch7 = RootSeqCxRbanaOuthiresCh7(self._context)
        self.ch4 = RootSeqCxRbanaOuthiresCh4(self._context)
        self.ch12 = RootSeqCxRbanaOuthiresCh12(self._context)
        self.ch11 = RootSeqCxRbanaOuthiresCh11(self._context)
        self.ch10 = RootSeqCxRbanaOuthiresCh10(self._context)
        self.ch3 = RootSeqCxRbanaOuthiresCh3(self._context)


class RootSeqCxRbanaInhiresCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch3.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch3.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch3'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh3Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh3Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh3Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh3Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh3Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh3Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh3Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh3Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh3Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh3Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh3Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh3Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh3Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh3Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh3Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh3Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh3Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh3Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh3Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh3Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh3Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh3Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh3Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh3Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh3Offset(self._context)


class RootSeqCxRbanaInhiresCh10Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch10.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch10.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh10(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch10'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh10Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh10Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh10Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh10Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh10Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh10Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh10Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh10Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh10Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh10Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh10Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh10Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh10Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh10Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh10Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh10Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh10Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh10Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh10Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh10Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh10Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh10Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh10Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh10Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh10Offset(self._context)


class RootSeqCxRbanaInhiresCh11Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch11.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch11.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh11(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch11'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh11Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh11Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh11Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh11Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh11Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh11Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh11Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh11Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh11Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh11Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh11Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh11Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh11Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh11Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh11Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh11Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh11Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh11Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh11Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh11Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh11Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh11Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh11Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh11Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh11Offset(self._context)


class RootSeqCxRbanaInhiresCh12Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch12.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch12.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh12(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch12'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh12Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh12Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh12Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh12Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh12Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh12Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh12Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh12Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh12Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh12Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh12Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh12Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh12Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh12Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh12Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh12Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh12Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh12Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh12Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh12Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh12Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh12Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh12Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh12Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh12Offset(self._context)


class RootSeqCxRbanaInhiresCh4Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch4.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch4.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch4'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh4Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh4Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh4Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh4Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh4Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh4Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh4Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh4Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh4Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh4Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh4Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh4Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh4Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh4Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh4Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh4Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh4Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh4Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh4Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh4Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh4Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh4Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh4Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh4Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh4Offset(self._context)


class RootSeqCxRbanaInhiresCh7Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch7.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch7.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch7'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh7Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh7Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh7Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh7Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh7Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh7Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh7Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh7Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh7Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh7Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh7Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh7Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh7Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh7Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh7Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh7Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh7Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh7Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh7Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh7Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh7Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh7Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh7Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh7Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh7Offset(self._context)


class RootSeqCxRbanaInhiresCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch2.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch2.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch2'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh2Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh2Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh2Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh2Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh2Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh2Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh2Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh2Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh2Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh2Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh2Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh2Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh2Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh2Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh2Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh2Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh2Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh2Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh2Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh2Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh2Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh2Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh2Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh2Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh2Offset(self._context)


class RootSeqCxRbanaInhiresCh9Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch9.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch9.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh9(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch9'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh9Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh9Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh9Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh9Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh9Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh9Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh9Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh9Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh9Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh9Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh9Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh9Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh9Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh9Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh9Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh9Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh9Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh9Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh9Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh9Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh9Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh9Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh9Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh9Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh9Offset(self._context)


class RootSeqCxRbanaInhiresCh6Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch6.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch6.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch6'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh6Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh6Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh6Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh6Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh6Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh6Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh6Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh6Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh6Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh6Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh6Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh6Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh6Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh6Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh6Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh6Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh6Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh6Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh6Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh6Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh6Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh6Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh6Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh6Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh6Offset(self._context)


class RootSeqCxRbanaInhiresCh5Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch5.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch5.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh5(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch5'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh5Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh5Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh5Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh5Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh5Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh5Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh5Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh5Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh5Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh5Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh5Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh5Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh5Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh5Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh5Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh5Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh5Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh5Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh5Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh5Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh5Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh5Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh5Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh5Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh5Offset(self._context)


class RootSeqCxRbanaInhiresCh8Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch8.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch8.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh8(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch8'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh8Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh8Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh8Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh8Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh8Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh8Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh8Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh8Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh8Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh8Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh8Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh8Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh8Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh8Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh8Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh8Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh8Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh8Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh8Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh8Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh8Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh8Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh8Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh8Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh8Offset(self._context)


class RootSeqCxRbanaInhiresCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.offset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.filterval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.gain.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.inputoffset.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.currentinval.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy3.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefx4.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefs2.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefy0.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.inhires.ch1.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.inhires.ch1.cccoefz1.regaddr', int(new_val))


class RootSeqCxRbanaInhiresCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires.ch1'
        self.cccoefz1 = RootSeqCxRbanaInhiresCh1Cccoefz1(self._context)
        self.cccoefy0 = RootSeqCxRbanaInhiresCh1Cccoefy0(self._context)
        self.cccoefs2 = RootSeqCxRbanaInhiresCh1Cccoefs2(self._context)
        self.cccoefx4 = RootSeqCxRbanaInhiresCh1Cccoefx4(self._context)
        self.cccoefx0 = RootSeqCxRbanaInhiresCh1Cccoefx0(self._context)
        self.cccoefy2 = RootSeqCxRbanaInhiresCh1Cccoefy2(self._context)
        self.cccoefz0 = RootSeqCxRbanaInhiresCh1Cccoefz0(self._context)
        self.cccoefy3 = RootSeqCxRbanaInhiresCh1Cccoefy3(self._context)
        self.cccoefx2 = RootSeqCxRbanaInhiresCh1Cccoefx2(self._context)
        self.cccoefx3 = RootSeqCxRbanaInhiresCh1Cccoefx3(self._context)
        self.currentinval = RootSeqCxRbanaInhiresCh1Currentinval(self._context)
        self.cccoefy4 = RootSeqCxRbanaInhiresCh1Cccoefy4(self._context)
        self.cccoefs1 = RootSeqCxRbanaInhiresCh1Cccoefs1(self._context)
        self.cccoefx1 = RootSeqCxRbanaInhiresCh1Cccoefx1(self._context)
        self.cccoefz2 = RootSeqCxRbanaInhiresCh1Cccoefz2(self._context)
        self.inputoffset = RootSeqCxRbanaInhiresCh1Inputoffset(self._context)
        self.gain = RootSeqCxRbanaInhiresCh1Gain(self._context)
        self.filterval = RootSeqCxRbanaInhiresCh1Filterval(self._context)
        self.cccoefs0 = RootSeqCxRbanaInhiresCh1Cccoefs0(self._context)
        self.cccoefs3 = RootSeqCxRbanaInhiresCh1Cccoefs3(self._context)
        self.cccoefz4 = RootSeqCxRbanaInhiresCh1Cccoefz4(self._context)
        self.cccoefz3 = RootSeqCxRbanaInhiresCh1Cccoefz3(self._context)
        self.cccoefy1 = RootSeqCxRbanaInhiresCh1Cccoefy1(self._context)
        self.cccoefs4 = RootSeqCxRbanaInhiresCh1Cccoefs4(self._context)
        self.offset = RootSeqCxRbanaInhiresCh1Offset(self._context)


class RootSeqCxRbanaInhires(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.inhires'
        self.ch1 = RootSeqCxRbanaInhiresCh1(self._context)
        self.ch8 = RootSeqCxRbanaInhiresCh8(self._context)
        self.ch5 = RootSeqCxRbanaInhiresCh5(self._context)
        self.ch6 = RootSeqCxRbanaInhiresCh6(self._context)
        self.ch9 = RootSeqCxRbanaInhiresCh9(self._context)
        self.ch2 = RootSeqCxRbanaInhiresCh2(self._context)
        self.ch7 = RootSeqCxRbanaInhiresCh7(self._context)
        self.ch4 = RootSeqCxRbanaInhiresCh4(self._context)
        self.ch12 = RootSeqCxRbanaInhiresCh12(self._context)
        self.ch11 = RootSeqCxRbanaInhiresCh11(self._context)
        self.ch10 = RootSeqCxRbanaInhiresCh10(self._context)
        self.ch3 = RootSeqCxRbanaInhiresCh3(self._context)


class RootSeqCxRbanaInfastcommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.infastcommon'


class RootSeqCxRbanaAnalyzercommonSgleControlHarmoncinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzercommon.sgle.control.harmoncinput.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzercommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzercommon.sgle.control'
        self.harmoncinput = RootSeqCxRbanaAnalyzercommonSgleControlHarmoncinput(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzercommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzercommon.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzercommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzercommon.sgle'
        self.control = RootSeqCxRbanaAnalyzercommonSgleControl(self._context)


class RootSeqCxRbanaAnalyzercommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzercommon'
        self.sgle = RootSeqCxRbanaAnalyzercommonSgle(self._context)


class RootSeqCxRbanaAnalyzerOneDeltafoffs_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.deltafoffs_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.deltafoffs_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.deltafoffs_hi.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiphase.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shift.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shift.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiphase.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.factor.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.factor.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiphase'
        self.shiftdirection = RootSeqCxRbanaAnalyzerOneKiphaseShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerOneKiphaseFactor(self._context)
        self.shift = RootSeqCxRbanaAnalyzerOneKiphaseShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiphase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCenterfreq_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.centerfreq_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.centerfreq_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.centerfreq_hi.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneAmplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.amplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.amplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.amplitude.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModeAnalyzerinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode.analyzerinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.analyzerinput.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModeOpmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode.opmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.opmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.opmode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.opmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.opmode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.opmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.opmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModeInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode.input'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.input.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.input.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.input.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.input.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.input.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.input.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModePhasedetref(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode.phasedetref'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.phasedetref.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.phasedetref.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.phasedetref.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.phasedetref.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.phasedetref.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.phasedetref.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.mode'
        self.phasedetref = RootSeqCxRbanaAnalyzerOneModePhasedetref(self._context)
        self.input = RootSeqCxRbanaAnalyzerOneModeInput(self._context)
        self.opmode = RootSeqCxRbanaAnalyzerOneModeOpmode(self._context)
        self.analyzerinput = RootSeqCxRbanaAnalyzerOneModeAnalyzerinput(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.mode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpphase.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shift.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shift.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpphase.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.factor.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.factor.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpphase'
        self.shiftdirection = RootSeqCxRbanaAnalyzerOneKpphaseShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerOneKpphaseFactor(self._context)
        self.shift = RootSeqCxRbanaAnalyzerOneKpphaseShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpphase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneFltrcoeff(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.fltrcoeff'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.fltrcoeff.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.fltrcoeff.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpampkel.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shift.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shift.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpampkel.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.factor.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.factor.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKpampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kpampkel'
        self.shiftdirection = RootSeqCxRbanaAnalyzerOneKpampkelShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerOneKpampkelFactor(self._context)
        self.shift = RootSeqCxRbanaAnalyzerOneKpampkelShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kpampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kpampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOnePhase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.phase'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.phase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.phase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOnePhaseshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.phaseshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.phaseshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.phaseshift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneLockrangeshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.lockrangeshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.lockrangeshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.lockrangeshift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetipSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip.safetip'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetip.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetip.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetipThresholdmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip.thresholdmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.thresholdmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetipSyncorsafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.syncorsafetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetipSafetipmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip.safetipmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.safetipmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.safetip'
        self.safetipmode = RootSeqCxRbanaAnalyzerOneSafetipSafetipmode(self._context)
        self.syncorsafetip = RootSeqCxRbanaAnalyzerOneSafetipSyncorsafetip(self._context)
        self.thresholdmode = RootSeqCxRbanaAnalyzerOneSafetipThresholdmode(self._context)
        self.safetip = RootSeqCxRbanaAnalyzerOneSafetipSafetip(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.safetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSetvalampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.setvalampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.setvalampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.setvalampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Distdeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.distdeltaf'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.distdeltaf.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Fltr_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.fltr_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.fltr_vld.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Clearflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.clearflag'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.clearflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.clearflag.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.clearflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.clearflag.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.clearflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.clearflag.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Outputsourceid(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.outputsourceid'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.outputsourceid.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Enabledcblock(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.enabledcblock'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.enabledcblock.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1Filtaddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1.filtaddr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.filtaddr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.filtaddr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.filtaddr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.filtaddr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.filtaddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.filtaddr.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneControl1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.control1'
        self.filtaddr = RootSeqCxRbanaAnalyzerOneControl1Filtaddr(self._context)
        self.enabledcblock = RootSeqCxRbanaAnalyzerOneControl1Enabledcblock(self._context)
        self.outputsourceid = RootSeqCxRbanaAnalyzerOneControl1Outputsourceid(self._context)
        self.clearflag = RootSeqCxRbanaAnalyzerOneControl1Clearflag(self._context)
        self.fltr_vld = RootSeqCxRbanaAnalyzerOneControl1Fltr_vld(self._context)
        self.distdeltaf = RootSeqCxRbanaAnalyzerOneControl1Distdeltaf(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.control1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.control1.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneX(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.x'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.x.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.x.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneSetptampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.setptampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.setptampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.setptampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneThreshold(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.threshold'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.threshold.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.threshold.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsAmpctrlpositiveaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsPhasectrl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phasectrl.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsAmpmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampmodulation.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsAmpctrlmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampctrlmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsPhaseclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.phaseclearaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbitsAmpclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.ampclearaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCtrlbits(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.ctrlbits'
        self.ampclearaccu = RootSeqCxRbanaAnalyzerOneCtrlbitsAmpclearaccu(self._context)
        self.phaseclearaccu = RootSeqCxRbanaAnalyzerOneCtrlbitsPhaseclearaccu(self._context)
        self.ampctrlmode = RootSeqCxRbanaAnalyzerOneCtrlbitsAmpctrlmode(self._context)
        self.ampmodulation = RootSeqCxRbanaAnalyzerOneCtrlbitsAmpmodulation(self._context)
        self.phasectrl = RootSeqCxRbanaAnalyzerOneCtrlbitsPhasectrl(self._context)
        self.ampctrlpositiveaccu = RootSeqCxRbanaAnalyzerOneCtrlbitsAmpctrlpositiveaccu(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.ctrlbits.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.ctrlbits.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneY(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.y'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.y.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.y.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneDisscp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.disscp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.disscp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.disscp.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneCenterfreq_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.centerfreq_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.centerfreq_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.centerfreq_lo.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneDelaycomp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.delaycomp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.delaycomp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.delaycomp.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneDeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.deltaf'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.deltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.deltaf.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneModampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.modampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.modampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.modampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiampkel.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shift.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shift.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiampkel.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.factor.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.factor.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneKiampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.kiampkel'
        self.shiftdirection = RootSeqCxRbanaAnalyzerOneKiampkelShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerOneKiampkelFactor(self._context)
        self.shift = RootSeqCxRbanaAnalyzerOneKiampkelShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.kiampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.kiampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneFlag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.flag'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.flag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.flag.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOneDeltafoffs_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one.deltafoffs_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.one.deltafoffs_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.one.deltafoffs_lo.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerOne(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.one'
        self.deltafoffs_lo = RootSeqCxRbanaAnalyzerOneDeltafoffs_lo(self._context)
        self.flag = RootSeqCxRbanaAnalyzerOneFlag(self._context)
        self.kiampkel = RootSeqCxRbanaAnalyzerOneKiampkel(self._context)
        self.modampkel = RootSeqCxRbanaAnalyzerOneModampkel(self._context)
        self.deltaf = RootSeqCxRbanaAnalyzerOneDeltaf(self._context)
        self.delaycomp = RootSeqCxRbanaAnalyzerOneDelaycomp(self._context)
        self.centerfreq_lo = RootSeqCxRbanaAnalyzerOneCenterfreq_lo(self._context)
        self.disscp = RootSeqCxRbanaAnalyzerOneDisscp(self._context)
        self.y = RootSeqCxRbanaAnalyzerOneY(self._context)
        self.ctrlbits = RootSeqCxRbanaAnalyzerOneCtrlbits(self._context)
        self.threshold = RootSeqCxRbanaAnalyzerOneThreshold(self._context)
        self.setptampkel = RootSeqCxRbanaAnalyzerOneSetptampkel(self._context)
        self.x = RootSeqCxRbanaAnalyzerOneX(self._context)
        self.control1 = RootSeqCxRbanaAnalyzerOneControl1(self._context)
        self.setvalampkel = RootSeqCxRbanaAnalyzerOneSetvalampkel(self._context)
        self.safetip = RootSeqCxRbanaAnalyzerOneSafetip(self._context)
        self.lockrangeshift = RootSeqCxRbanaAnalyzerOneLockrangeshift(self._context)
        self.phaseshift = RootSeqCxRbanaAnalyzerOnePhaseshift(self._context)
        self.phase = RootSeqCxRbanaAnalyzerOnePhase(self._context)
        self.kpampkel = RootSeqCxRbanaAnalyzerOneKpampkel(self._context)
        self.fltrcoeff = RootSeqCxRbanaAnalyzerOneFltrcoeff(self._context)
        self.kpphase = RootSeqCxRbanaAnalyzerOneKpphase(self._context)
        self.mode = RootSeqCxRbanaAnalyzerOneMode(self._context)
        self.amplitude = RootSeqCxRbanaAnalyzerOneAmplitude(self._context)
        self.centerfreq_hi = RootSeqCxRbanaAnalyzerOneCenterfreq_hi(self._context)
        self.kiphase = RootSeqCxRbanaAnalyzerOneKiphase(self._context)
        self.deltafoffs_hi = RootSeqCxRbanaAnalyzerOneDeltafoffs_hi(self._context)


class RootSeqCxRbanaAnalyzerTwoDeltafoffs_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.deltafoffs_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.deltafoffs_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.deltafoffs_hi.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiphase.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shift.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shift.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiphase.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.factor.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.factor.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiphase'
        self.shiftdirection = RootSeqCxRbanaAnalyzerTwoKiphaseShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerTwoKiphaseFactor(self._context)
        self.shift = RootSeqCxRbanaAnalyzerTwoKiphaseShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiphase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCenterfreq_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.centerfreq_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.centerfreq_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.centerfreq_hi.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoAmplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.amplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.amplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.amplitude.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModeAnalyzerinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode.analyzerinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.analyzerinput.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModeOpmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode.opmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.opmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.opmode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.opmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.opmode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.opmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.opmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModeInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode.input'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.input.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.input.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.input.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.input.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.input.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.input.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModePhasedetref(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode.phasedetref'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.phasedetref.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.phasedetref.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.phasedetref.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.phasedetref.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.phasedetref.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.phasedetref.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.mode'
        self.phasedetref = RootSeqCxRbanaAnalyzerTwoModePhasedetref(self._context)
        self.input = RootSeqCxRbanaAnalyzerTwoModeInput(self._context)
        self.opmode = RootSeqCxRbanaAnalyzerTwoModeOpmode(self._context)
        self.analyzerinput = RootSeqCxRbanaAnalyzerTwoModeAnalyzerinput(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.mode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpphase.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shift.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shift.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpphase.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.factor.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.factor.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpphase'
        self.shiftdirection = RootSeqCxRbanaAnalyzerTwoKpphaseShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerTwoKpphaseFactor(self._context)
        self.shift = RootSeqCxRbanaAnalyzerTwoKpphaseShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpphase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoFltrcoeff(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.fltrcoeff'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.fltrcoeff.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.fltrcoeff.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpampkel.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shift.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shift.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpampkel.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.factor.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.factor.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKpampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kpampkel'
        self.shiftdirection = RootSeqCxRbanaAnalyzerTwoKpampkelShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerTwoKpampkelFactor(self._context)
        self.shift = RootSeqCxRbanaAnalyzerTwoKpampkelShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kpampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kpampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoPhase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.phase'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.phase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.phase.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoPhaseshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.phaseshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.phaseshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.phaseshift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoLockrangeshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.lockrangeshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.lockrangeshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.lockrangeshift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetipSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip.safetip'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetip.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetip.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetipThresholdmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip.thresholdmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.thresholdmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetipSyncorsafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.syncorsafetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetipSafetipmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip.safetipmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.safetipmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.safetip'
        self.safetipmode = RootSeqCxRbanaAnalyzerTwoSafetipSafetipmode(self._context)
        self.syncorsafetip = RootSeqCxRbanaAnalyzerTwoSafetipSyncorsafetip(self._context)
        self.thresholdmode = RootSeqCxRbanaAnalyzerTwoSafetipThresholdmode(self._context)
        self.safetip = RootSeqCxRbanaAnalyzerTwoSafetipSafetip(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.safetip.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSetvalampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.setvalampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.setvalampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.setvalampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Distdeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.distdeltaf'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.distdeltaf.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Fltr_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.fltr_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.fltr_vld.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Clearflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.clearflag'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.clearflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.clearflag.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.clearflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.clearflag.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.clearflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.clearflag.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Outputsourceid(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.outputsourceid'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.outputsourceid.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Enabledcblock(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.enabledcblock'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.enabledcblock.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1Filtaddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1.filtaddr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.filtaddr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.filtaddr.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.filtaddr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.filtaddr.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.filtaddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.filtaddr.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoControl1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.control1'
        self.filtaddr = RootSeqCxRbanaAnalyzerTwoControl1Filtaddr(self._context)
        self.enabledcblock = RootSeqCxRbanaAnalyzerTwoControl1Enabledcblock(self._context)
        self.outputsourceid = RootSeqCxRbanaAnalyzerTwoControl1Outputsourceid(self._context)
        self.clearflag = RootSeqCxRbanaAnalyzerTwoControl1Clearflag(self._context)
        self.fltr_vld = RootSeqCxRbanaAnalyzerTwoControl1Fltr_vld(self._context)
        self.distdeltaf = RootSeqCxRbanaAnalyzerTwoControl1Distdeltaf(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.control1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.control1.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoX(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.x'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.x.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.x.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoSetptampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.setptampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.setptampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.setptampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoThreshold(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.threshold'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.threshold.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.threshold.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpctrlpositiveaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsPhasectrl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phasectrl.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampmodulation.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpctrlmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampctrlmode.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsPhaseclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.phaseclearaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.ampclearaccu.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCtrlbits(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.ctrlbits'
        self.ampclearaccu = RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpclearaccu(self._context)
        self.phaseclearaccu = RootSeqCxRbanaAnalyzerTwoCtrlbitsPhaseclearaccu(self._context)
        self.ampctrlmode = RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpctrlmode(self._context)
        self.ampmodulation = RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpmodulation(self._context)
        self.phasectrl = RootSeqCxRbanaAnalyzerTwoCtrlbitsPhasectrl(self._context)
        self.ampctrlpositiveaccu = RootSeqCxRbanaAnalyzerTwoCtrlbitsAmpctrlpositiveaccu(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.ctrlbits.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.ctrlbits.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoY(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.y'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.y.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.y.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoDisscp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.disscp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.disscp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.disscp.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoCenterfreq_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.centerfreq_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.centerfreq_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.centerfreq_lo.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoDelaycomp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.delaycomp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.delaycomp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.delaycomp.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoDeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.deltaf'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.deltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.deltaf.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoModampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.modampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.modampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.modampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiampkel.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shift.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shift.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shift.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiampkel.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.factor.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.factor.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.factor.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.shiftdirection.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoKiampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.kiampkel'
        self.shiftdirection = RootSeqCxRbanaAnalyzerTwoKiampkelShiftdirection(self._context)
        self.factor = RootSeqCxRbanaAnalyzerTwoKiampkelFactor(self._context)
        self.shift = RootSeqCxRbanaAnalyzerTwoKiampkelShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.kiampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.kiampkel.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoFlag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.flag'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.flag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.flag.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwoDeltafoffs_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two.deltafoffs_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.analyzer.two.deltafoffs_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.analyzer.two.deltafoffs_lo.regaddr', int(new_val))


class RootSeqCxRbanaAnalyzerTwo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer.two'
        self.deltafoffs_lo = RootSeqCxRbanaAnalyzerTwoDeltafoffs_lo(self._context)
        self.flag = RootSeqCxRbanaAnalyzerTwoFlag(self._context)
        self.kiampkel = RootSeqCxRbanaAnalyzerTwoKiampkel(self._context)
        self.modampkel = RootSeqCxRbanaAnalyzerTwoModampkel(self._context)
        self.deltaf = RootSeqCxRbanaAnalyzerTwoDeltaf(self._context)
        self.delaycomp = RootSeqCxRbanaAnalyzerTwoDelaycomp(self._context)
        self.centerfreq_lo = RootSeqCxRbanaAnalyzerTwoCenterfreq_lo(self._context)
        self.disscp = RootSeqCxRbanaAnalyzerTwoDisscp(self._context)
        self.y = RootSeqCxRbanaAnalyzerTwoY(self._context)
        self.ctrlbits = RootSeqCxRbanaAnalyzerTwoCtrlbits(self._context)
        self.threshold = RootSeqCxRbanaAnalyzerTwoThreshold(self._context)
        self.setptampkel = RootSeqCxRbanaAnalyzerTwoSetptampkel(self._context)
        self.x = RootSeqCxRbanaAnalyzerTwoX(self._context)
        self.control1 = RootSeqCxRbanaAnalyzerTwoControl1(self._context)
        self.setvalampkel = RootSeqCxRbanaAnalyzerTwoSetvalampkel(self._context)
        self.safetip = RootSeqCxRbanaAnalyzerTwoSafetip(self._context)
        self.lockrangeshift = RootSeqCxRbanaAnalyzerTwoLockrangeshift(self._context)
        self.phaseshift = RootSeqCxRbanaAnalyzerTwoPhaseshift(self._context)
        self.phase = RootSeqCxRbanaAnalyzerTwoPhase(self._context)
        self.kpampkel = RootSeqCxRbanaAnalyzerTwoKpampkel(self._context)
        self.fltrcoeff = RootSeqCxRbanaAnalyzerTwoFltrcoeff(self._context)
        self.kpphase = RootSeqCxRbanaAnalyzerTwoKpphase(self._context)
        self.mode = RootSeqCxRbanaAnalyzerTwoMode(self._context)
        self.amplitude = RootSeqCxRbanaAnalyzerTwoAmplitude(self._context)
        self.centerfreq_hi = RootSeqCxRbanaAnalyzerTwoCenterfreq_hi(self._context)
        self.kiphase = RootSeqCxRbanaAnalyzerTwoKiphase(self._context)
        self.deltafoffs_hi = RootSeqCxRbanaAnalyzerTwoDeltafoffs_hi(self._context)


class RootSeqCxRbanaAnalyzer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.analyzer'
        self.two = RootSeqCxRbanaAnalyzerTwo(self._context)
        self.one = RootSeqCxRbanaAnalyzerOne(self._context)


class RootSeqCxRbanaSeqSgleB(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.b'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.b.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.b.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.start.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControlStep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control.step'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.step.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.step.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.step.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.step.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.step.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.step.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.control'
        self.step = RootSeqCxRbanaSeqSgleControlStep(self._context)
        self.stop = RootSeqCxRbanaSeqSgleControlStop(self._context)
        self.start = RootSeqCxRbanaSeqSgleControlStart(self._context)
        self.abort = RootSeqCxRbanaSeqSgleControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleData(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.data'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.data.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.data.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleSeqreg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.seqreg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.seqreg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.seqreg.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleInstrptr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.instrptr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.instrptr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.instrptr.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleBit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.bit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.bit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.bit.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleSum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.sum'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.sum.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.sum.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleA(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.a'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.a.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.a.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleStatusRunning(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.status.running'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.running.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.running.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.running.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.running.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.running.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.running.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleStatusReaderror(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.status.readerror'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.readerror.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.readerror.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.readerror.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.readerror.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.readerror.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.readerror.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.status'
        self.readerror = RootSeqCxRbanaSeqSgleStatusReaderror(self._context)
        self.running = RootSeqCxRbanaSeqSgleStatusRunning(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleM(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.m'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.m.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.m.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgleAddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle.addr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.seq.sgle.addr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.seq.sgle.addr.regaddr', int(new_val))


class RootSeqCxRbanaSeqSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq.sgle'
        self.addr = RootSeqCxRbanaSeqSgleAddr(self._context)
        self.m = RootSeqCxRbanaSeqSgleM(self._context)
        self.status = RootSeqCxRbanaSeqSgleStatus(self._context)
        self.a = RootSeqCxRbanaSeqSgleA(self._context)
        self.sum = RootSeqCxRbanaSeqSgleSum(self._context)
        self.bit = RootSeqCxRbanaSeqSgleBit(self._context)
        self.instrptr = RootSeqCxRbanaSeqSgleInstrptr(self._context)
        self.seqreg = RootSeqCxRbanaSeqSgleSeqreg(self._context)
        self.data = RootSeqCxRbanaSeqSgleData(self._context)
        self.control = RootSeqCxRbanaSeqSgleControl(self._context)
        self.b = RootSeqCxRbanaSeqSgleB(self._context)


class RootSeqCxRbanaSeq(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.seq'
        self.sgle = RootSeqCxRbanaSeqSgle(self._context)


class RootSeqCxRbanaDpointfltrSgleChanin6Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin6.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin6.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin6.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin6.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin6.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin6.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin6.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin6'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin6Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin6.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin6.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin5Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin5.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin5.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin5.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin5.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin5.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin5.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin5.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin5(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin5'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin5Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin5.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin5.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin3Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin3.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin3.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin3.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin3.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin3.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin3.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin3.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin3'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin3Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin3.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin4Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin4.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin4.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin4.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin4.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin4.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin4.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin4.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin4'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin4Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin4.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin12Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin12.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin12.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin12.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin12.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin12.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin12.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin12.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin12(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin12'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin12Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin12.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin12.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin11Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin11.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin11.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin11.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin11.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin11.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin11.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin11.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin11(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin11'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin11Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin11.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin11.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin1Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin1.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin1.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin1.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin1.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin1.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin1.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin1.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin1'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin1Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin1.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleData(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.data'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.data.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.data.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleStatusFifoemptyflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.status.fifoemptyflag'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.fifoemptyflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.fifoemptyflag.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.fifoemptyflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.fifoemptyflag.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.fifoemptyflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.fifoemptyflag.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleStatusFifofullflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.status.fifofullflag'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.fifofullflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.fifofullflag.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.fifofullflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.fifofullflag.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.fifofullflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.fifofullflag.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleStatusAcqinprogress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.status.acqinprogress'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.acqinprogress.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.acqinprogress.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.acqinprogress.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.acqinprogress.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.acqinprogress.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.acqinprogress.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleStatusAcqdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.status.acqdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.acqdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.acqdone.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.acqdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.acqdone.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.acqdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.acqdone.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleStatusFifolevel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.status.fifolevel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.fifolevel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.fifolevel.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.fifolevel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.fifolevel.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.fifolevel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.fifolevel.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.status'
        self.fifolevel = RootSeqCxRbanaDpointfltrSgleStatusFifolevel(self._context)
        self.acqdone = RootSeqCxRbanaDpointfltrSgleStatusAcqdone(self._context)
        self.acqinprogress = RootSeqCxRbanaDpointfltrSgleStatusAcqinprogress(self._context)
        self.fifofullflag = RootSeqCxRbanaDpointfltrSgleStatusFifofullflag(self._context)
        self.fifoemptyflag = RootSeqCxRbanaDpointfltrSgleStatusFifoemptyflag(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.status.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin10Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin10.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin10.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin10.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin10.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin10.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin10.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin10.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin10(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin10'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin10Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin10.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin10.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin14Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin14.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin14.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin14.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin14.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin14.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin14.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin14.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin14(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin14'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin14Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin14.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin14.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin15Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin15.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin15.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin15.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin15.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin15.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin15.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin15.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin15(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin15'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin15Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin15.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin15.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleFircoeffs(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.fircoeffs'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.fircoeffs.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.fircoeffs.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin8Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin8.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin8.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin8.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin8.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin8.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin8.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin8.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin8(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin8'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin8Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin8.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin8.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin0Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin0.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin0.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin0.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin0.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin0.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin0.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin0.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin0'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin0Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin0.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin13Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin13.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin13.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin13.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin13.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin13.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin13.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin13.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin13(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin13'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin13Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin13.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin13.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleControlSamplemask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.control.samplemask'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.control.samplemask.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.control.samplemask.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.control.samplemask.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.control.samplemask.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.control.samplemask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.control.samplemask.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleControlFilterstage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.control.filterstage'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.control.filterstage.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.control.filterstage.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.control.filterstage.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.control.filterstage.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.control.filterstage.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.control.filterstage.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.control'
        self.filterstage = RootSeqCxRbanaDpointfltrSgleControlFilterstage(self._context)
        self.samplemask = RootSeqCxRbanaDpointfltrSgleControlSamplemask(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.control.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin9Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin9.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin9.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin9.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin9.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin9.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin9.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin9.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin9(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin9'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin9Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin9.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin9.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin7Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin7.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin7.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin7.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin7.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin7.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin7.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin7.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin7'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin7Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin7.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin7.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin2Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin2.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin2.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin2.srcchan.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin2.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin2.srcchan.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin2.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin2.srcchan.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgleChanin2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle.chanin2'
        self.srcchan = RootSeqCxRbanaDpointfltrSgleChanin2Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.dpointfltr.sgle.chanin2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.dpointfltr.sgle.chanin2.regaddr', int(new_val))


class RootSeqCxRbanaDpointfltrSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr.sgle'
        self.chanin2 = RootSeqCxRbanaDpointfltrSgleChanin2(self._context)
        self.chanin7 = RootSeqCxRbanaDpointfltrSgleChanin7(self._context)
        self.chanin9 = RootSeqCxRbanaDpointfltrSgleChanin9(self._context)
        self.control = RootSeqCxRbanaDpointfltrSgleControl(self._context)
        self.chanin13 = RootSeqCxRbanaDpointfltrSgleChanin13(self._context)
        self.chanin0 = RootSeqCxRbanaDpointfltrSgleChanin0(self._context)
        self.chanin8 = RootSeqCxRbanaDpointfltrSgleChanin8(self._context)
        self.fircoeffs = RootSeqCxRbanaDpointfltrSgleFircoeffs(self._context)
        self.chanin15 = RootSeqCxRbanaDpointfltrSgleChanin15(self._context)
        self.chanin14 = RootSeqCxRbanaDpointfltrSgleChanin14(self._context)
        self.chanin10 = RootSeqCxRbanaDpointfltrSgleChanin10(self._context)
        self.status = RootSeqCxRbanaDpointfltrSgleStatus(self._context)
        self.data = RootSeqCxRbanaDpointfltrSgleData(self._context)
        self.chanin1 = RootSeqCxRbanaDpointfltrSgleChanin1(self._context)
        self.chanin11 = RootSeqCxRbanaDpointfltrSgleChanin11(self._context)
        self.chanin12 = RootSeqCxRbanaDpointfltrSgleChanin12(self._context)
        self.chanin4 = RootSeqCxRbanaDpointfltrSgleChanin4(self._context)
        self.chanin3 = RootSeqCxRbanaDpointfltrSgleChanin3(self._context)
        self.chanin5 = RootSeqCxRbanaDpointfltrSgleChanin5(self._context)
        self.chanin6 = RootSeqCxRbanaDpointfltrSgleChanin6(self._context)


class RootSeqCxRbanaDpointfltr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.dpointfltr'
        self.sgle = RootSeqCxRbanaDpointfltrSgle(self._context)


class RootSeqCxRbanaTimerDbg1StatusEventcount(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.status.eventcount'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.status.eventcount.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.status.eventcount.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.status.eventcount.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.status.eventcount.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.status.eventcount.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.status.eventcount.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1StatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.status'
        self.busy = RootSeqCxRbanaTimerDbg1StatusBusy(self._context)
        self.eventcount = RootSeqCxRbanaTimerDbg1StatusEventcount(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.status.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1ControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1ControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.start.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1ControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.control'
        self.mode = RootSeqCxRbanaTimerDbg1ControlMode(self._context)
        self.stop = RootSeqCxRbanaTimerDbg1ControlStop(self._context)
        self.start = RootSeqCxRbanaTimerDbg1ControlStart(self._context)
        self.abort = RootSeqCxRbanaTimerDbg1ControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.control.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1Value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.value.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1Events(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1.events'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.dbg1.events.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.dbg1.events.regaddr', int(new_val))


class RootSeqCxRbanaTimerDbg1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.dbg1'
        self.events = RootSeqCxRbanaTimerDbg1Events(self._context)
        self.value = RootSeqCxRbanaTimerDbg1Value(self._context)
        self.control = RootSeqCxRbanaTimerDbg1Control(self._context)
        self.status = RootSeqCxRbanaTimerDbg1Status(self._context)


class RootSeqCxRbanaTimerProc0StatusEventcount(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.status.eventcount'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.status.eventcount.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.status.eventcount.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.status.eventcount.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.status.eventcount.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.status.eventcount.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.status.eventcount.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0StatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.status'
        self.busy = RootSeqCxRbanaTimerProc0StatusBusy(self._context)
        self.eventcount = RootSeqCxRbanaTimerProc0StatusEventcount(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.status.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0ControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0ControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.start.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0ControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.control'
        self.mode = RootSeqCxRbanaTimerProc0ControlMode(self._context)
        self.stop = RootSeqCxRbanaTimerProc0ControlStop(self._context)
        self.start = RootSeqCxRbanaTimerProc0ControlStart(self._context)
        self.abort = RootSeqCxRbanaTimerProc0ControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.control.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0Value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.value.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0Events(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0.events'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.timer.proc0.events.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.timer.proc0.events.regaddr', int(new_val))


class RootSeqCxRbanaTimerProc0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer.proc0'
        self.events = RootSeqCxRbanaTimerProc0Events(self._context)
        self.value = RootSeqCxRbanaTimerProc0Value(self._context)
        self.control = RootSeqCxRbanaTimerProc0Control(self._context)
        self.status = RootSeqCxRbanaTimerProc0Status(self._context)


class RootSeqCxRbanaTimer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.timer'
        self.proc0 = RootSeqCxRbanaTimerProc0(self._context)
        self.dbg1 = RootSeqCxRbanaTimerDbg1(self._context)


class RootSeqCxRbanaRampgenUser4StatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4StatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4StatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4StatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.countup.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.countup.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4StatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.status'
        self.busy = RootSeqCxRbanaRampgenUser4StatusBusy(self._context)
        self.countup = RootSeqCxRbanaRampgenUser4StatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenUser4StatusReachedupperlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenUser4StatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenUser4StatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Out(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Limit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Increment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.init.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.init.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4ControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.control'
        self.stop = RootSeqCxRbanaRampgenUser4ControlStop(self._context)
        self.init = RootSeqCxRbanaRampgenUser4ControlInit(self._context)
        self.mode = RootSeqCxRbanaRampgenUser4ControlMode(self._context)
        self.start = RootSeqCxRbanaRampgenUser4ControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenUser4ControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4Limit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.user4.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.user4.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.user4'
        self.limit_pos = RootSeqCxRbanaRampgenUser4Limit_pos(self._context)
        self.value = RootSeqCxRbanaRampgenUser4Value(self._context)
        self.control = RootSeqCxRbanaRampgenUser4Control(self._context)
        self.increment = RootSeqCxRbanaRampgenUser4Increment(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenUser4Limit_neg(self._context)
        self.out = RootSeqCxRbanaRampgenUser4Out(self._context)
        self.status = RootSeqCxRbanaRampgenUser4Status(self._context)


class RootSeqCxRbanaRampgenTipvoltageStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.status'
        self.busy = RootSeqCxRbanaRampgenTipvoltageStatusBusy(self._context)
        self.countup = RootSeqCxRbanaRampgenTipvoltageStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenTipvoltageStatusReachedupperlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenTipvoltageStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenTipvoltageStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.init.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.init.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.control'
        self.stop = RootSeqCxRbanaRampgenTipvoltageControlStop(self._context)
        self.init = RootSeqCxRbanaRampgenTipvoltageControlInit(self._context)
        self.mode = RootSeqCxRbanaRampgenTipvoltageControlMode(self._context)
        self.start = RootSeqCxRbanaRampgenTipvoltageControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenTipvoltageControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltageLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.tipvoltage.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.tipvoltage.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTipvoltage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.tipvoltage'
        self.limit_pos = RootSeqCxRbanaRampgenTipvoltageLimit_pos(self._context)
        self.value = RootSeqCxRbanaRampgenTipvoltageValue(self._context)
        self.control = RootSeqCxRbanaRampgenTipvoltageControl(self._context)
        self.increment = RootSeqCxRbanaRampgenTipvoltageIncrement(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenTipvoltageLimit_neg(self._context)
        self.out = RootSeqCxRbanaRampgenTipvoltageOut(self._context)
        self.status = RootSeqCxRbanaRampgenTipvoltageStatus(self._context)


class RootSeqCxRbanaRampgenAlternatezStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.countup.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.countup.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.status'
        self.busy = RootSeqCxRbanaRampgenAlternatezStatusBusy(self._context)
        self.countup = RootSeqCxRbanaRampgenAlternatezStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenAlternatezStatusReachedupperlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenAlternatezStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenAlternatezStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.init.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.init.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.control'
        self.stop = RootSeqCxRbanaRampgenAlternatezControlStop(self._context)
        self.init = RootSeqCxRbanaRampgenAlternatezControlInit(self._context)
        self.mode = RootSeqCxRbanaRampgenAlternatezControlMode(self._context)
        self.start = RootSeqCxRbanaRampgenAlternatezControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenAlternatezControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatezLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.alternatez.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.alternatez.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenAlternatez(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.alternatez'
        self.limit_pos = RootSeqCxRbanaRampgenAlternatezLimit_pos(self._context)
        self.value = RootSeqCxRbanaRampgenAlternatezValue(self._context)
        self.control = RootSeqCxRbanaRampgenAlternatezControl(self._context)
        self.increment = RootSeqCxRbanaRampgenAlternatezIncrement(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenAlternatezLimit_neg(self._context)
        self.out = RootSeqCxRbanaRampgenAlternatezOut(self._context)
        self.status = RootSeqCxRbanaRampgenAlternatezStatus(self._context)


class RootSeqCxRbanaRampgenPlanezStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.countup.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.countup.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.status'
        self.busy = RootSeqCxRbanaRampgenPlanezStatusBusy(self._context)
        self.countup = RootSeqCxRbanaRampgenPlanezStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenPlanezStatusReachedupperlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenPlanezStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenPlanezStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.init.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.init.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.control'
        self.stop = RootSeqCxRbanaRampgenPlanezControlStop(self._context)
        self.init = RootSeqCxRbanaRampgenPlanezControlInit(self._context)
        self.mode = RootSeqCxRbanaRampgenPlanezControlMode(self._context)
        self.start = RootSeqCxRbanaRampgenPlanezControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenPlanezControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanezLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.planez.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.planez.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPlanez(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.planez'
        self.limit_pos = RootSeqCxRbanaRampgenPlanezLimit_pos(self._context)
        self.value = RootSeqCxRbanaRampgenPlanezValue(self._context)
        self.control = RootSeqCxRbanaRampgenPlanezControl(self._context)
        self.increment = RootSeqCxRbanaRampgenPlanezIncrement(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenPlanezLimit_neg(self._context)
        self.out = RootSeqCxRbanaRampgenPlanezOut(self._context)
        self.status = RootSeqCxRbanaRampgenPlanezStatus(self._context)


class RootSeqCxRbanaRampgenMaxzStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.countup.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.countup.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.status'
        self.busy = RootSeqCxRbanaRampgenMaxzStatusBusy(self._context)
        self.countup = RootSeqCxRbanaRampgenMaxzStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenMaxzStatusReachedupperlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenMaxzStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenMaxzStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.init.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.init.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.control'
        self.stop = RootSeqCxRbanaRampgenMaxzControlStop(self._context)
        self.init = RootSeqCxRbanaRampgenMaxzControlInit(self._context)
        self.mode = RootSeqCxRbanaRampgenMaxzControlMode(self._context)
        self.start = RootSeqCxRbanaRampgenMaxzControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenMaxzControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxzLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.maxz.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.maxz.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenMaxz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.maxz'
        self.limit_pos = RootSeqCxRbanaRampgenMaxzLimit_pos(self._context)
        self.value = RootSeqCxRbanaRampgenMaxzValue(self._context)
        self.control = RootSeqCxRbanaRampgenMaxzControl(self._context)
        self.increment = RootSeqCxRbanaRampgenMaxzIncrement(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenMaxzLimit_neg(self._context)
        self.out = RootSeqCxRbanaRampgenMaxzOut(self._context)
        self.status = RootSeqCxRbanaRampgenMaxzStatus(self._context)


class RootSeqCxRbanaRampgenTestStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedregularend.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedregularend.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.countup.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.countup.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.status'
        self.busy = RootSeqCxRbanaRampgenTestStatusBusy(self._context)
        self.countup = RootSeqCxRbanaRampgenTestStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenTestStatusReachedupperlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenTestStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenTestStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.init.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.init.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.control'
        self.stop = RootSeqCxRbanaRampgenTestControlStop(self._context)
        self.init = RootSeqCxRbanaRampgenTestControlInit(self._context)
        self.mode = RootSeqCxRbanaRampgenTestControlMode(self._context)
        self.start = RootSeqCxRbanaRampgenTestControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenTestControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTestLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.test.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.test.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.test'
        self.limit_pos = RootSeqCxRbanaRampgenTestLimit_pos(self._context)
        self.value = RootSeqCxRbanaRampgenTestValue(self._context)
        self.control = RootSeqCxRbanaRampgenTestControl(self._context)
        self.increment = RootSeqCxRbanaRampgenTestIncrement(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenTestLimit_neg(self._context)
        self.out = RootSeqCxRbanaRampgenTestOut(self._context)
        self.status = RootSeqCxRbanaRampgenTestStatus(self._context)


class RootSeqCxRbanaRampgenApproachStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.countup.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.countup.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.status'
        self.busy = RootSeqCxRbanaRampgenApproachStatusBusy(self._context)
        self.countup = RootSeqCxRbanaRampgenApproachStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenApproachStatusReachedupperlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenApproachStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenApproachStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.init.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.init.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.control'
        self.stop = RootSeqCxRbanaRampgenApproachControlStop(self._context)
        self.init = RootSeqCxRbanaRampgenApproachControlInit(self._context)
        self.mode = RootSeqCxRbanaRampgenApproachControlMode(self._context)
        self.start = RootSeqCxRbanaRampgenApproachControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenApproachControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproachLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.approach.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.approach.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.approach'
        self.limit_pos = RootSeqCxRbanaRampgenApproachLimit_pos(self._context)
        self.value = RootSeqCxRbanaRampgenApproachValue(self._context)
        self.control = RootSeqCxRbanaRampgenApproachControl(self._context)
        self.increment = RootSeqCxRbanaRampgenApproachIncrement(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenApproachLimit_neg(self._context)
        self.out = RootSeqCxRbanaRampgenApproachOut(self._context)
        self.status = RootSeqCxRbanaRampgenApproachStatus(self._context)


class RootSeqCxRbanaRampgenPositionyStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.countup.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.countup.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.status'
        self.busy = RootSeqCxRbanaRampgenPositionyStatusBusy(self._context)
        self.countup = RootSeqCxRbanaRampgenPositionyStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenPositionyStatusReachedupperlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenPositionyStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenPositionyStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.init.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.init.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.stop.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.stop.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.stop.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.control'
        self.stop = RootSeqCxRbanaRampgenPositionyControlStop(self._context)
        self.init = RootSeqCxRbanaRampgenPositionyControlInit(self._context)
        self.mode = RootSeqCxRbanaRampgenPositionyControlMode(self._context)
        self.start = RootSeqCxRbanaRampgenPositionyControlStart(self._context)
        self.abort = RootSeqCxRbanaRampgenPositionyControlAbort(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.control.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.value.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionyLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positiony.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positiony.limit_pos.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositiony(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positiony'
        self.limit_pos = RootSeqCxRbanaRampgenPositionyLimit_pos(self._context)
        self.value = RootSeqCxRbanaRampgenPositionyValue(self._context)
        self.control = RootSeqCxRbanaRampgenPositionyControl(self._context)
        self.increment = RootSeqCxRbanaRampgenPositionyIncrement(self._context)
        self.limit_neg = RootSeqCxRbanaRampgenPositionyLimit_neg(self._context)
        self.out = RootSeqCxRbanaRampgenPositionyOut(self._context)
        self.status = RootSeqCxRbanaRampgenPositionyStatus(self._context)


class RootSeqCxRbanaRampgenPositionxStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedlowerlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedregularend.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.reachedupperlimit.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.countup.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.countup.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.countup.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.busy.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.busy.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.busy.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.status'
        self.busy = RootSeqCxRbanaRampgenPositionxStatusBusy(self._context)
        self.countup = RootSeqCxRbanaRampgenPositionxStatusCountup(self._context)
        self.reachedupperlimit = RootSeqCxRbanaRampgenPositionxStatusReachedupperlimit(self._context)
        self.reachedregularend = RootSeqCxRbanaRampgenPositionxStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqCxRbanaRampgenPositionxStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.status.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.out.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.limit_neg.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.increment.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.abort.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.abort.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.abort.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.start.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.start.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.start.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.mode.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.mode.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.mode.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.init.msb', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.init.lsb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.cx.rbana.rampgen.positionx.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.cx.rbana.rampgen.positionx.control.init.regaddr', int(new_val))


class RootSeqCxRbanaRampgenPositionxControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.cx.rbana.rampgen.positionx.control.stop'

    @property
    def msb(self) -> int:
 