import os
import sys
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

import unittest
from fairscape_models import Dataset

test_dataset = {
    "id": "ARK:APMS_embedding.MuSIC.1/5b3793b6-2bd0-4c51-9f35-c5cd7ddd366c.csv",
    "name": "AP-MS embeddings",
    "type": "schema:Dataset",
    "author": "Gygi lab (https://gygi.hms.harvard.edu/team.html)",
    "datePublished": "2021-04-23",
    "version": "1.0",
    "description": "Affinity purification mass spectrometer (APMS) embeddings for each protein in the study,  generated by node2vec predict.",
    "associatedPublication": "Qin, Y. et al. A multi-scale map of cell structure fusing protein images and interactions. Nature 600, 536–542 2021",
    "additionalDocumentation": [
        "https://idekerlab.ucsd.edu/music/"
    ],
    "format": "CSV",
    "dataSchema": 
      'APMS_ID str, "APMS_1, APMS_2, ...", protein, embedding array of float X 1024',
    "derivedFrom": ["node2vec predict"],
    "generatedBy": [],
    "usedBy": ["create labeled training & test sets  random_forest_samples.py"],
    "contentUrl": "https://github.com/idekerlab/MuSIC/blob/master/Examples/APMS_embedding.MuSIC.csv"
}

class TestDatasetModel(unittest.TestCase):
    def test_model_init(self):
        dataset_model = Dataset(**test_dataset)

    def test_optional_properties(self):
        pass
