# 🎙️ SpeechLine

<p align="center">
    <a href="https://github.com/bookbot-kids/speechline/blob/main/LICENSE.md">
        <img alt="GitHub" src="https://img.shields.io/badge/License-Apache--2.0-blue">
    </a>
    <a href="https://bookbot-kids.github.io/speechline/">
        <img alt="Documentation" src="https://img.shields.io/website?down_color=red&down_message=Offline&label=Website&up_color=green&up_message=Online&url=https%3A%2F%2Fbookbot-kids.github.io%2Fspeechline%2F">
    </a>
    <a href="https://github.com/bookbot-kids/speechline/actions/workflows/tests.yml">
        <img alt="Tests" src="https://github.com/bookbot-kids/speechline/actions/workflows/tests.yml/badge.svg">
    </a>
    <a href="https://codecov.io/gh/bookbot-kids/speechline">
        <img alt="Code Coverage" src="https://img.shields.io/codecov/c/github/bookbot-kids/speechline?label=Coverage&logo=codecov">
    </a>
    <a href="https://github.com/bookbot-kids/speechline/blob/main/CODE_OF_CONDUCT.md">
        <img alt="Contributor Covenant" src="https://img.shields.io/badge/Contributor%20Covenant-v2.0%20adopted-ff69b4.svg">
    </a>
    <a href="https://github.com/bookbot-kids/speechline/blob/main/CONTRIBUTING.md">
        <img alt="contributing guidelines" src="https://img.shields.io/badge/Contributing-Guidelines-brightgreen">
    </a>
</p>

SpeechLine is a speech labeling pipeline that handles end-to-end, offline, batch audio categorization, transcription, segmentation, and logging.

<p align="center">
    <img src="./docs/assets/logo-medium.png" alt="logo" width="300"/>
</p>

## Pipeline Overview

<p align="center">
    <img src="./docs/assets/diagram-light.svg#gh-light-mode-only"/>
    <img src="./docs/assets/diagram-dark.svg#gh-dark-mode-only"/>
</p>

## Available Modules

<p align="center">
    <img src="./docs/assets/components-light.svg#gh-light-mode-only"/>
    <img src="./docs/assets/components-dark.svg#gh-dark-mode-only"/>
</p>

<p align="center" style="font-style: italic;">
    Figure inspired by <a href="https://maartengr.github.io/BERTopic/algorithm/algorithm.html">BERTopic's Modularity Diagram</a>
</p>

## Examples

- [SpeechLine on AWS SageMaker](./docs/examples/sagemaker.md)

## Contributors

<a href="https://github.com/bookbot-kids/speechline/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=bookbot-kids/speechline" />
</a>