"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiMapping = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Create a new API mapping for API Gateway API endpoint.
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class ApiMapping extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_ApiMappingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiMapping);
            }
            throw error;
        }
        // defaultStage is present in IHttpStage.
        // However, importing "http" or "websocket" must import "common", but creating dependencies
        // the other way will cause potential cycles.
        // So casting to 'any'
        let stage = props.stage ?? props.api.defaultStage;
        if (!stage) {
            throw new Error('stage property must be specified');
        }
        if (props.apiMappingKey === '') {
            throw new Error('empty string for api mapping key not allowed');
        }
        const apiMappingProps = {
            apiId: props.api.apiId,
            domainName: props.domainName.name,
            stage: stage.stageName,
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new aws_apigatewayv2_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        // ensure the dependency on the provided stage
        this.node.addDependency(stage);
        this.apiMappingId = resource.ref;
        this.mappingKey = props.apiMappingKey;
        this.domainName = props.domainName;
    }
    /**
     * import from API ID
     */
    static fromApiMappingAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_ApiMappingAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromApiMappingAttributes);
            }
            throw error;
        }
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.ApiMapping = ApiMapping;
_a = JSII_RTTI_SYMBOL_1;
ApiMapping[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.ApiMapping", version: "2.34.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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