#!/usr/bin/python
# # -*- coding: utf-8 -*-
import datetime

from homevee.Helper import Logger
from homevee.cronjobs import FixedTimeCronjob
from homevee.utils.database import get_database_con
from homevee.utils.device_types import *


class SaveEnergyDataCronjob(FixedTimeCronjob):
    def __init__(self):
        super(FixedTimeCronjob, self).__init__(task_name="SaveEnergyDataCronjob")

    def task_to_do(self, *args):
        self.save_energy_data()

    def get_seconds_to_wait(self, execution_time=None):
        t = datetime.datetime.today()

        seconds_to_wait = (24 * 60 * 60) - (t.hour * 60 * 60) - (t.minute * 60) - t.second - 60  # um 23:59 ausführen

        return seconds_to_wait

    def save_energy_data(self):

        db = get_database_con()

        with db:
            cur = db.cursor()

            date_now = datetime.datetime.now()
            date = date_now.strftime('%Y-%m-%d %H:%M')

            total_value = 0

            room_total_value = {}

            # Z-Wave Stromzähler
            cur.execute("SELECT * FROM ZWAVE_POWER_METER")
            for item in cur.fetchall():
                room_id = item['ROOM_ID']
                value = self.save_to_db(date_now, ZWAVE_POWER_METER, room_id, item['DEVICE_ID'],
                                   item['VALUE'], db)
                total_value += value

                if room_id in room_total_value:
                    room_total_value[room_id] += value
                else:
                    room_total_value[room_id] = value

            #Gesamtwerte der Räume speichern
            for room in room_total_value:
                Logger.log("inserting in room_energy_data of room: "+str(room))
                cur.execute("INSERT INTO ROOM_ENERGY_DATA (ROOM_ID, POWER_USAGE, DATE) VALUES (:room, :usage, :date)",
                            {'room': room, 'usage': room_total_value[room_id], 'date': date})

            #Gesamtverbrauch speichern
            Logger.log("inserting in energy_data")
            cur.execute("INSERT INTO ENERGY_DATA (DATE, POWER_USAGE) VALUES (:date, :value)",
                        {'date': date, 'value': total_value})

        db.close()

    def save_to_db(self, date_now, type, room_id, id, value, db):
        if value is None or value == "N/A":
            return

        value = float(value)

        with db:
            cur = db.cursor()
            date = date_now.strftime('%Y-%m-%d %H:%M')

            if type == ZWAVE_POWER_METER:
                cur.execute("SELECT PREV_VALUE FROM ZWAVE_POWER_METER WHERE DEVICE_ID = :id", {'id': id})
                result = cur.fetchone()
                prev_value = float(result['PREV_VALUE'])

                prev_value = prev_value+value
                Logger.log("prev_value: "+str(prev_value))
                Logger.log("updating zwave_power_meter value")
                cur.execute("UPDATE ZWAVE_POWER_METER SET PREV_VALUE = :val, VALUE = 0 WHERE DEVICE_ID = :id",
                    {'val': prev_value, 'id': id})

            Logger.log("inserting in device_energy_data")
            cur.execute("INSERT INTO DEVICE_ENERGY_DATA (LOCATION, DEVICE_ID, DEVICE_TYPE, DATE, POWER_USAGE) \
                            VALUES (:location, :id, :type, :date, :value)",
                        {'location': room_id, 'id': id, 'type': type, 'date': date, 'value': value})

            return value
