# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1alpha1Error(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'assembly_error_code': 'ErrorAssemblyErrorCode',
        'gene_error_code': 'ErrorGeneErrorCode',
        'invalid_identifiers': 'list[str]',
        'message': 'str',
        'reason': 'str',
        'valid_identifiers': 'list[str]',
        'virus_error_code': 'ErrorVirusErrorCode'
    }

    attribute_map = {
        'assembly_error_code': 'assembly_error_code',
        'gene_error_code': 'gene_error_code',
        'invalid_identifiers': 'invalid_identifiers',
        'message': 'message',
        'reason': 'reason',
        'valid_identifiers': 'valid_identifiers',
        'virus_error_code': 'virus_error_code'
    }

    def __init__(self, assembly_error_code=None, gene_error_code=None, invalid_identifiers=None, message=None, reason=None, valid_identifiers=None, virus_error_code=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1Error - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._assembly_error_code = None
        self._gene_error_code = None
        self._invalid_identifiers = None
        self._message = None
        self._reason = None
        self._valid_identifiers = None
        self._virus_error_code = None
        self.discriminator = None

        if assembly_error_code is not None:
            self.assembly_error_code = assembly_error_code
        if gene_error_code is not None:
            self.gene_error_code = gene_error_code
        if invalid_identifiers is not None:
            self.invalid_identifiers = invalid_identifiers
        if message is not None:
            self.message = message
        if reason is not None:
            self.reason = reason
        if valid_identifiers is not None:
            self.valid_identifiers = valid_identifiers
        if virus_error_code is not None:
            self.virus_error_code = virus_error_code

    @property
    def assembly_error_code(self):
        """Gets the assembly_error_code of this V1alpha1Error.  # noqa: E501


        :return: The assembly_error_code of this V1alpha1Error.  # noqa: E501
        :rtype: ErrorAssemblyErrorCode
        """
        return self._assembly_error_code

    @assembly_error_code.setter
    def assembly_error_code(self, assembly_error_code):
        """Sets the assembly_error_code of this V1alpha1Error.


        :param assembly_error_code: The assembly_error_code of this V1alpha1Error.  # noqa: E501
        :type: ErrorAssemblyErrorCode
        """

        self._assembly_error_code = assembly_error_code

    @property
    def gene_error_code(self):
        """Gets the gene_error_code of this V1alpha1Error.  # noqa: E501


        :return: The gene_error_code of this V1alpha1Error.  # noqa: E501
        :rtype: ErrorGeneErrorCode
        """
        return self._gene_error_code

    @gene_error_code.setter
    def gene_error_code(self, gene_error_code):
        """Sets the gene_error_code of this V1alpha1Error.


        :param gene_error_code: The gene_error_code of this V1alpha1Error.  # noqa: E501
        :type: ErrorGeneErrorCode
        """

        self._gene_error_code = gene_error_code

    @property
    def invalid_identifiers(self):
        """Gets the invalid_identifiers of this V1alpha1Error.  # noqa: E501


        :return: The invalid_identifiers of this V1alpha1Error.  # noqa: E501
        :rtype: list[str]
        """
        return self._invalid_identifiers

    @invalid_identifiers.setter
    def invalid_identifiers(self, invalid_identifiers):
        """Sets the invalid_identifiers of this V1alpha1Error.


        :param invalid_identifiers: The invalid_identifiers of this V1alpha1Error.  # noqa: E501
        :type: list[str]
        """

        self._invalid_identifiers = invalid_identifiers

    @property
    def message(self):
        """Gets the message of this V1alpha1Error.  # noqa: E501


        :return: The message of this V1alpha1Error.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this V1alpha1Error.


        :param message: The message of this V1alpha1Error.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def reason(self):
        """Gets the reason of this V1alpha1Error.  # noqa: E501


        :return: The reason of this V1alpha1Error.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this V1alpha1Error.


        :param reason: The reason of this V1alpha1Error.  # noqa: E501
        :type: str
        """

        self._reason = reason

    @property
    def valid_identifiers(self):
        """Gets the valid_identifiers of this V1alpha1Error.  # noqa: E501


        :return: The valid_identifiers of this V1alpha1Error.  # noqa: E501
        :rtype: list[str]
        """
        return self._valid_identifiers

    @valid_identifiers.setter
    def valid_identifiers(self, valid_identifiers):
        """Sets the valid_identifiers of this V1alpha1Error.


        :param valid_identifiers: The valid_identifiers of this V1alpha1Error.  # noqa: E501
        :type: list[str]
        """

        self._valid_identifiers = valid_identifiers

    @property
    def virus_error_code(self):
        """Gets the virus_error_code of this V1alpha1Error.  # noqa: E501


        :return: The virus_error_code of this V1alpha1Error.  # noqa: E501
        :rtype: ErrorVirusErrorCode
        """
        return self._virus_error_code

    @virus_error_code.setter
    def virus_error_code(self, virus_error_code):
        """Sets the virus_error_code of this V1alpha1Error.


        :param virus_error_code: The virus_error_code of this V1alpha1Error.  # noqa: E501
        :type: ErrorVirusErrorCode
        """

        self._virus_error_code = virus_error_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1Error):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1Error):
            return True

        return self.to_dict() != other.to_dict()
