"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A subscription filter for an attribute.
 *
 * @stability stable
 */
class SubscriptionFilter {
    /**
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     * @stability stable
     */
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * Returns a subscription filter for a string attribute.
     *
     * @stability stable
     */
    static stringFilter(stringConditions) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_sns_StringConditions(stringConditions);
        const conditions = new Array();
        if (stringConditions.whitelist && stringConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        if (stringConditions.blacklist && stringConditions.denylist) {
            throw new Error('`blacklist` is deprecated; please use `denylist` instead');
        }
        const allowlist = (_b = stringConditions.allowlist) !== null && _b !== void 0 ? _b : stringConditions.whitelist;
        const denylist = (_c = stringConditions.denylist) !== null && _c !== void 0 ? _c : stringConditions.blacklist;
        if (allowlist) {
            conditions.push(...allowlist);
        }
        if (denylist) {
            conditions.push({ 'anything-but': denylist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for a numeric attribute.
     *
     * @stability stable
     */
    static numericFilter(numericConditions) {
        var _b;
        jsiiDeprecationWarnings._aws_cdk_aws_sns_NumericConditions(numericConditions);
        const conditions = new Array();
        if (numericConditions.whitelist && numericConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        const allowlist = (_b = numericConditions.allowlist) !== null && _b !== void 0 ? _b : numericConditions.whitelist;
        if (allowlist) {
            conditions.push(...allowlist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan !== undefined) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo !== undefined) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan !== undefined) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo !== undefined) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for attribute key matching.
     *
     * @stability stable
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
_a = JSII_RTTI_SYMBOL_1;
SubscriptionFilter[_a] = { fqn: "@aws-cdk/aws-sns.SubscriptionFilter", version: "1.137.0" };
//# sourceMappingURL=data:application/json;base64,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