import java.io
import java.lang
import java.net.http
import java.net.spi
import java.nio.channels
import java.nio.charset
import java.security
import java.security.cert
import java.util
import java.util.jar
import java.util.stream
import javax.net.ssl
import typing



class Authenticator:
    def __init__(self): ...
    @staticmethod
    def getDefault() -> 'Authenticator': ...
    @typing.overload
    @staticmethod
    def requestPasswordAuthentication(string: str, inetAddress: 'InetAddress', int: int, string2: str, string3: str, string4: str) -> 'PasswordAuthentication': ...
    @typing.overload
    @staticmethod
    def requestPasswordAuthentication(string: str, inetAddress: 'InetAddress', int: int, string2: str, string3: str, string4: str, uRL: 'URL', requestorType: 'Authenticator.RequestorType') -> 'PasswordAuthentication': ...
    @typing.overload
    @staticmethod
    def requestPasswordAuthentication(authenticator: 'Authenticator', string: str, inetAddress: 'InetAddress', int: int, string2: str, string3: str, string4: str, uRL: 'URL', requestorType: 'Authenticator.RequestorType') -> 'PasswordAuthentication': ...
    @typing.overload
    @staticmethod
    def requestPasswordAuthentication(inetAddress: 'InetAddress', int: int, string: str, string2: str, string3: str) -> 'PasswordAuthentication': ...
    def requestPasswordAuthenticationInstance(self, string: str, inetAddress: 'InetAddress', int: int, string2: str, string3: str, string4: str, uRL: 'URL', requestorType: 'Authenticator.RequestorType') -> 'PasswordAuthentication': ...
    @staticmethod
    def setDefault(authenticator: 'Authenticator') -> None: ...
    class RequestorType(java.lang.Enum['Authenticator.RequestorType']):
        PROXY: typing.ClassVar['Authenticator.RequestorType'] = ...
        SERVER: typing.ClassVar['Authenticator.RequestorType'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'Authenticator.RequestorType': ...
        @staticmethod
        def values() -> typing.List['Authenticator.RequestorType']: ...

class CacheRequest:
    def __init__(self): ...
    def abort(self) -> None: ...
    def getBody(self) -> java.io.OutputStream: ...

class CacheResponse:
    def __init__(self): ...
    def getBody(self) -> java.io.InputStream: ...
    def getHeaders(self) -> java.util.Map[str, java.util.List[str]]: ...

class ContentHandler:
    def __init__(self): ...
    @typing.overload
    def getContent(self, uRLConnection: 'URLConnection') -> typing.Any: ...
    @typing.overload
    def getContent(self, uRLConnection: 'URLConnection', classArray: typing.List[typing.Type]) -> typing.Any: ...

class ContentHandlerFactory:
    def createContentHandler(self, string: str) -> ContentHandler: ...

class CookieHandler:
    def __init__(self): ...
    def get(self, uRI: 'URI', map: typing.Union[java.util.Map[str, java.util.List[str]], typing.Mapping[str, java.util.List[str]]]) -> java.util.Map[str, java.util.List[str]]: ...
    @staticmethod
    def getDefault() -> 'CookieHandler': ...
    def put(self, uRI: 'URI', map: typing.Union[java.util.Map[str, java.util.List[str]], typing.Mapping[str, java.util.List[str]]]) -> None: ...
    @staticmethod
    def setDefault(cookieHandler: 'CookieHandler') -> None: ...

class CookiePolicy:
    ACCEPT_ALL: typing.ClassVar['CookiePolicy'] = ...
    ACCEPT_NONE: typing.ClassVar['CookiePolicy'] = ...
    ACCEPT_ORIGINAL_SERVER: typing.ClassVar['CookiePolicy'] = ...
    def shouldAccept(self, uRI: 'URI', httpCookie: 'HttpCookie') -> bool: ...

class CookieStore:
    def add(self, uRI: 'URI', httpCookie: 'HttpCookie') -> None: ...
    def get(self, uRI: 'URI') -> java.util.List['HttpCookie']: ...
    def getCookies(self) -> java.util.List['HttpCookie']: ...
    def getURIs(self) -> java.util.List['URI']: ...
    def remove(self, uRI: 'URI', httpCookie: 'HttpCookie') -> bool: ...
    def removeAll(self) -> bool: ...

class DatagramPacket:
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, int2: int): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, int2: int, inetAddress: 'InetAddress', int3: int): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, int2: int, socketAddress: 'SocketAddress'): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, inetAddress: 'InetAddress', int2: int): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, socketAddress: 'SocketAddress'): ...
    def getAddress(self) -> 'InetAddress': ...
    def getData(self) -> typing.List[int]: ...
    def getLength(self) -> int: ...
    def getOffset(self) -> int: ...
    def getPort(self) -> int: ...
    def getSocketAddress(self) -> 'SocketAddress': ...
    def setAddress(self, inetAddress: 'InetAddress') -> None: ...
    @typing.overload
    def setData(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def setData(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def setLength(self, int: int) -> None: ...
    def setPort(self, int: int) -> None: ...
    def setSocketAddress(self, socketAddress: 'SocketAddress') -> None: ...

class DatagramSocket(java.io.Closeable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, inetAddress: 'InetAddress'): ...
    @typing.overload
    def __init__(self, socketAddress: 'SocketAddress'): ...
    def bind(self, socketAddress: 'SocketAddress') -> None: ...
    def close(self) -> None: ...
    @typing.overload
    def connect(self, inetAddress: 'InetAddress', int: int) -> None: ...
    @typing.overload
    def connect(self, socketAddress: 'SocketAddress') -> None: ...
    def disconnect(self) -> None: ...
    def getBroadcast(self) -> bool: ...
    def getChannel(self) -> java.nio.channels.DatagramChannel: ...
    def getInetAddress(self) -> 'InetAddress': ...
    def getLocalAddress(self) -> 'InetAddress': ...
    def getLocalPort(self) -> int: ...
    def getLocalSocketAddress(self) -> 'SocketAddress': ...
    _getOption__T = typing.TypeVar('_getOption__T')  # <T>
    def getOption(self, socketOption: 'SocketOption'[_getOption__T]) -> _getOption__T: ...
    def getPort(self) -> int: ...
    def getReceiveBufferSize(self) -> int: ...
    def getRemoteSocketAddress(self) -> 'SocketAddress': ...
    def getReuseAddress(self) -> bool: ...
    def getSendBufferSize(self) -> int: ...
    def getSoTimeout(self) -> int: ...
    def getTrafficClass(self) -> int: ...
    def isBound(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isConnected(self) -> bool: ...
    def receive(self, datagramPacket: DatagramPacket) -> None: ...
    def send(self, datagramPacket: DatagramPacket) -> None: ...
    def setBroadcast(self, boolean: bool) -> None: ...
    @staticmethod
    def setDatagramSocketImplFactory(datagramSocketImplFactory: 'DatagramSocketImplFactory') -> None: ...
    _setOption__T = typing.TypeVar('_setOption__T')  # <T>
    def setOption(self, socketOption: 'SocketOption'[_setOption__T], t: _setOption__T) -> 'DatagramSocket': ...
    def setReceiveBufferSize(self, int: int) -> None: ...
    def setReuseAddress(self, boolean: bool) -> None: ...
    def setSendBufferSize(self, int: int) -> None: ...
    def setSoTimeout(self, int: int) -> None: ...
    def setTrafficClass(self, int: int) -> None: ...
    def supportedOptions(self) -> java.util.Set['SocketOption'[typing.Any]]: ...

class DatagramSocketImplFactory:
    def createDatagramSocketImpl(self) -> 'DatagramSocketImpl': ...

class FileNameMap:
    def getContentTypeFor(self, string: str) -> str: ...

class HttpCookie(java.lang.Cloneable):
    def __init__(self, string: str, string2: str): ...
    def clone(self) -> typing.Any: ...
    @staticmethod
    def domainMatches(string: str, string2: str) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getComment(self) -> str: ...
    def getCommentURL(self) -> str: ...
    def getDiscard(self) -> bool: ...
    def getDomain(self) -> str: ...
    def getMaxAge(self) -> int: ...
    def getName(self) -> str: ...
    def getPath(self) -> str: ...
    def getPortlist(self) -> str: ...
    def getSecure(self) -> bool: ...
    def getValue(self) -> str: ...
    def getVersion(self) -> int: ...
    def hasExpired(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isHttpOnly(self) -> bool: ...
    @staticmethod
    def parse(string: str) -> java.util.List['HttpCookie']: ...
    def setComment(self, string: str) -> None: ...
    def setCommentURL(self, string: str) -> None: ...
    def setDiscard(self, boolean: bool) -> None: ...
    def setDomain(self, string: str) -> None: ...
    def setHttpOnly(self, boolean: bool) -> None: ...
    def setMaxAge(self, long: int) -> None: ...
    def setPath(self, string: str) -> None: ...
    def setPortlist(self, string: str) -> None: ...
    def setSecure(self, boolean: bool) -> None: ...
    def setValue(self, string: str) -> None: ...
    def setVersion(self, int: int) -> None: ...
    def toString(self) -> str: ...

class HttpRetryException(java.io.IOException):
    @typing.overload
    def __init__(self, string: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, int: int, string2: str): ...
    def getLocation(self) -> str: ...
    def getReason(self) -> str: ...
    def responseCode(self) -> int: ...

class IDN:
    ALLOW_UNASSIGNED: typing.ClassVar[int] = ...
    USE_STD3_ASCII_RULES: typing.ClassVar[int] = ...
    @typing.overload
    @staticmethod
    def toASCII(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def toASCII(string: str, int: int) -> str: ...
    @typing.overload
    @staticmethod
    def toUnicode(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def toUnicode(string: str, int: int) -> str: ...

class InetAddress(java.io.Serializable):
    def equals(self, object: typing.Any) -> bool: ...
    def getAddress(self) -> typing.List[int]: ...
    @staticmethod
    def getAllByName(string: str) -> typing.List['InetAddress']: ...
    @typing.overload
    @staticmethod
    def getByAddress(byteArray: typing.List[int]) -> 'InetAddress': ...
    @typing.overload
    @staticmethod
    def getByAddress(string: str, byteArray: typing.List[int]) -> 'InetAddress': ...
    @staticmethod
    def getByName(string: str) -> 'InetAddress': ...
    def getCanonicalHostName(self) -> str: ...
    def getHostAddress(self) -> str: ...
    def getHostName(self) -> str: ...
    @staticmethod
    def getLocalHost() -> 'InetAddress': ...
    @staticmethod
    def getLoopbackAddress() -> 'InetAddress': ...
    def hashCode(self) -> int: ...
    def isAnyLocalAddress(self) -> bool: ...
    def isLinkLocalAddress(self) -> bool: ...
    def isLoopbackAddress(self) -> bool: ...
    def isMCGlobal(self) -> bool: ...
    def isMCLinkLocal(self) -> bool: ...
    def isMCNodeLocal(self) -> bool: ...
    def isMCOrgLocal(self) -> bool: ...
    def isMCSiteLocal(self) -> bool: ...
    def isMulticastAddress(self) -> bool: ...
    @typing.overload
    def isReachable(self, int: int) -> bool: ...
    @typing.overload
    def isReachable(self, networkInterface: 'NetworkInterface', int: int, int2: int) -> bool: ...
    def isSiteLocalAddress(self) -> bool: ...
    def toString(self) -> str: ...

class InterfaceAddress:
    def equals(self, object: typing.Any) -> bool: ...
    def getAddress(self) -> InetAddress: ...
    def getBroadcast(self) -> InetAddress: ...
    def getNetworkPrefixLength(self) -> int: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class MalformedURLException(java.io.IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class NetPermission(java.security.BasicPermission):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...

class NetworkInterface:
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def getByIndex(int: int) -> 'NetworkInterface': ...
    @staticmethod
    def getByInetAddress(inetAddress: InetAddress) -> 'NetworkInterface': ...
    @staticmethod
    def getByName(string: str) -> 'NetworkInterface': ...
    def getDisplayName(self) -> str: ...
    def getHardwareAddress(self) -> typing.List[int]: ...
    def getIndex(self) -> int: ...
    def getInetAddresses(self) -> java.util.Enumeration[InetAddress]: ...
    def getInterfaceAddresses(self) -> java.util.List[InterfaceAddress]: ...
    def getMTU(self) -> int: ...
    def getName(self) -> str: ...
    @staticmethod
    def getNetworkInterfaces() -> java.util.Enumeration['NetworkInterface']: ...
    def getParent(self) -> 'NetworkInterface': ...
    def getSubInterfaces(self) -> java.util.Enumeration['NetworkInterface']: ...
    def hashCode(self) -> int: ...
    def inetAddresses(self) -> java.util.stream.Stream[InetAddress]: ...
    def isLoopback(self) -> bool: ...
    def isPointToPoint(self) -> bool: ...
    def isUp(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    @staticmethod
    def networkInterfaces() -> java.util.stream.Stream['NetworkInterface']: ...
    def subInterfaces(self) -> java.util.stream.Stream['NetworkInterface']: ...
    def supportsMulticast(self) -> bool: ...
    def toString(self) -> str: ...

class PasswordAuthentication:
    def __init__(self, string: str, charArray: typing.List[str]): ...
    def getPassword(self) -> typing.List[str]: ...
    def getUserName(self) -> str: ...

class ProtocolException(java.io.IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ProtocolFamily:
    def name(self) -> str: ...

class Proxy:
    NO_PROXY: typing.ClassVar['Proxy'] = ...
    def __init__(self, type: 'Proxy.Type', socketAddress: 'SocketAddress'): ...
    def address(self) -> 'SocketAddress': ...
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def type(self) -> 'Proxy.Type': ...
    class Type(java.lang.Enum['Proxy.Type']):
        DIRECT: typing.ClassVar['Proxy.Type'] = ...
        HTTP: typing.ClassVar['Proxy.Type'] = ...
        SOCKS: typing.ClassVar['Proxy.Type'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'Proxy.Type': ...
        @staticmethod
        def values() -> typing.List['Proxy.Type']: ...

class ProxySelector:
    def __init__(self): ...
    def connectFailed(self, uRI: 'URI', socketAddress: 'SocketAddress', iOException: java.io.IOException) -> None: ...
    @staticmethod
    def getDefault() -> 'ProxySelector': ...
    @staticmethod
    def of(inetSocketAddress: 'InetSocketAddress') -> 'ProxySelector': ...
    def select(self, uRI: 'URI') -> java.util.List[Proxy]: ...
    @staticmethod
    def setDefault(proxySelector: 'ProxySelector') -> None: ...

class ResponseCache:
    def __init__(self): ...
    def get(self, uRI: 'URI', string: str, map: typing.Union[java.util.Map[str, java.util.List[str]], typing.Mapping[str, java.util.List[str]]]) -> CacheResponse: ...
    @staticmethod
    def getDefault() -> 'ResponseCache': ...
    def put(self, uRI: 'URI', uRLConnection: 'URLConnection') -> CacheRequest: ...
    @staticmethod
    def setDefault(responseCache: 'ResponseCache') -> None: ...

class ServerSocket(java.io.Closeable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int, inetAddress: InetAddress): ...
    def accept(self) -> 'Socket': ...
    @typing.overload
    def bind(self, socketAddress: 'SocketAddress') -> None: ...
    @typing.overload
    def bind(self, socketAddress: 'SocketAddress', int: int) -> None: ...
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.ServerSocketChannel: ...
    def getInetAddress(self) -> InetAddress: ...
    def getLocalPort(self) -> int: ...
    def getLocalSocketAddress(self) -> 'SocketAddress': ...
    _getOption__T = typing.TypeVar('_getOption__T')  # <T>
    def getOption(self, socketOption: 'SocketOption'[_getOption__T]) -> _getOption__T: ...
    def getReceiveBufferSize(self) -> int: ...
    def getReuseAddress(self) -> bool: ...
    def getSoTimeout(self) -> int: ...
    def isBound(self) -> bool: ...
    def isClosed(self) -> bool: ...
    _setOption__T = typing.TypeVar('_setOption__T')  # <T>
    def setOption(self, socketOption: 'SocketOption'[_setOption__T], t: _setOption__T) -> 'ServerSocket': ...
    def setPerformancePreferences(self, int: int, int2: int, int3: int) -> None: ...
    def setReceiveBufferSize(self, int: int) -> None: ...
    def setReuseAddress(self, boolean: bool) -> None: ...
    def setSoTimeout(self, int: int) -> None: ...
    @staticmethod
    def setSocketFactory(socketImplFactory: 'SocketImplFactory') -> None: ...
    def supportedOptions(self) -> java.util.Set['SocketOption'[typing.Any]]: ...
    def toString(self) -> str: ...

class Socket(java.io.Closeable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, int: int, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, int: int, inetAddress: InetAddress, int2: int): ...
    @typing.overload
    def __init__(self, inetAddress: InetAddress, int: int): ...
    @typing.overload
    def __init__(self, inetAddress: InetAddress, int: int, boolean: bool): ...
    @typing.overload
    def __init__(self, inetAddress: InetAddress, int: int, inetAddress2: InetAddress, int2: int): ...
    @typing.overload
    def __init__(self, proxy: Proxy): ...
    def bind(self, socketAddress: 'SocketAddress') -> None: ...
    def close(self) -> None: ...
    @typing.overload
    def connect(self, socketAddress: 'SocketAddress') -> None: ...
    @typing.overload
    def connect(self, socketAddress: 'SocketAddress', int: int) -> None: ...
    def getChannel(self) -> java.nio.channels.SocketChannel: ...
    def getInetAddress(self) -> InetAddress: ...
    def getInputStream(self) -> java.io.InputStream: ...
    def getKeepAlive(self) -> bool: ...
    def getLocalAddress(self) -> InetAddress: ...
    def getLocalPort(self) -> int: ...
    def getLocalSocketAddress(self) -> 'SocketAddress': ...
    def getOOBInline(self) -> bool: ...
    _getOption__T = typing.TypeVar('_getOption__T')  # <T>
    def getOption(self, socketOption: 'SocketOption'[_getOption__T]) -> _getOption__T: ...
    def getOutputStream(self) -> java.io.OutputStream: ...
    def getPort(self) -> int: ...
    def getReceiveBufferSize(self) -> int: ...
    def getRemoteSocketAddress(self) -> 'SocketAddress': ...
    def getReuseAddress(self) -> bool: ...
    def getSendBufferSize(self) -> int: ...
    def getSoLinger(self) -> int: ...
    def getSoTimeout(self) -> int: ...
    def getTcpNoDelay(self) -> bool: ...
    def getTrafficClass(self) -> int: ...
    def isBound(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isConnected(self) -> bool: ...
    def isInputShutdown(self) -> bool: ...
    def isOutputShutdown(self) -> bool: ...
    def sendUrgentData(self, int: int) -> None: ...
    def setKeepAlive(self, boolean: bool) -> None: ...
    def setOOBInline(self, boolean: bool) -> None: ...
    _setOption__T = typing.TypeVar('_setOption__T')  # <T>
    def setOption(self, socketOption: 'SocketOption'[_setOption__T], t: _setOption__T) -> 'Socket': ...
    def setPerformancePreferences(self, int: int, int2: int, int3: int) -> None: ...
    def setReceiveBufferSize(self, int: int) -> None: ...
    def setReuseAddress(self, boolean: bool) -> None: ...
    def setSendBufferSize(self, int: int) -> None: ...
    def setSoLinger(self, boolean: bool, int: int) -> None: ...
    def setSoTimeout(self, int: int) -> None: ...
    @staticmethod
    def setSocketImplFactory(socketImplFactory: 'SocketImplFactory') -> None: ...
    def setTcpNoDelay(self, boolean: bool) -> None: ...
    def setTrafficClass(self, int: int) -> None: ...
    def shutdownInput(self) -> None: ...
    def shutdownOutput(self) -> None: ...
    def supportedOptions(self) -> java.util.Set['SocketOption'[typing.Any]]: ...
    def toString(self) -> str: ...

class SocketAddress(java.io.Serializable):
    def __init__(self): ...

class SocketException(java.io.IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class SocketImplFactory:
    def createSocketImpl(self) -> 'SocketImpl': ...

_SocketOption__T = typing.TypeVar('_SocketOption__T')  # <T>
class SocketOption(typing.Generic[_SocketOption__T]):
    def name(self) -> str: ...
    def type(self) -> typing.Type[_SocketOption__T]: ...

class SocketOptions:
    TCP_NODELAY: typing.ClassVar[int] = ...
    SO_BINDADDR: typing.ClassVar[int] = ...
    SO_REUSEADDR: typing.ClassVar[int] = ...
    SO_REUSEPORT: typing.ClassVar[int] = ...
    SO_BROADCAST: typing.ClassVar[int] = ...
    IP_MULTICAST_IF: typing.ClassVar[int] = ...
    IP_MULTICAST_IF2: typing.ClassVar[int] = ...
    IP_MULTICAST_LOOP: typing.ClassVar[int] = ...
    IP_TOS: typing.ClassVar[int] = ...
    SO_LINGER: typing.ClassVar[int] = ...
    SO_TIMEOUT: typing.ClassVar[int] = ...
    SO_SNDBUF: typing.ClassVar[int] = ...
    SO_RCVBUF: typing.ClassVar[int] = ...
    SO_KEEPALIVE: typing.ClassVar[int] = ...
    SO_OOBINLINE: typing.ClassVar[int] = ...
    def getOption(self, int: int) -> typing.Any: ...
    def setOption(self, int: int, object: typing.Any) -> None: ...

class SocketPermission(java.security.Permission, java.io.Serializable):
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getActions(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: java.security.Permission) -> bool: ...
    def newPermissionCollection(self) -> java.security.PermissionCollection: ...

class SocketTimeoutException(java.io.InterruptedIOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class StandardSocketOptions:
    SO_BROADCAST: typing.ClassVar[SocketOption] = ...
    SO_KEEPALIVE: typing.ClassVar[SocketOption] = ...
    SO_SNDBUF: typing.ClassVar[SocketOption] = ...
    SO_RCVBUF: typing.ClassVar[SocketOption] = ...
    SO_REUSEADDR: typing.ClassVar[SocketOption] = ...
    SO_REUSEPORT: typing.ClassVar[SocketOption] = ...
    SO_LINGER: typing.ClassVar[SocketOption] = ...
    IP_TOS: typing.ClassVar[SocketOption] = ...
    IP_MULTICAST_IF: typing.ClassVar[SocketOption] = ...
    IP_MULTICAST_TTL: typing.ClassVar[SocketOption] = ...
    IP_MULTICAST_LOOP: typing.ClassVar[SocketOption] = ...
    TCP_NODELAY: typing.ClassVar[SocketOption] = ...

class URI(java.lang.Comparable['URI'], java.io.Serializable):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, int: int, string4: str, string5: str, string6: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str, string5: str): ...
    def compareTo(self, uRI: 'URI') -> int: ...
    @staticmethod
    def create(string: str) -> 'URI': ...
    def equals(self, object: typing.Any) -> bool: ...
    def getAuthority(self) -> str: ...
    def getFragment(self) -> str: ...
    def getHost(self) -> str: ...
    def getPath(self) -> str: ...
    def getPort(self) -> int: ...
    def getQuery(self) -> str: ...
    def getRawAuthority(self) -> str: ...
    def getRawFragment(self) -> str: ...
    def getRawPath(self) -> str: ...
    def getRawQuery(self) -> str: ...
    def getRawSchemeSpecificPart(self) -> str: ...
    def getRawUserInfo(self) -> str: ...
    def getScheme(self) -> str: ...
    def getSchemeSpecificPart(self) -> str: ...
    def getUserInfo(self) -> str: ...
    def hashCode(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def isOpaque(self) -> bool: ...
    def normalize(self) -> 'URI': ...
    def parseServerAuthority(self) -> 'URI': ...
    def relativize(self, uRI: 'URI') -> 'URI': ...
    @typing.overload
    def resolve(self, string: str) -> 'URI': ...
    @typing.overload
    def resolve(self, uRI: 'URI') -> 'URI': ...
    def toASCIIString(self) -> str: ...
    def toString(self) -> str: ...
    def toURL(self) -> 'URL': ...

class URISyntaxException(java.lang.Exception):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    def getIndex(self) -> int: ...
    def getInput(self) -> str: ...
    def getMessage(self) -> str: ...
    def getReason(self) -> str: ...

class URL(java.io.Serializable):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, string3: str, uRLStreamHandler: 'URLStreamHandler'): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, uRL: 'URL', string: str): ...
    @typing.overload
    def __init__(self, uRL: 'URL', string: str, uRLStreamHandler: 'URLStreamHandler'): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getAuthority(self) -> str: ...
    @typing.overload
    def getContent(self) -> typing.Any: ...
    @typing.overload
    def getContent(self, classArray: typing.List[typing.Type[typing.Any]]) -> typing.Any: ...
    def getDefaultPort(self) -> int: ...
    def getFile(self) -> str: ...
    def getHost(self) -> str: ...
    def getPath(self) -> str: ...
    def getPort(self) -> int: ...
    def getProtocol(self) -> str: ...
    def getQuery(self) -> str: ...
    def getRef(self) -> str: ...
    def getUserInfo(self) -> str: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def openConnection(self) -> 'URLConnection': ...
    @typing.overload
    def openConnection(self, proxy: Proxy) -> 'URLConnection': ...
    def openStream(self) -> java.io.InputStream: ...
    def sameFile(self, uRL: 'URL') -> bool: ...
    @staticmethod
    def setURLStreamHandlerFactory(uRLStreamHandlerFactory: 'URLStreamHandlerFactory') -> None: ...
    def toExternalForm(self) -> str: ...
    def toString(self) -> str: ...
    def toURI(self) -> URI: ...

class URLClassLoader(java.security.SecureClassLoader, java.io.Closeable):
    @typing.overload
    def __init__(self, string: str, uRLArray: typing.List[URL], classLoader: java.lang.ClassLoader): ...
    @typing.overload
    def __init__(self, string: str, uRLArray: typing.List[URL], classLoader: java.lang.ClassLoader, uRLStreamHandlerFactory: 'URLStreamHandlerFactory'): ...
    @typing.overload
    def __init__(self, uRLArray: typing.List[URL]): ...
    @typing.overload
    def __init__(self, uRLArray: typing.List[URL], classLoader: java.lang.ClassLoader): ...
    @typing.overload
    def __init__(self, uRLArray: typing.List[URL], classLoader: java.lang.ClassLoader, uRLStreamHandlerFactory: 'URLStreamHandlerFactory'): ...
    def close(self) -> None: ...
    def findResource(self, string: str) -> URL: ...
    def findResources(self, string: str) -> java.util.Enumeration[URL]: ...
    def getResourceAsStream(self, string: str) -> java.io.InputStream: ...
    def getURLs(self) -> typing.List[URL]: ...
    @typing.overload
    @staticmethod
    def newInstance(uRLArray: typing.List[URL]) -> 'URLClassLoader': ...
    @typing.overload
    @staticmethod
    def newInstance(uRLArray: typing.List[URL], classLoader: java.lang.ClassLoader) -> 'URLClassLoader': ...

class URLConnection:
    def addRequestProperty(self, string: str, string2: str) -> None: ...
    def connect(self) -> None: ...
    def getAllowUserInteraction(self) -> bool: ...
    def getConnectTimeout(self) -> int: ...
    @typing.overload
    def getContent(self) -> typing.Any: ...
    @typing.overload
    def getContent(self, classArray: typing.List[typing.Type[typing.Any]]) -> typing.Any: ...
    def getContentEncoding(self) -> str: ...
    def getContentLength(self) -> int: ...
    def getContentLengthLong(self) -> int: ...
    def getContentType(self) -> str: ...
    def getDate(self) -> int: ...
    @staticmethod
    def getDefaultAllowUserInteraction() -> bool: ...
    @staticmethod
    def getDefaultRequestProperty(string: str) -> str: ...
    @typing.overload
    def getDefaultUseCaches(self) -> bool: ...
    @typing.overload
    @staticmethod
    def getDefaultUseCaches(string: str) -> bool: ...
    def getDoInput(self) -> bool: ...
    def getDoOutput(self) -> bool: ...
    def getExpiration(self) -> int: ...
    @staticmethod
    def getFileNameMap() -> FileNameMap: ...
    @typing.overload
    def getHeaderField(self, int: int) -> str: ...
    @typing.overload
    def getHeaderField(self, string: str) -> str: ...
    def getHeaderFieldDate(self, string: str, long: int) -> int: ...
    def getHeaderFieldInt(self, string: str, int: int) -> int: ...
    def getHeaderFieldKey(self, int: int) -> str: ...
    def getHeaderFieldLong(self, string: str, long: int) -> int: ...
    def getHeaderFields(self) -> java.util.Map[str, java.util.List[str]]: ...
    def getIfModifiedSince(self) -> int: ...
    def getInputStream(self) -> java.io.InputStream: ...
    def getLastModified(self) -> int: ...
    def getOutputStream(self) -> java.io.OutputStream: ...
    def getPermission(self) -> java.security.Permission: ...
    def getReadTimeout(self) -> int: ...
    def getRequestProperties(self) -> java.util.Map[str, java.util.List[str]]: ...
    def getRequestProperty(self, string: str) -> str: ...
    def getURL(self) -> URL: ...
    def getUseCaches(self) -> bool: ...
    @staticmethod
    def guessContentTypeFromName(string: str) -> str: ...
    @staticmethod
    def guessContentTypeFromStream(inputStream: java.io.InputStream) -> str: ...
    def setAllowUserInteraction(self, boolean: bool) -> None: ...
    def setConnectTimeout(self, int: int) -> None: ...
    @staticmethod
    def setContentHandlerFactory(contentHandlerFactory: ContentHandlerFactory) -> None: ...
    @staticmethod
    def setDefaultAllowUserInteraction(boolean: bool) -> None: ...
    @staticmethod
    def setDefaultRequestProperty(string: str, string2: str) -> None: ...
    @typing.overload
    @staticmethod
    def setDefaultUseCaches(string: str, boolean: bool) -> None: ...
    @typing.overload
    def setDefaultUseCaches(self, boolean: bool) -> None: ...
    def setDoInput(self, boolean: bool) -> None: ...
    def setDoOutput(self, boolean: bool) -> None: ...
    @staticmethod
    def setFileNameMap(fileNameMap: FileNameMap) -> None: ...
    def setIfModifiedSince(self, long: int) -> None: ...
    def setReadTimeout(self, int: int) -> None: ...
    def setRequestProperty(self, string: str, string2: str) -> None: ...
    def setUseCaches(self, boolean: bool) -> None: ...
    def toString(self) -> str: ...

class URLDecoder:
    def __init__(self): ...
    @typing.overload
    @staticmethod
    def decode(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def decode(string: str, string2: str) -> str: ...
    @typing.overload
    @staticmethod
    def decode(string: str, charset: java.nio.charset.Charset) -> str: ...

class URLEncoder:
    @typing.overload
    @staticmethod
    def encode(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def encode(string: str, string2: str) -> str: ...
    @typing.overload
    @staticmethod
    def encode(string: str, charset: java.nio.charset.Charset) -> str: ...

class URLPermission(java.security.Permission):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getActions(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: java.security.Permission) -> bool: ...

class URLStreamHandler:
    def __init__(self): ...

class URLStreamHandlerFactory:
    def createURLStreamHandler(self, string: str) -> URLStreamHandler: ...

class UnknownHostException(java.io.IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class UnknownServiceException(java.io.IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class BindException(SocketException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ConnectException(SocketException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class CookieManager(CookieHandler):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, cookieStore: CookieStore, cookiePolicy: CookiePolicy): ...
    def get(self, uRI: URI, map: typing.Union[java.util.Map[str, java.util.List[str]], typing.Mapping[str, java.util.List[str]]]) -> java.util.Map[str, java.util.List[str]]: ...
    def getCookieStore(self) -> CookieStore: ...
    def put(self, uRI: URI, map: typing.Union[java.util.Map[str, java.util.List[str]], typing.Mapping[str, java.util.List[str]]]) -> None: ...
    def setCookiePolicy(self, cookiePolicy: CookiePolicy) -> None: ...

class DatagramSocketImpl(SocketOptions):
    def __init__(self): ...

class HttpURLConnection(URLConnection):
    HTTP_OK: typing.ClassVar[int] = ...
    HTTP_CREATED: typing.ClassVar[int] = ...
    HTTP_ACCEPTED: typing.ClassVar[int] = ...
    HTTP_NOT_AUTHORITATIVE: typing.ClassVar[int] = ...
    HTTP_NO_CONTENT: typing.ClassVar[int] = ...
    HTTP_RESET: typing.ClassVar[int] = ...
    HTTP_PARTIAL: typing.ClassVar[int] = ...
    HTTP_MULT_CHOICE: typing.ClassVar[int] = ...
    HTTP_MOVED_PERM: typing.ClassVar[int] = ...
    HTTP_MOVED_TEMP: typing.ClassVar[int] = ...
    HTTP_SEE_OTHER: typing.ClassVar[int] = ...
    HTTP_NOT_MODIFIED: typing.ClassVar[int] = ...
    HTTP_USE_PROXY: typing.ClassVar[int] = ...
    HTTP_BAD_REQUEST: typing.ClassVar[int] = ...
    HTTP_UNAUTHORIZED: typing.ClassVar[int] = ...
    HTTP_PAYMENT_REQUIRED: typing.ClassVar[int] = ...
    HTTP_FORBIDDEN: typing.ClassVar[int] = ...
    HTTP_NOT_FOUND: typing.ClassVar[int] = ...
    HTTP_BAD_METHOD: typing.ClassVar[int] = ...
    HTTP_NOT_ACCEPTABLE: typing.ClassVar[int] = ...
    HTTP_PROXY_AUTH: typing.ClassVar[int] = ...
    HTTP_CLIENT_TIMEOUT: typing.ClassVar[int] = ...
    HTTP_CONFLICT: typing.ClassVar[int] = ...
    HTTP_GONE: typing.ClassVar[int] = ...
    HTTP_LENGTH_REQUIRED: typing.ClassVar[int] = ...
    HTTP_PRECON_FAILED: typing.ClassVar[int] = ...
    HTTP_ENTITY_TOO_LARGE: typing.ClassVar[int] = ...
    HTTP_REQ_TOO_LONG: typing.ClassVar[int] = ...
    HTTP_UNSUPPORTED_TYPE: typing.ClassVar[int] = ...
    HTTP_SERVER_ERROR: typing.ClassVar[int] = ...
    HTTP_INTERNAL_ERROR: typing.ClassVar[int] = ...
    HTTP_NOT_IMPLEMENTED: typing.ClassVar[int] = ...
    HTTP_BAD_GATEWAY: typing.ClassVar[int] = ...
    HTTP_UNAVAILABLE: typing.ClassVar[int] = ...
    HTTP_GATEWAY_TIMEOUT: typing.ClassVar[int] = ...
    HTTP_VERSION: typing.ClassVar[int] = ...
    def disconnect(self) -> None: ...
    def getErrorStream(self) -> java.io.InputStream: ...
    @staticmethod
    def getFollowRedirects() -> bool: ...
    @typing.overload
    def getHeaderField(self, int: int) -> str: ...
    @typing.overload
    def getHeaderField(self, string: str) -> str: ...
    def getHeaderFieldDate(self, string: str, long: int) -> int: ...
    def getHeaderFieldKey(self, int: int) -> str: ...
    def getInstanceFollowRedirects(self) -> bool: ...
    def getPermission(self) -> java.security.Permission: ...
    def getRequestMethod(self) -> str: ...
    def getResponseCode(self) -> int: ...
    def getResponseMessage(self) -> str: ...
    def setAuthenticator(self, authenticator: Authenticator) -> None: ...
    def setChunkedStreamingMode(self, int: int) -> None: ...
    @typing.overload
    def setFixedLengthStreamingMode(self, int: int) -> None: ...
    @typing.overload
    def setFixedLengthStreamingMode(self, long: int) -> None: ...
    @staticmethod
    def setFollowRedirects(boolean: bool) -> None: ...
    def setInstanceFollowRedirects(self, boolean: bool) -> None: ...
    def setRequestMethod(self, string: str) -> None: ...
    def usingProxy(self) -> bool: ...

class Inet4Address(InetAddress):
    def equals(self, object: typing.Any) -> bool: ...
    def getAddress(self) -> typing.List[int]: ...
    def getHostAddress(self) -> str: ...
    def hashCode(self) -> int: ...
    def isAnyLocalAddress(self) -> bool: ...
    def isLinkLocalAddress(self) -> bool: ...
    def isLoopbackAddress(self) -> bool: ...
    def isMCGlobal(self) -> bool: ...
    def isMCLinkLocal(self) -> bool: ...
    def isMCNodeLocal(self) -> bool: ...
    def isMCOrgLocal(self) -> bool: ...
    def isMCSiteLocal(self) -> bool: ...
    def isMulticastAddress(self) -> bool: ...
    def isSiteLocalAddress(self) -> bool: ...

class Inet6Address(InetAddress):
    def equals(self, object: typing.Any) -> bool: ...
    def getAddress(self) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def getByAddress(string: str, byteArray: typing.List[int], int: int) -> 'Inet6Address': ...
    @typing.overload
    @staticmethod
    def getByAddress(string: str, byteArray: typing.List[int], networkInterface: NetworkInterface) -> 'Inet6Address': ...
    @typing.overload
    @staticmethod
    def getByAddress(byteArray: typing.List[int]) -> InetAddress: ...
    @typing.overload
    @staticmethod
    def getByAddress(string: str, byteArray: typing.List[int]) -> InetAddress: ...
    def getHostAddress(self) -> str: ...
    def getScopeId(self) -> int: ...
    def getScopedInterface(self) -> NetworkInterface: ...
    def hashCode(self) -> int: ...
    def isAnyLocalAddress(self) -> bool: ...
    def isIPv4CompatibleAddress(self) -> bool: ...
    def isLinkLocalAddress(self) -> bool: ...
    def isLoopbackAddress(self) -> bool: ...
    def isMCGlobal(self) -> bool: ...
    def isMCLinkLocal(self) -> bool: ...
    def isMCNodeLocal(self) -> bool: ...
    def isMCOrgLocal(self) -> bool: ...
    def isMCSiteLocal(self) -> bool: ...
    def isMulticastAddress(self) -> bool: ...
    def isSiteLocalAddress(self) -> bool: ...

class InetSocketAddress(SocketAddress):
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, string: str, int: int): ...
    @typing.overload
    def __init__(self, inetAddress: InetAddress, int: int): ...
    @staticmethod
    def createUnresolved(string: str, int: int) -> 'InetSocketAddress': ...
    def equals(self, object: typing.Any) -> bool: ...
    def getAddress(self) -> InetAddress: ...
    def getHostName(self) -> str: ...
    def getHostString(self) -> str: ...
    def getPort(self) -> int: ...
    def hashCode(self) -> int: ...
    def isUnresolved(self) -> bool: ...
    def toString(self) -> str: ...

class JarURLConnection(URLConnection):
    def getAttributes(self) -> java.util.jar.Attributes: ...
    def getCertificates(self) -> typing.List[java.security.cert.Certificate]: ...
    def getEntryName(self) -> str: ...
    def getJarEntry(self) -> java.util.jar.JarEntry: ...
    def getJarFile(self) -> java.util.jar.JarFile: ...
    def getJarFileURL(self) -> URL: ...
    def getMainAttributes(self) -> java.util.jar.Attributes: ...
    def getManifest(self) -> java.util.jar.Manifest: ...

class MulticastSocket(DatagramSocket):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, socketAddress: SocketAddress): ...
    def getInterface(self) -> InetAddress: ...
    def getLoopbackMode(self) -> bool: ...
    def getNetworkInterface(self) -> NetworkInterface: ...
    def getTTL(self) -> int: ...
    def getTimeToLive(self) -> int: ...
    @typing.overload
    def joinGroup(self, inetAddress: InetAddress) -> None: ...
    @typing.overload
    def joinGroup(self, socketAddress: SocketAddress, networkInterface: NetworkInterface) -> None: ...
    @typing.overload
    def leaveGroup(self, inetAddress: InetAddress) -> None: ...
    @typing.overload
    def leaveGroup(self, socketAddress: SocketAddress, networkInterface: NetworkInterface) -> None: ...
    @typing.overload
    def send(self, datagramPacket: DatagramPacket) -> None: ...
    @typing.overload
    def send(self, datagramPacket: DatagramPacket, byte: int) -> None: ...
    def setInterface(self, inetAddress: InetAddress) -> None: ...
    def setLoopbackMode(self, boolean: bool) -> None: ...
    def setNetworkInterface(self, networkInterface: NetworkInterface) -> None: ...
    def setTTL(self, byte: int) -> None: ...
    def setTimeToLive(self, int: int) -> None: ...
    def supportedOptions(self) -> java.util.Set[SocketOption[typing.Any]]: ...

class NoRouteToHostException(SocketException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class PortUnreachableException(SocketException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class SecureCacheResponse(CacheResponse):
    def __init__(self): ...
    def getCipherSuite(self) -> str: ...
    def getLocalCertificateChain(self) -> java.util.List[java.security.cert.Certificate]: ...
    def getLocalPrincipal(self) -> java.security.Principal: ...
    def getPeerPrincipal(self) -> java.security.Principal: ...
    def getSSLSession(self) -> java.util.Optional[javax.net.ssl.SSLSession]: ...
    def getServerCertificateChain(self) -> java.util.List[java.security.cert.Certificate]: ...

class SocketImpl(SocketOptions):
    def __init__(self): ...
    def toString(self) -> str: ...

class StandardProtocolFamily(java.lang.Enum['StandardProtocolFamily'], ProtocolFamily):
    INET: typing.ClassVar['StandardProtocolFamily'] = ...
    INET6: typing.ClassVar['StandardProtocolFamily'] = ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'StandardProtocolFamily': ...
    @staticmethod
    def values() -> typing.List['StandardProtocolFamily']: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.net")``.

    Authenticator: typing.Type[Authenticator]
    BindException: typing.Type[BindException]
    CacheRequest: typing.Type[CacheRequest]
    CacheResponse: typing.Type[CacheResponse]
    ConnectException: typing.Type[ConnectException]
    ContentHandler: typing.Type[ContentHandler]
    ContentHandlerFactory: typing.Type[ContentHandlerFactory]
    CookieHandler: typing.Type[CookieHandler]
    CookieManager: typing.Type[CookieManager]
    CookiePolicy: typing.Type[CookiePolicy]
    CookieStore: typing.Type[CookieStore]
    DatagramPacket: typing.Type[DatagramPacket]
    DatagramSocket: typing.Type[DatagramSocket]
    DatagramSocketImpl: typing.Type[DatagramSocketImpl]
    DatagramSocketImplFactory: typing.Type[DatagramSocketImplFactory]
    FileNameMap: typing.Type[FileNameMap]
    HttpCookie: typing.Type[HttpCookie]
    HttpRetryException: typing.Type[HttpRetryException]
    HttpURLConnection: typing.Type[HttpURLConnection]
    IDN: typing.Type[IDN]
    Inet4Address: typing.Type[Inet4Address]
    Inet6Address: typing.Type[Inet6Address]
    InetAddress: typing.Type[InetAddress]
    InetSocketAddress: typing.Type[InetSocketAddress]
    InterfaceAddress: typing.Type[InterfaceAddress]
    JarURLConnection: typing.Type[JarURLConnection]
    MalformedURLException: typing.Type[MalformedURLException]
    MulticastSocket: typing.Type[MulticastSocket]
    NetPermission: typing.Type[NetPermission]
    NetworkInterface: typing.Type[NetworkInterface]
    NoRouteToHostException: typing.Type[NoRouteToHostException]
    PasswordAuthentication: typing.Type[PasswordAuthentication]
    PortUnreachableException: typing.Type[PortUnreachableException]
    ProtocolException: typing.Type[ProtocolException]
    ProtocolFamily: typing.Type[ProtocolFamily]
    Proxy: typing.Type[Proxy]
    ProxySelector: typing.Type[ProxySelector]
    ResponseCache: typing.Type[ResponseCache]
    SecureCacheResponse: typing.Type[SecureCacheResponse]
    ServerSocket: typing.Type[ServerSocket]
    Socket: typing.Type[Socket]
    SocketAddress: typing.Type[SocketAddress]
    SocketException: typing.Type[SocketException]
    SocketImpl: typing.Type[SocketImpl]
    SocketImplFactory: typing.Type[SocketImplFactory]
    SocketOption: typing.Type[SocketOption]
    SocketOptions: typing.Type[SocketOptions]
    SocketPermission: typing.Type[SocketPermission]
    SocketTimeoutException: typing.Type[SocketTimeoutException]
    StandardProtocolFamily: typing.Type[StandardProtocolFamily]
    StandardSocketOptions: typing.Type[StandardSocketOptions]
    URI: typing.Type[URI]
    URISyntaxException: typing.Type[URISyntaxException]
    URL: typing.Type[URL]
    URLClassLoader: typing.Type[URLClassLoader]
    URLConnection: typing.Type[URLConnection]
    URLDecoder: typing.Type[URLDecoder]
    URLEncoder: typing.Type[URLEncoder]
    URLPermission: typing.Type[URLPermission]
    URLStreamHandler: typing.Type[URLStreamHandler]
    URLStreamHandlerFactory: typing.Type[URLStreamHandlerFactory]
    UnknownHostException: typing.Type[UnknownHostException]
    UnknownServiceException: typing.Type[UnknownServiceException]
    http: java.net.http.__module_protocol__
    spi: java.net.spi.__module_protocol__
