import VASSAL
import VASSAL.tools.image.svg
import VASSAL.tools.image.tilecache
import VASSAL.tools.io
import VASSAL.tools.lang
import java.awt
import java.awt.image
import java.io
import java.lang
import java.util
import jpype.protocol
import typing



class ImageIOException(java.io.IOException):
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: str): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    def getFile(self) -> java.io.File: ...

class ImageLoader:
    def load(self, string: str, inputStream: java.io.InputStream, int: int, int2: int, boolean: bool) -> java.awt.image.BufferedImage: ...
    def size(self, string: str, inputStream: java.io.InputStream) -> java.awt.Dimension: ...

class ImageTileSource:
    def getTile(self, string: str, int: int, int2: int, double: float) -> java.awt.image.BufferedImage: ...
    def getTileSize(self, string: str, int: int, int2: int, double: float) -> java.awt.Dimension: ...
    def tileExists(self, string: str, int: int, int2: int, double: float) -> bool: ...

class ImageTypeConverter:
    def convert(self, reference: VASSAL.tools.lang.Reference[java.awt.image.BufferedImage], int: int) -> java.awt.image.BufferedImage: ...

class ImageUtils:
    NULL_IMAGE: typing.ClassVar[java.awt.image.BufferedImage] = ...
    GIF_SUFFIX: typing.ClassVar[str] = ...
    PNG_SUFFIX: typing.ClassVar[str] = ...
    SVG_SUFFIX: typing.ClassVar[str] = ...
    JPG_SUFFIX: typing.ClassVar[str] = ...
    JPEG_SUFFIX: typing.ClassVar[str] = ...
    IMAGE_SUFFIXES: typing.ClassVar[typing.List[str]] = ...
    @staticmethod
    def coerceToIntType(bufferedImage: java.awt.image.BufferedImage) -> java.awt.image.BufferedImage: ...
    @typing.overload
    @staticmethod
    def createCompatibleImage(int: int, int2: int) -> java.awt.image.BufferedImage: ...
    @typing.overload
    @staticmethod
    def createCompatibleImage(int: int, int2: int, boolean: bool) -> java.awt.image.BufferedImage: ...
    @staticmethod
    def createCompatibleTranslucentImage(int: int, int2: int) -> java.awt.image.BufferedImage: ...
    @staticmethod
    def forceLoad(image: java.awt.Image) -> java.awt.Image: ...
    @typing.overload
    @staticmethod
    def getBounds(dimension: java.awt.Dimension) -> java.awt.Rectangle: ...
    @typing.overload
    @staticmethod
    def getBounds(bufferedImage: java.awt.image.BufferedImage) -> java.awt.Rectangle: ...
    @typing.overload
    @staticmethod
    def getCompatibleImageType() -> int: ...
    @typing.overload
    @staticmethod
    def getCompatibleImageType(boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def getCompatibleImageType(bufferedImage: java.awt.image.BufferedImage) -> int: ...
    @staticmethod
    def getCompatibleTranslucentImageType() -> int: ...
    @staticmethod
    def getDefaultHints() -> java.awt.RenderingHints: ...
    @staticmethod
    def getImage(string: str, inputStream: java.io.InputStream) -> java.awt.image.BufferedImage: ...
    @staticmethod
    def getImageResource(string: str) -> java.awt.image.BufferedImage: ...
    @staticmethod
    def getImageSize(string: str, inputStream: java.io.InputStream) -> java.awt.Dimension: ...
    @staticmethod
    def hasImageSuffix(string: str) -> bool: ...
    @staticmethod
    def isCompatibleImage(bufferedImage: java.awt.image.BufferedImage) -> bool: ...
    @typing.overload
    @staticmethod
    def isTransparent(image: java.awt.Image) -> bool: ...
    @typing.overload
    @staticmethod
    def isTransparent(bufferedImage: java.awt.image.BufferedImage) -> bool: ...
    @staticmethod
    def stripImageSuffix(string: str) -> str: ...
    @staticmethod
    def toBufferedImage(image: java.awt.Image) -> java.awt.image.BufferedImage: ...
    @staticmethod
    def toCompatibleImage(bufferedImage: java.awt.image.BufferedImage) -> java.awt.image.BufferedImage: ...
    @staticmethod
    def toType(bufferedImage: java.awt.image.BufferedImage, int: int) -> java.awt.image.BufferedImage: ...
    @typing.overload
    @staticmethod
    def transform(rectangle: java.awt.Rectangle, double: float, double2: float) -> java.awt.Rectangle: ...
    @typing.overload
    @staticmethod
    def transform(bufferedImage: java.awt.image.BufferedImage, double: float, double2: float) -> java.awt.image.BufferedImage: ...
    @typing.overload
    @staticmethod
    def transform(bufferedImage: java.awt.image.BufferedImage, double: float, double2: float, renderingHints: java.awt.RenderingHints) -> java.awt.image.BufferedImage: ...

class LabelUtils:
    CENTER: typing.ClassVar[int] = ...
    RIGHT: typing.ClassVar[int] = ...
    LEFT: typing.ClassVar[int] = ...
    TOP: typing.ClassVar[int] = ...
    BOTTOM: typing.ClassVar[int] = ...
    @staticmethod
    def drawHTMLLabel(graphics: java.awt.Graphics, string: str, int: int, int2: int, font: java.awt.Font, int3: int, int4: int, color: java.awt.Color, color2: java.awt.Color, color3: java.awt.Color, component: java.awt.Component, int5: int, int6: int, int7: int, int8: int) -> None: ...
    @typing.overload
    @staticmethod
    def drawLabel(graphics: java.awt.Graphics, string: str, int: int, int2: int, int3: int, int4: int, color: java.awt.Color, color2: java.awt.Color) -> None: ...
    @typing.overload
    @staticmethod
    def drawLabel(graphics: java.awt.Graphics, string: str, int: int, int2: int, font: java.awt.Font, int3: int, int4: int, color: java.awt.Color, color2: java.awt.Color, color3: java.awt.Color) -> None: ...
    @typing.overload
    @staticmethod
    def drawLabel(graphics: java.awt.Graphics, string: str, int: int, int2: int, font: java.awt.Font, int3: int, int4: int, color: java.awt.Color, color2: java.awt.Color, color3: java.awt.Color, int5: int, int6: int, int7: int, int8: int) -> None: ...
    @staticmethod
    def drawLabelBox(graphics2D: java.awt.Graphics2D, font: java.awt.Font, string: str, int: int, int2: int, int3: int) -> None: ...
    @staticmethod
    def labelBoxImage(font: java.awt.Font, string: str, int: int, int2: int) -> java.awt.image.BufferedImage: ...
    @staticmethod
    def labelWidth(font: java.awt.Font, string: str) -> int: ...
    @typing.overload
    @staticmethod
    def noImageBoxImage() -> java.awt.image.BufferedImage: ...
    @typing.overload
    @staticmethod
    def noImageBoxImage(int: int, int2: int, double: float) -> java.awt.image.BufferedImage: ...

class MultiResolutionRenderedImage(java.awt.image.AbstractMultiResolutionImage):
    def __init__(self, int: int, int2: int, renderer: typing.Union['MultiResolutionRenderedImage.Renderer', typing.Callable]): ...
    def getResolutionVariant(self, double: float, double2: float) -> java.awt.Image: ...
    def getResolutionVariants(self) -> java.util.List[java.awt.Image]: ...
    class Renderer:
        def render(self, int: int, int2: int, double: float) -> java.awt.image.BufferedImage: ...

class BrokenImageException(ImageIOException):
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: str): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...

class FallbackImageTypeConverter(ImageTypeConverter):
    def __init__(self, temporaryFileFactory: typing.Union[VASSAL.tools.io.TemporaryFileFactory, typing.Callable]): ...
    def convert(self, reference: VASSAL.tools.lang.Reference[java.awt.image.BufferedImage], int: int) -> java.awt.image.BufferedImage: ...

class FileImageTypeConverter(ImageTypeConverter):
    def __init__(self, temporaryFileFactory: typing.Union[VASSAL.tools.io.TemporaryFileFactory, typing.Callable]): ...
    def convert(self, reference: VASSAL.tools.lang.Reference[java.awt.image.BufferedImage], int: int) -> java.awt.image.BufferedImage: ...

class ImageIOImageLoader(ImageLoader):
    def __init__(self, imageTypeConverter: typing.Union[ImageTypeConverter, typing.Callable]): ...
    def load(self, string: str, inputStream: java.io.InputStream, int: int, int2: int, boolean: bool) -> java.awt.image.BufferedImage: ...
    def size(self, string: str, inputStream: java.io.InputStream) -> java.awt.Dimension: ...

class ImageNotFoundException(ImageIOException):
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...

class MemoryImageTypeConverter(ImageTypeConverter):
    def __init__(self): ...
    def convert(self, reference: VASSAL.tools.lang.Reference[java.awt.image.BufferedImage], int: int) -> java.awt.image.BufferedImage: ...

class UnrecognizedImageTypeException(ImageIOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...

class GeneralFilter:
    OPAQUE: typing.ClassVar[int] = ...
    TRANS_PREMULT: typing.ClassVar[int] = ...
    TRANS_UNPREMULT: typing.ClassVar[int] = ...
    @staticmethod
    def resample(intArray: typing.List[int], boolean: bool, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, int9: int, int10: int, intArray2: typing.List[int], int12: int, int13: int, int14: int, int15: int, int16: int, int17: int, int18: int, int19: int, float: float, float2: float, filter: 'GeneralFilter.Filter') -> None: ...
    @typing.overload
    @staticmethod
    def zoom(rectangle: java.awt.Rectangle, bufferedImage: java.awt.image.BufferedImage, filter: 'GeneralFilter.Filter') -> java.awt.image.BufferedImage: ...
    @typing.overload
    @staticmethod
    def zoom(writableRaster: java.awt.image.WritableRaster, rectangle: java.awt.Rectangle, bufferedImage: java.awt.image.BufferedImage, filter: 'GeneralFilter.Filter') -> None: ...
    class BSplineFilter(VASSAL.tools.image.GeneralFilter.Filter):
        def __init__(self): ...
        def apply(self, float: float) -> float: ...
        def getSamplingRadius(self) -> float: ...
    class BellFilter(VASSAL.tools.image.GeneralFilter.Filter):
        def __init__(self): ...
        def apply(self, float: float) -> float: ...
        def getSamplingRadius(self) -> float: ...
    class BoxFilter(VASSAL.tools.image.GeneralFilter.Filter):
        def __init__(self): ...
        def apply(self, float: float) -> float: ...
        def getSamplingRadius(self) -> float: ...
    class Filter:
        def __init__(self): ...
        def apply(self, float: float) -> float: ...
        def getSamplingRadius(self) -> float: ...
    class HermiteFilter(VASSAL.tools.image.GeneralFilter.Filter):
        def __init__(self): ...
        def apply(self, float: float) -> float: ...
        def getSamplingRadius(self) -> float: ...
    class Lanczos3Filter(VASSAL.tools.image.GeneralFilter.Filter):
        def __init__(self): ...
        def apply(self, float: float) -> float: ...
        def getSamplingRadius(self) -> float: ...
    class MitchellFilter(VASSAL.tools.image.GeneralFilter.Filter):
        def __init__(self): ...
        def apply(self, float: float) -> float: ...
        def getSamplingRadius(self) -> float: ...
    class TriangleFilter:
        def __init__(self): ...
        def apply(self, float: float) -> float: ...
        def getSamplingRadius(self) -> float: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.tools.image")``.

    BrokenImageException: typing.Type[BrokenImageException]
    FallbackImageTypeConverter: typing.Type[FallbackImageTypeConverter]
    FileImageTypeConverter: typing.Type[FileImageTypeConverter]
    GeneralFilter: typing.Type[GeneralFilter]
    ImageIOException: typing.Type[ImageIOException]
    ImageIOImageLoader: typing.Type[ImageIOImageLoader]
    ImageLoader: typing.Type[ImageLoader]
    ImageNotFoundException: typing.Type[ImageNotFoundException]
    ImageTileSource: typing.Type[ImageTileSource]
    ImageTypeConverter: typing.Type[ImageTypeConverter]
    ImageUtils: typing.Type[ImageUtils]
    LabelUtils: typing.Type[LabelUtils]
    MemoryImageTypeConverter: typing.Type[MemoryImageTypeConverter]
    MultiResolutionRenderedImage: typing.Type[MultiResolutionRenderedImage]
    UnrecognizedImageTypeException: typing.Type[UnrecognizedImageTypeException]
    svg: VASSAL.tools.image.svg.__module_protocol__
    tilecache: VASSAL.tools.image.tilecache.__module_protocol__
