import VASSAL.build.module.properties
import VASSAL.configure
import VASSAL.counters
import VASSAL.tools
import java.awt
import java.lang
import java.util
import javax.swing
import typing



class AuditTrail:
    @typing.overload
    def __init__(self, auditTrail: 'AuditTrail'): ...
    @typing.overload
    def __init__(self, auditable: 'Auditable', string: str): ...
    @typing.overload
    def __init__(self, auditable: 'Auditable', string: str, string2: str): ...
    def addMessage(self, string: str) -> None: ...
    @typing.overload
    @staticmethod
    def create(auditable: 'Auditable') -> 'AuditTrail': ...
    @typing.overload
    @staticmethod
    def create(auditable: 'Auditable', expression: 'Expression') -> 'AuditTrail': ...
    @typing.overload
    @staticmethod
    def create(auditable: 'Auditable', expression: 'Expression', string: str) -> 'AuditTrail': ...
    @typing.overload
    @staticmethod
    def create(auditable: 'Auditable', formattedString: VASSAL.tools.FormattedString) -> 'AuditTrail': ...
    @typing.overload
    @staticmethod
    def create(auditable: 'Auditable', formattedString: VASSAL.tools.FormattedString, string: str) -> 'AuditTrail': ...
    @typing.overload
    @staticmethod
    def create(auditable: 'Auditable', string: str) -> 'AuditTrail': ...
    @typing.overload
    @staticmethod
    def create(auditable: 'Auditable', string: str, string2: str) -> 'AuditTrail': ...
    @staticmethod
    def isEnabled() -> bool: ...
    @staticmethod
    def isReportingInProgress() -> bool: ...
    def setExpression(self, string: str) -> None: ...
    @staticmethod
    def setReportingInProgress(boolean: bool) -> None: ...
    def setSource(self, auditable: 'Auditable') -> None: ...
    def toString(self) -> str: ...

class Auditable:
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...

class AuditableException(java.lang.Exception):
    def __init__(self, auditable: Auditable, auditTrail: AuditTrail): ...
    def getAuditReport(self) -> str: ...
    def getAuditTrail(self) -> AuditTrail: ...
    def getOwner(self) -> Auditable: ...

class Expression:
    @staticmethod
    def createExpression(string: str) -> 'Expression': ...
    @staticmethod
    def createPropertyExpression(string: str) -> 'Expression': ...
    @staticmethod
    def createSimplePropertyExpression(string: str) -> 'Expression': ...
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def evaluate(self) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, boolean: bool) -> str: ...
    def getExpression(self) -> str: ...
    @typing.overload
    def getFilter(self) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, propertySource: VASSAL.build.module.properties.PropertySource) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, auditTrail: AuditTrail) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, auditable: Auditable, auditTrail: AuditTrail) -> VASSAL.counters.PieceFilter: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def quietEvaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, string: str) -> str: ...
    @typing.overload
    def quietEvaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @staticmethod
    def resetCachedExpressions() -> None: ...
    def setExpression(self, string: str) -> None: ...
    def toBeanShellString(self) -> str: ...
    @typing.overload
    def tryEvaluate(self) -> str: ...
    @typing.overload
    def tryEvaluate(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @typing.overload
    def tryEvaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def tryEvaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, string: str) -> str: ...
    @typing.overload
    def tryEvaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool) -> str: ...
    @typing.overload
    def tryEvaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def tryEvaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool) -> str: ...
    @typing.overload
    def tryEvaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def tryEvaluate(self, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def tryEvaluate(self, boolean: bool) -> str: ...
    @typing.overload
    def tryEvaluate(self, boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...

class ExpressionBuilder(javax.swing.JDialog):
    @typing.overload
    def __init__(self, configurer: VASSAL.configure.Configurer, jDialog: javax.swing.JDialog): ...
    @typing.overload
    def __init__(self, configurer: VASSAL.configure.Configurer, jDialog: javax.swing.JDialog, editablePiece: VASSAL.counters.EditablePiece): ...
    def cancel(self) -> None: ...
    def convert(self, string: str) -> str: ...
    def getExpression(self) -> str: ...
    def save(self) -> None: ...
    def setExpression(self, string: str) -> None: ...

class FunctionBuilder(javax.swing.JDialog):
    def __init__(self, stringConfigurer: VASSAL.configure.StringConfigurer, jDialog: javax.swing.JDialog, string2: str, string3: str, stringArray: typing.List[str], editablePiece: VASSAL.counters.EditablePiece, stringArray2: typing.List[str], optionArray: typing.List[VASSAL.configure.BeanShellExpressionConfigurer.Option], string6: str): ...
    def cancel(self) -> None: ...
    def save(self) -> None: ...
    @typing.overload
    def update(self) -> None: ...
    @typing.overload
    def update(self, graphics: java.awt.Graphics) -> None: ...

class StrBuilder(javax.swing.JDialog):
    @typing.overload
    def __init__(self, stringConfigurer: VASSAL.configure.StringConfigurer, jDialog: javax.swing.JDialog): ...
    @typing.overload
    def __init__(self, jDialog: javax.swing.JDialog, string: str, boolean: bool): ...

class BeanShellExpression(Expression):
    def __init__(self, string: str): ...
    @staticmethod
    def convertProperty(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def createExpression(string: str) -> Expression: ...
    @typing.overload
    @staticmethod
    def createExpression(string: str, boolean: bool) -> Expression: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, boolean: bool) -> str: ...
    @typing.overload
    def getFilter(self, propertySource: VASSAL.build.module.properties.PropertySource) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, auditTrail: AuditTrail) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, auditable: Auditable, auditTrail: AuditTrail) -> VASSAL.counters.PieceFilter: ...
    @staticmethod
    def instance(string: str) -> Expression: ...
    @staticmethod
    def isBeanShellExpression(string: str) -> bool: ...
    @staticmethod
    def isJavaIdentifier(string: str) -> bool: ...
    def toBeanShellString(self) -> str: ...
    class BshFilter(VASSAL.counters.PieceFilter):
        def __init__(self, beanShellExpression: 'BeanShellExpression', auditable: Auditable, auditTrail: AuditTrail): ...
        @typing.overload
        def accept(self, gamePiece: VASSAL.counters.GamePiece) -> bool: ...
        @typing.overload
        def accept(self, gamePiece: VASSAL.counters.GamePiece, auditable: Auditable, auditTrail: AuditTrail) -> bool: ...
        @typing.overload
        def accept(self, gamePiece: VASSAL.counters.GamePiece, auditable: Auditable, string: str) -> bool: ...

class ExpressionException(AuditableException):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, auditable: Auditable, auditTrail: AuditTrail): ...
    def getError(self) -> str: ...
    def getExpression(self) -> str: ...

class FormattedStringExpression(Expression):
    def __init__(self, string: str): ...
    @typing.overload
    def evaluate(self) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @staticmethod
    def instance(string: str) -> Expression: ...
    def toBeanShellString(self) -> str: ...

class IntBuilder(StrBuilder):
    def __init__(self, stringConfigurer: VASSAL.configure.StringConfigurer, jDialog: javax.swing.JDialog): ...

class IntExpression(Expression):
    @staticmethod
    def instance(int: int) -> Expression: ...

class NullExpression(Expression):
    @staticmethod
    def instance() -> 'NullExpression': ...

class PropertyExpressionBuilder(ExpressionBuilder):
    @typing.overload
    def __init__(self, configurer: VASSAL.configure.Configurer, jDialog: javax.swing.JDialog): ...
    @typing.overload
    def __init__(self, configurer: VASSAL.configure.Configurer, jDialog: javax.swing.JDialog, editablePiece: VASSAL.counters.EditablePiece): ...
    def convert(self, string: str) -> str: ...

class PropertyMatchExpression(Expression):
    def __init__(self, string: str): ...
    @typing.overload
    def evaluate(self) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool) -> str: ...
    @typing.overload
    def getFilter(self) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, auditable: Auditable, auditTrail: AuditTrail) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, propertySource: VASSAL.build.module.properties.PropertySource) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, auditTrail: AuditTrail) -> VASSAL.counters.PieceFilter: ...
    @staticmethod
    def instance(string: str) -> Expression: ...
    def toBeanShellString(self) -> str: ...

class PropertyNameExpressionBuilder(ExpressionBuilder):
    @typing.overload
    def __init__(self, configurer: VASSAL.configure.Configurer, jDialog: javax.swing.JDialog): ...
    @typing.overload
    def __init__(self, configurer: VASSAL.configure.Configurer, jDialog: javax.swing.JDialog, editablePiece: VASSAL.counters.EditablePiece): ...
    def convert(self, string: str) -> str: ...
    def save(self) -> None: ...

class SinglePropertyExpression(Expression):
    def __init__(self, string: str): ...
    @typing.overload
    def evaluate(self) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @typing.overload
    def evaluate(self, boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool) -> str: ...
    @typing.overload
    def evaluate(self, propertySource: VASSAL.build.module.properties.PropertySource, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], boolean: bool, auditable: Auditable, auditTrail: AuditTrail) -> str: ...
    @staticmethod
    def instance(string: str) -> Expression: ...
    def toBeanShellString(self) -> str: ...

class StringExpression(Expression):
    @staticmethod
    def instance(string: str) -> Expression: ...
    def toBeanShellString(self) -> str: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.script.expression")``.

    AuditTrail: typing.Type[AuditTrail]
    Auditable: typing.Type[Auditable]
    AuditableException: typing.Type[AuditableException]
    BeanShellExpression: typing.Type[BeanShellExpression]
    Expression: typing.Type[Expression]
    ExpressionBuilder: typing.Type[ExpressionBuilder]
    ExpressionException: typing.Type[ExpressionException]
    FormattedStringExpression: typing.Type[FormattedStringExpression]
    FunctionBuilder: typing.Type[FunctionBuilder]
    IntBuilder: typing.Type[IntBuilder]
    IntExpression: typing.Type[IntExpression]
    NullExpression: typing.Type[NullExpression]
    PropertyExpressionBuilder: typing.Type[PropertyExpressionBuilder]
    PropertyMatchExpression: typing.Type[PropertyMatchExpression]
    PropertyNameExpressionBuilder: typing.Type[PropertyNameExpressionBuilder]
    SinglePropertyExpression: typing.Type[SinglePropertyExpression]
    StrBuilder: typing.Type[StrBuilder]
    StringExpression: typing.Type[StringExpression]
