import VASSAL
import VASSAL.build
import VASSAL.build.module
import VASSAL.build.module.documentation
import VASSAL.build.module.map.boardPicker
import VASSAL.build.module.map.deck
import VASSAL.build.module.properties
import VASSAL.command
import VASSAL.configure
import VASSAL.counters
import VASSAL.i18n
import VASSAL.script.expression
import VASSAL.search
import VASSAL.tools
import java.awt
import java.awt.dnd
import java.awt.event
import java.awt.geom
import java.awt.image
import java.beans
import java.util
import javax.swing
import org.w3c.dom
import typing



class BoardPicker(VASSAL.build.AbstractBuildable, java.awt.event.ActionListener, VASSAL.build.module.GameComponent, VASSAL.build.module.GameSetupStep, VASSAL.build.Configurable, VASSAL.command.CommandEncoder, VASSAL.configure.ValidityChecker):
    ID: typing.ClassVar[str] = ...
    SCALE: typing.ClassVar[str] = ...
    SLOT_HEIGHT: typing.ClassVar[str] = ...
    SLOT_WIDTH: typing.ClassVar[str] = ...
    SETUP: typing.ClassVar[str] = ...
    DIALOG_TITLE: typing.ClassVar[str] = ...
    ADD_ROW_BUTTON_TEXT: typing.ClassVar[str] = ...
    ADD_COLUMN_BUTTON_TEXT: typing.ClassVar[str] = ...
    BOARD_PROMPT: typing.ClassVar[str] = ...
    MAX_COLUMNS: typing.ClassVar[str] = ...
    def __init__(self): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def finish(self) -> None: ...
    def getAllowableBoardNames(self) -> typing.List[str]: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAllowableLocalizedBoardNames(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBoard(self, string: str) -> VASSAL.build.module.map.boardPicker.Board: ...
    def getBoardDelimiter(self) -> str: ...
    def getBoardsFromControls(self) -> java.util.List[VASSAL.build.module.map.boardPicker.Board]: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getColumnCount(self) -> int: ...
    def getConfigureComponents(self) -> typing.List[VASSAL.build.Configurable]: ...
    def getConfigureName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getControls(self) -> java.awt.Component: ...
    def getDefaultSlotSize(self) -> java.awt.Dimension: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getLocalizedBoard(self, string: str) -> VASSAL.build.module.map.boardPicker.Board: ...
    def getNeighbor(self, boardSlot: VASSAL.build.module.map.boardPicker.BoardSlot, int: int, int2: int) -> VASSAL.build.module.map.boardPicker.BoardSlot: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getRowCount(self) -> int: ...
    def getSelectedBoardNames(self) -> java.util.List[str]: ...
    def getSelectedBoards(self) -> java.util.Collection[VASSAL.build.module.map.boardPicker.Board]: ...
    def getSlot(self, int: int) -> VASSAL.build.module.map.boardPicker.BoardSlot: ...
    def getSlotScale(self) -> float: ...
    def getStepTitle(self) -> str: ...
    def isAllowMultiple(self) -> bool: ...
    def isFinished(self) -> bool: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def repaint(self) -> None: ...
    def repaintAll(self) -> None: ...
    def reset(self) -> None: ...
    def setAllowMultiple(self, boolean: bool) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setBoards(self, collection: typing.Union[java.util.Collection[VASSAL.build.module.map.boardPicker.Board], typing.Sequence[VASSAL.build.module.map.boardPicker.Board], typing.Set[VASSAL.build.module.map.boardPicker.Board]]) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: VASSAL.configure.ValidationReport) -> None: ...
    def warn(self, string: str) -> None: ...
    class SetBoards(VASSAL.command.Command):
        def __init__(self, boardPicker: 'BoardPicker', list: java.util.List[VASSAL.build.module.map.boardPicker.Board]): ...

class Drawable:
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    def drawAboveCounters(self) -> bool: ...

class ForwardToChatter(VASSAL.build.Buildable, java.awt.event.KeyListener):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...

class ForwardToKeyBuffer(VASSAL.build.Buildable, java.awt.event.KeyListener):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...

class ImageSaver(VASSAL.build.AbstractToolbarItem):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, map: VASSAL.build.module.Map): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def writeMapAsImage(self) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class LayerControl(VASSAL.build.AbstractToolbarItem):
    COMMAND: typing.ClassVar[str] = ...
    SKIP: typing.ClassVar[str] = ...
    LAYERS: typing.ClassVar[str] = ...
    CMD_ROTATE_UP: typing.ClassVar[str] = ...
    CMD_ROTATE_DN: typing.ClassVar[str] = ...
    CMD_ENABLE: typing.ClassVar[str] = ...
    CMD_DISABLE: typing.ClassVar[str] = ...
    CMD_TOGGLE: typing.ClassVar[str] = ...
    CMD_RESET: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    BUTTON_ICON: typing.ClassVar[str] = ...
    BUTTON_HOTKEY: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def launch(self) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class CommandConfig(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class MapCenterer(VASSAL.build.AbstractBuildable, java.awt.event.MouseListener):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class MassKeyCommand(VASSAL.build.AbstractToolbarItem, VASSAL.tools.RecursionLimiter.Loopable):
    DEPRECATED_NAME: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    KEY_COMMAND: typing.ClassVar[str] = ...
    AFFECTED_PIECE_NAMES: typing.ClassVar[str] = ...
    PROPERTIES_FILTER: typing.ClassVar[str] = ...
    REPORT_SINGLE: typing.ClassVar[str] = ...
    REPORT_FORMAT: typing.ClassVar[str] = ...
    CONDITION: typing.ClassVar[str] = ...
    DECK_COUNT: typing.ClassVar[str] = ...
    CHECK_PROPERTY: typing.ClassVar[str] = ...
    CHECK_VALUE: typing.ClassVar[str] = ...
    SINGLE_MAP: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    TARGET: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, massKeyCommand: 'MassKeyCommand'): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def apply(self) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    @typing.overload
    def getFilter(self) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, auditTrail: VASSAL.script.expression.AuditTrail) -> VASSAL.counters.PieceFilter: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getGKCtype(self) -> VASSAL.counters.GlobalCommandTarget.GKCtype: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getTarget(self) -> VASSAL.counters.GlobalCommandTarget: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setPropertySource(self, propertySource: VASSAL.build.module.properties.PropertySource) -> None: ...
    class DeckPolicyConfig(VASSAL.configure.Configurer, VASSAL.configure.ConfigurerFactory):
        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, boolean: bool): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
        def getControls(self) -> java.awt.Component: ...
        def getIntValue(self) -> int: ...
        def getValueString(self) -> str: ...
        @typing.overload
        def setValue(self, object: typing.Any) -> None: ...
        @typing.overload
        def setValue(self, string: str) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class Prompt(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class ReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class MenuDisplayer(java.awt.event.MouseAdapter, VASSAL.build.Buildable):
    POPUP_MENU_FONT: typing.ClassVar[java.awt.Font] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    @typing.overload
    @staticmethod
    def createPopup(gamePiece: VASSAL.counters.GamePiece) -> javax.swing.JPopupMenu: ...
    @typing.overload
    @staticmethod
    def createPopup(gamePiece: VASSAL.counters.GamePiece, boolean: bool) -> javax.swing.JPopupMenu: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...

class PieceCollection:
    def add(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def canMerge(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece) -> bool: ...
    def clear(self) -> None: ...
    def getAllPieces(self) -> typing.List[VASSAL.counters.GamePiece]: ...
    def getPieces(self) -> typing.List[VASSAL.counters.GamePiece]: ...
    def indexOf(self, gamePiece: VASSAL.counters.GamePiece) -> int: ...
    def moveToBack(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def moveToFront(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def remove(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...

class PieceRecenterer(VASSAL.build.AbstractToolbarItem, VASSAL.counters.DeckVisitor):
    BUTTON_TEXT: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def recenter(self, map: VASSAL.build.module.Map) -> VASSAL.command.Command: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def visitDeck(self, deck: VASSAL.counters.Deck) -> typing.Any: ...
    def visitDefault(self, gamePiece: VASSAL.counters.GamePiece) -> typing.Any: ...
    def visitStack(self, stack: VASSAL.counters.Stack) -> typing.Any: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class Scroller(VASSAL.build.AbstractBuildable, java.awt.event.KeyListener):
    USE_ARROWS: typing.ClassVar[str] = ...
    ALWAYS: typing.ClassVar[str] = ...
    NEVER: typing.ClassVar[str] = ...
    PROMPT: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class SelectionHighlighter(VASSAL.build.AbstractConfigurable, VASSAL.counters.Highlighter):
    NAME: typing.ClassVar[str] = ...
    MATCH: typing.ClassVar[str] = ...
    COLOR: typing.ClassVar[str] = ...
    THICKNESS: typing.ClassVar[str] = ...
    USE_IMAGE: typing.ClassVar[str] = ...
    IMAGE: typing.ClassVar[str] = ...
    X_OFFSET: typing.ClassVar[str] = ...
    Y_OFFSET: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def boundingBox(self, gamePiece: VASSAL.counters.GamePiece) -> java.awt.Rectangle: ...
    def draw(self, gamePiece: VASSAL.counters.GamePiece, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class SelectionHighlighters(VASSAL.build.AbstractConfigurable):
    def __init__(self): ...
    def addHighlighter(self, selectionHighlighter: SelectionHighlighter) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeHighlighter(self, selectionHighlighter: SelectionHighlighter) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class SetupStack(VASSAL.build.AbstractConfigurable, VASSAL.build.module.GameComponent, VASSAL.tools.UniqueIdManager.Identifyable):
    COMMAND_PREFIX: typing.ClassVar[str] = ...
    OWNING_BOARD: typing.ClassVar[str] = ...
    X_POSITION: typing.ClassVar[str] = ...
    Y_POSITION: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    LOCATION: typing.ClassVar[str] = ...
    USE_GRID_LOCATION: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getId(self) -> str: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setId(self, string: str) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: VASSAL.configure.ValidationReport) -> None: ...
    class OwningBoardPrompt(VASSAL.configure.TranslatableStringEnum):
        ANY: typing.ClassVar[str] = ...
        ANY_NAME: typing.ClassVar[str] = ...
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def isDisplayNames(self) -> bool: ...
    class StackConfigurer(javax.swing.JFrame, java.awt.event.ActionListener, java.awt.event.KeyListener, java.awt.event.MouseListener):
        def __init__(self, setupStack: 'SetupStack', setupStack2: 'SetupStack'): ...
        def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
        @typing.overload
        def drawDummyImage(self, graphics: java.awt.Graphics, int: int, int2: int) -> None: ...
        @typing.overload
        def drawDummyImage(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
        def drawImage(self, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
        def getDummyImage(self) -> java.awt.image.BufferedImage: ...
        def getPieceBoundingBox(self) -> java.awt.Rectangle: ...
        def getScroll(self) -> javax.swing.JScrollPane: ...
        def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
        def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
        def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
        def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
        def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
        def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
        def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
        def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
        @typing.overload
        def updateCoords(self) -> None: ...
        @typing.overload
        def updateCoords(self, string: str) -> None: ...
        def updateDisplay(self) -> None: ...
    class View(javax.swing.JPanel, java.awt.dnd.DropTargetListener, java.awt.dnd.DragGestureListener, java.awt.dnd.DragSourceListener, java.awt.dnd.DragSourceMotionListener):
        def __init__(self, board: VASSAL.build.module.map.boardPicker.Board, setupStack: 'SetupStack'): ...
        def center(self, point: java.awt.Point) -> None: ...
        def dragDropEnd(self, dragSourceDropEvent: java.awt.dnd.DragSourceDropEvent) -> None: ...
        @typing.overload
        def dragEnter(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        @typing.overload
        def dragEnter(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
        @typing.overload
        def dragExit(self, dragSourceEvent: java.awt.dnd.DragSourceEvent) -> None: ...
        @typing.overload
        def dragExit(self, dropTargetEvent: java.awt.dnd.DropTargetEvent) -> None: ...
        def dragGestureRecognized(self, dragGestureEvent: java.awt.dnd.DragGestureEvent) -> None: ...
        def dragMouseMoved(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        @typing.overload
        def dragOver(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        @typing.overload
        def dragOver(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
        def drop(self, dropTargetDropEvent: java.awt.dnd.DropTargetDropEvent) -> None: ...
        @typing.overload
        def dropActionChanged(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        @typing.overload
        def dropActionChanged(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
        def getPreferredSize(self) -> java.awt.Dimension: ...
        def paint(self, graphics: java.awt.Graphics) -> None: ...
        def scrollAtEdge(self, point: java.awt.Point, int: int) -> None: ...
        def update(self, graphics: java.awt.Graphics) -> None: ...

class SmallList(java.awt.List):
    def __init__(self): ...
    def paint(self, graphics: java.awt.Graphics) -> None: ...

class StackExpander(java.awt.event.MouseAdapter, VASSAL.build.Buildable):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...

class StackMetrics(VASSAL.build.AbstractConfigurable):
    EXSEP_X: typing.ClassVar[str] = ...
    EXSEP_Y: typing.ClassVar[str] = ...
    UNEXSEP_X: typing.ClassVar[str] = ...
    UNEXSEP_Y: typing.ClassVar[str] = ...
    DISABLED: typing.ClassVar[str] = ...
    TOP_KEY: typing.ClassVar[str] = ...
    BOTTOM_KEY: typing.ClassVar[str] = ...
    UP_KEY: typing.ClassVar[str] = ...
    DOWN_KEY: typing.ClassVar[str] = ...
    COLOR: typing.ClassVar[str] = ...
    DEFAULT_EXSEP_X: typing.ClassVar[int] = ...
    DEFAULT_EXSEP_Y: typing.ClassVar[int] = ...
    DEFAULT_UNEXSEP_X: typing.ClassVar[int] = ...
    DEFAULT_UNEXSEP_Y: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, boolean: bool, int: int, int2: int, int3: int, int4: int): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    @typing.overload
    def createStack(self, gamePiece: VASSAL.counters.GamePiece) -> VASSAL.counters.Stack: ...
    @typing.overload
    def createStack(self, gamePiece: VASSAL.counters.GamePiece, boolean: bool) -> VASSAL.counters.Stack: ...
    @typing.overload
    def draw(self, stack: VASSAL.counters.Stack, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    @typing.overload
    def draw(self, stack: VASSAL.counters.Stack, point: java.awt.Point, graphics: java.awt.Graphics, map: VASSAL.build.module.Map, double: float, rectangle: java.awt.Rectangle) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getBlankColor(self) -> java.awt.Color: ...
    def getConfigureName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getContents(self, stack: VASSAL.counters.Stack, pointArray: typing.List[java.awt.Point], shapeArray: typing.List[java.awt.Shape], rectangleArray: typing.List[java.awt.Rectangle], int: int, int2: int) -> int: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getMoveBottomKey(self) -> javax.swing.KeyStroke: ...
    def getMoveDownKey(self) -> javax.swing.KeyStroke: ...
    def getMoveTopKey(self) -> javax.swing.KeyStroke: ...
    def getMoveUpKey(self) -> javax.swing.KeyStroke: ...
    def isStackingEnabled(self) -> bool: ...
    def merge(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece) -> VASSAL.command.Command: ...
    def placeOrMerge(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece) -> VASSAL.command.Command: ...
    def relativePosition(self, stack: VASSAL.counters.Stack, gamePiece: VASSAL.counters.GamePiece) -> java.awt.Point: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class TextSaver(VASSAL.build.AbstractToolbarItem):
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def apply(self) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class Zoomer(VASSAL.build.AbstractConfigurable, VASSAL.build.module.GameComponent):
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getZoomFactor(self) -> float: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setZoomFactor(self, double: float) -> None: ...
    def setZoomLevel(self, int: int) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def zoomIn(self) -> None: ...
    def zoomOut(self) -> None: ...
    class InIconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class LevelConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class OutIconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class PickIconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class CompoundPieceCollection(PieceCollection):
    def add(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def canMerge(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece) -> bool: ...
    def clear(self) -> None: ...
    def getAllPieces(self) -> typing.List[VASSAL.counters.GamePiece]: ...
    def getBottomLayer(self) -> int: ...
    def getLayerCount(self) -> int: ...
    def getLayerForName(self, string: str) -> int: ...
    def getLayerForPiece(self, gamePiece: VASSAL.counters.GamePiece) -> int: ...
    def getLayerNameForPiece(self, gamePiece: VASSAL.counters.GamePiece) -> str: ...
    def getPieces(self) -> typing.List[VASSAL.counters.GamePiece]: ...
    def getTopLayer(self) -> int: ...
    def indexOf(self, gamePiece: VASSAL.counters.GamePiece) -> int: ...
    def moveToBack(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def moveToFront(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def remove(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def reset(self) -> None: ...
    @typing.overload
    def rotate(self, boolean: bool) -> None: ...
    @typing.overload
    def rotate(self, boolean: bool, boolean2: bool) -> None: ...
    def setBottomLayer(self, int: int) -> None: ...
    @typing.overload
    def setLayerEnabled(self, int: int, boolean: bool) -> None: ...
    @typing.overload
    def setLayerEnabled(self, string: str, boolean: bool) -> None: ...
    @typing.overload
    def toggleLayerEnabled(self, int: int) -> None: ...
    @typing.overload
    def toggleLayerEnabled(self, string: str) -> None: ...

class CounterDetailViewer(VASSAL.build.AbstractConfigurable, Drawable, java.awt.dnd.DragSourceMotionListener, java.awt.event.MouseMotionListener, java.awt.event.MouseListener, java.awt.event.KeyListener):
    LATEST_VERSION: typing.ClassVar[str] = ...
    USE_KEYBOARD: typing.ClassVar[str] = ...
    PREFERRED_DELAY: typing.ClassVar[str] = ...
    DELAY: typing.ClassVar[str] = ...
    DRAW_PIECES: typing.ClassVar[str] = ...
    GRAPH_SINGLE_DEPRECATED: typing.ClassVar[str] = ...
    MINIMUM_DISPLAYABLE: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    DESCRIPTION: typing.ClassVar[str] = ...
    CENTER_TEXT: typing.ClassVar[str] = ...
    CENTER_ALL: typing.ClassVar[str] = ...
    COMBINE_COUNTER_SUMMARY: typing.ClassVar[str] = ...
    VERTICAL_OFFSET: typing.ClassVar[str] = ...
    VERTICAL_TOP_TEXT: typing.ClassVar[str] = ...
    STRETCH_WIDTH_SUMMARY: typing.ClassVar[str] = ...
    SHOW_TEXT: typing.ClassVar[str] = ...
    ENABLE_HTML: typing.ClassVar[str] = ...
    SHOW_TEXT_SINGLE_DEPRECATED: typing.ClassVar[str] = ...
    ZOOM_LEVEL: typing.ClassVar[str] = ...
    DRAW_PIECES_AT_ZOOM: typing.ClassVar[str] = ...
    BORDER_WIDTH: typing.ClassVar[str] = ...
    SHOW_NOSTACK: typing.ClassVar[str] = ...
    SHOW_MOVE_SELECTED: typing.ClassVar[str] = ...
    SHOW_NON_MOVABLE: typing.ClassVar[str] = ...
    SHOW_DECK: typing.ClassVar[str] = ...
    SHOW_DECK_DEPTH: typing.ClassVar[str] = ...
    SHOW_OVERLAP: typing.ClassVar[str] = ...
    UNROTATE_PIECES: typing.ClassVar[str] = ...
    DISPLAY: typing.ClassVar[str] = ...
    LAYER_LIST: typing.ClassVar[str] = ...
    SUMMARY_REPORT_FORMAT: typing.ClassVar[str] = ...
    COUNTER_REPORT_FORMAT: typing.ClassVar[str] = ...
    EMPTY_HEX_REPORT_FORMAT: typing.ClassVar[str] = ...
    VERSION: typing.ClassVar[str] = ...
    FG_COLOR: typing.ClassVar[str] = ...
    BG_COLOR: typing.ClassVar[str] = ...
    FONT_SIZE: typing.ClassVar[str] = ...
    EXTRA_TEXT_PADDING: typing.ClassVar[str] = ...
    PROPERTY_FILTER: typing.ClassVar[str] = ...
    TOP_LAYER: typing.ClassVar[str] = ...
    ALL_LAYERS: typing.ClassVar[str] = ...
    INC_LAYERS: typing.ClassVar[str] = ...
    EXC_LAYERS: typing.ClassVar[str] = ...
    FILTER: typing.ClassVar[str] = ...
    SUM: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def dragMouseMoved(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
    @typing.overload
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    @typing.overload
    def draw(self, graphics: java.awt.Graphics, point: java.awt.Point, jComponent: javax.swing.JComponent) -> None: ...
    def drawAboveCounters(self) -> bool: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getConfigureName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    @staticmethod
    def isDrawingMouseOver() -> bool: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseDragged(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseMoved(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class CounterFormatConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class DisplayConfig(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class EmptyFormatConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class MinConfig(VASSAL.configure.StringEnum):
        def __init__(self): ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class ReportFormatConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class DeckGlobalKeyCommand(MassKeyCommand):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, massKeyCommand: MassKeyCommand): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, propertySource: VASSAL.build.module.properties.PropertySource): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    @typing.overload
    def apply(self, deck: VASSAL.counters.Deck) -> None: ...
    @typing.overload
    def apply(self) -> None: ...
    def decode(self, string: str) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    @typing.overload
    def getFilter(self) -> VASSAL.counters.PieceFilter: ...
    @typing.overload
    def getFilter(self, auditTrail: VASSAL.script.expression.AuditTrail) -> VASSAL.counters.PieceFilter: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getGKCtype(self) -> VASSAL.counters.GlobalCommandTarget.GKCtype: ...
    def getKeyCommand(self, deck: VASSAL.counters.Deck) -> VASSAL.counters.KeyCommand: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    class DeckGlobalCommand(VASSAL.counters.GlobalCommand):
        def __init__(self, loopable: VASSAL.tools.RecursionLimiter.Loopable): ...
        @typing.overload
        def apply(self, deck: VASSAL.counters.Deck, pieceFilter: typing.Union[VASSAL.counters.PieceFilter, typing.Callable]) -> VASSAL.command.Command: ...
        @typing.overload
        def apply(self, map: VASSAL.build.module.Map, pieceFilter: typing.Union[VASSAL.counters.PieceFilter, typing.Callable]) -> VASSAL.command.Command: ...
        @typing.overload
        def apply(self, map: VASSAL.build.module.Map, pieceFilter: typing.Union[VASSAL.counters.PieceFilter, typing.Callable], globalCommandTarget: VASSAL.counters.GlobalCommandTarget) -> VASSAL.command.Command: ...
        @typing.overload
        def apply(self, map: VASSAL.build.module.Map, pieceFilter: typing.Union[VASSAL.counters.PieceFilter, typing.Callable], globalCommandTarget: VASSAL.counters.GlobalCommandTarget, auditTrail: VASSAL.script.expression.AuditTrail) -> VASSAL.command.Command: ...
        @typing.overload
        def apply(self, mapArray: typing.List[VASSAL.build.module.Map], pieceFilter: typing.Union[VASSAL.counters.PieceFilter, typing.Callable]) -> VASSAL.command.Command: ...
        @typing.overload
        def apply(self, mapArray: typing.List[VASSAL.build.module.Map], pieceFilter: typing.Union[VASSAL.counters.PieceFilter, typing.Callable], globalCommandTarget: VASSAL.counters.GlobalCommandTarget) -> VASSAL.command.Command: ...
        @typing.overload
        def apply(self, mapArray: typing.List[VASSAL.build.module.Map], pieceFilter: typing.Union[VASSAL.counters.PieceFilter, typing.Callable], globalCommandTarget: VASSAL.counters.GlobalCommandTarget, auditTrail: VASSAL.script.expression.AuditTrail) -> VASSAL.command.Command: ...
        def getComponentTypeName(self) -> str: ...
    class DeckPolicyConfig2(MassKeyCommand.DeckPolicyConfig):
        def __init__(self): ...

class DrawPile(SetupStack, VASSAL.build.module.properties.PropertySource, VASSAL.build.module.properties.PropertyNameSource):
    WIDTH: typing.ClassVar[str] = ...
    HEIGHT: typing.ClassVar[str] = ...
    ALLOW_MULTIPLE: typing.ClassVar[str] = ...
    ALLOW_SELECT: typing.ClassVar[str] = ...
    SELECT_DISPLAY_PROPERTY: typing.ClassVar[str] = ...
    SELECT_SORT_PROPERTY: typing.ClassVar[str] = ...
    FACE_DOWN: typing.ClassVar[str] = ...
    DRAW_FACE_UP: typing.ClassVar[str] = ...
    FACE_DOWN_REPORT_FORMAT: typing.ClassVar[str] = ...
    FACE_DOWN_HOTKEY: typing.ClassVar[str] = ...
    SHUFFLE: typing.ClassVar[str] = ...
    SHUFFLE_REPORT_FORMAT: typing.ClassVar[str] = ...
    SHUFFLE_HOTKEY: typing.ClassVar[str] = ...
    SHUFFLE_COMMAND: typing.ClassVar[str] = ...
    REVERSIBLE: typing.ClassVar[str] = ...
    REVERSE_REPORT_FORMAT: typing.ClassVar[str] = ...
    REVERSE_HOTKEY: typing.ClassVar[str] = ...
    REVERSE_COMMAND: typing.ClassVar[str] = ...
    DRAW: typing.ClassVar[str] = ...
    COLOR: typing.ClassVar[str] = ...
    MAXSTACK: typing.ClassVar[str] = ...
    EXPRESSIONCOUNTING: typing.ClassVar[str] = ...
    COUNTEXPRESSIONS: typing.ClassVar[str] = ...
    RESHUFFLABLE: typing.ClassVar[str] = ...
    RESHUFFLE_COMMAND: typing.ClassVar[str] = ...
    RESHUFFLE_TARGET: typing.ClassVar[str] = ...
    RESHUFFLE_MESSAGE: typing.ClassVar[str] = ...
    RESHUFFLE_HOTKEY: typing.ClassVar[str] = ...
    REPORT_FORMAT: typing.ClassVar[str] = ...
    CAN_SAVE: typing.ClassVar[str] = ...
    HOTKEY_ON_EMPTY: typing.ClassVar[str] = ...
    EMPTY_HOTKEY: typing.ClassVar[str] = ...
    RESTRICT_OPTION: typing.ClassVar[str] = ...
    RESTRICT_EXPRESSION: typing.ClassVar[str] = ...
    ALWAYS: typing.ClassVar[str] = ...
    NEVER: typing.ClassVar[str] = ...
    USE_MENU: typing.ClassVar[str] = ...
    USE_MENU_UP: typing.ClassVar[str] = ...
    COMMAND_NAME: typing.ClassVar[str] = ...
    DECK_NAME: typing.ClassVar[str] = ...
    DRAW_MULTIPLE_MESSAGE: typing.ClassVar[str] = ...
    DRAW_SPECIFIC_MESSAGE: typing.ClassVar[str] = ...
    FACE_UP_MESSAGE: typing.ClassVar[str] = ...
    FACE_DOWN_MESSAGE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addGlobalKeyCommand(self, deckGlobalKeyCommand: DeckGlobalKeyCommand) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addToContents(self, gamePiece: VASSAL.counters.GamePiece) -> VASSAL.command.Command: ...
    def boundingBox(self) -> java.awt.Rectangle: ...
    @staticmethod
    def findDrawPile(string: str) -> 'DrawPile': ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDeck(self) -> VASSAL.counters.Deck: ...
    def getDeckKeyCommands(self) -> java.util.List[VASSAL.build.module.map.deck.DeckKeyCommand]: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPosition(self) -> java.awt.Point: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def getSize(self) -> java.awt.Dimension: ...
    def isReshufflable(self) -> bool: ...
    def removeGlobalKeyCommand(self, deckGlobalKeyCommand: DeckGlobalKeyCommand) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setDeck(self, deck: VASSAL.counters.Deck) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class AssignedDeckPrompt(VASSAL.configure.TranslatableStringEnum):
        NONE: typing.ClassVar[str] = ...
        NONE_NAME: typing.ClassVar[str] = ...
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def isDisplayNames(self) -> bool: ...
    class FormattedStringConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class PiecePropertyConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class Prompt(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class Prompt2(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class Flare(VASSAL.build.AbstractConfigurable, VASSAL.command.CommandEncoder, VASSAL.build.module.GameComponent, Drawable, java.awt.event.MouseListener, VASSAL.tools.UniqueIdManager.Identifyable):
    COMMAND_PREFIX: typing.ClassVar[str] = ...
    NO_ANIMATION: typing.ClassVar[str] = ...
    CIRCLE_SIZE: typing.ClassVar[str] = ...
    CIRCLE_SCALE: typing.ClassVar[str] = ...
    CIRCLE_COLOR: typing.ClassVar[str] = ...
    FLARE_KEY: typing.ClassVar[str] = ...
    PULSES: typing.ClassVar[str] = ...
    PULSES_PER_SEC: typing.ClassVar[str] = ...
    REPORT_FORMAT: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    FLARE_ALT_LOCAL: typing.ClassVar[str] = ...
    FLARE_CTRL_LOCAL: typing.ClassVar[str] = ...
    FLARE_COMMAND_LOCAL: typing.ClassVar[str] = ...
    FLARE_ALT_SHIFT_LOCAL: typing.ClassVar[str] = ...
    FLARE_SHIFT_COMMAND_LOCAL: typing.ClassVar[str] = ...
    FLARE_CTRL_SHIFT_LOCAL: typing.ClassVar[str] = ...
    FLARE_ALT_COMMAND_LOCAL: typing.ClassVar[str] = ...
    FLARE_CTRL_ALT_LOCAL: typing.ClassVar[str] = ...
    FLARE_ALT_SHIFT_COMMAND_LOCAL: typing.ClassVar[str] = ...
    FLARE_CTRL_ALT_SHIFT_LOCAL: typing.ClassVar[str] = ...
    FLARE_ALT: typing.ClassVar[str] = ...
    FLARE_CTRL: typing.ClassVar[str] = ...
    FLARE_ALT_SHIFT: typing.ClassVar[str] = ...
    FLARE_CTRL_SHIFT: typing.ClassVar[str] = ...
    FLARE_CTRL_ALT: typing.ClassVar[str] = ...
    FLARE_CTRL_ALT_SHIFT: typing.ClassVar[str] = ...
    FLARE_NAME: typing.ClassVar[str] = ...
    FLARE_LOCATION: typing.ClassVar[str] = ...
    FLARE_ZONE: typing.ClassVar[str] = ...
    FLARE_MAP: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    def drawAboveCounters(self) -> bool: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getClickPoint(self) -> java.awt.Point: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDescription(self) -> str: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setClickPoint(self, point: java.awt.Point) -> None: ...
    def setId(self, string: str) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    def startAnimation(self, boolean: bool) -> None: ...
    class FlareKeyConfig(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def isDisplayNames(self) -> bool: ...
    class ReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class GlobalMap(VASSAL.build.AutoConfigurable, VASSAL.build.module.GameComponent, Drawable, VASSAL.search.SearchTarget, VASSAL.search.ImageSearchTarget):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addImageNamesRecursively(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def componentToMap(self, point: java.awt.Point) -> java.awt.Point: ...
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    def drawAboveCounters(self) -> bool: ...
    def getAllImageNames(self) -> java.util.SortedSet[str]: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getConfigureComponents(self) -> typing.List[VASSAL.build.Configurable]: ...
    def getConfigureName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getLocalImageNames(self) -> java.util.SortedSet[str]: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def getToolTipText(self, mouseEvent: java.awt.event.MouseEvent) -> str: ...
    def mapToComponent(self, point: java.awt.Point) -> java.awt.Point: ...
    @typing.overload
    def mapToDrawing(self, point: java.awt.Point, double: float) -> java.awt.Point: ...
    @typing.overload
    def mapToDrawing(self, rectangle: java.awt.Rectangle, double: float) -> java.awt.Rectangle: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class HandMetrics(StackMetrics):
    def __init__(self): ...
    @typing.overload
    def draw(self, stack: VASSAL.counters.Stack, graphics: java.awt.Graphics, int: int, int2: int, component: java.awt.Component, double: float) -> None: ...
    @typing.overload
    def draw(self, stack: VASSAL.counters.Stack, point: java.awt.Point, graphics: java.awt.Graphics, map: VASSAL.build.module.Map, double: float, rectangle: java.awt.Rectangle) -> None: ...
    def merge(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece) -> VASSAL.command.Command: ...

class HidePiecesButton(javax.swing.JPanel, java.awt.event.MouseListener, VASSAL.build.AutoConfigurable, VASSAL.build.module.GameComponent, Drawable, VASSAL.search.SearchTarget, VASSAL.search.ImageSearchTarget):
    DEFAULT_SHOWING_ICON: typing.ClassVar[str] = ...
    DEFAULT_HIDDEN_ICON: typing.ClassVar[str] = ...
    LAUNCH_ICON: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    HIDDEN_ICON: typing.ClassVar[str] = ...
    SHOWING_ICON: typing.ClassVar[str] = ...
    def __init__(self): ...
    @typing.overload
    def add(self, component: java.awt.Component) -> java.awt.Component: ...
    @typing.overload
    def add(self, component: java.awt.Component, int: int) -> java.awt.Component: ...
    @typing.overload
    def add(self, string: str, component: java.awt.Component) -> java.awt.Component: ...
    @typing.overload
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    @typing.overload
    def add(self, popupMenu: java.awt.PopupMenu) -> None: ...
    @typing.overload
    def add(self, component: java.awt.Component, object: typing.Any) -> None: ...
    @typing.overload
    def add(self, component: java.awt.Component, object: typing.Any, int: int) -> None: ...
    def addImageNamesRecursively(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    @typing.overload
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @typing.overload
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    def drawAboveCounters(self) -> bool: ...
    def getAllImageNames(self) -> java.util.SortedSet[str]: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getConfigureComponents(self) -> typing.List[VASSAL.build.Configurable]: ...
    def getConfigureName(self) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getLocalImageNames(self) -> java.util.SortedSet[str]: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    @typing.overload
    def getToolTipText(self, mouseEvent: java.awt.event.MouseEvent) -> str: ...
    @typing.overload
    def getToolTipText(self) -> str: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def paint(self, graphics: java.awt.Graphics) -> None: ...
    @typing.overload
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    @typing.overload
    def remove(self, menuComponent: java.awt.MenuComponent) -> None: ...
    @typing.overload
    def remove(self, int: int) -> None: ...
    @typing.overload
    def remove(self, component: java.awt.Component) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class HiddenIconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class ShowingIconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class HighlightLastMoved(VASSAL.build.AbstractConfigurable, Drawable, java.awt.event.MouseListener, VASSAL.build.module.GameComponent):
    ENABLED: typing.ClassVar[str] = ...
    COLOR: typing.ClassVar[str] = ...
    THICKNESS: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    def drawAboveCounters(self) -> bool: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    @staticmethod
    def setLastMoved(gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def setLastMovedPiece(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def setup(self, boolean: bool) -> None: ...

class KeyBufferer(java.awt.event.MouseAdapter, VASSAL.build.Buildable, java.awt.event.MouseMotionListener, Drawable):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def dragStarted(self) -> None: ...
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    def drawAboveCounters(self) -> bool: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def isLasso(self) -> bool: ...
    def mouseDragged(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseMoved(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    class KBDeckVisitor(VASSAL.counters.DeckVisitor):
        def __init__(self, keyBufferer: 'KeyBufferer', boolean: bool, boolean2: bool, rectangle: java.awt.Rectangle): ...
        def visitDeck(self, deck: VASSAL.counters.Deck) -> typing.Any: ...
        def visitDefault(self, gamePiece: VASSAL.counters.GamePiece) -> typing.Any: ...
        def visitStack(self, stack: VASSAL.counters.Stack) -> typing.Any: ...

class LOS_Thread(VASSAL.build.AbstractToolbarItem, java.awt.event.MouseListener, java.awt.event.MouseMotionListener, Drawable, VASSAL.build.Configurable, VASSAL.tools.UniqueIdManager.Identifyable, VASSAL.command.CommandEncoder):
    LOS_THREAD_COMMAND: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    ICON_NAME: typing.ClassVar[str] = ...
    LABEL: typing.ClassVar[str] = ...
    SNAP_LOS: typing.ClassVar[str] = ...
    SNAP_START: typing.ClassVar[str] = ...
    SNAP_END: typing.ClassVar[str] = ...
    REPORT: typing.ClassVar[str] = ...
    PERSISTENCE: typing.ClassVar[str] = ...
    PERSISTENT_ICON_NAME: typing.ClassVar[str] = ...
    GLOBAL: typing.ClassVar[str] = ...
    LOS_COLOR: typing.ClassVar[str] = ...
    DRAW_RANGE: typing.ClassVar[str] = ...
    HIDE_COUNTERS: typing.ClassVar[str] = ...
    HIDE_OPACITY: typing.ClassVar[str] = ...
    RANGE_BACKGROUND: typing.ClassVar[str] = ...
    RANGE_FOREGROUND: typing.ClassVar[str] = ...
    RANGE_SCALE: typing.ClassVar[str] = ...
    RANGE_ROUNDING: typing.ClassVar[str] = ...
    ROUND_UP: typing.ClassVar[str] = ...
    ROUND_DOWN: typing.ClassVar[str] = ...
    ROUND_OFF: typing.ClassVar[str] = ...
    RANGE_FONT: typing.ClassVar[java.awt.Font] = ...
    DEFAULT_ICON: typing.ClassVar[str] = ...
    FROM_LOCATION: typing.ClassVar[str] = ...
    TO_LOCATION: typing.ClassVar[str] = ...
    CHECK_COUNT: typing.ClassVar[str] = ...
    CHECK_LIST: typing.ClassVar[str] = ...
    RANGE: typing.ClassVar[str] = ...
    NEVER: typing.ClassVar[str] = ...
    ALWAYS: typing.ClassVar[str] = ...
    CTRL_CLICK: typing.ClassVar[str] = ...
    WHEN_PERSISTENT: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    def drawAboveCounters(self) -> bool: ...
    def drawRange(self, graphics: java.awt.Graphics, int: int) -> None: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getConfigureComponents(self) -> typing.List[VASSAL.build.Configurable]: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    def getState(self) -> str: ...
    def isVisible(self) -> bool: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseDragged(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseMoved(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def reset(self) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setId(self, string: str) -> None: ...
    def setState(self, string: str) -> None: ...
    def setVisible(self, boolean: bool) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class GlobalOptions(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class LOSCommand(VASSAL.command.Command):
        @typing.overload
        def __init__(self, lOS_Thread: 'LOS_Thread'): ...
        @typing.overload
        def __init__(self, lOS_Thread: 'LOS_Thread', point: java.awt.Point, point2: java.awt.Point, boolean: bool, boolean2: bool): ...
    class PersistenceOptions(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class ReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class RoundingOptions(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class MapShader(VASSAL.build.AbstractToolbarItem, VASSAL.build.module.GameComponent, Drawable, VASSAL.tools.UniqueIdManager.Identifyable):
    NAME: typing.ClassVar[str] = ...
    HOT_KEY: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    ALWAYS_ON: typing.ClassVar[str] = ...
    STARTS_ON: typing.ClassVar[str] = ...
    BOARDS: typing.ClassVar[str] = ...
    BOARD_LIST: typing.ClassVar[str] = ...
    ALL_BOARDS: typing.ClassVar[str] = ...
    EXC_BOARDS: typing.ClassVar[str] = ...
    INC_BOARDS: typing.ClassVar[str] = ...
    TYPE: typing.ClassVar[str] = ...
    DRAW_OVER: typing.ClassVar[str] = ...
    PATTERN: typing.ClassVar[str] = ...
    COLOR: typing.ClassVar[str] = ...
    IMAGE: typing.ClassVar[str] = ...
    SCALE_IMAGE: typing.ClassVar[str] = ...
    OPACITY: typing.ClassVar[str] = ...
    BORDER: typing.ClassVar[str] = ...
    BORDER_COLOR: typing.ClassVar[str] = ...
    BORDER_WIDTH: typing.ClassVar[str] = ...
    BORDER_OPACITY: typing.ClassVar[str] = ...
    BG_TYPE: typing.ClassVar[str] = ...
    FG_TYPE: typing.ClassVar[str] = ...
    TYPE_25_PERCENT: typing.ClassVar[str] = ...
    TYPE_50_PERCENT: typing.ClassVar[str] = ...
    TYPE_75_PERCENT: typing.ClassVar[str] = ...
    TYPE_SOLID: typing.ClassVar[str] = ...
    TYPE_IMAGE: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def draw(self, graphics: java.awt.Graphics, map: VASSAL.build.module.Map) -> None: ...
    def drawAboveCounters(self) -> bool: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getBoardClip(self) -> java.awt.geom.Area: ...
    def getBorderColor(self) -> java.awt.Color: ...
    def getColor(self) -> java.awt.Color: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def reset(self) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setId(self, string: str) -> None: ...
    def setLaunchButtonVisibility(self) -> None: ...
    def setShadingVisibility(self, boolean: bool) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class BoardPrompt(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class PatternPrompt(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class ShadedPiece:
        def getArea(self, mapShader: 'MapShader') -> java.awt.geom.Area: ...
    class TypePrompt(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class SimplePieceCollection(PieceCollection):
    def __init__(self): ...
    def add(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def canMerge(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece) -> bool: ...
    def clear(self) -> None: ...
    def getAllPieces(self) -> typing.List[VASSAL.counters.GamePiece]: ...
    def getPieces(self) -> typing.List[VASSAL.counters.GamePiece]: ...
    def indexOf(self, gamePiece: VASSAL.counters.GamePiece) -> int: ...
    def moveToBack(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def moveToFront(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def remove(self, gamePiece: VASSAL.counters.GamePiece) -> None: ...
    def reposition(self, gamePiece: VASSAL.counters.GamePiece, int: int) -> None: ...

class DefaultPieceCollection(CompoundPieceCollection):
    def __init__(self): ...
    def getLayerForPiece(self, gamePiece: VASSAL.counters.GamePiece) -> int: ...

class LayeredPieceCollection(VASSAL.build.AbstractConfigurable):
    PROPERTY_NAME: typing.ClassVar[str] = ...
    LAYER_ORDER: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getMap(self) -> VASSAL.build.module.Map: ...
    def getPieceCollection(self) -> CompoundPieceCollection: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def getToolBar(self) -> javax.swing.JToolBar: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class Collection(CompoundPieceCollection, VASSAL.counters.DeckVisitor):
        def __init__(self, string: str, stringArray: typing.List[str]): ...
        def getLayerForName(self, string: str) -> int: ...
        def getLayerForPiece(self, gamePiece: VASSAL.counters.GamePiece) -> int: ...
        def getLayerNameForPiece(self, gamePiece: VASSAL.counters.GamePiece) -> str: ...
        def getLayerOrder(self) -> typing.List[str]: ...
        def getPropertyName(self) -> str: ...
        def setLayerOrder(self, stringArray: typing.List[str]) -> None: ...
        def setPropertyName(self, string: str) -> None: ...
        def visitDeck(self, deck: VASSAL.counters.Deck) -> typing.Any: ...
        def visitDefault(self, gamePiece: VASSAL.counters.GamePiece) -> typing.Any: ...
        def visitStack(self, stack: VASSAL.counters.Stack) -> typing.Any: ...

class MovementReporter:
    def __init__(self, command: VASSAL.command.Command): ...
    def getReportCommand(self) -> VASSAL.command.Command: ...
    def markMoved(self, gamePiece: VASSAL.counters.GamePiece) -> VASSAL.command.Command: ...
    def markMovedPieces(self) -> VASSAL.command.Command: ...
    class HiddenMoveSummary(VASSAL.build.module.map.MovementReporter.MoveSummary):
        @typing.overload
        def __init__(self, addPiece: VASSAL.command.AddPiece): ...
        @typing.overload
        def __init__(self, movePiece: VASSAL.command.MovePiece): ...
        def getPieceName(self) -> str: ...
    class HiddenMovementReporter(VASSAL.build.module.map.MovementReporter):
        def __init__(self, command: VASSAL.command.Command): ...
    class MoveSummary:
        @typing.overload
        def __init__(self, addPiece: VASSAL.command.AddPiece): ...
        @typing.overload
        def __init__(self, movePiece: VASSAL.command.MovePiece): ...
        def append(self, movePiece: VASSAL.command.MovePiece) -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        def getNewMapId(self) -> str: ...
        def getNewPosition(self) -> java.awt.Point: ...
        def getOldMapId(self) -> str: ...
        def getOldPosition(self) -> java.awt.Point: ...
        def getPieceName(self) -> str: ...
        def hashCode(self) -> int: ...

class PieceMover(VASSAL.build.AbstractBuildable, java.awt.event.MouseListener, java.awt.event.MouseMotionListener, VASSAL.build.module.GameComponent, java.util.Comparator[VASSAL.counters.GamePiece]):
    AUTO_REPORT: typing.ClassVar[str] = ...
    NAME: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    ICON_NAME: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def compare(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece) -> int: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBreachedThreshold(self) -> bool: ...
    def getRestoreCommand(self) -> VASSAL.command.Command: ...
    def isClick(self, point: java.awt.Point) -> bool: ...
    def markMoved(self, gamePiece: VASSAL.counters.GamePiece, boolean: bool) -> VASSAL.command.Command: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseDragged(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseMoved(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def movePieces(self, map: VASSAL.build.module.Map, point: java.awt.Point) -> VASSAL.command.Command: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setBreachedThreshold(self, boolean: bool) -> None: ...
    def setCurPieceOffset(self, int: int, int2: int) -> None: ...
    def setup(self, boolean: bool) -> None: ...
    class AbstractDragHandler(java.awt.dnd.DragGestureListener, java.awt.dnd.DragSourceListener, java.awt.dnd.DragSourceMotionListener, java.awt.dnd.DropTargetListener):
        def __init__(self): ...
        def dragDropEnd(self, dragSourceDropEvent: java.awt.dnd.DragSourceDropEvent) -> None: ...
        @typing.overload
        def dragEnter(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        @typing.overload
        def dragEnter(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
        @typing.overload
        def dragExit(self, dragSourceEvent: java.awt.dnd.DragSourceEvent) -> None: ...
        @typing.overload
        def dragExit(self, dropTargetEvent: java.awt.dnd.DropTargetEvent) -> None: ...
        def dragGestureRecognized(self, dragGestureEvent: java.awt.dnd.DragGestureEvent) -> None: ...
        def dragMouseMoved(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        @typing.overload
        def dragOver(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        @typing.overload
        def dragOver(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
        def drop(self, dropTargetDropEvent: java.awt.dnd.DropTargetDropEvent) -> None: ...
        @typing.overload
        def dropActionChanged(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        @typing.overload
        def dropActionChanged(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
        @staticmethod
        def getTheDragHandler() -> 'PieceMover.AbstractDragHandler': ...
        @staticmethod
        def makeDropTarget(component: java.awt.Component, int: int, dropTargetListener: java.awt.dnd.DropTargetListener) -> java.awt.dnd.DropTarget: ...
        @staticmethod
        def removeDropTarget(component: java.awt.Component) -> None: ...
        @staticmethod
        def resetDragHandler() -> None: ...
        @staticmethod
        def resetRecursivePieceSlots(abstractBuildable: VASSAL.build.AbstractBuildable) -> None: ...
        def setDrawWinToOwnerOf(self, component: java.awt.Component) -> None: ...
        @staticmethod
        def setTheDragHandler(abstractDragHandler: 'PieceMover.AbstractDragHandler') -> None: ...
        class AbstractDragHandlerFactory:
            def __init__(self): ...
            @staticmethod
            def getCorrectDragHandler() -> 'PieceMover.AbstractDragHandler': ...
    class DragHandler(VASSAL.build.module.map.PieceMover.AbstractDragHandler):
        def __init__(self): ...
        def dragGestureRecognized(self, dragGestureEvent: java.awt.dnd.DragGestureEvent) -> None: ...
        def dragMouseMoved(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
    class DragHandlerMacOSX(VASSAL.build.module.map.PieceMover.DragHandler):
        def __init__(self): ...
    class DragHandlerNoImage(VASSAL.build.module.map.PieceMover.AbstractDragHandler):
        def __init__(self): ...
        def dragDropEnd(self, dragSourceDropEvent: java.awt.dnd.DragSourceDropEvent) -> None: ...
        @typing.overload
        def dragEnter(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        @typing.overload
        def dragEnter(self, dropTargetDragEvent: java.awt.dnd.DropTargetDragEvent) -> None: ...
        def dragGestureRecognized(self, dragGestureEvent: java.awt.dnd.DragGestureEvent) -> None: ...
        def dragMouseMoved(self, dragSourceDragEvent: java.awt.dnd.DragSourceDragEvent) -> None: ...
        def drop(self, dropTargetDropEvent: java.awt.dnd.DropTargetDropEvent) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build.module.map")``.

    BoardPicker: typing.Type[BoardPicker]
    CompoundPieceCollection: typing.Type[CompoundPieceCollection]
    CounterDetailViewer: typing.Type[CounterDetailViewer]
    DeckGlobalKeyCommand: typing.Type[DeckGlobalKeyCommand]
    DefaultPieceCollection: typing.Type[DefaultPieceCollection]
    DrawPile: typing.Type[DrawPile]
    Drawable: typing.Type[Drawable]
    Flare: typing.Type[Flare]
    ForwardToChatter: typing.Type[ForwardToChatter]
    ForwardToKeyBuffer: typing.Type[ForwardToKeyBuffer]
    GlobalMap: typing.Type[GlobalMap]
    HandMetrics: typing.Type[HandMetrics]
    HidePiecesButton: typing.Type[HidePiecesButton]
    HighlightLastMoved: typing.Type[HighlightLastMoved]
    ImageSaver: typing.Type[ImageSaver]
    KeyBufferer: typing.Type[KeyBufferer]
    LOS_Thread: typing.Type[LOS_Thread]
    LayerControl: typing.Type[LayerControl]
    LayeredPieceCollection: typing.Type[LayeredPieceCollection]
    MapCenterer: typing.Type[MapCenterer]
    MapShader: typing.Type[MapShader]
    MassKeyCommand: typing.Type[MassKeyCommand]
    MenuDisplayer: typing.Type[MenuDisplayer]
    MovementReporter: typing.Type[MovementReporter]
    PieceCollection: typing.Type[PieceCollection]
    PieceMover: typing.Type[PieceMover]
    PieceRecenterer: typing.Type[PieceRecenterer]
    Scroller: typing.Type[Scroller]
    SelectionHighlighter: typing.Type[SelectionHighlighter]
    SelectionHighlighters: typing.Type[SelectionHighlighters]
    SetupStack: typing.Type[SetupStack]
    SimplePieceCollection: typing.Type[SimplePieceCollection]
    SmallList: typing.Type[SmallList]
    StackExpander: typing.Type[StackExpander]
    StackMetrics: typing.Type[StackMetrics]
    TextSaver: typing.Type[TextSaver]
    Zoomer: typing.Type[Zoomer]
    boardPicker: VASSAL.build.module.map.boardPicker.__module_protocol__
    deck: VASSAL.build.module.map.deck.__module_protocol__
