import VASSAL.build
import VASSAL.build.module.documentation
import VASSAL.configure
import VASSAL.tools
import java.awt
import java.awt.event
import java.awt.image
import java.lang
import java.util
import javax.swing
import javax.swing.table
import org.w3c.dom
import typing



class ColorManager(VASSAL.build.AbstractConfigurable):
    DEFAULT_COLOR: typing.ClassVar[java.awt.Color] = ...
    SELECT_COLOR: typing.ClassVar[str] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getColorByName(self, string: str) -> java.awt.Color: ...
    def getColorDisplayNames(self) -> typing.List[str]: ...
    @staticmethod
    def getColorManager() -> 'ColorManager': ...
    def getColorNames(self) -> typing.List[str]: ...
    @typing.overload
    def getColorSwatch(self, color: java.awt.Color) -> 'ColorSwatch': ...
    @typing.overload
    def getColorSwatch(self, string: str) -> 'ColorSwatch': ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class ColorSwatch(VASSAL.build.AbstractConfigurable, java.lang.Comparable['ColorSwatch']):
    BLACK: typing.ClassVar[str] = ...
    WHITE: typing.ClassVar[str] = ...
    CLEAR: typing.ClassVar[str] = ...
    RED: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, color: java.awt.Color): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def compareTo(self, colorSwatch: 'ColorSwatch') -> int: ...
    def decode(self, string: str) -> None: ...
    def encode(self) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getBlack() -> 'ColorSwatch': ...
    @staticmethod
    def getClear() -> 'ColorSwatch': ...
    def getColor(self) -> java.awt.Color: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    @staticmethod
    def getDefaultSwatch() -> 'ColorSwatch': ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    @staticmethod
    def getRed() -> 'ColorSwatch': ...
    @staticmethod
    def getWhite() -> 'ColorSwatch': ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setColor(self, color: java.awt.Color) -> None: ...

class ColorSwatchConfigurer(VASSAL.configure.Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, colorSwatch: ColorSwatch): ...
    @typing.overload
    def __init__(self, string: str, string2: str, color: java.awt.Color): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @staticmethod
    def decode(string: str) -> ColorSwatch: ...
    @staticmethod
    def encode(colorSwatch: ColorSwatch) -> str: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueColor(self) -> java.awt.Color: ...
    def getValueColorSwatch(self) -> ColorSwatch: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...

class FontConfigurer(VASSAL.configure.Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, fontStyle: 'FontStyle'): ...
    @typing.overload
    def __init__(self, string: str, string2: str, outlineFont: 'OutlineFont'): ...
    @staticmethod
    def decode(string: str) -> 'OutlineFont': ...
    @staticmethod
    def encode(outlineFont: 'OutlineFont') -> str: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def isBold(self) -> bool: ...
    def isItalic(self) -> bool: ...
    def isOutline(self) -> bool: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...

class FontManager(VASSAL.build.AbstractConfigurable):
    DIALOG: typing.ClassVar[str] = ...
    SERIF: typing.ClassVar[str] = ...
    SANS_SERIF: typing.ClassVar[str] = ...
    DIALOG_INPUT: typing.ClassVar[str] = ...
    MONOSPACED: typing.ClassVar[str] = ...
    DEFAULT: typing.ClassVar[str] = ...
    DEFAULT_FONT: typing.ClassVar['OutlineFont'] = ...
    DEFAULT_STYLE: typing.ClassVar['FontStyle'] = ...
    ALLOWABLE_FONTS: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    @staticmethod
    def getFontManager() -> 'FontManager': ...
    def getFontNames(self) -> typing.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class FontStyle(VASSAL.build.AbstractConfigurable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, outlineFont: 'OutlineFont'): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getFont(self) -> 'OutlineFont': ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def isOutline(self) -> bool: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class FontStyleConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class FontStyleConfigurer(VASSAL.configure.Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, fontStyle: FontStyle): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @staticmethod
    def decode(string: str) -> FontStyle: ...
    @staticmethod
    def encode(fontStyle: FontStyle) -> str: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueFont(self) -> java.awt.Font: ...
    def getValueFontStyle(self) -> FontStyle: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...

class GamePieceImageDefinitions(VASSAL.build.AbstractConfigurable):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getGenericDefn(self, string: str) -> 'GamePieceImage': ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    @staticmethod
    def getInstance() -> 'GamePieceImageDefinitions': ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class GamePieceLayoutsContainer(VASSAL.build.AbstractConfigurable):
    def __init__(self): ...
    def add(self, buildable: VASSAL.build.Buildable) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getGenericDefn(self, string: str) -> 'GamePieceImage': ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def remove(self, buildable: VASSAL.build.Buildable) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class InstanceConfigurer(VASSAL.configure.Configurer):
    @staticmethod
    def PropertiesToString(list: java.util.List['ItemInstance']) -> str: ...
    @staticmethod
    def StringToProperties(string: str, gamePieceImage: 'GamePieceImage') -> java.util.List['ItemInstance']: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueList(self) -> java.util.List['ItemInstance']: ...
    def getValueString(self) -> str: ...
    def rebuildViz(self) -> None: ...
    def refresh(self) -> None: ...
    def repack(self) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...

class Item(VASSAL.build.AbstractConfigurable):
    TYPE: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePieceLayout: 'GamePieceLayout'): ...
    @typing.overload
    def __init__(self, string: str): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    @staticmethod
    def decode(gamePieceLayout: 'GamePieceLayout', string: str) -> 'Item': ...
    def draw(self, graphics: java.awt.Graphics, gamePieceImage: 'GamePieceImage') -> None: ...
    def encode(self) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getDisplayLocation(self) -> str: ...
    def getDisplayName(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getLocation(self) -> str: ...
    def getRotation(self) -> int: ...
    def getSize(self) -> java.awt.Dimension: ...
    def getType(self) -> str: ...
    def getXoffset(self) -> int: ...
    def getYoffset(self) -> int: ...
    def isAntialias(self) -> bool: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class LocationConfig(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class ItemInstance(VASSAL.build.AbstractConfigurable):
    FG_COLOR: typing.ClassVar[str] = ...
    BG_COLOR: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePieceImage: 'GamePieceImage'): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def encode(self) -> str: ...
    def formatName(self, string: str) -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBgColor(self) -> ColorSwatch: ...
    def getDisplayLocation(self) -> str: ...
    def getFgColor(self) -> ColorSwatch: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getItem(self) -> Item: ...
    def getLocation(self) -> str: ...
    def getName(self) -> str: ...
    def getSuffix(self) -> str: ...
    def getType(self) -> str: ...
    @staticmethod
    def newDefaultInstance(string: str, string2: str, string3: str) -> 'ItemInstance': ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setBgColor(self, colorSwatch: ColorSwatch) -> None: ...
    def setConfig(self, instanceConfigurer: InstanceConfigurer) -> None: ...
    def setFgColor(self, colorSwatch: ColorSwatch) -> None: ...
    def setLocation(self, string: str) -> None: ...
    def setName(self, string: str) -> None: ...
    def setType(self, string: str) -> None: ...

class LayoutConfigurer(VASSAL.configure.Configurer):
    def getControls(self) -> java.awt.Component: ...
    def getValue(self) -> typing.Any: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...

class NewColorConfigurer(VASSAL.configure.Configurer):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, color: java.awt.Color): ...
    @staticmethod
    def colorToString(color: java.awt.Color) -> str: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...
    @staticmethod
    def stringToColor(string: str) -> java.awt.Color: ...

class OutlineFont(java.awt.Font):
    @typing.overload
    def __init__(self, string: str, int: int, int2: int): ...
    @typing.overload
    def __init__(self, string: str, int: int, int2: int, boolean: bool): ...
    def isOutline(self) -> bool: ...

class StringEnumConfigurer(VASSAL.configure.Configurer):
    def __init__(self, string: str, string2: str, stringArray: typing.List[str]): ...
    def getComboBox(self) -> javax.swing.JComboBox[str]: ...
    def getControls(self) -> java.awt.Component: ...
    def getValidValues(self) -> typing.List[str]: ...
    def getValueString(self) -> str: ...
    def isValidValue(self, object: typing.Any) -> bool: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    def setValidValues(self, stringArray: typing.List[str]) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class SwatchComboBox(javax.swing.JComboBox[str]):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, itemListener: java.awt.event.ItemListener): ...
    @typing.overload
    def __init__(self, itemListener: java.awt.event.ItemListener, string: str): ...
    class SwatchRenderer(javax.swing.JLabel, javax.swing.ListCellRenderer[str]):
        def __init__(self, swatchComboBox: 'SwatchComboBox'): ...
        def getListCellRendererComponent(self, jList: javax.swing.JList[str], string: str, int: int, boolean: bool, boolean2: bool) -> java.awt.Component: ...
    class SwatchTableRenderer(javax.swing.JLabel, javax.swing.table.TableCellRenderer):
        def __init__(self, swatchComboBox: 'SwatchComboBox'): ...
        def getTableCellRendererComponent(self, jTable: javax.swing.JTable, object: typing.Any, boolean: bool, boolean2: bool, int: int, int2: int) -> java.awt.Component: ...

class Symbol:
    def __init__(self, string: str, string2: str, string3: str, string4: str): ...
    def draw(self, graphics: java.awt.Graphics, rectangle: java.awt.Rectangle, color: java.awt.Color, color2: java.awt.Color, color3: java.awt.Color, float: float) -> None: ...
    class NatoUnitSymbolSet:
        SIZES: typing.ClassVar[typing.List['Symbol.SizeOption']] = ...
        def __init__(self): ...
        @typing.overload
        @staticmethod
        def buildSizeImage(graphics: java.awt.Graphics, int: int, string: str, int2: int, int3: int, int4: int) -> java.awt.image.BufferedImage: ...
        @typing.overload
        @staticmethod
        def buildSizeImage(string: str, int: int, int2: int, int3: int) -> java.awt.image.BufferedImage: ...
    class SizeOption:
        def __init__(self, string: str, string2: str, int: int, string3: str): ...
        def getCount(self) -> int: ...
        def getDisplayName(self) -> str: ...
        def getName(self) -> str: ...
        def getType(self) -> str: ...

class Visualizable:
    def getVisualizerHeight(self) -> int: ...
    def getVisualizerImage(self) -> java.awt.Image: ...
    def getVisualizerWidth(self) -> int: ...
    def rebuildVisualizerImage(self) -> None: ...

class Visualizer(javax.swing.JPanel):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, visualizable: Visualizable): ...
    def rebuild(self) -> None: ...
    def refresh(self) -> None: ...
    def setObserver(self, visualizable: Visualizable) -> None: ...

class GamePieceImage(VASSAL.build.AbstractConfigurable, Visualizable, java.lang.Cloneable, VASSAL.tools.UniqueIdManager.Identifyable):
    PART_SIZE: typing.ClassVar[str] = ...
    PART_SYMBOL1: typing.ClassVar[str] = ...
    PART_SYMBOL2: typing.ClassVar[str] = ...
    BG_COLOR: typing.ClassVar[str] = ...
    BORDER_COLOR: typing.ClassVar[str] = ...
    VERSION: typing.ClassVar[str] = ...
    VERSION_0: typing.ClassVar[str] = ...
    VERSION_1: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePieceImage: 'GamePieceImage'): ...
    @typing.overload
    def __init__(self, gamePieceLayout: 'GamePieceLayout'): ...
    @typing.overload
    def __init__(self, string: str): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def clone(self) -> typing.Any: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getBgColor(self) -> ColorSwatch: ...
    def getBorderColor(self) -> ColorSwatch: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getEncodedImage(self, bufferedImage: java.awt.image.BufferedImage) -> typing.List[int]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getId(self) -> str: ...
    def getImageInstance(self, string: str) -> 'ImageItemInstance': ...
    def getInstance(self, string: str) -> ItemInstance: ...
    def getInstances(self) -> java.util.List[ItemInstance]: ...
    def getLayout(self) -> 'GamePieceLayout': ...
    def getShapeInstance(self, string: str) -> 'ShapeItemInstance': ...
    def getSymbolInstance(self, string: str) -> 'SymbolItemInstance': ...
    def getTextBoxInstance(self, string: str) -> 'TextBoxItemInstance': ...
    def getTextInstance(self, string: str) -> 'TextItemInstance': ...
    def getVersion(self) -> str: ...
    def getVisualizerHeight(self) -> int: ...
    def getVisualizerImage(self) -> java.awt.Image: ...
    def getVisualizerWidth(self) -> int: ...
    def isVersion1(self) -> bool: ...
    def rebuildVisualizerImage(self) -> None: ...
    def refreshConfig(self) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setId(self, string: str) -> None: ...
    class BgColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class BorderColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class DefnConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
        @staticmethod
        def refresh() -> None: ...
    class ImageNameConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class GamePieceLayout(VASSAL.build.AbstractConfigurable, Visualizable):
    LOCATIONS: typing.ClassVar[typing.List[str]] = ...
    LOCATION_I18N_KEYS: typing.ClassVar[typing.List[str]] = ...
    X_POS: typing.ClassVar[typing.List[int]] = ...
    Y_POS: typing.ClassVar[typing.List[int]] = ...
    def __init__(self): ...
    def addItem(self, item: Item) -> None: ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def buildImage(self, gamePieceImage: GamePieceImage) -> java.awt.Image: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBorder(self) -> str: ...
    @staticmethod
    def getCompassPoint(string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    @staticmethod
    def getDisplayLocation(string: str) -> str: ...
    def getGenericDefn(self, string: str) -> GamePieceImage: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getItems(self) -> java.util.List[Item]: ...
    def getLayoutHeight(self) -> int: ...
    def getLayoutWidth(self) -> int: ...
    def getPosition(self, item: Item) -> java.awt.Point: ...
    def getVisualizerHeight(self) -> int: ...
    def getVisualizerImage(self) -> java.awt.Image: ...
    def getVisualizerWidth(self) -> int: ...
    def isColoredBorder(self) -> bool: ...
    def moveItem(self, int: int, int2: int) -> None: ...
    def rebuildVisualizerImage(self) -> None: ...
    def refresh(self) -> None: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setHeight(self, int: int) -> None: ...
    def setImageDefn(self, gamePieceImage: GamePieceImage) -> None: ...
    def setWidth(self, int: int) -> None: ...
    class BorderConfig(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
    class LayoutConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
        @staticmethod
        def refresh() -> None: ...

class ImageItem(Item):
    TYPE: typing.ClassVar[str] = ...
    SRC_VARIABLE: typing.ClassVar[str] = ...
    SRC_FIXED: typing.ClassVar[str] = ...
    SOURCE: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout, string: str): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    @staticmethod
    def decode(gamePieceLayout: GamePieceLayout, string: str) -> Item: ...
    def draw(self, graphics: java.awt.Graphics, gamePieceImage: GamePieceImage) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getDisplayName(self) -> str: ...
    def getSize(self) -> java.awt.Dimension: ...
    def getType(self) -> str: ...
    def isFixed(self) -> bool: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class TextSource(VASSAL.configure.StringEnum):
        def __init__(self): ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class ImageItemInstance(ItemInstance):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePieceImage: GamePieceImage): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str): ...
    def decode(self, string: str) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getImageName(self) -> str: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class ShapeItem(Item):
    TYPE: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout, string: str): ...
    @staticmethod
    def decode(gamePieceLayout: GamePieceLayout, string: str) -> Item: ...
    def draw(self, graphics: java.awt.Graphics, gamePieceImage: GamePieceImage) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getDisplayName(self) -> str: ...
    def getHeight(self) -> int: ...
    def getSize(self) -> java.awt.Dimension: ...
    def getType(self) -> str: ...
    def getWidth(self) -> int: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class ShapeConfig(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class ShapeItemInstance(ItemInstance):
    BORDER_COLOR: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePieceImage: GamePieceImage): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    def decode(self, string: str) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class BorderColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class FgColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class SizeConfigurer(StringEnumConfigurer):
    def __init__(self, string: str, string2: str): ...
    def getComboBox(self) -> javax.swing.JComboBox: ...
    class SizeComboBox(javax.swing.JComboBox):
        @typing.overload
        def __init__(self, sizeConfigurer: 'SizeConfigurer'): ...
        @typing.overload
        def __init__(self, sizeConfigurer: 'SizeConfigurer', itemListener: java.awt.event.ItemListener): ...
        @typing.overload
        def __init__(self, sizeConfigurer: 'SizeConfigurer', itemListener: java.awt.event.ItemListener, string: str): ...
        class SizeRenderer(javax.swing.JLabel, javax.swing.ListCellRenderer):
            def __init__(self, sizeComboBox: 'SizeConfigurer.SizeComboBox'): ...
            def getListCellRendererComponent(self, jList: javax.swing.JList, object: typing.Any, int: int, boolean: bool, boolean2: bool) -> java.awt.Component: ...

class SymbolConfigurer(StringEnumConfigurer):
    def __init__(self, string: str, string2: str): ...
    def getComboBox(self) -> javax.swing.JComboBox: ...
    class SymbolComboBox(javax.swing.JComboBox):
        @typing.overload
        def __init__(self, symbolConfigurer: 'SymbolConfigurer'): ...
        @typing.overload
        def __init__(self, symbolConfigurer: 'SymbolConfigurer', itemListener: java.awt.event.ItemListener): ...
        @typing.overload
        def __init__(self, symbolConfigurer: 'SymbolConfigurer', itemListener: java.awt.event.ItemListener, string: str): ...
        class SymbolRenderer(javax.swing.JLabel, javax.swing.ListCellRenderer):
            def __init__(self, symbolComboBox: 'SymbolConfigurer.SymbolComboBox'): ...
            def getListCellRendererComponent(self, jList: javax.swing.JList, object: typing.Any, int: int, boolean: bool, boolean2: bool) -> java.awt.Component: ...

class SymbolItem(Item):
    TYPE: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout, string: str): ...
    @staticmethod
    def decode(gamePieceLayout: GamePieceLayout, string: str) -> Item: ...
    def draw(self, graphics: java.awt.Graphics, gamePieceImage: GamePieceImage) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getDisplayName(self) -> str: ...
    def getHeight(self) -> int: ...
    def getSize(self) -> java.awt.Dimension: ...
    def getType(self) -> str: ...
    def getWidth(self) -> int: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class SetConfig(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class SymbolItemInstance(ItemInstance):
    SIZE: typing.ClassVar[str] = ...
    SIZE_COLOR: typing.ClassVar[str] = ...
    SYMBOL1: typing.ClassVar[str] = ...
    SYMBOL2: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePieceImage: GamePieceImage): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str, string5: str, string6: str): ...
    def decode(self, string: str) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getSize(self) -> str: ...
    def getSymbol1(self) -> str: ...
    def getSymbol2(self) -> str: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setSize(self, string: str) -> None: ...
    def setSymbol1(self, string: str) -> None: ...
    def setSymbol2(self, string: str) -> None: ...
    class BgColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class FgColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class SizeColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class SizeConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class Symbol1Config(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class Symbol2Config(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class TextBoxItemInstance(ItemInstance):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePieceImage: GamePieceImage): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    def decode(self, string: str) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getValue(self) -> str: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setValue(self, string: str) -> None: ...
    class BgColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class FgColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class WrappingTextConfigurer(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class TextItem(Item):
    TYPE: typing.ClassVar[str] = ...
    SRC_VARIABLE: typing.ClassVar[str] = ...
    SRC_FIXED: typing.ClassVar[str] = ...
    AL_CENTER: typing.ClassVar[int] = ...
    AL_RIGHT: typing.ClassVar[int] = ...
    AL_LEFT: typing.ClassVar[int] = ...
    AL_TOP: typing.ClassVar[int] = ...
    AL_BOTTOM: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout, string: str): ...
    @typing.overload
    @staticmethod
    def decode(gamePieceLayout: GamePieceLayout, string: str) -> Item: ...
    @typing.overload
    @staticmethod
    def decode(textItem: 'TextItem', string: str) -> None: ...
    def draw(self, graphics: java.awt.Graphics, gamePieceImage: GamePieceImage) -> None: ...
    @staticmethod
    def drawLabel(graphics: java.awt.Graphics, string: str, int: int, int2: int, font: java.awt.Font, int3: int, int4: int, color: java.awt.Color, color2: java.awt.Color, color3: java.awt.Color, boolean: bool, color4: java.awt.Color) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getDisplayName(self) -> str: ...
    def getSize(self) -> java.awt.Dimension: ...
    def getType(self) -> str: ...
    def isFixed(self) -> bool: ...
    def isOutline(self) -> bool: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class FontStyleConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class NameFormatConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class TextSource(VASSAL.configure.TranslatableStringEnum):
        def __init__(self): ...
        def getI18nKeys(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...
        def getValidValues(self, autoConfigurable: VASSAL.build.AutoConfigurable) -> typing.List[str]: ...

class TextItemInstance(ItemInstance):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, gamePieceImage: GamePieceImage): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str): ...
    def decode(self, string: str) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getOutlineColor(self) -> ColorSwatch: ...
    def getValue(self) -> str: ...
    def isOutline(self) -> bool: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setOutlineColor(self, colorSwatch: ColorSwatch) -> None: ...
    def setValue(self, string: str) -> None: ...
    class BgColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class FgColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...
    class OutlineColorSwatchConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class TextBoxItem(TextItem):
    TYPE: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout): ...
    @typing.overload
    def __init__(self, gamePieceLayout: GamePieceLayout, string: str): ...
    @typing.overload
    @staticmethod
    def decode(gamePieceLayout: GamePieceLayout, string: str) -> Item: ...
    @typing.overload
    @staticmethod
    def decode(textItem: TextItem, string: str) -> None: ...
    def draw(self, graphics: java.awt.Graphics, gamePieceImage: GamePieceImage) -> None: ...
    def encode(self) -> str: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getDisplayName(self) -> str: ...
    def getHeight(self) -> int: ...
    def getSize(self) -> java.awt.Dimension: ...
    def getType(self) -> str: ...
    def getWidth(self) -> int: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build.module.gamepieceimage")``.

    ColorManager: typing.Type[ColorManager]
    ColorSwatch: typing.Type[ColorSwatch]
    ColorSwatchConfigurer: typing.Type[ColorSwatchConfigurer]
    FontConfigurer: typing.Type[FontConfigurer]
    FontManager: typing.Type[FontManager]
    FontStyle: typing.Type[FontStyle]
    FontStyleConfigurer: typing.Type[FontStyleConfigurer]
    GamePieceImage: typing.Type[GamePieceImage]
    GamePieceImageDefinitions: typing.Type[GamePieceImageDefinitions]
    GamePieceLayout: typing.Type[GamePieceLayout]
    GamePieceLayoutsContainer: typing.Type[GamePieceLayoutsContainer]
    ImageItem: typing.Type[ImageItem]
    ImageItemInstance: typing.Type[ImageItemInstance]
    InstanceConfigurer: typing.Type[InstanceConfigurer]
    Item: typing.Type[Item]
    ItemInstance: typing.Type[ItemInstance]
    LayoutConfigurer: typing.Type[LayoutConfigurer]
    NewColorConfigurer: typing.Type[NewColorConfigurer]
    OutlineFont: typing.Type[OutlineFont]
    ShapeItem: typing.Type[ShapeItem]
    ShapeItemInstance: typing.Type[ShapeItemInstance]
    SizeConfigurer: typing.Type[SizeConfigurer]
    StringEnumConfigurer: typing.Type[StringEnumConfigurer]
    SwatchComboBox: typing.Type[SwatchComboBox]
    Symbol: typing.Type[Symbol]
    SymbolConfigurer: typing.Type[SymbolConfigurer]
    SymbolItem: typing.Type[SymbolItem]
    SymbolItemInstance: typing.Type[SymbolItemInstance]
    TextBoxItem: typing.Type[TextBoxItem]
    TextBoxItemInstance: typing.Type[TextBoxItemInstance]
    TextItem: typing.Type[TextItem]
    TextItemInstance: typing.Type[TextItemInstance]
    Visualizable: typing.Type[Visualizable]
    Visualizer: typing.Type[Visualizer]
