/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.i18n.Resources;
import VASSAL.tools.swing.EDT;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.EventListenerList;
import net.miginfocom.swing.MigLayout;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected final JLabel label;
    protected final JProgressBar progbar;
    protected final JButton cancel;
    protected final EventListenerList listeners = new EventListenerList();

    public ProgressDialog(Frame parent, String title, String text) {
        super(parent, title, true);
        this.label = new JLabel(text);
        this.progbar = new JProgressBar(0, 100);
        this.progbar.setStringPainted(true);
        this.progbar.setValue(0);
        this.cancel = new JButton(Resources.getString("General.cancel"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressDialog.this.fireCancelledEvent(new ActionEvent(ProgressDialog.this, 1001, "cancel"));
            }
        });
        this.cancel.addActionListener(this::fireCancelledEvent);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("insets dialog, fill", "", "unrelated:push[]related[]unrelated:push[]"));
        panel.add((Component)this.progbar, "growx, wrap");
        panel.add((Component)this.label, "wmin 0, pad 0 0 2pt 0, wrap unrel:push");
        panel.add((Component)this.cancel, "tag cancel");
        this.add(panel);
        this.pack();
        this.setMinimumSize(new Dimension(300, this.getHeight()));
        this.pack();
    }

    protected void fireCancelledEvent(ActionEvent e) {
        Object[] larr = this.listeners.getListenerList();
        for (int i = larr.length - 2; i >= 0; i -= 2) {
            if (larr[i] != ActionListener.class) continue;
            ((ActionListener)larr[i + 1]).actionPerformed(e);
        }
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabel(String text) {
        this.label.setText(text);
    }

    public boolean isIndeterminate() {
        return this.progbar.isIndeterminate();
    }

    public void setIndeterminate(boolean indet) {
        this.progbar.setIndeterminate(indet);
    }

    public int getProgress() {
        return this.progbar.getValue();
    }

    public void setProgress(int percent) {
        this.progbar.setValue(percent);
    }

    public boolean isStringPainted() {
        return this.progbar.isStringPainted();
    }

    public void setStringPainted(boolean painted) {
        this.progbar.setStringPainted(painted);
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listeners.getListeners(ActionListener.class);
    }

    public static ProgressDialog createOnEDT(Frame parent, String title, String text) {
        Future<ProgressDialog> f = EDT.submit(() -> new ProgressDialog(parent, title, text));
        try {
            return f.get();
        }
        catch (InterruptedException | CancellationException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

