/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class FlowLabel
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_WIDTH = 40;

    public FlowLabel(String text) {
        this(text, 40);
    }

    public FlowLabel(String text, int width) {
        this.setEditable(false);
        this.setText(text);
        this.setOpaque(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setFont(UIManager.getFont("Label.font"));
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setBackground(UIManager.getColor("Label.background"));
        StyledDocument doc = this.getStyledDocument();
        SimpleAttributeSet sa = new SimpleAttributeSet();
        StyleConstants.setAlignment(sa, 3);
        doc.setParagraphAttributes(0, doc.getLength(), sa, false);
        int w = width * this.getFont().getSize();
        Dimension d = new Dimension(w, Integer.MAX_VALUE);
        this.setSize(d);
        d.height = this.getPreferredSize().height;
        this.setPreferredSize(d);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FlowLabel.this.setPreferredSize(null);
                FlowLabel.this.removeComponentListener(this);
            }
        });
    }

    @Override
    public void setText(String text) {
        if (BasicHTML.isHTMLString(text)) {
            this.setContentType("text/html");
        }
        super.setText(text);
    }

    public static void main(String[] args) {
        String loremIpsum = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
        JDialog d = new JDialog();
        d.setTitle("Flow Label Test");
        d.setModal(true);
        d.setResizable(true);
        d.setLocationRelativeTo(null);
        d.setDefaultCloseOperation(2);
        d.add(new FlowLabel("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."));
        d.pack();
        d.setVisible(true);
    }
}

