/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.tools.swing.EDTRunnableFuture;
import java.awt.EventQueue;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class EDTExecutorService
extends AbstractExecutorService {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ReentrantLock lock = new ReentrantLock();
    protected final EDTRunnableFuture<Void> poison_pill = new EDTRunnableFuture<Void>(){

        @Override
        protected void runOnEDT() {
        }
    };

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.isTerminated()) {
                boolean bl = true;
                return bl;
            }
            this.poison_pill.get(timeout, unit);
            boolean bl = true;
            return bl;
        }
        catch (TimeoutException e) {
            boolean bl = false;
            return bl;
        }
        catch (CancellationException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown.get() && this.poison_pill.isDone();
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            if (this.shutdown.get()) {
                return;
            }
            this.submit(this.poison_pill);
            this.shutdown.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(final Callable<T> cable) {
        return new EDTRunnableFuture<T>(){

            @Override
            protected void runOnEDT() throws Exception {
                this.result = cable.call();
            }
        };
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(final Runnable rable, T result) {
        return new EDTRunnableFuture<T>(result){

            @Override
            protected void runOnEDT() {
                rable.run();
            }
        };
    }

    public <T> EDTRunnableFuture<T> submit(EDTRunnableFuture<T> task) {
        this.execute(task);
        return task;
    }

    @Override
    public void execute(Runnable r) {
        Objects.requireNonNull(r);
        this.lock.lock();
        try {
            if (this.shutdown.get()) {
                throw new RejectedExecutionException();
            }
            EventQueue.invokeLater(r);
        }
        finally {
            this.lock.unlock();
        }
    }
}

