/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.AbstractProxy;
import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.MenuMarker;
import VASSAL.tools.menu.ParentProxy;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractParent<T extends JComponent>
extends AbstractProxy<T>
implements ParentProxy {
    protected final List<ChildProxy<?>> children = new ArrayList();

    @Override
    public void add(ChildProxy<?> child) {
        this.children.add(child);
        child.setParent(this);
        if (child instanceof MenuMarker) {
            return;
        }
        this.forEachPeer(peer -> peer.add((Component)child.createPeer()));
    }

    protected int proxyIndexToRealIndex(int pos) {
        int j = -1;
        for (int i = 0; i <= pos; ++i) {
            if (this.children.get(i) instanceof MenuMarker) continue;
            ++j;
        }
        return j;
    }

    @Override
    public void insert(ChildProxy<?> child, int pos) {
        this.children.add(pos, child);
        child.setParent(this);
        if (child instanceof MenuMarker) {
            return;
        }
        int rpos = this.proxyIndexToRealIndex(pos);
        this.forEachPeer(peer -> peer.add((Component)child.createPeer(), rpos));
    }

    @Override
    public void remove(ChildProxy<?> child) {
        if (this.children.remove(child)) {
            child.setParent(null);
        }
    }

    @Override
    public void remove(int pos) {
        ChildProxy<?> child = this.children.remove(pos);
        child.setParent(null);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public ChildProxy<?>[] getChildren() {
        return this.children.toArray(new ChildProxy[0]);
    }

    @Override
    public ChildProxy<?> getChild(int pos) {
        return this.children.get(pos);
    }

    @Override
    public int getIndex(ChildProxy<?> child) {
        return this.children.indexOf(child);
    }
}

