/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.concurrent.DaemonThreadFactory;
import VASSAL.tools.io.InputOutputStreamPump;
import VASSAL.tools.io.InputStreamPump;
import VASSAL.tools.io.ProcessCallable;
import VASSAL.tools.io.ProcessWrapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessLauncher {
    private static final Logger logger = LoggerFactory.getLogger(ProcessLauncher.class);
    protected final ExecutorService exec;

    public ProcessLauncher() {
        this(Executors.newCachedThreadPool(new DaemonThreadFactory(ProcessLauncher.class.getSimpleName())));
    }

    ProcessLauncher(ExecutorService exec) {
        this.exec = exec;
    }

    public ProcessWrapper launch(String ... args) throws IOException {
        return this.launch(null, System.out, System.err, args);
    }

    public ProcessWrapper launch(File workDir, OutputStream stdout, OutputStream stderr, String ... args) throws IOException {
        InputOutputStreamPump outP = new InputOutputStreamPump(null, stdout);
        InputOutputStreamPump errP = new InputOutputStreamPump(null, stderr);
        return this.launch(null, outP, errP, args);
    }

    public ProcessWrapper launch(File workDir, InputStreamPump stdoutPump, InputStreamPump stderrPump, String ... args) throws IOException {
        logger.info("launching " + StringUtils.join((Object[])args, (char)' '));
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(workDir);
        Process proc = pb.start();
        ProcessCallable pcall = new ProcessCallable(proc, stdoutPump, stderrPump, this.exec);
        Future<Integer> future = this.exec.submit(pcall);
        return new ProcessWrapper(future, proc.getInputStream(), proc.getErrorStream(), proc.getOutputStream());
    }
}

