/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.concurrent.listener.DummyEventListener;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.io.InputStreamPump;
import VASSAL.tools.io.OutputStreamPump;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputOutputStreamPump
implements InputStreamPump,
OutputStreamPump {
    protected InputStream in;
    protected OutputStream out;
    protected volatile boolean running = false;
    protected final EventListener<IOException> ioexListener;

    public InputOutputStreamPump() {
        this(null, null, new DummyEventListener<IOException>());
    }

    public InputOutputStreamPump(EventListener<IOException> ioexListener) {
        this(null, null, ioexListener);
    }

    public InputOutputStreamPump(InputStream in, OutputStream out) {
        this(in, out, new DummyEventListener<IOException>());
    }

    public InputOutputStreamPump(InputStream in, OutputStream out, EventListener<IOException> ioexListener) {
        this.in = in;
        this.out = out;
        this.ioexListener = ioexListener;
    }

    @Override
    public void setInputStream(InputStream in) {
        if (this.running) {
            throw new UnsupportedOperationException();
        }
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        if (this.running) {
            throw new UnsupportedOperationException();
        }
        this.out = out;
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.in.transferTo(this.out);
        }
        catch (IOException e) {
            this.ioexListener.receive(this, e);
        }
    }
}

