/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ImageOpObserver;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.opcache.OpCache;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractOpImpl
extends VASSAL.tools.opcache.AbstractOpImpl<BufferedImage>
implements ImageOp {
    protected Dimension size;
    protected static final OpCache cache = new OpCache();

    public static void clearCache() {
        cache.clear();
    }

    public AbstractOpImpl() {
        super(cache);
    }

    @Override
    public abstract BufferedImage eval() throws Exception;

    @Override
    public BufferedImage getImage() {
        block3: {
            try {
                return this.getImage(null);
            }
            catch (InterruptedException | CancellationException e) {
                ErrorDialog.bug(e);
            }
            catch (ExecutionException e) {
                if (Op.handleException(e)) break block3;
                ErrorDialog.bug(e);
            }
        }
        return null;
    }

    @Override
    public BufferedImage getImage(ImageOpObserver obs) throws CancellationException, InterruptedException, ExecutionException {
        return this.get(obs);
    }

    @Override
    public Future<BufferedImage> getFutureImage(ImageOpObserver obs) throws ExecutionException {
        return this.getFuture(obs);
    }

    protected Dimension getSizeFromCache() {
        BufferedImage im = (BufferedImage)cache.getIfDone(this.newKey());
        return im == null ? null : new Dimension(im.getWidth(), im.getHeight());
    }

    protected abstract void fixSize();

    @Override
    public Dimension getSize() {
        if (this.size == null) {
            this.fixSize();
        }
        return new Dimension(this.size);
    }

    @Override
    public int getWidth() {
        if (this.size == null) {
            this.fixSize();
        }
        return this.size.width;
    }

    @Override
    public int getHeight() {
        if (this.size == null) {
            this.fixSize();
        }
        return this.size.height;
    }

    @Override
    public abstract Dimension getTileSize();

    @Override
    public abstract int getTileHeight();

    @Override
    public abstract int getTileWidth();

    @Override
    public abstract int getNumXTiles();

    @Override
    public abstract int getNumYTiles();

    @Override
    public BufferedImage getTile(Point p, ImageOpObserver obs) throws CancellationException, InterruptedException, ExecutionException {
        return this.getTile(p.x, p.y, obs);
    }

    @Override
    public abstract BufferedImage getTile(int var1, int var2, ImageOpObserver var3) throws CancellationException, InterruptedException, ExecutionException;

    @Override
    public Future<BufferedImage> getFutureTile(Point p, ImageOpObserver obs) throws ExecutionException {
        return this.getFutureTile(p.x, p.y, obs);
    }

    @Override
    public abstract Future<BufferedImage> getFutureTile(int var1, int var2, ImageOpObserver var3) throws ExecutionException;

    @Override
    public ImageOp getTileOp(Point p) {
        return this.getTileOp(p.x, p.y);
    }

    @Override
    public abstract ImageOp getTileOp(int var1, int var2);

    @Override
    public abstract Point[] getTileIndices(Rectangle var1);
}

